# Bestehendes Projekt importieren:

### Git clone / config

- git clone git@git.tu-medien.de:stephan/table_maker.git
- git config --local remote.origin.tagopt --tags
- git config --local user.name "Stephan Winter"
- git config --local user.email s.winter@riego.cloud
- git config --local core.autocrlf input

### PDM install / config

- Python 3.9 installieren
- Linux: curl -sSL https://pdm.fming.dev/install-pdm.py | python3 -
- Windows: powershell -ExecutionPolicy ByPass -c "irm https://pdm-project.org/install-pdm.py | py -"
- pdm install
- pdm config repository.devpi.url "https://devpi.universalmail.de/riego/dev"
- pdm config repository.devpi.username riego
- pdm config repository.devpi.password <password>
- source .venv/bin/activate
- #.venv\Scripts\activate
- git add .


### Commit
- cz commit

### Bump/Build
- cz bump


### Falls der upload per pdm nicht funktionbiert
devpi use https://devpi.riego.cloud/riego/dev
devpi login riego --password=<password>
devpi upload

### Devpi push to production
devpi push template-python==0.1.0 riego/prod



Auf neuem Rechner
-----------------
- git init
- git config core.autocrlf true
- git config init.defaultBranch main
- git config --local user.name "Stephan Winter"
- git config --local user.email s.winter@riego.cloud

- git remote add origin git@git.tu-medien.de:stephan/demo.git
- git config --local remote.origin.tagopt --tags


- git fetch origin
- git switch -c main origin/main


- rmdir .venv
- (Invoke-WebRequest -Uri https://raw.githubusercontent.com/pdm-project/pdm/main/install-pdm.py -UseBasicParsing).Content | python -

- pdm init -n --skip :all

- pdm add uvloop 

- pdm add -d commitizen devpi-client pytest

- pdm config repository.devpi.url "https://devpi.riego.cloud/riego/prod"
- pdm config repository.devpi.username riego
- pdm config repository.devpi.password <password>
- pdm config request_timeout 100





## Python venv with venv
- rm -rf .venv
- python3 -m venv .venv && source .venv/bin/activate && pip install --upgrade pip
- pip config --site set global.index-url "https://devpi.riego.cloud/riego/dev/+simple/"
- pip config --site set global.timeout 60
- pip install --upgrade table_maker



## Python venv with uv
- rm -rf .venv
- curl -LsSf https://astral.sh/uv/install.sh | sh
- uv venv --python 3.9 && source .venv/bin/activate
- cat > pyproject.toml <<'EOT'
   [[tool.uv.index]]
   url = "https://devpi.riego.cloud/riego/dev/+simple/"
   EOT
- uv pip install --upgrade table_maker
