from pathlib import Path
from importlib import resources
from typing import Union

from spire.doc import *


from table_maker.helper import to_cur
import logging

log = logging.getLogger(__name__)


def make_doc(p: Path, plaza_txt_mtime: float, obj):
    make_doc_arras_de(
        dest_file=p.joinpath("Documentos Plaza/odt/Contrato Arras DE.docx"),
        plaza_txt_mtime=plaza_txt_mtime,
        obj=obj,
    )


def make_doc_arras_de(dest_file: Path, plaza_txt_mtime: float, obj):
    document = Document()

    if dest_file.exists() and dest_file.stat().st_mtime > plaza_txt_mtime:
        return None

    with resources.as_file(
        resources.files("table_maker") / "assets" / "Contrato-de-arras-DE.docx"
    ) as fp:
        document.LoadFromFileInReadMode(fp.as_posix())

    if document is None:
        log.error("document is None")
        return None

    document.Replace("{{c1.sex}}", obj["BUYER1"]["sex"], False, True)
    document.Replace("{{c1.first_name}}", obj["BUYER1"]["first_name"], False, True)
    document.SaveToFile(dest_file, FileFormat.Docx2016)
    document.Close()


"""     document.body.replace(
        "{{c1.last_name}}", config_object.get("BUYER1", "last_name", fallback="")
    )
    document.body.replace(
        "{{c1.nationality}}", config_object.get("BUYER1", "nationality", fallback="")
    )
    document.body.replace(
        "{{c1.town}}", config_object.get("BUYER1", "town", fallback="")
    )
     document.Replace("{{c1.zip}}", config_object.get("BUYER1", "zip", fallback=""))
    document.body.replace(
        "{{c1.street}}", config_object.get("BUYER1", "street", fallback="")
    )
    document.body.replace(
        "{{c1.number}}", config_object.get("BUYER1", "number", fallback="")
    )
    document.body.replace(
        "{{c1.nation}}", config_object.get("BUYER1", "nation", fallback="")
    )
     document.Replace("{{c1.nie}}", config_object.get("BUYER1", "nie", fallback=""))
    document.body.replace(
        "{{c1.idnr}}", config_object.get("BUYER1", "idnr", fallback="")
    )

     document.Replace("{{c2.sex}}", config_object.get("BUYER2", "sex", fallback=""))
    document.body.replace(
        "{{c2.first_name}}", config_object.get("BUYER2", "first_name", fallback="")
    )
    document.body.replace(
        "{{c2.last_name}}", config_object.get("BUYER2", "last_name", fallback="")
    )
    document.body.replace(
        "{{c2.nationality}}", config_object.get("BUYER2", "nationality", fallback="")
    )
    document.body.replace(
        "{{c2.town}}", config_object.get("BUYER2", "town", fallback="")
    )
     document.Replace("{{c2.zip}}", config_object.get("BUYER2", "zip", fallback=""))
    document.body.replace(
        "{{c2.street}}", config_object.get("BUYER2", "street", fallback="")
    )
    document.body.replace(
        "{{c2.number}}", config_object.get("BUYER2", "number", fallback="")
    )
    document.body.replace(
        "{{c2.nation}}", config_object.get("BUYER2", "nation", fallback="")
    )
     document.Replace("{{c2.nie}}", config_object.get("BUYER2", "nie", fallback=""))
    document.body.replace(
        "{{c2.idnr}}", config_object.get("BUYER2", "idnr", fallback="")
    )

     document.Replace("{{v1.sex}}", config_object.get("OWNER1", "sex", fallback=""))
    document.body.replace(
        "{{v1.first_name}}", config_object.get("OWNER1", "first_name", fallback="")
    )
    document.body.replace(
        "{{v1.last_name}}", config_object.get("OWNER1", "last_name", fallback="")
    )
    document.body.replace(
        "{{v1.nationality}}", config_object.get("OWNER1", "nationality", fallback="")
    )
    document.body.replace(
        "{{v1.town}}", config_object.get("OWNER1", "town", fallback="")
    )
     document.Replace("{{v1.zip}}", config_object.get("OWNER1", "zip", fallback=""))
    document.body.replace(
        "{{v1.street}}", config_object.get("OWNER1", "street", fallback="")
    )
    document.body.replace(
        "{{v1.number}}", config_object.get("OWNER1", "number", fallback="")
    )
    document.body.replace(
        "{{v1.nation}}", config_object.get("OWNER1", "nation", fallback="")
    )
     document.Replace("{{v1.nie}}", config_object.get("OWNER1", "nie", fallback=""))
    document.body.replace(
        "{{v1.idnr}}", config_object.get("OWNER1", "idnr", fallback="")
    )

     document.Replace("{{v2.sex}}", config_object.get("OWNER2", "sex", fallback=""))
    document.body.replace(
        "{{v2.first_name}}", config_object.get("OWNER2", "first_name", fallback="")
    )
    document.body.replace(
        "{{v2.last_name}}", config_object.get("OWNER2", "last_name", fallback="")
    )
    document.body.replace(
        "{{v2.nationality}}", config_object.get("OWNER2", "nationality", fallback="")
    )
    document.body.replace(
        "{{v2.town}}", config_object.get("OWNER2", "town", fallback="")
    )
     document.Replace("{{v2.zip}}", config_object.get("OWNER2", "zip", fallback=""))
    document.body.replace(
        "{{v2.street}}", config_object.get("OWNER2", "street", fallback="")
    )
    document.body.replace(
        "{{v2.number}}", config_object.get("OWNER2", "number", fallback="")
    )
    document.body.replace(
        "{{v2.nation}}", config_object.get("OWNER2", "nation", fallback="")
    )
     document.Replace("{{v2.nie}}", config_object.get("OWNER2", "nie", fallback=""))
    document.body.replace(
        "{{v2.idnr}}", config_object.get("OWNER2", "idnr", fallback="")
    )

    amount_notary = int(config_object.get("OPTION", "amount_notary", fallback=""))
    amount_meuble = int(config_object.get("OPTION", "amount_meuble", fallback=""))
    amount_option = int(config_object.get("OPTION", "amount_option", fallback=""))

     document.Replace("{{amount_notary}}", to_cur(amount_notary))
     document.Replace("{{amount_meuble}}", to_cur(amount_meuble))
     document.Replace("{{amount_option}}", to_cur(amount_option))
     document.Replace("{{amount_total}}", to_cur(amount_notary + amount_meuble))
     document.Replace("{{amount_rest}}", to_cur(amount_notary - amount_option))
    
 """
