from pathlib import Path
from importlib import resources
from typing import Union

from odfdo import Document

from table_maker.helper import to_cur
import logging

log = logging.getLogger(__name__)


def make_odt(p: Path, plaza_txt_mtime: float, config_object):
    make_odt_authorizacion(
        dest_file=p.joinpath("Documentos Plaza/odt/Autorizacion V.odt"),
        plaza_txt_mtime=plaza_txt_mtime,
        ref_catastral=config_object.get("MAIN", "ref_catastral", fallback=""),
        p1_sex=config_object.get("OWNER1", "sex", fallback=""),
        p1_first_name=config_object.get("OWNER1", "first_name", fallback=""),
        p1_last_name=config_object.get("OWNER1", "last_name", fallback=""),
        p1_nationality=config_object.get("OWNER1", "nationality", fallback=""),
        p1_town=config_object.get("OWNER1", "town", fallback=""),
        p1_zip=config_object.get("OWNER1", "zip", fallback=""),
        p1_street=config_object.get("OWNER1", "street", fallback=""),
        p1_number=config_object.get("OWNER1", "number", fallback=""),
        p1_nation=config_object.get("OWNER1", "nation", fallback=""),
        p1_idnr=config_object.get("OWNER1", "idnr", fallback=""),
        p1_nie=config_object.get("OWNER1", "nie", fallback=""),
        p2_sex=config_object.get("OWNER2", "sex", fallback=""),
        p2_first_name=config_object.get("OWNER2", "first_name", fallback=""),
        p2_last_name=config_object.get("OWNER2", "last_name", fallback=""),
        p2_nationality=config_object.get("OWNER2", "nationality", fallback=""),
        p2_town=config_object.get("OWNER2", "town", fallback=""),
        p2_zip=config_object.get("OWNER2", "zip", fallback=""),
        p2_street=config_object.get("OWNER2", "street", fallback=""),
        p2_number=config_object.get("OWNER2", "number", fallback=""),
        p2_nation=config_object.get("OWNER2", "nation", fallback=""),
        p2_idnr=config_object.get("OWNER2", "idnr", fallback=""),
        p2_nie=config_object.get("OWNER2", "nie", fallback=""),
    )

    make_odt_authorizacion(
        dest_file=p.joinpath("Documentos Plaza/odt/Autorizacion C.odt"),
        plaza_txt_mtime=plaza_txt_mtime,
        ref_catastral=config_object.get("MAIN", "ref_catastral", fallback=""),
        p1_sex=config_object.get("BUYER1", "sex", fallback=""),
        p1_first_name=config_object.get("BUYER1", "first_name", fallback=""),
        p1_last_name=config_object.get("BUYER1", "last_name", fallback=""),
        p1_nationality=config_object.get("BUYER1", "nationality", fallback=""),
        p1_town=config_object.get("BUYER1", "town", fallback=""),
        p1_zip=config_object.get("BUYER1", "zip", fallback=""),
        p1_street=config_object.get("BUYER1", "street", fallback=""),
        p1_number=config_object.get("BUYER1", "number", fallback=""),
        p1_nation=config_object.get("BUYER1", "nation", fallback=""),
        p1_idnr=config_object.get("BUYER1", "idnr", fallback=""),
        p1_nie=config_object.get("BUYER1", "nie", fallback=""),
        p2_sex=config_object.get("BUYER2", "sex", fallback=""),
        p2_first_name=config_object.get("BUYER2", "first_name", fallback=""),
        p2_last_name=config_object.get("BUYER2", "last_name", fallback=""),
        p2_nationality=config_object.get("BUYER2", "nationality", fallback=""),
        p2_town=config_object.get("BUYER2", "town", fallback=""),
        p2_zip=config_object.get("BUYER2", "zip", fallback=""),
        p2_street=config_object.get("BUYER2", "street", fallback=""),
        p2_number=config_object.get("BUYER2", "number", fallback=""),
        p2_nation=config_object.get("BUYER2", "nation", fallback=""),
        p2_idnr=config_object.get("BUYER2", "idnr", fallback=""),
        p2_nie=config_object.get("BUYER2", "nie", fallback=""),
    )

    make_odt_arras_de(
        dest_file=p.joinpath("Documentos Plaza/odt/Contrato Arras DE.odt"),
        plaza_txt_mtime=plaza_txt_mtime,
        config_object=config_object,
    )


def make_odt_authorizacion(
    dest_file: Path,
    plaza_txt_mtime: float,
    ref_catastral,
    p1_sex,
    p1_first_name,
    p1_last_name,
    p1_nationality,
    p1_town,
    p1_zip,
    p1_street,
    p1_number,
    p1_nation,
    p1_nie,
    p1_idnr,
    p2_sex,
    p2_first_name,
    p2_last_name,
    p2_nationality,
    p2_town,
    p2_zip,
    p2_street,
    p2_number,
    p2_nation,
    p2_nie,
    p2_idnr,
):
    document = None

    if dest_file.exists() and dest_file.stat().st_mtime > plaza_txt_mtime:
        return None

    with resources.as_file(
        resources.files("table_maker")
        / "assets"
        / "Autorizacion-Christian-Teresa-Stephan.odt"
    ) as fp:
        document = Document(fp)

    if document is None:
        log.error("document is None")
        return None

    document.body.replace("{{ref_catastral}}", ref_catastral)
    document.body.replace("{{p1.sex}}", p1_sex)
    document.body.replace("{{p1.first_name}}", p1_first_name)
    document.body.replace("{{p1.last_name}}", p1_last_name)
    document.body.replace("{{p1.nationality}}", p1_nationality)
    document.body.replace("{{p1.town}}", p1_town)
    document.body.replace("{{p1.zip}}", p1_zip)
    document.body.replace("{{p1.street}}", p1_street)
    document.body.replace("{{p1.number}}", p1_number)
    document.body.replace("{{p1.nation}}", p1_nation)
    document.body.replace("{{p1.nie}}", p1_nie)
    document.body.replace("{{p1.idnr}}", p1_idnr)

    document.body.replace("{{p2.sex}}", p2_sex)
    document.body.replace("{{p2.first_name}}", p2_first_name)
    document.body.replace("{{p2.last_name}}", p2_last_name)
    document.body.replace("{{p2.nationality}}", p2_nationality)
    document.body.replace("{{p2.town}}", p2_town)
    document.body.replace("{{p2.zip}}", p2_zip)
    document.body.replace("{{p2.street}}", p2_street)
    document.body.replace("{{p2.number}}", p2_number)
    document.body.replace("{{p2.nation}}", p2_nation)
    document.body.replace("{{p2.nie}}", p2_nie)
    document.body.replace("{{p2.idnr}}", p2_idnr)

    document.save(dest_file, pretty=True)


def make_odt_arras_de(dest_file: Path, plaza_txt_mtime: float, config_object):
    document = None

    if dest_file.exists() and dest_file.stat().st_mtime > plaza_txt_mtime:
        return None

    with resources.as_file(
        resources.files("table_maker") / "assets" / "Contrato-de-arras-DE.odt"
    ) as fp:
        document = Document(fp)

    if document is None:
        log.error("document is None")
        return None

    document.body.replace("{{c1.sex}}", config_object.get("BUYER1", "sex", fallback=""))
    document.body.replace(
        "{{c1.first_name}}", config_object.get("BUYER1", "first_name", fallback="")
    )
    document.body.replace(
        "{{c1.last_name}}", config_object.get("BUYER1", "last_name", fallback="")
    )
    document.body.replace(
        "{{c1.nationality}}", config_object.get("BUYER1", "nationality", fallback="")
    )
    document.body.replace(
        "{{c1.town}}", config_object.get("BUYER1", "town", fallback="")
    )
    document.body.replace("{{c1.zip}}", config_object.get("BUYER1", "zip", fallback=""))
    document.body.replace(
        "{{c1.street}}", config_object.get("BUYER1", "street", fallback="")
    )
    document.body.replace(
        "{{c1.number}}", config_object.get("BUYER1", "number", fallback="")
    )
    document.body.replace(
        "{{c1.nation}}", config_object.get("BUYER1", "nation", fallback="")
    )
    document.body.replace("{{c1.nie}}", config_object.get("BUYER1", "nie", fallback=""))
    document.body.replace(
        "{{c1.idnr}}", config_object.get("BUYER1", "idnr", fallback="")
    )

    document.body.replace("{{c2.sex}}", config_object.get("BUYER2", "sex", fallback=""))
    document.body.replace(
        "{{c2.first_name}}", config_object.get("BUYER2", "first_name", fallback="")
    )
    document.body.replace(
        "{{c2.last_name}}", config_object.get("BUYER2", "last_name", fallback="")
    )
    document.body.replace(
        "{{c2.nationality}}", config_object.get("BUYER2", "nationality", fallback="")
    )
    document.body.replace(
        "{{c2.town}}", config_object.get("BUYER2", "town", fallback="")
    )
    document.body.replace("{{c2.zip}}", config_object.get("BUYER2", "zip", fallback=""))
    document.body.replace(
        "{{c2.street}}", config_object.get("BUYER2", "street", fallback="")
    )
    document.body.replace(
        "{{c2.number}}", config_object.get("BUYER2", "number", fallback="")
    )
    document.body.replace(
        "{{c2.nation}}", config_object.get("BUYER2", "nation", fallback="")
    )
    document.body.replace("{{c2.nie}}", config_object.get("BUYER2", "nie", fallback=""))
    document.body.replace(
        "{{c2.idnr}}", config_object.get("BUYER2", "idnr", fallback="")
    )

    document.body.replace("{{v1.sex}}", config_object.get("OWNER1", "sex", fallback=""))
    document.body.replace(
        "{{v1.first_name}}", config_object.get("OWNER1", "first_name", fallback="")
    )
    document.body.replace(
        "{{v1.last_name}}", config_object.get("OWNER1", "last_name", fallback="")
    )
    document.body.replace(
        "{{v1.nationality}}", config_object.get("OWNER1", "nationality", fallback="")
    )
    document.body.replace(
        "{{v1.town}}", config_object.get("OWNER1", "town", fallback="")
    )
    document.body.replace("{{v1.zip}}", config_object.get("OWNER1", "zip", fallback=""))
    document.body.replace(
        "{{v1.street}}", config_object.get("OWNER1", "street", fallback="")
    )
    document.body.replace(
        "{{v1.number}}", config_object.get("OWNER1", "number", fallback="")
    )
    document.body.replace(
        "{{v1.nation}}", config_object.get("OWNER1", "nation", fallback="")
    )
    document.body.replace("{{v1.nie}}", config_object.get("OWNER1", "nie", fallback=""))
    document.body.replace(
        "{{v1.idnr}}", config_object.get("OWNER1", "idnr", fallback="")
    )

    document.body.replace("{{v2.sex}}", config_object.get("OWNER2", "sex", fallback=""))
    document.body.replace(
        "{{v2.first_name}}", config_object.get("OWNER2", "first_name", fallback="")
    )
    document.body.replace(
        "{{v2.last_name}}", config_object.get("OWNER2", "last_name", fallback="")
    )
    document.body.replace(
        "{{v2.nationality}}", config_object.get("OWNER2", "nationality", fallback="")
    )
    document.body.replace(
        "{{v2.town}}", config_object.get("OWNER2", "town", fallback="")
    )
    document.body.replace("{{v2.zip}}", config_object.get("OWNER2", "zip", fallback=""))
    document.body.replace(
        "{{v2.street}}", config_object.get("OWNER2", "street", fallback="")
    )
    document.body.replace(
        "{{v2.number}}", config_object.get("OWNER2", "number", fallback="")
    )
    document.body.replace(
        "{{v2.nation}}", config_object.get("OWNER2", "nation", fallback="")
    )
    document.body.replace("{{v2.nie}}", config_object.get("OWNER2", "nie", fallback=""))
    document.body.replace(
        "{{v2.idnr}}", config_object.get("OWNER2", "idnr", fallback="")
    )

    amount_notary = int(config_object.get("OPTION", "amount_notary", fallback=""))
    amount_meuble = int(config_object.get("OPTION", "amount_meuble", fallback=""))
    amount_option = int(config_object.get("OPTION", "amount_option", fallback=""))

    document.body.replace("{{amount_notary}}", to_cur(amount_notary))
    document.body.replace("{{amount_meuble}}", to_cur(amount_meuble))
    document.body.replace("{{amount_option}}", to_cur(amount_option))
    document.body.replace("{{amount_total}}", to_cur(amount_notary + amount_meuble))
    document.body.replace("{{amount_rest}}", to_cur(amount_notary - amount_option))

    document.save(dest_file, pretty=True)
