from dataclasses import dataclass
from pathlib import Path
import configparser


@dataclass
class Exposee:
    altitude: str
    living_space: str


@dataclass
class Media:
    idealista: str


@dataclass
class Person:
    sex: str
    first_name: str
    last_name: str
    nacionality: str


@dataclass
class Option:
    amount_notary: str


@dataclass
class Main:
    version: str
    title: str
    remark: str
    category: str
    price: str
    rent: str
    position: str
    hide_position: str
    grafcan: str
    plaza: str
    short_url: str


@dataclass
class Property:
    main: Main
    exposee: Exposee
    media: Media
    housekeeper: Person
    owner1: Person
    onwer2: Person
    buyer1: Person
    buyer2: Person
    tenant: Person
    option: Option


def read_ini(p: Path) -> Property | None:
    config_object = configparser.ConfigParser()

    with p.open() as f:
        config_object.read_file(f)

    cfg_dict = {s: dict(config_object.items(s)) for s in config_object.sections()}
    print(cfg_dict)


if __name__ == "__main__":
    main = dict()
    main["version"] = None

    exposee = dict()
    exposee["altitude"] = None

    media = dict()
    media["idealista"] = None

    person = dict()
    person["sex"] = None

    property = dict()

    property["MAIN"] = main
    property["EXPOSEE"] = exposee
    property["MEDIA"] = media
    property["HOUSEKEEPER"] = person.copy()
    property["OWNER1"] = person.copy()

    read_ini(
        p=Path(
            "/home/stephan/repos/table_maker/Objekte/Sueden/Las Manchas/L760 198.000/plaza.txt"
        ),
    )
