# Installation

### Debian Pakete
apt install -y python3-virtualenv python3-wheel build-essential rustc python3-dev libssl-dev

apt install -y mariadb memcached

### Systemuser
adduser --system --group --home /srv/riego.cloud/service --shell /usr/bin/bash riegocloud

### Sudo for restarting nginx / apache
sudo bash -c "cat > /etc/sudoers.d/riegocloud" << 'EOT'
riegocloud ALL=(root) NOPASSWD: /usr/sbin/apachectl graceful
riegocloud ALL=(root) NOPASSWD: /bin/systemctl reload nginx
EOT
chmod 440 /etc/sudoers.d/riegocloud


### Programm
cd /srv/riego.cloud/service
rm -rf .venv
sudo -H -i -u riegocloud bash
python3 -m virtualenv .venv && source .venv/bin/activate && python3 -m pip install pip --upgrade 
python3 -m pip config --site set global.index-url "https://devpi.riego.cloud/riego/prod/+simple/"
python -m pip config --site set global.timeout 60
pip install --upgrade riegocloud uvloop
echo "source .venv/bin/activate" >.profile
exit


### Create Database ###
mysql -u root <<"EOT"
DROP DATABASE IF EXISTS riegocloud;
CREATE DATABASE riegocloud;
CREATE USER IF NOT EXISTS 'riegocloud'@'localhost' IDENTIFIED BY 'Eech5jaephaepaes';
GRANT ALL PRIVILEGES ON riegocloud.* TO 'riegocloud'@'localhost';
FLUSH PRIVILEGES;
SHOW GRANTS FOR 'riegocloud'@'localhost';
EOT


### Install System-Service 
sudo bash -c "cat > /etc/systemd/system/riegocloud.service" <<'EOT'
[Unit]
Description=Riego Cloud Service
After=mariadb.service
StartLimitIntervalSec=0

[Service]
Environment="PYTHONUNBUFFERED=1"
Type=simple
User=riegocloud
WorkingDirectory=/srv/riego.cloud/service
ExecStart=/srv/riego.cloud/service/.venv/bin/riegocloud
Restart=always
RestartSec=1s

[Install]
WantedBy=multi-user.target
EOT


systemctl daemon-reload

systemctl enable riego

systemctl restart riego




### Login as riegocloud: ###
su -l riegocloud


