# Riego - Garden-Watering-System

- Using MQTT-Devices and MQTT-Server
- Linux Daemon with Webinterface
- Designed for running on embedded device like Raspberry Zero W
- Control from Cloud Server is possible
- Already in production for testing, but Work in progress
- Yet no documentation available


Einstellungen im Dashboard:
- Intervall == 0 => mittgas zusätzlich
- duration == 0 => keine automatische Abschaltung
- aktiviert == 0 => keine automatische Einschaltung
- is_hidden == 0 => keine automatische Ein-/ Ausschaltung


# Installation
vorbereitungen unter debian

 ./reboot-to-writable-mode.sh


## Memcached
sudo apt install -y memcached  
sudo systemctl enable memcached.service  
sudo systemctl restart memcached.service  


## Mosquitto
sudo apt install -y mosquitto mosquitto-clients

sudo bash -c "cat > /etc/mosquitto/mosquitto.conf" <<'EOT'  
listener 1883 0.0.0.0  
protocol mqtt  
allow_anonymous true  
persistence true  
persistence_location /mnt/usb1/mosquitto/  
persistent_client_expiration 2m  
include_dir /etc/mosquitto/conf.d  
EOT

cp -a /var/lib/mosquitto /mnt/usb1/

sudo systemctl enable mosquitto.service  
sudo systemctl restart mosquitto.service  


### mDNS Discovery für MQTT

sudo apt install -y avahi-daemon  
sudo bash -c "cat > /etc/avahi/services/mqtt.service" <<'EOT'  
<?xml version="1.0" standalone='no'?>  
<!DOCTYPE service-group SYSTEM "avahi-service.dtd">  
<service-group>  
 <name replace-wildcards="yes">MQTT on %h</name>  
  <service>  
   <type>_mqtt._tcp</type>  
   <port>1883</port>  
  </service>  
</service-group>  
EOT  

sudo systemctl enable avahi-daemon  
sudo systemctl restart avahi-daemon  

sudo adduser --system --group --home /mnt/usb1/riego --shell /bin/bash riego  
sudo chown -R riego:riego /mnt/usb1/riego  
sudo chmod 2775 /mnt/usb1/riego  

## Python venv with venv
- apt install -y python3-virtualenv python3-dev libffi-dev libssl-dev
- sudo -H -i -u riego bash
- rm -rf .venv
- python3 -m virtualenv .venv && source .venv/bin/activate && pip install --upgrade pip
- python3 -m pip config --site set global.index-url "https://devpi.riego.cloud/riego/prod/+simple/"
- python3 -m pip config --site set global.timeout 60


## Python venv with uv
- sudo -H -i -u riego bash
- rm -rf .venv
- curl -LsSf https://astral.sh/uv/install.sh | sh
- uv venv --python 3.12 && uv pip install pip && source .venv/bin/activate
- pip config --site set global.index-url "https://devpi.riego.cloud/riego/prod/+simple/"
- pip config --site set global.timeout 60


## Build Dependencie for crypthography from aiohttp[secure]
apt install libssl-dev  
curl https://sh.rustup.rs -sSf | sh 
pip install --upgrade riego uvloop  
echo "source .venv/bin/activate" >.profile  
exit

## Linux Service installieren ###
sudo bash -c "cat > /etc/systemd/system/riego.service" <<'EOT'  
[Unit]  
Description=Riego Rain-System  
After=mnt-usb1.mount mosquitto.service  

[Service]  
Nice=-9  
IOSchedulingClass=best-effort  
IOSchedulingPriority=0  
Environment="PYTHONUNBUFFERED=1"  
Type=simple  
User=riego  
WorkingDirectory=/mnt/usb1/riego  
ExecStart=/mnt/usb1/riego/.venv/bin/riego  
Restart=always  

[Install]  
WantedBy=multi-user.target  
EOT

systemctl daemon-reload  
systemctl enable riego  
systemctl restart riego  
