from logging import getLogger

_log = getLogger(__name__)


def migrate(db):
    if db.execute("PRAGMA user_version").fetchone()[0] == 0:
        _log.debug("Running Database migration version 0")
        db.executescript("""
BEGIN;
CREATE TABLE boxes (
	id	                INTEGER,
	topic	            TEXT NOT NULL,
	name	            TEXT,
	hostname	        TEXT,
	remark	            TEXT,
	first_seen	        datetime DEFAULT (strftime('%Y-%m-%d %H:%M:%f', 'now', 'localtime')),
	online_since    	datetime DEFAULT (strftime('%Y-%m-%d %H:%M:%f', 'now', 'localtime')),
	hw_type	            TEXT,
	hw_version        	TEXT,
	sw_type	            TEXT,
	sw_version	        TEXT,
	fallback_topic      TEXT,
	group_topic	        TEXT,
	ip_address	        TEXT,
	created_at	        datetime DEFAULT (strftime('%Y-%m-%d %H:%M:%f', 'now', 'localtime')),
    rssi                INTEGER,
    link_count          INTEGER,
    down_time           TEXT,
	CONSTRAINT topic_uc UNIQUE(topic),
    PRIMARY KEY(id));

CREATE TABLE events (
	id	                INTEGER,
	duration	        INTEGER DEFAULT 0,
	water_amount	    INTEGER,
	valve_id	        INTEGER NOT NULL REFERENCES valves(id) ON DELETE CASCADE,
	created_at	        datetime DEFAULT (strftime('%Y-%m-%d %H:%M:%f', 'now', 'localtime')),
    PRIMARY KEY(id));
                       
CREATE TABLE parameters (
	id	                INTEGER,
	key	                TEXT NOT NULL,
	value	            TEXT,
	created_at	        datetime DEFAULT (strftime('%Y-%m-%d %H:%M:%f', 'now', 'localtime')),
	CONSTRAINT key_uc   UNIQUE(key),
    PRIMARY KEY(id));
                       
CREATE TABLE users (
	id	                INTEGER,
	identity	        TEXT,
	password	        TEXT,
    full_name           TEXT,
    email               TEXT,
    permission_id	    INTEGER,
	is_superuser	    INTEGER DEFAULT 0,
	is_disabled	        INTEGER DEFAULT 0,
	remember_me	        TEXT,
	created_at	        datetime DEFAULT (strftime('%Y-%m-%d %H:%M:%f', 'now', 'localtime')),
    CONSTRAINT identity_uc UNIQUE(identity),
    PRIMARY KEY(id));                       

INSERT INTO users (identity,is_superuser) VALUES ('admin',1);                       

CREATE TABLE users_permissions (
	id                  INTEGER,
	name	            TEXT,
	user_id	            INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE,
	created_at	        datetime DEFAULT (strftime('%Y-%m-%d %H:%M:%f', 'now', 'localtime')),
	PRIMARY KEY(id));                       

CREATE TABLE users_tokens (
	id	                INTEGER,
	sequence	        TEXT NOT NULL,
    hash	            TEXT,
    category	        TEXT,
	user_id	            INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE,
	created_at	        datetime DEFAULT (strftime('%Y-%m-%d %H:%M:%f', 'now', 'localtime')),
    CONSTRAINT sequence_uc UNIQUE(sequence),
	PRIMARY KEY(id));

CREATE TABLE valves (
	id	                INTEGER,
	name	            TEXT,
	remark	            TEXT DEFAULT '',
	channel_nr	        INTEGER NOT NULL,
	duration	        INTEGER DEFAULT 0,
	interval	        INTEGER DEFAULT 4,
	last_shedule	    datetime DEFAULT '1970-01-01 00:00:00',
    last_run	        datetime DEFAULT '1970-01-01 00:00:00',
	is_running	        INTEGER DEFAULT 0,
	is_enabled	        INTEGER DEFAULT 0,
	is_hidden	        INTEGER DEFAULT 0,
	prio	            INTEGER DEFAULT 9,
	box_id	            INTEGER NOT NULL REFERENCES boxes(id) ON DELETE CASCADE,
	created_at	        datetime DEFAULT (strftime('%Y-%m-%d %H:%M:%f', 'now', 'localtime')),
	CONSTRAINT channel_nr_box_id_uc UNIQUE(channel_nr,box_id),
    PRIMARY KEY(id));

PRAGMA user_version = 1;
COMMIT;
""")

    if db.execute("PRAGMA user_version").fetchone()[0] == 1:
        _log.debug("Running Database migration version 1")
        db.executescript("""
BEGIN;
DROP TRIGGER IF EXISTS t_valves_insert;
CREATE TRIGGER t_valves_insert
        AFTER INSERT ON valves
        BEGIN SELECT signal_changes('valves', 'insert', new.rowid, new.rowid); END;

DROP TRIGGER IF EXISTS t_valves_update;
CREATE TRIGGER t_valves_update
        AFTER UPDATE ON valves
        BEGIN SELECT signal_changes('valves', 'update', old.rowid, new.rowid); END;

DROP TRIGGER IF EXISTS t_valves_delete;
CREATE TRIGGER t_valves_delete
        AFTER DELETE ON valves
        BEGIN SELECT signal_changes('valves', 'delete', old.rowid, old.rowid); END;

DROP TRIGGER IF EXISTS t_boxes_insert;
CREATE TRIGGER t_boxes_insert
        AFTER INSERT ON boxes
        BEGIN SELECT signal_changes('boxes', 'insert', new.rowid, new.rowid); END;

DROP TRIGGER IF EXISTS t_boxes_update;
CREATE TRIGGER t_boxes_update
        AFTER UPDATE ON boxes
        BEGIN SELECT signal_changes('boxes', 'update', old.rowid, new.rowid); END;

DROP TRIGGER IF EXISTS t_boxes_delete;
CREATE TRIGGER t_boxes_delete
        AFTER DELETE ON boxes
        BEGIN SELECT signal_changes('boxes', 'delete', old.rowid, old.rowid); END;

DROP TRIGGER IF EXISTS t_events_insert;
CREATE TRIGGER t_events_insert
        AFTER INSERT ON events
        BEGIN SELECT signal_changes('events', 'insert', new.rowid, new.rowid); END;

DROP TRIGGER IF EXISTS t_events_update;
CREATE TRIGGER t_events_update
        AFTER UPDATE ON events
        BEGIN SELECT signal_changes('events', 'update', old.rowid, new.rowid); END;                       
                       
PRAGMA user_version = 2;
COMMIT;
""")
