import aiohttp_jinja2
from aiohttp import web

from riego.web.security import raise_permission
from riego.db import get_db

router = web.RouteTableDef()


def setup_routes_events(app):
    app.add_routes(router)


@router.get("/events", name="events")
@aiohttp_jinja2.template("events/index.html")
async def event_index(request):
    await raise_permission(request, permission=None)
    db = get_db()
    cursor = db.cursor()
    cursor.execute(
        """SELECT events.*,
                valves.name AS valves_name,
                valves.id AS valves_id,
                valves.duration AS valves_duration
                FROM events, valves
                WHERE events.valve_id = valves.id
                ORDER BY events.created_at DESC
                LIMIT 100"""
    )
    items = cursor.fetchall()
    return {"items": items}


@router.get("/events/{item_id}/filter", name="events_item_filter")
@aiohttp_jinja2.template("events/index.html")
async def event_filter(request):
    await raise_permission(request, permission=None)
    db = get_db()
    item_id = request.match_info["item_id"]
    cursor = db.cursor()
    cursor.execute(
        """SELECT events.*, valves.name
                FROM events, valves
                WHERE events.valve_id = valves.id
                AND valves.id = ?
                ORDER BY events.created_at DESC""",
        (item_id,),
    )
    items = cursor.fetchall()
    return {"items": items}
