from sqlite3 import IntegrityError

import aiohttp_jinja2
import bcrypt
from aiohttp import web

from riego.db import get_db
from riego.web.security import get_user

router = web.RouteTableDef()


def setup_routes_profile(app):
    app.add_routes(router)


@router.get("/profile", name="profile")
@aiohttp_jinja2.template("profile/profile.html")
async def profile(request: web.Request):
    return {}


@router.post("/profile")
async def profile_apply(request: web.Request):
    form = await request.post()
    user = await get_user(request)
    db = get_db()
    # TODO check old_password and equality of pw1 an pw2
    password = form["new_password_1"].encode("utf-8")
    password = bcrypt.hashpw(password, bcrypt.gensalt())
    password = password.decode("utf-8")
    try:
        with db:
            db.execute(
                """UPDATE users
                    SET password = ?
                    WHERE id = ? """,
                (password, user["id"]),
            )
    except IntegrityError:
        return web.HTTPSeeOther(request.app.router["passwd"].url_for())

    return web.HTTPSeeOther(request.app.router["home"].url_for())
    return {}  # not reached
