import * as ec2 from '@aws-cdk/aws-ec2';
import * as s3 from '@aws-cdk/aws-s3';
import * as cdk from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface VideoTranscoderProp {
    /**
     * @stability stable
     */
    readonly bucket?: s3.Bucket;
    /**
     * @stability stable
     */
    readonly vpc?: ec2.IVpc;
    /**
     * @stability stable
     */
    readonly segmentTime?: number;
    /**
     * @stability stable
     */
    readonly parallelGroupNo?: number;
    /**
     * @stability stable
     */
    readonly lambdaMemorySize?: number;
    /**
     * @stability stable
     */
    readonly lambdaTimeOut?: number;
}
/**
 * @stability stable
 */
export declare class VideoTranscoder extends cdk.Construct {
    /**
     * @stability stable
     */
    readonly videoBucket: s3.Bucket;
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props?: VideoTranscoderProp);
}
