"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codedeploy = require("@aws-cdk/aws-codedeploy");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const cpactions = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'aws-cdk-codepipeline-codedeploy-ecs');
const application = codedeploy.EcsApplication.fromEcsApplicationName(stack, 'CodeDeployApplication', 'IntegTestDeployApp');
const deploymentGroup = codedeploy.EcsDeploymentGroup.fromEcsDeploymentGroupAttributes(stack, 'CodeDeployGroup', {
    application,
    deploymentGroupName: 'IntegTestDeploymentGroup',
});
const bucket = new s3.Bucket(stack, 'CodeDeployPipelineIntegTest', {
    versioned: true,
    removalPolicy: cdk.RemovalPolicy.DESTROY,
});
const pipeline = new codepipeline.Pipeline(stack, 'Pipeline', {
    artifactBucket: bucket,
});
const sourceStage = pipeline.addStage({ stageName: 'Source' });
const sourceOutput = new codepipeline.Artifact('SourceOutput');
const sourceAction = new cpactions.S3SourceAction({
    actionName: 'S3Source',
    bucketKey: 'application.zip',
    output: sourceOutput,
    bucket,
});
sourceStage.addAction(sourceAction);
const deployStage = pipeline.addStage({ stageName: 'Deploy' });
deployStage.addAction(new cpactions.CodeDeployEcsDeployAction({
    actionName: 'CodeDeploy',
    deploymentGroup,
    taskDefinitionTemplateFile: new codepipeline.ArtifactPath(sourceOutput, 'task-definition-test.json'),
    appSpecTemplateFile: new codepipeline.ArtifactPath(sourceOutput, 'appspec-test.json'),
    containerImageInputs: [
        {
            input: sourceOutput,
            taskDefinitionPlaceholder: 'PLACEHOLDER',
        },
    ],
}));
app.synth();
//# sourceMappingURL=data:application/json;base64,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