"use strict";
const assert_1 = require("@aws-cdk/assert");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const sns = require("@aws-cdk/aws-sns");
const core_1 = require("@aws-cdk/core");
const cpactions = require("../lib");
module.exports = {
    'manual approval Action': {
        'allows passing an SNS Topic when constructing it'(test) {
            const stack = new core_1.Stack();
            const topic = new sns.Topic(stack, 'Topic');
            const manualApprovalAction = new cpactions.ManualApprovalAction({
                actionName: 'Approve',
                notificationTopic: topic,
            });
            const pipeline = new codepipeline.Pipeline(stack, 'pipeline');
            const stage = pipeline.addStage({ stageName: 'stage' });
            stage.addAction(manualApprovalAction);
            test.equal(manualApprovalAction.notificationTopic, topic);
            test.done();
        },
        'renders CustomData and ExternalEntityLink even if notificationTopic was not passed'(test) {
            const stack = new core_1.Stack();
            new codepipeline.Pipeline(stack, 'pipeline', {
                stages: [
                    {
                        stageName: 'Source',
                        actions: [new cpactions.GitHubSourceAction({
                                actionName: 'Source',
                                output: new codepipeline.Artifact(),
                                oauthToken: core_1.SecretValue.plainText('secret'),
                                owner: 'aws',
                                repo: 'aws-cdk',
                            })],
                    },
                    {
                        stageName: 'Approve',
                        actions: [
                            new cpactions.ManualApprovalAction({
                                actionName: 'Approval',
                                additionalInformation: 'extra info',
                                externalEntityLink: 'external link',
                            }),
                        ],
                    },
                ],
            });
            assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::CodePipeline::Pipeline', {
                'Stages': [
                    {
                        'Name': 'Source',
                    },
                    {
                        'Name': 'Approve',
                        'Actions': [
                            {
                                'Name': 'Approval',
                                'Configuration': {
                                    'CustomData': 'extra info',
                                    'ExternalEntityLink': 'external link',
                                },
                            },
                        ],
                    },
                ],
            }));
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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