/**
 * Django Image Uploader Widget - An image uploader widget for django.
 * @version v0.1.0
 * @author Eduardo Oliveira (EduardoJM) <eduardo_y05@outlook.com>.
 * @link https://github.com/inventare/django-image-uploader-widget
 * 
 * Licensed under the MIT License (https://github.com/inventare/django-image-uploader-widget/blob/main/LICENSE).
 */

"use strict";function _classCallCheck(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function _defineProperties(e,t){for(var i=0;i<t.length;i++){var r=t[i];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}function _createClass(e,t,i){return t&&_defineProperties(e.prototype,t),i&&_defineProperties(e,i),Object.defineProperty(e,"prototype",{writable:!1}),e}function _defineProperty(e,t,i){return t in e?Object.defineProperty(e,t,{value:i,enumerable:!0,configurable:!0,writable:!0}):e[t]=i,e}var ImageUploaderWidget=function(){function t(e){var i=this;_classCallCheck(this,t),_defineProperty(this,"element",void 0),_defineProperty(this,"fileInput",void 0),_defineProperty(this,"checkboxInput",void 0),_defineProperty(this,"emptyMarker",void 0),_defineProperty(this,"dropLabel",void 0),_defineProperty(this,"canDelete",!1),_defineProperty(this,"dragging",!1),_defineProperty(this,"id",void 0),_defineProperty(this,"raw",null),_defineProperty(this,"file",null),_defineProperty(this,"onEmptyMarkerClick",function(){i.fileInput.click()}),_defineProperty(this,"onDrop",function(e){e.preventDefault(),i.dragging=!1,i.element.classList.remove("drop-zone"),e.dataTransfer.files.length&&(i.fileInput.files=e.dataTransfer.files,i.file=i.fileInput.files[0],i.raw=null,i.renderWidget())}),_defineProperty(this,"onDragEnter",function(){i.dragging=!0,i.element.classList.add("drop-zone")}),_defineProperty(this,"onDragOver",function(e){e&&e.preventDefault()}),_defineProperty(this,"onDragLeave",function(e){e.relatedTarget&&e.relatedTarget.closest(".iuw-root")===i.element||(i.dragging=!1,i.element.classList.remove("drop-zone"))}),_defineProperty(this,"onImagePreviewClick",function(e){if(e&&e.target){var t=e.target;if(e&&e.target&&t.closest(".iuw-delete-icon")){t=t.closest(".iuw-image-preview");return t.parentElement.removeChild(t),i.checkboxInput.checked=!0,i.fileInput.value=null,i.file=null,i.raw=null,void i.renderWidget()}}i.fileInput.click()}),_defineProperty(this,"onFileInputChange",function(){0<i.fileInput.files.length&&(i.file=i.fileInput.files[0]),i.renderWidget()}),this.element=e,this.fileInput=e.querySelector("input[type=file]"),this.checkboxInput=e.querySelector("input[type=checkbox]"),this.emptyMarker=this.element.querySelector(".iuw-empty"),this.canDelete="true"===e.getAttribute("data-candelete"),this.dragging=!1,this.id=this.fileInput.getAttribute("id"),this.dropLabel=this.element.querySelector(".drop-label"),this.dropLabel&&this.dropLabel.setAttribute("for",this.id),this.fileInput.addEventListener("change",this.onFileInputChange),this.emptyMarker.addEventListener("click",this.onEmptyMarkerClick),this.element.addEventListener("dragenter",this.onDragEnter),this.element.addEventListener("dragover",this.onDragOver),this.element.addEventListener("dragleave",this.onDragLeave),this.element.addEventListener("dragend",this.onDragLeave),this.element.addEventListener("drop",this.onDrop),this.raw=e.getAttribute("data-raw"),this.file=null,this.renderWidget()}return _createClass(t,[{key:"renderPreview",value:function(e){var t=document.createElement("div");t.classList.add("iuw-image-preview");var i=document.createElement("img");return i.src=e,t.appendChild(i),this.canDelete&&((i=document.createElement("span")).classList.add("iuw-delete-icon"),i.innerHTML='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" width="100%" height="100%"><path xmlns="http://www.w3.org/2000/svg" d="m289.94 256 95-95A24 24 0 0 0 351 127l-95 95-95-95a24 24 0 0 0-34 34l95 95-95 95a24 24 0 1 0 34 34l95-95 95 95a24 24 0 0 0 34-34z"></path></svg>',t.appendChild(i)),t}},{key:"renderWidget",value:function(){var e,t=this;this.file||this.raw?(this.element.classList.add("non-empty"),this.checkboxInput&&(this.checkboxInput.checked=!1)):(this.element.classList.remove("non-empty"),this.checkboxInput&&(this.checkboxInput.checked=!0)),Array.from(this.element.querySelectorAll(".iuw-image-preview")).forEach(function(e){return t.element.removeChild(e)}),this.file&&(e=URL.createObjectURL(this.file),this.element.appendChild(this.renderPreview(e))),this.raw&&this.element.appendChild(this.renderPreview(this.raw)),Array.from(this.element.querySelectorAll(".iuw-image-preview")).forEach(function(e){return e.addEventListener("click",t.onImagePreviewClick)})}}]),t}();document.addEventListener("DOMContentLoaded",function(){Array.from(document.querySelectorAll(".iuw-root")).map(function(e){return new ImageUploaderWidget(e)}),window&&window.django&&window.django.jQuery&&(0,window.django.jQuery)(document).on("formset:added",function(e,t){t.length&&Array.from(t[0].querySelectorAll(".iuw-root")).map(function(e){return new ImageUploaderWidget(e)})})});