"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PythonFunction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const bundling_1 = require("./bundling");
/**
 * A Python Lambda function
 */
class PythonFunction extends aws_lambda_1.Function {
    constructor(scope, id, props) {
        jsiiDeprecationWarnings._aws_cdk_aws_lambda_python_PythonFunctionProps(props);
        const { index = 'index.py', handler = 'handler', runtime } = props;
        if (props.index && !/\.py$/.test(props.index)) {
            throw new Error('Only Python (.py) index files are supported.');
        }
        // Entry
        const entry = path.resolve(props.entry);
        const resolvedIndex = path.resolve(entry, index);
        if (!fs.existsSync(resolvedIndex)) {
            throw new Error(`Cannot find index file at ${resolvedIndex}`);
        }
        const resolvedHandler = `${index.slice(0, -3)}.${handler}`.replace('/', '.');
        if (props.runtime && props.runtime.family !== aws_lambda_1.RuntimeFamily.PYTHON) {
            throw new Error('Only `PYTHON` runtimes are supported.');
        }
        super(scope, id, {
            ...props,
            runtime,
            code: bundling_1.Bundling.bundle({
                entry,
                runtime,
                ...props.bundling,
            }),
            handler: resolvedHandler,
        });
    }
}
exports.PythonFunction = PythonFunction;
_a = JSII_RTTI_SYMBOL_1;
PythonFunction[_a] = { fqn: "@aws-cdk/aws-lambda-python.PythonFunction", version: "1.146.0" };
//# sourceMappingURL=data:application/json;base64,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