/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.util.preprocessor;

import com.datapps.linkoopdb.jdbc.util.preprocessor.IResolver;
import java.io.File;
import java.io.IOException;

class BasicResolver
implements IResolver {
    File parentDir;

    public BasicResolver(File parentDir) {
        this.parentDir = parentDir;
    }

    @Override
    public String resolveProperties(String expression) {
        return expression;
    }

    @Override
    public File resolveFile(String path) {
        File file = new File(path);
        if (this.parentDir != null && !file.isAbsolute()) {
            try {
                path = this.parentDir.getCanonicalPath() + File.separatorChar + path;
                file = new File(path);
            }
            catch (IOException ex) {
                path = this.parentDir.getAbsolutePath() + File.separatorChar + path;
                file = new File(path);
            }
        }
        try {
            return file.getCanonicalFile();
        }
        catch (Exception e) {
            return file.getAbsoluteFile();
        }
    }
}

