# coding: utf-8

"""
    Selling Partner API for Finances

    The Selling Partner API for Finances helps you obtain financial information relevant to a seller's business. You can obtain financial events for a given order, financial event group, or date range without having to wait until a statement period closes. You can also obtain financial event groups for a given date range.  # noqa: E501

    OpenAPI spec version: v0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six


class SAFETReimbursementItem(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'item_charge_list': 'ChargeComponentList',
        'product_description': 'str',
        'quantity': 'str'
    }

    attribute_map = {
        'item_charge_list': 'itemChargeList',
        'product_description': 'productDescription',
        'quantity': 'quantity'
    }

    def __init__(self, item_charge_list=None, product_description=None, quantity=None):  # noqa: E501
        """SAFETReimbursementItem - a model defined in Swagger"""  # noqa: E501
        self._item_charge_list = None
        self._product_description = None
        self._quantity = None
        self.discriminator = None
        if item_charge_list is not None:
            self.item_charge_list = item_charge_list
        if product_description is not None:
            self.product_description = product_description
        if quantity is not None:
            self.quantity = quantity

    @property
    def item_charge_list(self):
        """Gets the item_charge_list of this SAFETReimbursementItem.  # noqa: E501


        :return: The item_charge_list of this SAFETReimbursementItem.  # noqa: E501
        :rtype: ChargeComponentList
        """
        return self._item_charge_list

    @item_charge_list.setter
    def item_charge_list(self, item_charge_list):
        """Sets the item_charge_list of this SAFETReimbursementItem.


        :param item_charge_list: The item_charge_list of this SAFETReimbursementItem.  # noqa: E501
        :type: ChargeComponentList
        """

        self._item_charge_list = item_charge_list

    @property
    def product_description(self):
        """Gets the product_description of this SAFETReimbursementItem.  # noqa: E501

        The description of the item as shown on the product detail page on the retail website.  # noqa: E501

        :return: The product_description of this SAFETReimbursementItem.  # noqa: E501
        :rtype: str
        """
        return self._product_description

    @product_description.setter
    def product_description(self, product_description):
        """Sets the product_description of this SAFETReimbursementItem.

        The description of the item as shown on the product detail page on the retail website.  # noqa: E501

        :param product_description: The product_description of this SAFETReimbursementItem.  # noqa: E501
        :type: str
        """

        self._product_description = product_description

    @property
    def quantity(self):
        """Gets the quantity of this SAFETReimbursementItem.  # noqa: E501

        The number of units of the item being reimbursed.  # noqa: E501

        :return: The quantity of this SAFETReimbursementItem.  # noqa: E501
        :rtype: str
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this SAFETReimbursementItem.

        The number of units of the item being reimbursed.  # noqa: E501

        :param quantity: The quantity of this SAFETReimbursementItem.  # noqa: E501
        :type: str
        """

        self._quantity = quantity

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SAFETReimbursementItem, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SAFETReimbursementItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
