import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


@register
class AnimationMixer(ThreeWidget):
    """AnimationMixer

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/animation/AnimationMixer
    """

    def __init__(self, rootObject=None, time=0, timeScale=1, **kwargs):
        kwargs['rootObject'] = rootObject
        kwargs['time'] = time
        kwargs['timeScale'] = timeScale
        super(AnimationMixer, self).__init__(**kwargs)

    _model_name = Unicode('AnimationMixerModel').tag(sync=True)

    rootObject = Instance(ThreeWidget, allow_none=True).tag(sync=True, **widget_serialization)

    time = CFloat(0, allow_none=False).tag(sync=True)

    timeScale = CFloat(1, allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    AnimationMixer.__signature__ = inspect.signature(AnimationMixer.__init__)
