import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


@register
class KeyframeTrack(ThreeWidget):
    """KeyframeTrack

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/animation/KeyframeTrack
    """

    def __init__(self, name="", times=None, values=None, interpolation="InterpolateLinear", **kwargs):
        kwargs['name'] = name
        kwargs['times'] = times
        kwargs['values'] = values
        kwargs['interpolation'] = interpolation
        super(KeyframeTrack, self).__init__(**kwargs)

    _model_name = Unicode('KeyframeTrackModel').tag(sync=True)

    name = Unicode("", allow_none=False).tag(sync=True)

    times = WebGLDataUnion().tag(sync=True)

    values = WebGLDataUnion().tag(sync=True)

    interpolation = Enum(InterpolationModes, "InterpolateLinear", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    KeyframeTrack.__signature__ = inspect.signature(KeyframeTrack.__init__)
