import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Camera_autogen import Camera


@register
class OrthographicCamera(Camera):
    """OrthographicCamera

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/cameras/OrthographicCamera
    """

    def __init__(self, left=0, right=0, top=0, bottom=0, near=0.1, far=2000, **kwargs):
        kwargs['left'] = left
        kwargs['right'] = right
        kwargs['top'] = top
        kwargs['bottom'] = bottom
        kwargs['near'] = near
        kwargs['far'] = far
        super(OrthographicCamera, self).__init__(**kwargs)

    _model_name = Unicode('OrthographicCameraModel').tag(sync=True)

    zoom = CFloat(1, allow_none=False).tag(sync=True)

    left = CFloat(0, allow_none=False).tag(sync=True)

    right = CFloat(0, allow_none=False).tag(sync=True)

    top = CFloat(0, allow_none=False).tag(sync=True)

    bottom = CFloat(0, allow_none=False).tag(sync=True)

    near = CFloat(0.1, allow_none=False).tag(sync=True)

    far = CFloat(2000, allow_none=False).tag(sync=True)

    type = Unicode("OrthographicCamera", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    OrthographicCamera.__signature__ = inspect.signature(OrthographicCamera.__init__)
