import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


@register
class Sphere(ThreeWidget):
    """Sphere

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/math/Sphere
    """

    def __init__(self, center=[0, 0, 0], radius=0, **kwargs):
        kwargs['center'] = center
        kwargs['radius'] = radius
        super(Sphere, self).__init__(**kwargs)

    _model_name = Unicode('SphereModel').tag(sync=True)

    center = Vector3(default_value=[0, 0, 0]).tag(sync=True)

    radius = CFloat(0, allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    Sphere.__signature__ = inspect.signature(Sphere.__init__)
