import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget

from .Bone_autogen import Bone

@register
class Skeleton(ThreeWidget):
    """Skeleton

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/objects/Skeleton
    """

    def __init__(self, bones=[], **kwargs):
        kwargs['bones'] = bones
        super(Skeleton, self).__init__(**kwargs)

    _model_name = Unicode('SkeletonModel').tag(sync=True)

    bones = Tuple().tag(sync=True, **widget_serialization)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    Skeleton.__signature__ = inspect.signature(Skeleton.__init__)
