"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PowertoolLogFormatter = void 0;
const _1 = require(".");
/**
 * This class is used to transform a set of log key-value pairs
 * in the AWS Lambda Powertools' default structure log format.
 *
 * @class
 * @extends {LogFormatter}
 */
class PowertoolLogFormatter extends _1.LogFormatter {
    /**
     * It formats key-value pairs of log attributes.
     *
     * @param {UnformattedAttributes} attributes
     * @returns {PowertoolLog}
     */
    formatAttributes(attributes) {
        var _a, _b, _c, _d, _e;
        return {
            cold_start: (_a = attributes.lambdaContext) === null || _a === void 0 ? void 0 : _a.coldStart,
            function_arn: (_b = attributes.lambdaContext) === null || _b === void 0 ? void 0 : _b.invokedFunctionArn,
            function_memory_size: (_c = attributes.lambdaContext) === null || _c === void 0 ? void 0 : _c.memoryLimitInMB,
            function_name: (_d = attributes.lambdaContext) === null || _d === void 0 ? void 0 : _d.functionName,
            function_request_id: (_e = attributes.lambdaContext) === null || _e === void 0 ? void 0 : _e.awsRequestId,
            level: attributes.logLevel,
            message: attributes.message,
            sampling_rate: attributes.sampleRateValue,
            service: attributes.serviceName,
            timestamp: this.formatTimestamp(attributes.timestamp),
            xray_trace_id: attributes.xRayTraceId,
        };
    }
}
exports.PowertoolLogFormatter = PowertoolLogFormatter;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUG93ZXJ0b29sTG9nRm9ybWF0dGVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2Zvcm1hdHRlci9Qb3dlcnRvb2xMb2dGb3JtYXR0ZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsd0JBQWlDO0FBSWpDOzs7Ozs7R0FNRztBQUNILE1BQU0scUJBQXNCLFNBQVEsZUFBWTtJQUU5Qzs7Ozs7T0FLRztJQUNJLGdCQUFnQixDQUFDLFVBQWlDOztRQUN2RCxPQUFPO1lBQ0wsVUFBVSxFQUFFLE1BQUEsVUFBVSxDQUFDLGFBQWEsMENBQUUsU0FBUztZQUMvQyxZQUFZLEVBQUUsTUFBQSxVQUFVLENBQUMsYUFBYSwwQ0FBRSxrQkFBa0I7WUFDMUQsb0JBQW9CLEVBQUUsTUFBQSxVQUFVLENBQUMsYUFBYSwwQ0FBRSxlQUFlO1lBQy9ELGFBQWEsRUFBRSxNQUFBLFVBQVUsQ0FBQyxhQUFhLDBDQUFFLFlBQVk7WUFDckQsbUJBQW1CLEVBQUUsTUFBQSxVQUFVLENBQUMsYUFBYSwwQ0FBRSxZQUFZO1lBQzNELEtBQUssRUFBRSxVQUFVLENBQUMsUUFBUTtZQUMxQixPQUFPLEVBQUUsVUFBVSxDQUFDLE9BQU87WUFDM0IsYUFBYSxFQUFFLFVBQVUsQ0FBQyxlQUFlO1lBQ3pDLE9BQU8sRUFBRSxVQUFVLENBQUMsV0FBVztZQUMvQixTQUFTLEVBQUUsSUFBSSxDQUFDLGVBQWUsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDO1lBQ3JELGFBQWEsRUFBRSxVQUFVLENBQUMsV0FBVztTQUN0QyxDQUFDO0lBQ0osQ0FBQztDQUVGO0FBR0Msc0RBQXFCIn0=