"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Authorizers = exports.IamAuthorizer = exports.NoneAuthorizer = exports.CustomAuthorizer = exports.CustomAuthorizerType = exports.CognitoAuthorizer = exports.Authorizer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const aws_apigateway_1 = require("aws-cdk-lib/aws-apigateway");
/**
 * An authorizer for authorizing API requests
 */
class Authorizer {
    constructor(props) {
        this.authorizerId = props.authorizerId;
        this.authorizationType = props.authorizationType;
    }
}
exports.Authorizer = Authorizer;
_a = JSII_RTTI_SYMBOL_1;
Authorizer[_a] = { fqn: "@aws-prototyping-sdk/open-api-gateway.Authorizer", version: "0.3.10" };
/**
 * An authorizer that uses Cognito identity or access tokens.
 */
class CognitoAuthorizer extends Authorizer {
    constructor(props) {
        super({
            authorizerId: props.authorizerId,
            authorizationType: aws_apigateway_1.AuthorizationType.COGNITO,
        });
        this.userPools = props.userPools;
        this.authorizationScopes = props.authorizationScopes ?? [];
    }
    /**
     * Returns this authorizer with scopes applied, intended for usage in individual operations where scopes may differ
     * on a per-operation basis
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
     * @param authorizationScopes the scopes to apply
     */
    withScopes(...authorizationScopes) {
        return new CognitoAuthorizer({
            authorizerId: this.authorizerId,
            userPools: this.userPools,
            authorizationScopes,
        });
    }
}
exports.CognitoAuthorizer = CognitoAuthorizer;
_b = JSII_RTTI_SYMBOL_1;
CognitoAuthorizer[_b] = { fqn: "@aws-prototyping-sdk/open-api-gateway.CognitoAuthorizer", version: "0.3.10" };
/**
 * The type of custom authorizer
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-authorizer.html#cfn-apigateway-authorizer-type
 */
var CustomAuthorizerType;
(function (CustomAuthorizerType) {
    /**
     * A custom authorizer that uses a Lambda function.
     */
    CustomAuthorizerType["TOKEN"] = "token";
    /**
     * An authorizer that uses a Lambda function using incoming request parameters.
     */
    CustomAuthorizerType["REQUEST"] = "request";
})(CustomAuthorizerType = exports.CustomAuthorizerType || (exports.CustomAuthorizerType = {}));
// The default time to cache the custom authorizer result
const DEFAULT_CUSTOM_AUTHORIZER_RESULT_TTL_SECONDS = 300;
/**
 * An authorizer that uses a lambda function to authorize requests
 */
class CustomAuthorizer extends Authorizer {
    constructor(props) {
        super({
            authorizerId: props.authorizerId,
            authorizationType: aws_apigateway_1.AuthorizationType.CUSTOM,
        });
        this.function = props.function;
        this.type = props.type ?? CustomAuthorizerType.TOKEN;
        this.identitySource =
            props.identitySource ?? "method.request.header.Authorization";
        this.authorizerResultTtlInSeconds =
            props.authorizerResultTtlInSeconds ??
                DEFAULT_CUSTOM_AUTHORIZER_RESULT_TTL_SECONDS;
    }
}
exports.CustomAuthorizer = CustomAuthorizer;
_c = JSII_RTTI_SYMBOL_1;
CustomAuthorizer[_c] = { fqn: "@aws-prototyping-sdk/open-api-gateway.CustomAuthorizer", version: "0.3.10" };
/**
 * No authorizer
 */
class NoneAuthorizer extends Authorizer {
    constructor() {
        super({
            authorizerId: "none",
            authorizationType: aws_apigateway_1.AuthorizationType.NONE,
        });
    }
}
exports.NoneAuthorizer = NoneAuthorizer;
_d = JSII_RTTI_SYMBOL_1;
NoneAuthorizer[_d] = { fqn: "@aws-prototyping-sdk/open-api-gateway.NoneAuthorizer", version: "0.3.10" };
/**
 * An IAM authorizer
 */
class IamAuthorizer extends Authorizer {
    constructor() {
        super({
            authorizerId: "iam",
            authorizationType: aws_apigateway_1.AuthorizationType.IAM,
        });
    }
}
exports.IamAuthorizer = IamAuthorizer;
_e = JSII_RTTI_SYMBOL_1;
IamAuthorizer[_e] = { fqn: "@aws-prototyping-sdk/open-api-gateway.IamAuthorizer", version: "0.3.10" };
/**
 * Class used to construct authorizers for use in the OpenApiGatewayLambdaApi construct
 */
class Authorizers {
    /**
     * An IAM authorizer which uses AWS signature version 4 to authorize requests
     */
    static iam() {
        return new IamAuthorizer();
    }
    /**
     * No authorizer
     */
    static none() {
        return new NoneAuthorizer();
    }
    /**
     * A Cognito User Pools authorizer
     */
    static cognito(props) {
        return new CognitoAuthorizer(props);
    }
    /**
     * A custom authorizer
     */
    static custom(props) {
        return new CustomAuthorizer(props);
    }
}
exports.Authorizers = Authorizers;
_f = JSII_RTTI_SYMBOL_1;
Authorizers[_f] = { fqn: "@aws-prototyping-sdk/open-api-gateway.Authorizers", version: "0.3.10" };
//# sourceMappingURL=data:application/json;base64,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