/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.lib;

import com.datapps.linkoopdb.jdbc.lib.ArrayUtil;
import com.datapps.linkoopdb.jdbc.lib.IntLookup;
import com.datapps.linkoopdb.jdbc.lib.LongLookup;
import java.util.NoSuchElementException;

public class DoubleIntIndex
implements IntLookup,
LongLookup {
    private final boolean fixedSize;
    private int count = 0;
    private int capacity;
    private boolean sorted = true;
    private boolean sortOnValues = true;
    private boolean hasChanged;
    private int[] keys;
    private int[] values;
    private int targetSearchValue;

    public DoubleIntIndex(int capacity, boolean fixedSize) {
        this.capacity = capacity;
        this.keys = new int[capacity];
        this.values = new int[capacity];
        this.fixedSize = fixedSize;
        this.hasChanged = true;
    }

    public synchronized int getKey(int i) {
        if (i < 0 || i >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.keys[i];
    }

    public synchronized int getValue(int i) {
        if (i < 0 || i >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[i];
    }

    public synchronized void setKey(int i, int key) {
        if (i < 0 || i >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.sortOnValues) {
            this.sorted = false;
        }
        this.keys[i] = key;
    }

    public synchronized void setValue(int i, int value) {
        if (i < 0 || i >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (this.sortOnValues) {
            this.sorted = false;
        }
        this.values[i] = value;
    }

    @Override
    public synchronized int size() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.capacity;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public int[] getValues() {
        return this.values;
    }

    public long getTotalValues() {
        long total = 0L;
        for (int i = 0; i < this.count; ++i) {
            total += (long)this.values[i];
        }
        return total;
    }

    public void setSize(int newSize) {
        this.count = newSize;
    }

    @Override
    public synchronized boolean addUnsorted(long key, long value) {
        if (key > Integer.MAX_VALUE || key < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.addUnsorted((int)key, (int)value);
    }

    @Override
    public synchronized boolean addUnsorted(int key, int value) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.sorted && this.count != 0) {
            if (this.sortOnValues) {
                if (value < this.values[this.count - 1]) {
                    this.sorted = false;
                }
            } else if (key < this.keys[this.count - 1]) {
                this.sorted = false;
            }
        }
        this.hasChanged = true;
        this.keys[this.count] = key;
        this.values[this.count] = value;
        ++this.count;
        return true;
    }

    public synchronized boolean addUnsorted(DoubleIntIndex other) {
        if (this.count + other.count > this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            while (this.count + other.count > this.capacity) {
                this.doubleCapacity();
            }
        }
        this.sorted = false;
        this.hasChanged = true;
        for (int i = 0; i < other.count; ++i) {
            this.keys[this.count] = other.keys[i];
            this.values[this.count] = other.values[i];
            ++this.count;
        }
        return true;
    }

    public synchronized boolean addSorted(int key, int value) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.count != 0) {
            if (this.sortOnValues) {
                if (value < this.values[this.count - 1]) {
                    return false;
                }
                if (value == this.values[this.count - 1] && key < this.keys[this.count - 1]) {
                    return false;
                }
            } else if (key < this.keys[this.count - 1]) {
                return false;
            }
        }
        this.hasChanged = true;
        this.keys[this.count] = key;
        this.values[this.count] = value;
        ++this.count;
        return true;
    }

    public synchronized boolean addUnique(int key, int value) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = this.sortOnValues ? value : key;
        int i = this.binaryEmptySlotSearch();
        if (i == -1) {
            return false;
        }
        this.hasChanged = true;
        if (this.count != i) {
            this.moveRows(i, i + 1, this.count - i);
        }
        this.keys[i] = key;
        this.values[i] = value;
        ++this.count;
        return true;
    }

    @Override
    public int add(long key, long value) {
        if (key > Integer.MAX_VALUE || key < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.add((int)key, (int)value);
    }

    @Override
    public synchronized int add(int key, int value) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return -1;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = this.sortOnValues ? value : key;
        int i = this.binarySlotSearch(true);
        this.hasChanged = true;
        if (this.count != i) {
            this.moveRows(i, i + 1, this.count - i);
        }
        this.keys[i] = key;
        this.values[i] = value;
        ++this.count;
        return i;
    }

    @Override
    public long lookup(long key) throws NoSuchElementException {
        if (key > Integer.MAX_VALUE || key < Integer.MIN_VALUE) {
            throw new NoSuchElementException();
        }
        return this.lookup((int)key);
    }

    @Override
    public int lookup(int key) throws NoSuchElementException {
        int i;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((i = this.findFirstEqualKeyIndex(key)) == -1) {
            throw new NoSuchElementException();
        }
        return this.getValue(i);
    }

    @Override
    public long lookup(long key, long def) {
        int i;
        if (key > Integer.MAX_VALUE || key < Integer.MIN_VALUE) {
            return def;
        }
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((i = this.findFirstEqualKeyIndex((int)key)) == -1) {
            return def;
        }
        return this.getValue(i);
    }

    @Override
    public int lookup(int key, int def) {
        int i;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((i = this.findFirstEqualKeyIndex(key)) == -1) {
            return def;
        }
        return this.getValue(i);
    }

    @Override
    public void clear() {
        this.removeAll();
    }

    public int lookupFirstGreaterEqual(int key) throws NoSuchElementException {
        int i;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((i = this.findFirstGreaterEqualKeyIndex(key)) == -1) {
            throw new NoSuchElementException();
        }
        return this.getValue(i);
    }

    public synchronized void setValuesSearchTarget() {
        if (!this.sortOnValues && this.count > 1) {
            this.sorted = false;
        }
        this.sortOnValues = true;
    }

    public synchronized void setKeysSearchTarget() {
        if (this.sortOnValues && this.count > 1) {
            this.sorted = false;
        }
        this.sortOnValues = false;
    }

    public synchronized int findFirstGreaterEqualKeyIndex(int value) {
        int index = this.findFirstGreaterEqualSlotIndex(value);
        return index == this.count ? -1 : index;
    }

    public synchronized int findFirstEqualKeyIndex(int value) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = value;
        return this.binaryFirstSearch();
    }

    public synchronized boolean compactLookupAsIntervals() {
        int i;
        if (this.size() == 0) {
            return false;
        }
        this.setKeysSearchTarget();
        if (!this.sorted) {
            this.fastQuickSort();
        }
        int base = 0;
        for (i = 1; i < this.count; ++i) {
            long limit = this.keys[base] + this.values[base];
            if (limit == (long)this.keys[i]) {
                int n = base;
                this.values[n] = this.values[n] + this.values[i];
                continue;
            }
            this.keys[++base] = this.keys[i];
            this.values[base] = this.values[i];
        }
        for (i = base + 1; i < this.count; ++i) {
            this.keys[i] = 0;
            this.values[i] = 0;
        }
        if (this.count != base + 1) {
            this.setSize(base + 1);
            return true;
        }
        return false;
    }

    public synchronized int findFirstGreaterEqualSlotIndex(int value) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = value;
        return this.binarySlotSearch(false);
    }

    private int binaryFirstSearch() {
        int low = 0;
        int high = this.count;
        int mid = 0;
        int compare = 0;
        int found = this.count;
        while (low < high) {
            mid = low + high >>> 1;
            compare = this.compare(mid);
            if (compare < 0) {
                high = mid;
                continue;
            }
            if (compare > 0) {
                low = mid + 1;
                continue;
            }
            high = mid;
            found = mid;
        }
        return found == this.count ? -1 : found;
    }

    private int binarySlotSearch(boolean fullCompare) {
        int low = 0;
        int high = this.count;
        int mid = 0;
        int compare = 0;
        while (low < high) {
            mid = low + high >>> 1;
            compare = this.compare(mid);
            if (compare <= 0) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }

    private int binaryEmptySlotSearch() {
        int low = 0;
        int high = this.count;
        int mid = 0;
        int compare = 0;
        while (low < high) {
            mid = low + high >>> 1;
            compare = this.compare(mid);
            if (compare < 0) {
                high = mid;
                continue;
            }
            if (compare > 0) {
                low = mid + 1;
                continue;
            }
            return -1;
        }
        return low;
    }

    public synchronized void sort() {
        this.fastQuickSort();
    }

    private synchronized void fastQuickSort() {
        DoubleIntIndex indices = new DoubleIntIndex(32, false);
        int threshold = 16;
        indices.push(0, this.count - 1);
        while (indices.size() > 0) {
            int start = indices.peekKey();
            int end = indices.peekValue();
            indices.pop();
            if (end - start >= threshold) {
                int pivot = this.partition(start, end, start + (end - start >>> 1));
                indices.push(start, pivot - 1);
                indices.push(pivot + 1, end);
                continue;
            }
            this.insertionSort(start, end);
        }
        this.sorted = true;
    }

    private int partition(int start, int end, int pivot) {
        int store = start;
        this.swap(pivot, end);
        for (int i = start; i <= end - 1; ++i) {
            if (!this.lessThan(i, end)) continue;
            this.swap(i, store);
            ++store;
        }
        this.swap(store, end);
        return store;
    }

    private synchronized void fastQuickSortRecursive() {
        this.quickSort(0, this.count - 1);
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private void quickSort(int l, int r) {
        int M = 16;
        if (r - l > M) {
            int i = r + l >>> 1;
            if (this.lessThan(i, l)) {
                this.swap(l, i);
            }
            if (this.lessThan(r, l)) {
                this.swap(l, r);
            }
            if (this.lessThan(r, i)) {
                this.swap(i, r);
            }
            int j = r - 1;
            this.swap(i, j);
            i = l;
            int v = j;
            while (true) {
                if (this.lessThan(++i, v)) {
                    continue;
                }
                while (this.lessThan(v, --j)) {
                }
                if (j < i) break;
                this.swap(i, j);
            }
            this.swap(i, r - 1);
            this.quickSort(l, j);
            this.quickSort(i + 1, r);
        }
    }

    private void insertionSort(int lo0, int hi0) {
        for (int i = lo0 + 1; i <= hi0; ++i) {
            int j;
            for (j = i; j > lo0 && this.lessThan(i, j - 1); --j) {
            }
            if (i == j) continue;
            this.moveAndInsertRow(i, j);
        }
    }

    protected void moveAndInsertRow(int i, int j) {
        int col1 = this.keys[i];
        int col2 = this.values[i];
        this.moveRows(j, j + 1, i - j);
        this.keys[j] = col1;
        this.values[j] = col2;
    }

    protected void swap(int i1, int i2) {
        int col1 = this.keys[i1];
        int col2 = this.values[i1];
        this.keys[i1] = this.keys[i2];
        this.values[i1] = this.values[i2];
        this.keys[i2] = col1;
        this.values[i2] = col2;
    }

    protected int compare(int i) {
        if (this.sortOnValues) {
            if (this.targetSearchValue > this.values[i]) {
                return 1;
            }
            if (this.targetSearchValue < this.values[i]) {
                return -1;
            }
            return 0;
        }
        if (this.targetSearchValue > this.keys[i]) {
            return 1;
        }
        if (this.targetSearchValue < this.keys[i]) {
            return -1;
        }
        return 0;
    }

    protected int compare(int i, boolean full) {
        if (this.sortOnValues) {
            if (this.targetSearchValue > this.values[i]) {
                return 1;
            }
            if (this.targetSearchValue < this.values[i]) {
                return -1;
            }
            if (!full) {
                return 0;
            }
        }
        if (this.targetSearchValue > this.keys[i]) {
            return 1;
        }
        if (this.targetSearchValue < this.keys[i]) {
            return -1;
        }
        return 0;
    }

    protected boolean lessThan(int i, int j) {
        if (this.sortOnValues) {
            if (this.values[i] < this.values[j]) {
                return true;
            }
            if (this.values[i] > this.values[j]) {
                return false;
            }
        }
        return this.keys[i] < this.keys[j];
    }

    protected void moveRows(int fromIndex, int toIndex, int rows) {
        System.arraycopy(this.keys, fromIndex, this.keys, toIndex, rows);
        System.arraycopy(this.values, fromIndex, this.values, toIndex, rows);
    }

    protected void doubleCapacity() {
        this.keys = (int[])ArrayUtil.resizeArray(this.keys, this.capacity * 2);
        this.values = (int[])ArrayUtil.resizeArray(this.values, this.capacity * 2);
        this.capacity *= 2;
    }

    public void removeRange(int start, int limit) {
        ArrayUtil.adjustArray(73, this.keys, this.count, start, start - limit);
        ArrayUtil.adjustArray(73, this.values, this.count, start, start - limit);
        this.count -= limit - start;
    }

    public void removeAll() {
        this.hasChanged = true;
        ArrayUtil.clearArray(73, this.keys, 0, this.count);
        ArrayUtil.clearArray(73, this.values, 0, this.count);
        this.count = 0;
        this.sorted = true;
    }

    public void copyTo(DoubleIntIndex other) {
        System.arraycopy(this.keys, 0, other.keys, 0, this.count);
        System.arraycopy(this.values, 0, other.values, 0, this.count);
        other.setSize(this.count);
    }

    public final synchronized void remove(int position) {
        this.hasChanged = true;
        this.moveRows(position + 1, position, this.count - position - 1);
        --this.count;
        this.keys[this.count] = 0;
        this.values[this.count] = 0;
    }

    int peekKey() {
        return this.getKey(this.count - 1);
    }

    int peekValue() {
        return this.getValue(this.count - 1);
    }

    boolean pop() {
        if (this.count > 0) {
            --this.count;
            return true;
        }
        return false;
    }

    boolean push(int key, int value) {
        return this.addUnsorted(key, value);
    }
}

