"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// node_modules/aws-cdk-lib/core/lib/aspect.js
var require_aspect = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/aspect.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.Aspects = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var ASPECTS_SYMBOL = Symbol.for("cdk-aspects");
    var Aspects = class {
      constructor() {
        this._aspects = [];
      }
      static of(scope) {
        let aspects = scope[ASPECTS_SYMBOL];
        return aspects || (aspects = new Aspects(), Object.defineProperty(scope, ASPECTS_SYMBOL, { value: aspects, configurable: false, enumerable: false })), aspects;
      }
      add(aspect) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IAspect(aspect);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.add), error;
        }
        this._aspects.push(aspect);
      }
      get all() {
        return [...this._aspects];
      }
    };
    exports.Aspects = Aspects, _a = JSII_RTTI_SYMBOL_1, Aspects[_a] = { fqn: "aws-cdk-lib.Aspects", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/cloud-assembly/schema.js
var require_schema = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/cloud-assembly/schema.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.ArtifactType = void 0;
    var ArtifactType;
    (function(ArtifactType2) {
      ArtifactType2.NONE = "none", ArtifactType2.AWS_CLOUDFORMATION_STACK = "aws:cloudformation:stack", ArtifactType2.CDK_TREE = "cdk:tree", ArtifactType2.ASSET_MANIFEST = "cdk:asset-manifest", ArtifactType2.NESTED_CLOUD_ASSEMBLY = "cdk:cloud-assembly";
    })(ArtifactType = exports.ArtifactType || (exports.ArtifactType = {}));
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/cloud-assembly/metadata-schema.js
var require_metadata_schema = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/cloud-assembly/metadata-schema.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.ArtifactMetadataEntryType = void 0;
    var ArtifactMetadataEntryType;
    (function(ArtifactMetadataEntryType2) {
      ArtifactMetadataEntryType2.ASSET = "aws:cdk:asset", ArtifactMetadataEntryType2.INFO = "aws:cdk:info", ArtifactMetadataEntryType2.WARN = "aws:cdk:warning", ArtifactMetadataEntryType2.ERROR = "aws:cdk:error", ArtifactMetadataEntryType2.LOGICAL_ID = "aws:cdk:logicalId", ArtifactMetadataEntryType2.STACK_TAGS = "aws:cdk:stack-tags";
    })(ArtifactMetadataEntryType = exports.ArtifactMetadataEntryType || (exports.ArtifactMetadataEntryType = {}));
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/cloud-assembly/artifact-schema.js
var require_artifact_schema = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/cloud-assembly/artifact-schema.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/cloud-assembly/context-queries.js
var require_context_queries = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/cloud-assembly/context-queries.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.LoadBalancerListenerProtocol = exports.LoadBalancerType = exports.ContextProvider = void 0;
    var ContextProvider;
    (function(ContextProvider2) {
      ContextProvider2.AMI_PROVIDER = "ami", ContextProvider2.AVAILABILITY_ZONE_PROVIDER = "availability-zones", ContextProvider2.HOSTED_ZONE_PROVIDER = "hosted-zone", ContextProvider2.SSM_PARAMETER_PROVIDER = "ssm", ContextProvider2.VPC_PROVIDER = "vpc-provider", ContextProvider2.ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER = "endpoint-service-availability-zones", ContextProvider2.LOAD_BALANCER_PROVIDER = "load-balancer", ContextProvider2.LOAD_BALANCER_LISTENER_PROVIDER = "load-balancer-listener", ContextProvider2.SECURITY_GROUP_PROVIDER = "security-group", ContextProvider2.KEY_PROVIDER = "key-provider", ContextProvider2.PLUGIN = "plugin";
    })(ContextProvider = exports.ContextProvider || (exports.ContextProvider = {}));
    var LoadBalancerType;
    (function(LoadBalancerType2) {
      LoadBalancerType2.NETWORK = "network", LoadBalancerType2.APPLICATION = "application";
    })(LoadBalancerType = exports.LoadBalancerType || (exports.LoadBalancerType = {}));
    var LoadBalancerListenerProtocol;
    (function(LoadBalancerListenerProtocol2) {
      LoadBalancerListenerProtocol2.HTTP = "HTTP", LoadBalancerListenerProtocol2.HTTPS = "HTTPS", LoadBalancerListenerProtocol2.TCP = "TCP", LoadBalancerListenerProtocol2.TLS = "TLS", LoadBalancerListenerProtocol2.UDP = "UDP", LoadBalancerListenerProtocol2.TCP_UDP = "TCP_UDP";
    })(LoadBalancerListenerProtocol = exports.LoadBalancerListenerProtocol || (exports.LoadBalancerListenerProtocol = {}));
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/cloud-assembly/index.js
var require_cloud_assembly = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/cloud-assembly/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        p !== "default" && !exports2.hasOwnProperty(p) && __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true }), __exportStar(require_schema(), exports), __exportStar(require_metadata_schema(), exports), __exportStar(require_artifact_schema(), exports), __exportStar(require_context_queries(), exports);
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/assets/schema.js
var require_schema2 = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/assets/schema.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/assets/docker-image-asset.js
var require_docker_image_asset = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/assets/docker-image-asset.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/assets/file-asset.js
var require_file_asset = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/assets/file-asset.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.FileAssetPackaging = void 0;
    var FileAssetPackaging;
    (function(FileAssetPackaging2) {
      FileAssetPackaging2.FILE = "file", FileAssetPackaging2.ZIP_DIRECTORY = "zip";
    })(FileAssetPackaging = exports.FileAssetPackaging || (exports.FileAssetPackaging = {}));
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/assets/aws-destination.js
var require_aws_destination = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/assets/aws-destination.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/assets/index.js
var require_assets = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/assets/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        p !== "default" && !exports2.hasOwnProperty(p) && __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true }), __exportStar(require_schema2(), exports), __exportStar(require_docker_image_asset(), exports), __exportStar(require_file_asset(), exports), __exportStar(require_aws_destination(), exports);
  }
});

// node_modules/aws-cdk-lib/node_modules/jsonschema/lib/helpers.js
var require_helpers = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/jsonschema/lib/helpers.js"(exports, module2) {
    "use strict";
    var uri = require("url");
    var ValidationError = exports.ValidationError = function ValidationError2(message, instance, schema, path, name, argument) {
      if (Array.isArray(path)) {
        this.path = path;
        this.property = path.reduce(function(sum, item) {
          return sum + makeSuffix(item);
        }, "instance");
      } else if (path !== void 0) {
        this.property = path;
      }
      if (message) {
        this.message = message;
      }
      if (schema) {
        var id = schema.$id || schema.id;
        this.schema = id || schema;
      }
      if (instance !== void 0) {
        this.instance = instance;
      }
      this.name = name;
      this.argument = argument;
      this.stack = this.toString();
    };
    ValidationError.prototype.toString = function toString() {
      return this.property + " " + this.message;
    };
    var ValidatorResult = exports.ValidatorResult = function ValidatorResult2(instance, schema, options, ctx) {
      this.instance = instance;
      this.schema = schema;
      this.options = options;
      this.path = ctx.path;
      this.propertyPath = ctx.propertyPath;
      this.errors = [];
      this.throwError = options && options.throwError;
      this.throwFirst = options && options.throwFirst;
      this.throwAll = options && options.throwAll;
      this.disableFormat = options && options.disableFormat === true;
    };
    ValidatorResult.prototype.addError = function addError(detail) {
      var err;
      if (typeof detail == "string") {
        err = new ValidationError(detail, this.instance, this.schema, this.path);
      } else {
        if (!detail)
          throw new Error("Missing error detail");
        if (!detail.message)
          throw new Error("Missing error message");
        if (!detail.name)
          throw new Error("Missing validator type");
        err = new ValidationError(detail.message, this.instance, this.schema, this.path, detail.name, detail.argument);
      }
      this.errors.push(err);
      if (this.throwFirst) {
        throw new ValidatorResultError(this);
      } else if (this.throwError) {
        throw err;
      }
      return err;
    };
    ValidatorResult.prototype.importErrors = function importErrors(res) {
      if (typeof res == "string" || res && res.validatorType) {
        this.addError(res);
      } else if (res && res.errors) {
        this.errors = this.errors.concat(res.errors);
      }
    };
    function stringizer(v, i) {
      return i + ": " + v.toString() + "\n";
    }
    ValidatorResult.prototype.toString = function toString(res) {
      return this.errors.map(stringizer).join("");
    };
    Object.defineProperty(ValidatorResult.prototype, "valid", { get: function() {
      return !this.errors.length;
    } });
    module2.exports.ValidatorResultError = ValidatorResultError;
    function ValidatorResultError(result) {
      if (Error.captureStackTrace) {
        Error.captureStackTrace(this, ValidatorResultError);
      }
      this.instance = result.instance;
      this.schema = result.schema;
      this.options = result.options;
      this.errors = result.errors;
    }
    ValidatorResultError.prototype = new Error();
    ValidatorResultError.prototype.constructor = ValidatorResultError;
    ValidatorResultError.prototype.name = "Validation Error";
    var SchemaError = exports.SchemaError = function SchemaError2(msg, schema) {
      this.message = msg;
      this.schema = schema;
      Error.call(this, msg);
      Error.captureStackTrace(this, SchemaError2);
    };
    SchemaError.prototype = Object.create(
      Error.prototype,
      {
        constructor: { value: SchemaError, enumerable: false },
        name: { value: "SchemaError", enumerable: false }
      }
    );
    var SchemaContext = exports.SchemaContext = function SchemaContext2(schema, options, path, base, schemas) {
      this.schema = schema;
      this.options = options;
      if (Array.isArray(path)) {
        this.path = path;
        this.propertyPath = path.reduce(function(sum, item) {
          return sum + makeSuffix(item);
        }, "instance");
      } else {
        this.propertyPath = path;
      }
      this.base = base;
      this.schemas = schemas;
    };
    SchemaContext.prototype.resolve = function resolve(target) {
      return uri.resolve(this.base, target);
    };
    SchemaContext.prototype.makeChild = function makeChild(schema, propertyName) {
      var path = propertyName === void 0 ? this.path : this.path.concat([propertyName]);
      var id = schema.$id || schema.id;
      var base = uri.resolve(this.base, id || "");
      var ctx = new SchemaContext(schema, this.options, path, base, Object.create(this.schemas));
      if (id && !ctx.schemas[base]) {
        ctx.schemas[base] = schema;
      }
      return ctx;
    };
    var FORMAT_REGEXPS = exports.FORMAT_REGEXPS = {
      // 7.3.1. Dates, Times, and Duration
      "date-time": /^\d{4}-(?:0[0-9]{1}|1[0-2]{1})-(3[01]|0[1-9]|[12][0-9])[tT ](2[0-4]|[01][0-9]):([0-5][0-9]):(60|[0-5][0-9])(\.\d+)?([zZ]|[+-]([0-5][0-9]):(60|[0-5][0-9]))$/,
      "date": /^\d{4}-(?:0[0-9]{1}|1[0-2]{1})-(3[01]|0[1-9]|[12][0-9])$/,
      "time": /^(2[0-4]|[01][0-9]):([0-5][0-9]):(60|[0-5][0-9])$/,
      "duration": /P(T\d+(H(\d+M(\d+S)?)?|M(\d+S)?|S)|\d+(D|M(\d+D)?|Y(\d+M(\d+D)?)?)(T\d+(H(\d+M(\d+S)?)?|M(\d+S)?|S))?|\d+W)/i,
      // 7.3.2. Email Addresses
      // TODO: fix the email production
      "email": /^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/,
      "idn-email": /^("(?:[!#-\[\]-\u{10FFFF}]|\\[\t -\u{10FFFF}])*"|[!#-'*+\-/-9=?A-Z\^-\u{10FFFF}](?:\.?[!#-'*+\-/-9=?A-Z\^-\u{10FFFF}])*)@([!#-'*+\-/-9=?A-Z\^-\u{10FFFF}](?:\.?[!#-'*+\-/-9=?A-Z\^-\u{10FFFF}])*|\[[!-Z\^-\u{10FFFF}]*\])$/u,
      // 7.3.3. Hostnames
      // 7.3.4. IP Addresses
      "ip-address": /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/,
      // FIXME whitespace is invalid
      "ipv6": /^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/,
      // 7.3.5. Resource Identifiers
      // TODO: A more accurate regular expression for "uri" goes:
      // [A-Za-z][+\-.0-9A-Za-z]*:((/(/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?)?)?#(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|(/(/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~])|/?%[0-9A-Fa-f]{2}|[!$&-.0-;=?-Z_a-z~])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*(#(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*)?|/(/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+(:\d*)?|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?:\d*|\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)?)?
      "uri": /^[a-zA-Z][a-zA-Z0-9+.-]*:[^\s]*$/,
      "uri-reference": /^(((([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|([A-Za-z][+\-.0-9A-Za-z]*:?)?)|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|(\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?)?))#(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|(([A-Za-z][+\-.0-9A-Za-z]*)?%[0-9A-Fa-f]{2}|[!$&-.0-9;=@_~]|[A-Za-z][+\-.0-9A-Za-z]*[!$&-*,;=@_~])(%[0-9A-Fa-f]{2}|[!$&-.0-9;=@-Z_a-z~])*((([/?](%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*)?#|[/?])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*)?|([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~])*|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~])+(:\d*)?|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?:\d*|\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~]+)?|[.0-:A-Fa-f]+)\])?)?|[A-Za-z][+\-.0-9A-Za-z]*:?)?$/,
      "iri": /^[a-zA-Z][a-zA-Z0-9+.-]*:[^\s]*$/,
      "iri-reference": /^(((([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~-\u{10FFFF}]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|([A-Za-z][+\-.0-9A-Za-z]*:?)?)|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~-\u{10FFFF}])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~-\u{10FFFF}])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|(\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~-\u{10FFFF}])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?)?))#(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|(([A-Za-z][+\-.0-9A-Za-z]*)?%[0-9A-Fa-f]{2}|[!$&-.0-9;=@_~-\u{10FFFF}]|[A-Za-z][+\-.0-9A-Za-z]*[!$&-*,;=@_~-\u{10FFFF}])(%[0-9A-Fa-f]{2}|[!$&-.0-9;=@-Z_a-z~-\u{10FFFF}])*((([/?](%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*)?#|[/?])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*)?|([A-Za-z][+\-.0-9A-Za-z]*(:%[0-9A-Fa-f]{2}|:[!$&-.0-;=?-Z_a-z~-\u{10FFFF}]|[/?])|\?)(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|([A-Za-z][+\-.0-9A-Za-z]*:)?\/((%[0-9A-Fa-f]{2}|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~-\u{10FFFF}])+|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?)(:\d*)?[/?]|[!$&-.0-;=?-Z_a-z~-\u{10FFFF}])(%[0-9A-Fa-f]{2}|[!$&-;=?-Z_a-z~-\u{10FFFF}])*|\/((%[0-9A-Fa-f]{2}|[!$&-.0-9;=A-Z_a-z~-\u{10FFFF}])+(:\d*)?|(\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?:\d*|\[(([Vv][0-9A-Fa-f]+\.[!$&-.0-;=A-Z_a-z~-\u{10FFFF}]+)?|[.0-:A-Fa-f]+)\])?)?|[A-Za-z][+\-.0-9A-Za-z]*:?)?$/u,
      "uuid": /^[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}$/i,
      // 7.3.6. uri-template
      "uri-template": /(%[0-9a-f]{2}|[!#$&(-;=?@\[\]_a-z~]|\{[!#&+,./;=?@|]?(%[0-9a-f]{2}|[0-9_a-z])(\.?(%[0-9a-f]{2}|[0-9_a-z]))*(:[1-9]\d{0,3}|\*)?(,(%[0-9a-f]{2}|[0-9_a-z])(\.?(%[0-9a-f]{2}|[0-9_a-z]))*(:[1-9]\d{0,3}|\*)?)*\})*/iu,
      // 7.3.7. JSON Pointers
      "json-pointer": /^(\/([\x00-\x2e0-@\[-}\x7f]|~[01])*)*$/iu,
      "relative-json-pointer": /^\d+(#|(\/([\x00-\x2e0-@\[-}\x7f]|~[01])*)*)$/iu,
      // hostname regex from: http://stackoverflow.com/a/1420225/5628
      "hostname": /^(?=.{1,255}$)[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?)*\.?$/,
      "host-name": /^(?=.{1,255}$)[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?(?:\.[0-9A-Za-z](?:(?:[0-9A-Za-z]|-){0,61}[0-9A-Za-z])?)*\.?$/,
      "utc-millisec": function(input) {
        return typeof input === "string" && parseFloat(input) === parseInt(input, 10) && !isNaN(input);
      },
      // 7.3.8. regex
      "regex": function(input) {
        var result = true;
        try {
          new RegExp(input);
        } catch (e) {
          result = false;
        }
        return result;
      },
      // Other definitions
      // "style" was removed from JSON Schema in draft-4 and is deprecated
      "style": /[\r\n\t ]*[^\r\n\t ][^:]*:[\r\n\t ]*[^\r\n\t ;]*[\r\n\t ]*;?/,
      // "color" was removed from JSON Schema in draft-4 and is deprecated
      "color": /^(#?([0-9A-Fa-f]{3}){1,2}\b|aqua|black|blue|fuchsia|gray|green|lime|maroon|navy|olive|orange|purple|red|silver|teal|white|yellow|(rgb\(\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*,\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*,\s*\b([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\b\s*\))|(rgb\(\s*(\d?\d%|100%)+\s*,\s*(\d?\d%|100%)+\s*,\s*(\d?\d%|100%)+\s*\)))$/,
      "phone": /^\+(?:[0-9] ?){6,14}[0-9]$/,
      "alpha": /^[a-zA-Z]+$/,
      "alphanumeric": /^[a-zA-Z0-9]+$/
    };
    FORMAT_REGEXPS.regexp = FORMAT_REGEXPS.regex;
    FORMAT_REGEXPS.pattern = FORMAT_REGEXPS.regex;
    FORMAT_REGEXPS.ipv4 = FORMAT_REGEXPS["ip-address"];
    exports.isFormat = function isFormat(input, format, validator) {
      if (typeof input === "string" && FORMAT_REGEXPS[format] !== void 0) {
        if (FORMAT_REGEXPS[format] instanceof RegExp) {
          return FORMAT_REGEXPS[format].test(input);
        }
        if (typeof FORMAT_REGEXPS[format] === "function") {
          return FORMAT_REGEXPS[format](input);
        }
      } else if (validator && validator.customFormats && typeof validator.customFormats[format] === "function") {
        return validator.customFormats[format](input);
      }
      return true;
    };
    var makeSuffix = exports.makeSuffix = function makeSuffix2(key) {
      key = key.toString();
      if (!key.match(/[.\s\[\]]/) && !key.match(/^[\d]/)) {
        return "." + key;
      }
      if (key.match(/^\d+$/)) {
        return "[" + key + "]";
      }
      return "[" + JSON.stringify(key) + "]";
    };
    exports.deepCompareStrict = function deepCompareStrict(a, b) {
      if (typeof a !== typeof b) {
        return false;
      }
      if (Array.isArray(a)) {
        if (!Array.isArray(b)) {
          return false;
        }
        if (a.length !== b.length) {
          return false;
        }
        return a.every(function(v, i) {
          return deepCompareStrict(a[i], b[i]);
        });
      }
      if (typeof a === "object") {
        if (!a || !b) {
          return a === b;
        }
        var aKeys = Object.keys(a);
        var bKeys = Object.keys(b);
        if (aKeys.length !== bKeys.length) {
          return false;
        }
        return aKeys.every(function(v) {
          return deepCompareStrict(a[v], b[v]);
        });
      }
      return a === b;
    };
    function deepMerger(target, dst, e, i) {
      if (typeof e === "object") {
        dst[i] = deepMerge(target[i], e);
      } else {
        if (target.indexOf(e) === -1) {
          dst.push(e);
        }
      }
    }
    function copyist(src, dst, key) {
      dst[key] = src[key];
    }
    function copyistWithDeepMerge(target, src, dst, key) {
      if (typeof src[key] !== "object" || !src[key]) {
        dst[key] = src[key];
      } else {
        if (!target[key]) {
          dst[key] = src[key];
        } else {
          dst[key] = deepMerge(target[key], src[key]);
        }
      }
    }
    function deepMerge(target, src) {
      var array = Array.isArray(src);
      var dst = array && [] || {};
      if (array) {
        target = target || [];
        dst = dst.concat(target);
        src.forEach(deepMerger.bind(null, target, dst));
      } else {
        if (target && typeof target === "object") {
          Object.keys(target).forEach(copyist.bind(null, target, dst));
        }
        Object.keys(src).forEach(copyistWithDeepMerge.bind(null, target, src, dst));
      }
      return dst;
    }
    module2.exports.deepMerge = deepMerge;
    exports.objectGetPath = function objectGetPath(o, s) {
      var parts = s.split("/").slice(1);
      var k;
      while (typeof (k = parts.shift()) == "string") {
        var n = decodeURIComponent(k.replace(/~0/, "~").replace(/~1/g, "/"));
        if (!(n in o))
          return;
        o = o[n];
      }
      return o;
    };
    function pathEncoder(v) {
      return "/" + encodeURIComponent(v).replace(/~/g, "%7E");
    }
    exports.encodePath = function encodePointer(a) {
      return a.map(pathEncoder).join("");
    };
    exports.getDecimalPlaces = function getDecimalPlaces(number) {
      var decimalPlaces = 0;
      if (isNaN(number))
        return decimalPlaces;
      if (typeof number !== "number") {
        number = Number(number);
      }
      var parts = number.toString().split("e");
      if (parts.length === 2) {
        if (parts[1][0] !== "-") {
          return decimalPlaces;
        } else {
          decimalPlaces = Number(parts[1].slice(1));
        }
      }
      var decimalParts = parts[0].split(".");
      if (decimalParts.length === 2) {
        decimalPlaces += decimalParts[1].length;
      }
      return decimalPlaces;
    };
    exports.isSchema = function isSchema(val) {
      return typeof val === "object" && val || typeof val === "boolean";
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/jsonschema/lib/attribute.js
var require_attribute = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/jsonschema/lib/attribute.js"(exports, module2) {
    "use strict";
    var helpers = require_helpers();
    var ValidatorResult = helpers.ValidatorResult;
    var SchemaError = helpers.SchemaError;
    var attribute = {};
    attribute.ignoreProperties = {
      // informative properties
      "id": true,
      "default": true,
      "description": true,
      "title": true,
      // arguments to other properties
      "additionalItems": true,
      "then": true,
      "else": true,
      // special-handled properties
      "$schema": true,
      "$ref": true,
      "extends": true
    };
    var validators = attribute.validators = {};
    validators.type = function validateType(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      var types = Array.isArray(schema.type) ? schema.type : [schema.type];
      if (!types.some(this.testType.bind(this, instance, schema, options, ctx))) {
        var list = types.map(function(v) {
          if (!v)
            return;
          var id = v.$id || v.id;
          return id ? "<" + id + ">" : v + "";
        });
        result.addError({
          name: "type",
          argument: list,
          message: "is not of a type(s) " + list
        });
      }
      return result;
    };
    function testSchemaNoThrow(instance, options, ctx, callback, schema) {
      var throwError = options.throwError;
      var throwAll = options.throwAll;
      options.throwError = false;
      options.throwAll = false;
      var res = this.validateSchema(instance, schema, options, ctx);
      options.throwError = throwError;
      options.throwAll = throwAll;
      if (!res.valid && callback instanceof Function) {
        callback(res);
      }
      return res.valid;
    }
    validators.anyOf = function validateAnyOf(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      var inner = new ValidatorResult(instance, schema, options, ctx);
      if (!Array.isArray(schema.anyOf)) {
        throw new SchemaError("anyOf must be an array");
      }
      if (!schema.anyOf.some(
        testSchemaNoThrow.bind(
          this,
          instance,
          options,
          ctx,
          function(res) {
            inner.importErrors(res);
          }
        )
      )) {
        var list = schema.anyOf.map(function(v, i) {
          var id = v.$id || v.id;
          if (id)
            return "<" + id + ">";
          return v.title && JSON.stringify(v.title) || v["$ref"] && "<" + v["$ref"] + ">" || "[subschema " + i + "]";
        });
        if (options.nestedErrors) {
          result.importErrors(inner);
        }
        result.addError({
          name: "anyOf",
          argument: list,
          message: "is not any of " + list.join(",")
        });
      }
      return result;
    };
    validators.allOf = function validateAllOf(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      if (!Array.isArray(schema.allOf)) {
        throw new SchemaError("allOf must be an array");
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      var self = this;
      schema.allOf.forEach(function(v, i) {
        var valid = self.validateSchema(instance, v, options, ctx);
        if (!valid.valid) {
          var id = v.$id || v.id;
          var msg = id || v.title && JSON.stringify(v.title) || v["$ref"] && "<" + v["$ref"] + ">" || "[subschema " + i + "]";
          result.addError({
            name: "allOf",
            argument: { id: msg, length: valid.errors.length, valid },
            message: "does not match allOf schema " + msg + " with " + valid.errors.length + " error[s]:"
          });
          result.importErrors(valid);
        }
      });
      return result;
    };
    validators.oneOf = function validateOneOf(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      if (!Array.isArray(schema.oneOf)) {
        throw new SchemaError("oneOf must be an array");
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      var inner = new ValidatorResult(instance, schema, options, ctx);
      var count = schema.oneOf.filter(
        testSchemaNoThrow.bind(
          this,
          instance,
          options,
          ctx,
          function(res) {
            inner.importErrors(res);
          }
        )
      ).length;
      var list = schema.oneOf.map(function(v, i) {
        var id = v.$id || v.id;
        return id || v.title && JSON.stringify(v.title) || v["$ref"] && "<" + v["$ref"] + ">" || "[subschema " + i + "]";
      });
      if (count !== 1) {
        if (options.nestedErrors) {
          result.importErrors(inner);
        }
        result.addError({
          name: "oneOf",
          argument: list,
          message: "is not exactly one from " + list.join(",")
        });
      }
      return result;
    };
    validators.if = function validateIf(instance, schema, options, ctx) {
      if (instance === void 0)
        return null;
      if (!helpers.isSchema(schema.if))
        throw new Error('Expected "if" keyword to be a schema');
      var ifValid = testSchemaNoThrow.call(this, instance, options, ctx, null, schema.if);
      var result = new ValidatorResult(instance, schema, options, ctx);
      var res;
      if (ifValid) {
        if (schema.then === void 0)
          return;
        if (!helpers.isSchema(schema.then))
          throw new Error('Expected "then" keyword to be a schema');
        res = this.validateSchema(instance, schema.then, options, ctx.makeChild(schema.then));
        result.importErrors(res);
      } else {
        if (schema.else === void 0)
          return;
        if (!helpers.isSchema(schema.else))
          throw new Error('Expected "else" keyword to be a schema');
        res = this.validateSchema(instance, schema.else, options, ctx.makeChild(schema.else));
        result.importErrors(res);
      }
      return result;
    };
    function getEnumerableProperty(object, key) {
      if (Object.hasOwnProperty.call(object, key))
        return object[key];
      if (!(key in object))
        return;
      while (object = Object.getPrototypeOf(object)) {
        if (Object.propertyIsEnumerable.call(object, key))
          return object[key];
      }
    }
    validators.propertyNames = function validatePropertyNames(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var subschema = schema.propertyNames !== void 0 ? schema.propertyNames : {};
      if (!helpers.isSchema(subschema))
        throw new SchemaError('Expected "propertyNames" to be a schema (object or boolean)');
      for (var property in instance) {
        if (getEnumerableProperty(instance, property) !== void 0) {
          var res = this.validateSchema(property, subschema, options, ctx.makeChild(subschema));
          result.importErrors(res);
        }
      }
      return result;
    };
    validators.properties = function validateProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var properties = schema.properties || {};
      for (var property in properties) {
        var subschema = properties[property];
        if (subschema === void 0) {
          continue;
        } else if (subschema === null) {
          throw new SchemaError('Unexpected null, expected schema in "properties"');
        }
        if (typeof options.preValidateProperty == "function") {
          options.preValidateProperty(instance, property, subschema, options, ctx);
        }
        var prop = getEnumerableProperty(instance, property);
        var res = this.validateSchema(prop, subschema, options, ctx.makeChild(subschema, property));
        if (res.instance !== result.instance[property])
          result.instance[property] = res.instance;
        result.importErrors(res);
      }
      return result;
    };
    function testAdditionalProperty(instance, schema, options, ctx, property, result) {
      if (!this.types.object(instance))
        return;
      if (schema.properties && schema.properties[property] !== void 0) {
        return;
      }
      if (schema.additionalProperties === false) {
        result.addError({
          name: "additionalProperties",
          argument: property,
          message: "is not allowed to have the additional property " + JSON.stringify(property)
        });
      } else {
        var additionalProperties = schema.additionalProperties || {};
        if (typeof options.preValidateProperty == "function") {
          options.preValidateProperty(instance, property, additionalProperties, options, ctx);
        }
        var res = this.validateSchema(instance[property], additionalProperties, options, ctx.makeChild(additionalProperties, property));
        if (res.instance !== result.instance[property])
          result.instance[property] = res.instance;
        result.importErrors(res);
      }
    }
    validators.patternProperties = function validatePatternProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var patternProperties = schema.patternProperties || {};
      for (var property in instance) {
        var test = true;
        for (var pattern in patternProperties) {
          var subschema = patternProperties[pattern];
          if (subschema === void 0) {
            continue;
          } else if (subschema === null) {
            throw new SchemaError('Unexpected null, expected schema in "patternProperties"');
          }
          try {
            var regexp = new RegExp(pattern, "u");
          } catch (_e) {
            regexp = new RegExp(pattern);
          }
          if (!regexp.test(property)) {
            continue;
          }
          test = false;
          if (typeof options.preValidateProperty == "function") {
            options.preValidateProperty(instance, property, subschema, options, ctx);
          }
          var res = this.validateSchema(instance[property], subschema, options, ctx.makeChild(subschema, property));
          if (res.instance !== result.instance[property])
            result.instance[property] = res.instance;
          result.importErrors(res);
        }
        if (test) {
          testAdditionalProperty.call(this, instance, schema, options, ctx, property, result);
        }
      }
      return result;
    };
    validators.additionalProperties = function validateAdditionalProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      if (schema.patternProperties) {
        return null;
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      for (var property in instance) {
        testAdditionalProperty.call(this, instance, schema, options, ctx, property, result);
      }
      return result;
    };
    validators.minProperties = function validateMinProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var keys = Object.keys(instance);
      if (!(keys.length >= schema.minProperties)) {
        result.addError({
          name: "minProperties",
          argument: schema.minProperties,
          message: "does not meet minimum property length of " + schema.minProperties
        });
      }
      return result;
    };
    validators.maxProperties = function validateMaxProperties(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var keys = Object.keys(instance);
      if (!(keys.length <= schema.maxProperties)) {
        result.addError({
          name: "maxProperties",
          argument: schema.maxProperties,
          message: "does not meet maximum property length of " + schema.maxProperties
        });
      }
      return result;
    };
    validators.items = function validateItems(instance, schema, options, ctx) {
      var self = this;
      if (!this.types.array(instance))
        return;
      if (schema.items === void 0)
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      instance.every(function(value, i) {
        if (Array.isArray(schema.items)) {
          var items = schema.items[i] === void 0 ? schema.additionalItems : schema.items[i];
        } else {
          var items = schema.items;
        }
        if (items === void 0) {
          return true;
        }
        if (items === false) {
          result.addError({
            name: "items",
            message: "additionalItems not permitted"
          });
          return false;
        }
        var res = self.validateSchema(value, items, options, ctx.makeChild(items, i));
        if (res.instance !== result.instance[i])
          result.instance[i] = res.instance;
        result.importErrors(res);
        return true;
      });
      return result;
    };
    validators.contains = function validateContains(instance, schema, options, ctx) {
      var self = this;
      if (!this.types.array(instance))
        return;
      if (schema.contains === void 0)
        return;
      if (!helpers.isSchema(schema.contains))
        throw new Error('Expected "contains" keyword to be a schema');
      var result = new ValidatorResult(instance, schema, options, ctx);
      var count = instance.some(function(value, i) {
        var res = self.validateSchema(value, schema.contains, options, ctx.makeChild(schema.contains, i));
        return res.errors.length === 0;
      });
      if (count === false) {
        result.addError({
          name: "contains",
          argument: schema.contains,
          message: "must contain an item matching given schema"
        });
      }
      return result;
    };
    validators.minimum = function validateMinimum(instance, schema, options, ctx) {
      if (!this.types.number(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (schema.exclusiveMinimum && schema.exclusiveMinimum === true) {
        if (!(instance > schema.minimum)) {
          result.addError({
            name: "minimum",
            argument: schema.minimum,
            message: "must be greater than " + schema.minimum
          });
        }
      } else {
        if (!(instance >= schema.minimum)) {
          result.addError({
            name: "minimum",
            argument: schema.minimum,
            message: "must be greater than or equal to " + schema.minimum
          });
        }
      }
      return result;
    };
    validators.maximum = function validateMaximum(instance, schema, options, ctx) {
      if (!this.types.number(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (schema.exclusiveMaximum && schema.exclusiveMaximum === true) {
        if (!(instance < schema.maximum)) {
          result.addError({
            name: "maximum",
            argument: schema.maximum,
            message: "must be less than " + schema.maximum
          });
        }
      } else {
        if (!(instance <= schema.maximum)) {
          result.addError({
            name: "maximum",
            argument: schema.maximum,
            message: "must be less than or equal to " + schema.maximum
          });
        }
      }
      return result;
    };
    validators.exclusiveMinimum = function validateExclusiveMinimum(instance, schema, options, ctx) {
      if (typeof schema.exclusiveMinimum === "boolean")
        return;
      if (!this.types.number(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var valid = instance > schema.exclusiveMinimum;
      if (!valid) {
        result.addError({
          name: "exclusiveMinimum",
          argument: schema.exclusiveMinimum,
          message: "must be strictly greater than " + schema.exclusiveMinimum
        });
      }
      return result;
    };
    validators.exclusiveMaximum = function validateExclusiveMaximum(instance, schema, options, ctx) {
      if (typeof schema.exclusiveMaximum === "boolean")
        return;
      if (!this.types.number(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var valid = instance < schema.exclusiveMaximum;
      if (!valid) {
        result.addError({
          name: "exclusiveMaximum",
          argument: schema.exclusiveMaximum,
          message: "must be strictly less than " + schema.exclusiveMaximum
        });
      }
      return result;
    };
    var validateMultipleOfOrDivisbleBy = function validateMultipleOfOrDivisbleBy2(instance, schema, options, ctx, validationType, errorMessage) {
      if (!this.types.number(instance))
        return;
      var validationArgument = schema[validationType];
      if (validationArgument == 0) {
        throw new SchemaError(validationType + " cannot be zero");
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      var instanceDecimals = helpers.getDecimalPlaces(instance);
      var divisorDecimals = helpers.getDecimalPlaces(validationArgument);
      var maxDecimals = Math.max(instanceDecimals, divisorDecimals);
      var multiplier = Math.pow(10, maxDecimals);
      if (Math.round(instance * multiplier) % Math.round(validationArgument * multiplier) !== 0) {
        result.addError({
          name: validationType,
          argument: validationArgument,
          message: errorMessage + JSON.stringify(validationArgument)
        });
      }
      return result;
    };
    validators.multipleOf = function validateMultipleOf(instance, schema, options, ctx) {
      return validateMultipleOfOrDivisbleBy.call(this, instance, schema, options, ctx, "multipleOf", "is not a multiple of (divisible by) ");
    };
    validators.divisibleBy = function validateDivisibleBy(instance, schema, options, ctx) {
      return validateMultipleOfOrDivisbleBy.call(this, instance, schema, options, ctx, "divisibleBy", "is not divisible by (multiple of) ");
    };
    validators.required = function validateRequired(instance, schema, options, ctx) {
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (instance === void 0 && schema.required === true) {
        result.addError({
          name: "required",
          message: "is required"
        });
      } else if (this.types.object(instance) && Array.isArray(schema.required)) {
        schema.required.forEach(function(n) {
          if (getEnumerableProperty(instance, n) === void 0) {
            result.addError({
              name: "required",
              argument: n,
              message: "requires property " + JSON.stringify(n)
            });
          }
        });
      }
      return result;
    };
    validators.pattern = function validatePattern(instance, schema, options, ctx) {
      if (!this.types.string(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var pattern = schema.pattern;
      try {
        var regexp = new RegExp(pattern, "u");
      } catch (_e) {
        regexp = new RegExp(pattern);
      }
      if (!instance.match(regexp)) {
        result.addError({
          name: "pattern",
          argument: schema.pattern,
          message: "does not match pattern " + JSON.stringify(schema.pattern.toString())
        });
      }
      return result;
    };
    validators.format = function validateFormat(instance, schema, options, ctx) {
      if (instance === void 0)
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!result.disableFormat && !helpers.isFormat(instance, schema.format, this)) {
        result.addError({
          name: "format",
          argument: schema.format,
          message: "does not conform to the " + JSON.stringify(schema.format) + " format"
        });
      }
      return result;
    };
    validators.minLength = function validateMinLength(instance, schema, options, ctx) {
      if (!this.types.string(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var hsp = instance.match(/[\uDC00-\uDFFF]/g);
      var length = instance.length - (hsp ? hsp.length : 0);
      if (!(length >= schema.minLength)) {
        result.addError({
          name: "minLength",
          argument: schema.minLength,
          message: "does not meet minimum length of " + schema.minLength
        });
      }
      return result;
    };
    validators.maxLength = function validateMaxLength(instance, schema, options, ctx) {
      if (!this.types.string(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var hsp = instance.match(/[\uDC00-\uDFFF]/g);
      var length = instance.length - (hsp ? hsp.length : 0);
      if (!(length <= schema.maxLength)) {
        result.addError({
          name: "maxLength",
          argument: schema.maxLength,
          message: "does not meet maximum length of " + schema.maxLength
        });
      }
      return result;
    };
    validators.minItems = function validateMinItems(instance, schema, options, ctx) {
      if (!this.types.array(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!(instance.length >= schema.minItems)) {
        result.addError({
          name: "minItems",
          argument: schema.minItems,
          message: "does not meet minimum length of " + schema.minItems
        });
      }
      return result;
    };
    validators.maxItems = function validateMaxItems(instance, schema, options, ctx) {
      if (!this.types.array(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!(instance.length <= schema.maxItems)) {
        result.addError({
          name: "maxItems",
          argument: schema.maxItems,
          message: "does not meet maximum length of " + schema.maxItems
        });
      }
      return result;
    };
    function testArrays(v, i, a) {
      var j, len = a.length;
      for (j = i + 1, len; j < len; j++) {
        if (helpers.deepCompareStrict(v, a[j])) {
          return false;
        }
      }
      return true;
    }
    validators.uniqueItems = function validateUniqueItems(instance, schema, options, ctx) {
      if (schema.uniqueItems !== true)
        return;
      if (!this.types.array(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!instance.every(testArrays)) {
        result.addError({
          name: "uniqueItems",
          message: "contains duplicate item"
        });
      }
      return result;
    };
    validators.dependencies = function validateDependencies(instance, schema, options, ctx) {
      if (!this.types.object(instance))
        return;
      var result = new ValidatorResult(instance, schema, options, ctx);
      for (var property in schema.dependencies) {
        if (instance[property] === void 0) {
          continue;
        }
        var dep = schema.dependencies[property];
        var childContext = ctx.makeChild(dep, property);
        if (typeof dep == "string") {
          dep = [dep];
        }
        if (Array.isArray(dep)) {
          dep.forEach(function(prop) {
            if (instance[prop] === void 0) {
              result.addError({
                // FIXME there's two different "dependencies" errors here with slightly different outputs
                // Can we make these the same? Or should we create different error types?
                name: "dependencies",
                argument: childContext.propertyPath,
                message: "property " + prop + " not found, required by " + childContext.propertyPath
              });
            }
          });
        } else {
          var res = this.validateSchema(instance, dep, options, childContext);
          if (result.instance !== res.instance)
            result.instance = res.instance;
          if (res && res.errors.length) {
            result.addError({
              name: "dependencies",
              argument: childContext.propertyPath,
              message: "does not meet dependency required by " + childContext.propertyPath
            });
            result.importErrors(res);
          }
        }
      }
      return result;
    };
    validators["enum"] = function validateEnum(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      if (!Array.isArray(schema["enum"])) {
        throw new SchemaError("enum expects an array", schema);
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!schema["enum"].some(helpers.deepCompareStrict.bind(null, instance))) {
        result.addError({
          name: "enum",
          argument: schema["enum"],
          message: "is not one of enum values: " + schema["enum"].map(String).join(",")
        });
      }
      return result;
    };
    validators["const"] = function validateEnum(instance, schema, options, ctx) {
      if (instance === void 0) {
        return null;
      }
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (!helpers.deepCompareStrict(schema["const"], instance)) {
        result.addError({
          name: "const",
          argument: schema["const"],
          message: "does not exactly match expected constant: " + schema["const"]
        });
      }
      return result;
    };
    validators.not = validators.disallow = function validateNot(instance, schema, options, ctx) {
      var self = this;
      if (instance === void 0)
        return null;
      var result = new ValidatorResult(instance, schema, options, ctx);
      var notTypes = schema.not || schema.disallow;
      if (!notTypes)
        return null;
      if (!Array.isArray(notTypes))
        notTypes = [notTypes];
      notTypes.forEach(function(type) {
        if (self.testType(instance, schema, options, ctx, type)) {
          var id = type && (type.$id || type.id);
          var schemaId = id || type;
          result.addError({
            name: "not",
            argument: schemaId,
            message: "is of prohibited type " + schemaId
          });
        }
      });
      return result;
    };
    module2.exports = attribute;
  }
});

// node_modules/aws-cdk-lib/node_modules/jsonschema/lib/scan.js
var require_scan = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/jsonschema/lib/scan.js"(exports, module2) {
    "use strict";
    var urilib = require("url");
    var helpers = require_helpers();
    module2.exports.SchemaScanResult = SchemaScanResult;
    function SchemaScanResult(found, ref) {
      this.id = found;
      this.ref = ref;
    }
    module2.exports.scan = function scan(base, schema) {
      function scanSchema(baseuri, schema2) {
        if (!schema2 || typeof schema2 != "object")
          return;
        if (schema2.$ref) {
          var resolvedUri = urilib.resolve(baseuri, schema2.$ref);
          ref[resolvedUri] = ref[resolvedUri] ? ref[resolvedUri] + 1 : 0;
          return;
        }
        var id = schema2.$id || schema2.id;
        var ourBase = id ? urilib.resolve(baseuri, id) : baseuri;
        if (ourBase) {
          if (ourBase.indexOf("#") < 0)
            ourBase += "#";
          if (found[ourBase]) {
            if (!helpers.deepCompareStrict(found[ourBase], schema2)) {
              throw new Error("Schema <" + ourBase + "> already exists with different definition");
            }
            return found[ourBase];
          }
          found[ourBase] = schema2;
          if (ourBase[ourBase.length - 1] == "#") {
            found[ourBase.substring(0, ourBase.length - 1)] = schema2;
          }
        }
        scanArray(ourBase + "/items", Array.isArray(schema2.items) ? schema2.items : [schema2.items]);
        scanArray(ourBase + "/extends", Array.isArray(schema2.extends) ? schema2.extends : [schema2.extends]);
        scanSchema(ourBase + "/additionalItems", schema2.additionalItems);
        scanObject(ourBase + "/properties", schema2.properties);
        scanSchema(ourBase + "/additionalProperties", schema2.additionalProperties);
        scanObject(ourBase + "/definitions", schema2.definitions);
        scanObject(ourBase + "/patternProperties", schema2.patternProperties);
        scanObject(ourBase + "/dependencies", schema2.dependencies);
        scanArray(ourBase + "/disallow", schema2.disallow);
        scanArray(ourBase + "/allOf", schema2.allOf);
        scanArray(ourBase + "/anyOf", schema2.anyOf);
        scanArray(ourBase + "/oneOf", schema2.oneOf);
        scanSchema(ourBase + "/not", schema2.not);
      }
      function scanArray(baseuri, schemas) {
        if (!Array.isArray(schemas))
          return;
        for (var i = 0; i < schemas.length; i++) {
          scanSchema(baseuri + "/" + i, schemas[i]);
        }
      }
      function scanObject(baseuri, schemas) {
        if (!schemas || typeof schemas != "object")
          return;
        for (var p in schemas) {
          scanSchema(baseuri + "/" + p, schemas[p]);
        }
      }
      var found = {};
      var ref = {};
      scanSchema(base, schema);
      return new SchemaScanResult(found, ref);
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/jsonschema/lib/validator.js
var require_validator = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/jsonschema/lib/validator.js"(exports, module2) {
    "use strict";
    var urilib = require("url");
    var attribute = require_attribute();
    var helpers = require_helpers();
    var scanSchema = require_scan().scan;
    var ValidatorResult = helpers.ValidatorResult;
    var ValidatorResultError = helpers.ValidatorResultError;
    var SchemaError = helpers.SchemaError;
    var SchemaContext = helpers.SchemaContext;
    var anonymousBase = "/";
    var Validator = function Validator2() {
      this.customFormats = Object.create(Validator2.prototype.customFormats);
      this.schemas = {};
      this.unresolvedRefs = [];
      this.types = Object.create(types);
      this.attributes = Object.create(attribute.validators);
    };
    Validator.prototype.customFormats = {};
    Validator.prototype.schemas = null;
    Validator.prototype.types = null;
    Validator.prototype.attributes = null;
    Validator.prototype.unresolvedRefs = null;
    Validator.prototype.addSchema = function addSchema(schema, base) {
      var self = this;
      if (!schema) {
        return null;
      }
      var scan = scanSchema(base || anonymousBase, schema);
      var ourUri = base || schema.$id || schema.id;
      for (var uri in scan.id) {
        this.schemas[uri] = scan.id[uri];
      }
      for (var uri in scan.ref) {
        this.unresolvedRefs.push(uri);
      }
      this.unresolvedRefs = this.unresolvedRefs.filter(function(uri2) {
        return typeof self.schemas[uri2] === "undefined";
      });
      return this.schemas[ourUri];
    };
    Validator.prototype.addSubSchemaArray = function addSubSchemaArray(baseuri, schemas) {
      if (!Array.isArray(schemas))
        return;
      for (var i = 0; i < schemas.length; i++) {
        this.addSubSchema(baseuri, schemas[i]);
      }
    };
    Validator.prototype.addSubSchemaObject = function addSubSchemaArray(baseuri, schemas) {
      if (!schemas || typeof schemas != "object")
        return;
      for (var p in schemas) {
        this.addSubSchema(baseuri, schemas[p]);
      }
    };
    Validator.prototype.setSchemas = function setSchemas(schemas) {
      this.schemas = schemas;
    };
    Validator.prototype.getSchema = function getSchema(urn) {
      return this.schemas[urn];
    };
    Validator.prototype.validate = function validate(instance, schema, options, ctx) {
      if (typeof schema !== "boolean" && typeof schema !== "object" || schema === null) {
        throw new SchemaError("Expected `schema` to be an object or boolean");
      }
      if (!options) {
        options = {};
      }
      var id = schema.$id || schema.id;
      var base = urilib.resolve(options.base || anonymousBase, id || "");
      if (!ctx) {
        ctx = new SchemaContext(schema, options, [], base, Object.create(this.schemas));
        if (!ctx.schemas[base]) {
          ctx.schemas[base] = schema;
        }
        var found = scanSchema(base, schema);
        for (var n in found.id) {
          var sch = found.id[n];
          ctx.schemas[n] = sch;
        }
      }
      if (options.required && instance === void 0) {
        var result = new ValidatorResult(instance, schema, options, ctx);
        result.addError("is required, but is undefined");
        return result;
      }
      var result = this.validateSchema(instance, schema, options, ctx);
      if (!result) {
        throw new Error("Result undefined");
      } else if (options.throwAll && result.errors.length) {
        throw new ValidatorResultError(result);
      }
      return result;
    };
    function shouldResolve(schema) {
      var ref = typeof schema === "string" ? schema : schema.$ref;
      if (typeof ref == "string")
        return ref;
      return false;
    }
    Validator.prototype.validateSchema = function validateSchema(instance, schema, options, ctx) {
      var result = new ValidatorResult(instance, schema, options, ctx);
      if (typeof schema === "boolean") {
        if (schema === true) {
          schema = {};
        } else if (schema === false) {
          schema = { type: [] };
        }
      } else if (!schema) {
        throw new Error("schema is undefined");
      }
      if (schema["extends"]) {
        if (Array.isArray(schema["extends"])) {
          var schemaobj = { schema, ctx };
          schema["extends"].forEach(this.schemaTraverser.bind(this, schemaobj));
          schema = schemaobj.schema;
          schemaobj.schema = null;
          schemaobj.ctx = null;
          schemaobj = null;
        } else {
          schema = helpers.deepMerge(schema, this.superResolve(schema["extends"], ctx));
        }
      }
      var switchSchema = shouldResolve(schema);
      if (switchSchema) {
        var resolved = this.resolve(schema, switchSchema, ctx);
        var subctx = new SchemaContext(resolved.subschema, options, ctx.path, resolved.switchSchema, ctx.schemas);
        return this.validateSchema(instance, resolved.subschema, options, subctx);
      }
      var skipAttributes = options && options.skipAttributes || [];
      for (var key in schema) {
        if (!attribute.ignoreProperties[key] && skipAttributes.indexOf(key) < 0) {
          var validatorErr = null;
          var validator = this.attributes[key];
          if (validator) {
            validatorErr = validator.call(this, instance, schema, options, ctx);
          } else if (options.allowUnknownAttributes === false) {
            throw new SchemaError("Unsupported attribute: " + key, schema);
          }
          if (validatorErr) {
            result.importErrors(validatorErr);
          }
        }
      }
      if (typeof options.rewrite == "function") {
        var value = options.rewrite.call(this, instance, schema, options, ctx);
        result.instance = value;
      }
      return result;
    };
    Validator.prototype.schemaTraverser = function schemaTraverser(schemaobj, s) {
      schemaobj.schema = helpers.deepMerge(schemaobj.schema, this.superResolve(s, schemaobj.ctx));
    };
    Validator.prototype.superResolve = function superResolve(schema, ctx) {
      var ref = shouldResolve(schema);
      if (ref) {
        return this.resolve(schema, ref, ctx).subschema;
      }
      return schema;
    };
    Validator.prototype.resolve = function resolve(schema, switchSchema, ctx) {
      switchSchema = ctx.resolve(switchSchema);
      if (ctx.schemas[switchSchema]) {
        return { subschema: ctx.schemas[switchSchema], switchSchema };
      }
      var parsed = urilib.parse(switchSchema);
      var fragment = parsed && parsed.hash;
      var document = fragment && fragment.length && switchSchema.substr(0, switchSchema.length - fragment.length);
      if (!document || !ctx.schemas[document]) {
        throw new SchemaError("no such schema <" + switchSchema + ">", schema);
      }
      var subschema = helpers.objectGetPath(ctx.schemas[document], fragment.substr(1));
      if (subschema === void 0) {
        throw new SchemaError("no such schema " + fragment + " located in <" + document + ">", schema);
      }
      return { subschema, switchSchema };
    };
    Validator.prototype.testType = function validateType(instance, schema, options, ctx, type) {
      if (type === void 0) {
        return;
      } else if (type === null) {
        throw new SchemaError('Unexpected null in "type" keyword');
      }
      if (typeof this.types[type] == "function") {
        return this.types[type].call(this, instance);
      }
      if (type && typeof type == "object") {
        var res = this.validateSchema(instance, type, options, ctx);
        return res === void 0 || !(res && res.errors.length);
      }
      return true;
    };
    var types = Validator.prototype.types = {};
    types.string = function testString(instance) {
      return typeof instance == "string";
    };
    types.number = function testNumber(instance) {
      return typeof instance == "number" && isFinite(instance);
    };
    types.integer = function testInteger(instance) {
      return typeof instance == "number" && instance % 1 === 0;
    };
    types.boolean = function testBoolean(instance) {
      return typeof instance == "boolean";
    };
    types.array = function testArray(instance) {
      return Array.isArray(instance);
    };
    types["null"] = function testNull(instance) {
      return instance === null;
    };
    types.date = function testDate(instance) {
      return instance instanceof Date;
    };
    types.any = function testAny(instance) {
      return true;
    };
    types.object = function testObject(instance) {
      return instance && typeof instance === "object" && !Array.isArray(instance) && !(instance instanceof Date);
    };
    module2.exports = Validator;
  }
});

// node_modules/aws-cdk-lib/node_modules/jsonschema/lib/index.js
var require_lib = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/jsonschema/lib/index.js"(exports, module2) {
    "use strict";
    var Validator = module2.exports.Validator = require_validator();
    module2.exports.ValidatorResult = require_helpers().ValidatorResult;
    module2.exports.ValidatorResultError = require_helpers().ValidatorResultError;
    module2.exports.ValidationError = require_helpers().ValidationError;
    module2.exports.SchemaError = require_helpers().SchemaError;
    module2.exports.SchemaScanResult = require_scan().SchemaScanResult;
    module2.exports.scan = require_scan().scan;
    module2.exports.validate = function(instance, schema, options) {
      var v = new Validator();
      return v.validate(instance, schema, options);
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/internal/constants.js
var require_constants = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/internal/constants.js"(exports, module2) {
    var SEMVER_SPEC_VERSION = "2.0.0";
    var MAX_LENGTH = 256;
    var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || /* istanbul ignore next */
    9007199254740991;
    var MAX_SAFE_COMPONENT_LENGTH = 16;
    module2.exports = {
      SEMVER_SPEC_VERSION,
      MAX_LENGTH,
      MAX_SAFE_INTEGER,
      MAX_SAFE_COMPONENT_LENGTH
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/internal/debug.js
var require_debug = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/internal/debug.js"(exports, module2) {
    var debug = typeof process === "object" && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG) ? (...args) => console.error("SEMVER", ...args) : () => {
    };
    module2.exports = debug;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/internal/re.js
var require_re = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/internal/re.js"(exports, module2) {
    var { MAX_SAFE_COMPONENT_LENGTH } = require_constants();
    var debug = require_debug();
    exports = module2.exports = {};
    var re = exports.re = [];
    var src = exports.src = [];
    var t = exports.t = {};
    var R = 0;
    var createToken = (name, value, isGlobal) => {
      const index = R++;
      debug(name, index, value);
      t[name] = index;
      src[index] = value;
      re[index] = new RegExp(value, isGlobal ? "g" : void 0);
    };
    createToken("NUMERICIDENTIFIER", "0|[1-9]\\d*");
    createToken("NUMERICIDENTIFIERLOOSE", "[0-9]+");
    createToken("NONNUMERICIDENTIFIER", "\\d*[a-zA-Z-][a-zA-Z0-9-]*");
    createToken("MAINVERSION", `(${src[t.NUMERICIDENTIFIER]})\\.(${src[t.NUMERICIDENTIFIER]})\\.(${src[t.NUMERICIDENTIFIER]})`);
    createToken("MAINVERSIONLOOSE", `(${src[t.NUMERICIDENTIFIERLOOSE]})\\.(${src[t.NUMERICIDENTIFIERLOOSE]})\\.(${src[t.NUMERICIDENTIFIERLOOSE]})`);
    createToken("PRERELEASEIDENTIFIER", `(?:${src[t.NUMERICIDENTIFIER]}|${src[t.NONNUMERICIDENTIFIER]})`);
    createToken("PRERELEASEIDENTIFIERLOOSE", `(?:${src[t.NUMERICIDENTIFIERLOOSE]}|${src[t.NONNUMERICIDENTIFIER]})`);
    createToken("PRERELEASE", `(?:-(${src[t.PRERELEASEIDENTIFIER]}(?:\\.${src[t.PRERELEASEIDENTIFIER]})*))`);
    createToken("PRERELEASELOOSE", `(?:-?(${src[t.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src[t.PRERELEASEIDENTIFIERLOOSE]})*))`);
    createToken("BUILDIDENTIFIER", "[0-9A-Za-z-]+");
    createToken("BUILD", `(?:\\+(${src[t.BUILDIDENTIFIER]}(?:\\.${src[t.BUILDIDENTIFIER]})*))`);
    createToken("FULLPLAIN", `v?${src[t.MAINVERSION]}${src[t.PRERELEASE]}?${src[t.BUILD]}?`);
    createToken("FULL", `^${src[t.FULLPLAIN]}$`);
    createToken("LOOSEPLAIN", `[v=\\s]*${src[t.MAINVERSIONLOOSE]}${src[t.PRERELEASELOOSE]}?${src[t.BUILD]}?`);
    createToken("LOOSE", `^${src[t.LOOSEPLAIN]}$`);
    createToken("GTLT", "((?:<|>)?=?)");
    createToken("XRANGEIDENTIFIERLOOSE", `${src[t.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`);
    createToken("XRANGEIDENTIFIER", `${src[t.NUMERICIDENTIFIER]}|x|X|\\*`);
    createToken("XRANGEPLAIN", `[v=\\s]*(${src[t.XRANGEIDENTIFIER]})(?:\\.(${src[t.XRANGEIDENTIFIER]})(?:\\.(${src[t.XRANGEIDENTIFIER]})(?:${src[t.PRERELEASE]})?${src[t.BUILD]}?)?)?`);
    createToken("XRANGEPLAINLOOSE", `[v=\\s]*(${src[t.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})(?:${src[t.PRERELEASELOOSE]})?${src[t.BUILD]}?)?)?`);
    createToken("XRANGE", `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAIN]}$`);
    createToken("XRANGELOOSE", `^${src[t.GTLT]}\\s*${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("COERCE", `${"(^|[^\\d])(\\d{1,"}${MAX_SAFE_COMPONENT_LENGTH}})(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?(?:$|[^\\d])`);
    createToken("COERCERTL", src[t.COERCE], true);
    createToken("LONETILDE", "(?:~>?)");
    createToken("TILDETRIM", `(\\s*)${src[t.LONETILDE]}\\s+`, true);
    exports.tildeTrimReplace = "$1~";
    createToken("TILDE", `^${src[t.LONETILDE]}${src[t.XRANGEPLAIN]}$`);
    createToken("TILDELOOSE", `^${src[t.LONETILDE]}${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("LONECARET", "(?:\\^)");
    createToken("CARETTRIM", `(\\s*)${src[t.LONECARET]}\\s+`, true);
    exports.caretTrimReplace = "$1^";
    createToken("CARET", `^${src[t.LONECARET]}${src[t.XRANGEPLAIN]}$`);
    createToken("CARETLOOSE", `^${src[t.LONECARET]}${src[t.XRANGEPLAINLOOSE]}$`);
    createToken("COMPARATORLOOSE", `^${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]})$|^$`);
    createToken("COMPARATOR", `^${src[t.GTLT]}\\s*(${src[t.FULLPLAIN]})$|^$`);
    createToken("COMPARATORTRIM", `(\\s*)${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]}|${src[t.XRANGEPLAIN]})`, true);
    exports.comparatorTrimReplace = "$1$2$3";
    createToken("HYPHENRANGE", `^\\s*(${src[t.XRANGEPLAIN]})\\s+-\\s+(${src[t.XRANGEPLAIN]})\\s*$`);
    createToken("HYPHENRANGELOOSE", `^\\s*(${src[t.XRANGEPLAINLOOSE]})\\s+-\\s+(${src[t.XRANGEPLAINLOOSE]})\\s*$`);
    createToken("STAR", "(<|>)?=?\\s*\\*");
    createToken("GTE0", "^\\s*>=\\s*0\\.0\\.0\\s*$");
    createToken("GTE0PRE", "^\\s*>=\\s*0\\.0\\.0-0\\s*$");
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/internal/parse-options.js
var require_parse_options = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/internal/parse-options.js"(exports, module2) {
    var opts = ["includePrerelease", "loose", "rtl"];
    var parseOptions = (options) => !options ? {} : typeof options !== "object" ? { loose: true } : opts.filter((k) => options[k]).reduce((o, k) => {
      o[k] = true;
      return o;
    }, {});
    module2.exports = parseOptions;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/internal/identifiers.js
var require_identifiers = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/internal/identifiers.js"(exports, module2) {
    var numeric = /^[0-9]+$/;
    var compareIdentifiers = (a, b) => {
      const anum = numeric.test(a);
      const bnum = numeric.test(b);
      if (anum && bnum) {
        a = +a;
        b = +b;
      }
      return a === b ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a < b ? -1 : 1;
    };
    var rcompareIdentifiers = (a, b) => compareIdentifiers(b, a);
    module2.exports = {
      compareIdentifiers,
      rcompareIdentifiers
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/classes/semver.js
var require_semver = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/classes/semver.js"(exports, module2) {
    var debug = require_debug();
    var { MAX_LENGTH, MAX_SAFE_INTEGER } = require_constants();
    var { re, t } = require_re();
    var parseOptions = require_parse_options();
    var { compareIdentifiers } = require_identifiers();
    var SemVer = class {
      constructor(version, options) {
        options = parseOptions(options);
        if (version instanceof SemVer) {
          if (version.loose === !!options.loose && version.includePrerelease === !!options.includePrerelease) {
            return version;
          } else {
            version = version.version;
          }
        } else if (typeof version !== "string") {
          throw new TypeError(`Invalid Version: ${version}`);
        }
        if (version.length > MAX_LENGTH) {
          throw new TypeError(
            `version is longer than ${MAX_LENGTH} characters`
          );
        }
        debug("SemVer", version, options);
        this.options = options;
        this.loose = !!options.loose;
        this.includePrerelease = !!options.includePrerelease;
        const m = version.trim().match(options.loose ? re[t.LOOSE] : re[t.FULL]);
        if (!m) {
          throw new TypeError(`Invalid Version: ${version}`);
        }
        this.raw = version;
        this.major = +m[1];
        this.minor = +m[2];
        this.patch = +m[3];
        if (this.major > MAX_SAFE_INTEGER || this.major < 0) {
          throw new TypeError("Invalid major version");
        }
        if (this.minor > MAX_SAFE_INTEGER || this.minor < 0) {
          throw new TypeError("Invalid minor version");
        }
        if (this.patch > MAX_SAFE_INTEGER || this.patch < 0) {
          throw new TypeError("Invalid patch version");
        }
        if (!m[4]) {
          this.prerelease = [];
        } else {
          this.prerelease = m[4].split(".").map((id) => {
            if (/^[0-9]+$/.test(id)) {
              const num = +id;
              if (num >= 0 && num < MAX_SAFE_INTEGER) {
                return num;
              }
            }
            return id;
          });
        }
        this.build = m[5] ? m[5].split(".") : [];
        this.format();
      }
      format() {
        this.version = `${this.major}.${this.minor}.${this.patch}`;
        if (this.prerelease.length) {
          this.version += `-${this.prerelease.join(".")}`;
        }
        return this.version;
      }
      toString() {
        return this.version;
      }
      compare(other) {
        debug("SemVer.compare", this.version, this.options, other);
        if (!(other instanceof SemVer)) {
          if (typeof other === "string" && other === this.version) {
            return 0;
          }
          other = new SemVer(other, this.options);
        }
        if (other.version === this.version) {
          return 0;
        }
        return this.compareMain(other) || this.comparePre(other);
      }
      compareMain(other) {
        if (!(other instanceof SemVer)) {
          other = new SemVer(other, this.options);
        }
        return compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
      }
      comparePre(other) {
        if (!(other instanceof SemVer)) {
          other = new SemVer(other, this.options);
        }
        if (this.prerelease.length && !other.prerelease.length) {
          return -1;
        } else if (!this.prerelease.length && other.prerelease.length) {
          return 1;
        } else if (!this.prerelease.length && !other.prerelease.length) {
          return 0;
        }
        let i = 0;
        do {
          const a = this.prerelease[i];
          const b = other.prerelease[i];
          debug("prerelease compare", i, a, b);
          if (a === void 0 && b === void 0) {
            return 0;
          } else if (b === void 0) {
            return 1;
          } else if (a === void 0) {
            return -1;
          } else if (a === b) {
            continue;
          } else {
            return compareIdentifiers(a, b);
          }
        } while (++i);
      }
      compareBuild(other) {
        if (!(other instanceof SemVer)) {
          other = new SemVer(other, this.options);
        }
        let i = 0;
        do {
          const a = this.build[i];
          const b = other.build[i];
          debug("prerelease compare", i, a, b);
          if (a === void 0 && b === void 0) {
            return 0;
          } else if (b === void 0) {
            return 1;
          } else if (a === void 0) {
            return -1;
          } else if (a === b) {
            continue;
          } else {
            return compareIdentifiers(a, b);
          }
        } while (++i);
      }
      // preminor will bump the version up to the next minor release, and immediately
      // down to pre-release. premajor and prepatch work the same way.
      inc(release, identifier) {
        switch (release) {
          case "premajor":
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor = 0;
            this.major++;
            this.inc("pre", identifier);
            break;
          case "preminor":
            this.prerelease.length = 0;
            this.patch = 0;
            this.minor++;
            this.inc("pre", identifier);
            break;
          case "prepatch":
            this.prerelease.length = 0;
            this.inc("patch", identifier);
            this.inc("pre", identifier);
            break;
          case "prerelease":
            if (this.prerelease.length === 0) {
              this.inc("patch", identifier);
            }
            this.inc("pre", identifier);
            break;
          case "major":
            if (this.minor !== 0 || this.patch !== 0 || this.prerelease.length === 0) {
              this.major++;
            }
            this.minor = 0;
            this.patch = 0;
            this.prerelease = [];
            break;
          case "minor":
            if (this.patch !== 0 || this.prerelease.length === 0) {
              this.minor++;
            }
            this.patch = 0;
            this.prerelease = [];
            break;
          case "patch":
            if (this.prerelease.length === 0) {
              this.patch++;
            }
            this.prerelease = [];
            break;
          case "pre":
            if (this.prerelease.length === 0) {
              this.prerelease = [0];
            } else {
              let i = this.prerelease.length;
              while (--i >= 0) {
                if (typeof this.prerelease[i] === "number") {
                  this.prerelease[i]++;
                  i = -2;
                }
              }
              if (i === -1) {
                this.prerelease.push(0);
              }
            }
            if (identifier) {
              if (compareIdentifiers(this.prerelease[0], identifier) === 0) {
                if (isNaN(this.prerelease[1])) {
                  this.prerelease = [identifier, 0];
                }
              } else {
                this.prerelease = [identifier, 0];
              }
            }
            break;
          default:
            throw new Error(`invalid increment argument: ${release}`);
        }
        this.format();
        this.raw = this.version;
        return this;
      }
    };
    module2.exports = SemVer;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/parse.js
var require_parse = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/parse.js"(exports, module2) {
    var { MAX_LENGTH } = require_constants();
    var { re, t } = require_re();
    var SemVer = require_semver();
    var parseOptions = require_parse_options();
    var parse = (version, options) => {
      options = parseOptions(options);
      if (version instanceof SemVer) {
        return version;
      }
      if (typeof version !== "string") {
        return null;
      }
      if (version.length > MAX_LENGTH) {
        return null;
      }
      const r = options.loose ? re[t.LOOSE] : re[t.FULL];
      if (!r.test(version)) {
        return null;
      }
      try {
        return new SemVer(version, options);
      } catch (er) {
        return null;
      }
    };
    module2.exports = parse;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/valid.js
var require_valid = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/valid.js"(exports, module2) {
    var parse = require_parse();
    var valid = (version, options) => {
      const v = parse(version, options);
      return v ? v.version : null;
    };
    module2.exports = valid;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/clean.js
var require_clean = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/clean.js"(exports, module2) {
    var parse = require_parse();
    var clean = (version, options) => {
      const s = parse(version.trim().replace(/^[=v]+/, ""), options);
      return s ? s.version : null;
    };
    module2.exports = clean;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/inc.js
var require_inc = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/inc.js"(exports, module2) {
    var SemVer = require_semver();
    var inc = (version, release, options, identifier) => {
      if (typeof options === "string") {
        identifier = options;
        options = void 0;
      }
      try {
        return new SemVer(
          version instanceof SemVer ? version.version : version,
          options
        ).inc(release, identifier).version;
      } catch (er) {
        return null;
      }
    };
    module2.exports = inc;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/compare.js
var require_compare = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/compare.js"(exports, module2) {
    var SemVer = require_semver();
    var compare = (a, b, loose) => new SemVer(a, loose).compare(new SemVer(b, loose));
    module2.exports = compare;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/eq.js
var require_eq = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/eq.js"(exports, module2) {
    var compare = require_compare();
    var eq = (a, b, loose) => compare(a, b, loose) === 0;
    module2.exports = eq;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/diff.js
var require_diff = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/diff.js"(exports, module2) {
    var parse = require_parse();
    var eq = require_eq();
    var diff = (version1, version2) => {
      if (eq(version1, version2)) {
        return null;
      } else {
        const v1 = parse(version1);
        const v2 = parse(version2);
        const hasPre = v1.prerelease.length || v2.prerelease.length;
        const prefix = hasPre ? "pre" : "";
        const defaultResult = hasPre ? "prerelease" : "";
        for (const key in v1) {
          if (key === "major" || key === "minor" || key === "patch") {
            if (v1[key] !== v2[key]) {
              return prefix + key;
            }
          }
        }
        return defaultResult;
      }
    };
    module2.exports = diff;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/major.js
var require_major = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/major.js"(exports, module2) {
    var SemVer = require_semver();
    var major = (a, loose) => new SemVer(a, loose).major;
    module2.exports = major;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/minor.js
var require_minor = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/minor.js"(exports, module2) {
    var SemVer = require_semver();
    var minor = (a, loose) => new SemVer(a, loose).minor;
    module2.exports = minor;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/patch.js
var require_patch = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/patch.js"(exports, module2) {
    var SemVer = require_semver();
    var patch = (a, loose) => new SemVer(a, loose).patch;
    module2.exports = patch;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/prerelease.js
var require_prerelease = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/prerelease.js"(exports, module2) {
    var parse = require_parse();
    var prerelease = (version, options) => {
      const parsed = parse(version, options);
      return parsed && parsed.prerelease.length ? parsed.prerelease : null;
    };
    module2.exports = prerelease;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/rcompare.js
var require_rcompare = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/rcompare.js"(exports, module2) {
    var compare = require_compare();
    var rcompare = (a, b, loose) => compare(b, a, loose);
    module2.exports = rcompare;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/compare-loose.js
var require_compare_loose = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/compare-loose.js"(exports, module2) {
    var compare = require_compare();
    var compareLoose = (a, b) => compare(a, b, true);
    module2.exports = compareLoose;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/compare-build.js
var require_compare_build = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/compare-build.js"(exports, module2) {
    var SemVer = require_semver();
    var compareBuild = (a, b, loose) => {
      const versionA = new SemVer(a, loose);
      const versionB = new SemVer(b, loose);
      return versionA.compare(versionB) || versionA.compareBuild(versionB);
    };
    module2.exports = compareBuild;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/sort.js
var require_sort = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/sort.js"(exports, module2) {
    var compareBuild = require_compare_build();
    var sort = (list, loose) => list.sort((a, b) => compareBuild(a, b, loose));
    module2.exports = sort;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/rsort.js
var require_rsort = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/rsort.js"(exports, module2) {
    var compareBuild = require_compare_build();
    var rsort = (list, loose) => list.sort((a, b) => compareBuild(b, a, loose));
    module2.exports = rsort;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/gt.js
var require_gt = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/gt.js"(exports, module2) {
    var compare = require_compare();
    var gt = (a, b, loose) => compare(a, b, loose) > 0;
    module2.exports = gt;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/lt.js
var require_lt = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/lt.js"(exports, module2) {
    var compare = require_compare();
    var lt = (a, b, loose) => compare(a, b, loose) < 0;
    module2.exports = lt;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/neq.js
var require_neq = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/neq.js"(exports, module2) {
    var compare = require_compare();
    var neq = (a, b, loose) => compare(a, b, loose) !== 0;
    module2.exports = neq;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/gte.js
var require_gte = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/gte.js"(exports, module2) {
    var compare = require_compare();
    var gte = (a, b, loose) => compare(a, b, loose) >= 0;
    module2.exports = gte;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/lte.js
var require_lte = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/lte.js"(exports, module2) {
    var compare = require_compare();
    var lte = (a, b, loose) => compare(a, b, loose) <= 0;
    module2.exports = lte;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/cmp.js
var require_cmp = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/cmp.js"(exports, module2) {
    var eq = require_eq();
    var neq = require_neq();
    var gt = require_gt();
    var gte = require_gte();
    var lt = require_lt();
    var lte = require_lte();
    var cmp = (a, op, b, loose) => {
      switch (op) {
        case "===":
          if (typeof a === "object") {
            a = a.version;
          }
          if (typeof b === "object") {
            b = b.version;
          }
          return a === b;
        case "!==":
          if (typeof a === "object") {
            a = a.version;
          }
          if (typeof b === "object") {
            b = b.version;
          }
          return a !== b;
        case "":
        case "=":
        case "==":
          return eq(a, b, loose);
        case "!=":
          return neq(a, b, loose);
        case ">":
          return gt(a, b, loose);
        case ">=":
          return gte(a, b, loose);
        case "<":
          return lt(a, b, loose);
        case "<=":
          return lte(a, b, loose);
        default:
          throw new TypeError(`Invalid operator: ${op}`);
      }
    };
    module2.exports = cmp;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/coerce.js
var require_coerce = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/coerce.js"(exports, module2) {
    var SemVer = require_semver();
    var parse = require_parse();
    var { re, t } = require_re();
    var coerce = (version, options) => {
      if (version instanceof SemVer) {
        return version;
      }
      if (typeof version === "number") {
        version = String(version);
      }
      if (typeof version !== "string") {
        return null;
      }
      options = options || {};
      let match = null;
      if (!options.rtl) {
        match = version.match(re[t.COERCE]);
      } else {
        let next;
        while ((next = re[t.COERCERTL].exec(version)) && (!match || match.index + match[0].length !== version.length)) {
          if (!match || next.index + next[0].length !== match.index + match[0].length) {
            match = next;
          }
          re[t.COERCERTL].lastIndex = next.index + next[1].length + next[2].length;
        }
        re[t.COERCERTL].lastIndex = -1;
      }
      if (match === null) {
        return null;
      }
      return parse(`${match[2]}.${match[3] || "0"}.${match[4] || "0"}`, options);
    };
    module2.exports = coerce;
  }
});

// node_modules/aws-cdk-lib/node_modules/yallist/iterator.js
var require_iterator = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/yallist/iterator.js"(exports, module2) {
    "use strict";
    module2.exports = function(Yallist) {
      Yallist.prototype[Symbol.iterator] = function* () {
        for (let walker = this.head; walker; walker = walker.next) {
          yield walker.value;
        }
      };
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/yallist/yallist.js
var require_yallist = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/yallist/yallist.js"(exports, module2) {
    "use strict";
    module2.exports = Yallist;
    Yallist.Node = Node;
    Yallist.create = Yallist;
    function Yallist(list) {
      var self = this;
      if (!(self instanceof Yallist)) {
        self = new Yallist();
      }
      self.tail = null;
      self.head = null;
      self.length = 0;
      if (list && typeof list.forEach === "function") {
        list.forEach(function(item) {
          self.push(item);
        });
      } else if (arguments.length > 0) {
        for (var i = 0, l = arguments.length; i < l; i++) {
          self.push(arguments[i]);
        }
      }
      return self;
    }
    Yallist.prototype.removeNode = function(node) {
      if (node.list !== this) {
        throw new Error("removing node which does not belong to this list");
      }
      var next = node.next;
      var prev = node.prev;
      if (next) {
        next.prev = prev;
      }
      if (prev) {
        prev.next = next;
      }
      if (node === this.head) {
        this.head = next;
      }
      if (node === this.tail) {
        this.tail = prev;
      }
      node.list.length--;
      node.next = null;
      node.prev = null;
      node.list = null;
      return next;
    };
    Yallist.prototype.unshiftNode = function(node) {
      if (node === this.head) {
        return;
      }
      if (node.list) {
        node.list.removeNode(node);
      }
      var head = this.head;
      node.list = this;
      node.next = head;
      if (head) {
        head.prev = node;
      }
      this.head = node;
      if (!this.tail) {
        this.tail = node;
      }
      this.length++;
    };
    Yallist.prototype.pushNode = function(node) {
      if (node === this.tail) {
        return;
      }
      if (node.list) {
        node.list.removeNode(node);
      }
      var tail = this.tail;
      node.list = this;
      node.prev = tail;
      if (tail) {
        tail.next = node;
      }
      this.tail = node;
      if (!this.head) {
        this.head = node;
      }
      this.length++;
    };
    Yallist.prototype.push = function() {
      for (var i = 0, l = arguments.length; i < l; i++) {
        push(this, arguments[i]);
      }
      return this.length;
    };
    Yallist.prototype.unshift = function() {
      for (var i = 0, l = arguments.length; i < l; i++) {
        unshift(this, arguments[i]);
      }
      return this.length;
    };
    Yallist.prototype.pop = function() {
      if (!this.tail) {
        return void 0;
      }
      var res = this.tail.value;
      this.tail = this.tail.prev;
      if (this.tail) {
        this.tail.next = null;
      } else {
        this.head = null;
      }
      this.length--;
      return res;
    };
    Yallist.prototype.shift = function() {
      if (!this.head) {
        return void 0;
      }
      var res = this.head.value;
      this.head = this.head.next;
      if (this.head) {
        this.head.prev = null;
      } else {
        this.tail = null;
      }
      this.length--;
      return res;
    };
    Yallist.prototype.forEach = function(fn, thisp) {
      thisp = thisp || this;
      for (var walker = this.head, i = 0; walker !== null; i++) {
        fn.call(thisp, walker.value, i, this);
        walker = walker.next;
      }
    };
    Yallist.prototype.forEachReverse = function(fn, thisp) {
      thisp = thisp || this;
      for (var walker = this.tail, i = this.length - 1; walker !== null; i--) {
        fn.call(thisp, walker.value, i, this);
        walker = walker.prev;
      }
    };
    Yallist.prototype.get = function(n) {
      for (var i = 0, walker = this.head; walker !== null && i < n; i++) {
        walker = walker.next;
      }
      if (i === n && walker !== null) {
        return walker.value;
      }
    };
    Yallist.prototype.getReverse = function(n) {
      for (var i = 0, walker = this.tail; walker !== null && i < n; i++) {
        walker = walker.prev;
      }
      if (i === n && walker !== null) {
        return walker.value;
      }
    };
    Yallist.prototype.map = function(fn, thisp) {
      thisp = thisp || this;
      var res = new Yallist();
      for (var walker = this.head; walker !== null; ) {
        res.push(fn.call(thisp, walker.value, this));
        walker = walker.next;
      }
      return res;
    };
    Yallist.prototype.mapReverse = function(fn, thisp) {
      thisp = thisp || this;
      var res = new Yallist();
      for (var walker = this.tail; walker !== null; ) {
        res.push(fn.call(thisp, walker.value, this));
        walker = walker.prev;
      }
      return res;
    };
    Yallist.prototype.reduce = function(fn, initial) {
      var acc;
      var walker = this.head;
      if (arguments.length > 1) {
        acc = initial;
      } else if (this.head) {
        walker = this.head.next;
        acc = this.head.value;
      } else {
        throw new TypeError("Reduce of empty list with no initial value");
      }
      for (var i = 0; walker !== null; i++) {
        acc = fn(acc, walker.value, i);
        walker = walker.next;
      }
      return acc;
    };
    Yallist.prototype.reduceReverse = function(fn, initial) {
      var acc;
      var walker = this.tail;
      if (arguments.length > 1) {
        acc = initial;
      } else if (this.tail) {
        walker = this.tail.prev;
        acc = this.tail.value;
      } else {
        throw new TypeError("Reduce of empty list with no initial value");
      }
      for (var i = this.length - 1; walker !== null; i--) {
        acc = fn(acc, walker.value, i);
        walker = walker.prev;
      }
      return acc;
    };
    Yallist.prototype.toArray = function() {
      var arr = new Array(this.length);
      for (var i = 0, walker = this.head; walker !== null; i++) {
        arr[i] = walker.value;
        walker = walker.next;
      }
      return arr;
    };
    Yallist.prototype.toArrayReverse = function() {
      var arr = new Array(this.length);
      for (var i = 0, walker = this.tail; walker !== null; i++) {
        arr[i] = walker.value;
        walker = walker.prev;
      }
      return arr;
    };
    Yallist.prototype.slice = function(from, to) {
      to = to || this.length;
      if (to < 0) {
        to += this.length;
      }
      from = from || 0;
      if (from < 0) {
        from += this.length;
      }
      var ret = new Yallist();
      if (to < from || to < 0) {
        return ret;
      }
      if (from < 0) {
        from = 0;
      }
      if (to > this.length) {
        to = this.length;
      }
      for (var i = 0, walker = this.head; walker !== null && i < from; i++) {
        walker = walker.next;
      }
      for (; walker !== null && i < to; i++, walker = walker.next) {
        ret.push(walker.value);
      }
      return ret;
    };
    Yallist.prototype.sliceReverse = function(from, to) {
      to = to || this.length;
      if (to < 0) {
        to += this.length;
      }
      from = from || 0;
      if (from < 0) {
        from += this.length;
      }
      var ret = new Yallist();
      if (to < from || to < 0) {
        return ret;
      }
      if (from < 0) {
        from = 0;
      }
      if (to > this.length) {
        to = this.length;
      }
      for (var i = this.length, walker = this.tail; walker !== null && i > to; i--) {
        walker = walker.prev;
      }
      for (; walker !== null && i > from; i--, walker = walker.prev) {
        ret.push(walker.value);
      }
      return ret;
    };
    Yallist.prototype.splice = function(start, deleteCount, ...nodes) {
      if (start > this.length) {
        start = this.length - 1;
      }
      if (start < 0) {
        start = this.length + start;
      }
      for (var i = 0, walker = this.head; walker !== null && i < start; i++) {
        walker = walker.next;
      }
      var ret = [];
      for (var i = 0; walker && i < deleteCount; i++) {
        ret.push(walker.value);
        walker = this.removeNode(walker);
      }
      if (walker === null) {
        walker = this.tail;
      }
      if (walker !== this.head && walker !== this.tail) {
        walker = walker.prev;
      }
      for (var i = 0; i < nodes.length; i++) {
        walker = insert(this, walker, nodes[i]);
      }
      return ret;
    };
    Yallist.prototype.reverse = function() {
      var head = this.head;
      var tail = this.tail;
      for (var walker = head; walker !== null; walker = walker.prev) {
        var p = walker.prev;
        walker.prev = walker.next;
        walker.next = p;
      }
      this.head = tail;
      this.tail = head;
      return this;
    };
    function insert(self, node, value) {
      var inserted = node === self.head ? new Node(value, null, node, self) : new Node(value, node, node.next, self);
      if (inserted.next === null) {
        self.tail = inserted;
      }
      if (inserted.prev === null) {
        self.head = inserted;
      }
      self.length++;
      return inserted;
    }
    function push(self, item) {
      self.tail = new Node(item, self.tail, null, self);
      if (!self.head) {
        self.head = self.tail;
      }
      self.length++;
    }
    function unshift(self, item) {
      self.head = new Node(item, null, self.head, self);
      if (!self.tail) {
        self.tail = self.head;
      }
      self.length++;
    }
    function Node(value, prev, next, list) {
      if (!(this instanceof Node)) {
        return new Node(value, prev, next, list);
      }
      this.list = list;
      this.value = value;
      if (prev) {
        prev.next = this;
        this.prev = prev;
      } else {
        this.prev = null;
      }
      if (next) {
        next.prev = this;
        this.next = next;
      } else {
        this.next = null;
      }
    }
    try {
      require_iterator()(Yallist);
    } catch (er) {
    }
  }
});

// node_modules/aws-cdk-lib/node_modules/lru-cache/index.js
var require_lru_cache = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/lru-cache/index.js"(exports, module2) {
    "use strict";
    var Yallist = require_yallist();
    var MAX = Symbol("max");
    var LENGTH = Symbol("length");
    var LENGTH_CALCULATOR = Symbol("lengthCalculator");
    var ALLOW_STALE = Symbol("allowStale");
    var MAX_AGE = Symbol("maxAge");
    var DISPOSE = Symbol("dispose");
    var NO_DISPOSE_ON_SET = Symbol("noDisposeOnSet");
    var LRU_LIST = Symbol("lruList");
    var CACHE = Symbol("cache");
    var UPDATE_AGE_ON_GET = Symbol("updateAgeOnGet");
    var naiveLength = () => 1;
    var LRUCache = class {
      constructor(options) {
        if (typeof options === "number")
          options = { max: options };
        if (!options)
          options = {};
        if (options.max && (typeof options.max !== "number" || options.max < 0))
          throw new TypeError("max must be a non-negative number");
        const max = this[MAX] = options.max || Infinity;
        const lc = options.length || naiveLength;
        this[LENGTH_CALCULATOR] = typeof lc !== "function" ? naiveLength : lc;
        this[ALLOW_STALE] = options.stale || false;
        if (options.maxAge && typeof options.maxAge !== "number")
          throw new TypeError("maxAge must be a number");
        this[MAX_AGE] = options.maxAge || 0;
        this[DISPOSE] = options.dispose;
        this[NO_DISPOSE_ON_SET] = options.noDisposeOnSet || false;
        this[UPDATE_AGE_ON_GET] = options.updateAgeOnGet || false;
        this.reset();
      }
      // resize the cache when the max changes.
      set max(mL) {
        if (typeof mL !== "number" || mL < 0)
          throw new TypeError("max must be a non-negative number");
        this[MAX] = mL || Infinity;
        trim(this);
      }
      get max() {
        return this[MAX];
      }
      set allowStale(allowStale) {
        this[ALLOW_STALE] = !!allowStale;
      }
      get allowStale() {
        return this[ALLOW_STALE];
      }
      set maxAge(mA) {
        if (typeof mA !== "number")
          throw new TypeError("maxAge must be a non-negative number");
        this[MAX_AGE] = mA;
        trim(this);
      }
      get maxAge() {
        return this[MAX_AGE];
      }
      // resize the cache when the lengthCalculator changes.
      set lengthCalculator(lC) {
        if (typeof lC !== "function")
          lC = naiveLength;
        if (lC !== this[LENGTH_CALCULATOR]) {
          this[LENGTH_CALCULATOR] = lC;
          this[LENGTH] = 0;
          this[LRU_LIST].forEach((hit) => {
            hit.length = this[LENGTH_CALCULATOR](hit.value, hit.key);
            this[LENGTH] += hit.length;
          });
        }
        trim(this);
      }
      get lengthCalculator() {
        return this[LENGTH_CALCULATOR];
      }
      get length() {
        return this[LENGTH];
      }
      get itemCount() {
        return this[LRU_LIST].length;
      }
      rforEach(fn, thisp) {
        thisp = thisp || this;
        for (let walker = this[LRU_LIST].tail; walker !== null; ) {
          const prev = walker.prev;
          forEachStep(this, fn, walker, thisp);
          walker = prev;
        }
      }
      forEach(fn, thisp) {
        thisp = thisp || this;
        for (let walker = this[LRU_LIST].head; walker !== null; ) {
          const next = walker.next;
          forEachStep(this, fn, walker, thisp);
          walker = next;
        }
      }
      keys() {
        return this[LRU_LIST].toArray().map((k) => k.key);
      }
      values() {
        return this[LRU_LIST].toArray().map((k) => k.value);
      }
      reset() {
        if (this[DISPOSE] && this[LRU_LIST] && this[LRU_LIST].length) {
          this[LRU_LIST].forEach((hit) => this[DISPOSE](hit.key, hit.value));
        }
        this[CACHE] = /* @__PURE__ */ new Map();
        this[LRU_LIST] = new Yallist();
        this[LENGTH] = 0;
      }
      dump() {
        return this[LRU_LIST].map((hit) => isStale(this, hit) ? false : {
          k: hit.key,
          v: hit.value,
          e: hit.now + (hit.maxAge || 0)
        }).toArray().filter((h) => h);
      }
      dumpLru() {
        return this[LRU_LIST];
      }
      set(key, value, maxAge) {
        maxAge = maxAge || this[MAX_AGE];
        if (maxAge && typeof maxAge !== "number")
          throw new TypeError("maxAge must be a number");
        const now = maxAge ? Date.now() : 0;
        const len = this[LENGTH_CALCULATOR](value, key);
        if (this[CACHE].has(key)) {
          if (len > this[MAX]) {
            del(this, this[CACHE].get(key));
            return false;
          }
          const node = this[CACHE].get(key);
          const item = node.value;
          if (this[DISPOSE]) {
            if (!this[NO_DISPOSE_ON_SET])
              this[DISPOSE](key, item.value);
          }
          item.now = now;
          item.maxAge = maxAge;
          item.value = value;
          this[LENGTH] += len - item.length;
          item.length = len;
          this.get(key);
          trim(this);
          return true;
        }
        const hit = new Entry(key, value, len, now, maxAge);
        if (hit.length > this[MAX]) {
          if (this[DISPOSE])
            this[DISPOSE](key, value);
          return false;
        }
        this[LENGTH] += hit.length;
        this[LRU_LIST].unshift(hit);
        this[CACHE].set(key, this[LRU_LIST].head);
        trim(this);
        return true;
      }
      has(key) {
        if (!this[CACHE].has(key))
          return false;
        const hit = this[CACHE].get(key).value;
        return !isStale(this, hit);
      }
      get(key) {
        return get(this, key, true);
      }
      peek(key) {
        return get(this, key, false);
      }
      pop() {
        const node = this[LRU_LIST].tail;
        if (!node)
          return null;
        del(this, node);
        return node.value;
      }
      del(key) {
        del(this, this[CACHE].get(key));
      }
      load(arr) {
        this.reset();
        const now = Date.now();
        for (let l = arr.length - 1; l >= 0; l--) {
          const hit = arr[l];
          const expiresAt = hit.e || 0;
          if (expiresAt === 0)
            this.set(hit.k, hit.v);
          else {
            const maxAge = expiresAt - now;
            if (maxAge > 0) {
              this.set(hit.k, hit.v, maxAge);
            }
          }
        }
      }
      prune() {
        this[CACHE].forEach((value, key) => get(this, key, false));
      }
    };
    var get = (self, key, doUse) => {
      const node = self[CACHE].get(key);
      if (node) {
        const hit = node.value;
        if (isStale(self, hit)) {
          del(self, node);
          if (!self[ALLOW_STALE])
            return void 0;
        } else {
          if (doUse) {
            if (self[UPDATE_AGE_ON_GET])
              node.value.now = Date.now();
            self[LRU_LIST].unshiftNode(node);
          }
        }
        return hit.value;
      }
    };
    var isStale = (self, hit) => {
      if (!hit || !hit.maxAge && !self[MAX_AGE])
        return false;
      const diff = Date.now() - hit.now;
      return hit.maxAge ? diff > hit.maxAge : self[MAX_AGE] && diff > self[MAX_AGE];
    };
    var trim = (self) => {
      if (self[LENGTH] > self[MAX]) {
        for (let walker = self[LRU_LIST].tail; self[LENGTH] > self[MAX] && walker !== null; ) {
          const prev = walker.prev;
          del(self, walker);
          walker = prev;
        }
      }
    };
    var del = (self, node) => {
      if (node) {
        const hit = node.value;
        if (self[DISPOSE])
          self[DISPOSE](hit.key, hit.value);
        self[LENGTH] -= hit.length;
        self[CACHE].delete(hit.key);
        self[LRU_LIST].removeNode(node);
      }
    };
    var Entry = class {
      constructor(key, value, length, now, maxAge) {
        this.key = key;
        this.value = value;
        this.length = length;
        this.now = now;
        this.maxAge = maxAge || 0;
      }
    };
    var forEachStep = (self, fn, node, thisp) => {
      let hit = node.value;
      if (isStale(self, hit)) {
        del(self, node);
        if (!self[ALLOW_STALE])
          hit = void 0;
      }
      if (hit)
        fn.call(thisp, hit.value, hit.key, self);
    };
    module2.exports = LRUCache;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/classes/range.js
var require_range = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/classes/range.js"(exports, module2) {
    var Range = class {
      constructor(range, options) {
        options = parseOptions(options);
        if (range instanceof Range) {
          if (range.loose === !!options.loose && range.includePrerelease === !!options.includePrerelease) {
            return range;
          } else {
            return new Range(range.raw, options);
          }
        }
        if (range instanceof Comparator) {
          this.raw = range.value;
          this.set = [[range]];
          this.format();
          return this;
        }
        this.options = options;
        this.loose = !!options.loose;
        this.includePrerelease = !!options.includePrerelease;
        this.raw = range;
        this.set = range.split("||").map((r) => this.parseRange(r.trim())).filter((c) => c.length);
        if (!this.set.length) {
          throw new TypeError(`Invalid SemVer Range: ${range}`);
        }
        if (this.set.length > 1) {
          const first = this.set[0];
          this.set = this.set.filter((c) => !isNullSet(c[0]));
          if (this.set.length === 0) {
            this.set = [first];
          } else if (this.set.length > 1) {
            for (const c of this.set) {
              if (c.length === 1 && isAny(c[0])) {
                this.set = [c];
                break;
              }
            }
          }
        }
        this.format();
      }
      format() {
        this.range = this.set.map((comps) => {
          return comps.join(" ").trim();
        }).join("||").trim();
        return this.range;
      }
      toString() {
        return this.range;
      }
      parseRange(range) {
        range = range.trim();
        const memoOpts = Object.keys(this.options).join(",");
        const memoKey = `parseRange:${memoOpts}:${range}`;
        const cached = cache.get(memoKey);
        if (cached) {
          return cached;
        }
        const loose = this.options.loose;
        const hr = loose ? re[t.HYPHENRANGELOOSE] : re[t.HYPHENRANGE];
        range = range.replace(hr, hyphenReplace(this.options.includePrerelease));
        debug("hyphen replace", range);
        range = range.replace(re[t.COMPARATORTRIM], comparatorTrimReplace);
        debug("comparator trim", range);
        range = range.replace(re[t.TILDETRIM], tildeTrimReplace);
        range = range.replace(re[t.CARETTRIM], caretTrimReplace);
        range = range.split(/\s+/).join(" ");
        let rangeList = range.split(" ").map((comp) => parseComparator(comp, this.options)).join(" ").split(/\s+/).map((comp) => replaceGTE0(comp, this.options));
        if (loose) {
          rangeList = rangeList.filter((comp) => {
            debug("loose invalid filter", comp, this.options);
            return !!comp.match(re[t.COMPARATORLOOSE]);
          });
        }
        debug("range list", rangeList);
        const rangeMap = /* @__PURE__ */ new Map();
        const comparators = rangeList.map((comp) => new Comparator(comp, this.options));
        for (const comp of comparators) {
          if (isNullSet(comp)) {
            return [comp];
          }
          rangeMap.set(comp.value, comp);
        }
        if (rangeMap.size > 1 && rangeMap.has("")) {
          rangeMap.delete("");
        }
        const result = [...rangeMap.values()];
        cache.set(memoKey, result);
        return result;
      }
      intersects(range, options) {
        if (!(range instanceof Range)) {
          throw new TypeError("a Range is required");
        }
        return this.set.some((thisComparators) => {
          return isSatisfiable(thisComparators, options) && range.set.some((rangeComparators) => {
            return isSatisfiable(rangeComparators, options) && thisComparators.every((thisComparator) => {
              return rangeComparators.every((rangeComparator) => {
                return thisComparator.intersects(rangeComparator, options);
              });
            });
          });
        });
      }
      // if ANY of the sets match ALL of its comparators, then pass
      test(version) {
        if (!version) {
          return false;
        }
        if (typeof version === "string") {
          try {
            version = new SemVer(version, this.options);
          } catch (er) {
            return false;
          }
        }
        for (let i = 0; i < this.set.length; i++) {
          if (testSet(this.set[i], version, this.options)) {
            return true;
          }
        }
        return false;
      }
    };
    module2.exports = Range;
    var LRU = require_lru_cache();
    var cache = new LRU({ max: 1e3 });
    var parseOptions = require_parse_options();
    var Comparator = require_comparator();
    var debug = require_debug();
    var SemVer = require_semver();
    var {
      re,
      t,
      comparatorTrimReplace,
      tildeTrimReplace,
      caretTrimReplace
    } = require_re();
    var isNullSet = (c) => c.value === "<0.0.0-0";
    var isAny = (c) => c.value === "";
    var isSatisfiable = (comparators, options) => {
      let result = true;
      const remainingComparators = comparators.slice();
      let testComparator = remainingComparators.pop();
      while (result && remainingComparators.length) {
        result = remainingComparators.every((otherComparator) => {
          return testComparator.intersects(otherComparator, options);
        });
        testComparator = remainingComparators.pop();
      }
      return result;
    };
    var parseComparator = (comp, options) => {
      debug("comp", comp, options);
      comp = replaceCarets(comp, options);
      debug("caret", comp);
      comp = replaceTildes(comp, options);
      debug("tildes", comp);
      comp = replaceXRanges(comp, options);
      debug("xrange", comp);
      comp = replaceStars(comp, options);
      debug("stars", comp);
      return comp;
    };
    var isX = (id) => !id || id.toLowerCase() === "x" || id === "*";
    var replaceTildes = (comp, options) => comp.trim().split(/\s+/).map((c) => {
      return replaceTilde(c, options);
    }).join(" ");
    var replaceTilde = (comp, options) => {
      const r = options.loose ? re[t.TILDELOOSE] : re[t.TILDE];
      return comp.replace(r, (_, M, m, p, pr) => {
        debug("tilde", comp, _, M, m, p, pr);
        let ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m)) {
          ret = `>=${M}.0.0 <${+M + 1}.0.0-0`;
        } else if (isX(p)) {
          ret = `>=${M}.${m}.0 <${M}.${+m + 1}.0-0`;
        } else if (pr) {
          debug("replaceTilde pr", pr);
          ret = `>=${M}.${m}.${p}-${pr} <${M}.${+m + 1}.0-0`;
        } else {
          ret = `>=${M}.${m}.${p} <${M}.${+m + 1}.0-0`;
        }
        debug("tilde return", ret);
        return ret;
      });
    };
    var replaceCarets = (comp, options) => comp.trim().split(/\s+/).map((c) => {
      return replaceCaret(c, options);
    }).join(" ");
    var replaceCaret = (comp, options) => {
      debug("caret", comp, options);
      const r = options.loose ? re[t.CARETLOOSE] : re[t.CARET];
      const z = options.includePrerelease ? "-0" : "";
      return comp.replace(r, (_, M, m, p, pr) => {
        debug("caret", comp, _, M, m, p, pr);
        let ret;
        if (isX(M)) {
          ret = "";
        } else if (isX(m)) {
          ret = `>=${M}.0.0${z} <${+M + 1}.0.0-0`;
        } else if (isX(p)) {
          if (M === "0") {
            ret = `>=${M}.${m}.0${z} <${M}.${+m + 1}.0-0`;
          } else {
            ret = `>=${M}.${m}.0${z} <${+M + 1}.0.0-0`;
          }
        } else if (pr) {
          debug("replaceCaret pr", pr);
          if (M === "0") {
            if (m === "0") {
              ret = `>=${M}.${m}.${p}-${pr} <${M}.${m}.${+p + 1}-0`;
            } else {
              ret = `>=${M}.${m}.${p}-${pr} <${M}.${+m + 1}.0-0`;
            }
          } else {
            ret = `>=${M}.${m}.${p}-${pr} <${+M + 1}.0.0-0`;
          }
        } else {
          debug("no pr");
          if (M === "0") {
            if (m === "0") {
              ret = `>=${M}.${m}.${p}${z} <${M}.${m}.${+p + 1}-0`;
            } else {
              ret = `>=${M}.${m}.${p}${z} <${M}.${+m + 1}.0-0`;
            }
          } else {
            ret = `>=${M}.${m}.${p} <${+M + 1}.0.0-0`;
          }
        }
        debug("caret return", ret);
        return ret;
      });
    };
    var replaceXRanges = (comp, options) => {
      debug("replaceXRanges", comp, options);
      return comp.split(/\s+/).map((c) => {
        return replaceXRange(c, options);
      }).join(" ");
    };
    var replaceXRange = (comp, options) => {
      comp = comp.trim();
      const r = options.loose ? re[t.XRANGELOOSE] : re[t.XRANGE];
      return comp.replace(r, (ret, gtlt, M, m, p, pr) => {
        debug("xRange", comp, ret, gtlt, M, m, p, pr);
        const xM = isX(M);
        const xm = xM || isX(m);
        const xp = xm || isX(p);
        const anyX = xp;
        if (gtlt === "=" && anyX) {
          gtlt = "";
        }
        pr = options.includePrerelease ? "-0" : "";
        if (xM) {
          if (gtlt === ">" || gtlt === "<") {
            ret = "<0.0.0-0";
          } else {
            ret = "*";
          }
        } else if (gtlt && anyX) {
          if (xm) {
            m = 0;
          }
          p = 0;
          if (gtlt === ">") {
            gtlt = ">=";
            if (xm) {
              M = +M + 1;
              m = 0;
              p = 0;
            } else {
              m = +m + 1;
              p = 0;
            }
          } else if (gtlt === "<=") {
            gtlt = "<";
            if (xm) {
              M = +M + 1;
            } else {
              m = +m + 1;
            }
          }
          if (gtlt === "<") {
            pr = "-0";
          }
          ret = `${gtlt + M}.${m}.${p}${pr}`;
        } else if (xm) {
          ret = `>=${M}.0.0${pr} <${+M + 1}.0.0-0`;
        } else if (xp) {
          ret = `>=${M}.${m}.0${pr} <${M}.${+m + 1}.0-0`;
        }
        debug("xRange return", ret);
        return ret;
      });
    };
    var replaceStars = (comp, options) => {
      debug("replaceStars", comp, options);
      return comp.trim().replace(re[t.STAR], "");
    };
    var replaceGTE0 = (comp, options) => {
      debug("replaceGTE0", comp, options);
      return comp.trim().replace(re[options.includePrerelease ? t.GTE0PRE : t.GTE0], "");
    };
    var hyphenReplace = (incPr) => ($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr, tb) => {
      if (isX(fM)) {
        from = "";
      } else if (isX(fm)) {
        from = `>=${fM}.0.0${incPr ? "-0" : ""}`;
      } else if (isX(fp)) {
        from = `>=${fM}.${fm}.0${incPr ? "-0" : ""}`;
      } else if (fpr) {
        from = `>=${from}`;
      } else {
        from = `>=${from}${incPr ? "-0" : ""}`;
      }
      if (isX(tM)) {
        to = "";
      } else if (isX(tm)) {
        to = `<${+tM + 1}.0.0-0`;
      } else if (isX(tp)) {
        to = `<${tM}.${+tm + 1}.0-0`;
      } else if (tpr) {
        to = `<=${tM}.${tm}.${tp}-${tpr}`;
      } else if (incPr) {
        to = `<${tM}.${tm}.${+tp + 1}-0`;
      } else {
        to = `<=${to}`;
      }
      return `${from} ${to}`.trim();
    };
    var testSet = (set, version, options) => {
      for (let i = 0; i < set.length; i++) {
        if (!set[i].test(version)) {
          return false;
        }
      }
      if (version.prerelease.length && !options.includePrerelease) {
        for (let i = 0; i < set.length; i++) {
          debug(set[i].semver);
          if (set[i].semver === Comparator.ANY) {
            continue;
          }
          if (set[i].semver.prerelease.length > 0) {
            const allowed = set[i].semver;
            if (allowed.major === version.major && allowed.minor === version.minor && allowed.patch === version.patch) {
              return true;
            }
          }
        }
        return false;
      }
      return true;
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/classes/comparator.js
var require_comparator = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/classes/comparator.js"(exports, module2) {
    var ANY = Symbol("SemVer ANY");
    var Comparator = class {
      static get ANY() {
        return ANY;
      }
      constructor(comp, options) {
        options = parseOptions(options);
        if (comp instanceof Comparator) {
          if (comp.loose === !!options.loose) {
            return comp;
          } else {
            comp = comp.value;
          }
        }
        debug("comparator", comp, options);
        this.options = options;
        this.loose = !!options.loose;
        this.parse(comp);
        if (this.semver === ANY) {
          this.value = "";
        } else {
          this.value = this.operator + this.semver.version;
        }
        debug("comp", this);
      }
      parse(comp) {
        const r = this.options.loose ? re[t.COMPARATORLOOSE] : re[t.COMPARATOR];
        const m = comp.match(r);
        if (!m) {
          throw new TypeError(`Invalid comparator: ${comp}`);
        }
        this.operator = m[1] !== void 0 ? m[1] : "";
        if (this.operator === "=") {
          this.operator = "";
        }
        if (!m[2]) {
          this.semver = ANY;
        } else {
          this.semver = new SemVer(m[2], this.options.loose);
        }
      }
      toString() {
        return this.value;
      }
      test(version) {
        debug("Comparator.test", version, this.options.loose);
        if (this.semver === ANY || version === ANY) {
          return true;
        }
        if (typeof version === "string") {
          try {
            version = new SemVer(version, this.options);
          } catch (er) {
            return false;
          }
        }
        return cmp(version, this.operator, this.semver, this.options);
      }
      intersects(comp, options) {
        if (!(comp instanceof Comparator)) {
          throw new TypeError("a Comparator is required");
        }
        if (!options || typeof options !== "object") {
          options = {
            loose: !!options,
            includePrerelease: false
          };
        }
        if (this.operator === "") {
          if (this.value === "") {
            return true;
          }
          return new Range(comp.value, options).test(this.value);
        } else if (comp.operator === "") {
          if (comp.value === "") {
            return true;
          }
          return new Range(this.value, options).test(comp.semver);
        }
        const sameDirectionIncreasing = (this.operator === ">=" || this.operator === ">") && (comp.operator === ">=" || comp.operator === ">");
        const sameDirectionDecreasing = (this.operator === "<=" || this.operator === "<") && (comp.operator === "<=" || comp.operator === "<");
        const sameSemVer = this.semver.version === comp.semver.version;
        const differentDirectionsInclusive = (this.operator === ">=" || this.operator === "<=") && (comp.operator === ">=" || comp.operator === "<=");
        const oppositeDirectionsLessThan = cmp(this.semver, "<", comp.semver, options) && (this.operator === ">=" || this.operator === ">") && (comp.operator === "<=" || comp.operator === "<");
        const oppositeDirectionsGreaterThan = cmp(this.semver, ">", comp.semver, options) && (this.operator === "<=" || this.operator === "<") && (comp.operator === ">=" || comp.operator === ">");
        return sameDirectionIncreasing || sameDirectionDecreasing || sameSemVer && differentDirectionsInclusive || oppositeDirectionsLessThan || oppositeDirectionsGreaterThan;
      }
    };
    module2.exports = Comparator;
    var parseOptions = require_parse_options();
    var { re, t } = require_re();
    var cmp = require_cmp();
    var debug = require_debug();
    var SemVer = require_semver();
    var Range = require_range();
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/functions/satisfies.js
var require_satisfies = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/functions/satisfies.js"(exports, module2) {
    var Range = require_range();
    var satisfies = (version, range, options) => {
      try {
        range = new Range(range, options);
      } catch (er) {
        return false;
      }
      return range.test(version);
    };
    module2.exports = satisfies;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/ranges/to-comparators.js
var require_to_comparators = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/ranges/to-comparators.js"(exports, module2) {
    var Range = require_range();
    var toComparators = (range, options) => new Range(range, options).set.map((comp) => comp.map((c) => c.value).join(" ").trim().split(" "));
    module2.exports = toComparators;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/ranges/max-satisfying.js
var require_max_satisfying = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/ranges/max-satisfying.js"(exports, module2) {
    var SemVer = require_semver();
    var Range = require_range();
    var maxSatisfying = (versions, range, options) => {
      let max = null;
      let maxSV = null;
      let rangeObj = null;
      try {
        rangeObj = new Range(range, options);
      } catch (er) {
        return null;
      }
      versions.forEach((v) => {
        if (rangeObj.test(v)) {
          if (!max || maxSV.compare(v) === -1) {
            max = v;
            maxSV = new SemVer(max, options);
          }
        }
      });
      return max;
    };
    module2.exports = maxSatisfying;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/ranges/min-satisfying.js
var require_min_satisfying = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/ranges/min-satisfying.js"(exports, module2) {
    var SemVer = require_semver();
    var Range = require_range();
    var minSatisfying = (versions, range, options) => {
      let min = null;
      let minSV = null;
      let rangeObj = null;
      try {
        rangeObj = new Range(range, options);
      } catch (er) {
        return null;
      }
      versions.forEach((v) => {
        if (rangeObj.test(v)) {
          if (!min || minSV.compare(v) === 1) {
            min = v;
            minSV = new SemVer(min, options);
          }
        }
      });
      return min;
    };
    module2.exports = minSatisfying;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/ranges/min-version.js
var require_min_version = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/ranges/min-version.js"(exports, module2) {
    var SemVer = require_semver();
    var Range = require_range();
    var gt = require_gt();
    var minVersion = (range, loose) => {
      range = new Range(range, loose);
      let minver = new SemVer("0.0.0");
      if (range.test(minver)) {
        return minver;
      }
      minver = new SemVer("0.0.0-0");
      if (range.test(minver)) {
        return minver;
      }
      minver = null;
      for (let i = 0; i < range.set.length; ++i) {
        const comparators = range.set[i];
        let setMin = null;
        comparators.forEach((comparator) => {
          const compver = new SemVer(comparator.semver.version);
          switch (comparator.operator) {
            case ">":
              if (compver.prerelease.length === 0) {
                compver.patch++;
              } else {
                compver.prerelease.push(0);
              }
              compver.raw = compver.format();
            case "":
            case ">=":
              if (!setMin || gt(compver, setMin)) {
                setMin = compver;
              }
              break;
            case "<":
            case "<=":
              break;
            default:
              throw new Error(`Unexpected operation: ${comparator.operator}`);
          }
        });
        if (setMin && (!minver || gt(minver, setMin))) {
          minver = setMin;
        }
      }
      if (minver && range.test(minver)) {
        return minver;
      }
      return null;
    };
    module2.exports = minVersion;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/ranges/valid.js
var require_valid2 = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/ranges/valid.js"(exports, module2) {
    var Range = require_range();
    var validRange = (range, options) => {
      try {
        return new Range(range, options).range || "*";
      } catch (er) {
        return null;
      }
    };
    module2.exports = validRange;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/ranges/outside.js
var require_outside = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/ranges/outside.js"(exports, module2) {
    var SemVer = require_semver();
    var Comparator = require_comparator();
    var { ANY } = Comparator;
    var Range = require_range();
    var satisfies = require_satisfies();
    var gt = require_gt();
    var lt = require_lt();
    var lte = require_lte();
    var gte = require_gte();
    var outside = (version, range, hilo, options) => {
      version = new SemVer(version, options);
      range = new Range(range, options);
      let gtfn, ltefn, ltfn, comp, ecomp;
      switch (hilo) {
        case ">":
          gtfn = gt;
          ltefn = lte;
          ltfn = lt;
          comp = ">";
          ecomp = ">=";
          break;
        case "<":
          gtfn = lt;
          ltefn = gte;
          ltfn = gt;
          comp = "<";
          ecomp = "<=";
          break;
        default:
          throw new TypeError('Must provide a hilo val of "<" or ">"');
      }
      if (satisfies(version, range, options)) {
        return false;
      }
      for (let i = 0; i < range.set.length; ++i) {
        const comparators = range.set[i];
        let high = null;
        let low = null;
        comparators.forEach((comparator) => {
          if (comparator.semver === ANY) {
            comparator = new Comparator(">=0.0.0");
          }
          high = high || comparator;
          low = low || comparator;
          if (gtfn(comparator.semver, high.semver, options)) {
            high = comparator;
          } else if (ltfn(comparator.semver, low.semver, options)) {
            low = comparator;
          }
        });
        if (high.operator === comp || high.operator === ecomp) {
          return false;
        }
        if ((!low.operator || low.operator === comp) && ltefn(version, low.semver)) {
          return false;
        } else if (low.operator === ecomp && ltfn(version, low.semver)) {
          return false;
        }
      }
      return true;
    };
    module2.exports = outside;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/ranges/gtr.js
var require_gtr = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/ranges/gtr.js"(exports, module2) {
    var outside = require_outside();
    var gtr = (version, range, options) => outside(version, range, ">", options);
    module2.exports = gtr;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/ranges/ltr.js
var require_ltr = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/ranges/ltr.js"(exports, module2) {
    var outside = require_outside();
    var ltr = (version, range, options) => outside(version, range, "<", options);
    module2.exports = ltr;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/ranges/intersects.js
var require_intersects = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/ranges/intersects.js"(exports, module2) {
    var Range = require_range();
    var intersects = (r1, r2, options) => {
      r1 = new Range(r1, options);
      r2 = new Range(r2, options);
      return r1.intersects(r2);
    };
    module2.exports = intersects;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/ranges/simplify.js
var require_simplify = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/ranges/simplify.js"(exports, module2) {
    var satisfies = require_satisfies();
    var compare = require_compare();
    module2.exports = (versions, range, options) => {
      const set = [];
      let first = null;
      let prev = null;
      const v = versions.sort((a, b) => compare(a, b, options));
      for (const version of v) {
        const included = satisfies(version, range, options);
        if (included) {
          prev = version;
          if (!first) {
            first = version;
          }
        } else {
          if (prev) {
            set.push([first, prev]);
          }
          prev = null;
          first = null;
        }
      }
      if (first) {
        set.push([first, null]);
      }
      const ranges = [];
      for (const [min, max] of set) {
        if (min === max) {
          ranges.push(min);
        } else if (!max && min === v[0]) {
          ranges.push("*");
        } else if (!max) {
          ranges.push(`>=${min}`);
        } else if (min === v[0]) {
          ranges.push(`<=${max}`);
        } else {
          ranges.push(`${min} - ${max}`);
        }
      }
      const simplified = ranges.join(" || ");
      const original = typeof range.raw === "string" ? range.raw : String(range);
      return simplified.length < original.length ? simplified : range;
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/ranges/subset.js
var require_subset = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/ranges/subset.js"(exports, module2) {
    var Range = require_range();
    var Comparator = require_comparator();
    var { ANY } = Comparator;
    var satisfies = require_satisfies();
    var compare = require_compare();
    var subset = (sub, dom, options = {}) => {
      if (sub === dom) {
        return true;
      }
      sub = new Range(sub, options);
      dom = new Range(dom, options);
      let sawNonNull = false;
      OUTER:
        for (const simpleSub of sub.set) {
          for (const simpleDom of dom.set) {
            const isSub = simpleSubset(simpleSub, simpleDom, options);
            sawNonNull = sawNonNull || isSub !== null;
            if (isSub) {
              continue OUTER;
            }
          }
          if (sawNonNull) {
            return false;
          }
        }
      return true;
    };
    var simpleSubset = (sub, dom, options) => {
      if (sub === dom) {
        return true;
      }
      if (sub.length === 1 && sub[0].semver === ANY) {
        if (dom.length === 1 && dom[0].semver === ANY) {
          return true;
        } else if (options.includePrerelease) {
          sub = [new Comparator(">=0.0.0-0")];
        } else {
          sub = [new Comparator(">=0.0.0")];
        }
      }
      if (dom.length === 1 && dom[0].semver === ANY) {
        if (options.includePrerelease) {
          return true;
        } else {
          dom = [new Comparator(">=0.0.0")];
        }
      }
      const eqSet = /* @__PURE__ */ new Set();
      let gt, lt;
      for (const c of sub) {
        if (c.operator === ">" || c.operator === ">=") {
          gt = higherGT(gt, c, options);
        } else if (c.operator === "<" || c.operator === "<=") {
          lt = lowerLT(lt, c, options);
        } else {
          eqSet.add(c.semver);
        }
      }
      if (eqSet.size > 1) {
        return null;
      }
      let gtltComp;
      if (gt && lt) {
        gtltComp = compare(gt.semver, lt.semver, options);
        if (gtltComp > 0) {
          return null;
        } else if (gtltComp === 0 && (gt.operator !== ">=" || lt.operator !== "<=")) {
          return null;
        }
      }
      for (const eq of eqSet) {
        if (gt && !satisfies(eq, String(gt), options)) {
          return null;
        }
        if (lt && !satisfies(eq, String(lt), options)) {
          return null;
        }
        for (const c of dom) {
          if (!satisfies(eq, String(c), options)) {
            return false;
          }
        }
        return true;
      }
      let higher, lower;
      let hasDomLT, hasDomGT;
      let needDomLTPre = lt && !options.includePrerelease && lt.semver.prerelease.length ? lt.semver : false;
      let needDomGTPre = gt && !options.includePrerelease && gt.semver.prerelease.length ? gt.semver : false;
      if (needDomLTPre && needDomLTPre.prerelease.length === 1 && lt.operator === "<" && needDomLTPre.prerelease[0] === 0) {
        needDomLTPre = false;
      }
      for (const c of dom) {
        hasDomGT = hasDomGT || c.operator === ">" || c.operator === ">=";
        hasDomLT = hasDomLT || c.operator === "<" || c.operator === "<=";
        if (gt) {
          if (needDomGTPre) {
            if (c.semver.prerelease && c.semver.prerelease.length && c.semver.major === needDomGTPre.major && c.semver.minor === needDomGTPre.minor && c.semver.patch === needDomGTPre.patch) {
              needDomGTPre = false;
            }
          }
          if (c.operator === ">" || c.operator === ">=") {
            higher = higherGT(gt, c, options);
            if (higher === c && higher !== gt) {
              return false;
            }
          } else if (gt.operator === ">=" && !satisfies(gt.semver, String(c), options)) {
            return false;
          }
        }
        if (lt) {
          if (needDomLTPre) {
            if (c.semver.prerelease && c.semver.prerelease.length && c.semver.major === needDomLTPre.major && c.semver.minor === needDomLTPre.minor && c.semver.patch === needDomLTPre.patch) {
              needDomLTPre = false;
            }
          }
          if (c.operator === "<" || c.operator === "<=") {
            lower = lowerLT(lt, c, options);
            if (lower === c && lower !== lt) {
              return false;
            }
          } else if (lt.operator === "<=" && !satisfies(lt.semver, String(c), options)) {
            return false;
          }
        }
        if (!c.operator && (lt || gt) && gtltComp !== 0) {
          return false;
        }
      }
      if (gt && hasDomLT && !lt && gtltComp !== 0) {
        return false;
      }
      if (lt && hasDomGT && !gt && gtltComp !== 0) {
        return false;
      }
      if (needDomGTPre || needDomLTPre) {
        return false;
      }
      return true;
    };
    var higherGT = (a, b, options) => {
      if (!a) {
        return b;
      }
      const comp = compare(a.semver, b.semver, options);
      return comp > 0 ? a : comp < 0 ? b : b.operator === ">" && a.operator === ">=" ? b : a;
    };
    var lowerLT = (a, b, options) => {
      if (!a) {
        return b;
      }
      const comp = compare(a.semver, b.semver, options);
      return comp < 0 ? a : comp > 0 ? b : b.operator === "<" && a.operator === "<=" ? b : a;
    };
    module2.exports = subset;
  }
});

// node_modules/aws-cdk-lib/node_modules/semver/index.js
var require_semver2 = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/semver/index.js"(exports, module2) {
    var internalRe = require_re();
    var constants = require_constants();
    var SemVer = require_semver();
    var identifiers = require_identifiers();
    var parse = require_parse();
    var valid = require_valid();
    var clean = require_clean();
    var inc = require_inc();
    var diff = require_diff();
    var major = require_major();
    var minor = require_minor();
    var patch = require_patch();
    var prerelease = require_prerelease();
    var compare = require_compare();
    var rcompare = require_rcompare();
    var compareLoose = require_compare_loose();
    var compareBuild = require_compare_build();
    var sort = require_sort();
    var rsort = require_rsort();
    var gt = require_gt();
    var lt = require_lt();
    var eq = require_eq();
    var neq = require_neq();
    var gte = require_gte();
    var lte = require_lte();
    var cmp = require_cmp();
    var coerce = require_coerce();
    var Comparator = require_comparator();
    var Range = require_range();
    var satisfies = require_satisfies();
    var toComparators = require_to_comparators();
    var maxSatisfying = require_max_satisfying();
    var minSatisfying = require_min_satisfying();
    var minVersion = require_min_version();
    var validRange = require_valid2();
    var outside = require_outside();
    var gtr = require_gtr();
    var ltr = require_ltr();
    var intersects = require_intersects();
    var simplifyRange = require_simplify();
    var subset = require_subset();
    module2.exports = {
      parse,
      valid,
      clean,
      inc,
      diff,
      major,
      minor,
      patch,
      prerelease,
      compare,
      rcompare,
      compareLoose,
      compareBuild,
      sort,
      rsort,
      gt,
      lt,
      eq,
      neq,
      gte,
      lte,
      cmp,
      coerce,
      Comparator,
      Range,
      satisfies,
      toComparators,
      maxSatisfying,
      minSatisfying,
      minVersion,
      validRange,
      outside,
      gtr,
      ltr,
      intersects,
      simplifyRange,
      subset,
      SemVer,
      re: internalRe.re,
      src: internalRe.src,
      tokens: internalRe.t,
      SEMVER_SPEC_VERSION: constants.SEMVER_SPEC_VERSION,
      compareIdentifiers: identifiers.compareIdentifiers,
      rcompareIdentifiers: identifiers.rcompareIdentifiers
    };
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/schema/assets.schema.json
var require_assets_schema = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/schema/assets.schema.json"(exports, module2) {
    module2.exports = {
      $ref: "#/definitions/AssetManifest",
      definitions: {
        AssetManifest: {
          description: "Definitions for the asset manifest",
          type: "object",
          properties: {
            version: {
              description: "Version of the manifest",
              type: "string"
            },
            files: {
              description: "The file assets in this manifest (Default - No files)",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/FileAsset"
              }
            },
            dockerImages: {
              description: "The Docker image assets in this manifest (Default - No Docker images)",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/DockerImageAsset"
              }
            }
          },
          required: [
            "version"
          ]
        },
        FileAsset: {
          description: "A file asset",
          type: "object",
          properties: {
            source: {
              $ref: "#/definitions/FileSource",
              description: "Source description for file assets"
            },
            destinations: {
              description: "Destinations for this file asset",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/FileDestination"
              }
            }
          },
          required: [
            "destinations",
            "source"
          ]
        },
        FileSource: {
          description: "Describe the source of a file asset",
          type: "object",
          properties: {
            executable: {
              description: "External command which will produce the file asset to upload. (Default - Exactly one of `executable` and `path` is required.)",
              type: "array",
              items: {
                type: "string"
              }
            },
            path: {
              description: "The filesystem object to upload\n\nThis path is relative to the asset manifest location. (Default - Exactly one of `executable` and `path` is required.)",
              type: "string"
            },
            packaging: {
              description: "Packaging method\n\nOnly allowed when `path` is specified. (Default FILE)",
              enum: [
                "file",
                "zip"
              ],
              type: "string"
            }
          }
        },
        FileDestination: {
          description: "Where in S3 a file asset needs to be published",
          type: "object",
          properties: {
            bucketName: {
              description: "The name of the bucket",
              type: "string"
            },
            objectKey: {
              description: "The destination object key",
              type: "string"
            },
            region: {
              description: "The region where this asset will need to be published (Default - Current region)",
              type: "string"
            },
            assumeRoleArn: {
              description: "The role that needs to be assumed while publishing this asset (Default - No role will be assumed)",
              type: "string"
            },
            assumeRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            }
          },
          required: [
            "bucketName",
            "objectKey"
          ]
        },
        DockerImageAsset: {
          description: "A file asset",
          type: "object",
          properties: {
            source: {
              $ref: "#/definitions/DockerImageSource",
              description: "Source description for file assets"
            },
            destinations: {
              description: "Destinations for this file asset",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/DockerImageDestination"
              }
            }
          },
          required: [
            "destinations",
            "source"
          ]
        },
        DockerImageSource: {
          description: "Properties for how to produce a Docker image from a source",
          type: "object",
          properties: {
            directory: {
              description: "The directory containing the Docker image build instructions.\n\nThis path is relative to the asset manifest location. (Default - Exactly one of `directory` and `executable` is required)",
              type: "string"
            },
            executable: {
              description: "A command-line executable that returns the name of a local\nDocker image on stdout after being run. (Default - Exactly one of `directory` and `executable` is required)",
              type: "array",
              items: {
                type: "string"
              }
            },
            dockerFile: {
              description: "The name of the file with build instructions\n\nOnly allowed when `directory` is set. (Default Dockerfile)",
              type: "string"
            },
            dockerBuildTarget: {
              description: "Target build stage in a Dockerfile with multiple build stages\n\nOnly allowed when `directory` is set. (Default - The last stage in the Dockerfile)",
              type: "string"
            },
            dockerBuildArgs: {
              description: "Additional build arguments\n\nOnly allowed when `directory` is set. (Default - No additional build arguments)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            networkMode: {
              description: "Networking mode for the RUN commands during build. _Requires Docker Engine API v1.25+_.\n\nSpecify this property to build images on a specific networking mode. (Default - no networking mode specified)",
              type: "string"
            },
            platform: {
              description: "Platform to build for. _Requires Docker Buildx_.\n\nSpecify this property to build images on a specific platform/architecture. (Default - current machine platform)",
              type: "string"
            }
          }
        },
        DockerImageDestination: {
          description: "Where to publish docker images",
          type: "object",
          properties: {
            repositoryName: {
              description: "Name of the ECR repository to publish to",
              type: "string"
            },
            imageTag: {
              description: "Tag of the image to publish",
              type: "string"
            },
            region: {
              description: "The region where this asset will need to be published (Default - Current region)",
              type: "string"
            },
            assumeRoleArn: {
              description: "The role that needs to be assumed while publishing this asset (Default - No role will be assumed)",
              type: "string"
            },
            assumeRoleExternalId: {
              description: "The ExternalId that needs to be supplied while assuming this role (Default - No ExternalId will be supplied)",
              type: "string"
            }
          },
          required: [
            "imageTag",
            "repositoryName"
          ]
        }
      },
      $schema: "http://json-schema.org/draft-07/schema#"
    };
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/schema/cloud-assembly.schema.json
var require_cloud_assembly_schema = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/schema/cloud-assembly.schema.json"(exports, module2) {
    module2.exports = {
      $ref: "#/definitions/AssemblyManifest",
      definitions: {
        AssemblyManifest: {
          description: "A manifest which describes the cloud assembly.",
          type: "object",
          properties: {
            version: {
              description: "Protocol version",
              type: "string"
            },
            artifacts: {
              description: "The set of artifacts in this assembly. (Default - no artifacts.)",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/ArtifactManifest"
              }
            },
            missing: {
              description: "Missing context information. If this field has values, it means that the\ncloud assembly is not complete and should not be deployed. (Default - no missing context.)",
              type: "array",
              items: {
                $ref: "#/definitions/MissingContext"
              }
            },
            runtime: {
              description: "Runtime information. (Default - no info.)",
              $ref: "#/definitions/RuntimeInfo"
            }
          },
          required: [
            "version"
          ]
        },
        ArtifactManifest: {
          description: "A manifest for a single artifact within the cloud assembly.",
          type: "object",
          properties: {
            type: {
              $ref: "#/definitions/ArtifactType",
              description: "The type of artifact."
            },
            environment: {
              description: "The environment into which this artifact is deployed. (Default - no envrionment.)",
              type: "string"
            },
            metadata: {
              description: "Associated metadata. (Default - no metadata.)",
              type: "object",
              additionalProperties: {
                type: "array",
                items: {
                  $ref: "#/definitions/MetadataEntry"
                }
              }
            },
            dependencies: {
              description: "IDs of artifacts that must be deployed before this artifact. (Default - no dependencies.)",
              type: "array",
              items: {
                type: "string"
              }
            },
            properties: {
              description: "The set of properties for this artifact (depends on type) (Default - no properties.)",
              anyOf: [
                {
                  $ref: "#/definitions/AwsCloudFormationStackProperties"
                },
                {
                  $ref: "#/definitions/AssetManifestProperties"
                },
                {
                  $ref: "#/definitions/TreeArtifactProperties"
                },
                {
                  $ref: "#/definitions/NestedCloudAssemblyProperties"
                }
              ]
            },
            displayName: {
              description: "A string that represents this artifact. Should only be used in user interfaces. (Default - no display name)",
              type: "string"
            }
          },
          required: [
            "type"
          ]
        },
        ArtifactType: {
          description: "Type of cloud artifact.",
          enum: [
            "aws:cloudformation:stack",
            "cdk:asset-manifest",
            "cdk:cloud-assembly",
            "cdk:tree",
            "none"
          ],
          type: "string"
        },
        MetadataEntry: {
          description: "A metadata entry in a cloud assembly artifact.",
          type: "object",
          properties: {
            type: {
              description: "The type of the metadata entry.",
              type: "string"
            },
            data: {
              description: "The data. (Default - no data.)",
              anyOf: [
                {
                  $ref: "#/definitions/FileAssetMetadataEntry"
                },
                {
                  $ref: "#/definitions/ContainerImageAssetMetadataEntry"
                },
                {
                  type: "array",
                  items: {
                    $ref: "#/definitions/Tag"
                  }
                },
                {
                  type: "string"
                },
                {
                  description: "Free form data."
                }
              ]
            },
            trace: {
              description: "A stack trace for when the entry was created. (Default - no trace.)",
              type: "array",
              items: {
                type: "string"
              }
            }
          },
          required: [
            "type"
          ]
        },
        FileAssetMetadataEntry: {
          description: "Metadata Entry spec for files.",
          type: "object",
          properties: {
            packaging: {
              description: "Requested packaging style",
              enum: [
                "file",
                "zip"
              ],
              type: "string"
            },
            s3BucketParameter: {
              description: "Name of parameter where S3 bucket should be passed in",
              type: "string"
            },
            s3KeyParameter: {
              description: "Name of parameter where S3 key should be passed in",
              type: "string"
            },
            artifactHashParameter: {
              description: "The name of the parameter where the hash of the bundled asset should be passed in.",
              type: "string"
            },
            id: {
              description: "Logical identifier for the asset",
              type: "string"
            },
            sourceHash: {
              description: "The hash of the asset source.",
              type: "string"
            },
            path: {
              description: "Path on disk to the asset",
              type: "string"
            }
          },
          required: [
            "artifactHashParameter",
            "id",
            "packaging",
            "path",
            "s3BucketParameter",
            "s3KeyParameter",
            "sourceHash"
          ]
        },
        ContainerImageAssetMetadataEntry: {
          description: "Metadata Entry spec for container images.",
          type: "object",
          properties: {
            packaging: {
              description: "Type of asset",
              type: "string",
              enum: [
                "container-image"
              ]
            },
            imageNameParameter: {
              description: 'ECR Repository name and repo digest (separated by "@sha256:") where this\nimage is stored. (Default undefined If not specified, `repositoryName` and `imageTag` are\nrequired because otherwise how will the stack know where to find the asset,\nha?)',
              type: "string"
            },
            repositoryName: {
              description: "ECR repository name, if omitted a default name based on the asset's ID is\nused instead. Specify this property if you need to statically address the\nimage, e.g. from a Kubernetes Pod. Note, this is only the repository name,\nwithout the registry and the tag parts. (Default - this parameter is REQUIRED after 1.21.0)",
              type: "string"
            },
            imageTag: {
              description: "The docker image tag to use for tagging pushed images. This field is\nrequired if `imageParameterName` is ommited (otherwise, the app won't be\nable to find the image). (Default - this parameter is REQUIRED after 1.21.0)",
              type: "string"
            },
            buildArgs: {
              description: "Build args to pass to the `docker build` command (Default no build args are passed)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            target: {
              description: "Docker target to build to (Default no build target)",
              type: "string"
            },
            file: {
              description: "Path to the Dockerfile (relative to the directory). (Default - no file is passed)",
              type: "string"
            },
            networkMode: {
              description: "Networking mode for the RUN commands during build. (Default - no networking mode specified)",
              type: "string"
            },
            platform: {
              description: "Platform to build for. _Requires Docker Buildx_. (Default - current machine platform)",
              type: "string"
            },
            id: {
              description: "Logical identifier for the asset",
              type: "string"
            },
            sourceHash: {
              description: "The hash of the asset source.",
              type: "string"
            },
            path: {
              description: "Path on disk to the asset",
              type: "string"
            }
          },
          required: [
            "id",
            "packaging",
            "path",
            "sourceHash"
          ]
        },
        Tag: {
          description: "Metadata Entry spec for stack tag.",
          type: "object",
          properties: {
            key: {
              description: 'Tag key.\n\n(In the actual file on disk this will be cased as "Key", and the structure is\npatched to match this structure upon loading:\nhttps://github.com/aws/aws-cdk/blob/4aadaa779b48f35838cccd4e25107b2338f05547/packages/%40aws-cdk/cloud-assembly-schema/lib/manifest.ts#L137)',
              type: "string"
            },
            value: {
              description: 'Tag value.\n\n(In the actual file on disk this will be cased as "Value", and the structure is\npatched to match this structure upon loading:\nhttps://github.com/aws/aws-cdk/blob/4aadaa779b48f35838cccd4e25107b2338f05547/packages/%40aws-cdk/cloud-assembly-schema/lib/manifest.ts#L137)',
              type: "string"
            }
          },
          required: [
            "key",
            "value"
          ]
        },
        AwsCloudFormationStackProperties: {
          description: "Artifact properties for CloudFormation stacks.",
          type: "object",
          properties: {
            templateFile: {
              description: "A file relative to the assembly root which contains the CloudFormation template for this stack.",
              type: "string"
            },
            parameters: {
              description: "Values for CloudFormation stack parameters that should be passed when the stack is deployed. (Default - No parameters)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            tags: {
              description: "Values for CloudFormation stack tags that should be passed when the stack is deployed. (Default - No tags)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            stackName: {
              description: "The name to use for the CloudFormation stack. (Default - name derived from artifact ID)",
              type: "string"
            },
            terminationProtection: {
              description: "Whether to enable termination protection for this stack.",
              default: false,
              type: "boolean"
            },
            assumeRoleArn: {
              description: "The role that needs to be assumed to deploy the stack (Default - No role is assumed (current credentials are used))",
              type: "string"
            },
            assumeRoleExternalId: {
              description: "External ID to use when assuming role for cloudformation deployments (Default - No external ID)",
              type: "string"
            },
            cloudFormationExecutionRoleArn: {
              description: "The role that is passed to CloudFormation to execute the change set (Default - No role is passed (currently assumed role/credentials are used))",
              type: "string"
            },
            lookupRole: {
              description: "The role to use to look up values from the target AWS account (Default - No role is assumed (current credentials are used))",
              $ref: "#/definitions/BootstrapRole"
            },
            stackTemplateAssetObjectUrl: {
              description: "If the stack template has already been included in the asset manifest, its asset URL (Default - Not uploaded yet, upload just before deploying)",
              type: "string"
            },
            requiresBootstrapStackVersion: {
              description: "Version of bootstrap stack required to deploy this stack (Default - No bootstrap stack required)",
              type: "number"
            },
            bootstrapStackVersionSsmParameter: {
              description: "SSM parameter where the bootstrap stack version number can be found\n\nOnly used if `requiresBootstrapStackVersion` is set.\n\n- If this value is not set, the bootstrap stack name must be known at\n  deployment time so the stack version can be looked up from the stack\n  outputs.\n- If this value is set, the bootstrap stack can have any name because\n  we won't need to look it up. (Default - Bootstrap stack version number looked up)",
              type: "string"
            },
            validateOnSynth: {
              description: "Whether this stack should be validated by the CLI after synthesis (Default - false)",
              type: "boolean"
            }
          },
          required: [
            "templateFile"
          ]
        },
        BootstrapRole: {
          description: "Information needed to access an IAM role created\nas part of the bootstrap process",
          type: "object",
          properties: {
            arn: {
              description: "The ARN of the IAM role created as part of bootrapping\ne.g. lookupRoleArn",
              type: "string"
            },
            assumeRoleExternalId: {
              description: "External ID to use when assuming the bootstrap role (Default - No external ID)",
              type: "string"
            },
            requiresBootstrapStackVersion: {
              description: "Version of bootstrap stack required to use this role (Default - No bootstrap stack required)",
              type: "number"
            },
            bootstrapStackVersionSsmParameter: {
              description: "Name of SSM parameter with bootstrap stack version (Default - Discover SSM parameter by reading stack)",
              type: "string"
            }
          },
          required: [
            "arn"
          ]
        },
        AssetManifestProperties: {
          description: "Artifact properties for the Asset Manifest",
          type: "object",
          properties: {
            file: {
              description: "Filename of the asset manifest",
              type: "string"
            },
            requiresBootstrapStackVersion: {
              description: "Version of bootstrap stack required to deploy this stack (Default - Version 1 (basic modern bootstrap stack))",
              type: "number"
            },
            bootstrapStackVersionSsmParameter: {
              description: "SSM parameter where the bootstrap stack version number can be found\n\n- If this value is not set, the bootstrap stack name must be known at\n  deployment time so the stack version can be looked up from the stack\n  outputs.\n- If this value is set, the bootstrap stack can have any name because\n  we won't need to look it up. (Default - Bootstrap stack version number looked up)",
              type: "string"
            }
          },
          required: [
            "file"
          ]
        },
        TreeArtifactProperties: {
          description: "Artifact properties for the Construct Tree Artifact",
          type: "object",
          properties: {
            file: {
              description: "Filename of the tree artifact",
              type: "string"
            }
          },
          required: [
            "file"
          ]
        },
        NestedCloudAssemblyProperties: {
          description: "Artifact properties for nested cloud assemblies",
          type: "object",
          properties: {
            directoryName: {
              description: "Relative path to the nested cloud assembly",
              type: "string"
            },
            displayName: {
              description: "Display name for the cloud assembly (Default - The artifact ID)",
              type: "string"
            }
          },
          required: [
            "directoryName"
          ]
        },
        MissingContext: {
          description: "Represents a missing piece of context.",
          type: "object",
          properties: {
            key: {
              description: "The missing context key.",
              type: "string"
            },
            provider: {
              $ref: "#/definitions/ContextProvider",
              description: "The provider from which we expect this context key to be obtained."
            },
            props: {
              description: "A set of provider-specific options.",
              anyOf: [
                {
                  $ref: "#/definitions/AmiContextQuery"
                },
                {
                  $ref: "#/definitions/AvailabilityZonesContextQuery"
                },
                {
                  $ref: "#/definitions/HostedZoneContextQuery"
                },
                {
                  $ref: "#/definitions/SSMParameterContextQuery"
                },
                {
                  $ref: "#/definitions/VpcContextQuery"
                },
                {
                  $ref: "#/definitions/EndpointServiceAvailabilityZonesContextQuery"
                },
                {
                  $ref: "#/definitions/LoadBalancerContextQuery"
                },
                {
                  $ref: "#/definitions/LoadBalancerListenerContextQuery"
                },
                {
                  $ref: "#/definitions/SecurityGroupContextQuery"
                },
                {
                  $ref: "#/definitions/KeyContextQuery"
                },
                {
                  $ref: "#/definitions/PluginContextQuery"
                }
              ]
            }
          },
          required: [
            "key",
            "props",
            "provider"
          ]
        },
        ContextProvider: {
          description: "Identifier for the context provider",
          enum: [
            "ami",
            "availability-zones",
            "endpoint-service-availability-zones",
            "hosted-zone",
            "key-provider",
            "load-balancer",
            "load-balancer-listener",
            "plugin",
            "security-group",
            "ssm",
            "vpc-provider"
          ],
          type: "string"
        },
        AmiContextQuery: {
          description: "Query to AMI context provider",
          type: "object",
          properties: {
            account: {
              description: "Account to query",
              type: "string"
            },
            region: {
              description: "Region to query",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            owners: {
              description: "Owners to DescribeImages call (Default - All owners)",
              type: "array",
              items: {
                type: "string"
              }
            },
            filters: {
              description: "Filters to DescribeImages call",
              type: "object",
              additionalProperties: {
                type: "array",
                items: {
                  type: "string"
                }
              }
            }
          },
          required: [
            "account",
            "filters",
            "region"
          ]
        },
        AvailabilityZonesContextQuery: {
          description: "Query to availability zone context provider",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            }
          },
          required: [
            "account",
            "region"
          ]
        },
        HostedZoneContextQuery: {
          description: "Query to hosted zone context provider",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            domainName: {
              description: "The domain name e.g. example.com to lookup",
              type: "string"
            },
            privateZone: {
              description: "True if the zone you want to find is a private hosted zone",
              default: false,
              type: "boolean"
            },
            vpcId: {
              description: "The VPC ID to that the private zone must be associated with\n\nIf you provide VPC ID and privateZone is false, this will return no results\nand raise an error. (Default - Required if privateZone=true)",
              type: "string"
            }
          },
          required: [
            "account",
            "domainName",
            "region"
          ]
        },
        SSMParameterContextQuery: {
          description: "Query to SSM Parameter Context Provider",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            parameterName: {
              description: "Parameter name to query",
              type: "string"
            }
          },
          required: [
            "account",
            "parameterName",
            "region"
          ]
        },
        VpcContextQuery: {
          description: "Query input for looking up a VPC",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            filter: {
              description: "Filters to apply to the VPC\n\nFilter parameters are the same as passed to DescribeVpcs.",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            returnAsymmetricSubnets: {
              description: "Whether to populate the subnetGroups field of the {@link VpcContextResponse},\nwhich contains potentially asymmetric subnet groups.",
              default: false,
              type: "boolean"
            },
            subnetGroupNameTag: {
              description: "Optional tag for subnet group name.\nIf not provided, we'll look at the aws-cdk:subnet-name tag.\nIf the subnet does not have the specified tag,\nwe'll use its type as the name. (Default 'aws-cdk:subnet-name')",
              type: "string"
            }
          },
          required: [
            "account",
            "filter",
            "region"
          ]
        },
        EndpointServiceAvailabilityZonesContextQuery: {
          description: "Query to endpoint service context provider",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            serviceName: {
              description: "Query service name",
              type: "string"
            }
          },
          required: [
            "account",
            "region",
            "serviceName"
          ]
        },
        LoadBalancerContextQuery: {
          description: "Query input for looking up a load balancer",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            loadBalancerType: {
              $ref: "#/definitions/LoadBalancerType",
              description: "Filter load balancers by their type"
            },
            loadBalancerArn: {
              description: "Find by load balancer's ARN (Default - does not search by load balancer arn)",
              type: "string"
            },
            loadBalancerTags: {
              description: "Match load balancer tags (Default - does not match load balancers by tags)",
              type: "array",
              items: {
                $ref: "#/definitions/Tag"
              }
            }
          },
          required: [
            "account",
            "loadBalancerType",
            "region"
          ]
        },
        LoadBalancerType: {
          description: "Type of load balancer",
          enum: [
            "application",
            "network"
          ],
          type: "string"
        },
        LoadBalancerListenerContextQuery: {
          description: "Query input for looking up a load balancer listener",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            listenerArn: {
              description: "Find by listener's arn (Default - does not find by listener arn)",
              type: "string"
            },
            listenerProtocol: {
              description: "Filter by listener protocol (Default - does not filter by listener protocol)",
              enum: [
                "HTTP",
                "HTTPS",
                "TCP",
                "TCP_UDP",
                "TLS",
                "UDP"
              ],
              type: "string"
            },
            listenerPort: {
              description: "Filter listeners by listener port (Default - does not filter by a listener port)",
              type: "number"
            },
            loadBalancerType: {
              $ref: "#/definitions/LoadBalancerType",
              description: "Filter load balancers by their type"
            },
            loadBalancerArn: {
              description: "Find by load balancer's ARN (Default - does not search by load balancer arn)",
              type: "string"
            },
            loadBalancerTags: {
              description: "Match load balancer tags (Default - does not match load balancers by tags)",
              type: "array",
              items: {
                $ref: "#/definitions/Tag"
              }
            }
          },
          required: [
            "account",
            "loadBalancerType",
            "region"
          ]
        },
        SecurityGroupContextQuery: {
          description: "Query input for looking up a security group",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            securityGroupId: {
              description: "Security group id (Default - None)",
              type: "string"
            },
            securityGroupName: {
              description: "Security group name (Default - None)",
              type: "string"
            },
            vpcId: {
              description: "VPC ID (Default - None)",
              type: "string"
            }
          },
          required: [
            "account",
            "region"
          ]
        },
        KeyContextQuery: {
          description: "Query input for looking up a KMS Key",
          type: "object",
          properties: {
            account: {
              description: "Query account",
              type: "string"
            },
            region: {
              description: "Query region",
              type: "string"
            },
            lookupRoleArn: {
              description: "The ARN of the role that should be used to look up the missing values (Default - None)",
              type: "string"
            },
            aliasName: {
              description: "Alias name used to search the Key",
              type: "string"
            }
          },
          required: [
            "account",
            "aliasName",
            "region"
          ]
        },
        PluginContextQuery: {
          description: "Query input for plugins\n\nThis alternate branch is necessary because it needs to be able to escape all type checking\nwe do on on the cloud assembly -- we cannot know the properties that will be used a priori.",
          type: "object",
          additionalProperties: {},
          properties: {
            pluginName: {
              description: "The name of the plugin",
              type: "string"
            }
          },
          required: [
            "pluginName"
          ]
        },
        RuntimeInfo: {
          description: "Information about the application's runtime components.",
          type: "object",
          properties: {
            libraries: {
              description: "The list of libraries loaded in the application, associated with their versions.",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            }
          },
          required: [
            "libraries"
          ]
        }
      },
      $schema: "http://json-schema.org/draft-07/schema#"
    };
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/schema/cloud-assembly.version.json
var require_cloud_assembly_version = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/schema/cloud-assembly.version.json"(exports, module2) {
    module2.exports = { version: "21.0.0" };
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/schema/integ.schema.json
var require_integ_schema = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/schema/integ.schema.json"(exports, module2) {
    module2.exports = {
      $ref: "#/definitions/IntegManifest",
      definitions: {
        IntegManifest: {
          description: "Definitions for the integration testing manifest",
          type: "object",
          properties: {
            version: {
              description: "Version of the manifest",
              type: "string"
            },
            enableLookups: {
              description: "Enable lookups for this test. If lookups are enabled\nthen `stackUpdateWorkflow` must be set to false.\nLookups should only be enabled when you are explicitely testing\nlookups.",
              default: false,
              type: "boolean"
            },
            synthContext: {
              description: "Additional context to use when performing\na synth. Any context provided here will override\nany default context (Default - no additional context)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            testCases: {
              description: "test cases",
              type: "object",
              additionalProperties: {
                $ref: "#/definitions/TestCase"
              }
            }
          },
          required: [
            "testCases",
            "version"
          ]
        },
        TestCase: {
          description: "Represents an integration test case",
          type: "object",
          properties: {
            stacks: {
              description: "Stacks that should be tested as part of this test case\nThe stackNames will be passed as args to the cdk commands\nso dependent stacks will be automatically deployed unless\n`exclusively` is passed",
              type: "array",
              items: {
                type: "string"
              }
            },
            assertionStack: {
              description: "The node id of the stack that contains assertions.\nThis is the value that can be used to deploy the stack with the CDK CLI (Default - no assertion stack)",
              type: "string"
            },
            assertionStackName: {
              description: "The name of the stack that contains assertions (Default - no assertion stack)",
              type: "string"
            },
            stackUpdateWorkflow: {
              description: "Run update workflow on this test case\nThis should only be set to false to test scenarios\nthat are not possible to test as part of the update workflow (Default true)",
              type: "boolean"
            },
            cdkCommandOptions: {
              description: "Additional options to use for each CDK command (Default - runner default options)",
              $ref: "#/definitions/CdkCommands"
            },
            hooks: {
              description: "Additional commands to run at predefined points in the test workflow\n\ne.g. { postDeploy: ['yarn', 'test'] } (Default - no hooks)",
              $ref: "#/definitions/Hooks"
            },
            diffAssets: {
              description: "Whether or not to include asset hashes in the diff\nAsset hashes can introduces a lot of unneccessary noise into tests,\nbut there are some cases where asset hashes _should_ be included. For example\nany tests involving custom resources or bundling",
              default: false,
              type: "boolean"
            },
            allowDestroy: {
              description: "List of CloudFormation resource types in this stack that can\nbe destroyed as part of an update without failing the test.\n\nThis list should only include resources that for this specific\nintegration test we are sure will not cause errors or an outage if\ndestroyed. For example, maybe we know that a new resource will be created\nfirst before the old resource is destroyed which prevents any outage.\n\ne.g. ['AWS::IAM::Role'] (Default - do not allow destruction of any resources on update)",
              type: "array",
              items: {
                type: "string"
              }
            },
            regions: {
              description: "Limit deployment to these regions (Default - can run in any region)",
              type: "array",
              items: {
                type: "string"
              }
            }
          },
          required: [
            "stacks"
          ]
        },
        CdkCommands: {
          description: "Options for specific cdk commands that are run\nas part of the integration test workflow",
          type: "object",
          properties: {
            deploy: {
              description: "Options to for the cdk deploy command (Default - default deploy options)",
              $ref: "#/definitions/DeployCommand"
            },
            destroy: {
              description: "Options to for the cdk destroy command (Default - default destroy options)",
              $ref: "#/definitions/DestroyCommand"
            }
          }
        },
        DeployCommand: {
          description: "Represents a cdk deploy command",
          type: "object",
          properties: {
            args: {
              description: "Additional arguments to pass to the command\nThis can be used to test specific CLI functionality (Default - only default args are used)",
              $ref: "#/definitions/DeployOptions"
            },
            enabled: {
              description: "Whether or not to run this command as part of the workflow\nThis can be used if you only want to test some of the workflow\nfor example enable `synth` and disable `deploy` & `destroy` in order\nto limit the test to synthesis (Default true)",
              type: "boolean"
            },
            expectError: {
              description: "If the runner should expect this command to fail",
              default: false,
              type: "boolean"
            },
            expectedMessage: {
              description: "This can be used in combination with `expectedError`\nto validate that a specific message is returned. (Default - do not validate message)",
              type: "string"
            }
          }
        },
        DeployOptions: {
          description: "Options to use with cdk deploy",
          type: "object",
          properties: {
            exclusively: {
              description: "Only perform action on the given stack",
              default: false,
              type: "boolean"
            },
            toolkitStackName: {
              description: "Name of the toolkit stack to use/deploy (Default CDKToolkit)",
              type: "string"
            },
            reuseAssets: {
              description: "Reuse the assets with the given asset IDs (Default - do not reuse assets)",
              type: "array",
              items: {
                type: "string"
              }
            },
            changeSetName: {
              description: "Optional name to use for the CloudFormation change set.\nIf not provided, a name will be generated automatically. (Default - auto generate a name)",
              type: "string"
            },
            force: {
              description: "Always deploy, even if templates are identical.",
              default: false,
              type: "boolean"
            },
            rollback: {
              description: "Rollback failed deployments (Default true)",
              type: "boolean"
            },
            notificationArns: {
              description: "ARNs of SNS topics that CloudFormation will notify with stack related events (Default - no notifications)",
              type: "array",
              items: {
                type: "string"
              }
            },
            requireApproval: {
              description: "What kind of security changes require approval (Default RequireApproval.Never)",
              enum: [
                "any-change",
                "broadening",
                "never"
              ],
              type: "string"
            },
            execute: {
              description: "Whether to execute the ChangeSet\nNot providing `execute` parameter will result in execution of ChangeSet (Default true)",
              type: "boolean"
            },
            parameters: {
              description: "Additional parameters for CloudFormation at deploy time (Default [object Object])",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            usePreviousParameters: {
              description: "Use previous values for unspecified parameters\n\nIf not set, all parameters must be specified for every deployment. (Default true)",
              type: "boolean"
            },
            outputsFile: {
              description: "Path to file where stack outputs will be written after a successful deploy as JSON (Default - Outputs are not written to any file)",
              type: "string"
            },
            ci: {
              description: "Whether we are on a CI system",
              default: false,
              type: "boolean"
            },
            stacks: {
              description: "List of stacks to deploy\n\nRequried if `all` is not set (Default - [])",
              type: "array",
              items: {
                type: "string"
              }
            },
            all: {
              description: "Deploy all stacks\n\nRequried if `stacks` is not set (Default - false)",
              type: "boolean"
            },
            app: {
              description: 'command-line for executing your app or a cloud assembly directory\ne.g. "node bin/my-app.js"\nor\n"cdk.out" (Default - read from cdk.json)',
              type: "string"
            },
            roleArn: {
              description: "Role to pass to CloudFormation for deployment (Default - use the bootstrap cfn-exec role)",
              type: "string"
            },
            context: {
              description: "Additional context (Default - no additional context)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            trace: {
              description: "Print trace for stack warnings",
              default: false,
              type: "boolean"
            },
            strict: {
              description: "Do not construct stacks with warnings",
              default: false,
              type: "boolean"
            },
            lookups: {
              description: "Perform context lookups.\n\nSynthesis fails if this is disabled and context lookups need\nto be performed (Default true)",
              type: "boolean"
            },
            ignoreErrors: {
              description: "Ignores synthesis errors, which will likely produce an invalid output",
              default: false,
              type: "boolean"
            },
            json: {
              description: "Use JSON output instead of YAML when templates are printed\nto STDOUT",
              default: false,
              type: "boolean"
            },
            verbose: {
              description: "show debug logs",
              default: false,
              type: "boolean"
            },
            debug: {
              description: "enable emission of additional debugging information, such as creation stack\ntraces of tokens",
              default: false,
              type: "boolean"
            },
            profile: {
              description: "Use the indicated AWS profile as the default environment (Default - no profile is used)",
              type: "string"
            },
            proxy: {
              description: "Use the indicated proxy. Will read from\nHTTPS_PROXY environment if specified (Default - no proxy)",
              type: "string"
            },
            caBundlePath: {
              description: "Path to CA certificate to use when validating HTTPS\nrequests. (Default - read from AWS_CA_BUNDLE environment variable)",
              type: "string"
            },
            ec2Creds: {
              description: "Force trying to fetch EC2 instance credentials (Default - guess EC2 instance status)",
              type: "boolean"
            },
            versionReporting: {
              description: 'Include "AWS::CDK::Metadata" resource in synthesized templates (Default true)',
              type: "boolean"
            },
            pathMetadata: {
              description: 'Include "aws:cdk:path" CloudFormation metadata for each resource (Default true)',
              type: "boolean"
            },
            assetMetadata: {
              description: 'Include "aws:asset:*" CloudFormation metadata for resources that use assets (Default true)',
              type: "boolean"
            },
            staging: {
              description: "Copy assets to the output directory\n\nNeeded for local debugging the source files with SAM CLI",
              default: false,
              type: "boolean"
            },
            output: {
              description: "Emits the synthesized cloud assembly into a directory (Default cdk.out)",
              type: "string"
            },
            notices: {
              description: "Show relevant notices (Default true)",
              type: "boolean"
            },
            color: {
              description: "Show colors and other style from console output (Default true)",
              type: "boolean"
            }
          }
        },
        DestroyCommand: {
          description: "Represents a cdk destroy command",
          type: "object",
          properties: {
            args: {
              description: "Additional arguments to pass to the command\nThis can be used to test specific CLI functionality (Default - only default args are used)",
              $ref: "#/definitions/DestroyOptions"
            },
            enabled: {
              description: "Whether or not to run this command as part of the workflow\nThis can be used if you only want to test some of the workflow\nfor example enable `synth` and disable `deploy` & `destroy` in order\nto limit the test to synthesis (Default true)",
              type: "boolean"
            },
            expectError: {
              description: "If the runner should expect this command to fail",
              default: false,
              type: "boolean"
            },
            expectedMessage: {
              description: "This can be used in combination with `expectedError`\nto validate that a specific message is returned. (Default - do not validate message)",
              type: "string"
            }
          }
        },
        DestroyOptions: {
          description: "Options to use with cdk destroy",
          type: "object",
          properties: {
            force: {
              description: "Do not ask for permission before destroying stacks",
              default: false,
              type: "boolean"
            },
            exclusively: {
              description: "Only destroy the given stack",
              default: false,
              type: "boolean"
            },
            stacks: {
              description: "List of stacks to deploy\n\nRequried if `all` is not set (Default - [])",
              type: "array",
              items: {
                type: "string"
              }
            },
            all: {
              description: "Deploy all stacks\n\nRequried if `stacks` is not set (Default - false)",
              type: "boolean"
            },
            app: {
              description: 'command-line for executing your app or a cloud assembly directory\ne.g. "node bin/my-app.js"\nor\n"cdk.out" (Default - read from cdk.json)',
              type: "string"
            },
            roleArn: {
              description: "Role to pass to CloudFormation for deployment (Default - use the bootstrap cfn-exec role)",
              type: "string"
            },
            context: {
              description: "Additional context (Default - no additional context)",
              type: "object",
              additionalProperties: {
                type: "string"
              }
            },
            trace: {
              description: "Print trace for stack warnings",
              default: false,
              type: "boolean"
            },
            strict: {
              description: "Do not construct stacks with warnings",
              default: false,
              type: "boolean"
            },
            lookups: {
              description: "Perform context lookups.\n\nSynthesis fails if this is disabled and context lookups need\nto be performed (Default true)",
              type: "boolean"
            },
            ignoreErrors: {
              description: "Ignores synthesis errors, which will likely produce an invalid output",
              default: false,
              type: "boolean"
            },
            json: {
              description: "Use JSON output instead of YAML when templates are printed\nto STDOUT",
              default: false,
              type: "boolean"
            },
            verbose: {
              description: "show debug logs",
              default: false,
              type: "boolean"
            },
            debug: {
              description: "enable emission of additional debugging information, such as creation stack\ntraces of tokens",
              default: false,
              type: "boolean"
            },
            profile: {
              description: "Use the indicated AWS profile as the default environment (Default - no profile is used)",
              type: "string"
            },
            proxy: {
              description: "Use the indicated proxy. Will read from\nHTTPS_PROXY environment if specified (Default - no proxy)",
              type: "string"
            },
            caBundlePath: {
              description: "Path to CA certificate to use when validating HTTPS\nrequests. (Default - read from AWS_CA_BUNDLE environment variable)",
              type: "string"
            },
            ec2Creds: {
              description: "Force trying to fetch EC2 instance credentials (Default - guess EC2 instance status)",
              type: "boolean"
            },
            versionReporting: {
              description: 'Include "AWS::CDK::Metadata" resource in synthesized templates (Default true)',
              type: "boolean"
            },
            pathMetadata: {
              description: 'Include "aws:cdk:path" CloudFormation metadata for each resource (Default true)',
              type: "boolean"
            },
            assetMetadata: {
              description: 'Include "aws:asset:*" CloudFormation metadata for resources that use assets (Default true)',
              type: "boolean"
            },
            staging: {
              description: "Copy assets to the output directory\n\nNeeded for local debugging the source files with SAM CLI",
              default: false,
              type: "boolean"
            },
            output: {
              description: "Emits the synthesized cloud assembly into a directory (Default cdk.out)",
              type: "string"
            },
            notices: {
              description: "Show relevant notices (Default true)",
              type: "boolean"
            },
            color: {
              description: "Show colors and other style from console output (Default true)",
              type: "boolean"
            }
          }
        },
        Hooks: {
          description: "Commands to run at predefined points during the\nintegration test workflow",
          type: "object",
          properties: {
            preDeploy: {
              description: "Commands to run prior to deploying the cdk stacks\nin the integration test (Default - no commands)",
              type: "array",
              items: {
                type: "string"
              }
            },
            postDeploy: {
              description: "Commands to run prior after deploying the cdk stacks\nin the integration test (Default - no commands)",
              type: "array",
              items: {
                type: "string"
              }
            },
            preDestroy: {
              description: "Commands to run prior to destroying the cdk stacks\nin the integration test (Default - no commands)",
              type: "array",
              items: {
                type: "string"
              }
            },
            postDestroy: {
              description: "Commands to run after destroying the cdk stacks\nin the integration test (Default - no commands)",
              type: "array",
              items: {
                type: "string"
              }
            }
          }
        }
      },
      $schema: "http://json-schema.org/draft-07/schema#"
    };
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/manifest.js
var require_manifest = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/manifest.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.Manifest = exports.VERSION_MISMATCH = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs = require("fs");
    var jsonschema = require_lib();
    var semver = require_semver2();
    var assembly = require_cloud_assembly();
    exports.VERSION_MISMATCH = "Cloud assembly schema version mismatch";
    var ASSETS_SCHEMA = require_assets_schema();
    var ASSEMBLY_SCHEMA = require_cloud_assembly_schema();
    var SCHEMA_VERSION = require_cloud_assembly_version().version;
    var INTEG_SCHEMA = require_integ_schema();
    var Manifest = class {
      constructor() {
      }
      static saveAssemblyManifest(manifest, filePath) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_AssemblyManifest(manifest);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.saveAssemblyManifest), error;
        }
        Manifest.saveManifest(manifest, filePath, ASSEMBLY_SCHEMA, Manifest.patchStackTagsOnWrite);
      }
      static loadAssemblyManifest(filePath, options) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_LoadManifestOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.loadAssemblyManifest), error;
        }
        return Manifest.loadManifest(filePath, ASSEMBLY_SCHEMA, Manifest.patchStackTagsOnRead, options);
      }
      static saveAssetManifest(manifest, filePath) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_AssetManifest(manifest);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.saveAssetManifest), error;
        }
        Manifest.saveManifest(manifest, filePath, ASSETS_SCHEMA, Manifest.patchStackTagsOnRead);
      }
      static loadAssetManifest(filePath) {
        return this.loadManifest(filePath, ASSETS_SCHEMA);
      }
      static saveIntegManifest(manifest, filePath) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_IntegManifest(manifest);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.saveIntegManifest), error;
        }
        Manifest.saveManifest(manifest, filePath, INTEG_SCHEMA);
      }
      static loadIntegManifest(filePath) {
        return this.loadManifest(filePath, INTEG_SCHEMA);
      }
      static version() {
        return SCHEMA_VERSION;
      }
      static save(manifest, filePath) {
        return this.saveAssemblyManifest(manifest, filePath);
      }
      static load(filePath) {
        return this.loadAssemblyManifest(filePath);
      }
      static validate(manifest, schema, options) {
        function parseVersion(version) {
          const ver = semver.valid(version);
          if (!ver)
            throw new Error(`Invalid semver string: "${version}"`);
          return ver;
        }
        const maxSupported = parseVersion(Manifest.version()), actual = parseVersion(manifest.version);
        if (semver.gt(actual, maxSupported) && !(options == null ? void 0 : options.skipVersionCheck))
          throw new Error(`${exports.VERSION_MISMATCH}: Maximum schema version supported is ${maxSupported}, but found ${actual}`);
        let errors = new jsonschema.Validator().validate(manifest, schema, { nestedErrors: true, allowUnknownAttributes: false }).errors;
        if ((options == null ? void 0 : options.skipEnumCheck) && (errors = stripEnumErrors(errors)), errors.length > 0)
          throw new Error(`Invalid assembly manifest:
${errors.map((e) => e.stack).join(`
`)}`);
      }
      static saveManifest(manifest, filePath, schema, preprocess) {
        let withVersion = { ...manifest, version: Manifest.version() };
        Manifest.validate(withVersion, schema), preprocess && (withVersion = preprocess(withVersion)), fs.writeFileSync(filePath, JSON.stringify(withVersion, void 0, 2));
      }
      static loadManifest(filePath, schema, preprocess, options) {
        let obj = JSON.parse(fs.readFileSync(filePath, { encoding: "utf-8" }));
        return preprocess && (obj = preprocess(obj)), Manifest.validate(obj, schema, options), obj;
      }
      static patchStackTagsOnRead(manifest) {
        return Manifest.replaceStackTags(manifest, (tags) => tags.map((diskTag) => ({ key: diskTag.Key, value: diskTag.Value })));
      }
      static patchStackTagsOnWrite(manifest) {
        return Manifest.replaceStackTags(manifest, (tags) => tags.map((memTag) => "Key" in memTag ? memTag : { Key: memTag.key, Value: memTag.value }));
      }
      static replaceStackTags(manifest, fn) {
        return noUndefined({ ...manifest, artifacts: mapValues(manifest.artifacts, (artifact) => artifact.type !== assembly.ArtifactType.AWS_CLOUDFORMATION_STACK ? artifact : noUndefined({ ...artifact, metadata: mapValues(artifact.metadata, (metadataEntries) => metadataEntries.map((metadataEntry) => metadataEntry.type !== assembly.ArtifactMetadataEntryType.STACK_TAGS || !metadataEntry.data ? metadataEntry : { ...metadataEntry, data: fn(metadataEntry.data) })) })) });
      }
    };
    exports.Manifest = Manifest, _a = JSII_RTTI_SYMBOL_1, Manifest[_a] = { fqn: "aws-cdk-lib.cloud_assembly_schema.Manifest", version: "2.50.0" };
    function mapValues(xs, fn) {
      if (!xs)
        return;
      const ret = {};
      for (const [k, v] of Object.entries(xs))
        ret[k] = fn(v);
      return ret;
    }
    function noUndefined(xs) {
      const ret = {};
      for (const [k, v] of Object.entries(xs))
        v !== void 0 && (ret[k] = v);
      return ret;
    }
    function stripEnumErrors(errors) {
      return errors.filter((e) => typeof e.schema == "string" || !("enum" in e.schema));
    }
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/integ-tests/schema.js
var require_schema3 = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/integ-tests/schema.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/integ-tests/commands/common.js
var require_common = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/integ-tests/commands/common.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.RequireApproval = void 0;
    var RequireApproval;
    (function(RequireApproval2) {
      RequireApproval2.NEVER = "never", RequireApproval2.ANYCHANGE = "any-change", RequireApproval2.BROADENING = "broadening";
    })(RequireApproval = exports.RequireApproval || (exports.RequireApproval = {}));
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/integ-tests/commands/deploy.js
var require_deploy = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/integ-tests/commands/deploy.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/integ-tests/commands/destroy.js
var require_destroy = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/integ-tests/commands/destroy.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/integ-tests/commands/index.js
var require_commands = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/integ-tests/commands/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        p !== "default" && !exports2.hasOwnProperty(p) && __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true }), __exportStar(require_common(), exports), __exportStar(require_deploy(), exports), __exportStar(require_destroy(), exports);
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/integ-tests/test-case.js
var require_test_case = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/integ-tests/test-case.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/integ-tests/index.js
var require_integ_tests = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/integ-tests/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        p !== "default" && !exports2.hasOwnProperty(p) && __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true }), __exportStar(require_schema3(), exports), __exportStar(require_commands(), exports), __exportStar(require_test_case(), exports);
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/lib/index.js
var require_lib2 = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/lib/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        p !== "default" && !exports2.hasOwnProperty(p) && __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true }), __exportStar(require_cloud_assembly(), exports), __exportStar(require_assets(), exports), __exportStar(require_manifest(), exports), __exportStar(require_integ_tests(), exports);
  }
});

// node_modules/aws-cdk-lib/cloud-assembly-schema/index.js
var require_cloud_assembly_schema2 = __commonJS({
  "node_modules/aws-cdk-lib/cloud-assembly-schema/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        p !== "default" && !exports2.hasOwnProperty(p) && __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true }), __exportStar(require_lib2(), exports);
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/cxapi.js
var require_cxapi = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/cxapi.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.SSMPARAM_NO_INVALIDATE = exports.PROVIDER_ERROR_KEY = exports.CLI_VERSION_ENV = exports.CLI_ASM_VERSION_ENV = exports.DEFAULT_REGION_ENV = exports.DEFAULT_ACCOUNT_ENV = exports.CONTEXT_OVERFLOW_LOCATION_ENV = exports.CONTEXT_ENV = exports.OUTDIR_ENV = void 0, exports.OUTDIR_ENV = "CDK_OUTDIR", exports.CONTEXT_ENV = "CDK_CONTEXT_JSON", exports.CONTEXT_OVERFLOW_LOCATION_ENV = "CONTEXT_OVERFLOW_LOCATION_ENV", exports.DEFAULT_ACCOUNT_ENV = "CDK_DEFAULT_ACCOUNT", exports.DEFAULT_REGION_ENV = "CDK_DEFAULT_REGION", exports.CLI_ASM_VERSION_ENV = "CDK_CLI_ASM_VERSION", exports.CLI_VERSION_ENV = "CDK_CLI_VERSION", exports.PROVIDER_ERROR_KEY = "$providerError", exports.SSMPARAM_NO_INVALIDATE = "[cdk:skip]";
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/context/vpc.js
var require_vpc = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/context/vpc.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.VpcSubnetGroupType = void 0;
    var VpcSubnetGroupType;
    (function(VpcSubnetGroupType2) {
      VpcSubnetGroupType2.PUBLIC = "Public", VpcSubnetGroupType2.PRIVATE = "Private", VpcSubnetGroupType2.ISOLATED = "Isolated";
    })(VpcSubnetGroupType = exports.VpcSubnetGroupType || (exports.VpcSubnetGroupType = {}));
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/context/ami.js
var require_ami = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/context/ami.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/context/load-balancer.js
var require_load_balancer = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/context/load-balancer.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.LoadBalancerIpAddressType = void 0;
    var LoadBalancerIpAddressType;
    (function(LoadBalancerIpAddressType2) {
      LoadBalancerIpAddressType2.IPV4 = "ipv4", LoadBalancerIpAddressType2.DUAL_STACK = "dualstack";
    })(LoadBalancerIpAddressType = exports.LoadBalancerIpAddressType || (exports.LoadBalancerIpAddressType = {}));
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/context/availability-zones.js
var require_availability_zones = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/context/availability-zones.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.AVAILABILITY_ZONE_FALLBACK_CONTEXT_KEY = void 0, exports.AVAILABILITY_ZONE_FALLBACK_CONTEXT_KEY = "aws:cdk:availability-zones:fallback";
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/context/endpoint-service-availability-zones.js
var require_endpoint_service_availability_zones = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/context/endpoint-service-availability-zones.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER = void 0, exports.ENDPOINT_SERVICE_AVAILABILITY_ZONE_PROVIDER = "endpoint-service-availability-zones";
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/context/security-group.js
var require_security_group = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/context/security-group.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/context/key.js
var require_key = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/context/key.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/metadata.js
var require_metadata = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/metadata.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.SynthesisMessageLevel = exports.PATH_METADATA_KEY = void 0, exports.PATH_METADATA_KEY = "aws:cdk:path";
    var SynthesisMessageLevel;
    (function(SynthesisMessageLevel2) {
      SynthesisMessageLevel2.INFO = "info", SynthesisMessageLevel2.WARNING = "warning", SynthesisMessageLevel2.ERROR = "error";
    })(SynthesisMessageLevel = exports.SynthesisMessageLevel || (exports.SynthesisMessageLevel = {}));
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/cloud-artifact.js
var require_cloud_artifact = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/cloud-artifact.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CloudArtifact = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxschema = require_cloud_assembly_schema2();
    var metadata_1 = require_metadata();
    var CloudArtifact = class {
      constructor(assembly, id, manifest) {
        this.assembly = assembly, this.id = id;
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cx_api_CloudAssembly(assembly), jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_ArtifactManifest(manifest);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CloudArtifact), error;
        }
        this.manifest = manifest, this.messages = this.renderMessages(), this._dependencyIDs = manifest.dependencies || [];
      }
      static fromManifest(assembly, id, artifact) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cx_api_CloudAssembly(assembly), jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_ArtifactManifest(artifact);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.fromManifest), error;
        }
        throw new Error("Implementation not overridden yet");
      }
      get dependencies() {
        return this._deps ? this._deps : (this._deps = this._dependencyIDs.map((id) => {
          const dep = this.assembly.tryGetArtifact(id);
          if (!dep)
            throw new Error(`Artifact ${this.id} depends on non-existing artifact ${id}`);
          return dep;
        }), this._deps);
      }
      findMetadataByType(type) {
        const result = new Array();
        for (const path of Object.keys(this.manifest.metadata || {}))
          for (const entry of (this.manifest.metadata || {})[path])
            entry.type === type && result.push({ path, ...entry });
        return result;
      }
      renderMessages() {
        const messages = new Array();
        for (const [id, metadata] of Object.entries(this.manifest.metadata || {}))
          for (const entry of metadata) {
            let level;
            switch (entry.type) {
              case cxschema.ArtifactMetadataEntryType.WARN:
                level = metadata_1.SynthesisMessageLevel.WARNING;
                break;
              case cxschema.ArtifactMetadataEntryType.ERROR:
                level = metadata_1.SynthesisMessageLevel.ERROR;
                break;
              case cxschema.ArtifactMetadataEntryType.INFO:
                level = metadata_1.SynthesisMessageLevel.INFO;
                break;
              default:
                continue;
            }
            messages.push({ level, entry, id });
          }
        return messages;
      }
      get hierarchicalId() {
        return this.manifest.displayName ?? this.id;
      }
    };
    exports.CloudArtifact = CloudArtifact, _a = JSII_RTTI_SYMBOL_1, CloudArtifact[_a] = { fqn: "aws-cdk-lib.cx_api.CloudArtifact", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/artifacts/asset-manifest-artifact.js
var require_asset_manifest_artifact = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/artifacts/asset-manifest-artifact.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.AssetManifestArtifact = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs = require("fs");
    var path = require("path");
    var cloud_artifact_1 = require_cloud_artifact();
    var ASSET_MANIFEST_ARTIFACT_SYM = Symbol.for("@aws-cdk/cx-api.AssetManifestArtifact");
    var AssetManifestArtifact = class extends cloud_artifact_1.CloudArtifact {
      constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cx_api_CloudAssembly(assembly), jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_ArtifactManifest(artifact);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, AssetManifestArtifact), error;
        }
        const properties = this.manifest.properties || {};
        if (!properties.file)
          throw new Error('Invalid AssetManifestArtifact. Missing "file" property');
        this.file = path.resolve(this.assembly.directory, properties.file), this.requiresBootstrapStackVersion = properties.requiresBootstrapStackVersion, this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter;
      }
      static isAssetManifestArtifact(art) {
        return art && typeof art == "object" && art[ASSET_MANIFEST_ARTIFACT_SYM];
      }
      get contents() {
        return this._contents !== void 0 ? this._contents : this._contents = JSON.parse(fs.readFileSync(this.file, "utf-8"));
      }
    };
    exports.AssetManifestArtifact = AssetManifestArtifact, _a = JSII_RTTI_SYMBOL_1, AssetManifestArtifact[_a] = { fqn: "aws-cdk-lib.cx_api.AssetManifestArtifact", version: "2.50.0" }, Object.defineProperty(AssetManifestArtifact.prototype, ASSET_MANIFEST_ARTIFACT_SYM, { value: true, enumerable: false, writable: false });
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/environment.js
var require_environment = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/environment.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.EnvironmentUtils = exports.UNKNOWN_REGION = exports.UNKNOWN_ACCOUNT = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var AWS_ENV_REGEX = /aws\:\/\/([a-z0-9A-Z\-\@\.\_]+)\/([a-z\-0-9]+)/;
    exports.UNKNOWN_ACCOUNT = "unknown-account", exports.UNKNOWN_REGION = "unknown-region";
    var EnvironmentUtils = class {
      static parse(environment) {
        const env = AWS_ENV_REGEX.exec(environment);
        if (!env)
          throw new Error(`Unable to parse environment specification "${environment}". Expected format: aws://account/region`);
        const [, account, region] = env;
        if (!account || !region)
          throw new Error(`Invalid environment specification: ${environment}`);
        return { account, region, name: environment };
      }
      static make(account, region) {
        return { account, region, name: this.format(account, region) };
      }
      static format(account, region) {
        return `aws://${account}/${region}`;
      }
    };
    exports.EnvironmentUtils = EnvironmentUtils, _a = JSII_RTTI_SYMBOL_1, EnvironmentUtils[_a] = { fqn: "aws-cdk-lib.cx_api.EnvironmentUtils", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/artifacts/cloudformation-artifact.js
var require_cloudformation_artifact = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/artifacts/cloudformation-artifact.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CloudFormationStackArtifact = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs = require("fs");
    var path = require("path");
    var cxschema = require_cloud_assembly_schema2();
    var cloud_artifact_1 = require_cloud_artifact();
    var environment_1 = require_environment();
    var CloudFormationStackArtifact = class extends cloud_artifact_1.CloudArtifact {
      constructor(assembly, artifactId, artifact) {
        super(assembly, artifactId, artifact);
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cx_api_CloudAssembly(assembly), jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_ArtifactManifest(artifact);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CloudFormationStackArtifact), error;
        }
        const properties = this.manifest.properties || {};
        if (!properties.templateFile)
          throw new Error('Invalid CloudFormation stack artifact. Missing "templateFile" property in cloud assembly manifest');
        if (!artifact.environment)
          throw new Error("Invalid CloudFormation stack artifact. Missing environment");
        this.environment = environment_1.EnvironmentUtils.parse(artifact.environment), this.templateFile = properties.templateFile, this.parameters = properties.parameters ?? {}, this.tags = properties.tags ?? this.tagsFromMetadata(), this.assumeRoleArn = properties.assumeRoleArn, this.assumeRoleExternalId = properties.assumeRoleExternalId, this.cloudFormationExecutionRoleArn = properties.cloudFormationExecutionRoleArn, this.stackTemplateAssetObjectUrl = properties.stackTemplateAssetObjectUrl, this.requiresBootstrapStackVersion = properties.requiresBootstrapStackVersion, this.bootstrapStackVersionSsmParameter = properties.bootstrapStackVersionSsmParameter, this.terminationProtection = properties.terminationProtection, this.validateOnSynth = properties.validateOnSynth, this.lookupRole = properties.lookupRole, this.stackName = properties.stackName || artifactId, this.assets = this.findMetadataByType(cxschema.ArtifactMetadataEntryType.ASSET).map((e) => e.data), this.displayName = this.stackName === artifactId ? this.hierarchicalId : `${this.hierarchicalId} (${this.stackName})`, this.name = this.stackName, this.originalName = this.stackName;
      }
      get templateFullPath() {
        return path.join(this.assembly.directory, this.templateFile);
      }
      get template() {
        return this._template === void 0 && (this._template = JSON.parse(fs.readFileSync(this.templateFullPath, "utf-8"))), this._template;
      }
      tagsFromMetadata() {
        const ret = {};
        for (const metadataEntry of this.findMetadataByType(cxschema.ArtifactMetadataEntryType.STACK_TAGS))
          for (const tag of metadataEntry.data ?? [])
            ret[tag.key] = tag.value;
        return ret;
      }
    };
    exports.CloudFormationStackArtifact = CloudFormationStackArtifact, _a = JSII_RTTI_SYMBOL_1, CloudFormationStackArtifact[_a] = { fqn: "aws-cdk-lib.cx_api.CloudFormationStackArtifact", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/artifacts/nested-cloud-assembly-artifact.js
var require_nested_cloud_assembly_artifact = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/artifacts/nested-cloud-assembly-artifact.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.NestedCloudAssemblyArtifact = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var path = require("path");
    var cloud_artifact_1 = require_cloud_artifact();
    var NestedCloudAssemblyArtifact = class extends cloud_artifact_1.CloudArtifact {
      constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cx_api_CloudAssembly(assembly), jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_ArtifactManifest(artifact);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, NestedCloudAssemblyArtifact), error;
        }
        const properties = this.manifest.properties || {};
        this.directoryName = properties.directoryName, this.displayName = properties.displayName ?? name;
      }
      get fullPath() {
        return path.join(this.assembly.directory, this.directoryName);
      }
    };
    exports.NestedCloudAssemblyArtifact = NestedCloudAssemblyArtifact, _a = JSII_RTTI_SYMBOL_1, NestedCloudAssemblyArtifact[_a] = { fqn: "aws-cdk-lib.cx_api.NestedCloudAssemblyArtifact", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/artifacts/tree-cloud-artifact.js
var require_tree_cloud_artifact = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/artifacts/tree-cloud-artifact.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.TreeCloudArtifact = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cloud_artifact_1 = require_cloud_artifact();
    var TreeCloudArtifact = class extends cloud_artifact_1.CloudArtifact {
      constructor(assembly, name, artifact) {
        super(assembly, name, artifact);
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cx_api_CloudAssembly(assembly), jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_ArtifactManifest(artifact);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, TreeCloudArtifact), error;
        }
        const properties = this.manifest.properties || {};
        if (!properties.file)
          throw new Error('Invalid TreeCloudArtifact. Missing "file" property');
        this.file = properties.file;
      }
    };
    exports.TreeCloudArtifact = TreeCloudArtifact, _a = JSII_RTTI_SYMBOL_1, TreeCloudArtifact[_a] = { fqn: "aws-cdk-lib.cx_api.TreeCloudArtifact", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/cloud-artifact-aug.js
var require_cloud_artifact_aug = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/cloud-artifact-aug.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var cxschema = require_cloud_assembly_schema2();
    var asset_manifest_artifact_1 = require_asset_manifest_artifact();
    var cloudformation_artifact_1 = require_cloudformation_artifact();
    var nested_cloud_assembly_artifact_1 = require_nested_cloud_assembly_artifact();
    var tree_cloud_artifact_1 = require_tree_cloud_artifact();
    var cloud_artifact_1 = require_cloud_artifact();
    cloud_artifact_1.CloudArtifact.fromManifest = function(assembly, id, artifact) {
      switch (artifact.type) {
        case cxschema.ArtifactType.AWS_CLOUDFORMATION_STACK:
          return new cloudformation_artifact_1.CloudFormationStackArtifact(assembly, id, artifact);
        case cxschema.ArtifactType.CDK_TREE:
          return new tree_cloud_artifact_1.TreeCloudArtifact(assembly, id, artifact);
        case cxschema.ArtifactType.ASSET_MANIFEST:
          return new asset_manifest_artifact_1.AssetManifestArtifact(assembly, id, artifact);
        case cxschema.ArtifactType.NESTED_CLOUD_ASSEMBLY:
          return new nested_cloud_assembly_artifact_1.NestedCloudAssemblyArtifact(assembly, id, artifact);
        default:
          return;
      }
    };
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/toposort.js
var require_toposort = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/toposort.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.topologicalSort = void 0;
    function topologicalSort(xs, keyFn, depFn) {
      const remaining = /* @__PURE__ */ new Map();
      for (const element of xs) {
        const key = keyFn(element);
        remaining.set(key, { key, element, dependencies: depFn(element) });
      }
      const ret = new Array();
      for (; remaining.size > 0; ) {
        const selectable = Array.from(remaining.values()).filter((e) => e.dependencies.every((d) => !remaining.has(d)));
        selectable.sort((a, b) => a.key < b.key ? -1 : b.key < a.key ? 1 : 0);
        for (const selected of selectable)
          ret.push(selected.element), remaining.delete(selected.key);
        if (selectable.length === 0)
          throw new Error(`Could not determine ordering between: ${Array.from(remaining.keys()).join(", ")}`);
      }
      return ret;
    }
    exports.topologicalSort = topologicalSort;
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/cloud-assembly.js
var require_cloud_assembly2 = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/cloud-assembly.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CloudAssemblyBuilder = exports.CloudAssembly = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs = require("fs");
    var os = require("os");
    var path = require("path");
    var cxschema = require_cloud_assembly_schema2();
    var cloudformation_artifact_1 = require_cloudformation_artifact();
    var nested_cloud_assembly_artifact_1 = require_nested_cloud_assembly_artifact();
    var tree_cloud_artifact_1 = require_tree_cloud_artifact();
    var cloud_artifact_1 = require_cloud_artifact();
    var toposort_1 = require_toposort();
    var MANIFEST_FILE = "manifest.json";
    var CloudAssembly = class {
      constructor(directory, loadOptions) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_LoadManifestOptions(loadOptions);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CloudAssembly), error;
        }
        this.directory = directory, this.manifest = cxschema.Manifest.loadAssemblyManifest(path.join(directory, MANIFEST_FILE), loadOptions), this.version = this.manifest.version, this.artifacts = this.renderArtifacts(), this.runtime = this.manifest.runtime || { libraries: {} }, this.validateDeps();
      }
      tryGetArtifact(id) {
        return this.artifacts.find((a) => a.id === id);
      }
      getStackByName(stackName) {
        const artifacts = this.artifacts.filter((a) => a instanceof cloudformation_artifact_1.CloudFormationStackArtifact && a.stackName === stackName);
        if (!artifacts || artifacts.length === 0)
          throw new Error(`Unable to find stack with stack name "${stackName}"`);
        if (artifacts.length > 1)
          throw new Error(`There are multiple stacks with the stack name "${stackName}" (${artifacts.map((a) => a.id).join(",")}). Use "getStackArtifact(id)" instead`);
        return artifacts[0];
      }
      getStack(stackName) {
        return this.getStackByName(stackName);
      }
      getStackArtifact(artifactId) {
        const artifact = this.tryGetArtifactRecursively(artifactId);
        if (!artifact)
          throw new Error(`Unable to find artifact with id "${artifactId}"`);
        if (!(artifact instanceof cloudformation_artifact_1.CloudFormationStackArtifact))
          throw new Error(`Artifact ${artifactId} is not a CloudFormation stack`);
        return artifact;
      }
      tryGetArtifactRecursively(artifactId) {
        return this.stacksRecursively.find((a) => a.id === artifactId);
      }
      get stacksRecursively() {
        function search(stackArtifacts, assemblies) {
          if (assemblies.length === 0)
            return stackArtifacts;
          const [head, ...tail] = assemblies, nestedAssemblies = head.nestedAssemblies.map((asm) => asm.nestedAssembly);
          return search(stackArtifacts.concat(head.stacks), tail.concat(nestedAssemblies));
        }
        return search([], [this]);
      }
      getNestedAssemblyArtifact(artifactId) {
        const artifact = this.tryGetArtifact(artifactId);
        if (!artifact)
          throw new Error(`Unable to find artifact with id "${artifactId}"`);
        if (!(artifact instanceof nested_cloud_assembly_artifact_1.NestedCloudAssemblyArtifact))
          throw new Error(`Found artifact '${artifactId}' but it's not a nested cloud assembly`);
        return artifact;
      }
      getNestedAssembly(artifactId) {
        return this.getNestedAssemblyArtifact(artifactId).nestedAssembly;
      }
      tree() {
        const trees = this.artifacts.filter((a) => a.manifest.type === cxschema.ArtifactType.CDK_TREE);
        if (trees.length === 0)
          return;
        if (trees.length > 1)
          throw new Error(`Multiple artifacts of type ${cxschema.ArtifactType.CDK_TREE} found in manifest`);
        const tree = trees[0];
        if (!(tree instanceof tree_cloud_artifact_1.TreeCloudArtifact))
          throw new Error('"Tree" artifact is not of expected type');
        return tree;
      }
      get stacks() {
        return this.artifacts.filter(isCloudFormationStackArtifact);
        function isCloudFormationStackArtifact(x) {
          return x instanceof cloudformation_artifact_1.CloudFormationStackArtifact;
        }
      }
      get nestedAssemblies() {
        return this.artifacts.filter(isNestedCloudAssemblyArtifact);
        function isNestedCloudAssemblyArtifact(x) {
          return x instanceof nested_cloud_assembly_artifact_1.NestedCloudAssemblyArtifact;
        }
      }
      validateDeps() {
        for (const artifact of this.artifacts)
          artifact.dependencies;
      }
      renderArtifacts() {
        const result = new Array();
        for (const [name, artifact] of Object.entries(this.manifest.artifacts || {})) {
          const cloudartifact = cloud_artifact_1.CloudArtifact.fromManifest(this, name, artifact);
          cloudartifact && result.push(cloudartifact);
        }
        return toposort_1.topologicalSort(result, (x) => x.id, (x) => x._dependencyIDs);
      }
    };
    exports.CloudAssembly = CloudAssembly, _a = JSII_RTTI_SYMBOL_1, CloudAssembly[_a] = { fqn: "aws-cdk-lib.cx_api.CloudAssembly", version: "2.50.0" };
    var CloudAssemblyBuilder = class {
      constructor(outdir, props = {}) {
        this.artifacts = {}, this.missing = new Array();
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cx_api_CloudAssemblyBuilderProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CloudAssemblyBuilder), error;
        }
        this.outdir = determineOutputDirectory(outdir), this.assetOutdir = props.assetOutdir ?? this.outdir, this.parentBuilder = props.parentBuilder, ensureDirSync(this.outdir);
      }
      addArtifact(id, manifest) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_ArtifactManifest(manifest);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addArtifact), error;
        }
        this.artifacts[id] = filterUndefined(manifest);
      }
      addMissing(missing) {
        var _a2;
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_MissingContext(missing);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addMissing), error;
        }
        this.missing.every((m) => m.key !== missing.key) && this.missing.push(missing), (_a2 = this.parentBuilder) == null ? void 0 : _a2.addMissing(missing);
      }
      buildAssembly(options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cx_api_AssemblyBuildOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.buildAssembly), error;
        }
        let manifest = { version: cxschema.Manifest.version(), artifacts: this.artifacts, runtime: options.runtimeInfo, missing: this.missing.length > 0 ? this.missing : void 0 };
        manifest = filterUndefined(manifest);
        const manifestFilePath = path.join(this.outdir, MANIFEST_FILE);
        return cxschema.Manifest.saveAssemblyManifest(manifest, manifestFilePath), fs.writeFileSync(path.join(this.outdir, "cdk.out"), JSON.stringify({ version: manifest.version })), new CloudAssembly(this.outdir);
      }
      createNestedAssembly(artifactId, displayName) {
        const directoryName = artifactId, innerAsmDir = path.join(this.outdir, directoryName);
        return this.addArtifact(artifactId, { type: cxschema.ArtifactType.NESTED_CLOUD_ASSEMBLY, properties: { directoryName, displayName } }), new CloudAssemblyBuilder(innerAsmDir, { assetOutdir: this.assetOutdir, parentBuilder: this });
      }
    };
    exports.CloudAssemblyBuilder = CloudAssemblyBuilder, _b = JSII_RTTI_SYMBOL_1, CloudAssemblyBuilder[_b] = { fqn: "aws-cdk-lib.cx_api.CloudAssemblyBuilder", version: "2.50.0" };
    function filterUndefined(obj) {
      if (Array.isArray(obj))
        return obj.filter((x) => x !== void 0).map((x) => filterUndefined(x));
      if (typeof obj == "object") {
        const ret = {};
        for (const [key, value] of Object.entries(obj))
          value !== void 0 && (ret[key] = filterUndefined(value));
        return ret;
      }
      return obj;
    }
    function determineOutputDirectory(outdir) {
      return outdir ?? fs.mkdtempSync(path.join(fs.realpathSync(os.tmpdir()), "cdk.out"));
    }
    function ensureDirSync(dir) {
      if (fs.existsSync(dir)) {
        if (!fs.statSync(dir).isDirectory())
          throw new Error(`${dir} must be a directory`);
      } else
        fs.mkdirSync(dir, { recursive: true });
    }
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/artifacts/nested-cloud-assembly-artifact-aug.js
var require_nested_cloud_assembly_artifact_aug = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/artifacts/nested-cloud-assembly-artifact-aug.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var cloud_assembly_1 = require_cloud_assembly2();
    var nested_cloud_assembly_artifact_1 = require_nested_cloud_assembly_artifact();
    var cacheSym = Symbol();
    Object.defineProperty(nested_cloud_assembly_artifact_1.NestedCloudAssemblyArtifact.prototype, "nestedAssembly", { get() {
      return this[cacheSym] || (this[cacheSym] = new cloud_assembly_1.CloudAssembly(this.fullPath)), this[cacheSym];
    } });
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/assets.js
var require_assets2 = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/assets.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.ASSET_PREFIX_SEPARATOR = exports.ASSET_RESOURCE_METADATA_IS_BUNDLED_KEY = exports.ASSET_RESOURCE_METADATA_PROPERTY_KEY = exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_TARGET_KEY = exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_ARGS_KEY = exports.ASSET_RESOURCE_METADATA_DOCKERFILE_PATH_KEY = exports.ASSET_RESOURCE_METADATA_PATH_KEY = exports.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = void 0, exports.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT = "aws:cdk:enable-asset-metadata", exports.ASSET_RESOURCE_METADATA_PATH_KEY = "aws:asset:path", exports.ASSET_RESOURCE_METADATA_DOCKERFILE_PATH_KEY = "aws:asset:dockerfile-path", exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_ARGS_KEY = "aws:asset:docker-build-args", exports.ASSET_RESOURCE_METADATA_DOCKER_BUILD_TARGET_KEY = "aws:asset:docker-build-target", exports.ASSET_RESOURCE_METADATA_PROPERTY_KEY = "aws:asset:property", exports.ASSET_RESOURCE_METADATA_IS_BUNDLED_KEY = "aws:asset:is-bundled", exports.ASSET_PREFIX_SEPARATOR = "||";
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/features.js
var require_features = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/features.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.futureFlagDefault = exports.FUTURE_FLAGS_EXPIRED = exports.NEW_PROJECT_DEFAULT_CONTEXT = exports.FUTURE_FLAGS = exports.ENABLE_PARTITION_LITERALS = exports.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE = exports.SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY = exports.S3_CREATE_DEFAULT_LOGGING_POLICY = exports.CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME = exports.VALIDATE_SNAPSHOT_REMOVAL_POLICY = exports.IAM_MINIMIZE_POLICIES = exports.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME = exports.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME = exports.ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER = exports.TARGET_PARTITIONS = exports.CHECK_SECRET_USAGE = exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021 = exports.LAMBDA_RECOGNIZE_LAYER_VERSION = exports.LAMBDA_RECOGNIZE_VERSION_PROPS = exports.EFS_DEFAULT_ENCRYPTION_AT_REST = exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID = exports.RDS_LOWERCASE_DB_IDENTIFIER = exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT = exports.S3_GRANT_WRITE_WITHOUT_ACL = exports.KMS_DEFAULT_KEY_POLICIES = exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = exports.DOCKER_IGNORE_SUPPORT = exports.STACK_RELATIVE_EXPORTS_CONTEXT = exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT = exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = void 0, exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT = "@aws-cdk/core:enableStackNameDuplicates", exports.ENABLE_DIFF_NO_FAIL_CONTEXT = "aws-cdk:enableDiffNoFail", exports.ENABLE_DIFF_NO_FAIL = exports.ENABLE_DIFF_NO_FAIL_CONTEXT, exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT = "@aws-cdk/core:newStyleStackSynthesis", exports.STACK_RELATIVE_EXPORTS_CONTEXT = "@aws-cdk/core:stackRelativeExports", exports.DOCKER_IGNORE_SUPPORT = "@aws-cdk/aws-ecr-assets:dockerIgnoreSupport", exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME = "@aws-cdk/aws-secretsmanager:parseOwnedSecretName", exports.KMS_DEFAULT_KEY_POLICIES = "@aws-cdk/aws-kms:defaultKeyPolicies", exports.S3_GRANT_WRITE_WITHOUT_ACL = "@aws-cdk/aws-s3:grantWriteWithoutAcl", exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT = "@aws-cdk/aws-ecs-patterns:removeDefaultDesiredCount", exports.RDS_LOWERCASE_DB_IDENTIFIER = "@aws-cdk/aws-rds:lowercaseDbIdentifier", exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID = "@aws-cdk/aws-apigateway:usagePlanKeyOrderInsensitiveId", exports.EFS_DEFAULT_ENCRYPTION_AT_REST = "@aws-cdk/aws-efs:defaultEncryptionAtRest", exports.LAMBDA_RECOGNIZE_VERSION_PROPS = "@aws-cdk/aws-lambda:recognizeVersionProps", exports.LAMBDA_RECOGNIZE_LAYER_VERSION = "@aws-cdk/aws-lambda:recognizeLayerVersion", exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021 = "@aws-cdk/aws-cloudfront:defaultSecurityPolicyTLSv1.2_2021", exports.CHECK_SECRET_USAGE = "@aws-cdk/core:checkSecretUsage", exports.TARGET_PARTITIONS = "@aws-cdk/core:target-partitions", exports.ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER = "@aws-cdk-containers/ecs-service-extensions:enableDefaultLogDriver", exports.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME = "@aws-cdk/aws-ec2:uniqueImdsv2TemplateName", exports.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME = "@aws-cdk/aws-ecs:arnFormatIncludesClusterName", exports.IAM_MINIMIZE_POLICIES = "@aws-cdk/aws-iam:minimizePolicies", exports.VALIDATE_SNAPSHOT_REMOVAL_POLICY = "@aws-cdk/core:validateSnapshotRemovalPolicy", exports.CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME = "@aws-cdk/aws-codepipeline:crossAccountKeyAliasStackSafeResourceName", exports.S3_CREATE_DEFAULT_LOGGING_POLICY = "@aws-cdk/aws-s3:createDefaultLoggingPolicy", exports.SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY = "@aws-cdk/aws-sns-subscriptions:restrictSqsDescryption", exports.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE = "@aws-cdk/aws-apigateway:disableCloudWatchRole", exports.ENABLE_PARTITION_LITERALS = "@aws-cdk/core:enablePartitionLiterals", exports.FUTURE_FLAGS = { [exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID]: true, [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: true, [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: true, [exports.STACK_RELATIVE_EXPORTS_CONTEXT]: true, [exports.DOCKER_IGNORE_SUPPORT]: true, [exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME]: true, [exports.KMS_DEFAULT_KEY_POLICIES]: true, [exports.S3_GRANT_WRITE_WITHOUT_ACL]: true, [exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT]: true, [exports.RDS_LOWERCASE_DB_IDENTIFIER]: true, [exports.EFS_DEFAULT_ENCRYPTION_AT_REST]: true, [exports.LAMBDA_RECOGNIZE_VERSION_PROPS]: true, [exports.LAMBDA_RECOGNIZE_LAYER_VERSION]: true, [exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021]: true, [exports.ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER]: true, [exports.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME]: true, [exports.CHECK_SECRET_USAGE]: true, [exports.IAM_MINIMIZE_POLICIES]: true, [exports.ECS_ARN_FORMAT_INCLUDES_CLUSTER_NAME]: true, [exports.VALIDATE_SNAPSHOT_REMOVAL_POLICY]: true, [exports.CODEPIPELINE_CROSS_ACCOUNT_KEY_ALIAS_STACK_SAFE_RESOURCE_NAME]: true, [exports.S3_CREATE_DEFAULT_LOGGING_POLICY]: true, [exports.SNS_SUBSCRIPTIONS_SQS_DECRYPTION_POLICY]: true, [exports.APIGATEWAY_DISABLE_CLOUDWATCH_ROLE]: true, [exports.ENABLE_PARTITION_LITERALS]: true }, exports.NEW_PROJECT_DEFAULT_CONTEXT = { [exports.TARGET_PARTITIONS]: ["aws", "aws-cn"] }, exports.FUTURE_FLAGS_EXPIRED = [exports.DOCKER_IGNORE_SUPPORT, exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT, exports.EFS_DEFAULT_ENCRYPTION_AT_REST, exports.ENABLE_DIFF_NO_FAIL_CONTEXT, exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT, exports.KMS_DEFAULT_KEY_POLICIES, exports.S3_GRANT_WRITE_WITHOUT_ACL, exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME];
    var FUTURE_FLAGS_DEFAULTS = { [exports.APIGATEWAY_USAGEPLANKEY_ORDERINSENSITIVE_ID]: true, [exports.ENABLE_STACK_NAME_DUPLICATES_CONTEXT]: true, [exports.ENABLE_DIFF_NO_FAIL_CONTEXT]: true, [exports.STACK_RELATIVE_EXPORTS_CONTEXT]: true, [exports.NEW_STYLE_STACK_SYNTHESIS_CONTEXT]: true, [exports.DOCKER_IGNORE_SUPPORT]: true, [exports.SECRETS_MANAGER_PARSE_OWNED_SECRET_NAME]: true, [exports.KMS_DEFAULT_KEY_POLICIES]: true, [exports.S3_GRANT_WRITE_WITHOUT_ACL]: true, [exports.ECS_REMOVE_DEFAULT_DESIRED_COUNT]: true, [exports.RDS_LOWERCASE_DB_IDENTIFIER]: true, [exports.EFS_DEFAULT_ENCRYPTION_AT_REST]: true, [exports.LAMBDA_RECOGNIZE_VERSION_PROPS]: true, [exports.CLOUDFRONT_DEFAULT_SECURITY_POLICY_TLS_V1_2_2021]: true, [exports.ECS_SERVICE_EXTENSIONS_ENABLE_DEFAULT_LOG_DRIVER]: false, [exports.EC2_UNIQUE_IMDSV2_LAUNCH_TEMPLATE_NAME]: false };
    function futureFlagDefault(flag) {
      return FUTURE_FLAGS_DEFAULTS[flag] ?? false;
    }
    exports.futureFlagDefault = futureFlagDefault;
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/placeholders.js
var require_placeholders = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/placeholders.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.EnvironmentPlaceholders = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var EnvironmentPlaceholders = class {
      static replace(object, values) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cx_api_EnvironmentPlaceholderValues(values);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.replace), error;
        }
        return this.recurse(object, (value) => (value = replaceAll(value, EnvironmentPlaceholders.CURRENT_REGION, values.region), value = replaceAll(value, EnvironmentPlaceholders.CURRENT_ACCOUNT, values.accountId), value = replaceAll(value, EnvironmentPlaceholders.CURRENT_PARTITION, values.partition), value));
      }
      static async replaceAsync(object, provider) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cx_api_IEnvironmentPlaceholderProvider(provider);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.replaceAsync), error;
        }
        let needRegion = false, needAccountId = false, needPartition = false;
        this.recurse(object, (value) => (value.indexOf(EnvironmentPlaceholders.CURRENT_REGION) > 1 && (needRegion = true), value.indexOf(EnvironmentPlaceholders.CURRENT_ACCOUNT) > 1 && (needAccountId = true), value.indexOf(EnvironmentPlaceholders.CURRENT_PARTITION) > 1 && (needPartition = true), value));
        const region = needRegion ? await provider.region() : void 0, accountId = needAccountId ? await provider.accountId() : void 0, partition = needPartition ? await provider.partition() : void 0;
        return this.recurse(object, (value) => (value = replaceAll(value, EnvironmentPlaceholders.CURRENT_REGION, region ?? "WONTHAPPEN"), value = replaceAll(value, EnvironmentPlaceholders.CURRENT_ACCOUNT, accountId ?? "WONTHAPPEN"), value = replaceAll(value, EnvironmentPlaceholders.CURRENT_PARTITION, partition ?? "WONTHAPPEN"), value));
      }
      static recurse(value, cb) {
        if (typeof value == "string")
          return cb(value);
        if (typeof value != "object" || value === null)
          return value;
        if (Array.isArray(value))
          return value.map((x) => this.recurse(x, cb));
        const ret = {};
        for (const [key, inner] of Object.entries(value))
          ret[key] = this.recurse(inner, cb);
        return ret;
      }
    };
    exports.EnvironmentPlaceholders = EnvironmentPlaceholders, _a = JSII_RTTI_SYMBOL_1, EnvironmentPlaceholders[_a] = { fqn: "aws-cdk-lib.cx_api.EnvironmentPlaceholders", version: "2.50.0" }, EnvironmentPlaceholders.CURRENT_REGION = "${AWS::Region}", EnvironmentPlaceholders.CURRENT_ACCOUNT = "${AWS::AccountId}", EnvironmentPlaceholders.CURRENT_PARTITION = "${AWS::Partition}";
    function replaceAll(s, search, replace) {
      return s.split(search).join(replace);
    }
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/app.js
var require_app = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/app.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.BUNDLING_STACKS = exports.DISABLE_LOGICAL_ID_METADATA = exports.DISABLE_METADATA_STACK_TRACE = exports.DISABLE_ASSET_STAGING_CONTEXT = exports.ANALYTICS_REPORTING_ENABLED_CONTEXT = exports.PATH_METADATA_ENABLE_CONTEXT = void 0, exports.PATH_METADATA_ENABLE_CONTEXT = "aws:cdk:enable-path-metadata", exports.ANALYTICS_REPORTING_ENABLED_CONTEXT = "aws:cdk:version-reporting", exports.DISABLE_ASSET_STAGING_CONTEXT = "aws:cdk:disable-asset-staging", exports.DISABLE_METADATA_STACK_TRACE = "aws:cdk:disable-stack-trace", exports.DISABLE_LOGICAL_ID_METADATA = "aws:cdk:disable-logicalId-metadata", exports.BUNDLING_STACKS = "aws:cdk:bundling-stacks";
  }
});

// node_modules/aws-cdk-lib/cx-api/lib/index.js
var require_lib3 = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/lib/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        p !== "default" && !exports2.hasOwnProperty(p) && __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true }), __exportStar(require_cxapi(), exports), __exportStar(require_vpc(), exports), __exportStar(require_ami(), exports), __exportStar(require_load_balancer(), exports), __exportStar(require_availability_zones(), exports), __exportStar(require_endpoint_service_availability_zones(), exports), __exportStar(require_security_group(), exports), __exportStar(require_key(), exports), __exportStar(require_cloud_artifact(), exports), require_cloud_artifact_aug(), __exportStar(require_asset_manifest_artifact(), exports), __exportStar(require_cloudformation_artifact(), exports), __exportStar(require_tree_cloud_artifact(), exports), __exportStar(require_nested_cloud_assembly_artifact(), exports), require_nested_cloud_assembly_artifact_aug(), __exportStar(require_cloud_assembly2(), exports), __exportStar(require_assets2(), exports), __exportStar(require_environment(), exports), __exportStar(require_metadata(), exports), __exportStar(require_features(), exports), __exportStar(require_placeholders(), exports), __exportStar(require_app(), exports);
  }
});

// node_modules/aws-cdk-lib/cx-api/index.js
var require_cx_api = __commonJS({
  "node_modules/aws-cdk-lib/cx-api/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        p !== "default" && !exports2.hasOwnProperty(p) && __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true }), __exportStar(require_lib3(), exports);
  }
});

// node_modules/constructs/lib/dependency.js
var require_dependency = __commonJS({
  "node_modules/constructs/lib/dependency.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Dependable = exports.DependencyGroup = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var DependencyGroup = class {
      /**
       * @experimental
       */
      constructor(...deps) {
        this._deps = new Array();
        const self = this;
        Dependable.implement(this, {
          get dependencyRoots() {
            const result = new Array();
            for (const d of self._deps) {
              result.push(...Dependable.of(d).dependencyRoots);
            }
            return result;
          }
        });
        this.add(...deps);
      }
      /**
       * (experimental) Add a construct to the dependency roots.
       *
       * @experimental
       */
      add(...scopes) {
        this._deps.push(...scopes);
      }
    };
    exports.DependencyGroup = DependencyGroup;
    _a = JSII_RTTI_SYMBOL_1;
    DependencyGroup[_a] = { fqn: "constructs.DependencyGroup", version: "10.0.5" };
    var DEPENDABLE_SYMBOL = Symbol.for("@aws-cdk/core.DependableTrait");
    var Dependable = class {
      /**
       * (experimental) Turn any object into an IDependable.
       *
       * @experimental
       */
      static implement(instance, trait) {
        instance[DEPENDABLE_SYMBOL] = trait;
      }
      /**
       * (experimental) Return the matching Dependable for the given class instance.
       *
       * @experimental
       */
      static of(instance) {
        const ret = instance[DEPENDABLE_SYMBOL];
        if (!ret) {
          throw new Error(`${instance} does not implement IDependable. Use "Dependable.implement()" to implement`);
        }
        return ret;
      }
      /**
       * (deprecated) Return the matching Dependable for the given class instance.
       *
       * @deprecated use `of`
       */
      static get(instance) {
        return this.of(instance);
      }
    };
    exports.Dependable = Dependable;
    _b = JSII_RTTI_SYMBOL_1;
    Dependable[_b] = { fqn: "constructs.Dependable", version: "10.0.5" };
  }
});

// node_modules/constructs/lib/private/stack-trace.js
var require_stack_trace = __commonJS({
  "node_modules/constructs/lib/private/stack-trace.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.captureStackTrace = void 0;
    function captureStackTrace(below) {
      below = below || captureStackTrace;
      const object = { stack: "" };
      const previousLimit = Error.stackTraceLimit;
      try {
        Error.stackTraceLimit = Number.MAX_SAFE_INTEGER;
        Error.captureStackTrace(object, below);
      } finally {
        Error.stackTraceLimit = previousLimit;
      }
      if (!object.stack) {
        return [];
      }
      return object.stack.split("\n").slice(1).map((s) => s.replace(/^\s*at\s+/, ""));
    }
    exports.captureStackTrace = captureStackTrace;
  }
});

// node_modules/constructs/lib/private/uniqueid.js
var require_uniqueid = __commonJS({
  "node_modules/constructs/lib/private/uniqueid.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.addressOf = void 0;
    var crypto = require("crypto");
    var HIDDEN_ID = "Default";
    function addressOf(components) {
      const hash = crypto.createHash("sha1");
      for (const c of components) {
        if (c === HIDDEN_ID) {
          continue;
        }
        hash.update(c);
        hash.update("\n");
      }
      return "c8" + hash.digest("hex");
    }
    exports.addressOf = addressOf;
  }
});

// node_modules/constructs/lib/construct.js
var require_construct = __commonJS({
  "node_modules/constructs/lib/construct.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.ConstructOrder = exports.Construct = exports.Node = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var dependency_1 = require_dependency();
    var stack_trace_1 = require_stack_trace();
    var uniqueid_1 = require_uniqueid();
    var Node = class {
      /**
       * @stability stable
       */
      constructor(host, scope, id) {
        this.host = host;
        this._locked = false;
        this._children = {};
        this._context = {};
        this._metadata = new Array();
        this._dependencies = /* @__PURE__ */ new Set();
        this._validations = new Array();
        id = id !== null && id !== void 0 ? id : "";
        this.id = sanitizeId(id);
        this.scope = scope;
        if (scope && !this.id) {
          throw new Error("Only root constructs may have an empty ID");
        }
        scope === null || scope === void 0 ? void 0 : scope.node.addChild(host, this.id);
      }
      /**
       * (deprecated) Returns the node associated with a construct.
       *
       * @param construct the construct.
       * @deprecated use `construct.node` instead
       */
      static of(construct) {
        return construct.node;
      }
      /**
       * The full, absolute path of this construct in the tree.
       *
       * Components are separated by '/'.
       *
       * @stability stable
       */
      get path() {
        const components = this.scopes.filter((c) => c.node.id).map((c) => c.node.id);
        return components.join(Node.PATH_SEP);
      }
      /**
       * Returns an opaque tree-unique address for this construct.
       *
       * Addresses are 42 characters hexadecimal strings. They begin with "c8"
       * followed by 40 lowercase hexadecimal characters (0-9a-f).
       *
       * Addresses are calculated using a SHA-1 of the components of the construct
       * path.
       *
       * To enable refactorings of construct trees, constructs with the ID `Default`
       * will be excluded from the calculation. In those cases constructs in the
       * same tree may have the same addreess.
       *
       * @stability stable
       * @example
       *
       * c83a2846e506bcc5f10682b564084bca2d275709ee
       */
      get addr() {
        if (!this._addr) {
          this._addr = uniqueid_1.addressOf(this.scopes.map((c) => Node.of(c).id));
        }
        return this._addr;
      }
      /**
       * Return a direct child by id, or undefined.
       *
       * @param id Identifier of direct child.
       * @returns the child if found, or undefined
       * @stability stable
       */
      tryFindChild(id) {
        return this._children[sanitizeId(id)];
      }
      /**
       * Return a direct child by id.
       *
       * Throws an error if the child is not found.
       *
       * @param id Identifier of direct child.
       * @returns Child with the given id.
       * @stability stable
       */
      findChild(id) {
        const ret = this.tryFindChild(id);
        if (!ret) {
          throw new Error(`No child with id: '${id}'`);
        }
        return ret;
      }
      /**
       * Returns the child construct that has the id `Default` or `Resource"`.
       *
       * This is usually the construct that provides the bulk of the underlying functionality.
       * Useful for modifications of the underlying construct that are not available at the higher levels.
       * Override the defaultChild property.
       *
       * This should only be used in the cases where the correct
       * default child is not named 'Resource' or 'Default' as it
       * should be.
       *
       * If you set this to undefined, the default behavior of finding
       * the child named 'Resource' or 'Default' will be used.
       *
       * @returns a construct or undefined if there is no default child
       * @stability stable
       * @throws if there is more than one child
       */
      get defaultChild() {
        if (this._defaultChild !== void 0) {
          return this._defaultChild;
        }
        const resourceChild = this.tryFindChild("Resource");
        const defaultChild = this.tryFindChild("Default");
        if (resourceChild && defaultChild) {
          throw new Error(`Cannot determine default child for ${this.path}. There is both a child with id "Resource" and id "Default"`);
        }
        return defaultChild || resourceChild;
      }
      /**
       * Returns the child construct that has the id `Default` or `Resource"`.
       *
       * This is usually the construct that provides the bulk of the underlying functionality.
       * Useful for modifications of the underlying construct that are not available at the higher levels.
       * Override the defaultChild property.
       *
       * This should only be used in the cases where the correct
       * default child is not named 'Resource' or 'Default' as it
       * should be.
       *
       * If you set this to undefined, the default behavior of finding
       * the child named 'Resource' or 'Default' will be used.
       *
       * @returns a construct or undefined if there is no default child
       * @stability stable
       * @throws if there is more than one child
       */
      set defaultChild(value) {
        this._defaultChild = value;
      }
      /**
       * All direct children of this construct.
       *
       * @stability stable
       */
      get children() {
        return Object.values(this._children);
      }
      /**
       * Return this construct and all of its children in the given order.
       *
       * @stability stable
       */
      findAll(order = ConstructOrder.PREORDER) {
        const ret = new Array();
        visit(this.host);
        return ret;
        function visit(c) {
          if (order === ConstructOrder.PREORDER) {
            ret.push(c);
          }
          for (const child of c.node.children) {
            visit(child);
          }
          if (order === ConstructOrder.POSTORDER) {
            ret.push(c);
          }
        }
      }
      /**
       * This can be used to set contextual values.
       *
       * Context must be set before any children are added, since children may consult context info during construction.
       * If the key already exists, it will be overridden.
       *
       * @param key The context key.
       * @param value The context value.
       * @stability stable
       */
      setContext(key, value) {
        if (this.children.length > 0) {
          const names = this.children.map((c) => c.node.id);
          throw new Error("Cannot set context after children have been added: " + names.join(","));
        }
        this._context[key] = value;
      }
      /**
       * Retrieves a value from tree context.
       *
       * Context is usually initialized at the root, but can be overridden at any point in the tree.
       *
       * @param key The context key.
       * @returns The context value or `undefined` if there is no context value for thie key.
       * @stability stable
       */
      tryGetContext(key) {
        const value = this._context[key];
        if (value !== void 0) {
          return value;
        }
        return this.scope && this.scope.node.tryGetContext(key);
      }
      /**
       * An immutable array of metadata objects associated with this construct.
       *
       * This can be used, for example, to implement support for deprecation notices, source mapping, etc.
       *
       * @stability stable
       */
      get metadata() {
        return [...this._metadata];
      }
      /**
       * Adds a metadata entry to this construct.
       *
       * Entries are arbitrary values and will also include a stack trace to allow tracing back to
       * the code location for when the entry was added. It can be used, for example, to include source
       * mapping in CloudFormation templates to improve diagnostics.
       *
       * @param type a string denoting the type of metadata.
       * @param data the value of the metadata (can be a Token).
       * @param options options.
       * @stability stable
       */
      addMetadata(type, data, options = {}) {
        var _c, _d;
        if (data == null) {
          return;
        }
        const shouldTrace = (_c = options.stackTrace) !== null && _c !== void 0 ? _c : false;
        const trace = shouldTrace ? stack_trace_1.captureStackTrace((_d = options.traceFromFunction) !== null && _d !== void 0 ? _d : this.addMetadata) : void 0;
        this._metadata.push({ type, data, trace });
      }
      /**
       * All parent scopes of this construct.
       *
       * @returns a list of parent scopes. The last element in the list will always
       * be the current construct and the first element will be the root of the
       * tree.
       * @stability stable
       */
      get scopes() {
        const ret = new Array();
        let curr = this.host;
        while (curr) {
          ret.unshift(curr);
          curr = curr.node.scope;
        }
        return ret;
      }
      /**
       * Returns the root of the construct tree.
       *
       * @returns The root of the construct tree.
       * @stability stable
       */
      get root() {
        return this.scopes[0];
      }
      /**
       * Returns true if this construct or the scopes in which it is defined are locked.
       *
       * @stability stable
       */
      get locked() {
        if (this._locked) {
          return true;
        }
        if (this.scope && this.scope.node.locked) {
          return true;
        }
        return false;
      }
      /**
       * Add an ordering dependency on another construct.
       *
       * An `IDependable`
       *
       * @stability stable
       */
      addDependency(...deps) {
        for (const d of deps) {
          this._dependencies.add(d);
        }
      }
      /**
       * Return all dependencies registered on this node (non-recursive).
       *
       * @stability stable
       */
      get dependencies() {
        const result = new Array();
        for (const dep of this._dependencies) {
          for (const root of dependency_1.Dependable.of(dep).dependencyRoots) {
            result.push(root);
          }
        }
        return result;
      }
      /**
       * (experimental) Remove the child with the given name, if present.
       *
       * @returns Whether a child with the given name was deleted.
       * @experimental
       */
      tryRemoveChild(childName) {
        if (!(childName in this._children)) {
          return false;
        }
        delete this._children[childName];
        return true;
      }
      /**
       * Adds a validation to this construct.
       *
       * When `node.validate()` is called, the `validate()` method will be called on
       * all validations and all errors will be returned.
       *
       * @param validation The validation object.
       * @stability stable
       */
      addValidation(validation) {
        this._validations.push(validation);
      }
      /**
       * Validates this construct.
       *
       * Invokes the `validate()` method on all validations added through
       * `addValidation()`.
       *
       * @returns an array of validation error messages associated with this
       * construct.
       * @stability stable
       */
      validate() {
        const deprecated = ["validate", "onValidate", "synthesize", "onSynthesize", "prepare", "onPrepare"];
        for (const method of deprecated) {
          if (typeof this.host[method] === "function") {
            throw new Error(`the construct "${this.path}" has a "${method}()" method which is no longer supported. Use "construct.node.addValidation()" to add validations to a construct`);
          }
        }
        const errors = new Array();
        for (const v of this._validations) {
          errors.push(...v.validate());
        }
        return errors;
      }
      /**
       * Locks this construct from allowing more children to be added.
       *
       * After this
       * call, no more children can be added to this construct or to any children.
       *
       * @stability stable
       */
      lock() {
        this._locked = true;
      }
      /**
       * Adds a child construct to this node.
       *
       * @param child The child construct
       * @param childName The type name of the child construct.
       * @returns The resolved path part name of the child
       */
      addChild(child, childName) {
        var _c;
        if (this.locked) {
          if (!this.path) {
            throw new Error("Cannot add children during synthesis");
          }
          throw new Error(`Cannot add children to "${this.path}" during synthesis`);
        }
        if (childName in this._children) {
          const name = (_c = this.id) !== null && _c !== void 0 ? _c : "";
          const typeName = this.host.constructor.name;
          throw new Error(`There is already a Construct with name '${childName}' in ${typeName}${name.length > 0 ? " [" + name + "]" : ""}`);
        }
        if (!childName && this.id) {
          throw new Error(`cannot add a nameless construct to the named scope: ${this.path}`);
        }
        this._children[childName] = child;
        if (Object.keys(this._children).length > 1 && Object.keys(this._children).filter((x) => !x).length > 0) {
          throw new Error("only a single construct is allowed in a scope if it has an empty name");
        }
      }
    };
    exports.Node = Node;
    _a = JSII_RTTI_SYMBOL_1;
    Node[_a] = { fqn: "constructs.Node", version: "10.0.5" };
    Node.PATH_SEP = "/";
    var Construct = class {
      /**
       * Creates a new construct node.
       *
       * @param scope The scope in which to define this construct.
       * @param id The scoped construct ID.
       * @stability stable
       */
      constructor(scope, id) {
        this.node = new Node(this, scope, id);
        dependency_1.Dependable.implement(this, {
          dependencyRoots: [this]
        });
      }
      /**
       * (deprecated) Checks if `x` is a construct.
       *
       * @param x Any object.
       * @returns true if `x` is an object created from a class which extends `Construct`.
       * @deprecated use `x instanceof Construct` instead
       */
      static isConstruct(x) {
        return x instanceof Construct;
      }
      /**
       * Returns a string representation of this construct.
       *
       * @stability stable
       */
      toString() {
        return this.node.path || "<root>";
      }
    };
    exports.Construct = Construct;
    _b = JSII_RTTI_SYMBOL_1;
    Construct[_b] = { fqn: "constructs.Construct", version: "10.0.5" };
    var ConstructOrder;
    (function(ConstructOrder2) {
      ConstructOrder2[ConstructOrder2["PREORDER"] = 0] = "PREORDER";
      ConstructOrder2[ConstructOrder2["POSTORDER"] = 1] = "POSTORDER";
    })(ConstructOrder = exports.ConstructOrder || (exports.ConstructOrder = {}));
    var PATH_SEP_REGEX = new RegExp(`${Node.PATH_SEP}`, "g");
    function sanitizeId(id) {
      return id.replace(PATH_SEP_REGEX, "--");
    }
  }
});

// node_modules/constructs/lib/metadata.js
var require_metadata2 = __commonJS({
  "node_modules/constructs/lib/metadata.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/constructs/lib/index.js
var require_lib4 = __commonJS({
  "node_modules/constructs/lib/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      if (k2 === void 0)
        k2 = k;
      o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        if (p !== "default" && !exports2.hasOwnProperty(p))
          __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true });
    __exportStar(require_construct(), exports);
    __exportStar(require_metadata2(), exports);
    __exportStar(require_dependency(), exports);
  }
});

// node_modules/aws-cdk-lib/core/lib/annotations.js
var require_annotations = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/annotations.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.Annotations = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxschema = require_cloud_assembly_schema2();
    var cxapi = require_cx_api();
    var constructs_1 = require_lib4();
    var DEPRECATIONS_SYMBOL = Symbol.for("@aws-cdk/core.deprecations");
    var Annotations = class {
      constructor(scope) {
        this.scope = scope;
        const disableTrace = scope.node.tryGetContext(cxapi.DISABLE_METADATA_STACK_TRACE) || process.env.CDK_DISABLE_STACK_TRACE;
        this.stackTraces = !disableTrace;
      }
      static of(scope) {
        return new Annotations(scope);
      }
      addWarning(message) {
        this.addMessage(cxschema.ArtifactMetadataEntryType.WARN, message);
      }
      addInfo(message) {
        this.addMessage(cxschema.ArtifactMetadataEntryType.INFO, message);
      }
      addError(message) {
        this.addMessage(cxschema.ArtifactMetadataEntryType.ERROR, message);
      }
      addDeprecation(api, message) {
        const text = `The API ${api} is deprecated: ${message}. This API will be removed in the next major release`;
        if (process.env.CDK_BLOCK_DEPRECATIONS)
          throw new Error(`${constructs_1.Node.of(this.scope).path}: ${text}`);
        const set = this.deprecationsReported;
        set.has(api) || (this.addWarning(text), set.add(api));
      }
      addMessage(level, message) {
        constructs_1.Node.of(this.scope).addMetadata(level, message, { stackTrace: this.stackTraces });
      }
      get deprecationsReported() {
        let set = this.scope[DEPRECATIONS_SYMBOL];
        return set || (set = /* @__PURE__ */ new Set(), Object.defineProperty(this.scope, DEPRECATIONS_SYMBOL, { value: set })), set;
      }
    };
    exports.Annotations = Annotations, _a = JSII_RTTI_SYMBOL_1, Annotations[_a] = { fqn: "aws-cdk-lib.Annotations", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/debug.js
var require_debug2 = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/debug.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.debugModeEnabled = exports.CDK_DEBUG = void 0;
    var process_1 = require("process");
    exports.CDK_DEBUG = "CDK_DEBUG";
    function debugModeEnabled() {
      return isTruthy(process_1.env[exports.CDK_DEBUG]);
    }
    exports.debugModeEnabled = debugModeEnabled;
    var TRUTHY_VALUES = /* @__PURE__ */ new Set(["1", "on", "true"]);
    function isTruthy(value) {
      return value ? TRUTHY_VALUES.has(value.toLowerCase()) : false;
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/stack-trace.js
var require_stack_trace2 = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/stack-trace.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.captureStackTrace = void 0;
    var debug_1 = require_debug2();
    function captureStackTrace(below = captureStackTrace, limit = Number.MAX_SAFE_INTEGER) {
      if (!debug_1.debugModeEnabled())
        return ["stack traces disabled"];
      const object = {}, previousLimit = Error.stackTraceLimit;
      try {
        Error.stackTraceLimit = limit, Error.captureStackTrace(object, below);
      } finally {
        Error.stackTraceLimit = previousLimit;
      }
      return object.stack ? object.stack.split(`
`).slice(1).map((s) => s.replace(/^\s*at\s+/, "")) : [];
    }
    exports.captureStackTrace = captureStackTrace;
  }
});

// node_modules/aws-cdk-lib/core/lib/string-fragments.js
var require_string_fragments = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/string-fragments.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.TokenizedStringFragments = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var token_1 = require_token();
    var TokenizedStringFragments = class {
      constructor() {
        this.fragments = new Array();
      }
      get firstToken() {
        const first = this.fragments[0];
        if (first.type === "token")
          return first.token;
      }
      get firstValue() {
        return fragmentValue(this.fragments[0]);
      }
      get length() {
        return this.fragments.length;
      }
      addLiteral(lit) {
        this.fragments.push({ type: "literal", lit });
      }
      addToken(token) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IResolvable(token);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addToken), error;
        }
        this.fragments.push({ type: "token", token });
      }
      addIntrinsic(value) {
        this.fragments.push({ type: "intrinsic", value });
      }
      get tokens() {
        const ret = new Array();
        for (const f of this.fragments)
          f.type === "token" && ret.push(f.token);
        return ret;
      }
      mapTokens(mapper) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ITokenMapper(mapper);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.mapTokens), error;
        }
        const ret = new TokenizedStringFragments();
        for (const f of this.fragments)
          switch (f.type) {
            case "literal":
              ret.addLiteral(f.lit);
              break;
            case "token":
              const mapped = mapper.mapToken(f.token);
              token_1.isResolvableObject(mapped) ? ret.addToken(mapped) : token_1.Token.isUnresolved(mapped) ? ret.addIntrinsic(mapped) : ret.addLiteral(mapped);
              break;
            case "intrinsic":
              ret.addIntrinsic(f.value);
              break;
          }
        return ret;
      }
      join(concat) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IFragmentConcatenator(concat);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.join), error;
        }
        if (this.fragments.length === 0)
          return concat.join(void 0, void 0);
        if (this.fragments.length === 1)
          return this.firstValue;
        const values = this.fragments.map(fragmentValue);
        for (; values.length > 1; ) {
          const prefix = values.splice(0, 2);
          values.splice(0, 0, concat.join(prefix[0], prefix[1]));
        }
        return values[0];
      }
    };
    exports.TokenizedStringFragments = TokenizedStringFragments, _a = JSII_RTTI_SYMBOL_1, TokenizedStringFragments[_a] = { fqn: "aws-cdk-lib.TokenizedStringFragments", version: "2.50.0" };
    function fragmentValue(fragment) {
      switch (fragment.type) {
        case "literal":
          return fragment.lit;
        case "token":
          return fragment.token.toString();
        case "intrinsic":
          return fragment.value;
      }
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/private/encoding.js
var require_encoding = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/encoding.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.stringContainsNumberTokens = exports.extractTokenDouble = exports.createTokenDouble = exports.unresolved = exports.containsListTokenElement = exports.NullConcat = exports.regexQuote = exports.TokenString = exports.STRINGIFIED_NUMBER_PATTERN = exports.VALID_KEY_CHARS = exports.END_TOKEN_MARKER = exports.BEGIN_LIST_TOKEN_MARKER = exports.BEGIN_STRING_TOKEN_MARKER = void 0;
    var string_fragments_1 = require_string_fragments();
    var token_1 = require_token();
    exports.BEGIN_STRING_TOKEN_MARKER = "${Token[", exports.BEGIN_LIST_TOKEN_MARKER = "#{Token[", exports.END_TOKEN_MARKER = "]}", exports.VALID_KEY_CHARS = "a-zA-Z0-9:._-";
    var QUOTED_BEGIN_STRING_TOKEN_MARKER = regexQuote(exports.BEGIN_STRING_TOKEN_MARKER);
    var QUOTED_BEGIN_LIST_TOKEN_MARKER = regexQuote(exports.BEGIN_LIST_TOKEN_MARKER);
    var QUOTED_END_TOKEN_MARKER = regexQuote(exports.END_TOKEN_MARKER);
    exports.STRINGIFIED_NUMBER_PATTERN = "-1\\.\\d{10,16}e\\+289";
    var STRING_TOKEN_REGEX = new RegExp(`${QUOTED_BEGIN_STRING_TOKEN_MARKER}([${exports.VALID_KEY_CHARS}]+)${QUOTED_END_TOKEN_MARKER}|(${exports.STRINGIFIED_NUMBER_PATTERN})`, "g");
    var LIST_TOKEN_REGEX = new RegExp(`${QUOTED_BEGIN_LIST_TOKEN_MARKER}([${exports.VALID_KEY_CHARS}]+)${QUOTED_END_TOKEN_MARKER}`, "g");
    var TokenString = class {
      constructor(str, re) {
        this.str = str, this.re = re;
      }
      static forString(s) {
        return new TokenString(s, STRING_TOKEN_REGEX);
      }
      static forListToken(s) {
        return new TokenString(s, LIST_TOKEN_REGEX);
      }
      split(lookup) {
        const ret = new string_fragments_1.TokenizedStringFragments();
        let rest = 0;
        this.re.lastIndex = 0;
        let m = this.re.exec(this.str);
        for (; m; )
          m.index > rest && ret.addLiteral(this.str.substring(rest, m.index)), ret.addToken(lookup(m[1] ?? m[2])), rest = this.re.lastIndex, m = this.re.exec(this.str);
        return rest < this.str.length && ret.addLiteral(this.str.substring(rest)), ret;
      }
      test() {
        return this.re.lastIndex = 0, this.re.test(this.str);
      }
    };
    exports.TokenString = TokenString;
    function regexQuote(s) {
      return s.replace(/[.?*+^$[\]\\(){}|-]/g, "\\$&");
    }
    exports.regexQuote = regexQuote;
    var NullConcat = class {
      join(_left, _right) {
      }
    };
    exports.NullConcat = NullConcat;
    function containsListTokenElement(xs) {
      return xs.some((x) => typeof x == "string" && TokenString.forListToken(x).test());
    }
    exports.containsListTokenElement = containsListTokenElement;
    function unresolved(obj) {
      return typeof obj == "string" ? TokenString.forString(obj).test() : typeof obj == "number" ? extractTokenDouble(obj) !== void 0 : Array.isArray(obj) && obj.length === 1 ? typeof obj[0] == "string" && TokenString.forListToken(obj[0]).test() : token_1.isResolvableObject(obj);
    }
    exports.unresolved = unresolved;
    var DOUBLE_TOKEN_MARKER_BITS = 64511 << 16;
    var MAX_ENCODABLE_INTEGER = Math.pow(2, 48) - 1;
    var BITS32 = Math.pow(2, 32);
    function createTokenDouble(x) {
      if (Math.floor(x) !== x || x < 0)
        throw new Error("Can only encode positive integers");
      if (x > MAX_ENCODABLE_INTEGER)
        throw new Error(`Got an index too large to encode: ${x}`);
      const buf = new ArrayBuffer(8), ints = new Uint32Array(buf);
      return ints[0] = x & 4294967295, ints[1] = shr32(x) & 65535 | DOUBLE_TOKEN_MARKER_BITS, new Float64Array(buf)[0];
    }
    exports.createTokenDouble = createTokenDouble;
    function shr32(x) {
      return Math.floor(x / BITS32);
    }
    function shl32(x) {
      return x * BITS32;
    }
    function extractTokenDouble(encoded) {
      const buf = new ArrayBuffer(8);
      new Float64Array(buf)[0] = encoded;
      const ints = new Uint32Array(buf);
      if ((ints[1] & 4294901760) === DOUBLE_TOKEN_MARKER_BITS)
        return ints[0] + shl32(ints[1] & 65535);
    }
    exports.extractTokenDouble = extractTokenDouble;
    var STRINGIFIED_NUMBER_REGEX = new RegExp(exports.STRINGIFIED_NUMBER_PATTERN);
    function stringContainsNumberTokens(x) {
      return !!x.match(STRINGIFIED_NUMBER_REGEX);
    }
    exports.stringContainsNumberTokens = stringContainsNumberTokens;
  }
});

// node_modules/aws-cdk-lib/core/lib/private/intrinsic.js
var require_intrinsic = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/intrinsic.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.Intrinsic = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var stack_trace_1 = require_stack_trace2();
    var token_1 = require_token();
    var Intrinsic = class {
      constructor(value, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IntrinsicProps(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, Intrinsic), error;
        }
        if (isFunction(value))
          throw new Error(`Argument to Intrinsic must be a plain value object, got ${value}`);
        this.creationStack = options.stackTrace ?? true ? stack_trace_1.captureStackTrace() : [], this.value = value;
      }
      resolve(_context) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IResolveContext(_context);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.resolve), error;
        }
        return this.value;
      }
      toString() {
        return token_1.Token.asString(this);
      }
      toStringList() {
        return token_1.Token.asList(this);
      }
      toJSON() {
        return "<unresolved-token>";
      }
      newError(message) {
        return new Error(`${message}
Token created:
    at ${this.creationStack.join(`
    at `)}
Error thrown:`);
      }
    };
    exports.Intrinsic = Intrinsic, _a = JSII_RTTI_SYMBOL_1, Intrinsic[_a] = { fqn: "aws-cdk-lib.Intrinsic", version: "2.50.0" };
    function isFunction(x) {
      return typeof x == "function";
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/private/token-map.js
var require_token_map = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/token-map.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.TokenMap = void 0;
    var token_1 = require_token();
    var encoding_1 = require_encoding();
    var glob = global;
    var STRING_SYMBOL = Symbol.for("@aws-cdk/core.TokenMap.STRING");
    var LIST_SYMBOL = Symbol.for("@aws-cdk/core.TokenMap.LIST");
    var NUMBER_SYMBOL = Symbol.for("@aws-cdk/core.TokenMap.NUMBER");
    var TokenMap = class {
      constructor() {
        this.stringTokenMap = /* @__PURE__ */ new Map(), this.numberTokenMap = /* @__PURE__ */ new Map(), this.tokenCounter = Math.floor(Math.random() * 10);
      }
      static instance() {
        return glob.__cdkTokenMap || (glob.__cdkTokenMap = new TokenMap()), glob.__cdkTokenMap;
      }
      registerString(token, displayHint) {
        return cachedValue(token, STRING_SYMBOL, () => {
          const key = this.registerStringKey(token, displayHint);
          return `${encoding_1.BEGIN_STRING_TOKEN_MARKER}${key}${encoding_1.END_TOKEN_MARKER}`;
        });
      }
      registerList(token, displayHint) {
        return cachedValue(token, LIST_SYMBOL, () => {
          const key = this.registerStringKey(token, displayHint);
          return [`${encoding_1.BEGIN_LIST_TOKEN_MARKER}${key}${encoding_1.END_TOKEN_MARKER}`];
        });
      }
      registerNumber(token) {
        return cachedValue(token, NUMBER_SYMBOL, () => this.registerNumberKey(token));
      }
      tokenFromEncoding(x) {
        if (token_1.isResolvableObject(x))
          return x;
        if (typeof x == "string")
          return this.lookupString(x);
        if (Array.isArray(x))
          return this.lookupList(x);
        if (token_1.Token.isUnresolved(x))
          return x;
      }
      lookupString(s) {
        const fragments = this.splitString(s);
        if (fragments.tokens.length > 0 && fragments.length === 1)
          return fragments.firstToken;
      }
      lookupList(xs) {
        if (xs.length !== 1)
          return;
        const fragments = encoding_1.TokenString.forListToken(xs[0]).split(this.lookupToken.bind(this));
        if (fragments.length === 1)
          return fragments.firstToken;
      }
      splitString(s) {
        return encoding_1.TokenString.forString(s).split(this.lookupToken.bind(this));
      }
      lookupNumberToken(x) {
        const tokenIndex = encoding_1.extractTokenDouble(x);
        if (tokenIndex === void 0)
          return;
        const t = this.numberTokenMap.get(tokenIndex);
        if (t === void 0)
          throw new Error("Encoded representation of unknown number Token found");
        return t;
      }
      lookupToken(key) {
        const token = this.stringTokenMap.get(key);
        if (!token)
          throw new Error(`Unrecognized token key: ${key}`);
        return token;
      }
      registerStringKey(token, displayHint) {
        const counter = this.tokenCounter++, key = `${(displayHint || "TOKEN").replace(new RegExp(`[^${encoding_1.VALID_KEY_CHARS}]`, "g"), ".")}.${counter}`;
        return this.stringTokenMap.set(key, token), key;
      }
      registerNumberKey(token) {
        const counter = this.tokenCounter++, dbl = encoding_1.createTokenDouble(counter);
        return this.numberTokenMap.set(counter, token), this.stringTokenMap.set(`${dbl}`, token), dbl;
      }
    };
    exports.TokenMap = TokenMap;
    function cachedValue(x, sym, prod) {
      let cached = x[sym];
      return cached === void 0 && (cached = prod(), Object.defineProperty(x, sym, { value: cached })), cached;
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/resolvable.js
var require_resolvable = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/resolvable.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.DefaultTokenResolver = exports.StringConcat = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var encoding_1 = require_encoding();
    var token_map_1 = require_token_map();
    var StringConcat = class {
      join(left, right) {
        return left === void 0 ? right !== void 0 ? `${right}` : void 0 : right === void 0 ? `${left}` : `${left}${right}`;
      }
    };
    exports.StringConcat = StringConcat, _a = JSII_RTTI_SYMBOL_1, StringConcat[_a] = { fqn: "aws-cdk-lib.StringConcat", version: "2.50.0" };
    var DefaultTokenResolver = class {
      constructor(concat) {
        this.concat = concat;
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IFragmentConcatenator(concat);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, DefaultTokenResolver), error;
        }
      }
      resolveToken(t, context, postProcessor) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IResolvable(t), jsiiDeprecationWarnings.aws_cdk_lib_IResolveContext(context), jsiiDeprecationWarnings.aws_cdk_lib_IPostProcessor(postProcessor);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.resolveToken), error;
        }
        try {
          let resolved = t.resolve(context);
          return resolved = context.resolve(resolved), resolved = postProcessor.postProcess(resolved, context), resolved;
        } catch (e) {
          let message = `Resolution error: ${e.message}.`;
          throw t.creationStack && t.creationStack.length > 0 && (message += `
Object creation stack:
  at ${t.creationStack.join(`
  at `)}`), e.message = message, e;
        }
      }
      resolveString(fragments, context) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TokenizedStringFragments(fragments), jsiiDeprecationWarnings.aws_cdk_lib_IResolveContext(context);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.resolveString), error;
        }
        return fragments.mapTokens({ mapToken: context.resolve }).join(this.concat);
      }
      resolveList(xs, context) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IResolveContext(context);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.resolveList), error;
        }
        if (xs.length !== 1)
          throw new Error(`Cannot add elements to list token, got: ${xs}`);
        const str = encoding_1.TokenString.forListToken(xs[0]), tokenMap = token_map_1.TokenMap.instance(), fragments = str.split(tokenMap.lookupToken.bind(tokenMap));
        if (fragments.length !== 1)
          throw new Error(`Cannot concatenate strings in a tokenized string array, got: ${xs[0]}`);
        return fragments.mapTokens({ mapToken: context.resolve }).firstValue;
      }
    };
    exports.DefaultTokenResolver = DefaultTokenResolver, _b = JSII_RTTI_SYMBOL_1, DefaultTokenResolver[_b] = { fqn: "aws-cdk-lib.DefaultTokenResolver", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/private/resolve.js
var require_resolve = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/resolve.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.resolvedTypeHint = exports.RememberingTokenResolver = exports.findTokens = exports.resolve = exports.ResolutionTypeHint = exports.INTRINSIC_KEY_PREFIX = void 0;
    var resolvable_1 = require_resolvable();
    var encoding_1 = require_encoding();
    var token_map_1 = require_token_map();
    var tokenMap = token_map_1.TokenMap.instance();
    var RESOLUTION_TYPEHINT_SYM = Symbol.for("@aws-cdk/core.resolvedTypeHint");
    exports.INTRINSIC_KEY_PREFIX = "$IntrinsicKey$";
    var ResolutionTypeHint;
    (function(ResolutionTypeHint2) {
      ResolutionTypeHint2.STRING = "string", ResolutionTypeHint2.NUMBER = "number", ResolutionTypeHint2.LIST = "list";
    })(ResolutionTypeHint = exports.ResolutionTypeHint || (exports.ResolutionTypeHint = {}));
    function resolve(obj, options) {
      const prefix = options.prefix || [], pathName = "/" + prefix.join("/");
      function makeContext(appendPath) {
        const newPrefix = appendPath !== void 0 ? prefix.concat([appendPath]) : options.prefix;
        let postProcessor;
        const context = { preparing: options.preparing, scope: options.scope, documentPath: newPrefix ?? [], registerPostProcessor(pp) {
          postProcessor = pp;
        }, resolve(x, changeOptions) {
          return resolve(x, { ...options, ...changeOptions, prefix: newPrefix });
        } };
        return [context, { postProcess(x) {
          return postProcessor ? postProcessor.postProcess(x, context) : x;
        } }];
      }
      if (prefix.length > 200)
        throw new Error("Unable to resolve object tree with circular reference. Path: " + pathName);
      const leaveEmpty = options.removeEmpty === false;
      if (typeof obj > "u")
        return;
      if (obj === null)
        return null;
      if (typeof obj == "function")
        throw new Error(`Trying to resolve a non-data object. Only token are supported for lazy evaluation. Path: ${pathName}. Object: ${obj}`);
      if (typeof obj == "string") {
        if (encoding_1.TokenString.forListToken(obj).test())
          throw new Error("Found an encoded list token string in a scalar string context. Use 'Fn.select(0, list)' (not 'list[0]') to extract elements from token lists.");
        const str = encoding_1.TokenString.forString(obj);
        if (str.test()) {
          const fragments = str.split(tokenMap.lookupToken.bind(tokenMap));
          return tagResolvedValue(options.resolver.resolveString(fragments, makeContext()[0]), ResolutionTypeHint.STRING);
        }
        return obj;
      }
      if (typeof obj == "number")
        return tagResolvedValue(resolveNumberToken(obj, makeContext()[0]), ResolutionTypeHint.NUMBER);
      if (typeof obj != "object" || obj instanceof Date)
        return obj;
      if (Array.isArray(obj))
        return encoding_1.containsListTokenElement(obj) ? tagResolvedValue(options.resolver.resolveList(obj, makeContext()[0]), ResolutionTypeHint.LIST) : obj.map((x, i) => makeContext(`${i}`)[0].resolve(x)).filter((x) => leaveEmpty || typeof x < "u");
      if (encoding_1.unresolved(obj)) {
        const [context, postProcessor] = makeContext();
        return tagResolvedValue(options.resolver.resolveToken(obj, context, postProcessor), ResolutionTypeHint.STRING);
      }
      if (isConstruct(obj))
        throw new Error("Trying to resolve() a Construct at " + pathName);
      const result = {};
      let intrinsicKeyCtr = 0;
      for (const key of Object.keys(obj)) {
        const value = makeContext(String(key))[0].resolve(obj[key]);
        if (typeof value > "u") {
          leaveEmpty && (result[key] = void 0);
          continue;
        }
        if (!encoding_1.unresolved(key)) {
          result[key] = value;
          continue;
        }
        const resolvedKey = makeContext()[0].resolve(key);
        if (typeof resolvedKey == "string")
          result[resolvedKey] = value;
        else {
          if (!options.allowIntrinsicKeys)
            throw new Error(`"${String(key)}" is used as the key in a map so must resolve to a string, but it resolves to: ${JSON.stringify(resolvedKey)}. Consider using "CfnJson" to delay resolution to deployment-time`);
          result[`${exports.INTRINSIC_KEY_PREFIX}${intrinsicKeyCtr++}`] = [resolvedKey, value];
        }
      }
      const previousTypeHint = resolvedTypeHint(obj);
      return previousTypeHint ? tagResolvedValue(result, previousTypeHint) : result;
    }
    exports.resolve = resolve;
    function findTokens(scope, fn) {
      const resolver = new RememberingTokenResolver(new resolvable_1.StringConcat());
      return resolve(fn(), { scope, prefix: [], resolver, preparing: true }), resolver.tokens;
    }
    exports.findTokens = findTokens;
    var RememberingTokenResolver = class extends resolvable_1.DefaultTokenResolver {
      constructor() {
        super(...arguments), this.tokensSeen = /* @__PURE__ */ new Set();
      }
      resolveToken(t, context, postProcessor) {
        return this.tokensSeen.add(t), super.resolveToken(t, context, postProcessor);
      }
      resolveString(s, context) {
        return super.resolveString(s, context);
      }
      get tokens() {
        return Array.from(this.tokensSeen);
      }
    };
    exports.RememberingTokenResolver = RememberingTokenResolver;
    function isConstruct(x) {
      return x._children !== void 0 && x._metadata !== void 0;
    }
    function resolveNumberToken(x, context) {
      const token = token_map_1.TokenMap.instance().lookupNumberToken(x);
      return token === void 0 ? x : context.resolve(token);
    }
    function tagResolvedValue(value, typeHint) {
      return typeof value != "object" || value == null || Object.defineProperty(value, RESOLUTION_TYPEHINT_SYM, { value: typeHint, configurable: true }), value;
    }
    function resolvedTypeHint(value) {
      if (!(typeof value != "object" || value == null))
        return value[RESOLUTION_TYPEHINT_SYM];
    }
    exports.resolvedTypeHint = resolvedTypeHint;
  }
});

// node_modules/aws-cdk-lib/core/lib/token.js
var require_token = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/token.js"(exports) {
    "use strict";
    var _a;
    var _b;
    var _c;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.withResolved = exports.isResolvableObject = exports.Tokenization = exports.Token = exports.TokenComparison = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var lazy_1 = require_lazy();
    var encoding_1 = require_encoding();
    var intrinsic_1 = require_intrinsic();
    var resolve_1 = require_resolve();
    var token_map_1 = require_token_map();
    var TokenComparison = class {
      constructor() {
      }
    };
    exports.TokenComparison = TokenComparison, _a = JSII_RTTI_SYMBOL_1, TokenComparison[_a] = { fqn: "aws-cdk-lib.TokenComparison", version: "2.50.0" }, TokenComparison.SAME = new TokenComparison(), TokenComparison.DIFFERENT = new TokenComparison(), TokenComparison.ONE_UNRESOLVED = new TokenComparison(), TokenComparison.BOTH_UNRESOLVED = new TokenComparison();
    var Token = class {
      constructor() {
      }
      static isUnresolved(obj) {
        return encoding_1.unresolved(obj);
      }
      static asString(value, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_EncodingOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.asString), error;
        }
        return typeof value == "string" ? value : token_map_1.TokenMap.instance().registerString(Token.asAny(value), options.displayHint);
      }
      static asNumber(value) {
        return typeof value == "number" ? value : token_map_1.TokenMap.instance().registerNumber(Token.asAny(value));
      }
      static asList(value, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_EncodingOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.asList), error;
        }
        return Array.isArray(value) && value.every((x) => typeof x == "string") ? value : token_map_1.TokenMap.instance().registerList(Token.asAny(value), options.displayHint);
      }
      static asAny(value) {
        return value = Tokenization.reverse(value) ?? value, isResolvableObject(value) ? value : new intrinsic_1.Intrinsic(value);
      }
      static compareStrings(possibleToken1, possibleToken2) {
        const firstIsUnresolved = Token.isUnresolved(possibleToken1), secondIsUnresolved = Token.isUnresolved(possibleToken2);
        return firstIsUnresolved && secondIsUnresolved ? TokenComparison.BOTH_UNRESOLVED : firstIsUnresolved || secondIsUnresolved ? TokenComparison.ONE_UNRESOLVED : possibleToken1 === possibleToken2 ? TokenComparison.SAME : TokenComparison.DIFFERENT;
      }
    };
    exports.Token = Token, _b = JSII_RTTI_SYMBOL_1, Token[_b] = { fqn: "aws-cdk-lib.Token", version: "2.50.0" };
    var Tokenization = class {
      constructor() {
      }
      static reverseString(s) {
        return token_map_1.TokenMap.instance().splitString(s);
      }
      static reverseCompleteString(s) {
        const fragments = Tokenization.reverseString(s);
        if (fragments.length !== 1)
          throw new Error(`Tokenzation.reverseCompleteString: argument must not be a concatentation, got '${s}'`);
        return fragments.firstToken;
      }
      static reverseNumber(n) {
        return token_map_1.TokenMap.instance().lookupNumberToken(n);
      }
      static reverseList(l) {
        return token_map_1.TokenMap.instance().lookupList(l);
      }
      static reverse(x, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ReverseOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.reverse), error;
        }
        if (Tokenization.isResolvable(x))
          return x;
        if (typeof x == "string") {
          if (options.failConcat === false) {
            const fragments = Tokenization.reverseString(x);
            return fragments.length === 1 ? fragments.firstToken : void 0;
          }
          return Tokenization.reverseCompleteString(x);
        }
        if (Array.isArray(x))
          return Tokenization.reverseList(x);
        if (typeof x == "number")
          return Tokenization.reverseNumber(x);
      }
      static resolve(obj, options) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ResolveOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.resolve), error;
        }
        return resolve_1.resolve(obj, { scope: options.scope, resolver: options.resolver, preparing: options.preparing ?? false, removeEmpty: options.removeEmpty });
      }
      static isResolvable(obj) {
        return isResolvableObject(obj);
      }
      static stringifyNumber(x) {
        return Token.isUnresolved(x) ? lazy_1.Lazy.uncachedString({ produce: (context) => {
          const resolved = context.resolve(x);
          return typeof resolved != "number" ? resolved : `${resolved}`;
        } }) : typeof x != "number" ? x : `${x}`;
      }
    };
    exports.Tokenization = Tokenization, _c = JSII_RTTI_SYMBOL_1, Tokenization[_c] = { fqn: "aws-cdk-lib.Tokenization", version: "2.50.0" };
    function isResolvableObject(x) {
      return typeof x == "object" && x !== null && typeof x.resolve == "function";
    }
    exports.isResolvableObject = isResolvableObject;
    function withResolved(...args) {
      if (args.length < 2)
        return;
      const argArray = args.slice(0, args.length - 1);
      argArray.some(Token.isUnresolved) || args[args.length - 1].apply(arguments, argArray);
    }
    exports.withResolved = withResolved;
  }
});

// node_modules/aws-cdk-lib/core/lib/lazy.js
var require_lazy = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/lazy.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.Lazy = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var debug_1 = require_debug2();
    var stack_trace_1 = require_stack_trace2();
    var token_1 = require_token();
    var Lazy = class {
      constructor() {
      }
      static stringValue(producer, options = {}) {
        return token_1.Token.asString(new LazyString(producer, false), options);
      }
      static string(producer, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IStableStringProducer(producer), jsiiDeprecationWarnings.aws_cdk_lib_LazyStringValueOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.string), error;
        }
        return token_1.Token.asString(new LazyString(producer, true), options);
      }
      static uncachedString(producer, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IStringProducer(producer), jsiiDeprecationWarnings.aws_cdk_lib_LazyStringValueOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.uncachedString), error;
        }
        return token_1.Token.asString(new LazyString(producer, false), options);
      }
      static numberValue(producer) {
        return token_1.Token.asNumber(new LazyNumber(producer, false));
      }
      static number(producer) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IStableNumberProducer(producer);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.number), error;
        }
        return token_1.Token.asNumber(new LazyNumber(producer, true));
      }
      static uncachedNumber(producer) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_INumberProducer(producer);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.uncachedNumber), error;
        }
        return token_1.Token.asNumber(new LazyNumber(producer, false));
      }
      static listValue(producer, options = {}) {
        return token_1.Token.asList(new LazyList(producer, false, options), options);
      }
      static uncachedList(producer, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IListProducer(producer), jsiiDeprecationWarnings.aws_cdk_lib_LazyListValueOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.uncachedList), error;
        }
        return token_1.Token.asList(new LazyList(producer, false, options), options);
      }
      static list(producer, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IStableListProducer(producer), jsiiDeprecationWarnings.aws_cdk_lib_LazyListValueOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.list), error;
        }
        return token_1.Token.asList(new LazyList(producer, true, options), options);
      }
      static anyValue(producer, options = {}) {
        return new LazyAny(producer, false, options);
      }
      static any(producer, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IStableAnyProducer(producer), jsiiDeprecationWarnings.aws_cdk_lib_LazyAnyValueOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.any), error;
        }
        return new LazyAny(producer, true, options);
      }
      static uncachedAny(producer, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IAnyProducer(producer), jsiiDeprecationWarnings.aws_cdk_lib_LazyAnyValueOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.uncachedAny), error;
        }
        return new LazyAny(producer, false, options);
      }
    };
    exports.Lazy = Lazy, _a = JSII_RTTI_SYMBOL_1, Lazy[_a] = { fqn: "aws-cdk-lib.Lazy", version: "2.50.0" };
    var LazyBase = class {
      constructor(producer, cache) {
        this.producer = producer, this.cache = cache, this.creationStack = debug_1.debugModeEnabled() ? stack_trace_1.captureStackTrace(this.constructor) : [`Execute again with ${debug_1.CDK_DEBUG}=true to capture stack traces`];
      }
      resolve(context) {
        return this.cache ? this._cached ?? (this._cached = this.producer.produce(context)) : this.producer.produce(context);
      }
      toString() {
        return token_1.Token.asString(this);
      }
      toJSON() {
        return "<unresolved-lazy>";
      }
    };
    var LazyString = class extends LazyBase {
    };
    var LazyNumber = class extends LazyBase {
    };
    var LazyList = class extends LazyBase {
      constructor(producer, cache, options = {}) {
        super(producer, cache), this.options = options;
      }
      resolve(context) {
        const resolved = super.resolve(context);
        if (!((resolved == null ? void 0 : resolved.length) === 0 && this.options.omitEmpty))
          return resolved;
      }
    };
    var LazyAny = class extends LazyBase {
      constructor(producer, cache, options = {}) {
        super(producer, cache), this.options = options;
      }
      resolve(context) {
        const resolved = super.resolve(context);
        if (!(Array.isArray(resolved) && resolved.length === 0 && this.options.omitEmptyArray))
          return resolved;
      }
    };
  }
});

// node_modules/aws-cdk-lib/core/lib/reference.js
var require_reference = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/reference.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.Reference = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var intrinsic_1 = require_intrinsic();
    var REFERENCE_SYMBOL = Symbol.for("@aws-cdk/core.Reference");
    var Reference = class extends intrinsic_1.Intrinsic {
      constructor(value, target, displayName) {
        super(value), Object.defineProperty(this, REFERENCE_SYMBOL, { value: true }), this.target = target, this.displayName = displayName || "Reference";
      }
      static isReference(x) {
        return typeof x == "object" && x !== null && REFERENCE_SYMBOL in x;
      }
    };
    exports.Reference = Reference, _a = JSII_RTTI_SYMBOL_1, Reference[_a] = { fqn: "aws-cdk-lib.Reference", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/node_modules/concat-map/index.js
var require_concat_map = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/concat-map/index.js"(exports, module2) {
    module2.exports = function(xs, fn) {
      var res = [];
      for (var i = 0; i < xs.length; i++) {
        var x = fn(xs[i], i);
        if (isArray(x))
          res.push.apply(res, x);
        else
          res.push(x);
      }
      return res;
    };
    var isArray = Array.isArray || function(xs) {
      return Object.prototype.toString.call(xs) === "[object Array]";
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/balanced-match/index.js
var require_balanced_match = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/balanced-match/index.js"(exports, module2) {
    "use strict";
    module2.exports = balanced;
    function balanced(a, b, str) {
      if (a instanceof RegExp)
        a = maybeMatch(a, str);
      if (b instanceof RegExp)
        b = maybeMatch(b, str);
      var r = range(a, b, str);
      return r && {
        start: r[0],
        end: r[1],
        pre: str.slice(0, r[0]),
        body: str.slice(r[0] + a.length, r[1]),
        post: str.slice(r[1] + b.length)
      };
    }
    function maybeMatch(reg, str) {
      var m = str.match(reg);
      return m ? m[0] : null;
    }
    balanced.range = range;
    function range(a, b, str) {
      var begs, beg, left, right, result;
      var ai = str.indexOf(a);
      var bi = str.indexOf(b, ai + 1);
      var i = ai;
      if (ai >= 0 && bi > 0) {
        if (a === b) {
          return [ai, bi];
        }
        begs = [];
        left = str.length;
        while (i >= 0 && !result) {
          if (i == ai) {
            begs.push(i);
            ai = str.indexOf(a, i + 1);
          } else if (begs.length == 1) {
            result = [begs.pop(), bi];
          } else {
            beg = begs.pop();
            if (beg < left) {
              left = beg;
              right = bi;
            }
            bi = str.indexOf(b, i + 1);
          }
          i = ai < bi && ai >= 0 ? ai : bi;
        }
        if (begs.length) {
          result = [left, right];
        }
      }
      return result;
    }
  }
});

// node_modules/aws-cdk-lib/node_modules/brace-expansion/index.js
var require_brace_expansion = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/brace-expansion/index.js"(exports, module2) {
    var concatMap = require_concat_map();
    var balanced = require_balanced_match();
    module2.exports = expandTop;
    var escSlash = "\0SLASH" + Math.random() + "\0";
    var escOpen = "\0OPEN" + Math.random() + "\0";
    var escClose = "\0CLOSE" + Math.random() + "\0";
    var escComma = "\0COMMA" + Math.random() + "\0";
    var escPeriod = "\0PERIOD" + Math.random() + "\0";
    function numeric(str) {
      return parseInt(str, 10) == str ? parseInt(str, 10) : str.charCodeAt(0);
    }
    function escapeBraces(str) {
      return str.split("\\\\").join(escSlash).split("\\{").join(escOpen).split("\\}").join(escClose).split("\\,").join(escComma).split("\\.").join(escPeriod);
    }
    function unescapeBraces(str) {
      return str.split(escSlash).join("\\").split(escOpen).join("{").split(escClose).join("}").split(escComma).join(",").split(escPeriod).join(".");
    }
    function parseCommaParts(str) {
      if (!str)
        return [""];
      var parts = [];
      var m = balanced("{", "}", str);
      if (!m)
        return str.split(",");
      var pre = m.pre;
      var body = m.body;
      var post = m.post;
      var p = pre.split(",");
      p[p.length - 1] += "{" + body + "}";
      var postParts = parseCommaParts(post);
      if (post.length) {
        p[p.length - 1] += postParts.shift();
        p.push.apply(p, postParts);
      }
      parts.push.apply(parts, p);
      return parts;
    }
    function expandTop(str) {
      if (!str)
        return [];
      if (str.substr(0, 2) === "{}") {
        str = "\\{\\}" + str.substr(2);
      }
      return expand(escapeBraces(str), true).map(unescapeBraces);
    }
    function embrace(str) {
      return "{" + str + "}";
    }
    function isPadded(el) {
      return /^-?0\d/.test(el);
    }
    function lte(i, y) {
      return i <= y;
    }
    function gte(i, y) {
      return i >= y;
    }
    function expand(str, isTop) {
      var expansions = [];
      var m = balanced("{", "}", str);
      if (!m || /\$$/.test(m.pre))
        return [str];
      var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m.body);
      var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m.body);
      var isSequence = isNumericSequence || isAlphaSequence;
      var isOptions = m.body.indexOf(",") >= 0;
      if (!isSequence && !isOptions) {
        if (m.post.match(/,.*\}/)) {
          str = m.pre + "{" + m.body + escClose + m.post;
          return expand(str);
        }
        return [str];
      }
      var n;
      if (isSequence) {
        n = m.body.split(/\.\./);
      } else {
        n = parseCommaParts(m.body);
        if (n.length === 1) {
          n = expand(n[0], false).map(embrace);
          if (n.length === 1) {
            var post = m.post.length ? expand(m.post, false) : [""];
            return post.map(function(p) {
              return m.pre + n[0] + p;
            });
          }
        }
      }
      var pre = m.pre;
      var post = m.post.length ? expand(m.post, false) : [""];
      var N;
      if (isSequence) {
        var x = numeric(n[0]);
        var y = numeric(n[1]);
        var width = Math.max(n[0].length, n[1].length);
        var incr = n.length == 3 ? Math.abs(numeric(n[2])) : 1;
        var test = lte;
        var reverse = y < x;
        if (reverse) {
          incr *= -1;
          test = gte;
        }
        var pad = n.some(isPadded);
        N = [];
        for (var i = x; test(i, y); i += incr) {
          var c;
          if (isAlphaSequence) {
            c = String.fromCharCode(i);
            if (c === "\\")
              c = "";
          } else {
            c = String(i);
            if (pad) {
              var need = width - c.length;
              if (need > 0) {
                var z = new Array(need + 1).join("0");
                if (i < 0)
                  c = "-" + z + c.slice(1);
                else
                  c = z + c;
              }
            }
          }
          N.push(c);
        }
      } else {
        N = concatMap(n, function(el) {
          return expand(el, false);
        });
      }
      for (var j = 0; j < N.length; j++) {
        for (var k = 0; k < post.length; k++) {
          var expansion = pre + N[j] + post[k];
          if (!isTop || isSequence || expansion)
            expansions.push(expansion);
        }
      }
      return expansions;
    }
  }
});

// node_modules/aws-cdk-lib/node_modules/minimatch/minimatch.js
var require_minimatch = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/minimatch/minimatch.js"(exports, module2) {
    module2.exports = minimatch;
    minimatch.Minimatch = Minimatch;
    var path = function() {
      try {
        return require("path");
      } catch (e) {
      }
    }() || {
      sep: "/"
    };
    minimatch.sep = path.sep;
    var GLOBSTAR = minimatch.GLOBSTAR = Minimatch.GLOBSTAR = {};
    var expand = require_brace_expansion();
    var plTypes = {
      "!": { open: "(?:(?!(?:", close: "))[^/]*?)" },
      "?": { open: "(?:", close: ")?" },
      "+": { open: "(?:", close: ")+" },
      "*": { open: "(?:", close: ")*" },
      "@": { open: "(?:", close: ")" }
    };
    var qmark = "[^/]";
    var star = qmark + "*?";
    var twoStarDot = "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?";
    var twoStarNoDot = "(?:(?!(?:\\/|^)\\.).)*?";
    var reSpecials = charSet("().*{}+?[]^$\\!");
    function charSet(s) {
      return s.split("").reduce(function(set, c) {
        set[c] = true;
        return set;
      }, {});
    }
    var slashSplit = /\/+/;
    minimatch.filter = filter;
    function filter(pattern, options) {
      options = options || {};
      return function(p, i, list) {
        return minimatch(p, pattern, options);
      };
    }
    function ext(a, b) {
      b = b || {};
      var t = {};
      Object.keys(a).forEach(function(k) {
        t[k] = a[k];
      });
      Object.keys(b).forEach(function(k) {
        t[k] = b[k];
      });
      return t;
    }
    minimatch.defaults = function(def) {
      if (!def || typeof def !== "object" || !Object.keys(def).length) {
        return minimatch;
      }
      var orig = minimatch;
      var m = function minimatch2(p, pattern, options) {
        return orig(p, pattern, ext(def, options));
      };
      m.Minimatch = function Minimatch2(pattern, options) {
        return new orig.Minimatch(pattern, ext(def, options));
      };
      m.Minimatch.defaults = function defaults(options) {
        return orig.defaults(ext(def, options)).Minimatch;
      };
      m.filter = function filter2(pattern, options) {
        return orig.filter(pattern, ext(def, options));
      };
      m.defaults = function defaults(options) {
        return orig.defaults(ext(def, options));
      };
      m.makeRe = function makeRe2(pattern, options) {
        return orig.makeRe(pattern, ext(def, options));
      };
      m.braceExpand = function braceExpand2(pattern, options) {
        return orig.braceExpand(pattern, ext(def, options));
      };
      m.match = function(list, pattern, options) {
        return orig.match(list, pattern, ext(def, options));
      };
      return m;
    };
    Minimatch.defaults = function(def) {
      return minimatch.defaults(def).Minimatch;
    };
    function minimatch(p, pattern, options) {
      assertValidPattern(pattern);
      if (!options)
        options = {};
      if (!options.nocomment && pattern.charAt(0) === "#") {
        return false;
      }
      return new Minimatch(pattern, options).match(p);
    }
    function Minimatch(pattern, options) {
      if (!(this instanceof Minimatch)) {
        return new Minimatch(pattern, options);
      }
      assertValidPattern(pattern);
      if (!options)
        options = {};
      pattern = pattern.trim();
      if (!options.allowWindowsEscape && path.sep !== "/") {
        pattern = pattern.split(path.sep).join("/");
      }
      this.options = options;
      this.set = [];
      this.pattern = pattern;
      this.regexp = null;
      this.negate = false;
      this.comment = false;
      this.empty = false;
      this.partial = !!options.partial;
      this.make();
    }
    Minimatch.prototype.debug = function() {
    };
    Minimatch.prototype.make = make;
    function make() {
      var pattern = this.pattern;
      var options = this.options;
      if (!options.nocomment && pattern.charAt(0) === "#") {
        this.comment = true;
        return;
      }
      if (!pattern) {
        this.empty = true;
        return;
      }
      this.parseNegate();
      var set = this.globSet = this.braceExpand();
      if (options.debug)
        this.debug = function debug() {
          console.error.apply(console, arguments);
        };
      this.debug(this.pattern, set);
      set = this.globParts = set.map(function(s) {
        return s.split(slashSplit);
      });
      this.debug(this.pattern, set);
      set = set.map(function(s, si, set2) {
        return s.map(this.parse, this);
      }, this);
      this.debug(this.pattern, set);
      set = set.filter(function(s) {
        return s.indexOf(false) === -1;
      });
      this.debug(this.pattern, set);
      this.set = set;
    }
    Minimatch.prototype.parseNegate = parseNegate;
    function parseNegate() {
      var pattern = this.pattern;
      var negate = false;
      var options = this.options;
      var negateOffset = 0;
      if (options.nonegate)
        return;
      for (var i = 0, l = pattern.length; i < l && pattern.charAt(i) === "!"; i++) {
        negate = !negate;
        negateOffset++;
      }
      if (negateOffset)
        this.pattern = pattern.substr(negateOffset);
      this.negate = negate;
    }
    minimatch.braceExpand = function(pattern, options) {
      return braceExpand(pattern, options);
    };
    Minimatch.prototype.braceExpand = braceExpand;
    function braceExpand(pattern, options) {
      if (!options) {
        if (this instanceof Minimatch) {
          options = this.options;
        } else {
          options = {};
        }
      }
      pattern = typeof pattern === "undefined" ? this.pattern : pattern;
      assertValidPattern(pattern);
      if (options.nobrace || !/\{(?:(?!\{).)*\}/.test(pattern)) {
        return [pattern];
      }
      return expand(pattern);
    }
    var MAX_PATTERN_LENGTH = 1024 * 64;
    var assertValidPattern = function(pattern) {
      if (typeof pattern !== "string") {
        throw new TypeError("invalid pattern");
      }
      if (pattern.length > MAX_PATTERN_LENGTH) {
        throw new TypeError("pattern is too long");
      }
    };
    Minimatch.prototype.parse = parse;
    var SUBPARSE = {};
    function parse(pattern, isSub) {
      assertValidPattern(pattern);
      var options = this.options;
      if (pattern === "**") {
        if (!options.noglobstar)
          return GLOBSTAR;
        else
          pattern = "*";
      }
      if (pattern === "")
        return "";
      var re = "";
      var hasMagic = !!options.nocase;
      var escaping = false;
      var patternListStack = [];
      var negativeLists = [];
      var stateChar;
      var inClass = false;
      var reClassStart = -1;
      var classStart = -1;
      var patternStart = pattern.charAt(0) === "." ? "" : options.dot ? "(?!(?:^|\\/)\\.{1,2}(?:$|\\/))" : "(?!\\.)";
      var self = this;
      function clearStateChar() {
        if (stateChar) {
          switch (stateChar) {
            case "*":
              re += star;
              hasMagic = true;
              break;
            case "?":
              re += qmark;
              hasMagic = true;
              break;
            default:
              re += "\\" + stateChar;
              break;
          }
          self.debug("clearStateChar %j %j", stateChar, re);
          stateChar = false;
        }
      }
      for (var i = 0, len = pattern.length, c; i < len && (c = pattern.charAt(i)); i++) {
        this.debug("%s	%s %s %j", pattern, i, re, c);
        if (escaping && reSpecials[c]) {
          re += "\\" + c;
          escaping = false;
          continue;
        }
        switch (c) {
          case "/": {
            return false;
          }
          case "\\":
            clearStateChar();
            escaping = true;
            continue;
          case "?":
          case "*":
          case "+":
          case "@":
          case "!":
            this.debug("%s	%s %s %j <-- stateChar", pattern, i, re, c);
            if (inClass) {
              this.debug("  in class");
              if (c === "!" && i === classStart + 1)
                c = "^";
              re += c;
              continue;
            }
            self.debug("call clearStateChar %j", stateChar);
            clearStateChar();
            stateChar = c;
            if (options.noext)
              clearStateChar();
            continue;
          case "(":
            if (inClass) {
              re += "(";
              continue;
            }
            if (!stateChar) {
              re += "\\(";
              continue;
            }
            patternListStack.push({
              type: stateChar,
              start: i - 1,
              reStart: re.length,
              open: plTypes[stateChar].open,
              close: plTypes[stateChar].close
            });
            re += stateChar === "!" ? "(?:(?!(?:" : "(?:";
            this.debug("plType %j %j", stateChar, re);
            stateChar = false;
            continue;
          case ")":
            if (inClass || !patternListStack.length) {
              re += "\\)";
              continue;
            }
            clearStateChar();
            hasMagic = true;
            var pl = patternListStack.pop();
            re += pl.close;
            if (pl.type === "!") {
              negativeLists.push(pl);
            }
            pl.reEnd = re.length;
            continue;
          case "|":
            if (inClass || !patternListStack.length || escaping) {
              re += "\\|";
              escaping = false;
              continue;
            }
            clearStateChar();
            re += "|";
            continue;
          case "[":
            clearStateChar();
            if (inClass) {
              re += "\\" + c;
              continue;
            }
            inClass = true;
            classStart = i;
            reClassStart = re.length;
            re += c;
            continue;
          case "]":
            if (i === classStart + 1 || !inClass) {
              re += "\\" + c;
              escaping = false;
              continue;
            }
            var cs = pattern.substring(classStart + 1, i);
            try {
              RegExp("[" + cs + "]");
            } catch (er) {
              var sp = this.parse(cs, SUBPARSE);
              re = re.substr(0, reClassStart) + "\\[" + sp[0] + "\\]";
              hasMagic = hasMagic || sp[1];
              inClass = false;
              continue;
            }
            hasMagic = true;
            inClass = false;
            re += c;
            continue;
          default:
            clearStateChar();
            if (escaping) {
              escaping = false;
            } else if (reSpecials[c] && !(c === "^" && inClass)) {
              re += "\\";
            }
            re += c;
        }
      }
      if (inClass) {
        cs = pattern.substr(classStart + 1);
        sp = this.parse(cs, SUBPARSE);
        re = re.substr(0, reClassStart) + "\\[" + sp[0];
        hasMagic = hasMagic || sp[1];
      }
      for (pl = patternListStack.pop(); pl; pl = patternListStack.pop()) {
        var tail = re.slice(pl.reStart + pl.open.length);
        this.debug("setting tail", re, pl);
        tail = tail.replace(/((?:\\{2}){0,64})(\\?)\|/g, function(_, $1, $2) {
          if (!$2) {
            $2 = "\\";
          }
          return $1 + $1 + $2 + "|";
        });
        this.debug("tail=%j\n   %s", tail, tail, pl, re);
        var t = pl.type === "*" ? star : pl.type === "?" ? qmark : "\\" + pl.type;
        hasMagic = true;
        re = re.slice(0, pl.reStart) + t + "\\(" + tail;
      }
      clearStateChar();
      if (escaping) {
        re += "\\\\";
      }
      var addPatternStart = false;
      switch (re.charAt(0)) {
        case "[":
        case ".":
        case "(":
          addPatternStart = true;
      }
      for (var n = negativeLists.length - 1; n > -1; n--) {
        var nl = negativeLists[n];
        var nlBefore = re.slice(0, nl.reStart);
        var nlFirst = re.slice(nl.reStart, nl.reEnd - 8);
        var nlLast = re.slice(nl.reEnd - 8, nl.reEnd);
        var nlAfter = re.slice(nl.reEnd);
        nlLast += nlAfter;
        var openParensBefore = nlBefore.split("(").length - 1;
        var cleanAfter = nlAfter;
        for (i = 0; i < openParensBefore; i++) {
          cleanAfter = cleanAfter.replace(/\)[+*?]?/, "");
        }
        nlAfter = cleanAfter;
        var dollar = "";
        if (nlAfter === "" && isSub !== SUBPARSE) {
          dollar = "$";
        }
        var newRe = nlBefore + nlFirst + nlAfter + dollar + nlLast;
        re = newRe;
      }
      if (re !== "" && hasMagic) {
        re = "(?=.)" + re;
      }
      if (addPatternStart) {
        re = patternStart + re;
      }
      if (isSub === SUBPARSE) {
        return [re, hasMagic];
      }
      if (!hasMagic) {
        return globUnescape(pattern);
      }
      var flags = options.nocase ? "i" : "";
      try {
        var regExp = new RegExp("^" + re + "$", flags);
      } catch (er) {
        return new RegExp("$.");
      }
      regExp._glob = pattern;
      regExp._src = re;
      return regExp;
    }
    minimatch.makeRe = function(pattern, options) {
      return new Minimatch(pattern, options || {}).makeRe();
    };
    Minimatch.prototype.makeRe = makeRe;
    function makeRe() {
      if (this.regexp || this.regexp === false)
        return this.regexp;
      var set = this.set;
      if (!set.length) {
        this.regexp = false;
        return this.regexp;
      }
      var options = this.options;
      var twoStar = options.noglobstar ? star : options.dot ? twoStarDot : twoStarNoDot;
      var flags = options.nocase ? "i" : "";
      var re = set.map(function(pattern) {
        return pattern.map(function(p) {
          return p === GLOBSTAR ? twoStar : typeof p === "string" ? regExpEscape(p) : p._src;
        }).join("\\/");
      }).join("|");
      re = "^(?:" + re + ")$";
      if (this.negate)
        re = "^(?!" + re + ").*$";
      try {
        this.regexp = new RegExp(re, flags);
      } catch (ex) {
        this.regexp = false;
      }
      return this.regexp;
    }
    minimatch.match = function(list, pattern, options) {
      options = options || {};
      var mm = new Minimatch(pattern, options);
      list = list.filter(function(f) {
        return mm.match(f);
      });
      if (mm.options.nonull && !list.length) {
        list.push(pattern);
      }
      return list;
    };
    Minimatch.prototype.match = function match(f, partial) {
      if (typeof partial === "undefined")
        partial = this.partial;
      this.debug("match", f, this.pattern);
      if (this.comment)
        return false;
      if (this.empty)
        return f === "";
      if (f === "/" && partial)
        return true;
      var options = this.options;
      if (path.sep !== "/") {
        f = f.split(path.sep).join("/");
      }
      f = f.split(slashSplit);
      this.debug(this.pattern, "split", f);
      var set = this.set;
      this.debug(this.pattern, "set", set);
      var filename;
      var i;
      for (i = f.length - 1; i >= 0; i--) {
        filename = f[i];
        if (filename)
          break;
      }
      for (i = 0; i < set.length; i++) {
        var pattern = set[i];
        var file = f;
        if (options.matchBase && pattern.length === 1) {
          file = [filename];
        }
        var hit = this.matchOne(file, pattern, partial);
        if (hit) {
          if (options.flipNegate)
            return true;
          return !this.negate;
        }
      }
      if (options.flipNegate)
        return false;
      return this.negate;
    };
    Minimatch.prototype.matchOne = function(file, pattern, partial) {
      var options = this.options;
      this.debug(
        "matchOne",
        { "this": this, file, pattern }
      );
      this.debug("matchOne", file.length, pattern.length);
      for (var fi = 0, pi = 0, fl = file.length, pl = pattern.length; fi < fl && pi < pl; fi++, pi++) {
        this.debug("matchOne loop");
        var p = pattern[pi];
        var f = file[fi];
        this.debug(pattern, p, f);
        if (p === false)
          return false;
        if (p === GLOBSTAR) {
          this.debug("GLOBSTAR", [pattern, p, f]);
          var fr = fi;
          var pr = pi + 1;
          if (pr === pl) {
            this.debug("** at the end");
            for (; fi < fl; fi++) {
              if (file[fi] === "." || file[fi] === ".." || !options.dot && file[fi].charAt(0) === ".")
                return false;
            }
            return true;
          }
          while (fr < fl) {
            var swallowee = file[fr];
            this.debug("\nglobstar while", file, fr, pattern, pr, swallowee);
            if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
              this.debug("globstar found match!", fr, fl, swallowee);
              return true;
            } else {
              if (swallowee === "." || swallowee === ".." || !options.dot && swallowee.charAt(0) === ".") {
                this.debug("dot detected!", file, fr, pattern, pr);
                break;
              }
              this.debug("globstar swallow a segment, and continue");
              fr++;
            }
          }
          if (partial) {
            this.debug("\n>>> no match, partial?", file, fr, pattern, pr);
            if (fr === fl)
              return true;
          }
          return false;
        }
        var hit;
        if (typeof p === "string") {
          hit = f === p;
          this.debug("string match", p, f, hit);
        } else {
          hit = f.match(p);
          this.debug("pattern match", p, f, hit);
        }
        if (!hit)
          return false;
      }
      if (fi === fl && pi === pl) {
        return true;
      } else if (fi === fl) {
        return partial;
      } else if (pi === pl) {
        return fi === fl - 1 && file[fi] === "";
      }
      throw new Error("wtf?");
    };
    function globUnescape(s) {
      return s.replace(/\\(.)/g, "$1");
    }
    function regExpEscape(s) {
      return s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    }
  }
});

// node_modules/aws-cdk-lib/node_modules/universalify/index.js
var require_universalify = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/universalify/index.js"(exports) {
    "use strict";
    exports.fromCallback = function(fn) {
      return Object.defineProperty(function(...args) {
        if (typeof args[args.length - 1] === "function")
          fn.apply(this, args);
        else {
          return new Promise((resolve, reject) => {
            fn.call(
              this,
              ...args,
              (err, res) => err != null ? reject(err) : resolve(res)
            );
          });
        }
      }, "name", { value: fn.name });
    };
    exports.fromPromise = function(fn) {
      return Object.defineProperty(function(...args) {
        const cb = args[args.length - 1];
        if (typeof cb !== "function")
          return fn.apply(this, args);
        else
          fn.apply(this, args.slice(0, -1)).then((r) => cb(null, r), cb);
      }, "name", { value: fn.name });
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/graceful-fs/polyfills.js
var require_polyfills = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/graceful-fs/polyfills.js"(exports, module2) {
    var constants = require("constants");
    var origCwd = process.cwd;
    var cwd = null;
    var platform = process.env.GRACEFUL_FS_PLATFORM || process.platform;
    process.cwd = function() {
      if (!cwd)
        cwd = origCwd.call(process);
      return cwd;
    };
    try {
      process.cwd();
    } catch (er) {
    }
    if (typeof process.chdir === "function") {
      chdir = process.chdir;
      process.chdir = function(d) {
        cwd = null;
        chdir.call(process, d);
      };
      if (Object.setPrototypeOf)
        Object.setPrototypeOf(process.chdir, chdir);
    }
    var chdir;
    module2.exports = patch;
    function patch(fs) {
      if (constants.hasOwnProperty("O_SYMLINK") && process.version.match(/^v0\.6\.[0-2]|^v0\.5\./)) {
        patchLchmod(fs);
      }
      if (!fs.lutimes) {
        patchLutimes(fs);
      }
      fs.chown = chownFix(fs.chown);
      fs.fchown = chownFix(fs.fchown);
      fs.lchown = chownFix(fs.lchown);
      fs.chmod = chmodFix(fs.chmod);
      fs.fchmod = chmodFix(fs.fchmod);
      fs.lchmod = chmodFix(fs.lchmod);
      fs.chownSync = chownFixSync(fs.chownSync);
      fs.fchownSync = chownFixSync(fs.fchownSync);
      fs.lchownSync = chownFixSync(fs.lchownSync);
      fs.chmodSync = chmodFixSync(fs.chmodSync);
      fs.fchmodSync = chmodFixSync(fs.fchmodSync);
      fs.lchmodSync = chmodFixSync(fs.lchmodSync);
      fs.stat = statFix(fs.stat);
      fs.fstat = statFix(fs.fstat);
      fs.lstat = statFix(fs.lstat);
      fs.statSync = statFixSync(fs.statSync);
      fs.fstatSync = statFixSync(fs.fstatSync);
      fs.lstatSync = statFixSync(fs.lstatSync);
      if (fs.chmod && !fs.lchmod) {
        fs.lchmod = function(path, mode, cb) {
          if (cb)
            process.nextTick(cb);
        };
        fs.lchmodSync = function() {
        };
      }
      if (fs.chown && !fs.lchown) {
        fs.lchown = function(path, uid, gid, cb) {
          if (cb)
            process.nextTick(cb);
        };
        fs.lchownSync = function() {
        };
      }
      if (platform === "win32") {
        fs.rename = typeof fs.rename !== "function" ? fs.rename : function(fs$rename) {
          function rename(from, to, cb) {
            var start = Date.now();
            var backoff = 0;
            fs$rename(from, to, function CB(er) {
              if (er && (er.code === "EACCES" || er.code === "EPERM") && Date.now() - start < 6e4) {
                setTimeout(function() {
                  fs.stat(to, function(stater, st) {
                    if (stater && stater.code === "ENOENT")
                      fs$rename(from, to, CB);
                    else
                      cb(er);
                  });
                }, backoff);
                if (backoff < 100)
                  backoff += 10;
                return;
              }
              if (cb)
                cb(er);
            });
          }
          if (Object.setPrototypeOf)
            Object.setPrototypeOf(rename, fs$rename);
          return rename;
        }(fs.rename);
      }
      fs.read = typeof fs.read !== "function" ? fs.read : function(fs$read) {
        function read(fd, buffer, offset, length, position, callback_) {
          var callback;
          if (callback_ && typeof callback_ === "function") {
            var eagCounter = 0;
            callback = function(er, _, __) {
              if (er && er.code === "EAGAIN" && eagCounter < 10) {
                eagCounter++;
                return fs$read.call(fs, fd, buffer, offset, length, position, callback);
              }
              callback_.apply(this, arguments);
            };
          }
          return fs$read.call(fs, fd, buffer, offset, length, position, callback);
        }
        if (Object.setPrototypeOf)
          Object.setPrototypeOf(read, fs$read);
        return read;
      }(fs.read);
      fs.readSync = typeof fs.readSync !== "function" ? fs.readSync : function(fs$readSync) {
        return function(fd, buffer, offset, length, position) {
          var eagCounter = 0;
          while (true) {
            try {
              return fs$readSync.call(fs, fd, buffer, offset, length, position);
            } catch (er) {
              if (er.code === "EAGAIN" && eagCounter < 10) {
                eagCounter++;
                continue;
              }
              throw er;
            }
          }
        };
      }(fs.readSync);
      function patchLchmod(fs2) {
        fs2.lchmod = function(path, mode, callback) {
          fs2.open(
            path,
            constants.O_WRONLY | constants.O_SYMLINK,
            mode,
            function(err, fd) {
              if (err) {
                if (callback)
                  callback(err);
                return;
              }
              fs2.fchmod(fd, mode, function(err2) {
                fs2.close(fd, function(err22) {
                  if (callback)
                    callback(err2 || err22);
                });
              });
            }
          );
        };
        fs2.lchmodSync = function(path, mode) {
          var fd = fs2.openSync(path, constants.O_WRONLY | constants.O_SYMLINK, mode);
          var threw = true;
          var ret;
          try {
            ret = fs2.fchmodSync(fd, mode);
            threw = false;
          } finally {
            if (threw) {
              try {
                fs2.closeSync(fd);
              } catch (er) {
              }
            } else {
              fs2.closeSync(fd);
            }
          }
          return ret;
        };
      }
      function patchLutimes(fs2) {
        if (constants.hasOwnProperty("O_SYMLINK") && fs2.futimes) {
          fs2.lutimes = function(path, at, mt, cb) {
            fs2.open(path, constants.O_SYMLINK, function(er, fd) {
              if (er) {
                if (cb)
                  cb(er);
                return;
              }
              fs2.futimes(fd, at, mt, function(er2) {
                fs2.close(fd, function(er22) {
                  if (cb)
                    cb(er2 || er22);
                });
              });
            });
          };
          fs2.lutimesSync = function(path, at, mt) {
            var fd = fs2.openSync(path, constants.O_SYMLINK);
            var ret;
            var threw = true;
            try {
              ret = fs2.futimesSync(fd, at, mt);
              threw = false;
            } finally {
              if (threw) {
                try {
                  fs2.closeSync(fd);
                } catch (er) {
                }
              } else {
                fs2.closeSync(fd);
              }
            }
            return ret;
          };
        } else if (fs2.futimes) {
          fs2.lutimes = function(_a, _b, _c, cb) {
            if (cb)
              process.nextTick(cb);
          };
          fs2.lutimesSync = function() {
          };
        }
      }
      function chmodFix(orig) {
        if (!orig)
          return orig;
        return function(target, mode, cb) {
          return orig.call(fs, target, mode, function(er) {
            if (chownErOk(er))
              er = null;
            if (cb)
              cb.apply(this, arguments);
          });
        };
      }
      function chmodFixSync(orig) {
        if (!orig)
          return orig;
        return function(target, mode) {
          try {
            return orig.call(fs, target, mode);
          } catch (er) {
            if (!chownErOk(er))
              throw er;
          }
        };
      }
      function chownFix(orig) {
        if (!orig)
          return orig;
        return function(target, uid, gid, cb) {
          return orig.call(fs, target, uid, gid, function(er) {
            if (chownErOk(er))
              er = null;
            if (cb)
              cb.apply(this, arguments);
          });
        };
      }
      function chownFixSync(orig) {
        if (!orig)
          return orig;
        return function(target, uid, gid) {
          try {
            return orig.call(fs, target, uid, gid);
          } catch (er) {
            if (!chownErOk(er))
              throw er;
          }
        };
      }
      function statFix(orig) {
        if (!orig)
          return orig;
        return function(target, options, cb) {
          if (typeof options === "function") {
            cb = options;
            options = null;
          }
          function callback(er, stats) {
            if (stats) {
              if (stats.uid < 0)
                stats.uid += 4294967296;
              if (stats.gid < 0)
                stats.gid += 4294967296;
            }
            if (cb)
              cb.apply(this, arguments);
          }
          return options ? orig.call(fs, target, options, callback) : orig.call(fs, target, callback);
        };
      }
      function statFixSync(orig) {
        if (!orig)
          return orig;
        return function(target, options) {
          var stats = options ? orig.call(fs, target, options) : orig.call(fs, target);
          if (stats) {
            if (stats.uid < 0)
              stats.uid += 4294967296;
            if (stats.gid < 0)
              stats.gid += 4294967296;
          }
          return stats;
        };
      }
      function chownErOk(er) {
        if (!er)
          return true;
        if (er.code === "ENOSYS")
          return true;
        var nonroot = !process.getuid || process.getuid() !== 0;
        if (nonroot) {
          if (er.code === "EINVAL" || er.code === "EPERM")
            return true;
        }
        return false;
      }
    }
  }
});

// node_modules/aws-cdk-lib/node_modules/graceful-fs/legacy-streams.js
var require_legacy_streams = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/graceful-fs/legacy-streams.js"(exports, module2) {
    var Stream = require("stream").Stream;
    module2.exports = legacy;
    function legacy(fs) {
      return {
        ReadStream,
        WriteStream
      };
      function ReadStream(path, options) {
        if (!(this instanceof ReadStream))
          return new ReadStream(path, options);
        Stream.call(this);
        var self = this;
        this.path = path;
        this.fd = null;
        this.readable = true;
        this.paused = false;
        this.flags = "r";
        this.mode = 438;
        this.bufferSize = 64 * 1024;
        options = options || {};
        var keys = Object.keys(options);
        for (var index = 0, length = keys.length; index < length; index++) {
          var key = keys[index];
          this[key] = options[key];
        }
        if (this.encoding)
          this.setEncoding(this.encoding);
        if (this.start !== void 0) {
          if ("number" !== typeof this.start) {
            throw TypeError("start must be a Number");
          }
          if (this.end === void 0) {
            this.end = Infinity;
          } else if ("number" !== typeof this.end) {
            throw TypeError("end must be a Number");
          }
          if (this.start > this.end) {
            throw new Error("start must be <= end");
          }
          this.pos = this.start;
        }
        if (this.fd !== null) {
          process.nextTick(function() {
            self._read();
          });
          return;
        }
        fs.open(this.path, this.flags, this.mode, function(err, fd) {
          if (err) {
            self.emit("error", err);
            self.readable = false;
            return;
          }
          self.fd = fd;
          self.emit("open", fd);
          self._read();
        });
      }
      function WriteStream(path, options) {
        if (!(this instanceof WriteStream))
          return new WriteStream(path, options);
        Stream.call(this);
        this.path = path;
        this.fd = null;
        this.writable = true;
        this.flags = "w";
        this.encoding = "binary";
        this.mode = 438;
        this.bytesWritten = 0;
        options = options || {};
        var keys = Object.keys(options);
        for (var index = 0, length = keys.length; index < length; index++) {
          var key = keys[index];
          this[key] = options[key];
        }
        if (this.start !== void 0) {
          if ("number" !== typeof this.start) {
            throw TypeError("start must be a Number");
          }
          if (this.start < 0) {
            throw new Error("start must be >= zero");
          }
          this.pos = this.start;
        }
        this.busy = false;
        this._queue = [];
        if (this.fd === null) {
          this._open = fs.open;
          this._queue.push([this._open, this.path, this.flags, this.mode, void 0]);
          this.flush();
        }
      }
    }
  }
});

// node_modules/aws-cdk-lib/node_modules/graceful-fs/clone.js
var require_clone = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/graceful-fs/clone.js"(exports, module2) {
    "use strict";
    module2.exports = clone;
    var getPrototypeOf = Object.getPrototypeOf || function(obj) {
      return obj.__proto__;
    };
    function clone(obj) {
      if (obj === null || typeof obj !== "object")
        return obj;
      if (obj instanceof Object)
        var copy = { __proto__: getPrototypeOf(obj) };
      else
        var copy = /* @__PURE__ */ Object.create(null);
      Object.getOwnPropertyNames(obj).forEach(function(key) {
        Object.defineProperty(copy, key, Object.getOwnPropertyDescriptor(obj, key));
      });
      return copy;
    }
  }
});

// node_modules/aws-cdk-lib/node_modules/graceful-fs/graceful-fs.js
var require_graceful_fs = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/graceful-fs/graceful-fs.js"(exports, module2) {
    var fs = require("fs");
    var polyfills = require_polyfills();
    var legacy = require_legacy_streams();
    var clone = require_clone();
    var util = require("util");
    var gracefulQueue;
    var previousSymbol;
    if (typeof Symbol === "function" && typeof Symbol.for === "function") {
      gracefulQueue = Symbol.for("graceful-fs.queue");
      previousSymbol = Symbol.for("graceful-fs.previous");
    } else {
      gracefulQueue = "___graceful-fs.queue";
      previousSymbol = "___graceful-fs.previous";
    }
    function noop() {
    }
    function publishQueue(context, queue2) {
      Object.defineProperty(context, gracefulQueue, {
        get: function() {
          return queue2;
        }
      });
    }
    var debug = noop;
    if (util.debuglog)
      debug = util.debuglog("gfs4");
    else if (/\bgfs4\b/i.test(process.env.NODE_DEBUG || ""))
      debug = function() {
        var m = util.format.apply(util, arguments);
        m = "GFS4: " + m.split(/\n/).join("\nGFS4: ");
        console.error(m);
      };
    if (!fs[gracefulQueue]) {
      queue = global[gracefulQueue] || [];
      publishQueue(fs, queue);
      fs.close = function(fs$close) {
        function close(fd, cb) {
          return fs$close.call(fs, fd, function(err) {
            if (!err) {
              resetQueue();
            }
            if (typeof cb === "function")
              cb.apply(this, arguments);
          });
        }
        Object.defineProperty(close, previousSymbol, {
          value: fs$close
        });
        return close;
      }(fs.close);
      fs.closeSync = function(fs$closeSync) {
        function closeSync(fd) {
          fs$closeSync.apply(fs, arguments);
          resetQueue();
        }
        Object.defineProperty(closeSync, previousSymbol, {
          value: fs$closeSync
        });
        return closeSync;
      }(fs.closeSync);
      if (/\bgfs4\b/i.test(process.env.NODE_DEBUG || "")) {
        process.on("exit", function() {
          debug(fs[gracefulQueue]);
          require("assert").equal(fs[gracefulQueue].length, 0);
        });
      }
    }
    var queue;
    if (!global[gracefulQueue]) {
      publishQueue(global, fs[gracefulQueue]);
    }
    module2.exports = patch(clone(fs));
    if (process.env.TEST_GRACEFUL_FS_GLOBAL_PATCH && !fs.__patched) {
      module2.exports = patch(fs);
      fs.__patched = true;
    }
    function patch(fs2) {
      polyfills(fs2);
      fs2.gracefulify = patch;
      fs2.createReadStream = createReadStream;
      fs2.createWriteStream = createWriteStream;
      var fs$readFile = fs2.readFile;
      fs2.readFile = readFile;
      function readFile(path, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$readFile(path, options, cb);
        function go$readFile(path2, options2, cb2, startTime) {
          return fs$readFile(path2, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$readFile, [path2, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      var fs$writeFile = fs2.writeFile;
      fs2.writeFile = writeFile;
      function writeFile(path, data, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$writeFile(path, data, options, cb);
        function go$writeFile(path2, data2, options2, cb2, startTime) {
          return fs$writeFile(path2, data2, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$writeFile, [path2, data2, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      var fs$appendFile = fs2.appendFile;
      if (fs$appendFile)
        fs2.appendFile = appendFile;
      function appendFile(path, data, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        return go$appendFile(path, data, options, cb);
        function go$appendFile(path2, data2, options2, cb2, startTime) {
          return fs$appendFile(path2, data2, options2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$appendFile, [path2, data2, options2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      var fs$copyFile = fs2.copyFile;
      if (fs$copyFile)
        fs2.copyFile = copyFile;
      function copyFile(src, dest, flags, cb) {
        if (typeof flags === "function") {
          cb = flags;
          flags = 0;
        }
        return go$copyFile(src, dest, flags, cb);
        function go$copyFile(src2, dest2, flags2, cb2, startTime) {
          return fs$copyFile(src2, dest2, flags2, function(err) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$copyFile, [src2, dest2, flags2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      var fs$readdir = fs2.readdir;
      fs2.readdir = readdir;
      var noReaddirOptionVersions = /^v[0-5]\./;
      function readdir(path, options, cb) {
        if (typeof options === "function")
          cb = options, options = null;
        var go$readdir = noReaddirOptionVersions.test(process.version) ? function go$readdir2(path2, options2, cb2, startTime) {
          return fs$readdir(path2, fs$readdirCallback(
            path2,
            options2,
            cb2,
            startTime
          ));
        } : function go$readdir2(path2, options2, cb2, startTime) {
          return fs$readdir(path2, options2, fs$readdirCallback(
            path2,
            options2,
            cb2,
            startTime
          ));
        };
        return go$readdir(path, options, cb);
        function fs$readdirCallback(path2, options2, cb2, startTime) {
          return function(err, files) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([
                go$readdir,
                [path2, options2, cb2],
                err,
                startTime || Date.now(),
                Date.now()
              ]);
            else {
              if (files && files.sort)
                files.sort();
              if (typeof cb2 === "function")
                cb2.call(this, err, files);
            }
          };
        }
      }
      if (process.version.substr(0, 4) === "v0.8") {
        var legStreams = legacy(fs2);
        ReadStream = legStreams.ReadStream;
        WriteStream = legStreams.WriteStream;
      }
      var fs$ReadStream = fs2.ReadStream;
      if (fs$ReadStream) {
        ReadStream.prototype = Object.create(fs$ReadStream.prototype);
        ReadStream.prototype.open = ReadStream$open;
      }
      var fs$WriteStream = fs2.WriteStream;
      if (fs$WriteStream) {
        WriteStream.prototype = Object.create(fs$WriteStream.prototype);
        WriteStream.prototype.open = WriteStream$open;
      }
      Object.defineProperty(fs2, "ReadStream", {
        get: function() {
          return ReadStream;
        },
        set: function(val) {
          ReadStream = val;
        },
        enumerable: true,
        configurable: true
      });
      Object.defineProperty(fs2, "WriteStream", {
        get: function() {
          return WriteStream;
        },
        set: function(val) {
          WriteStream = val;
        },
        enumerable: true,
        configurable: true
      });
      var FileReadStream = ReadStream;
      Object.defineProperty(fs2, "FileReadStream", {
        get: function() {
          return FileReadStream;
        },
        set: function(val) {
          FileReadStream = val;
        },
        enumerable: true,
        configurable: true
      });
      var FileWriteStream = WriteStream;
      Object.defineProperty(fs2, "FileWriteStream", {
        get: function() {
          return FileWriteStream;
        },
        set: function(val) {
          FileWriteStream = val;
        },
        enumerable: true,
        configurable: true
      });
      function ReadStream(path, options) {
        if (this instanceof ReadStream)
          return fs$ReadStream.apply(this, arguments), this;
        else
          return ReadStream.apply(Object.create(ReadStream.prototype), arguments);
      }
      function ReadStream$open() {
        var that = this;
        open(that.path, that.flags, that.mode, function(err, fd) {
          if (err) {
            if (that.autoClose)
              that.destroy();
            that.emit("error", err);
          } else {
            that.fd = fd;
            that.emit("open", fd);
            that.read();
          }
        });
      }
      function WriteStream(path, options) {
        if (this instanceof WriteStream)
          return fs$WriteStream.apply(this, arguments), this;
        else
          return WriteStream.apply(Object.create(WriteStream.prototype), arguments);
      }
      function WriteStream$open() {
        var that = this;
        open(that.path, that.flags, that.mode, function(err, fd) {
          if (err) {
            that.destroy();
            that.emit("error", err);
          } else {
            that.fd = fd;
            that.emit("open", fd);
          }
        });
      }
      function createReadStream(path, options) {
        return new fs2.ReadStream(path, options);
      }
      function createWriteStream(path, options) {
        return new fs2.WriteStream(path, options);
      }
      var fs$open = fs2.open;
      fs2.open = open;
      function open(path, flags, mode, cb) {
        if (typeof mode === "function")
          cb = mode, mode = null;
        return go$open(path, flags, mode, cb);
        function go$open(path2, flags2, mode2, cb2, startTime) {
          return fs$open(path2, flags2, mode2, function(err, fd) {
            if (err && (err.code === "EMFILE" || err.code === "ENFILE"))
              enqueue([go$open, [path2, flags2, mode2, cb2], err, startTime || Date.now(), Date.now()]);
            else {
              if (typeof cb2 === "function")
                cb2.apply(this, arguments);
            }
          });
        }
      }
      return fs2;
    }
    function enqueue(elem) {
      debug("ENQUEUE", elem[0].name, elem[1]);
      fs[gracefulQueue].push(elem);
      retry();
    }
    var retryTimer;
    function resetQueue() {
      var now = Date.now();
      for (var i = 0; i < fs[gracefulQueue].length; ++i) {
        if (fs[gracefulQueue][i].length > 2) {
          fs[gracefulQueue][i][3] = now;
          fs[gracefulQueue][i][4] = now;
        }
      }
      retry();
    }
    function retry() {
      clearTimeout(retryTimer);
      retryTimer = void 0;
      if (fs[gracefulQueue].length === 0)
        return;
      var elem = fs[gracefulQueue].shift();
      var fn = elem[0];
      var args = elem[1];
      var err = elem[2];
      var startTime = elem[3];
      var lastTime = elem[4];
      if (startTime === void 0) {
        debug("RETRY", fn.name, args);
        fn.apply(null, args);
      } else if (Date.now() - startTime >= 6e4) {
        debug("TIMEOUT", fn.name, args);
        var cb = args.pop();
        if (typeof cb === "function")
          cb.call(null, err);
      } else {
        var sinceAttempt = Date.now() - lastTime;
        var sinceStart = Math.max(lastTime - startTime, 1);
        var desiredDelay = Math.min(sinceStart * 1.2, 100);
        if (sinceAttempt >= desiredDelay) {
          debug("RETRY", fn.name, args);
          fn.apply(null, args.concat([startTime]));
        } else {
          fs[gracefulQueue].push(elem);
        }
      }
      if (retryTimer === void 0) {
        retryTimer = setTimeout(retry, 0);
      }
    }
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/fs/index.js
var require_fs = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/fs/index.js"(exports) {
    "use strict";
    var u = require_universalify().fromCallback;
    var fs = require_graceful_fs();
    var api = [
      "access",
      "appendFile",
      "chmod",
      "chown",
      "close",
      "copyFile",
      "fchmod",
      "fchown",
      "fdatasync",
      "fstat",
      "fsync",
      "ftruncate",
      "futimes",
      "lchmod",
      "lchown",
      "link",
      "lstat",
      "mkdir",
      "mkdtemp",
      "open",
      "opendir",
      "readdir",
      "readFile",
      "readlink",
      "realpath",
      "rename",
      "rm",
      "rmdir",
      "stat",
      "symlink",
      "truncate",
      "unlink",
      "utimes",
      "writeFile"
    ].filter((key) => {
      return typeof fs[key] === "function";
    });
    Object.keys(fs).forEach((key) => {
      if (key === "promises") {
        return;
      }
      exports[key] = fs[key];
    });
    api.forEach((method) => {
      exports[method] = u(fs[method]);
    });
    exports.exists = function(filename, callback) {
      if (typeof callback === "function") {
        return fs.exists(filename, callback);
      }
      return new Promise((resolve) => {
        return fs.exists(filename, resolve);
      });
    };
    exports.read = function(fd, buffer, offset, length, position, callback) {
      if (typeof callback === "function") {
        return fs.read(fd, buffer, offset, length, position, callback);
      }
      return new Promise((resolve, reject) => {
        fs.read(fd, buffer, offset, length, position, (err, bytesRead, buffer2) => {
          if (err)
            return reject(err);
          resolve({ bytesRead, buffer: buffer2 });
        });
      });
    };
    exports.write = function(fd, buffer, ...args) {
      if (typeof args[args.length - 1] === "function") {
        return fs.write(fd, buffer, ...args);
      }
      return new Promise((resolve, reject) => {
        fs.write(fd, buffer, ...args, (err, bytesWritten, buffer2) => {
          if (err)
            return reject(err);
          resolve({ bytesWritten, buffer: buffer2 });
        });
      });
    };
    if (typeof fs.writev === "function") {
      exports.writev = function(fd, buffers, ...args) {
        if (typeof args[args.length - 1] === "function") {
          return fs.writev(fd, buffers, ...args);
        }
        return new Promise((resolve, reject) => {
          fs.writev(fd, buffers, ...args, (err, bytesWritten, buffers2) => {
            if (err)
              return reject(err);
            resolve({ bytesWritten, buffers: buffers2 });
          });
        });
      };
    }
    if (typeof fs.realpath.native === "function") {
      exports.realpath.native = u(fs.realpath.native);
    }
  }
});

// node_modules/aws-cdk-lib/node_modules/at-least-node/index.js
var require_at_least_node = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/at-least-node/index.js"(exports, module2) {
    module2.exports = (r) => {
      const n = process.versions.node.split(".").map((x) => parseInt(x, 10));
      r = r.split(".").map((x) => parseInt(x, 10));
      return n[0] > r[0] || n[0] === r[0] && (n[1] > r[1] || n[1] === r[1] && n[2] >= r[2]);
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/mkdirs/make-dir.js
var require_make_dir = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/mkdirs/make-dir.js"(exports, module2) {
    "use strict";
    var fs = require_fs();
    var path = require("path");
    var atLeastNode = require_at_least_node();
    var useNativeRecursiveOption = atLeastNode("10.12.0");
    var checkPath = (pth) => {
      if (process.platform === "win32") {
        const pathHasInvalidWinCharacters = /[<>:"|?*]/.test(pth.replace(path.parse(pth).root, ""));
        if (pathHasInvalidWinCharacters) {
          const error = new Error(`Path contains invalid characters: ${pth}`);
          error.code = "EINVAL";
          throw error;
        }
      }
    };
    var processOptions = (options) => {
      const defaults = { mode: 511 };
      if (typeof options === "number")
        options = { mode: options };
      return { ...defaults, ...options };
    };
    var permissionError = (pth) => {
      const error = new Error(`operation not permitted, mkdir '${pth}'`);
      error.code = "EPERM";
      error.errno = -4048;
      error.path = pth;
      error.syscall = "mkdir";
      return error;
    };
    module2.exports.makeDir = async (input, options) => {
      checkPath(input);
      options = processOptions(options);
      if (useNativeRecursiveOption) {
        const pth = path.resolve(input);
        return fs.mkdir(pth, {
          mode: options.mode,
          recursive: true
        });
      }
      const make = async (pth) => {
        try {
          await fs.mkdir(pth, options.mode);
        } catch (error) {
          if (error.code === "EPERM") {
            throw error;
          }
          if (error.code === "ENOENT") {
            if (path.dirname(pth) === pth) {
              throw permissionError(pth);
            }
            if (error.message.includes("null bytes")) {
              throw error;
            }
            await make(path.dirname(pth));
            return make(pth);
          }
          try {
            const stats = await fs.stat(pth);
            if (!stats.isDirectory()) {
              throw new Error("The path is not a directory");
            }
          } catch {
            throw error;
          }
        }
      };
      return make(path.resolve(input));
    };
    module2.exports.makeDirSync = (input, options) => {
      checkPath(input);
      options = processOptions(options);
      if (useNativeRecursiveOption) {
        const pth = path.resolve(input);
        return fs.mkdirSync(pth, {
          mode: options.mode,
          recursive: true
        });
      }
      const make = (pth) => {
        try {
          fs.mkdirSync(pth, options.mode);
        } catch (error) {
          if (error.code === "EPERM") {
            throw error;
          }
          if (error.code === "ENOENT") {
            if (path.dirname(pth) === pth) {
              throw permissionError(pth);
            }
            if (error.message.includes("null bytes")) {
              throw error;
            }
            make(path.dirname(pth));
            return make(pth);
          }
          try {
            if (!fs.statSync(pth).isDirectory()) {
              throw new Error("The path is not a directory");
            }
          } catch {
            throw error;
          }
        }
      };
      return make(path.resolve(input));
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/mkdirs/index.js
var require_mkdirs = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/mkdirs/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromPromise;
    var { makeDir: _makeDir, makeDirSync } = require_make_dir();
    var makeDir = u(_makeDir);
    module2.exports = {
      mkdirs: makeDir,
      mkdirsSync: makeDirSync,
      // alias
      mkdirp: makeDir,
      mkdirpSync: makeDirSync,
      ensureDir: makeDir,
      ensureDirSync: makeDirSync
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/util/utimes.js
var require_utimes = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/util/utimes.js"(exports, module2) {
    "use strict";
    var fs = require_graceful_fs();
    function utimesMillis(path, atime, mtime, callback) {
      fs.open(path, "r+", (err, fd) => {
        if (err)
          return callback(err);
        fs.futimes(fd, atime, mtime, (futimesErr) => {
          fs.close(fd, (closeErr) => {
            if (callback)
              callback(futimesErr || closeErr);
          });
        });
      });
    }
    function utimesMillisSync(path, atime, mtime) {
      const fd = fs.openSync(path, "r+");
      fs.futimesSync(fd, atime, mtime);
      return fs.closeSync(fd);
    }
    module2.exports = {
      utimesMillis,
      utimesMillisSync
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/util/stat.js
var require_stat = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/util/stat.js"(exports, module2) {
    "use strict";
    var fs = require_fs();
    var path = require("path");
    var util = require("util");
    var atLeastNode = require_at_least_node();
    var nodeSupportsBigInt = atLeastNode("10.5.0");
    var stat = (file) => nodeSupportsBigInt ? fs.stat(file, { bigint: true }) : fs.stat(file);
    var statSync = (file) => nodeSupportsBigInt ? fs.statSync(file, { bigint: true }) : fs.statSync(file);
    function getStats(src, dest) {
      return Promise.all([
        stat(src),
        stat(dest).catch((err) => {
          if (err.code === "ENOENT")
            return null;
          throw err;
        })
      ]).then(([srcStat, destStat]) => ({ srcStat, destStat }));
    }
    function getStatsSync(src, dest) {
      let destStat;
      const srcStat = statSync(src);
      try {
        destStat = statSync(dest);
      } catch (err) {
        if (err.code === "ENOENT")
          return { srcStat, destStat: null };
        throw err;
      }
      return { srcStat, destStat };
    }
    function checkPaths(src, dest, funcName, cb) {
      util.callbackify(getStats)(src, dest, (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat, destStat } = stats;
        if (destStat && areIdentical(srcStat, destStat)) {
          return cb(new Error("Source and destination must not be the same."));
        }
        if (srcStat.isDirectory() && isSrcSubdir(src, dest)) {
          return cb(new Error(errMsg(src, dest, funcName)));
        }
        return cb(null, { srcStat, destStat });
      });
    }
    function checkPathsSync(src, dest, funcName) {
      const { srcStat, destStat } = getStatsSync(src, dest);
      if (destStat && areIdentical(srcStat, destStat)) {
        throw new Error("Source and destination must not be the same.");
      }
      if (srcStat.isDirectory() && isSrcSubdir(src, dest)) {
        throw new Error(errMsg(src, dest, funcName));
      }
      return { srcStat, destStat };
    }
    function checkParentPaths(src, srcStat, dest, funcName, cb) {
      const srcParent = path.resolve(path.dirname(src));
      const destParent = path.resolve(path.dirname(dest));
      if (destParent === srcParent || destParent === path.parse(destParent).root)
        return cb();
      const callback = (err, destStat) => {
        if (err) {
          if (err.code === "ENOENT")
            return cb();
          return cb(err);
        }
        if (areIdentical(srcStat, destStat)) {
          return cb(new Error(errMsg(src, dest, funcName)));
        }
        return checkParentPaths(src, srcStat, destParent, funcName, cb);
      };
      if (nodeSupportsBigInt)
        fs.stat(destParent, { bigint: true }, callback);
      else
        fs.stat(destParent, callback);
    }
    function checkParentPathsSync(src, srcStat, dest, funcName) {
      const srcParent = path.resolve(path.dirname(src));
      const destParent = path.resolve(path.dirname(dest));
      if (destParent === srcParent || destParent === path.parse(destParent).root)
        return;
      let destStat;
      try {
        destStat = statSync(destParent);
      } catch (err) {
        if (err.code === "ENOENT")
          return;
        throw err;
      }
      if (areIdentical(srcStat, destStat)) {
        throw new Error(errMsg(src, dest, funcName));
      }
      return checkParentPathsSync(src, srcStat, destParent, funcName);
    }
    function areIdentical(srcStat, destStat) {
      if (destStat.ino && destStat.dev && destStat.ino === srcStat.ino && destStat.dev === srcStat.dev) {
        if (nodeSupportsBigInt || destStat.ino < Number.MAX_SAFE_INTEGER) {
          return true;
        }
        if (destStat.size === srcStat.size && destStat.mode === srcStat.mode && destStat.nlink === srcStat.nlink && destStat.atimeMs === srcStat.atimeMs && destStat.mtimeMs === srcStat.mtimeMs && destStat.ctimeMs === srcStat.ctimeMs && destStat.birthtimeMs === srcStat.birthtimeMs) {
          return true;
        }
      }
      return false;
    }
    function isSrcSubdir(src, dest) {
      const srcArr = path.resolve(src).split(path.sep).filter((i) => i);
      const destArr = path.resolve(dest).split(path.sep).filter((i) => i);
      return srcArr.reduce((acc, cur, i) => acc && destArr[i] === cur, true);
    }
    function errMsg(src, dest, funcName) {
      return `Cannot ${funcName} '${src}' to a subdirectory of itself, '${dest}'.`;
    }
    module2.exports = {
      checkPaths,
      checkPathsSync,
      checkParentPaths,
      checkParentPathsSync,
      isSrcSubdir
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/copy-sync/copy-sync.js
var require_copy_sync = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/copy-sync/copy-sync.js"(exports, module2) {
    "use strict";
    var fs = require_graceful_fs();
    var path = require("path");
    var mkdirsSync = require_mkdirs().mkdirsSync;
    var utimesMillisSync = require_utimes().utimesMillisSync;
    var stat = require_stat();
    function copySync(src, dest, opts) {
      if (typeof opts === "function") {
        opts = { filter: opts };
      }
      opts = opts || {};
      opts.clobber = "clobber" in opts ? !!opts.clobber : true;
      opts.overwrite = "overwrite" in opts ? !!opts.overwrite : opts.clobber;
      if (opts.preserveTimestamps && process.arch === "ia32") {
        console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;

    see https://github.com/jprichardson/node-fs-extra/issues/269`);
      }
      const { srcStat, destStat } = stat.checkPathsSync(src, dest, "copy");
      stat.checkParentPathsSync(src, srcStat, dest, "copy");
      return handleFilterAndCopy(destStat, src, dest, opts);
    }
    function handleFilterAndCopy(destStat, src, dest, opts) {
      if (opts.filter && !opts.filter(src, dest))
        return;
      const destParent = path.dirname(dest);
      if (!fs.existsSync(destParent))
        mkdirsSync(destParent);
      return startCopy(destStat, src, dest, opts);
    }
    function startCopy(destStat, src, dest, opts) {
      if (opts.filter && !opts.filter(src, dest))
        return;
      return getStats(destStat, src, dest, opts);
    }
    function getStats(destStat, src, dest, opts) {
      const statSync = opts.dereference ? fs.statSync : fs.lstatSync;
      const srcStat = statSync(src);
      if (srcStat.isDirectory())
        return onDir(srcStat, destStat, src, dest, opts);
      else if (srcStat.isFile() || srcStat.isCharacterDevice() || srcStat.isBlockDevice())
        return onFile(srcStat, destStat, src, dest, opts);
      else if (srcStat.isSymbolicLink())
        return onLink(destStat, src, dest, opts);
    }
    function onFile(srcStat, destStat, src, dest, opts) {
      if (!destStat)
        return copyFile(srcStat, src, dest, opts);
      return mayCopyFile(srcStat, src, dest, opts);
    }
    function mayCopyFile(srcStat, src, dest, opts) {
      if (opts.overwrite) {
        fs.unlinkSync(dest);
        return copyFile(srcStat, src, dest, opts);
      } else if (opts.errorOnExist) {
        throw new Error(`'${dest}' already exists`);
      }
    }
    function copyFile(srcStat, src, dest, opts) {
      fs.copyFileSync(src, dest);
      if (opts.preserveTimestamps)
        handleTimestamps(srcStat.mode, src, dest);
      return setDestMode(dest, srcStat.mode);
    }
    function handleTimestamps(srcMode, src, dest) {
      if (fileIsNotWritable(srcMode))
        makeFileWritable(dest, srcMode);
      return setDestTimestamps(src, dest);
    }
    function fileIsNotWritable(srcMode) {
      return (srcMode & 128) === 0;
    }
    function makeFileWritable(dest, srcMode) {
      return setDestMode(dest, srcMode | 128);
    }
    function setDestMode(dest, srcMode) {
      return fs.chmodSync(dest, srcMode);
    }
    function setDestTimestamps(src, dest) {
      const updatedSrcStat = fs.statSync(src);
      return utimesMillisSync(dest, updatedSrcStat.atime, updatedSrcStat.mtime);
    }
    function onDir(srcStat, destStat, src, dest, opts) {
      if (!destStat)
        return mkDirAndCopy(srcStat.mode, src, dest, opts);
      if (destStat && !destStat.isDirectory()) {
        throw new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`);
      }
      return copyDir(src, dest, opts);
    }
    function mkDirAndCopy(srcMode, src, dest, opts) {
      fs.mkdirSync(dest);
      copyDir(src, dest, opts);
      return setDestMode(dest, srcMode);
    }
    function copyDir(src, dest, opts) {
      fs.readdirSync(src).forEach((item) => copyDirItem(item, src, dest, opts));
    }
    function copyDirItem(item, src, dest, opts) {
      const srcItem = path.join(src, item);
      const destItem = path.join(dest, item);
      const { destStat } = stat.checkPathsSync(srcItem, destItem, "copy");
      return startCopy(destStat, srcItem, destItem, opts);
    }
    function onLink(destStat, src, dest, opts) {
      let resolvedSrc = fs.readlinkSync(src);
      if (opts.dereference) {
        resolvedSrc = path.resolve(process.cwd(), resolvedSrc);
      }
      if (!destStat) {
        return fs.symlinkSync(resolvedSrc, dest);
      } else {
        let resolvedDest;
        try {
          resolvedDest = fs.readlinkSync(dest);
        } catch (err) {
          if (err.code === "EINVAL" || err.code === "UNKNOWN")
            return fs.symlinkSync(resolvedSrc, dest);
          throw err;
        }
        if (opts.dereference) {
          resolvedDest = path.resolve(process.cwd(), resolvedDest);
        }
        if (stat.isSrcSubdir(resolvedSrc, resolvedDest)) {
          throw new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`);
        }
        if (fs.statSync(dest).isDirectory() && stat.isSrcSubdir(resolvedDest, resolvedSrc)) {
          throw new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`);
        }
        return copyLink(resolvedSrc, dest);
      }
    }
    function copyLink(resolvedSrc, dest) {
      fs.unlinkSync(dest);
      return fs.symlinkSync(resolvedSrc, dest);
    }
    module2.exports = copySync;
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/copy-sync/index.js
var require_copy_sync2 = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/copy-sync/index.js"(exports, module2) {
    "use strict";
    module2.exports = {
      copySync: require_copy_sync()
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/path-exists/index.js
var require_path_exists = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/path-exists/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromPromise;
    var fs = require_fs();
    function pathExists(path) {
      return fs.access(path).then(() => true).catch(() => false);
    }
    module2.exports = {
      pathExists: u(pathExists),
      pathExistsSync: fs.existsSync
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/copy/copy.js
var require_copy = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/copy/copy.js"(exports, module2) {
    "use strict";
    var fs = require_graceful_fs();
    var path = require("path");
    var mkdirs = require_mkdirs().mkdirs;
    var pathExists = require_path_exists().pathExists;
    var utimesMillis = require_utimes().utimesMillis;
    var stat = require_stat();
    function copy(src, dest, opts, cb) {
      if (typeof opts === "function" && !cb) {
        cb = opts;
        opts = {};
      } else if (typeof opts === "function") {
        opts = { filter: opts };
      }
      cb = cb || function() {
      };
      opts = opts || {};
      opts.clobber = "clobber" in opts ? !!opts.clobber : true;
      opts.overwrite = "overwrite" in opts ? !!opts.overwrite : opts.clobber;
      if (opts.preserveTimestamps && process.arch === "ia32") {
        console.warn(`fs-extra: Using the preserveTimestamps option in 32-bit node is not recommended;

    see https://github.com/jprichardson/node-fs-extra/issues/269`);
      }
      stat.checkPaths(src, dest, "copy", (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat, destStat } = stats;
        stat.checkParentPaths(src, srcStat, dest, "copy", (err2) => {
          if (err2)
            return cb(err2);
          if (opts.filter)
            return handleFilter(checkParentDir, destStat, src, dest, opts, cb);
          return checkParentDir(destStat, src, dest, opts, cb);
        });
      });
    }
    function checkParentDir(destStat, src, dest, opts, cb) {
      const destParent = path.dirname(dest);
      pathExists(destParent, (err, dirExists) => {
        if (err)
          return cb(err);
        if (dirExists)
          return startCopy(destStat, src, dest, opts, cb);
        mkdirs(destParent, (err2) => {
          if (err2)
            return cb(err2);
          return startCopy(destStat, src, dest, opts, cb);
        });
      });
    }
    function handleFilter(onInclude, destStat, src, dest, opts, cb) {
      Promise.resolve(opts.filter(src, dest)).then((include) => {
        if (include)
          return onInclude(destStat, src, dest, opts, cb);
        return cb();
      }, (error) => cb(error));
    }
    function startCopy(destStat, src, dest, opts, cb) {
      if (opts.filter)
        return handleFilter(getStats, destStat, src, dest, opts, cb);
      return getStats(destStat, src, dest, opts, cb);
    }
    function getStats(destStat, src, dest, opts, cb) {
      const stat2 = opts.dereference ? fs.stat : fs.lstat;
      stat2(src, (err, srcStat) => {
        if (err)
          return cb(err);
        if (srcStat.isDirectory())
          return onDir(srcStat, destStat, src, dest, opts, cb);
        else if (srcStat.isFile() || srcStat.isCharacterDevice() || srcStat.isBlockDevice())
          return onFile(srcStat, destStat, src, dest, opts, cb);
        else if (srcStat.isSymbolicLink())
          return onLink(destStat, src, dest, opts, cb);
      });
    }
    function onFile(srcStat, destStat, src, dest, opts, cb) {
      if (!destStat)
        return copyFile(srcStat, src, dest, opts, cb);
      return mayCopyFile(srcStat, src, dest, opts, cb);
    }
    function mayCopyFile(srcStat, src, dest, opts, cb) {
      if (opts.overwrite) {
        fs.unlink(dest, (err) => {
          if (err)
            return cb(err);
          return copyFile(srcStat, src, dest, opts, cb);
        });
      } else if (opts.errorOnExist) {
        return cb(new Error(`'${dest}' already exists`));
      } else
        return cb();
    }
    function copyFile(srcStat, src, dest, opts, cb) {
      fs.copyFile(src, dest, (err) => {
        if (err)
          return cb(err);
        if (opts.preserveTimestamps)
          return handleTimestampsAndMode(srcStat.mode, src, dest, cb);
        return setDestMode(dest, srcStat.mode, cb);
      });
    }
    function handleTimestampsAndMode(srcMode, src, dest, cb) {
      if (fileIsNotWritable(srcMode)) {
        return makeFileWritable(dest, srcMode, (err) => {
          if (err)
            return cb(err);
          return setDestTimestampsAndMode(srcMode, src, dest, cb);
        });
      }
      return setDestTimestampsAndMode(srcMode, src, dest, cb);
    }
    function fileIsNotWritable(srcMode) {
      return (srcMode & 128) === 0;
    }
    function makeFileWritable(dest, srcMode, cb) {
      return setDestMode(dest, srcMode | 128, cb);
    }
    function setDestTimestampsAndMode(srcMode, src, dest, cb) {
      setDestTimestamps(src, dest, (err) => {
        if (err)
          return cb(err);
        return setDestMode(dest, srcMode, cb);
      });
    }
    function setDestMode(dest, srcMode, cb) {
      return fs.chmod(dest, srcMode, cb);
    }
    function setDestTimestamps(src, dest, cb) {
      fs.stat(src, (err, updatedSrcStat) => {
        if (err)
          return cb(err);
        return utimesMillis(dest, updatedSrcStat.atime, updatedSrcStat.mtime, cb);
      });
    }
    function onDir(srcStat, destStat, src, dest, opts, cb) {
      if (!destStat)
        return mkDirAndCopy(srcStat.mode, src, dest, opts, cb);
      if (destStat && !destStat.isDirectory()) {
        return cb(new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`));
      }
      return copyDir(src, dest, opts, cb);
    }
    function mkDirAndCopy(srcMode, src, dest, opts, cb) {
      fs.mkdir(dest, (err) => {
        if (err)
          return cb(err);
        copyDir(src, dest, opts, (err2) => {
          if (err2)
            return cb(err2);
          return setDestMode(dest, srcMode, cb);
        });
      });
    }
    function copyDir(src, dest, opts, cb) {
      fs.readdir(src, (err, items) => {
        if (err)
          return cb(err);
        return copyDirItems(items, src, dest, opts, cb);
      });
    }
    function copyDirItems(items, src, dest, opts, cb) {
      const item = items.pop();
      if (!item)
        return cb();
      return copyDirItem(items, item, src, dest, opts, cb);
    }
    function copyDirItem(items, item, src, dest, opts, cb) {
      const srcItem = path.join(src, item);
      const destItem = path.join(dest, item);
      stat.checkPaths(srcItem, destItem, "copy", (err, stats) => {
        if (err)
          return cb(err);
        const { destStat } = stats;
        startCopy(destStat, srcItem, destItem, opts, (err2) => {
          if (err2)
            return cb(err2);
          return copyDirItems(items, src, dest, opts, cb);
        });
      });
    }
    function onLink(destStat, src, dest, opts, cb) {
      fs.readlink(src, (err, resolvedSrc) => {
        if (err)
          return cb(err);
        if (opts.dereference) {
          resolvedSrc = path.resolve(process.cwd(), resolvedSrc);
        }
        if (!destStat) {
          return fs.symlink(resolvedSrc, dest, cb);
        } else {
          fs.readlink(dest, (err2, resolvedDest) => {
            if (err2) {
              if (err2.code === "EINVAL" || err2.code === "UNKNOWN")
                return fs.symlink(resolvedSrc, dest, cb);
              return cb(err2);
            }
            if (opts.dereference) {
              resolvedDest = path.resolve(process.cwd(), resolvedDest);
            }
            if (stat.isSrcSubdir(resolvedSrc, resolvedDest)) {
              return cb(new Error(`Cannot copy '${resolvedSrc}' to a subdirectory of itself, '${resolvedDest}'.`));
            }
            if (destStat.isDirectory() && stat.isSrcSubdir(resolvedDest, resolvedSrc)) {
              return cb(new Error(`Cannot overwrite '${resolvedDest}' with '${resolvedSrc}'.`));
            }
            return copyLink(resolvedSrc, dest, cb);
          });
        }
      });
    }
    function copyLink(resolvedSrc, dest, cb) {
      fs.unlink(dest, (err) => {
        if (err)
          return cb(err);
        return fs.symlink(resolvedSrc, dest, cb);
      });
    }
    module2.exports = copy;
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/copy/index.js
var require_copy2 = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/copy/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    module2.exports = {
      copy: u(require_copy())
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/remove/rimraf.js
var require_rimraf = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/remove/rimraf.js"(exports, module2) {
    "use strict";
    var fs = require_graceful_fs();
    var path = require("path");
    var assert = require("assert");
    var isWindows = process.platform === "win32";
    function defaults(options) {
      const methods = [
        "unlink",
        "chmod",
        "stat",
        "lstat",
        "rmdir",
        "readdir"
      ];
      methods.forEach((m) => {
        options[m] = options[m] || fs[m];
        m = m + "Sync";
        options[m] = options[m] || fs[m];
      });
      options.maxBusyTries = options.maxBusyTries || 3;
    }
    function rimraf(p, options, cb) {
      let busyTries = 0;
      if (typeof options === "function") {
        cb = options;
        options = {};
      }
      assert(p, "rimraf: missing path");
      assert.strictEqual(typeof p, "string", "rimraf: path should be a string");
      assert.strictEqual(typeof cb, "function", "rimraf: callback function required");
      assert(options, "rimraf: invalid options argument provided");
      assert.strictEqual(typeof options, "object", "rimraf: options should be object");
      defaults(options);
      rimraf_(p, options, function CB(er) {
        if (er) {
          if ((er.code === "EBUSY" || er.code === "ENOTEMPTY" || er.code === "EPERM") && busyTries < options.maxBusyTries) {
            busyTries++;
            const time = busyTries * 100;
            return setTimeout(() => rimraf_(p, options, CB), time);
          }
          if (er.code === "ENOENT")
            er = null;
        }
        cb(er);
      });
    }
    function rimraf_(p, options, cb) {
      assert(p);
      assert(options);
      assert(typeof cb === "function");
      options.lstat(p, (er, st) => {
        if (er && er.code === "ENOENT") {
          return cb(null);
        }
        if (er && er.code === "EPERM" && isWindows) {
          return fixWinEPERM(p, options, er, cb);
        }
        if (st && st.isDirectory()) {
          return rmdir(p, options, er, cb);
        }
        options.unlink(p, (er2) => {
          if (er2) {
            if (er2.code === "ENOENT") {
              return cb(null);
            }
            if (er2.code === "EPERM") {
              return isWindows ? fixWinEPERM(p, options, er2, cb) : rmdir(p, options, er2, cb);
            }
            if (er2.code === "EISDIR") {
              return rmdir(p, options, er2, cb);
            }
          }
          return cb(er2);
        });
      });
    }
    function fixWinEPERM(p, options, er, cb) {
      assert(p);
      assert(options);
      assert(typeof cb === "function");
      options.chmod(p, 438, (er2) => {
        if (er2) {
          cb(er2.code === "ENOENT" ? null : er);
        } else {
          options.stat(p, (er3, stats) => {
            if (er3) {
              cb(er3.code === "ENOENT" ? null : er);
            } else if (stats.isDirectory()) {
              rmdir(p, options, er, cb);
            } else {
              options.unlink(p, cb);
            }
          });
        }
      });
    }
    function fixWinEPERMSync(p, options, er) {
      let stats;
      assert(p);
      assert(options);
      try {
        options.chmodSync(p, 438);
      } catch (er2) {
        if (er2.code === "ENOENT") {
          return;
        } else {
          throw er;
        }
      }
      try {
        stats = options.statSync(p);
      } catch (er3) {
        if (er3.code === "ENOENT") {
          return;
        } else {
          throw er;
        }
      }
      if (stats.isDirectory()) {
        rmdirSync(p, options, er);
      } else {
        options.unlinkSync(p);
      }
    }
    function rmdir(p, options, originalEr, cb) {
      assert(p);
      assert(options);
      assert(typeof cb === "function");
      options.rmdir(p, (er) => {
        if (er && (er.code === "ENOTEMPTY" || er.code === "EEXIST" || er.code === "EPERM")) {
          rmkids(p, options, cb);
        } else if (er && er.code === "ENOTDIR") {
          cb(originalEr);
        } else {
          cb(er);
        }
      });
    }
    function rmkids(p, options, cb) {
      assert(p);
      assert(options);
      assert(typeof cb === "function");
      options.readdir(p, (er, files) => {
        if (er)
          return cb(er);
        let n = files.length;
        let errState;
        if (n === 0)
          return options.rmdir(p, cb);
        files.forEach((f) => {
          rimraf(path.join(p, f), options, (er2) => {
            if (errState) {
              return;
            }
            if (er2)
              return cb(errState = er2);
            if (--n === 0) {
              options.rmdir(p, cb);
            }
          });
        });
      });
    }
    function rimrafSync(p, options) {
      let st;
      options = options || {};
      defaults(options);
      assert(p, "rimraf: missing path");
      assert.strictEqual(typeof p, "string", "rimraf: path should be a string");
      assert(options, "rimraf: missing options");
      assert.strictEqual(typeof options, "object", "rimraf: options should be object");
      try {
        st = options.lstatSync(p);
      } catch (er) {
        if (er.code === "ENOENT") {
          return;
        }
        if (er.code === "EPERM" && isWindows) {
          fixWinEPERMSync(p, options, er);
        }
      }
      try {
        if (st && st.isDirectory()) {
          rmdirSync(p, options, null);
        } else {
          options.unlinkSync(p);
        }
      } catch (er) {
        if (er.code === "ENOENT") {
          return;
        } else if (er.code === "EPERM") {
          return isWindows ? fixWinEPERMSync(p, options, er) : rmdirSync(p, options, er);
        } else if (er.code !== "EISDIR") {
          throw er;
        }
        rmdirSync(p, options, er);
      }
    }
    function rmdirSync(p, options, originalEr) {
      assert(p);
      assert(options);
      try {
        options.rmdirSync(p);
      } catch (er) {
        if (er.code === "ENOTDIR") {
          throw originalEr;
        } else if (er.code === "ENOTEMPTY" || er.code === "EEXIST" || er.code === "EPERM") {
          rmkidsSync(p, options);
        } else if (er.code !== "ENOENT") {
          throw er;
        }
      }
    }
    function rmkidsSync(p, options) {
      assert(p);
      assert(options);
      options.readdirSync(p).forEach((f) => rimrafSync(path.join(p, f), options));
      if (isWindows) {
        const startTime = Date.now();
        do {
          try {
            const ret = options.rmdirSync(p, options);
            return ret;
          } catch {
          }
        } while (Date.now() - startTime < 500);
      } else {
        const ret = options.rmdirSync(p, options);
        return ret;
      }
    }
    module2.exports = rimraf;
    rimraf.sync = rimrafSync;
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/remove/index.js
var require_remove = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/remove/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    var rimraf = require_rimraf();
    module2.exports = {
      remove: u(rimraf),
      removeSync: rimraf.sync
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/empty/index.js
var require_empty = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/empty/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    var fs = require_graceful_fs();
    var path = require("path");
    var mkdir = require_mkdirs();
    var remove = require_remove();
    var emptyDir = u(function emptyDir2(dir, callback) {
      callback = callback || function() {
      };
      fs.readdir(dir, (err, items) => {
        if (err)
          return mkdir.mkdirs(dir, callback);
        items = items.map((item) => path.join(dir, item));
        deleteItem();
        function deleteItem() {
          const item = items.pop();
          if (!item)
            return callback();
          remove.remove(item, (err2) => {
            if (err2)
              return callback(err2);
            deleteItem();
          });
        }
      });
    });
    function emptyDirSync(dir) {
      let items;
      try {
        items = fs.readdirSync(dir);
      } catch {
        return mkdir.mkdirsSync(dir);
      }
      items.forEach((item) => {
        item = path.join(dir, item);
        remove.removeSync(item);
      });
    }
    module2.exports = {
      emptyDirSync,
      emptydirSync: emptyDirSync,
      emptyDir,
      emptydir: emptyDir
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/ensure/file.js
var require_file = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/ensure/file.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    var path = require("path");
    var fs = require_graceful_fs();
    var mkdir = require_mkdirs();
    function createFile(file, callback) {
      function makeFile() {
        fs.writeFile(file, "", (err) => {
          if (err)
            return callback(err);
          callback();
        });
      }
      fs.stat(file, (err, stats) => {
        if (!err && stats.isFile())
          return callback();
        const dir = path.dirname(file);
        fs.stat(dir, (err2, stats2) => {
          if (err2) {
            if (err2.code === "ENOENT") {
              return mkdir.mkdirs(dir, (err3) => {
                if (err3)
                  return callback(err3);
                makeFile();
              });
            }
            return callback(err2);
          }
          if (stats2.isDirectory())
            makeFile();
          else {
            fs.readdir(dir, (err3) => {
              if (err3)
                return callback(err3);
            });
          }
        });
      });
    }
    function createFileSync(file) {
      let stats;
      try {
        stats = fs.statSync(file);
      } catch {
      }
      if (stats && stats.isFile())
        return;
      const dir = path.dirname(file);
      try {
        if (!fs.statSync(dir).isDirectory()) {
          fs.readdirSync(dir);
        }
      } catch (err) {
        if (err && err.code === "ENOENT")
          mkdir.mkdirsSync(dir);
        else
          throw err;
      }
      fs.writeFileSync(file, "");
    }
    module2.exports = {
      createFile: u(createFile),
      createFileSync
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/ensure/link.js
var require_link = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/ensure/link.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    var path = require("path");
    var fs = require_graceful_fs();
    var mkdir = require_mkdirs();
    var pathExists = require_path_exists().pathExists;
    function createLink(srcpath, dstpath, callback) {
      function makeLink(srcpath2, dstpath2) {
        fs.link(srcpath2, dstpath2, (err) => {
          if (err)
            return callback(err);
          callback(null);
        });
      }
      pathExists(dstpath, (err, destinationExists) => {
        if (err)
          return callback(err);
        if (destinationExists)
          return callback(null);
        fs.lstat(srcpath, (err2) => {
          if (err2) {
            err2.message = err2.message.replace("lstat", "ensureLink");
            return callback(err2);
          }
          const dir = path.dirname(dstpath);
          pathExists(dir, (err3, dirExists) => {
            if (err3)
              return callback(err3);
            if (dirExists)
              return makeLink(srcpath, dstpath);
            mkdir.mkdirs(dir, (err4) => {
              if (err4)
                return callback(err4);
              makeLink(srcpath, dstpath);
            });
          });
        });
      });
    }
    function createLinkSync(srcpath, dstpath) {
      const destinationExists = fs.existsSync(dstpath);
      if (destinationExists)
        return void 0;
      try {
        fs.lstatSync(srcpath);
      } catch (err) {
        err.message = err.message.replace("lstat", "ensureLink");
        throw err;
      }
      const dir = path.dirname(dstpath);
      const dirExists = fs.existsSync(dir);
      if (dirExists)
        return fs.linkSync(srcpath, dstpath);
      mkdir.mkdirsSync(dir);
      return fs.linkSync(srcpath, dstpath);
    }
    module2.exports = {
      createLink: u(createLink),
      createLinkSync
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/ensure/symlink-paths.js
var require_symlink_paths = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/ensure/symlink-paths.js"(exports, module2) {
    "use strict";
    var path = require("path");
    var fs = require_graceful_fs();
    var pathExists = require_path_exists().pathExists;
    function symlinkPaths(srcpath, dstpath, callback) {
      if (path.isAbsolute(srcpath)) {
        return fs.lstat(srcpath, (err) => {
          if (err) {
            err.message = err.message.replace("lstat", "ensureSymlink");
            return callback(err);
          }
          return callback(null, {
            toCwd: srcpath,
            toDst: srcpath
          });
        });
      } else {
        const dstdir = path.dirname(dstpath);
        const relativeToDst = path.join(dstdir, srcpath);
        return pathExists(relativeToDst, (err, exists) => {
          if (err)
            return callback(err);
          if (exists) {
            return callback(null, {
              toCwd: relativeToDst,
              toDst: srcpath
            });
          } else {
            return fs.lstat(srcpath, (err2) => {
              if (err2) {
                err2.message = err2.message.replace("lstat", "ensureSymlink");
                return callback(err2);
              }
              return callback(null, {
                toCwd: srcpath,
                toDst: path.relative(dstdir, srcpath)
              });
            });
          }
        });
      }
    }
    function symlinkPathsSync(srcpath, dstpath) {
      let exists;
      if (path.isAbsolute(srcpath)) {
        exists = fs.existsSync(srcpath);
        if (!exists)
          throw new Error("absolute srcpath does not exist");
        return {
          toCwd: srcpath,
          toDst: srcpath
        };
      } else {
        const dstdir = path.dirname(dstpath);
        const relativeToDst = path.join(dstdir, srcpath);
        exists = fs.existsSync(relativeToDst);
        if (exists) {
          return {
            toCwd: relativeToDst,
            toDst: srcpath
          };
        } else {
          exists = fs.existsSync(srcpath);
          if (!exists)
            throw new Error("relative srcpath does not exist");
          return {
            toCwd: srcpath,
            toDst: path.relative(dstdir, srcpath)
          };
        }
      }
    }
    module2.exports = {
      symlinkPaths,
      symlinkPathsSync
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/ensure/symlink-type.js
var require_symlink_type = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/ensure/symlink-type.js"(exports, module2) {
    "use strict";
    var fs = require_graceful_fs();
    function symlinkType(srcpath, type, callback) {
      callback = typeof type === "function" ? type : callback;
      type = typeof type === "function" ? false : type;
      if (type)
        return callback(null, type);
      fs.lstat(srcpath, (err, stats) => {
        if (err)
          return callback(null, "file");
        type = stats && stats.isDirectory() ? "dir" : "file";
        callback(null, type);
      });
    }
    function symlinkTypeSync(srcpath, type) {
      let stats;
      if (type)
        return type;
      try {
        stats = fs.lstatSync(srcpath);
      } catch {
        return "file";
      }
      return stats && stats.isDirectory() ? "dir" : "file";
    }
    module2.exports = {
      symlinkType,
      symlinkTypeSync
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/ensure/symlink.js
var require_symlink = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/ensure/symlink.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    var path = require("path");
    var fs = require_graceful_fs();
    var _mkdirs = require_mkdirs();
    var mkdirs = _mkdirs.mkdirs;
    var mkdirsSync = _mkdirs.mkdirsSync;
    var _symlinkPaths = require_symlink_paths();
    var symlinkPaths = _symlinkPaths.symlinkPaths;
    var symlinkPathsSync = _symlinkPaths.symlinkPathsSync;
    var _symlinkType = require_symlink_type();
    var symlinkType = _symlinkType.symlinkType;
    var symlinkTypeSync = _symlinkType.symlinkTypeSync;
    var pathExists = require_path_exists().pathExists;
    function createSymlink(srcpath, dstpath, type, callback) {
      callback = typeof type === "function" ? type : callback;
      type = typeof type === "function" ? false : type;
      pathExists(dstpath, (err, destinationExists) => {
        if (err)
          return callback(err);
        if (destinationExists)
          return callback(null);
        symlinkPaths(srcpath, dstpath, (err2, relative) => {
          if (err2)
            return callback(err2);
          srcpath = relative.toDst;
          symlinkType(relative.toCwd, type, (err3, type2) => {
            if (err3)
              return callback(err3);
            const dir = path.dirname(dstpath);
            pathExists(dir, (err4, dirExists) => {
              if (err4)
                return callback(err4);
              if (dirExists)
                return fs.symlink(srcpath, dstpath, type2, callback);
              mkdirs(dir, (err5) => {
                if (err5)
                  return callback(err5);
                fs.symlink(srcpath, dstpath, type2, callback);
              });
            });
          });
        });
      });
    }
    function createSymlinkSync(srcpath, dstpath, type) {
      const destinationExists = fs.existsSync(dstpath);
      if (destinationExists)
        return void 0;
      const relative = symlinkPathsSync(srcpath, dstpath);
      srcpath = relative.toDst;
      type = symlinkTypeSync(relative.toCwd, type);
      const dir = path.dirname(dstpath);
      const exists = fs.existsSync(dir);
      if (exists)
        return fs.symlinkSync(srcpath, dstpath, type);
      mkdirsSync(dir);
      return fs.symlinkSync(srcpath, dstpath, type);
    }
    module2.exports = {
      createSymlink: u(createSymlink),
      createSymlinkSync
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/ensure/index.js
var require_ensure = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/ensure/index.js"(exports, module2) {
    "use strict";
    var file = require_file();
    var link = require_link();
    var symlink = require_symlink();
    module2.exports = {
      // file
      createFile: file.createFile,
      createFileSync: file.createFileSync,
      ensureFile: file.createFile,
      ensureFileSync: file.createFileSync,
      // link
      createLink: link.createLink,
      createLinkSync: link.createLinkSync,
      ensureLink: link.createLink,
      ensureLinkSync: link.createLinkSync,
      // symlink
      createSymlink: symlink.createSymlink,
      createSymlinkSync: symlink.createSymlinkSync,
      ensureSymlink: symlink.createSymlink,
      ensureSymlinkSync: symlink.createSymlinkSync
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/jsonfile/utils.js
var require_utils = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/jsonfile/utils.js"(exports, module2) {
    function stringify(obj, { EOL = "\n", finalEOL = true, replacer = null, spaces } = {}) {
      const EOF = finalEOL ? EOL : "";
      const str = JSON.stringify(obj, replacer, spaces);
      return str.replace(/\n/g, EOL) + EOF;
    }
    function stripBom(content) {
      if (Buffer.isBuffer(content))
        content = content.toString("utf8");
      return content.replace(/^\uFEFF/, "");
    }
    module2.exports = { stringify, stripBom };
  }
});

// node_modules/aws-cdk-lib/node_modules/jsonfile/index.js
var require_jsonfile = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/jsonfile/index.js"(exports, module2) {
    var _fs;
    try {
      _fs = require_graceful_fs();
    } catch (_) {
      _fs = require("fs");
    }
    var universalify = require_universalify();
    var { stringify, stripBom } = require_utils();
    async function _readFile(file, options = {}) {
      if (typeof options === "string") {
        options = { encoding: options };
      }
      const fs = options.fs || _fs;
      const shouldThrow = "throws" in options ? options.throws : true;
      let data = await universalify.fromCallback(fs.readFile)(file, options);
      data = stripBom(data);
      let obj;
      try {
        obj = JSON.parse(data, options ? options.reviver : null);
      } catch (err) {
        if (shouldThrow) {
          err.message = `${file}: ${err.message}`;
          throw err;
        } else {
          return null;
        }
      }
      return obj;
    }
    var readFile = universalify.fromPromise(_readFile);
    function readFileSync(file, options = {}) {
      if (typeof options === "string") {
        options = { encoding: options };
      }
      const fs = options.fs || _fs;
      const shouldThrow = "throws" in options ? options.throws : true;
      try {
        let content = fs.readFileSync(file, options);
        content = stripBom(content);
        return JSON.parse(content, options.reviver);
      } catch (err) {
        if (shouldThrow) {
          err.message = `${file}: ${err.message}`;
          throw err;
        } else {
          return null;
        }
      }
    }
    async function _writeFile(file, obj, options = {}) {
      const fs = options.fs || _fs;
      const str = stringify(obj, options);
      await universalify.fromCallback(fs.writeFile)(file, str, options);
    }
    var writeFile = universalify.fromPromise(_writeFile);
    function writeFileSync(file, obj, options = {}) {
      const fs = options.fs || _fs;
      const str = stringify(obj, options);
      return fs.writeFileSync(file, str, options);
    }
    var jsonfile = {
      readFile,
      readFileSync,
      writeFile,
      writeFileSync
    };
    module2.exports = jsonfile;
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/json/jsonfile.js
var require_jsonfile2 = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/json/jsonfile.js"(exports, module2) {
    "use strict";
    var jsonFile = require_jsonfile();
    module2.exports = {
      // jsonfile exports
      readJson: jsonFile.readFile,
      readJsonSync: jsonFile.readFileSync,
      writeJson: jsonFile.writeFile,
      writeJsonSync: jsonFile.writeFileSync
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/output/index.js
var require_output = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/output/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    var fs = require_graceful_fs();
    var path = require("path");
    var mkdir = require_mkdirs();
    var pathExists = require_path_exists().pathExists;
    function outputFile(file, data, encoding, callback) {
      if (typeof encoding === "function") {
        callback = encoding;
        encoding = "utf8";
      }
      const dir = path.dirname(file);
      pathExists(dir, (err, itDoes) => {
        if (err)
          return callback(err);
        if (itDoes)
          return fs.writeFile(file, data, encoding, callback);
        mkdir.mkdirs(dir, (err2) => {
          if (err2)
            return callback(err2);
          fs.writeFile(file, data, encoding, callback);
        });
      });
    }
    function outputFileSync(file, ...args) {
      const dir = path.dirname(file);
      if (fs.existsSync(dir)) {
        return fs.writeFileSync(file, ...args);
      }
      mkdir.mkdirsSync(dir);
      fs.writeFileSync(file, ...args);
    }
    module2.exports = {
      outputFile: u(outputFile),
      outputFileSync
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/json/output-json.js
var require_output_json = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/json/output-json.js"(exports, module2) {
    "use strict";
    var { stringify } = require_utils();
    var { outputFile } = require_output();
    async function outputJson(file, data, options = {}) {
      const str = stringify(data, options);
      await outputFile(file, str, options);
    }
    module2.exports = outputJson;
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/json/output-json-sync.js
var require_output_json_sync = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/json/output-json-sync.js"(exports, module2) {
    "use strict";
    var { stringify } = require_utils();
    var { outputFileSync } = require_output();
    function outputJsonSync(file, data, options) {
      const str = stringify(data, options);
      outputFileSync(file, str, options);
    }
    module2.exports = outputJsonSync;
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/json/index.js
var require_json = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/json/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromPromise;
    var jsonFile = require_jsonfile2();
    jsonFile.outputJson = u(require_output_json());
    jsonFile.outputJsonSync = require_output_json_sync();
    jsonFile.outputJSON = jsonFile.outputJson;
    jsonFile.outputJSONSync = jsonFile.outputJsonSync;
    jsonFile.writeJSON = jsonFile.writeJson;
    jsonFile.writeJSONSync = jsonFile.writeJsonSync;
    jsonFile.readJSON = jsonFile.readJson;
    jsonFile.readJSONSync = jsonFile.readJsonSync;
    module2.exports = jsonFile;
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/move-sync/move-sync.js
var require_move_sync = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/move-sync/move-sync.js"(exports, module2) {
    "use strict";
    var fs = require_graceful_fs();
    var path = require("path");
    var copySync = require_copy_sync2().copySync;
    var removeSync = require_remove().removeSync;
    var mkdirpSync = require_mkdirs().mkdirpSync;
    var stat = require_stat();
    function moveSync(src, dest, opts) {
      opts = opts || {};
      const overwrite = opts.overwrite || opts.clobber || false;
      const { srcStat } = stat.checkPathsSync(src, dest, "move");
      stat.checkParentPathsSync(src, srcStat, dest, "move");
      mkdirpSync(path.dirname(dest));
      return doRename(src, dest, overwrite);
    }
    function doRename(src, dest, overwrite) {
      if (overwrite) {
        removeSync(dest);
        return rename(src, dest, overwrite);
      }
      if (fs.existsSync(dest))
        throw new Error("dest already exists.");
      return rename(src, dest, overwrite);
    }
    function rename(src, dest, overwrite) {
      try {
        fs.renameSync(src, dest);
      } catch (err) {
        if (err.code !== "EXDEV")
          throw err;
        return moveAcrossDevice(src, dest, overwrite);
      }
    }
    function moveAcrossDevice(src, dest, overwrite) {
      const opts = {
        overwrite,
        errorOnExist: true
      };
      copySync(src, dest, opts);
      return removeSync(src);
    }
    module2.exports = moveSync;
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/move-sync/index.js
var require_move_sync2 = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/move-sync/index.js"(exports, module2) {
    "use strict";
    module2.exports = {
      moveSync: require_move_sync()
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/move/move.js
var require_move = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/move/move.js"(exports, module2) {
    "use strict";
    var fs = require_graceful_fs();
    var path = require("path");
    var copy = require_copy2().copy;
    var remove = require_remove().remove;
    var mkdirp = require_mkdirs().mkdirp;
    var pathExists = require_path_exists().pathExists;
    var stat = require_stat();
    function move(src, dest, opts, cb) {
      if (typeof opts === "function") {
        cb = opts;
        opts = {};
      }
      const overwrite = opts.overwrite || opts.clobber || false;
      stat.checkPaths(src, dest, "move", (err, stats) => {
        if (err)
          return cb(err);
        const { srcStat } = stats;
        stat.checkParentPaths(src, srcStat, dest, "move", (err2) => {
          if (err2)
            return cb(err2);
          mkdirp(path.dirname(dest), (err3) => {
            if (err3)
              return cb(err3);
            return doRename(src, dest, overwrite, cb);
          });
        });
      });
    }
    function doRename(src, dest, overwrite, cb) {
      if (overwrite) {
        return remove(dest, (err) => {
          if (err)
            return cb(err);
          return rename(src, dest, overwrite, cb);
        });
      }
      pathExists(dest, (err, destExists) => {
        if (err)
          return cb(err);
        if (destExists)
          return cb(new Error("dest already exists."));
        return rename(src, dest, overwrite, cb);
      });
    }
    function rename(src, dest, overwrite, cb) {
      fs.rename(src, dest, (err) => {
        if (!err)
          return cb();
        if (err.code !== "EXDEV")
          return cb(err);
        return moveAcrossDevice(src, dest, overwrite, cb);
      });
    }
    function moveAcrossDevice(src, dest, overwrite, cb) {
      const opts = {
        overwrite,
        errorOnExist: true
      };
      copy(src, dest, opts, (err) => {
        if (err)
          return cb(err);
        return remove(src, cb);
      });
    }
    module2.exports = move;
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/move/index.js
var require_move2 = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/move/index.js"(exports, module2) {
    "use strict";
    var u = require_universalify().fromCallback;
    module2.exports = {
      move: u(require_move())
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/fs-extra/lib/index.js
var require_lib5 = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/fs-extra/lib/index.js"(exports, module2) {
    "use strict";
    module2.exports = {
      // Export promiseified graceful-fs:
      ...require_fs(),
      // Export extra methods:
      ...require_copy_sync2(),
      ...require_copy2(),
      ...require_empty(),
      ...require_ensure(),
      ...require_json(),
      ...require_mkdirs(),
      ...require_move_sync2(),
      ...require_move2(),
      ...require_output(),
      ...require_path_exists(),
      ...require_remove()
    };
    var fs = require("fs");
    if (Object.getOwnPropertyDescriptor(fs, "promises")) {
      Object.defineProperty(module2.exports, "promises", {
        get() {
          return fs.promises;
        }
      });
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/stage.js
var require_stage = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/stage.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.Stage = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxapi = require_cx_api();
    var constructs_1 = require_lib4();
    var synthesis_1 = require_synthesis();
    var STAGE_SYMBOL = Symbol.for("@aws-cdk/core.Stage");
    var Stage = class extends constructs_1.Construct {
      constructor(scope, id, props = {}) {
        var _a2, _b, _c, _d, _e;
        super(scope, id);
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_StageProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, Stage), error;
        }
        if (id !== "" && !/^[a-z][a-z0-9\-\_\.]+$/i.test(id))
          throw new Error(`invalid stage name "${id}". Stage name must start with a letter and contain only alphanumeric characters, hypens ('-'), underscores ('_') and periods ('.')`);
        Object.defineProperty(this, STAGE_SYMBOL, { value: true }), this.parentStage = Stage.of(this), this.region = ((_a2 = props.env) == null ? void 0 : _a2.region) ?? ((_b = this.parentStage) == null ? void 0 : _b.region), this.account = ((_c = props.env) == null ? void 0 : _c.account) ?? ((_d = this.parentStage) == null ? void 0 : _d.account), this._assemblyBuilder = this.createBuilder(props.outdir), this.stageName = [(_e = this.parentStage) == null ? void 0 : _e.stageName, props.stageName ?? id].filter((x) => x).join("-");
      }
      static of(construct) {
        return constructs_1.Node.of(construct).scopes.reverse().slice(1).find(Stage.isStage);
      }
      static isStage(x) {
        return x !== null && typeof x == "object" && STAGE_SYMBOL in x;
      }
      get outdir() {
        return this._assemblyBuilder.outdir;
      }
      get assetOutdir() {
        return this._assemblyBuilder.assetOutdir;
      }
      get artifactId() {
        return this.node.path ? `assembly-${this.node.path.replace(/\//g, "-").replace(/^-+|-+$/g, "")}` : "";
      }
      synth(options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_StageSynthesisOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.synth), error;
        }
        return (!this.assembly || options.force) && (this.assembly = synthesis_1.synthesize(this, { skipValidation: options.skipValidation, validateOnSynthesis: options.validateOnSynthesis })), this.assembly;
      }
      createBuilder(outdir) {
        if (this.parentStage && outdir)
          throw new Error('"outdir" cannot be specified for nested stages');
        return this.parentStage ? this.parentStage._assemblyBuilder.createNestedAssembly(this.artifactId, this.node.path) : new cxapi.CloudAssemblyBuilder(outdir);
      }
    };
    exports.Stage = Stage, _a = JSII_RTTI_SYMBOL_1, Stage[_a] = { fqn: "aws-cdk-lib.Stage", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/region-info/lib/default.js
var require_default = __commonJS({
  "node_modules/aws-cdk-lib/region-info/lib/default.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.Default = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var Default = class {
      constructor() {
      }
      static servicePrincipal(serviceFqn, region, urlSuffix) {
        const serviceName = extractSimpleName(serviceFqn);
        if (!serviceName)
          return serviceFqn;
        function determineConfiguration(service) {
          function universal(s) {
            return `${s}.amazonaws.com`;
          }
          function partitional(s, _, u) {
            return `${s}.${u}`;
          }
          function regional(s, r) {
            return `${s}.${r}.amazonaws.com`;
          }
          function regionalPartitional(s, r, u) {
            return `${s}.${r}.${u}`;
          }
          const US_ISO_EXCEPTIONS = /* @__PURE__ */ new Set(["cloudhsm", "config", "states", "workspaces"]);
          if (region.startsWith("us-iso-") && US_ISO_EXCEPTIONS.has(service))
            switch (service) {
              case "states":
                return universal;
              default:
                return partitional;
            }
          const US_ISOB_EXCEPTIONS = /* @__PURE__ */ new Set(["dms", "states"]);
          if (region.startsWith("us-isob-") && US_ISOB_EXCEPTIONS.has(service))
            switch (service) {
              case "states":
                return universal;
              default:
                return partitional;
            }
          switch (service) {
            case "codedeploy":
              return region.startsWith("cn-") ? regionalPartitional : region.startsWith("us-iso") ? universal : regional;
            case "logs":
              return regionalPartitional;
            case "states":
              return regional;
            case "ec2":
              return partitional;
            case "elasticmapreduce":
              return region.startsWith("cn-") ? partitional : universal;
            default:
              return universal;
          }
        }
        return determineConfiguration(serviceName)(serviceName, region, urlSuffix);
      }
    };
    exports.Default = Default, _a = JSII_RTTI_SYMBOL_1, Default[_a] = { fqn: "aws-cdk-lib.region_info.Default", version: "2.50.0" }, Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX = "com.amazonaws.vpce";
    function extractSimpleName(serviceFqn) {
      const matches = serviceFqn.match(/^([^.]+)(?:(?:\.amazonaws\.com(?:\.cn)?)|(?:\.c2s\.ic\.gov)|(?:\.sc2s\.sgov\.gov))?$/);
      return matches ? matches[1] : void 0;
    }
  }
});

// node_modules/aws-cdk-lib/region-info/lib/aws-entities.js
var require_aws_entities = __commonJS({
  "node_modules/aws-cdk-lib/region-info/lib/aws-entities.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.partitionInformation = exports.regionsBefore = exports.before = exports.AWS_SERVICES = exports.AWS_REGIONS = exports.AWS_REGIONS_AND_RULES = exports.RULE_S3_WEBSITE_REGIONAL_SUBDOMAIN = void 0, exports.RULE_S3_WEBSITE_REGIONAL_SUBDOMAIN = Symbol("S3_WEBSITE_REGIONAL_SUBDOMAIN"), exports.AWS_REGIONS_AND_RULES = ["us-east-1", "eu-west-1", "us-west-1", "ap-southeast-1", "ap-northeast-1", "us-gov-west-1", "us-west-2", "sa-east-1", "ap-southeast-2", exports.RULE_S3_WEBSITE_REGIONAL_SUBDOMAIN, "cn-north-1", "us-iso-east-1", "eu-central-1", "ap-northeast-2", "ap-south-1", "us-east-2", "ca-central-1", "eu-west-2", "us-isob-east-1", "cn-northwest-1", "eu-west-3", "ap-northeast-3", "us-gov-east-1", "eu-north-1", "ap-east-1", "me-south-1", "eu-south-1", "af-south-1", "us-iso-west-1", "eu-south-2", "ap-southeast-3"], exports.AWS_REGIONS = exports.AWS_REGIONS_AND_RULES.filter((x) => typeof x == "string").sort(), exports.AWS_SERVICES = ["application-autoscaling", "autoscaling", "codedeploy", "ec2", "events", "lambda", "logs", "s3", "ssm", "sns", "sqs", "states"].sort();
    function before(region, ruleOrRegion) {
      const ruleIx = exports.AWS_REGIONS_AND_RULES.indexOf(ruleOrRegion);
      if (ruleIx === -1)
        throw new Error(`Unknown rule: ${String(ruleOrRegion)}`);
      const regionIx = exports.AWS_REGIONS_AND_RULES.indexOf(region);
      return regionIx === -1 ? false : regionIx < ruleIx;
    }
    exports.before = before;
    function regionsBefore(ruleOrRegion) {
      const ruleIx = exports.AWS_REGIONS_AND_RULES.indexOf(ruleOrRegion);
      if (ruleIx === -1)
        throw new Error(`Unknown rule: ${String(ruleOrRegion)}`);
      return exports.AWS_REGIONS_AND_RULES.slice(0, ruleIx).filter((entry) => typeof entry == "string").sort();
    }
    exports.regionsBefore = regionsBefore;
    var PARTITION_MAP = { default: { partition: "aws", domainSuffix: "amazonaws.com" }, "cn-": { partition: "aws-cn", domainSuffix: "amazonaws.com.cn" }, "us-gov-": { partition: "aws-us-gov", domainSuffix: "amazonaws.com" }, "us-iso-": { partition: "aws-iso", domainSuffix: "c2s.ic.gov" }, "us-isob-": { partition: "aws-iso-b", domainSuffix: "sc2s.sgov.gov" } };
    function partitionInformation(region) {
      for (const [prefix, info] of Object.entries(PARTITION_MAP))
        if (region.startsWith(prefix))
          return info;
      return PARTITION_MAP.default;
    }
    exports.partitionInformation = partitionInformation;
  }
});

// node_modules/aws-cdk-lib/region-info/lib/fact.js
var require_fact = __commonJS({
  "node_modules/aws-cdk-lib/region-info/lib/fact.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.FactName = exports.Fact = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var aws_entities_1 = require_aws_entities();
    var Fact = class {
      constructor() {
        throw new Error("Use the static methods of Fact instead!");
      }
      static get regions() {
        return Array.from(aws_entities_1.AWS_REGIONS);
      }
      static find(region, name) {
        const regionFacts = this.database[region];
        return regionFacts && regionFacts[name];
      }
      static requireFact(region, name) {
        const foundFact = this.find(region, name);
        if (!foundFact)
          throw new Error(`No fact ${name} could be found for region: ${region} and name: ${name}`);
        return foundFact;
      }
      static register(fact, allowReplacing = false) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_region_info_IFact(fact);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.register), error;
        }
        const regionFacts = this.database[fact.region] || (this.database[fact.region] = {});
        if (fact.name in regionFacts && regionFacts[fact.name] !== fact.value && !allowReplacing)
          throw new Error(`Region ${fact.region} already has a fact ${fact.name}, with value ${regionFacts[fact.name]}`);
        fact.value !== void 0 && (regionFacts[fact.name] = fact.value);
      }
      static unregister(region, name, value) {
        const regionFacts = this.database[region] || {};
        if (name in regionFacts && value && regionFacts[name] !== value)
          throw new Error(`Attempted to remove ${name} from ${region} with value ${value}, but the fact's value is ${regionFacts[name]}`);
        delete regionFacts[name];
      }
    };
    exports.Fact = Fact, _a = JSII_RTTI_SYMBOL_1, Fact[_a] = { fqn: "aws-cdk-lib.region_info.Fact", version: "2.50.0" }, Fact.database = {};
    var FactName = class {
      static cloudwatchLambdaInsightsVersion(version, arch) {
        return `cloudwatch-lambda-insights-version:${version.split(".").join("_") + `_${arch ?? "x86_64"}`}`;
      }
      static servicePrincipal(service) {
        return `service-principal:${service.replace(/\.amazonaws\.com(\.cn)?$/, "")}`;
      }
    };
    exports.FactName = FactName, _b = JSII_RTTI_SYMBOL_1, FactName[_b] = { fqn: "aws-cdk-lib.region_info.FactName", version: "2.50.0" }, FactName.PARTITION = "partition", FactName.DOMAIN_SUFFIX = "domainSuffix", FactName.CDK_METADATA_RESOURCE_AVAILABLE = "cdk:metadata-resource:available", FactName.S3_STATIC_WEBSITE_ENDPOINT = "s3-static-website:endpoint", FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID = "s3-static-website:route-53-hosted-zone-id", FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID = "ebs-environment:route-53-hosted-zone-id", FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX = "vpcEndpointServiceNamePrefix", FactName.ELBV2_ACCOUNT = "elbv2Account", FactName.DLC_REPOSITORY_ACCOUNT = "dlcRepositoryAccount", FactName.APPMESH_ECR_ACCOUNT = "appMeshRepositoryAccount", FactName.FIREHOSE_CIDR_BLOCK = "firehoseCidrBlock";
  }
});

// node_modules/aws-cdk-lib/region-info/lib/region-info.js
var require_region_info = __commonJS({
  "node_modules/aws-cdk-lib/region-info/lib/region-info.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.RegionInfo = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var aws_entities_1 = require_aws_entities();
    var fact_1 = require_fact();
    var RegionInfo = class {
      constructor(name) {
        this.name = name;
      }
      static get regions() {
        return fact_1.Fact.regions.map(RegionInfo.get);
      }
      static regionMap(factName) {
        const ret = {};
        for (const regionInfo of RegionInfo.regions) {
          const fact = fact_1.Fact.find(regionInfo.name, factName);
          fact && (ret[regionInfo.name] = fact);
        }
        return ret;
      }
      static limitedRegionMap(factName, partitions) {
        const ret = {};
        for (const [region, value] of Object.entries(RegionInfo.regionMap(factName)))
          partitions.includes(aws_entities_1.partitionInformation(region).partition) && (ret[region] = value);
        return ret;
      }
      static get(name) {
        return new RegionInfo(name);
      }
      get cdkMetadataResourceAvailable() {
        return fact_1.Fact.find(this.name, fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE) === "YES";
      }
      get domainSuffix() {
        return fact_1.Fact.find(this.name, fact_1.FactName.DOMAIN_SUFFIX);
      }
      get partition() {
        return fact_1.Fact.find(this.name, fact_1.FactName.PARTITION);
      }
      get s3StaticWebsiteEndpoint() {
        return fact_1.Fact.find(this.name, fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT);
      }
      get s3StaticWebsiteHostedZoneId() {
        return fact_1.Fact.find(this.name, fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID);
      }
      get ebsEnvEndpointHostedZoneId() {
        return fact_1.Fact.find(this.name, fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID);
      }
      get vpcEndpointServiceNamePrefix() {
        return fact_1.Fact.find(this.name, fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX);
      }
      servicePrincipal(service) {
        return fact_1.Fact.find(this.name, fact_1.FactName.servicePrincipal(service));
      }
      get elbv2Account() {
        return fact_1.Fact.find(this.name, fact_1.FactName.ELBV2_ACCOUNT);
      }
      get dlcRepositoryAccount() {
        return fact_1.Fact.find(this.name, fact_1.FactName.DLC_REPOSITORY_ACCOUNT);
      }
      cloudwatchLambdaInsightsArn(insightsVersion, architecture) {
        return fact_1.Fact.find(this.name, fact_1.FactName.cloudwatchLambdaInsightsVersion(insightsVersion, architecture));
      }
      get appMeshRepositoryAccount() {
        return fact_1.Fact.find(this.name, fact_1.FactName.APPMESH_ECR_ACCOUNT);
      }
      get firehoseCidrBlock() {
        return fact_1.Fact.find(this.name, fact_1.FactName.FIREHOSE_CIDR_BLOCK);
      }
    };
    exports.RegionInfo = RegionInfo, _a = JSII_RTTI_SYMBOL_1, RegionInfo[_a] = { fqn: "aws-cdk-lib.region_info.RegionInfo", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/region-info/lib/built-ins.generated.js
var require_built_ins_generated = __commonJS({
  "node_modules/aws-cdk-lib/region-info/lib/built-ins.generated.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.BuiltIns = void 0;
    var fact_1 = require_fact();
    var BuiltIns = class {
      static register() {
        fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.af-south-1.amazonaws.com" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z11KHD8FBVPUYU" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z1EI3BVKMKK4AM" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "098369216593" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "924023996002" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.244.121.224/27" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.af-south-1.amazonaws.com" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.af-south-1.amazonaws.com" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.af-south-1.amazonaws.com" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension:13" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension:9" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension:8" }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "af-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.ap-east-1.amazonaws.com" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "ZNB98KWMFR0R6" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "ZPWYUBWRU171A" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "754344448648" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "871362719292" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "856666278305" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "18.162.221.32/27" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ap-east-1.amazonaws.com" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ap-east-1.amazonaws.com" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.ap-east-1.amazonaws.com" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension:13" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension:9" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension:8" }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "ap-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-ap-northeast-1.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z2M4EHUR26P7ZW" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z1R25G3KIG2GBW" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "582318560864" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.113.196.224/27" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ap-northeast-1.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ap-northeast-1.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.ap-northeast-1.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:31" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: "arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension-Arm64:2" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:25" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: "arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension-Arm64:1" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:23" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: "arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:12" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: "arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "ap-northeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: "arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:2" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.ap-northeast-2.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z3W03O7B5YMIYP" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z3JE5OI70TWKCP" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.ELBV2_ACCOUNT, value: "600734575887" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.209.1.64/27" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ap-northeast-2.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ap-northeast-2.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.servicePrincipal("states"), value: "states.ap-northeast-2.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:20" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:18" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:16" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: "arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:12" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: "arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "ap-northeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: "arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:2" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "NO" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.ap-northeast-3.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z2YQB5RD63NC85" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "ZNE5GEY1TIAGY" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.ELBV2_ACCOUNT, value: "383597477331" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.208.177.192/27" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ap-northeast-3.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ap-northeast-3.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.servicePrincipal("states"), value: "states.ap-northeast-3.amazonaws.com" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:ap-northeast-3:194566237122:layer:LambdaInsightsExtension:2" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:ap-northeast-3:194566237122:layer:LambdaInsightsExtension:1" }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "ap-northeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.ap-south-1.amazonaws.com" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z11RGJOFQNVJUP" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z18NTBI3Y7N9TZ" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "718504428378" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.232.67.32/27" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ap-south-1.amazonaws.com" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ap-south-1.amazonaws.com" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.ap-south-1.amazonaws.com" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:21" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: "arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension-Arm64:2" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:18" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: "arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension-Arm64:1" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:16" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: "arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:12" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: "arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "ap-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: "arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:2" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-ap-southeast-1.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z3O0J2DXBE1FTB" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z16FZ9L249IFLT" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "114774131450" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.228.64.192/27" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ap-southeast-1.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ap-southeast-1.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.ap-southeast-1.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:21" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: "arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension-Arm64:2" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:18" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: "arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension-Arm64:1" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:16" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: "arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:12" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: "arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "ap-southeast-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: "arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:2" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-ap-southeast-2.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z1WCIGYICN2BYD" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z2PCDNR3VC2G1N" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.ELBV2_ACCOUNT, value: "783225319266" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.210.67.224/27" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ap-southeast-2.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ap-southeast-2.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.servicePrincipal("states"), value: "states.ap-southeast-2.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:21" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: "arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension-Arm64:2" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:18" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: "arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension-Arm64:1" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:16" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: "arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:12" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: "arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "ap-southeast-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: "arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:2" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "NO" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.ap-southeast-3.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z01613992JD795ZI93075" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.ELBV2_ACCOUNT, value: "589379963580" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "909464085924" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "108.136.221.64/27" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ap-southeast-3.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ap-southeast-3.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.servicePrincipal("states"), value: "states.ap-southeast-3.amazonaws.com" }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "ap-southeast-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.ca-central-1.amazonaws.com" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z1QDHH18159H29" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "ZJFCZL7SSZB5I" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "985666609251" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "35.183.92.128/27" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.ca-central-1.amazonaws.com" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.ca-central-1.amazonaws.com" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.ca-central-1.amazonaws.com" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:20" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:18" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:16" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: "arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:12" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: "arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "ca-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: "arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:2" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.PARTITION, value: "aws-cn" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com.cn" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.cn-north-1.amazonaws.com.cn" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "638102146993" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "727897471807" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "919366029133" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "52.81.151.32/27" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "cn.com.amazonaws.vpce" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.cn-north-1.amazonaws.com.cn" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com.cn" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.cn-north-1.amazonaws.com.cn" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.cn-north-1.amazonaws.com" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws-cn:lambda:cn-north-1:488211338238:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws-cn:lambda:cn-north-1:488211338238:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws-cn:lambda:cn-north-1:488211338238:layer:LambdaInsightsExtension:9" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws-cn:lambda:cn-north-1:488211338238:layer:LambdaInsightsExtension:8" }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "cn-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.PARTITION, value: "aws-cn" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com.cn" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.cn-northwest-1.amazonaws.com.cn" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z282HJ1KT0DH03" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "037604701340" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "727897471807" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "919830735681" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "161.189.23.64/27" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "cn.com.amazonaws.vpce" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.cn-northwest-1.amazonaws.com.cn" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com.cn" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.cn-northwest-1.amazonaws.com.cn" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.cn-northwest-1.amazonaws.com" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws-cn:lambda:cn-northwest-1:488211338238:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws-cn:lambda:cn-northwest-1:488211338238:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws-cn:lambda:cn-northwest-1:488211338238:layer:LambdaInsightsExtension:9" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws-cn:lambda:cn-northwest-1:488211338238:layer:LambdaInsightsExtension:8" }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "cn-northwest-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.eu-central-1.amazonaws.com" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z21DNDUVLTQW6Q" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z1FRNW7UH4DEZJ" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "054676820928" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "35.158.127.160/27" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.eu-central-1.amazonaws.com" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.eu-central-1.amazonaws.com" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.eu-central-1.amazonaws.com" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:21" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: "arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension-Arm64:2" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:18" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: "arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension-Arm64:1" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:16" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: "arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:12" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: "arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "eu-central-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: "arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:2" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.eu-north-1.amazonaws.com" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z3BAZG2TWCNX0D" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z23GO28BZ5AETM" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "897822967062" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.53.63.224/27" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.eu-north-1.amazonaws.com" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.eu-north-1.amazonaws.com" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.eu-north-1.amazonaws.com" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:20" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:18" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:16" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: "arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:12" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: "arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "eu-north-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: "arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:2" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.eu-south-1.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z3IXVV8C73GIO3" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z10VDYYOA2JFKM" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "635631232127" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "422531588944" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "15.161.135.128/27" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.eu-south-1.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.eu-south-1.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.eu-south-1.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension:13" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension:9" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension:8" }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "eu-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "NO" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.eu-south-2.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.ELBV2_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.eu-south-2.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.eu-south-2.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.servicePrincipal("states"), value: "states.eu-south-2.amazonaws.com" }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "eu-south-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-eu-west-1.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z1BKCTXD74EZPE" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z2NYPWQ7DFZAZH" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "156460612806" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "52.19.239.192/27" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.eu-west-1.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.eu-west-1.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.eu-west-1.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:21" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: "arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension-Arm64:2" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:18" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: "arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension-Arm64:1" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:16" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: "arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:12" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: "arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "eu-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: "arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:2" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.eu-west-2.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z3GKZC51ZF0DB4" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z1GKAAAUGATPF1" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.ELBV2_ACCOUNT, value: "652711504416" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "18.130.1.96/27" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.eu-west-2.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.eu-west-2.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.servicePrincipal("states"), value: "states.eu-west-2.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:21" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: "arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension-Arm64:2" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:18" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: "arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension-Arm64:1" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:16" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: "arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:12" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: "arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "eu-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: "arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:2" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.eu-west-3.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z3R1K369G5AVDG" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z5WN6GAYWG5OB" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.ELBV2_ACCOUNT, value: "009996457667" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "35.180.1.96/27" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.eu-west-3.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.eu-west-3.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.servicePrincipal("states"), value: "states.eu-west-3.amazonaws.com" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:20" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:18" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:16" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: "arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:12" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: "arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "eu-west-3", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: "arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:2" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.me-south-1.amazonaws.com" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z1MPMWCPA7YB62" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z2BBTEKR2I36N2" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "076674570225" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "217643126080" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "772975370895" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "15.185.91.0/27" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.me-south-1.amazonaws.com" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.me-south-1.amazonaws.com" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.me-south-1.amazonaws.com" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension:13" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension:9" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension:8" }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "me-south-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-sa-east-1.amazonaws.com" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z7KQH4QJS55SO" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z10X7K2B4QSOFV" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "507241528517" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "18.228.1.128/27" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.sa-east-1.amazonaws.com" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.sa-east-1.amazonaws.com" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.sa-east-1.amazonaws.com" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:20" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:18" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:16" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: "arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:12" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: "arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "sa-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: "arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:2" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-us-east-1.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z3AQBSTGFYJSTF" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z117KPS5GTRQ2G" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "127311923021" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "52.70.63.192/27" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.us-east-1.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-east-1.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.us-east-1.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:21" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: "arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension-Arm64:2" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:18" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: "arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension-Arm64:1" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:16" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: "arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:12" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: "arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "us-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: "arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:2" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.us-east-2.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z2O1EMRO9K5GLX" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z14LCN19Q5QHIC" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.ELBV2_ACCOUNT, value: "033677994240" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.58.135.96/27" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.us-east-2.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-east-2.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.servicePrincipal("states"), value: "states.us-east-2.amazonaws.com" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:21" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: "arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension-Arm64:2" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:18" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: "arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension-Arm64:1" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:16" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: "arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:12" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: "arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "us-east-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: "arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:2" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.PARTITION, value: "aws-us-gov" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "NO" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.us-gov-east-1.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z2NIFVYYW2VKV1" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z35TSARG0EJ4VU" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "190560391635" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "18.253.138.96/27" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.us-gov-east-1.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-gov-east-1.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.us-gov-east-1.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.PARTITION, value: "aws-us-gov" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "NO" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-us-gov-west-1.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z31GFT0UA1I2HV" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z4KAURWC4UUUG" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "048591011584" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "52.61.204.160/27" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.us-gov-west-1.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-gov-west-1.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.us-gov-west-1.amazonaws.com" }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-gov-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.PARTITION, value: "aws-iso" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "c2s.ic.gov" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "NO" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.us-iso-east-1.c2s.ic.gov" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "770363063475" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "gov.ic.c2s.vpce" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.c2s.ic.gov" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-iso-east-1.c2s.ic.gov" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.PARTITION, value: "aws-iso" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "c2s.ic.gov" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "NO" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.us-iso-west-1.c2s.ic.gov" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "121062877647" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "gov.ic.c2s.vpce" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.c2s.ic.gov" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-iso-west-1.c2s.ic.gov" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.amazonaws.com" }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-iso-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.PARTITION, value: "aws-iso-b" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "sc2s.sgov.gov" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "NO" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website.us-isob-east-1.sc2s.sgov.gov" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "740734521339" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: void 0 }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "gov.sgov.sc2s.vpce" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.amazonaws.com" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.sc2s.sgov.gov" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-isob-east-1.sc2s.sgov.gov" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.amazonaws.com" }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-isob-east-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: void 0 }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-us-west-1.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z2F56UZL2M1ACD" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z1LQECGX5PH1X" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.ELBV2_ACCOUNT, value: "027434742980" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "13.57.135.192/27" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.us-west-1.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-west-1.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.servicePrincipal("states"), value: "states.us-west-1.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:20" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:18" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: void 0 }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:16" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: "arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:12" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: "arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "us-west-1", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: "arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:2" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.PARTITION, value: "aws" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.DOMAIN_SUFFIX, value: "amazonaws.com" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.CDK_METADATA_RESOURCE_AVAILABLE, value: "YES" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ENDPOINT, value: "s3-website-us-west-2.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.S3_STATIC_WEBSITE_ZONE_53_HOSTED_ZONE_ID, value: "Z3BJ6K6RIION7M" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.EBS_ENV_ENDPOINT_HOSTED_ZONE_ID, value: "Z38NKT9BP95V3O" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.ELBV2_ACCOUNT, value: "797873946194" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.DLC_REPOSITORY_ACCOUNT, value: "763104351884" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.APPMESH_ECR_ACCOUNT, value: "840364872350" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.FIREHOSE_CIDR_BLOCK, value: "52.89.255.224/27" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.VPC_ENDPOINT_SERVICE_NAME_PREFIX, value: "com.amazonaws.vpce" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("application-autoscaling"), value: "application-autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("autoscaling"), value: "autoscaling.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("codedeploy"), value: "codedeploy.us-west-2.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("ec2"), value: "ec2.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("events"), value: "events.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("lambda"), value: "lambda.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("logs"), value: "logs.us-west-2.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("s3"), value: "s3.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("sns"), value: "sns.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("sqs"), value: "sqs.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("ssm"), value: "ssm.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.servicePrincipal("states"), value: "states.us-west-2.amazonaws.com" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.143.0", "x86_64"), value: "arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:21" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "arm64"), value: "arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension-Arm64:2" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.135.0", "x86_64"), value: "arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:18" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "arm64"), value: "arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension-Arm64:1" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.119.0", "x86_64"), value: "arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:16" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.98.0", "x86_64"), value: "arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:14" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.89.0", "x86_64"), value: "arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:12" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.86.0", "x86_64"), value: "arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:11" }), fact_1.Fact.register({ region: "us-west-2", name: fact_1.FactName.cloudwatchLambdaInsightsVersion("1.0.54.0", "x86_64"), value: "arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:2" });
      }
      constructor() {
      }
    };
    exports.BuiltIns = BuiltIns;
  }
});

// node_modules/aws-cdk-lib/region-info/lib/index.js
var require_lib6 = __commonJS({
  "node_modules/aws-cdk-lib/region-info/lib/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        p !== "default" && !exports2.hasOwnProperty(p) && __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true }), __exportStar(require_default(), exports), __exportStar(require_fact(), exports), __exportStar(require_region_info(), exports);
    var built_ins_generated_1 = require_built_ins_generated();
    built_ins_generated_1.BuiltIns.register();
  }
});

// node_modules/aws-cdk-lib/region-info/index.js
var require_region_info2 = __commonJS({
  "node_modules/aws-cdk-lib/region-info/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        p !== "default" && !exports2.hasOwnProperty(p) && __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true }), __exportStar(require_lib6(), exports);
  }
});

// node_modules/aws-cdk-lib/core/lib/cfn-condition.js
var require_cfn_condition = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cfn-condition.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CfnCondition = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_element_1 = require_cfn_element();
    var CfnCondition = class extends cfn_element_1.CfnElement {
      constructor(scope, id, props) {
        super(scope, id);
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnConditionProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnCondition), error;
        }
        this.expression = props && props.expression;
      }
      _toCloudFormation() {
        return this.expression ? { Conditions: { [this.logicalId]: this.expression } } : {};
      }
      resolve(_context) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IResolveContext(_context);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.resolve), error;
        }
        return { Condition: this.logicalId };
      }
    };
    exports.CfnCondition = CfnCondition, _a = JSII_RTTI_SYMBOL_1, CfnCondition[_a] = { fqn: "aws-cdk-lib.CfnCondition", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/removal-policy.js
var require_removal_policy = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/removal-policy.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.RemovalPolicy = void 0;
    var RemovalPolicy;
    (function(RemovalPolicy2) {
      RemovalPolicy2.DESTROY = "destroy", RemovalPolicy2.RETAIN = "retain", RemovalPolicy2.SNAPSHOT = "snapshot";
    })(RemovalPolicy = exports.RemovalPolicy || (exports.RemovalPolicy = {}));
  }
});

// node_modules/aws-cdk-lib/core/lib/util.js
var require_util = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/util.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.undefinedIfAllValuesAreEmpty = exports.findLastCommonElement = exports.pathToTopLevelStack = exports.PostResolveToken = exports.filterUndefined = exports.ignoreEmpty = exports.capitalizePropertyNames = void 0;
    var intrinsic_1 = require_intrinsic();
    var stack_1 = require_stack();
    function capitalizePropertyNames(construct, obj) {
      if (obj = stack_1.Stack.of(construct).resolve(obj), typeof obj != "object")
        return obj;
      if (Array.isArray(obj))
        return obj.map((x) => capitalizePropertyNames(construct, x));
      const newObj = {};
      for (const key of Object.keys(obj)) {
        const value = obj[key], newKey = key.charAt(0).toUpperCase() + key.slice(1);
        newObj[newKey] = capitalizePropertyNames(construct, value);
      }
      return newObj;
    }
    exports.capitalizePropertyNames = capitalizePropertyNames;
    function ignoreEmpty(obj) {
      return new PostResolveToken(obj, (o) => {
        if (o == null)
          return o;
        if (!(Array.isArray(o) && o.length === 0) && !(typeof o == "object" && Object.keys(o).length === 0))
          return o;
      });
    }
    exports.ignoreEmpty = ignoreEmpty;
    function filterUndefined(obj) {
      if (Array.isArray(obj))
        return obj.filter((x) => x != null).map((x) => filterUndefined(x));
      if (typeof obj == "object") {
        const ret = {};
        for (const [key, value] of Object.entries(obj))
          value != null && (ret[key] = filterUndefined(value));
        return ret;
      }
      return obj;
    }
    exports.filterUndefined = filterUndefined;
    var PostResolveToken = class extends intrinsic_1.Intrinsic {
      constructor(value, processor) {
        super(value, { stackTrace: false }), this.processor = processor;
      }
      resolve(context) {
        return context.registerPostProcessor(this), super.resolve(context);
      }
      postProcess(o, _context) {
        return this.processor(o);
      }
    };
    exports.PostResolveToken = PostResolveToken;
    function pathToTopLevelStack(s) {
      return s.nestedStackParent ? [...pathToTopLevelStack(s.nestedStackParent), s] : [s];
    }
    exports.pathToTopLevelStack = pathToTopLevelStack;
    function findLastCommonElement(path1, path2) {
      let i = 0;
      for (; i < path1.length && i < path2.length && path1[i] === path2[i]; )
        i++;
      return path1[i - 1];
    }
    exports.findLastCommonElement = findLastCommonElement;
    function undefinedIfAllValuesAreEmpty(object) {
      return Object.values(object).some((v) => v !== void 0) ? object : void 0;
    }
    exports.undefinedIfAllValuesAreEmpty = undefinedIfAllValuesAreEmpty;
  }
});

// node_modules/aws-cdk-lib/core/lib/arn.js
var require_arn = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/arn.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.Arn = exports.ArnFormat = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_fn_1 = require_cfn_fn();
    var token_1 = require_token();
    var util_1 = require_util();
    var ArnFormat;
    (function(ArnFormat2) {
      ArnFormat2.NO_RESOURCE_NAME = "arn:aws:service:region:account:resource", ArnFormat2.COLON_RESOURCE_NAME = "arn:aws:service:region:account:resource:resourceName", ArnFormat2.SLASH_RESOURCE_NAME = "arn:aws:service:region:account:resource/resourceName", ArnFormat2.SLASH_RESOURCE_SLASH_RESOURCE_NAME = "arn:aws:service:region:account:/resource/resourceName";
    })(ArnFormat = exports.ArnFormat || (exports.ArnFormat = {}));
    var Arn2 = class {
      constructor() {
      }
      static format(components, stack) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ArnComponents(components), jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.format), error;
        }
        const partition = components.partition ?? (stack == null ? void 0 : stack.partition), region = components.region ?? (stack == null ? void 0 : stack.region), account = components.account ?? (stack == null ? void 0 : stack.account);
        if (partition == null || region == null || account == null)
          throw new Error(`Arn.format: partition (${partition}), region (${region}), and account (${account}) must all be passed if stack is not passed.`);
        const sep = components.sep ?? (components.arnFormat === ArnFormat.COLON_RESOURCE_NAME ? ":" : "/"), values = ["arn", ":", partition, ":", components.service, ":", region, ":", account, ":", ...components.arnFormat === ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME ? ["/"] : [], components.resource];
        if (sep !== "/" && sep !== ":" && sep !== "")
          throw new Error('resourcePathSep may only be ":", "/" or an empty string');
        return components.resourceName != null && (values.push(sep), values.push(components.resourceName)), values.join("");
      }
      static parse(arn, sepIfToken = "/", hasName = true) {
        let arnFormat;
        return hasName ? arnFormat = sepIfToken === "/" ? ArnFormat.SLASH_RESOURCE_NAME : ArnFormat.COLON_RESOURCE_NAME : arnFormat = ArnFormat.NO_RESOURCE_NAME, this.split(arn, arnFormat);
      }
      static split(arn, arnFormat) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ArnFormat(arnFormat);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.split), error;
        }
        const components = parseArnShape(arn);
        if (components === "token")
          return parseTokenArn(arn, arnFormat);
        const [, partition, service, region, account, resourceTypeOrName, ...rest] = components;
        let resource, resourceName, sep, resourcePartStartIndex = 0, detectedArnFormat, slashIndex = resourceTypeOrName.indexOf("/");
        return slashIndex === 0 && (slashIndex = resourceTypeOrName.indexOf("/", 1), resourcePartStartIndex = 1, detectedArnFormat = ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME), slashIndex !== -1 ? arnFormat === ArnFormat.NO_RESOURCE_NAME ? (sep = void 0, slashIndex = -1, detectedArnFormat = ArnFormat.NO_RESOURCE_NAME) : (sep = "/", detectedArnFormat = resourcePartStartIndex === 0 ? ArnFormat.SLASH_RESOURCE_NAME : ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME) : rest.length > 0 ? (sep = ":", slashIndex = -1, detectedArnFormat = ArnFormat.COLON_RESOURCE_NAME) : (sep = void 0, detectedArnFormat = ArnFormat.NO_RESOURCE_NAME), slashIndex !== -1 ? (resource = resourceTypeOrName.substring(resourcePartStartIndex, slashIndex), resourceName = resourceTypeOrName.substring(slashIndex + 1)) : resource = resourceTypeOrName, rest.length > 0 && (resourceName ? resourceName += ":" : resourceName = "", resourceName += rest.join(":")), util_1.filterUndefined({ service: service || void 0, resource: resource || void 0, partition: partition || void 0, region, account, resourceName, sep, arnFormat: detectedArnFormat });
      }
      static extractResourceName(arn, resourceType) {
        if (parseArnShape(arn) === "token")
          return cfn_fn_1.Fn.select(1, cfn_fn_1.Fn.split(`:${resourceType}/`, arn));
        const parsed = Arn2.split(arn, ArnFormat.SLASH_RESOURCE_NAME);
        if (!token_1.Token.isUnresolved(parsed.resource) && parsed.resource !== resourceType)
          throw new Error(`Expected resource type '${resourceType}' in ARN, got '${parsed.resource}' in '${arn}'`);
        if (!parsed.resourceName)
          throw new Error(`Expected resource name in ARN, didn't find one: '${arn}'`);
        return parsed.resourceName;
      }
    };
    exports.Arn = Arn2, _a = JSII_RTTI_SYMBOL_1, Arn2[_a] = { fqn: "aws-cdk-lib.Arn", version: "2.50.0" };
    function parseTokenArn(arnToken, arnFormat) {
      const components = cfn_fn_1.Fn.split(":", arnToken), partition = cfn_fn_1.Fn.select(1, components).toString(), service = cfn_fn_1.Fn.select(2, components).toString(), region = cfn_fn_1.Fn.select(3, components).toString(), account = cfn_fn_1.Fn.select(4, components).toString();
      let resource, resourceName, sep;
      if (arnFormat === ArnFormat.NO_RESOURCE_NAME || arnFormat === ArnFormat.COLON_RESOURCE_NAME)
        resource = cfn_fn_1.Fn.select(5, components), arnFormat === ArnFormat.COLON_RESOURCE_NAME ? (resourceName = cfn_fn_1.Fn.select(6, components), sep = ":") : (resourceName = void 0, sep = void 0);
      else {
        const lastComponents = cfn_fn_1.Fn.split("/", cfn_fn_1.Fn.select(5, components));
        arnFormat === ArnFormat.SLASH_RESOURCE_NAME ? (resource = cfn_fn_1.Fn.select(0, lastComponents), resourceName = cfn_fn_1.Fn.select(1, lastComponents)) : (resource = cfn_fn_1.Fn.select(1, lastComponents), resourceName = cfn_fn_1.Fn.select(2, lastComponents)), sep = "/";
      }
      return { partition, service, region, account, resource, resourceName, sep, arnFormat };
    }
    function parseArnShape(arn) {
      if (!arn.startsWith("arn:")) {
        if (token_1.Token.isUnresolved(arn))
          return "token";
        throw new Error(`ARNs must start with "arn:" and have at least 6 components: ${arn}`);
      }
      const components = arn.split(":");
      if (!(components.length > 1 ? components[1] : void 0))
        throw new Error("The `partition` component (2nd component) of an ARN is required: " + arn);
      if (!(components.length > 2 ? components[2] : void 0))
        throw new Error("The `service` component (3rd component) of an ARN is required: " + arn);
      if (!(components.length > 5 ? components[5] : void 0))
        throw new Error("The `resource` component (6th component) of an ARN is required: " + arn);
      return components;
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/private/unique-resource-name.js
var require_unique_resource_name = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/unique-resource-name.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.makeUniqueResourceName = void 0;
    var crypto_1 = require("crypto");
    var HIDDEN_FROM_HUMAN_ID = "Resource";
    var HIDDEN_ID = "Default";
    var PATH_SEP = "/";
    var MAX_LEN = 256;
    var HASH_LEN = 8;
    function makeUniqueResourceName(components, options) {
      const maxLength = options.maxLength ?? 256, separator = options.separator ?? "";
      if (components = components.filter((x) => x !== HIDDEN_ID), components.length === 0)
        throw new Error("Unable to calculate a unique resource name for an empty set of components");
      if (components.length === 1) {
        const topLevelResource = removeNonAllowedSpecialCharacters(components[0], separator, options.allowedSpecialCharacters);
        if (topLevelResource.length <= maxLength)
          return topLevelResource;
      }
      const hash = pathHash(components), human = removeDupes(components).filter((pathElement) => pathElement !== HIDDEN_FROM_HUMAN_ID).map((pathElement) => removeNonAllowedSpecialCharacters(pathElement, separator, options.allowedSpecialCharacters)).filter((pathElement) => pathElement).join(separator).concat(separator), maxhumanLength = maxLength - HASH_LEN;
      return human.length > maxhumanLength ? `${splitInMiddle(human, maxhumanLength)}${hash}` : `${human}${hash}`;
    }
    exports.makeUniqueResourceName = makeUniqueResourceName;
    function pathHash(path) {
      return crypto_1.createHash("md5").update(path.join(PATH_SEP)).digest("hex").slice(0, HASH_LEN).toUpperCase();
    }
    function removeNonAllowedSpecialCharacters(s, _separator, allowedSpecialCharacters) {
      const pattern = allowedSpecialCharacters ? `[^A-Za-z0-9${allowedSpecialCharacters}]` : "[^A-Za-z0-9]", regex = new RegExp(pattern, "g");
      return s.replace(regex, "");
    }
    function removeDupes(path) {
      const ret = new Array();
      for (const component of path)
        (ret.length === 0 || !ret[ret.length - 1].endsWith(component)) && ret.push(component);
      return ret;
    }
    function splitInMiddle(s, maxLength = MAX_LEN - HASH_LEN) {
      const half = maxLength / 2;
      return s.slice(0, half) + s.slice(-half);
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/private/uniqueid.js
var require_uniqueid2 = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/uniqueid.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.makeUniqueId = void 0;
    var crypto = require("crypto");
    var encoding_1 = require_encoding();
    var HIDDEN_FROM_HUMAN_ID = "Resource";
    var HIDDEN_ID = "Default";
    var PATH_SEP = "/";
    var HASH_LEN = 8;
    var MAX_HUMAN_LEN = 240;
    var MAX_ID_LEN = 255;
    function makeUniqueId(components) {
      if (components = components.filter((x) => x !== HIDDEN_ID), components.length === 0)
        throw new Error("Unable to calculate a unique id for an empty set of components");
      const unresolvedTokens = components.filter((c) => encoding_1.unresolved(c));
      if (unresolvedTokens.length > 0)
        throw new Error(`ID components may not include unresolved tokens: ${unresolvedTokens.join(",")}`);
      if (components.length === 1) {
        const candidate = removeNonAlphanumeric(components[0]);
        if (candidate.length <= MAX_ID_LEN)
          return candidate;
      }
      const hash = pathHash(components);
      return removeDupes(components).filter((x) => x !== HIDDEN_FROM_HUMAN_ID).map(removeNonAlphanumeric).join("").slice(0, MAX_HUMAN_LEN) + hash;
    }
    exports.makeUniqueId = makeUniqueId;
    function pathHash(path) {
      return crypto.createHash("md5").update(path.join(PATH_SEP)).digest("hex").slice(0, HASH_LEN).toUpperCase();
    }
    function removeNonAlphanumeric(s) {
      return s.replace(/[^A-Za-z0-9]/g, "");
    }
    function removeDupes(path) {
      const ret = new Array();
      for (const component of path)
        (ret.length === 0 || !ret[ret.length - 1].endsWith(component)) && ret.push(component);
      return ret;
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/names.js
var require_names = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/names.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.Names = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var constructs_1 = require_lib4();
    var encoding_1 = require_encoding();
    var unique_resource_name_1 = require_unique_resource_name();
    var uniqueid_1 = require_uniqueid2();
    var stack_1 = require_stack();
    var Names = class {
      constructor() {
      }
      static uniqueId(construct) {
        const components = constructs_1.Node.of(construct).scopes.slice(1).map((c) => constructs_1.Node.of(c).id);
        return components.length > 0 ? uniqueid_1.makeUniqueId(components) : "";
      }
      static nodeUniqueId(node) {
        const components = node.scopes.slice(1).map((c) => constructs_1.Node.of(c).id);
        return components.length > 0 ? uniqueid_1.makeUniqueId(components) : "";
      }
      static uniqueResourceName(construct, options) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_UniqueResourceNameOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.uniqueResourceName), error;
        }
        const node = constructs_1.Node.of(construct), componentsPath = node.scopes.slice(node.scopes.indexOf(node.scopes.reverse().find((component) => stack_1.Stack.isStack(component) && !encoding_1.unresolved(component.stackName)))).map((component) => stack_1.Stack.isStack(component) && !encoding_1.unresolved(component.stackName) ? component.stackName : constructs_1.Node.of(component).id);
        return unique_resource_name_1.makeUniqueResourceName(componentsPath, options);
      }
    };
    exports.Names = Names, _a = JSII_RTTI_SYMBOL_1, Names[_a] = { fqn: "aws-cdk-lib.Names", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/private/physical-name-generator.js
var require_physical_name_generator = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/physical-name-generator.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.isGeneratedWhenNeededMarker = exports.GeneratedWhenNeededMarker = exports.generatePhysicalName = void 0;
    var crypto = require("crypto");
    var constructs_1 = require_lib4();
    var names_1 = require_names();
    var stack_1 = require_stack();
    var token_1 = require_token();
    var token_map_1 = require_token_map();
    function generatePhysicalName(resource) {
      const stack = stack_1.Stack.of(resource), stackPart = new PrefixNamePart(stack.stackName, 25), idPart = new SuffixNamePart(names_1.Names.nodeUniqueId(resource.node), 24), region = stack.region;
      if (token_1.Token.isUnresolved(region) || !region)
        throw new Error(`Cannot generate a physical name for ${constructs_1.Node.of(resource).path}, because the region is un-resolved or missing`);
      const account = stack.account;
      if (token_1.Token.isUnresolved(account) || !account)
        throw new Error(`Cannot generate a physical name for ${constructs_1.Node.of(resource).path}, because the account is un-resolved or missing`);
      const parts = [stackPart, idPart].map((part) => part.generate()), hashLength = 12, hash = crypto.createHash("sha256").update(stackPart.bareStr).update(idPart.bareStr).update(region).update(account).digest("hex").slice(0, hashLength);
      return [...parts, hash].join("").toLowerCase();
    }
    exports.generatePhysicalName = generatePhysicalName;
    var NamePart = class {
      constructor(bareStr) {
        this.bareStr = bareStr;
      }
    };
    var PrefixNamePart = class extends NamePart {
      constructor(bareStr, prefixLength) {
        super(bareStr), this.prefixLength = prefixLength;
      }
      generate() {
        return this.bareStr.slice(0, this.prefixLength);
      }
    };
    var SuffixNamePart = class extends NamePart {
      constructor(str, suffixLength) {
        super(str), this.suffixLength = suffixLength;
      }
      generate() {
        const strLen = this.bareStr.length, startIndex = Math.max(strLen - this.suffixLength, 0);
        return this.bareStr.slice(startIndex, strLen);
      }
    };
    var GENERATE_IF_NEEDED_SYMBOL = Symbol.for("@aws-cdk/core.<private>.GenerateIfNeeded");
    var GeneratedWhenNeededMarker = class {
      constructor() {
        this.creationStack = [], Object.defineProperty(this, GENERATE_IF_NEEDED_SYMBOL, { value: true });
      }
      resolve(_ctx) {
        throw new Error('Invalid physical name passed to CloudFormation. Use "this.physicalName" instead');
      }
      toString() {
        return "PhysicalName.GENERATE_IF_NEEDED";
      }
    };
    exports.GeneratedWhenNeededMarker = GeneratedWhenNeededMarker;
    function isGeneratedWhenNeededMarker(val) {
      const token = token_map_1.TokenMap.instance().lookupString(val);
      return !!token && GENERATE_IF_NEEDED_SYMBOL in token;
    }
    exports.isGeneratedWhenNeededMarker = isGeneratedWhenNeededMarker;
  }
});

// node_modules/aws-cdk-lib/core/lib/resource.js
var require_resource = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/resource.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.Resource = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var arn_1 = require_arn();
    var cfn_resource_1 = require_cfn_resource();
    var lazy_1 = require_lazy();
    var physical_name_generator_1 = require_physical_name_generator();
    var reference_1 = require_reference();
    var stack_1 = require_stack();
    var token_1 = require_token();
    var constructs_1 = require_lib4();
    var RESOURCE_SYMBOL = Symbol.for("@aws-cdk/core.Resource");
    var Resource = class extends constructs_1.Construct {
      constructor(scope, id, props = {}) {
        super(scope, id);
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ResourceProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, Resource), error;
        }
        if ((props.account !== void 0 || props.region !== void 0) && props.environmentFromArn !== void 0)
          throw new Error(`Supply at most one of 'account'/'region' (${props.account}/${props.region}) and 'environmentFromArn' (${props.environmentFromArn})`);
        Object.defineProperty(this, RESOURCE_SYMBOL, { value: true }), this.stack = stack_1.Stack.of(this);
        const parsedArn = props.environmentFromArn ? this.stack.splitArn(props.environmentFromArn, arn_1.ArnFormat.NO_RESOURCE_NAME) : void 0;
        this.env = { account: props.account ?? (parsedArn == null ? void 0 : parsedArn.account) ?? this.stack.account, region: props.region ?? (parsedArn == null ? void 0 : parsedArn.region) ?? this.stack.region };
        let physicalName = props.physicalName;
        props.physicalName && physical_name_generator_1.isGeneratedWhenNeededMarker(props.physicalName) ? (this._physicalName = void 0, this._allowCrossEnvironment = true, physicalName = lazy_1.Lazy.string({ produce: () => this._physicalName })) : props.physicalName && !token_1.Token.isUnresolved(props.physicalName) ? (this._physicalName = props.physicalName, this._allowCrossEnvironment = true) : (this._physicalName = props.physicalName, this._allowCrossEnvironment = false), physicalName === void 0 && (physicalName = token_1.Token.asString(void 0)), this.physicalName = physicalName;
      }
      static isResource(construct) {
        return construct !== null && typeof construct == "object" && RESOURCE_SYMBOL in construct;
      }
      static isOwnedResource(construct) {
        return construct.node.defaultChild ? cfn_resource_1.CfnResource.isCfnResource(construct.node.defaultChild) : false;
      }
      _enableCrossEnvironment() {
        if (!this._allowCrossEnvironment)
          throw new Error(`Cannot use resource '${this.node.path}' in a cross-environment fashion, the resource's physical name must be explicit set or use \`PhysicalName.GENERATE_IF_NEEDED\``);
        this._physicalName || (this._physicalName = this.generatePhysicalName());
      }
      applyRemovalPolicy(policy) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_RemovalPolicy(policy);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.applyRemovalPolicy), error;
        }
        const child = this.node.defaultChild;
        if (!child || !cfn_resource_1.CfnResource.isCfnResource(child))
          throw new Error("Cannot apply RemovalPolicy: no child or not a CfnResource. Apply the removal policy on the CfnResource directly.");
        child.applyRemovalPolicy(policy);
      }
      generatePhysicalName() {
        return physical_name_generator_1.generatePhysicalName(this);
      }
      getResourceNameAttribute(nameAttr) {
        return mimicReference(nameAttr, { produce: (context) => {
          const consumingStack = stack_1.Stack.of(context.scope);
          return this.stack.account !== consumingStack.account || this.stack.region !== consumingStack.region && !consumingStack._crossRegionReferences ? (this._enableCrossEnvironment(), this.physicalName) : nameAttr;
        } });
      }
      getResourceArnAttribute(arnAttr, arnComponents) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ArnComponents(arnComponents);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.getResourceArnAttribute), error;
        }
        return mimicReference(arnAttr, { produce: (context) => {
          const consumingStack = stack_1.Stack.of(context.scope);
          return this.stack.account !== consumingStack.account || this.stack.region !== consumingStack.region && !consumingStack._crossRegionReferences ? (this._enableCrossEnvironment(), this.stack.formatArn(arnComponents)) : arnAttr;
        } });
      }
    };
    exports.Resource = Resource, _a = JSII_RTTI_SYMBOL_1, Resource[_a] = { fqn: "aws-cdk-lib.Resource", version: "2.50.0" };
    function mimicReference(refSource, producer) {
      const reference = token_1.Tokenization.reverse(refSource, { failConcat: false });
      return reference_1.Reference.isReference(reference) ? token_1.Token.asString(new class extends reference_1.Reference {
        resolve(context) {
          return producer.produce(context);
        }
      }(reference, reference.target, reference.displayName)) : lazy_1.Lazy.uncachedString(producer);
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/custom-resource.js
var require_custom_resource = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/custom-resource.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CustomResource = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_resource_1 = require_cfn_resource();
    var removal_policy_1 = require_removal_policy();
    var resource_1 = require_resource();
    var token_1 = require_token();
    var CustomResource2 = class extends resource_1.Resource {
      constructor(scope, id, props) {
        super(scope, id);
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CustomResourceProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CustomResource2), error;
        }
        const type = renderResourceType(props.resourceType), properties = props.pascalCaseProperties ?? false ? uppercaseProperties(props.properties || {}) : props.properties || {};
        this.resource = new cfn_resource_1.CfnResource(this, "Default", { type, properties: { ServiceToken: props.serviceToken, ...properties } }), this.resource.applyRemovalPolicy(props.removalPolicy, { default: removal_policy_1.RemovalPolicy.DESTROY });
      }
      get ref() {
        return this.resource.ref;
      }
      getAtt(attributeName) {
        return this.resource.getAtt(attributeName);
      }
      getAttString(attributeName) {
        return token_1.Token.asString(this.getAtt(attributeName));
      }
    };
    exports.CustomResource = CustomResource2, _a = JSII_RTTI_SYMBOL_1, CustomResource2[_a] = { fqn: "aws-cdk-lib.CustomResource", version: "2.50.0" };
    function uppercaseProperties(props) {
      const ret = {};
      return Object.keys(props).forEach((key) => {
        const upper = key.slice(0, 1).toUpperCase() + key.slice(1);
        ret[upper] = props[key];
      }), ret;
    }
    function renderResourceType(resourceType) {
      if (!resourceType)
        return "AWS::CloudFormation::CustomResource";
      if (!resourceType.startsWith("Custom::"))
        throw new Error(`Custom resource type must begin with "Custom::" (${resourceType})`);
      if (resourceType.length > 60)
        throw new Error(`Custom resource type length > 60 (${resourceType})`);
      const typeName = resourceType.slice(resourceType.indexOf("::") + 2);
      if (!/^[a-z0-9_@-]+$/i.test(typeName))
        throw new Error(`Custom resource type name can only include alphanumeric characters and _@- (${typeName})`);
      return resourceType;
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/assets.js
var require_assets3 = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/assets.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.FileAssetPackaging = exports.AssetHashType = void 0;
    var AssetHashType;
    (function(AssetHashType2) {
      AssetHashType2.SOURCE = "source", AssetHashType2.BUNDLE = "bundle", AssetHashType2.OUTPUT = "output", AssetHashType2.CUSTOM = "custom";
    })(AssetHashType = exports.AssetHashType || (exports.AssetHashType = {}));
    var FileAssetPackaging;
    (function(FileAssetPackaging2) {
      FileAssetPackaging2.ZIP_DIRECTORY = "zip", FileAssetPackaging2.FILE = "file";
    })(FileAssetPackaging = exports.FileAssetPackaging || (exports.FileAssetPackaging = {}));
  }
});

// node_modules/aws-cdk-lib/node_modules/@balena/dockerignore/ignore.js
var require_ignore = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/@balena/dockerignore/ignore.js"(exports, module2) {
    "use strict";
    var path = require("path");
    var factory = (options) => new IgnoreBase(options);
    factory.default = factory;
    module2.exports = factory;
    function make_array(subject) {
      return Array.isArray(subject) ? subject : [subject];
    }
    var REGEX_TRAILING_SLASH = /(?<=.)\/$/;
    var REGEX_TRAILING_BACKSLASH = /(?<=.)\\$/;
    var REGEX_TRAILING_PATH_SEP = path.sep === "\\" ? REGEX_TRAILING_BACKSLASH : REGEX_TRAILING_SLASH;
    var KEY_IGNORE = typeof Symbol !== "undefined" ? Symbol.for("dockerignore") : "dockerignore";
    function cleanPath(file) {
      return path.normalize(file).replace(REGEX_TRAILING_PATH_SEP, "");
    }
    function toSlash(file) {
      if (path.sep === "/") {
        return file;
      }
      return file.replace(/\\/g, "/");
    }
    function fromSlash(file) {
      if (path.sep === "/") {
        return file;
      }
      return file.replace(/\//g, path.sep);
    }
    var IgnoreBase = class {
      constructor({
        // https://github.com/kaelzhang/node-ignore/blob/5.1.4/index.js#L372
        ignorecase = true
      } = {}) {
        this._rules = [];
        this._ignorecase = ignorecase;
        this[KEY_IGNORE] = true;
        this._initCache();
      }
      _initCache() {
        this._cache = {};
      }
      // @param {Array.<string>|string|Ignore} pattern
      add(pattern) {
        this._added = false;
        if (typeof pattern === "string") {
          pattern = pattern.split(/\r?\n/g);
        }
        make_array(pattern).forEach(this._addPattern, this);
        if (this._added) {
          this._initCache();
        }
        return this;
      }
      // legacy
      addPattern(pattern) {
        return this.add(pattern);
      }
      _addPattern(pattern) {
        if (pattern && pattern[KEY_IGNORE]) {
          this._rules = this._rules.concat(pattern._rules);
          this._added = true;
          return;
        }
        if (this._checkPattern(pattern)) {
          const rule = this._createRule(pattern.trim());
          if (rule !== null) {
            this._added = true;
            this._rules.push(rule);
          }
        }
      }
      _checkPattern(pattern) {
        return pattern && typeof pattern === "string" && pattern.indexOf("#") !== 0 && pattern.trim() !== "";
      }
      filter(paths) {
        return make_array(paths).filter((path2) => this._filter(path2));
      }
      createFilter() {
        return (path2) => this._filter(path2);
      }
      ignores(path2) {
        return !this._filter(path2);
      }
      // https://github.com/moby/moby/blob/v19.03.8/builder/dockerignore/dockerignore.go#L41-L53
      // https://github.com/moby/moby/blob/v19.03.8/pkg/fileutils/fileutils.go#L29-L55
      _createRule(pattern) {
        const origin = pattern;
        let negative = false;
        if (pattern[0] === "!") {
          negative = true;
          pattern = pattern.substring(1).trim();
        }
        if (pattern.length > 0) {
          pattern = cleanPath(pattern);
          pattern = toSlash(pattern);
          if (pattern.length > 1 && pattern[0] === "/") {
            pattern = pattern.slice(1);
          }
        }
        if (negative) {
          pattern = "!" + pattern;
        }
        pattern = pattern.trim();
        if (pattern === "") {
          return null;
        }
        pattern = cleanPath(pattern);
        if (pattern[0] === "!") {
          if (pattern.length === 1) {
            return null;
          }
          negative = true;
          pattern = pattern.substring(1);
        } else {
          negative = false;
        }
        return {
          origin,
          pattern,
          // https://github.com/moby/moby/blob/v19.03.8/pkg/fileutils/fileutils.go#L54
          dirs: pattern.split(path.sep),
          negative
        };
      }
      // @returns `Boolean` true if the `path` is NOT ignored
      _filter(path2) {
        if (!path2) {
          return false;
        }
        if (path2 in this._cache) {
          return this._cache[path2];
        }
        return this._cache[path2] = this._test(path2);
      }
      // @returns {Boolean} true if a file is NOT ignored
      // https://github.com/moby/moby/blob/v19.03.8/pkg/fileutils/fileutils.go#L62
      _test(file) {
        file = fromSlash(file);
        const parentPath = cleanPath(path.dirname(file));
        const parentPathDirs = parentPath.split(path.sep);
        let matched = false;
        this._rules.forEach((rule) => {
          let match = this._match(file, rule);
          if (!match && parentPath !== ".") {
            if (rule.dirs.includes("**")) {
              for (let i = rule.dirs.filter((x) => x !== "**").length; i <= parentPathDirs.length; i++) {
                match = match || this._match(parentPathDirs.slice(0, i).join(path.sep), rule);
              }
            } else if (rule.dirs.length <= parentPathDirs.length) {
              match = this._match(parentPathDirs.slice(0, rule.dirs.length).join(path.sep), rule);
            }
          }
          if (match) {
            matched = !rule.negative;
          }
        });
        return !matched;
      }
      // @returns {Boolean} true if a file is matched by a rule
      _match(file, rule) {
        return this._compile(rule).regexp.test(file);
      }
      // https://github.com/moby/moby/blob/v19.03.8/pkg/fileutils/fileutils.go#L139
      _compile(rule) {
        if (rule.regexp) {
          return rule;
        }
        let regStr = "^";
        let escapedSlash = path.sep === "\\" ? "\\\\" : path.sep;
        for (let i = 0; i < rule.pattern.length; i++) {
          const ch = rule.pattern[i];
          if (ch === "*") {
            if (rule.pattern[i + 1] === "*") {
              i++;
              if (rule.pattern[i + 1] === path.sep) {
                i++;
              }
              if (rule.pattern[i + 1] === void 0) {
                regStr += ".*";
              } else {
                regStr += `(.*${escapedSlash})?`;
              }
            } else {
              regStr += `[^${escapedSlash}]*`;
            }
          } else if (ch === "?") {
            regStr += `[^${escapedSlash}]`;
          } else if (ch === "." || ch === "$") {
            regStr += `\\${ch}`;
          } else if (ch === "\\") {
            if (path.sep === "\\") {
              regStr += escapedSlash;
              continue;
            }
            if (rule.pattern[i + 1] !== void 0) {
              regStr += "\\" + rule.pattern[i + 1];
              i++;
            } else {
              regStr += "\\";
            }
          } else {
            regStr += ch;
          }
        }
        regStr += "$";
        rule.regexp = new RegExp(regStr, this._ignorecase ? "i" : "");
        return rule;
      }
    };
  }
});

// node_modules/aws-cdk-lib/node_modules/ignore/index.js
var require_ignore2 = __commonJS({
  "node_modules/aws-cdk-lib/node_modules/ignore/index.js"(exports, module2) {
    function makeArray(subject) {
      return Array.isArray(subject) ? subject : [subject];
    }
    var EMPTY = "";
    var SPACE = " ";
    var ESCAPE = "\\";
    var REGEX_TEST_BLANK_LINE = /^\s+$/;
    var REGEX_REPLACE_LEADING_EXCAPED_EXCLAMATION = /^\\!/;
    var REGEX_REPLACE_LEADING_EXCAPED_HASH = /^\\#/;
    var REGEX_SPLITALL_CRLF = /\r?\n/g;
    var REGEX_TEST_INVALID_PATH = /^\.*\/|^\.+$/;
    var SLASH = "/";
    var KEY_IGNORE = typeof Symbol !== "undefined" ? Symbol.for("node-ignore") : "node-ignore";
    var define = (object, key, value) => Object.defineProperty(object, key, { value });
    var REGEX_REGEXP_RANGE = /([0-z])-([0-z])/g;
    var RETURN_FALSE = () => false;
    var sanitizeRange = (range) => range.replace(
      REGEX_REGEXP_RANGE,
      (match, from, to) => from.charCodeAt(0) <= to.charCodeAt(0) ? match : EMPTY
    );
    var cleanRangeBackSlash = (slashes) => {
      const { length } = slashes;
      return slashes.slice(0, length - length % 2);
    };
    var REPLACERS = [
      // > Trailing spaces are ignored unless they are quoted with backslash ("\")
      [
        // (a\ ) -> (a )
        // (a  ) -> (a)
        // (a \ ) -> (a  )
        /\\?\s+$/,
        (match) => match.indexOf("\\") === 0 ? SPACE : EMPTY
      ],
      // replace (\ ) with ' '
      [
        /\\\s/g,
        () => SPACE
      ],
      // Escape metacharacters
      // which is written down by users but means special for regular expressions.
      // > There are 12 characters with special meanings:
      // > - the backslash \,
      // > - the caret ^,
      // > - the dollar sign $,
      // > - the period or dot .,
      // > - the vertical bar or pipe symbol |,
      // > - the question mark ?,
      // > - the asterisk or star *,
      // > - the plus sign +,
      // > - the opening parenthesis (,
      // > - the closing parenthesis ),
      // > - and the opening square bracket [,
      // > - the opening curly brace {,
      // > These special characters are often called "metacharacters".
      [
        /[\\$.|*+(){^]/g,
        (match) => `\\${match}`
      ],
      [
        // > a question mark (?) matches a single character
        /(?!\\)\?/g,
        () => "[^/]"
      ],
      // leading slash
      [
        // > A leading slash matches the beginning of the pathname.
        // > For example, "/*.c" matches "cat-file.c" but not "mozilla-sha1/sha1.c".
        // A leading slash matches the beginning of the pathname
        /^\//,
        () => "^"
      ],
      // replace special metacharacter slash after the leading slash
      [
        /\//g,
        () => "\\/"
      ],
      [
        // > A leading "**" followed by a slash means match in all directories.
        // > For example, "**/foo" matches file or directory "foo" anywhere,
        // > the same as pattern "foo".
        // > "**/foo/bar" matches file or directory "bar" anywhere that is directly
        // >   under directory "foo".
        // Notice that the '*'s have been replaced as '\\*'
        /^\^*\\\*\\\*\\\//,
        // '**/foo' <-> 'foo'
        () => "^(?:.*\\/)?"
      ],
      // starting
      [
        // there will be no leading '/'
        //   (which has been replaced by section "leading slash")
        // If starts with '**', adding a '^' to the regular expression also works
        /^(?=[^^])/,
        function startingReplacer() {
          return !/\/(?!$)/.test(this) ? "(?:^|\\/)" : "^";
        }
      ],
      // two globstars
      [
        // Use lookahead assertions so that we could match more than one `'/**'`
        /\\\/\\\*\\\*(?=\\\/|$)/g,
        // Zero, one or several directories
        // should not use '*', or it will be replaced by the next replacer
        // Check if it is not the last `'/**'`
        (_, index, str) => index + 6 < str.length ? "(?:\\/[^\\/]+)*" : "\\/.+"
      ],
      // intermediate wildcards
      [
        // Never replace escaped '*'
        // ignore rule '\*' will match the path '*'
        // 'abc.*/' -> go
        // 'abc.*'  -> skip this rule
        /(^|[^\\]+)\\\*(?=.+)/g,
        // '*.js' matches '.js'
        // '*.js' doesn't match 'abc'
        (_, p1) => `${p1}[^\\/]*`
      ],
      [
        // unescape, revert step 3 except for back slash
        // For example, if a user escape a '\\*',
        // after step 3, the result will be '\\\\\\*'
        /\\\\\\(?=[$.|*+(){^])/g,
        () => ESCAPE
      ],
      [
        // '\\\\' -> '\\'
        /\\\\/g,
        () => ESCAPE
      ],
      [
        // > The range notation, e.g. [a-zA-Z],
        // > can be used to match one of the characters in a range.
        // `\` is escaped by step 3
        /(\\)?\[([^\]/]*?)(\\*)($|\])/g,
        (match, leadEscape, range, endEscape, close) => leadEscape === ESCAPE ? `\\[${range}${cleanRangeBackSlash(endEscape)}${close}` : close === "]" ? endEscape.length % 2 === 0 ? `[${sanitizeRange(range)}${endEscape}]` : "[]" : "[]"
      ],
      // ending
      [
        // 'js' will not match 'js.'
        // 'ab' will not match 'abc'
        /(?:[^*])$/,
        // WTF!
        // https://git-scm.com/docs/gitignore
        // changes in [2.22.1](https://git-scm.com/docs/gitignore/2.22.1)
        // which re-fixes #24, #38
        // > If there is a separator at the end of the pattern then the pattern
        // > will only match directories, otherwise the pattern can match both
        // > files and directories.
        // 'js*' will not match 'a.js'
        // 'js/' will not match 'a.js'
        // 'js' will match 'a.js' and 'a.js/'
        (match) => /\/$/.test(match) ? `${match}$` : `${match}(?=$|\\/$)`
      ],
      // trailing wildcard
      [
        /(\^|\\\/)?\\\*$/,
        (_, p1) => {
          const prefix = p1 ? `${p1}[^/]+` : "[^/]*";
          return `${prefix}(?=$|\\/$)`;
        }
      ]
    ];
    var regexCache = /* @__PURE__ */ Object.create(null);
    var makeRegex = (pattern, ignoreCase) => {
      let source = regexCache[pattern];
      if (!source) {
        source = REPLACERS.reduce(
          (prev, current) => prev.replace(current[0], current[1].bind(pattern)),
          pattern
        );
        regexCache[pattern] = source;
      }
      return ignoreCase ? new RegExp(source, "i") : new RegExp(source);
    };
    var isString = (subject) => typeof subject === "string";
    var checkPattern = (pattern) => pattern && isString(pattern) && !REGEX_TEST_BLANK_LINE.test(pattern) && pattern.indexOf("#") !== 0;
    var splitPattern = (pattern) => pattern.split(REGEX_SPLITALL_CRLF);
    var IgnoreRule = class {
      constructor(origin, pattern, negative, regex) {
        this.origin = origin;
        this.pattern = pattern;
        this.negative = negative;
        this.regex = regex;
      }
    };
    var createRule = (pattern, ignoreCase) => {
      const origin = pattern;
      let negative = false;
      if (pattern.indexOf("!") === 0) {
        negative = true;
        pattern = pattern.substr(1);
      }
      pattern = pattern.replace(REGEX_REPLACE_LEADING_EXCAPED_EXCLAMATION, "!").replace(REGEX_REPLACE_LEADING_EXCAPED_HASH, "#");
      const regex = makeRegex(pattern, ignoreCase);
      return new IgnoreRule(
        origin,
        pattern,
        negative,
        regex
      );
    };
    var throwError = (message, Ctor) => {
      throw new Ctor(message);
    };
    var checkPath = (path, originalPath, doThrow) => {
      if (!isString(path)) {
        return doThrow(
          `path must be a string, but got \`${originalPath}\``,
          TypeError
        );
      }
      if (!path) {
        return doThrow(`path must not be empty`, TypeError);
      }
      if (checkPath.isNotRelative(path)) {
        const r = "`path.relative()`d";
        return doThrow(
          `path should be a ${r} string, but got "${originalPath}"`,
          RangeError
        );
      }
      return true;
    };
    var isNotRelative = (path) => REGEX_TEST_INVALID_PATH.test(path);
    checkPath.isNotRelative = isNotRelative;
    checkPath.convert = (p) => p;
    var Ignore = class {
      constructor({
        ignorecase = true,
        ignoreCase = ignorecase,
        allowRelativePaths = false
      } = {}) {
        define(this, KEY_IGNORE, true);
        this._rules = [];
        this._ignoreCase = ignoreCase;
        this._allowRelativePaths = allowRelativePaths;
        this._initCache();
      }
      _initCache() {
        this._ignoreCache = /* @__PURE__ */ Object.create(null);
        this._testCache = /* @__PURE__ */ Object.create(null);
      }
      _addPattern(pattern) {
        if (pattern && pattern[KEY_IGNORE]) {
          this._rules = this._rules.concat(pattern._rules);
          this._added = true;
          return;
        }
        if (checkPattern(pattern)) {
          const rule = createRule(pattern, this._ignoreCase);
          this._added = true;
          this._rules.push(rule);
        }
      }
      // @param {Array<string> | string | Ignore} pattern
      add(pattern) {
        this._added = false;
        makeArray(
          isString(pattern) ? splitPattern(pattern) : pattern
        ).forEach(this._addPattern, this);
        if (this._added) {
          this._initCache();
        }
        return this;
      }
      // legacy
      addPattern(pattern) {
        return this.add(pattern);
      }
      //          |           ignored : unignored
      // negative |   0:0   |   0:1   |   1:0   |   1:1
      // -------- | ------- | ------- | ------- | --------
      //     0    |  TEST   |  TEST   |  SKIP   |    X
      //     1    |  TESTIF |  SKIP   |  TEST   |    X
      // - SKIP: always skip
      // - TEST: always test
      // - TESTIF: only test if checkUnignored
      // - X: that never happen
      // @param {boolean} whether should check if the path is unignored,
      //   setting `checkUnignored` to `false` could reduce additional
      //   path matching.
      // @returns {TestResult} true if a file is ignored
      _testOne(path, checkUnignored) {
        let ignored = false;
        let unignored = false;
        this._rules.forEach((rule) => {
          const { negative } = rule;
          if (unignored === negative && ignored !== unignored || negative && !ignored && !unignored && !checkUnignored) {
            return;
          }
          const matched = rule.regex.test(path);
          if (matched) {
            ignored = !negative;
            unignored = negative;
          }
        });
        return {
          ignored,
          unignored
        };
      }
      // @returns {TestResult}
      _test(originalPath, cache, checkUnignored, slices) {
        const path = originalPath && checkPath.convert(originalPath);
        checkPath(
          path,
          originalPath,
          this._allowRelativePaths ? RETURN_FALSE : throwError
        );
        return this._t(path, cache, checkUnignored, slices);
      }
      _t(path, cache, checkUnignored, slices) {
        if (path in cache) {
          return cache[path];
        }
        if (!slices) {
          slices = path.split(SLASH);
        }
        slices.pop();
        if (!slices.length) {
          return cache[path] = this._testOne(path, checkUnignored);
        }
        const parent = this._t(
          slices.join(SLASH) + SLASH,
          cache,
          checkUnignored,
          slices
        );
        return cache[path] = parent.ignored ? parent : this._testOne(path, checkUnignored);
      }
      ignores(path) {
        return this._test(path, this._ignoreCache, false).ignored;
      }
      createFilter() {
        return (path) => !this.ignores(path);
      }
      filter(paths) {
        return makeArray(paths).filter(this.createFilter());
      }
      // @returns {TestResult}
      test(path) {
        return this._test(path, this._testCache, true);
      }
    };
    var factory = (options) => new Ignore(options);
    var isPathValid = (path) => checkPath(path && checkPath.convert(path), path, RETURN_FALSE);
    factory.isPathValid = isPathValid;
    factory.default = factory;
    module2.exports = factory;
    if (// Detect `process` so that it can run in browsers.
    typeof process !== "undefined" && (process.env && process.env.IGNORE_TEST_WIN32 || process.platform === "win32")) {
      const makePosix = (str) => /^\\\\\?\\/.test(str) || /["<>|\u0000-\u001F]+/u.test(str) ? str : str.replace(/\\/g, "/");
      checkPath.convert = makePosix;
      const REGIX_IS_WINDOWS_PATH_ABSOLUTE = /^[a-z]:\//i;
      checkPath.isNotRelative = (path) => REGIX_IS_WINDOWS_PATH_ABSOLUTE.test(path) || isNotRelative(path);
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/fs/options.js
var require_options = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/fs/options.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.IgnoreMode = exports.SymlinkFollowMode = void 0;
    var SymlinkFollowMode;
    (function(SymlinkFollowMode2) {
      SymlinkFollowMode2.NEVER = "never", SymlinkFollowMode2.ALWAYS = "always", SymlinkFollowMode2.EXTERNAL = "external", SymlinkFollowMode2.BLOCK_EXTERNAL = "internal-only";
    })(SymlinkFollowMode = exports.SymlinkFollowMode || (exports.SymlinkFollowMode = {}));
    var IgnoreMode;
    (function(IgnoreMode2) {
      IgnoreMode2.GLOB = "glob", IgnoreMode2.GIT = "git", IgnoreMode2.DOCKER = "docker";
    })(IgnoreMode = exports.IgnoreMode || (exports.IgnoreMode = {}));
  }
});

// node_modules/aws-cdk-lib/core/lib/fs/ignore.js
var require_ignore3 = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/fs/ignore.js"(exports) {
    "use strict";
    var _a;
    var _b;
    var _c;
    var _d;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.DockerIgnoreStrategy = exports.GitIgnoreStrategy = exports.GlobIgnoreStrategy = exports.IgnoreStrategy = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var path = require("path");
    var dockerignore_1 = require_ignore();
    var ignore_1 = require_ignore2();
    var minimatch = require_minimatch();
    var options_1 = require_options();
    var IgnoreStrategy = class {
      static glob(absoluteRootPath, patterns) {
        return new GlobIgnoreStrategy(absoluteRootPath, patterns);
      }
      static git(absoluteRootPath, patterns) {
        return new GitIgnoreStrategy(absoluteRootPath, patterns);
      }
      static docker(absoluteRootPath, patterns) {
        return new DockerIgnoreStrategy(absoluteRootPath, patterns);
      }
      static fromCopyOptions(options, absoluteRootPath) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CopyOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.fromCopyOptions), error;
        }
        const ignoreMode = options.ignoreMode || options_1.IgnoreMode.GLOB, exclude = options.exclude || [];
        switch (ignoreMode) {
          case options_1.IgnoreMode.GLOB:
            return this.glob(absoluteRootPath, exclude);
          case options_1.IgnoreMode.GIT:
            return this.git(absoluteRootPath, exclude);
          case options_1.IgnoreMode.DOCKER:
            return this.docker(absoluteRootPath, exclude);
        }
      }
    };
    exports.IgnoreStrategy = IgnoreStrategy, _a = JSII_RTTI_SYMBOL_1, IgnoreStrategy[_a] = { fqn: "aws-cdk-lib.IgnoreStrategy", version: "2.50.0" };
    var GlobIgnoreStrategy = class extends IgnoreStrategy {
      constructor(absoluteRootPath, patterns) {
        if (super(), !path.isAbsolute(absoluteRootPath))
          throw new Error("GlobIgnoreStrategy expects an absolute file path");
        this.absoluteRootPath = absoluteRootPath, this.patterns = patterns;
      }
      add(pattern) {
        this.patterns.push(pattern);
      }
      ignores(absoluteFilePath) {
        if (!path.isAbsolute(absoluteFilePath))
          throw new Error("GlobIgnoreStrategy.ignores() expects an absolute path");
        let relativePath = path.relative(this.absoluteRootPath, absoluteFilePath), excludeOutput = false;
        for (const pattern of this.patterns) {
          const negate = pattern.startsWith("!"), match = minimatch(relativePath, pattern, { matchBase: true, flipNegate: true });
          !negate && match && (excludeOutput = true), negate && match && (excludeOutput = false);
        }
        return excludeOutput;
      }
    };
    exports.GlobIgnoreStrategy = GlobIgnoreStrategy, _b = JSII_RTTI_SYMBOL_1, GlobIgnoreStrategy[_b] = { fqn: "aws-cdk-lib.GlobIgnoreStrategy", version: "2.50.0" };
    var GitIgnoreStrategy = class extends IgnoreStrategy {
      constructor(absoluteRootPath, patterns) {
        if (super(), !path.isAbsolute(absoluteRootPath))
          throw new Error("GitIgnoreStrategy expects an absolute file path");
        this.absoluteRootPath = absoluteRootPath, this.ignore = ignore_1.default().add(patterns);
      }
      add(pattern) {
        this.ignore.add(pattern);
      }
      ignores(absoluteFilePath) {
        if (!path.isAbsolute(absoluteFilePath))
          throw new Error("GitIgnoreStrategy.ignores() expects an absolute path");
        let relativePath = path.relative(this.absoluteRootPath, absoluteFilePath);
        return this.ignore.ignores(relativePath);
      }
    };
    exports.GitIgnoreStrategy = GitIgnoreStrategy, _c = JSII_RTTI_SYMBOL_1, GitIgnoreStrategy[_c] = { fqn: "aws-cdk-lib.GitIgnoreStrategy", version: "2.50.0" };
    var DockerIgnoreStrategy = class extends IgnoreStrategy {
      constructor(absoluteRootPath, patterns) {
        if (super(), !path.isAbsolute(absoluteRootPath))
          throw new Error("DockerIgnoreStrategy expects an absolute file path");
        this.absoluteRootPath = absoluteRootPath, this.ignore = dockerignore_1.default().add(patterns);
      }
      add(pattern) {
        this.ignore.add(pattern);
      }
      ignores(absoluteFilePath) {
        if (!path.isAbsolute(absoluteFilePath))
          throw new Error("DockerIgnoreStrategy.ignores() expects an absolute path");
        let relativePath = path.relative(this.absoluteRootPath, absoluteFilePath);
        return this.ignore.ignores(relativePath);
      }
    };
    exports.DockerIgnoreStrategy = DockerIgnoreStrategy, _d = JSII_RTTI_SYMBOL_1, DockerIgnoreStrategy[_d] = { fqn: "aws-cdk-lib.DockerIgnoreStrategy", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/fs/utils.js
var require_utils2 = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/fs/utils.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.shouldFollow = void 0;
    var fs = require("fs");
    var path = require("path");
    var options_1 = require_options();
    function shouldFollow(mode, sourceRoot, realPath) {
      switch (mode) {
        case options_1.SymlinkFollowMode.ALWAYS:
          return fs.existsSync(realPath);
        case options_1.SymlinkFollowMode.EXTERNAL:
          return !_isInternal() && fs.existsSync(realPath);
        case options_1.SymlinkFollowMode.BLOCK_EXTERNAL:
          return _isInternal() && fs.existsSync(realPath);
        case options_1.SymlinkFollowMode.NEVER:
          return false;
        default:
          throw new Error(`Unsupported FollowMode: ${mode}`);
      }
      function _isInternal() {
        return path.resolve(realPath).startsWith(path.resolve(sourceRoot));
      }
    }
    exports.shouldFollow = shouldFollow;
  }
});

// node_modules/aws-cdk-lib/core/lib/fs/copy.js
var require_copy3 = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/fs/copy.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.copyDirectory = void 0;
    var fs = require("fs");
    var path = require("path");
    var ignore_1 = require_ignore3();
    var options_1 = require_options();
    var utils_1 = require_utils2();
    function copyDirectory(srcDir, destDir, options = {}, rootDir) {
      const follow = options.follow ?? options_1.SymlinkFollowMode.EXTERNAL;
      rootDir = rootDir || srcDir;
      const ignoreStrategy = ignore_1.IgnoreStrategy.fromCopyOptions(options, rootDir);
      if (!fs.statSync(srcDir).isDirectory())
        throw new Error(`${srcDir} is not a directory`);
      const files = fs.readdirSync(srcDir);
      for (const file of files) {
        const sourceFilePath = path.join(srcDir, file);
        if (ignoreStrategy.ignores(sourceFilePath))
          continue;
        const destFilePath = path.join(destDir, file);
        let stat = follow === options_1.SymlinkFollowMode.ALWAYS ? fs.statSync(sourceFilePath) : fs.lstatSync(sourceFilePath);
        if (stat && stat.isSymbolicLink()) {
          const target = fs.readlinkSync(sourceFilePath), targetPath = path.normalize(path.resolve(srcDir, target));
          utils_1.shouldFollow(follow, rootDir, targetPath) ? stat = fs.statSync(sourceFilePath) : (fs.symlinkSync(target, destFilePath), stat = void 0);
        }
        stat && stat.isDirectory() && (fs.mkdirSync(destFilePath), copyDirectory(sourceFilePath, destFilePath, options, rootDir), stat = void 0), stat && stat.isFile() && (fs.copyFileSync(sourceFilePath, destFilePath), stat = void 0);
      }
    }
    exports.copyDirectory = copyDirectory;
  }
});

// node_modules/aws-cdk-lib/core/lib/private/cache.js
var require_cache = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/cache.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.Cache = void 0;
    var Cache = class {
      constructor() {
        this.cache = /* @__PURE__ */ new Map();
      }
      clear() {
        this.cache.clear();
      }
      obtain(cacheKey, calcFn) {
        let value = this.cache.get(cacheKey);
        return value || (value = calcFn(), this.cache.set(cacheKey, value), value);
      }
    };
    exports.Cache = Cache;
  }
});

// node_modules/aws-cdk-lib/core/lib/fs/fingerprint.js
var require_fingerprint = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/fs/fingerprint.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.contentFingerprint = exports.fingerprint = exports.clearLargeFileFingerprintCache = void 0;
    var crypto = require("crypto");
    var fs = require("fs");
    var path = require("path");
    var cache_1 = require_cache();
    var ignore_1 = require_ignore3();
    var options_1 = require_options();
    var utils_1 = require_utils2();
    var BUFFER_SIZE = 8 * 1024;
    var CTRL_SOH = "";
    var CTRL_SOT = "";
    var CTRL_ETX = "";
    var CR = "\r";
    var LF = `
`;
    var CRLF = `${CR}${LF}`;
    var fingerprintCache = new cache_1.Cache();
    function clearLargeFileFingerprintCache() {
      fingerprintCache.clear();
    }
    exports.clearLargeFileFingerprintCache = clearLargeFileFingerprintCache;
    function fingerprint(fileOrDirectory, options = {}) {
      const hash = crypto.createHash("sha256");
      _hashField(hash, "options.extra", options.extraHash || "");
      const follow = options.follow || options_1.SymlinkFollowMode.EXTERNAL;
      _hashField(hash, "options.follow", follow), fileOrDirectory = fs.realpathSync(fileOrDirectory);
      const isDir = fs.statSync(fileOrDirectory).isDirectory(), rootDirectory = isDir ? fileOrDirectory : path.dirname(fileOrDirectory), ignoreMode = options.ignoreMode || options_1.IgnoreMode.GLOB;
      ignoreMode != options_1.IgnoreMode.GLOB && _hashField(hash, "options.ignoreMode", ignoreMode);
      const ignoreStrategy = ignore_1.IgnoreStrategy.fromCopyOptions(options, fileOrDirectory);
      return _processFileOrDirectory(fileOrDirectory, isDir), hash.digest("hex");
      function _processFileOrDirectory(symbolicPath, isRootDir = false, realPath = symbolicPath) {
        if (!isRootDir && ignoreStrategy.ignores(symbolicPath))
          return;
        const stat = fs.lstatSync(realPath), hashComponent = path.relative(fileOrDirectory, symbolicPath).replace(/\\/g, "/");
        if (stat.isSymbolicLink()) {
          const linkTarget = fs.readlinkSync(realPath), resolvedLinkTarget = path.resolve(path.dirname(realPath), linkTarget);
          utils_1.shouldFollow(follow, rootDirectory, resolvedLinkTarget) ? _processFileOrDirectory(symbolicPath, false, resolvedLinkTarget) : _hashField(hash, `link:${hashComponent}`, linkTarget);
        } else if (stat.isFile())
          _hashField(hash, `file:${hashComponent}`, contentFingerprint(realPath));
        else if (stat.isDirectory())
          for (const item of fs.readdirSync(realPath).sort())
            _processFileOrDirectory(path.join(symbolicPath, item), false, path.join(realPath, item));
        else
          throw new Error(`Unable to hash ${symbolicPath}: it is neither a file nor a directory`);
      }
    }
    exports.fingerprint = fingerprint;
    function contentFingerprint(file) {
      const stats = fs.statSync(file, { bigint: true }), cacheKey = JSON.stringify({ mtime_unix: stats.mtime.toUTCString(), mtime_ms: stats.mtimeMs.toString(), inode: stats.ino.toString(), size: stats.size.toString() });
      return fingerprintCache.obtain(cacheKey, () => contentFingerprintMiss(file));
    }
    exports.contentFingerprint = contentFingerprint;
    function contentFingerprintMiss(file) {
      const hash = crypto.createHash("sha256"), buffer = Buffer.alloc(BUFFER_SIZE), fd = fs.openSync(file, fs.constants.O_DSYNC | fs.constants.O_RDONLY | fs.constants.O_SYNC);
      let size = 0, isBinary = false, lastStr = "", read = 0;
      try {
        for (; (read = fs.readSync(fd, buffer, 0, BUFFER_SIZE, null)) !== 0; ) {
          const slicedBuffer = buffer.slice(0, read);
          size === 0 && (isBinary = slicedBuffer.indexOf(0) !== -1);
          let dataBuffer = slicedBuffer;
          if (!isBinary) {
            const str = buffer.slice(0, read).toString();
            if (new RegExp(`${CR}$`).test(str)) {
              lastStr += str;
              continue;
            }
            const normalizedData = (lastStr + str).replace(new RegExp(CRLF, "g"), LF);
            dataBuffer = Buffer.from(normalizedData), lastStr = "";
          }
          size += dataBuffer.length, hash.update(dataBuffer);
        }
        lastStr && hash.update(Buffer.from(lastStr));
      } finally {
        fs.closeSync(fd);
      }
      return `${size}:${hash.digest("hex")}`;
    }
    function _hashField(hash, header, value) {
      hash.update(CTRL_SOH).update(header).update(CTRL_SOT).update(value).update(CTRL_ETX);
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/fs/index.js
var require_fs2 = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/fs/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        p !== "default" && !exports2.hasOwnProperty(p) && __createBinding(exports2, m, p);
    };
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.FileSystem = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs = require("fs");
    var os = require("os");
    var path = require("path");
    var copy_1 = require_copy3();
    var fingerprint_1 = require_fingerprint();
    __exportStar(require_ignore3(), exports), __exportStar(require_options(), exports);
    var FileSystem = class {
      static copyDirectory(srcDir, destDir, options = {}, rootDir) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CopyOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.copyDirectory), error;
        }
        return copy_1.copyDirectory(srcDir, destDir, options, rootDir);
      }
      static fingerprint(fileOrDirectory, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_FingerprintOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.fingerprint), error;
        }
        return fingerprint_1.fingerprint(fileOrDirectory, options);
      }
      static isEmpty(dir) {
        return fs.readdirSync(dir).length === 0;
      }
      static get tmpdir() {
        return FileSystem._tmpdir || (FileSystem._tmpdir = fs.realpathSync(os.tmpdir())), FileSystem._tmpdir;
      }
      static mkdtemp(prefix) {
        return fs.mkdtempSync(path.join(FileSystem.tmpdir, prefix));
      }
    };
    exports.FileSystem = FileSystem, _a = JSII_RTTI_SYMBOL_1, FileSystem[_a] = { fqn: "aws-cdk-lib.FileSystem", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/private/jsii-deprecated.js
var require_jsii_deprecated = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/jsii-deprecated.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.reset = exports.quiet = void 0;
    function quiet() {
      const deprecated = process.env.JSII_DEPRECATED;
      return process.env.JSII_DEPRECATED = "quiet", deprecated;
    }
    exports.quiet = quiet;
    function reset(deprecated) {
      deprecated === void 0 ? delete process.env.JSII_DEPRECATED : process.env.JSII_DEPRECATED = deprecated;
    }
    exports.reset = reset;
  }
});

// node_modules/aws-cdk-lib/core/lib/bundling.js
var require_bundling = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/bundling.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.DockerVolumeConsistency = exports.DockerImage = exports.BundlingDockerImage = exports.BundlingOutput = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var child_process_1 = require("child_process");
    var crypto = require("crypto");
    var path_1 = require("path");
    var fs_1 = require_fs2();
    var jsii_deprecated_1 = require_jsii_deprecated();
    var BundlingOutput;
    (function(BundlingOutput2) {
      BundlingOutput2.ARCHIVED = "archived", BundlingOutput2.NOT_ARCHIVED = "not-archived", BundlingOutput2.AUTO_DISCOVER = "auto-discover";
    })(BundlingOutput = exports.BundlingOutput || (exports.BundlingOutput = {}));
    var BundlingDockerImage = class {
      constructor(image, _imageHash) {
        this.image = image, this._imageHash = _imageHash;
      }
      static fromRegistry(image) {
        return new DockerImage(image);
      }
      static fromAsset(path, options = {}) {
        return DockerImage.fromBuild(path, options);
      }
      toJSON() {
        return this._imageHash ?? this.image;
      }
      run(options = {}) {
        var _a2, _b2;
        const volumes = options.volumes || [], environment = options.environment || {}, entrypoint = ((_a2 = options.entrypoint) == null ? void 0 : _a2[0]) || null, command = [...((_b2 = options.entrypoint) == null ? void 0 : _b2[1]) ? [...options.entrypoint.slice(1)] : [], ...options.command ? [...options.command] : []], dockerArgs = ["run", "--rm", ...options.securityOpt ? ["--security-opt", options.securityOpt] : [], ...options.network ? ["--network", options.network] : [], ...options.user ? ["-u", options.user] : [], ...flatten(volumes.map((v) => ["-v", `${v.hostPath}:${v.containerPath}:${isSeLinux() ? "z," : ""}${v.consistency ?? DockerVolumeConsistency.DELEGATED}`])), ...flatten(Object.entries(environment).map(([k, v]) => ["--env", `${k}=${v}`])), ...options.workingDirectory ? ["-w", options.workingDirectory] : [], ...entrypoint ? ["--entrypoint", entrypoint] : [], this.image, ...command];
        dockerExec(dockerArgs);
      }
      cp(imagePath, outputPath) {
        const { stdout } = dockerExec(["create", this.image], {}), match = stdout.toString().match(/([0-9a-f]{16,})/);
        if (!match)
          throw new Error("Failed to extract container ID from Docker create output");
        const containerId = match[1], containerPath = `${containerId}:${imagePath}`, destPath = outputPath ?? fs_1.FileSystem.mkdtemp("cdk-docker-cp-");
        try {
          return dockerExec(["cp", containerPath, destPath]), destPath;
        } catch (err) {
          throw new Error(`Failed to copy files from ${containerPath} to ${destPath}: ${err}`);
        } finally {
          dockerExec(["rm", "-v", containerId]);
        }
      }
    };
    exports.BundlingDockerImage = BundlingDockerImage, _a = JSII_RTTI_SYMBOL_1, BundlingDockerImage[_a] = { fqn: "aws-cdk-lib.BundlingDockerImage", version: "2.50.0" };
    var DockerImage = class extends BundlingDockerImage {
      constructor(image, _imageHash) {
        const deprecated = jsii_deprecated_1.quiet();
        super(image, _imageHash), jsii_deprecated_1.reset(deprecated), this.image = image;
      }
      static fromBuild(path, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_DockerBuildOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.fromBuild), error;
        }
        const buildArgs = options.buildArgs || {};
        if (options.file && path_1.isAbsolute(options.file))
          throw new Error(`"file" must be relative to the docker build directory. Got ${options.file}`);
        const input = JSON.stringify({ path, ...options }), tag = `cdk-${crypto.createHash("sha256").update(input).digest("hex")}`, dockerArgs = ["build", "-t", tag, ...options.file ? ["-f", path_1.join(path, options.file)] : [], ...options.platform ? ["--platform", options.platform] : [], ...options.targetStage ? ["--target", options.targetStage] : [], ...flatten(Object.entries(buildArgs).map(([k, v]) => ["--build-arg", `${k}=${v}`])), path];
        dockerExec(dockerArgs);
        const hash = fs_1.FileSystem.fingerprint(path, { extraHash: JSON.stringify(options) });
        return new DockerImage(tag, hash);
      }
      static fromRegistry(image) {
        return new DockerImage(image);
      }
      toJSON() {
        const deprecated = jsii_deprecated_1.quiet(), json = super.toJSON();
        return jsii_deprecated_1.reset(deprecated), json;
      }
      run(options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_DockerRunOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.run), error;
        }
        const deprecated = jsii_deprecated_1.quiet(), result = super.run(options);
        return jsii_deprecated_1.reset(deprecated), result;
      }
      cp(imagePath, outputPath) {
        const deprecated = jsii_deprecated_1.quiet(), result = super.cp(imagePath, outputPath);
        return jsii_deprecated_1.reset(deprecated), result;
      }
    };
    exports.DockerImage = DockerImage, _b = JSII_RTTI_SYMBOL_1, DockerImage[_b] = { fqn: "aws-cdk-lib.DockerImage", version: "2.50.0" };
    var DockerVolumeConsistency;
    (function(DockerVolumeConsistency2) {
      DockerVolumeConsistency2.CONSISTENT = "consistent", DockerVolumeConsistency2.DELEGATED = "delegated", DockerVolumeConsistency2.CACHED = "cached";
    })(DockerVolumeConsistency = exports.DockerVolumeConsistency || (exports.DockerVolumeConsistency = {}));
    function flatten(x) {
      return Array.prototype.concat([], ...x);
    }
    function dockerExec(args, options) {
      var _a2, _b2;
      const prog = process.env.CDK_DOCKER ?? "docker", proc = child_process_1.spawnSync(prog, args, options ?? { stdio: ["ignore", process.stderr, "inherit"] });
      if (proc.error)
        throw proc.error;
      if (proc.status !== 0)
        throw proc.stdout || proc.stderr ? new Error(`[Status ${proc.status}] stdout: ${(_a2 = proc.stdout) == null ? void 0 : _a2.toString().trim()}


stderr: ${(_b2 = proc.stderr) == null ? void 0 : _b2.toString().trim()}`) : new Error(`${prog} exited with status ${proc.status}`);
      return proc;
    }
    function isSeLinux() {
      if (process.platform != "linux")
        return false;
      const prog = "selinuxenabled", proc = child_process_1.spawnSync(prog, [], { stdio: ["pipe", process.stderr, "inherit"] });
      return proc.error ? false : proc.status == 0;
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/asset-staging.js
var require_asset_staging = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/asset-staging.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.AssetStaging = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var crypto = require("crypto");
    var os = require("os");
    var path = require("path");
    var cxapi = require_cx_api();
    var constructs_1 = require_lib4();
    var fs = require_lib5();
    var assets_1 = require_assets3();
    var bundling_1 = require_bundling();
    var fs_1 = require_fs2();
    var fingerprint_1 = require_fingerprint();
    var names_1 = require_names();
    var cache_1 = require_cache();
    var stack_1 = require_stack();
    var stage_1 = require_stage();
    var ARCHIVE_EXTENSIONS = [".tar.gz", ".zip", ".jar", ".tar", ".tgz"];
    var ASSET_SALT_CONTEXT_KEY = "@aws-cdk/core:assetHashSalt";
    var AssetStaging = class extends constructs_1.Construct {
      constructor(scope, id, props) {
        var _a2;
        super(scope, id);
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_AssetStagingProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, AssetStaging), error;
        }
        const salt = this.node.tryGetContext(ASSET_SALT_CONTEXT_KEY);
        if (this.sourcePath = path.resolve(props.sourcePath), this.fingerprintOptions = { ...props, extraHash: props.extraHash || salt ? `${props.extraHash ?? ""}${salt ?? ""}` : void 0 }, !fs.existsSync(this.sourcePath))
          throw new Error(`Cannot find asset at ${this.sourcePath}`);
        this.sourceStats = fs.statSync(this.sourcePath);
        const outdir = (_a2 = stage_1.Stage.of(this)) == null ? void 0 : _a2.assetOutdir;
        if (!outdir)
          throw new Error('unable to determine cloud assembly asset output directory. Assets must be defined indirectly within a "Stage" or an "App" scope');
        this.assetOutdir = outdir, this.customSourceFingerprint = props.assetHash, this.hashType = determineHashType(props.assetHashType, this.customSourceFingerprint);
        let stageThisAsset, skip = false;
        if (props.bundling) {
          skip = !stack_1.Stack.of(this).bundlingRequired;
          const bundling = props.bundling;
          stageThisAsset = () => this.stageByBundling(bundling, skip);
        } else
          stageThisAsset = () => this.stageByCopying();
        this.cacheKey = calculateCacheKey({ outdir: this.assetOutdir, sourcePath: path.resolve(props.sourcePath), bundling: props.bundling, assetHashType: this.hashType, customFingerprint: this.customSourceFingerprint, extraHash: props.extraHash, exclude: props.exclude, ignoreMode: props.ignoreMode, skip });
        const staged = AssetStaging.assetCache.obtain(this.cacheKey, stageThisAsset);
        this.stagedPath = staged.stagedPath, this.absoluteStagedPath = staged.stagedPath, this.assetHash = staged.assetHash, this.packaging = staged.packaging, this.isArchive = staged.isArchive;
      }
      static clearAssetHashCache() {
        this.assetCache.clear(), fingerprint_1.clearLargeFileFingerprintCache();
      }
      get sourceHash() {
        return this.assetHash;
      }
      relativeStagedPath(stack) {
        var _a2;
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.relativeStagedPath), error;
        }
        const asmManifestDir = (_a2 = stage_1.Stage.of(stack)) == null ? void 0 : _a2.outdir;
        return asmManifestDir ? path.relative(this.assetOutdir, this.stagedPath).startsWith("..") || this.stagingDisabled ? this.stagedPath : path.relative(asmManifestDir, this.stagedPath) : this.stagedPath;
      }
      stageByCopying() {
        const assetHash = this.calculateHash(this.hashType), stagedPath = this.stagingDisabled ? this.sourcePath : path.resolve(this.assetOutdir, renderAssetFilename(assetHash, getExtension(this.sourcePath)));
        if (!this.sourceStats.isDirectory() && !this.sourceStats.isFile())
          throw new Error(`Asset ${this.sourcePath} is expected to be either a directory or a regular file`);
        return this.stageAsset(this.sourcePath, stagedPath, "copy"), { assetHash, stagedPath, packaging: this.sourceStats.isDirectory() ? assets_1.FileAssetPackaging.ZIP_DIRECTORY : assets_1.FileAssetPackaging.FILE, isArchive: this.sourceStats.isDirectory() || ARCHIVE_EXTENSIONS.includes(getExtension(this.sourcePath).toLowerCase()) };
      }
      stageByBundling(bundling, skip) {
        if (!this.sourceStats.isDirectory())
          throw new Error(`Asset ${this.sourcePath} is expected to be a directory when bundling`);
        if (skip) {
          let hashType = this.hashType;
          return (hashType === assets_1.AssetHashType.OUTPUT || hashType === assets_1.AssetHashType.BUNDLE) && (this.customSourceFingerprint = names_1.Names.uniqueId(this), hashType = assets_1.AssetHashType.CUSTOM), { assetHash: this.calculateHash(hashType, bundling), stagedPath: this.sourcePath, packaging: assets_1.FileAssetPackaging.ZIP_DIRECTORY, isArchive: true };
        }
        let assetHash = this.hashType === assets_1.AssetHashType.SOURCE || this.hashType === assets_1.AssetHashType.CUSTOM ? this.calculateHash(this.hashType, bundling) : void 0;
        const bundleDir = this.determineBundleDir(this.assetOutdir, assetHash);
        this.bundle(bundling, bundleDir);
        const bundlingOutputType = bundling.outputType ?? bundling_1.BundlingOutput.AUTO_DISCOVER, bundledAsset = determineBundledAsset(bundleDir, bundlingOutputType);
        assetHash = assetHash ?? this.calculateHash(this.hashType, bundling, bundledAsset.path);
        const stagedPath = path.resolve(this.assetOutdir, renderAssetFilename(assetHash, bundledAsset.extension));
        return this.stageAsset(bundledAsset.path, stagedPath, "move"), bundledAsset.packaging === assets_1.FileAssetPackaging.FILE && fs.closeSync(fs.openSync(bundledAsset.path, "w")), { assetHash, stagedPath, packaging: bundledAsset.packaging, isArchive: true };
      }
      get stagingDisabled() {
        return !!this.node.tryGetContext(cxapi.DISABLE_ASSET_STAGING_CONTEXT);
      }
      stageAsset(sourcePath, targetPath, style) {
        if (fs.existsSync(targetPath)) {
          style === "move" && sourcePath !== targetPath && fs.removeSync(sourcePath);
          return;
        }
        if (style == "move") {
          fs.renameSync(sourcePath, targetPath);
          return;
        }
        if (this.sourceStats.isFile())
          fs.copyFileSync(sourcePath, targetPath);
        else if (this.sourceStats.isDirectory())
          fs.mkdirSync(targetPath), fs_1.FileSystem.copyDirectory(sourcePath, targetPath, this.fingerprintOptions);
        else
          throw new Error(`Unknown file type: ${sourcePath}`);
      }
      determineBundleDir(outdir, sourceHash) {
        return sourceHash ? path.resolve(outdir, renderAssetFilename(sourceHash)) : path.resolve(outdir, `bundling-temp-${this.cacheKey}`);
      }
      bundle(options, bundleDir) {
        var _a2;
        if (fs.existsSync(bundleDir))
          return;
        fs.ensureDirSync(bundleDir), fs.chmodSync(bundleDir, 511);
        const volumes = [{ hostPath: this.sourcePath, containerPath: AssetStaging.BUNDLING_INPUT_DIR }, { hostPath: bundleDir, containerPath: AssetStaging.BUNDLING_OUTPUT_DIR }, ...options.volumes ?? []];
        let localBundling;
        try {
          if (process.stderr.write(`Bundling asset ${this.node.path}...
`), localBundling = (_a2 = options.local) == null ? void 0 : _a2.tryBundle(bundleDir, options), !localBundling) {
            let user;
            if (options.user)
              user = options.user;
            else {
              const userInfo = os.userInfo();
              user = userInfo.uid !== -1 ? `${userInfo.uid}:${userInfo.gid}` : "1000:1000";
            }
            options.image.run({ command: options.command, user, volumes, environment: options.environment, entrypoint: options.entrypoint, workingDirectory: options.workingDirectory ?? AssetStaging.BUNDLING_INPUT_DIR, securityOpt: options.securityOpt ?? "" });
          }
        } catch (err) {
          const bundleErrorDir = bundleDir + "-error";
          throw fs.existsSync(bundleErrorDir) && fs.removeSync(bundleErrorDir), fs.renameSync(bundleDir, bundleErrorDir), new Error(`Failed to bundle asset ${this.node.path}, bundle output is located at ${bundleErrorDir}: ${err}`);
        }
        if (fs_1.FileSystem.isEmpty(bundleDir)) {
          const outputDir = localBundling ? bundleDir : AssetStaging.BUNDLING_OUTPUT_DIR;
          throw new Error(`Bundling did not produce any output. Check that content is written to ${outputDir}.`);
        }
      }
      calculateHash(hashType, bundling, outputDir) {
        if (hashType == assets_1.AssetHashType.CUSTOM || hashType == assets_1.AssetHashType.SOURCE && bundling) {
          const hash = crypto.createHash("sha256");
          return hash.update(this.customSourceFingerprint ?? fs_1.FileSystem.fingerprint(this.sourcePath, this.fingerprintOptions)), bundling && hash.update(JSON.stringify(bundling)), hash.digest("hex");
        }
        switch (hashType) {
          case assets_1.AssetHashType.SOURCE:
            return fs_1.FileSystem.fingerprint(this.sourcePath, this.fingerprintOptions);
          case assets_1.AssetHashType.BUNDLE:
          case assets_1.AssetHashType.OUTPUT:
            if (!outputDir)
              throw new Error(`Cannot use \`${hashType}\` hash type when \`bundling\` is not specified.`);
            return fs_1.FileSystem.fingerprint(outputDir, this.fingerprintOptions);
          default:
            throw new Error("Unknown asset hash type.");
        }
      }
    };
    exports.AssetStaging = AssetStaging, _a = JSII_RTTI_SYMBOL_1, AssetStaging[_a] = { fqn: "aws-cdk-lib.AssetStaging", version: "2.50.0" }, AssetStaging.BUNDLING_INPUT_DIR = "/asset-input", AssetStaging.BUNDLING_OUTPUT_DIR = "/asset-output", AssetStaging.assetCache = new cache_1.Cache();
    function renderAssetFilename(assetHash, extension = "") {
      return `asset.${assetHash}${extension}`;
    }
    function determineHashType(assetHashType, customSourceFingerprint) {
      const hashType = customSourceFingerprint ? assetHashType ?? assets_1.AssetHashType.CUSTOM : assetHashType ?? assets_1.AssetHashType.SOURCE;
      if (customSourceFingerprint && hashType !== assets_1.AssetHashType.CUSTOM)
        throw new Error(`Cannot specify \`${assetHashType}\` for \`assetHashType\` when \`assetHash\` is specified. Use \`CUSTOM\` or leave \`undefined\`.`);
      if (hashType === assets_1.AssetHashType.CUSTOM && !customSourceFingerprint)
        throw new Error("`assetHash` must be specified when `assetHashType` is set to `AssetHashType.CUSTOM`.");
      return hashType;
    }
    function calculateCacheKey(props) {
      return crypto.createHash("sha256").update(JSON.stringify(sortObject(props))).digest("hex");
    }
    function sortObject(object) {
      if (typeof object != "object" || object instanceof Array)
        return object;
      const ret = {};
      for (const key of Object.keys(object).sort())
        ret[key] = sortObject(object[key]);
      return ret;
    }
    function singleArchiveFile(directory) {
      if (!fs.existsSync(directory))
        throw new Error(`Directory ${directory} does not exist.`);
      if (!fs.statSync(directory).isDirectory())
        throw new Error(`${directory} is not a directory.`);
      const content = fs.readdirSync(directory);
      if (content.length === 1) {
        const file = path.join(directory, content[0]), extension = getExtension(content[0]).toLowerCase();
        if (fs.statSync(file).isFile() && ARCHIVE_EXTENSIONS.includes(extension))
          return file;
      }
    }
    function determineBundledAsset(bundleDir, outputType) {
      const archiveFile = singleArchiveFile(bundleDir);
      switch (outputType === bundling_1.BundlingOutput.AUTO_DISCOVER && (outputType = archiveFile ? bundling_1.BundlingOutput.ARCHIVED : bundling_1.BundlingOutput.NOT_ARCHIVED), outputType) {
        case bundling_1.BundlingOutput.NOT_ARCHIVED:
          return { path: bundleDir, packaging: assets_1.FileAssetPackaging.ZIP_DIRECTORY };
        case bundling_1.BundlingOutput.ARCHIVED:
          if (!archiveFile)
            throw new Error("Bundling output directory is expected to include only a single archive file when `output` is set to `ARCHIVED`");
          return { path: archiveFile, packaging: assets_1.FileAssetPackaging.FILE, extension: getExtension(archiveFile) };
      }
    }
    function getExtension(source) {
      for (const ext of ARCHIVE_EXTENSIONS)
        if (source.toLowerCase().endsWith(ext))
          return ext;
      return path.extname(source);
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/duration.js
var require_duration = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/duration.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.Duration = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var token_1 = require_token();
    var Duration = class {
      constructor(amount, unit) {
        if (!token_1.Token.isUnresolved(amount) && amount < 0)
          throw new Error(`Duration amounts cannot be negative. Received: ${amount}`);
        this.amount = amount, this.unit = unit;
      }
      static millis(amount) {
        return new Duration(amount, TimeUnit.Milliseconds);
      }
      static seconds(amount) {
        return new Duration(amount, TimeUnit.Seconds);
      }
      static minutes(amount) {
        return new Duration(amount, TimeUnit.Minutes);
      }
      static hours(amount) {
        return new Duration(amount, TimeUnit.Hours);
      }
      static days(amount) {
        return new Duration(amount, TimeUnit.Days);
      }
      static parse(duration) {
        const matches = duration.match(/^P(?:(\d+)D)?(?:T(?:(\d+)H)?(?:(\d+)M)?(?:(\d+)S)?)?$/);
        if (!matches)
          throw new Error(`Not a valid ISO duration: ${duration}`);
        const [, days, hours, minutes, seconds] = matches;
        if (!days && !hours && !minutes && !seconds)
          throw new Error(`Not a valid ISO duration: ${duration}`);
        return Duration.millis(_toInt(seconds) * TimeUnit.Seconds.inMillis + _toInt(minutes) * TimeUnit.Minutes.inMillis + _toInt(hours) * TimeUnit.Hours.inMillis + _toInt(days) * TimeUnit.Days.inMillis);
        function _toInt(str) {
          return str ? Number(str) : 0;
        }
      }
      plus(rhs) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_Duration(rhs);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.plus), error;
        }
        const targetUnit = finestUnit(this.unit, rhs.unit), res = convert(this.amount, this.unit, targetUnit, {}) + convert(rhs.amount, rhs.unit, targetUnit, {});
        return new Duration(res, targetUnit);
      }
      minus(rhs) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_Duration(rhs);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.minus), error;
        }
        const targetUnit = finestUnit(this.unit, rhs.unit), res = convert(this.amount, this.unit, targetUnit, {}) - convert(rhs.amount, rhs.unit, targetUnit, {});
        return new Duration(res, targetUnit);
      }
      toMilliseconds(opts = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TimeConversionOptions(opts);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.toMilliseconds), error;
        }
        return convert(this.amount, this.unit, TimeUnit.Milliseconds, opts);
      }
      toSeconds(opts = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TimeConversionOptions(opts);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.toSeconds), error;
        }
        return convert(this.amount, this.unit, TimeUnit.Seconds, opts);
      }
      toMinutes(opts = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TimeConversionOptions(opts);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.toMinutes), error;
        }
        return convert(this.amount, this.unit, TimeUnit.Minutes, opts);
      }
      toHours(opts = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TimeConversionOptions(opts);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.toHours), error;
        }
        return convert(this.amount, this.unit, TimeUnit.Hours, opts);
      }
      toDays(opts = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TimeConversionOptions(opts);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.toDays), error;
        }
        return convert(this.amount, this.unit, TimeUnit.Days, opts);
      }
      toIsoString() {
        if (this.amount === 0)
          return "PT0S";
        const ret = ["P"];
        let tee = false;
        for (const [amount, unit] of this.components(true))
          [TimeUnit.Seconds, TimeUnit.Minutes, TimeUnit.Hours].includes(unit) && !tee && (ret.push("T"), tee = true), ret.push(`${amount}${unit.isoLabel}`);
        return ret.join("");
      }
      toISOString() {
        return this.toIsoString();
      }
      toHumanString() {
        if (this.amount === 0)
          return fmtUnit(0, this.unit);
        if (token_1.Token.isUnresolved(this.amount))
          return `<token> ${this.unit.label}`;
        return this.components(false).slice(0, 2).map(([amount, unit]) => fmtUnit(amount, unit)).join(" ");
        function fmtUnit(amount, unit) {
          return amount === 1 ? `${amount} ${unit.label.substring(0, unit.label.length - 1)}` : `${amount} ${unit.label}`;
        }
      }
      toString() {
        return `Duration.${this.unit.label}(${this.amount})`;
      }
      components(combineMillisWithSeconds) {
        const ret = new Array();
        let millis = convert(this.amount, this.unit, TimeUnit.Milliseconds, { integral: false });
        for (const unit of [TimeUnit.Days, TimeUnit.Hours, TimeUnit.Minutes, TimeUnit.Seconds]) {
          const count = convert(millis, TimeUnit.Milliseconds, unit, { integral: false }), wholeCount = unit === TimeUnit.Seconds && combineMillisWithSeconds ? count : Math.floor(count);
          wholeCount > 0 && (ret.push([wholeCount, unit]), millis -= wholeCount * unit.inMillis);
        }
        return millis > 0 && ret.push([millis, TimeUnit.Milliseconds]), ret;
      }
      isUnresolved() {
        return token_1.Token.isUnresolved(this.amount);
      }
      unitLabel() {
        return this.unit.label;
      }
      formatTokenToNumber() {
        return `${token_1.Tokenization.stringifyNumber(this.amount)} ${this.unit.label}`;
      }
    };
    exports.Duration = Duration, _a = JSII_RTTI_SYMBOL_1, Duration[_a] = { fqn: "aws-cdk-lib.Duration", version: "2.50.0" };
    var TimeUnit = class {
      constructor(label, isoLabel, inMillis) {
        this.label = label, this.isoLabel = isoLabel, this.inMillis = inMillis;
      }
      toString() {
        return this.label;
      }
    };
    TimeUnit.Milliseconds = new TimeUnit("millis", "", 1), TimeUnit.Seconds = new TimeUnit("seconds", "S", 1e3), TimeUnit.Minutes = new TimeUnit("minutes", "M", 6e4), TimeUnit.Hours = new TimeUnit("hours", "H", 36e5), TimeUnit.Days = new TimeUnit("days", "D", 864e5);
    function convert(amount, fromUnit, toUnit, { integral = true }) {
      if (fromUnit.inMillis === toUnit.inMillis) {
        if (integral && !token_1.Token.isUnresolved(amount) && !Number.isInteger(amount))
          throw new Error(`${amount} must be a whole number of ${toUnit}.`);
        return amount;
      }
      if (token_1.Token.isUnresolved(amount))
        throw new Error(`Duration must be specified as 'Duration.${toUnit}()' here since its value comes from a token and cannot be converted (got Duration.${fromUnit})`);
      const value = amount * fromUnit.inMillis / toUnit.inMillis;
      if (!Number.isInteger(value) && integral)
        throw new Error(`'${amount} ${fromUnit}' cannot be converted into a whole number of ${toUnit}.`);
      return value;
    }
    function finestUnit(a, b) {
      return a.inMillis < b.inMillis ? a : b;
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/size.js
var require_size = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/size.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.SizeRoundingBehavior = exports.Size = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var token_1 = require_token();
    var Size = class {
      constructor(amount, unit) {
        if (!token_1.Token.isUnresolved(amount) && amount < 0)
          throw new Error(`Storage amounts cannot be negative. Received: ${amount}`);
        this.amount = amount, this.unit = unit;
      }
      static kibibytes(amount) {
        return new Size(amount, StorageUnit.Kibibytes);
      }
      static mebibytes(amount) {
        return new Size(amount, StorageUnit.Mebibytes);
      }
      static gibibytes(amount) {
        return new Size(amount, StorageUnit.Gibibytes);
      }
      static tebibytes(amount) {
        return new Size(amount, StorageUnit.Tebibytes);
      }
      static pebibyte(amount) {
        return Size.pebibytes(amount);
      }
      static pebibytes(amount) {
        return new Size(amount, StorageUnit.Pebibytes);
      }
      toKibibytes(opts = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_SizeConversionOptions(opts);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.toKibibytes), error;
        }
        return convert(this.amount, this.unit, StorageUnit.Kibibytes, opts);
      }
      toMebibytes(opts = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_SizeConversionOptions(opts);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.toMebibytes), error;
        }
        return convert(this.amount, this.unit, StorageUnit.Mebibytes, opts);
      }
      toGibibytes(opts = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_SizeConversionOptions(opts);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.toGibibytes), error;
        }
        return convert(this.amount, this.unit, StorageUnit.Gibibytes, opts);
      }
      toTebibytes(opts = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_SizeConversionOptions(opts);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.toTebibytes), error;
        }
        return convert(this.amount, this.unit, StorageUnit.Tebibytes, opts);
      }
      toPebibytes(opts = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_SizeConversionOptions(opts);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.toPebibytes), error;
        }
        return convert(this.amount, this.unit, StorageUnit.Pebibytes, opts);
      }
      isUnresolved() {
        return token_1.Token.isUnresolved(this.amount);
      }
    };
    exports.Size = Size, _a = JSII_RTTI_SYMBOL_1, Size[_a] = { fqn: "aws-cdk-lib.Size", version: "2.50.0" };
    var SizeRoundingBehavior;
    (function(SizeRoundingBehavior2) {
      SizeRoundingBehavior2[SizeRoundingBehavior2.FAIL = 0] = "FAIL", SizeRoundingBehavior2[SizeRoundingBehavior2.FLOOR = 1] = "FLOOR", SizeRoundingBehavior2[SizeRoundingBehavior2.NONE = 2] = "NONE";
    })(SizeRoundingBehavior = exports.SizeRoundingBehavior || (exports.SizeRoundingBehavior = {}));
    var StorageUnit = class {
      constructor(label, inKibiBytes) {
        this.label = label, this.inKibiBytes = inKibiBytes;
      }
      toString() {
        return this.label;
      }
    };
    StorageUnit.Kibibytes = new StorageUnit("kibibytes", 1), StorageUnit.Mebibytes = new StorageUnit("mebibytes", 1024), StorageUnit.Gibibytes = new StorageUnit("gibibytes", 1024 * 1024), StorageUnit.Tebibytes = new StorageUnit("tebibytes", 1024 * 1024 * 1024), StorageUnit.Pebibytes = new StorageUnit("pebibytes", 1024 * 1024 * 1024 * 1024);
    function convert(amount, fromUnit, toUnit, options = {}) {
      const rounding = options.rounding ?? SizeRoundingBehavior.FAIL;
      if (fromUnit.inKibiBytes === toUnit.inKibiBytes)
        return amount;
      if (token_1.Token.isUnresolved(amount))
        throw new Error(`Size must be specified as 'Size.${toUnit}()' here since its value comes from a token and cannot be converted (got Size.${fromUnit})`);
      const multiplier = fromUnit.inKibiBytes / toUnit.inKibiBytes, value = amount * multiplier;
      switch (rounding) {
        case SizeRoundingBehavior.NONE:
          return value;
        case SizeRoundingBehavior.FLOOR:
          return Math.floor(value);
        default:
        case SizeRoundingBehavior.FAIL:
          if (!Number.isInteger(value))
            throw new Error(`'${amount} ${fromUnit}' cannot be converted into a whole number of ${toUnit}.`);
          return value;
      }
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/custom-resource-provider/custom-resource-provider.js
var require_custom_resource_provider = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/custom-resource-provider/custom-resource-provider.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CustomResourceProvider = exports.CustomResourceProviderRuntime = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs = require("fs");
    var path = require("path");
    var cxapi = require_cx_api();
    var constructs_1 = require_lib4();
    var fse = require_lib5();
    var asset_staging_1 = require_asset_staging();
    var assets_1 = require_assets3();
    var cfn_resource_1 = require_cfn_resource();
    var duration_1 = require_duration();
    var fs_1 = require_fs2();
    var lazy_1 = require_lazy();
    var size_1 = require_size();
    var stack_1 = require_stack();
    var token_1 = require_token();
    var ENTRYPOINT_FILENAME = "__entrypoint__";
    var ENTRYPOINT_NODEJS_SOURCE = path.join(__dirname, "nodejs-entrypoint.js");
    var CustomResourceProviderRuntime;
    (function(CustomResourceProviderRuntime2) {
      CustomResourceProviderRuntime2.NODEJS_12_X = "nodejs12.x", CustomResourceProviderRuntime2.NODEJS_12 = "deprecated_nodejs12.x", CustomResourceProviderRuntime2.NODEJS_14_X = "nodejs14.x", CustomResourceProviderRuntime2.NODEJS_16_X = "nodejs16.x";
    })(CustomResourceProviderRuntime = exports.CustomResourceProviderRuntime || (exports.CustomResourceProviderRuntime = {}));
    var CustomResourceProvider = class extends constructs_1.Construct {
      constructor(scope, id, props) {
        super(scope, id);
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CustomResourceProviderProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CustomResourceProvider), error;
        }
        const stack = stack_1.Stack.of(scope);
        if (!fs.existsSync(path.join(props.codeDirectory, "index.js")))
          throw new Error(`cannot find ${props.codeDirectory}/index.js`);
        const stagingDirectory = fs_1.FileSystem.mkdtemp("cdk-custom-resource");
        fse.copySync(props.codeDirectory, stagingDirectory, { filter: (src, _dest) => !src.endsWith(".ts") }), fs.copyFileSync(ENTRYPOINT_NODEJS_SOURCE, path.join(stagingDirectory, `${ENTRYPOINT_FILENAME}.js`));
        const staging = new asset_staging_1.AssetStaging(this, "Staging", { sourcePath: stagingDirectory }), assetFileName = staging.relativeStagedPath(stack), asset = stack.synthesizer.addFileAsset({ fileName: assetFileName, sourceHash: staging.assetHash, packaging: assets_1.FileAssetPackaging.ZIP_DIRECTORY });
        if (props.policyStatements)
          for (const statement of props.policyStatements)
            this.addToRolePolicy(statement);
        const role = new cfn_resource_1.CfnResource(this, "Role", { type: "AWS::IAM::Role", properties: { AssumeRolePolicyDocument: { Version: "2012-10-17", Statement: [{ Action: "sts:AssumeRole", Effect: "Allow", Principal: { Service: "lambda.amazonaws.com" } }] }, ManagedPolicyArns: [{ "Fn::Sub": "arn:${AWS::Partition}:iam::aws:policy/service-role/AWSLambdaBasicExecutionRole" }], Policies: lazy_1.Lazy.any({ produce: () => this.renderPolicies() }) } });
        this.roleArn = token_1.Token.asString(role.getAtt("Arn"));
        const timeout = props.timeout ?? duration_1.Duration.minutes(15), memory = props.memorySize ?? size_1.Size.mebibytes(128), handler2 = new cfn_resource_1.CfnResource(this, "Handler", { type: "AWS::Lambda::Function", properties: { Code: { S3Bucket: asset.bucketName, S3Key: asset.objectKey }, Timeout: timeout.toSeconds(), MemorySize: memory.toMebibytes(), Handler: `${ENTRYPOINT_FILENAME}.handler`, Role: role.getAtt("Arn"), Runtime: customResourceProviderRuntimeToString(props.runtime), Environment: this.renderEnvironmentVariables(props.environment), Description: props.description ?? void 0 } });
        handler2.addDependsOn(role), this.node.tryGetContext(cxapi.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT) && (handler2.addMetadata(cxapi.ASSET_RESOURCE_METADATA_PATH_KEY, assetFileName), handler2.addMetadata(cxapi.ASSET_RESOURCE_METADATA_PROPERTY_KEY, "Code")), this.serviceToken = token_1.Token.asString(handler2.getAtt("Arn"));
      }
      static getOrCreate(scope, uniqueid, props) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CustomResourceProviderProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.getOrCreate), error;
        }
        return this.getOrCreateProvider(scope, uniqueid, props).serviceToken;
      }
      static getOrCreateProvider(scope, uniqueid, props) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CustomResourceProviderProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.getOrCreateProvider), error;
        }
        const id = `${uniqueid}CustomResourceProvider`, stack = stack_1.Stack.of(scope);
        return stack.node.tryFindChild(id) ?? new CustomResourceProvider(stack, id, props);
      }
      addToRolePolicy(statement) {
        this.policyStatements || (this.policyStatements = []), this.policyStatements.push(statement);
      }
      renderPolicies() {
        return this.policyStatements ? [{ PolicyName: "Inline", PolicyDocument: { Version: "2012-10-17", Statement: this.policyStatements } }] : void 0;
      }
      renderEnvironmentVariables(env) {
        if (!env || Object.keys(env).length === 0)
          return;
        env = { ...env }, env.AWS_STS_REGIONAL_ENDPOINTS = "regional";
        const variables = {}, keys = Object.keys(env).sort();
        for (const key of keys)
          variables[key] = env[key];
        return { Variables: variables };
      }
    };
    exports.CustomResourceProvider = CustomResourceProvider, _a = JSII_RTTI_SYMBOL_1, CustomResourceProvider[_a] = { fqn: "aws-cdk-lib.CustomResourceProvider", version: "2.50.0" };
    function customResourceProviderRuntimeToString(x) {
      switch (x) {
        case CustomResourceProviderRuntime.NODEJS_12:
        case CustomResourceProviderRuntime.NODEJS_12_X:
          return "nodejs12.x";
        case CustomResourceProviderRuntime.NODEJS_14_X:
          return "nodejs14.x";
        case CustomResourceProviderRuntime.NODEJS_16_X:
          return "nodejs16.x";
      }
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/custom-resource-provider/index.js
var require_custom_resource_provider2 = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/custom-resource-provider/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        p !== "default" && !exports2.hasOwnProperty(p) && __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true }), __exportStar(require_custom_resource_provider(), exports);
  }
});

// node_modules/aws-cdk-lib/core/lib/private/cfn-utils-provider.js
var require_cfn_utils_provider = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/cfn-utils-provider.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CfnUtils = exports.CfnUtilsProvider = void 0;
    var constructs_1 = require_lib4();
    var custom_resource_1 = require_custom_resource();
    var custom_resource_provider_1 = require_custom_resource_provider2();
    var CfnUtilsProvider = class extends constructs_1.Construct {
      static getOrCreate(scope) {
        return custom_resource_provider_1.CustomResourceProvider.getOrCreate(scope, "AWSCDKCfnUtilsProvider", { runtime: custom_resource_provider_1.CustomResourceProviderRuntime.NODEJS_14_X, codeDirectory: `${__dirname}/cfn-utils-provider` });
      }
    };
    exports.CfnUtilsProvider = CfnUtilsProvider;
    var CfnUtils = class {
      static stringify(scope, id, value) {
        return new custom_resource_1.CustomResource(scope, id, { serviceToken: CfnUtilsProvider.getOrCreate(scope), resourceType: "Custom::AWSCDKCfnJsonStringify", properties: { Value: value } }).getAttString("Value");
      }
    };
    exports.CfnUtils = CfnUtils;
  }
});

// node_modules/aws-cdk-lib/core/lib/private/cloudformation-lang.js
var require_cloudformation_lang = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/cloudformation-lang.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.isNameOfCloudFormationIntrinsic = exports.minimalCloudFormationJoin = exports.CLOUDFORMATION_TOKEN_RESOLVER = exports.CloudFormationLang = void 0;
    var lazy_1 = require_lazy();
    var resolvable_1 = require_resolvable();
    var stack_1 = require_stack();
    var token_1 = require_token();
    var cfn_utils_provider_1 = require_cfn_utils_provider();
    var resolve_1 = require_resolve();
    var CloudFormationLang = class {
      static toJSON(obj, space) {
        return lazy_1.Lazy.uncachedString({ produce: (ctx) => tokenAwareStringify(obj, space ?? 0, ctx) });
      }
      static concat(left, right) {
        if (left === void 0 && right === void 0)
          return "";
        const parts = new Array();
        return left !== void 0 && parts.push(left), right !== void 0 && parts.push(right), parts.length === 1 ? parts[0] : parts.length === 2 && isConcatable(parts[0]) && isConcatable(parts[1]) ? `${parts[0]}${parts[1]}` : fnJoinConcat(parts);
      }
    };
    exports.CloudFormationLang = CloudFormationLang;
    function fnJoinConcat(parts) {
      return { "Fn::Join": ["", minimalCloudFormationJoin("", parts)] };
    }
    function tokenAwareStringify(root, space, ctx) {
      let indent = 0;
      const ret = new Array();
      switch (recurse(ctx.resolve(root, { allowIntrinsicKeys: true })), ret.length) {
        case 0:
          return;
        case 1:
          return renderSegment(ret[0]);
        default:
          return fnJoinConcat(ret.map(renderSegment));
      }
      function recurse(obj) {
        if (obj !== void 0) {
          if (token_1.Token.isUnresolved(obj))
            throw new Error("This shouldnt happen anymore");
          if (Array.isArray(obj))
            return renderCollection("[", "]", obj, recurse);
          if (typeof obj == "object" && obj != null && !(obj instanceof Date)) {
            if (isIntrinsic(obj) && resolve_1.resolvedTypeHint(obj)) {
              renderIntrinsic(obj);
              return;
            }
            return renderCollection("{", "}", definedEntries(obj), ([key, value]) => {
              key.startsWith(resolve_1.INTRINSIC_KEY_PREFIX) && ([key, value] = value), recurse(key), pushLiteral(prettyPunctuation(":")), recurse(value);
            });
          }
          pushLiteral(JSON.stringify(obj));
        }
      }
      function renderCollection(pre, post, xs, each) {
        pushLiteral(pre), indent += space;
        let atLeastOne = false;
        for (const [comma, item] of sepIter(xs))
          comma && pushLiteral(","), pushLineBreak(), each(item), atLeastOne = true;
        indent -= space, atLeastOne && pushLineBreak(), pushLiteral(post);
      }
      function renderIntrinsic(intrinsic) {
        switch (resolve_1.resolvedTypeHint(intrinsic)) {
          case resolve_1.ResolutionTypeHint.STRING:
            pushLiteral('"'), pushIntrinsic(deepQuoteStringLiterals(intrinsic)), pushLiteral('"');
            return;
          case resolve_1.ResolutionTypeHint.LIST:
            const stack = stack_1.Stack.of(ctx.scope), stringifyResponse = stringifyCache.obtain(stack, JSON.stringify(intrinsic), () => cfn_utils_provider_1.CfnUtils.stringify(stack, `CdkJsonStringify${stringifyCounter++}`, intrinsic));
            pushIntrinsic(stringifyResponse);
            return;
          case resolve_1.ResolutionTypeHint.NUMBER:
            pushIntrinsic(intrinsic);
            return;
        }
        throw new Error(`Unexpected type hint: ${resolve_1.resolvedTypeHint(intrinsic)}`);
      }
      function pushLiteral(lit) {
        let last = ret[ret.length - 1];
        (last == null ? void 0 : last.type) !== "literal" && (last = { type: "literal", parts: [] }, ret.push(last)), last.parts.push(lit);
      }
      function pushIntrinsic(intrinsic) {
        ret.push({ type: "intrinsic", intrinsic });
      }
      function pushLineBreak() {
        space > 0 && pushLiteral(`
${" ".repeat(indent)}`);
      }
      function prettyPunctuation(punc) {
        return space > 0 ? `${punc} ` : punc;
      }
    }
    function renderSegment(s) {
      switch (s.type) {
        case "literal":
          return s.parts.join("");
        case "intrinsic":
          return s.intrinsic;
      }
    }
    var CLOUDFORMATION_CONCAT = { join(left, right) {
      return CloudFormationLang.concat(left, right);
    } };
    exports.CLOUDFORMATION_TOKEN_RESOLVER = new resolvable_1.DefaultTokenResolver(CLOUDFORMATION_CONCAT);
    function minimalCloudFormationJoin(delimiter, values) {
      let i = 0;
      for (; i < values.length; ) {
        const el = values[i];
        isSplicableFnJoinIntrinsic(el) ? values.splice(i, 1, ...el["Fn::Join"][1]) : i > 0 && isConcatable(values[i - 1]) && isConcatable(values[i]) ? (values[i - 1] = `${values[i - 1]}${delimiter}${values[i]}`, values.splice(i, 1)) : i += 1;
      }
      return values;
      function isSplicableFnJoinIntrinsic(obj) {
        if (!isIntrinsic(obj) || Object.keys(obj)[0] !== "Fn::Join")
          return false;
        const [delim, list] = obj["Fn::Join"];
        return !(delim !== delimiter || token_1.Token.isUnresolved(list) || !Array.isArray(list));
      }
    }
    exports.minimalCloudFormationJoin = minimalCloudFormationJoin;
    function isConcatable(obj) {
      return ["string", "number"].includes(typeof obj) && !token_1.Token.isUnresolved(obj);
    }
    function isIntrinsic(x) {
      if (Array.isArray(x) || x === null || typeof x != "object")
        return false;
      const keys = Object.keys(x);
      return keys.length !== 1 ? false : keys[0] === "Ref" || isNameOfCloudFormationIntrinsic(keys[0]);
    }
    function isNameOfCloudFormationIntrinsic(name) {
      return name.startsWith("Fn::") ? name !== "Fn::GetArtifactAtt" && name !== "Fn::GetParam" : false;
    }
    exports.isNameOfCloudFormationIntrinsic = isNameOfCloudFormationIntrinsic;
    function* sepIter(xs) {
      let comma = false;
      for (const item of xs)
        yield [comma, item], comma = true;
    }
    function* definedEntries(xs) {
      for (const [key, value] of Object.entries(xs))
        value !== void 0 && (yield [key, value]);
    }
    function deepQuoteStringLiterals(x) {
      if (Array.isArray(x))
        return x.map(deepQuoteStringLiterals);
      if (typeof x == "object" && x != null) {
        const ret = {};
        for (const [key, value] of Object.entries(x))
          ret[deepQuoteStringLiterals(key)] = deepQuoteStringLiterals(value);
        return ret;
      }
      return typeof x == "string" ? quoteString(x) : x;
    }
    function quoteString(s) {
      return s = JSON.stringify(s), s.substring(1, s.length - 1);
    }
    var stringifyCounter = 1;
    var ScopedCache = class {
      constructor() {
        this.cache = /* @__PURE__ */ new WeakMap();
      }
      obtain(object, key, init) {
        let kvMap = this.cache.get(object);
        kvMap || (kvMap = /* @__PURE__ */ new Map(), this.cache.set(object, kvMap));
        let ret = kvMap.get(key);
        return ret === void 0 && (ret = init(), kvMap.set(key, ret)), ret;
      }
    };
    var stringifyCache = new ScopedCache();
  }
});

// node_modules/aws-cdk-lib/core/lib/cfn-fn.js
var require_cfn_fn = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cfn-fn.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.Fn = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cloudformation_lang_1 = require_cloudformation_lang();
    var intrinsic_1 = require_intrinsic();
    var reference_1 = require_reference();
    var stack_1 = require_stack();
    var stack_trace_1 = require_stack_trace2();
    var token_1 = require_token();
    var Fn = class {
      constructor() {
      }
      static ref(logicalName) {
        return new FnRef(logicalName).toString();
      }
      static getAtt(logicalNameOfResource, attributeName) {
        return new FnGetAtt(logicalNameOfResource, attributeName);
      }
      static join(delimiter, listOfValues) {
        if (listOfValues.length === 0)
          throw new Error("FnJoin requires at least one value to be provided");
        return new FnJoin(delimiter, listOfValues).toString();
      }
      static split(delimiter, source, assumedLength) {
        if (!token_1.Token.isUnresolved(source))
          return source.split(delimiter);
        if (token_1.Token.isUnresolved(delimiter))
          throw new Error("Fn.split: 'delimiter' may not be a token value");
        const split = token_1.Token.asList(new FnSplit(delimiter, source));
        if (assumedLength === void 0)
          return split;
        if (token_1.Token.isUnresolved(assumedLength))
          throw new Error("Fn.split: 'assumedLength' may not be a token value");
        return range(assumedLength).map((i) => Fn.select(i, split));
      }
      static select(index, array) {
        return !token_1.Token.isUnresolved(index) && !token_1.Token.isUnresolved(array) && !array.some(token_1.Token.isUnresolved) ? array[index] : new FnSelect(index, array).toString();
      }
      static sub(body, variables) {
        return new FnSub(body, variables).toString();
      }
      static base64(data) {
        return new FnBase64(data).toString();
      }
      static cidr(ipBlock, count, sizeMask) {
        return token_1.Token.asList(new FnCidr(ipBlock, count, sizeMask));
      }
      static parseDomainName(url) {
        const noHttps = Fn.select(1, Fn.split("//", url));
        return Fn.select(0, Fn.split("/", noHttps));
      }
      static getAzs(region) {
        return token_1.Token.asList(new FnGetAZs(region));
      }
      static importValue(sharedValueToImport) {
        return new FnImportValue(sharedValueToImport).toString();
      }
      static importListValue(sharedValueToImport, assumedLength, delimiter = ",") {
        return Fn.split(delimiter, Fn.importValue(sharedValueToImport), assumedLength);
      }
      static findInMap(mapName, topLevelKey, secondLevelKey) {
        return Fn._findInMap(mapName, topLevelKey, secondLevelKey).toString();
      }
      static _findInMap(mapName, topLevelKey, secondLevelKey) {
        return new FnFindInMap(mapName, topLevelKey, secondLevelKey);
      }
      static transform(macroName, parameters) {
        return new FnTransform(macroName, parameters);
      }
      static conditionAnd(...conditions) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ICfnConditionExpression(conditions);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.conditionAnd), error;
        }
        if (conditions.length === 0)
          throw new Error("Fn.conditionAnd() needs at least one argument");
        return conditions.length === 1 ? conditions[0] : Fn.conditionAnd(..._inGroupsOf(conditions, 10).map((group) => new FnAnd(...group)));
      }
      static conditionEquals(lhs, rhs) {
        return new FnEquals(lhs, rhs);
      }
      static conditionIf(conditionId, valueIfTrue, valueIfFalse) {
        return new FnIf(conditionId, valueIfTrue, valueIfFalse);
      }
      static conditionNot(condition) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ICfnConditionExpression(condition);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.conditionNot), error;
        }
        return new FnNot(condition);
      }
      static conditionOr(...conditions) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ICfnConditionExpression(conditions);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.conditionOr), error;
        }
        if (conditions.length === 0)
          throw new Error("Fn.conditionOr() needs at least one argument");
        return conditions.length === 1 ? conditions[0] : Fn.conditionOr(..._inGroupsOf(conditions, 10).map((group) => new FnOr(...group)));
      }
      static conditionContains(listOfStrings, value) {
        return new FnContains(listOfStrings, value);
      }
      static conditionEachMemberEquals(listOfStrings, value) {
        return new FnEachMemberEquals(listOfStrings, value);
      }
      static conditionEachMemberIn(stringsToCheck, stringsToMatch) {
        return new FnEachMemberIn(stringsToCheck, stringsToMatch);
      }
      static refAll(parameterType) {
        return token_1.Token.asList(new FnRefAll(parameterType));
      }
      static valueOf(parameterOrLogicalId, attribute) {
        return new FnValueOf(parameterOrLogicalId, attribute).toString();
      }
      static valueOfAll(parameterType, attribute) {
        return token_1.Token.asList(new FnValueOfAll(parameterType, attribute));
      }
      static toJsonString(object) {
        return token_1.Token.isUnresolved(object) ? new FnToJsonString(object).toString() : JSON.stringify(object);
      }
      static len(array) {
        if (!token_1.Token.isUnresolved(array)) {
          if (!Array.isArray(array))
            throw new Error("Fn.length() needs an array");
          return array.length;
        }
        return token_1.Token.asNumber(new FnLength(array));
      }
    };
    exports.Fn = Fn, _a = JSII_RTTI_SYMBOL_1, Fn[_a] = { fqn: "aws-cdk-lib.Fn", version: "2.50.0" };
    var FnBase = class extends intrinsic_1.Intrinsic {
      constructor(name, value) {
        super({ [name]: value });
      }
    };
    var FnRef = class extends FnBase {
      constructor(logicalName) {
        super("Ref", logicalName);
      }
    };
    var FnFindInMap = class extends FnBase {
      constructor(mapName, topLevelKey, secondLevelKey) {
        super("Fn::FindInMap", [mapName, topLevelKey, secondLevelKey]);
      }
    };
    var FnTransform = class extends FnBase {
      constructor(macroName, parameters) {
        super("Fn::Transform", { Name: macroName, Parameters: parameters });
      }
    };
    var FnGetAtt = class extends FnBase {
      constructor(logicalNameOfResource, attributeName) {
        super("Fn::GetAtt", [logicalNameOfResource, attributeName]);
      }
    };
    var FnGetAZs = class extends FnBase {
      constructor(region) {
        super("Fn::GetAZs", region || "");
      }
    };
    var FnImportValue = class extends FnBase {
      constructor(sharedValueToImport) {
        super("Fn::ImportValue", sharedValueToImport);
      }
    };
    var FnSelect = class extends FnBase {
      constructor(index, array) {
        super("Fn::Select", [index, array]);
      }
    };
    var FnSplit = class extends FnBase {
      constructor(delimiter, source) {
        super("Fn::Split", [delimiter, source]);
      }
    };
    var FnSub = class extends FnBase {
      constructor(body, variables) {
        super("Fn::Sub", variables ? [body, variables] : body);
      }
    };
    var FnBase64 = class extends FnBase {
      constructor(data) {
        super("Fn::Base64", data);
      }
    };
    var FnCidr = class extends FnBase {
      constructor(ipBlock, count, sizeMask) {
        if (count < 1 || count > 256)
          throw new Error(`Fn::Cidr's count attribute must be betwen 1 and 256, ${count} was provided.`);
        super("Fn::Cidr", [ipBlock, count, sizeMask]);
      }
    };
    var FnConditionBase = class extends intrinsic_1.Intrinsic {
      constructor(type, value) {
        super({ [type]: value }), this.disambiguator = true;
      }
    };
    var FnAnd = class extends FnConditionBase {
      constructor(...condition) {
        super("Fn::And", condition);
      }
    };
    var FnEquals = class extends FnConditionBase {
      constructor(lhs, rhs) {
        super("Fn::Equals", [lhs, rhs]);
      }
    };
    var FnIf = class extends FnConditionBase {
      constructor(condition, valueIfTrue, valueIfFalse) {
        super("Fn::If", [condition, valueIfTrue, valueIfFalse]);
      }
    };
    var FnNot = class extends FnConditionBase {
      constructor(condition) {
        super("Fn::Not", [condition]);
      }
    };
    var FnOr = class extends FnConditionBase {
      constructor(...condition) {
        super("Fn::Or", condition);
      }
    };
    var FnContains = class extends FnConditionBase {
      constructor(listOfStrings, value) {
        super("Fn::Contains", [listOfStrings, value]);
      }
    };
    var FnEachMemberEquals = class extends FnConditionBase {
      constructor(listOfStrings, value) {
        super("Fn::EachMemberEquals", [listOfStrings, value]);
      }
    };
    var FnEachMemberIn = class extends FnConditionBase {
      constructor(stringsToCheck, stringsToMatch) {
        super("Fn::EachMemberIn", [stringsToCheck, stringsToMatch]);
      }
    };
    var FnRefAll = class extends FnBase {
      constructor(parameterType) {
        super("Fn::RefAll", parameterType);
      }
    };
    var FnValueOf = class extends FnBase {
      constructor(parameterOrLogicalId, attribute) {
        super("Fn::ValueOf", [parameterOrLogicalId, attribute]);
      }
    };
    var FnValueOfAll = class extends FnBase {
      constructor(parameterType, attribute) {
        super("Fn::ValueOfAll", [parameterType, attribute]);
      }
    };
    var FnJoin = class {
      constructor(delimiter, listOfValues) {
        if (listOfValues.length === 0)
          throw new Error("FnJoin requires at least one value to be provided");
        this.delimiter = delimiter, this.listOfValues = listOfValues, this.creationStack = stack_trace_1.captureStackTrace();
      }
      resolve(context) {
        if (token_1.Token.isUnresolved(this.listOfValues))
          return { "Fn::Join": [this.delimiter, this.listOfValues] };
        const resolved = this.resolveValues(context);
        return resolved.length === 1 ? resolved[0] : { "Fn::Join": [this.delimiter, resolved] };
      }
      toString() {
        return token_1.Token.asString(this, { displayHint: "Fn::Join" });
      }
      toJSON() {
        return "<Fn::Join>";
      }
      resolveValues(context) {
        const resolvedValues = this.listOfValues.map((x) => reference_1.Reference.isReference(x) ? x : context.resolve(x));
        return cloudformation_lang_1.minimalCloudFormationJoin(this.delimiter, resolvedValues);
      }
    };
    var FnToJsonString = class {
      constructor(object) {
        this.object = object, this.creationStack = stack_trace_1.captureStackTrace();
      }
      resolve(context) {
        return stack_1.Stack.of(context.scope).addTransform("AWS::LanguageExtensions"), { "Fn::ToJsonString": this.object };
      }
      toString() {
        return token_1.Token.asString(this, { displayHint: "Fn::ToJsonString" });
      }
      toJSON() {
        return "<Fn::ToJsonString>";
      }
    };
    var FnLength = class {
      constructor(array) {
        this.array = array, this.creationStack = stack_trace_1.captureStackTrace();
      }
      resolve(context) {
        return stack_1.Stack.of(context.scope).addTransform("AWS::LanguageExtensions"), { "Fn::Length": this.array };
      }
      toString() {
        return token_1.Token.asString(this, { displayHint: "Fn::Length" });
      }
      toJSON() {
        return "<Fn::Length>";
      }
    };
    function _inGroupsOf(array, maxGroup) {
      const result = new Array();
      for (let i = 0; i < array.length; i += maxGroup)
        result.push(array.slice(i, i + maxGroup));
      return result;
    }
    function range(n) {
      const ret = [];
      for (let i = 0; i < n; i++)
        ret.push(i);
      return ret;
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/cfn-pseudo.js
var require_cfn_pseudo = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cfn-pseudo.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.ScopedAws = exports.Aws = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_reference_1 = require_cfn_reference();
    var token_1 = require_token();
    var AWS_ACCOUNTID = "AWS::AccountId";
    var AWS_URLSUFFIX = "AWS::URLSuffix";
    var AWS_NOTIFICATIONARNS = "AWS::NotificationARNs";
    var AWS_PARTITION = "AWS::Partition";
    var AWS_REGION = "AWS::Region";
    var AWS_STACKID = "AWS::StackId";
    var AWS_STACKNAME = "AWS::StackName";
    var AWS_NOVALUE = "AWS::NoValue";
    var Aws = class {
      constructor() {
      }
    };
    exports.Aws = Aws, _a = JSII_RTTI_SYMBOL_1, Aws[_a] = { fqn: "aws-cdk-lib.Aws", version: "2.50.0" }, Aws.ACCOUNT_ID = pseudoString(AWS_ACCOUNTID), Aws.URL_SUFFIX = pseudoString(AWS_URLSUFFIX), Aws.NOTIFICATION_ARNS = token_1.Token.asList({ Ref: AWS_NOTIFICATIONARNS }, { displayHint: AWS_NOTIFICATIONARNS }), Aws.PARTITION = pseudoString(AWS_PARTITION), Aws.REGION = pseudoString(AWS_REGION), Aws.STACK_ID = pseudoString(AWS_STACKID), Aws.STACK_NAME = pseudoString(AWS_STACKNAME), Aws.NO_VALUE = pseudoString(AWS_NOVALUE);
    var ScopedAws = class {
      constructor(scope) {
        this.scope = scope;
      }
      get accountId() {
        return this.asString(AWS_ACCOUNTID);
      }
      get urlSuffix() {
        return this.asString(AWS_URLSUFFIX);
      }
      get notificationArns() {
        return token_1.Token.asList(cfn_reference_1.CfnReference.forPseudo(AWS_NOTIFICATIONARNS, this.scope), { displayHint: AWS_NOTIFICATIONARNS });
      }
      get partition() {
        return this.asString(AWS_PARTITION);
      }
      get region() {
        return this.asString(AWS_REGION);
      }
      get stackId() {
        return this.asString(AWS_STACKID);
      }
      get stackName() {
        return this.asString(AWS_STACKNAME);
      }
      asString(name) {
        return token_1.Token.asString(cfn_reference_1.CfnReference.forPseudo(name, this.scope), { displayHint: name });
      }
    };
    exports.ScopedAws = ScopedAws, _b = JSII_RTTI_SYMBOL_1, ScopedAws[_b] = { fqn: "aws-cdk-lib.ScopedAws", version: "2.50.0" };
    function pseudoString(name) {
      return token_1.Token.asString({ Ref: name }, { displayHint: name.replace("::", ".") });
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/private/runtime-info.js
var require_runtime_info = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/runtime-info.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.constructInfoFromStack = exports.constructInfoFromConstruct = void 0;
    var stack_1 = require_stack();
    var stage_1 = require_stage();
    var ALLOWED_FQN_PREFIXES = ["@aws-cdk/", "@aws-cdk-containers/", "@aws-solutions-konstruk/", "@aws-solutions-constructs/", "@amzn/", "@cdklabs/", "aws-rfdk.", "aws-cdk-lib.", "monocdk."];
    var JSII_RUNTIME_SYMBOL = Symbol.for("jsii.rtti");
    function constructInfoFromConstruct(construct) {
      const jsiiRuntimeInfo = Object.getPrototypeOf(construct).constructor[JSII_RUNTIME_SYMBOL];
      if (typeof jsiiRuntimeInfo == "object" && jsiiRuntimeInfo !== null && typeof jsiiRuntimeInfo.fqn == "string" && typeof jsiiRuntimeInfo.version == "string")
        return { fqn: jsiiRuntimeInfo.fqn, version: jsiiRuntimeInfo.version };
      if (jsiiRuntimeInfo)
        throw new Error(`malformed jsii runtime info for construct: '${construct.node.path}'`);
    }
    exports.constructInfoFromConstruct = constructInfoFromConstruct;
    function constructInfoFromStack(stack) {
      const isDefined = (value) => value !== void 0, allConstructInfos = constructsInStack(stack).map((construct) => constructInfoFromConstruct(construct)).filter(isDefined).filter((info) => ALLOWED_FQN_PREFIXES.find((prefix) => info.fqn.startsWith(prefix)));
      allConstructInfos.push({ fqn: "jsii-runtime.Runtime", version: getJsiiAgentVersion() });
      const uniqKeys = /* @__PURE__ */ new Set();
      return allConstructInfos.filter((construct) => {
        const constructKey = `${construct.fqn}@${construct.version}`, isDuplicate = uniqKeys.has(constructKey);
        return uniqKeys.add(constructKey), !isDuplicate;
      });
    }
    exports.constructInfoFromStack = constructInfoFromStack;
    function constructsInStack(construct) {
      const constructs = [construct];
      return construct.node.children.filter((child) => !stage_1.Stage.isStage(child) && !stack_1.Stack.isStack(child)).forEach((child) => constructs.push(...constructsInStack(child))), constructs;
    }
    function getJsiiAgentVersion() {
      let jsiiAgent = process.env.JSII_AGENT;
      return jsiiAgent || (jsiiAgent = `node.js/${process.version}`), jsiiAgent = jsiiAgent.replace(/[^a-z0-9.-/=_]/gi, "-"), jsiiAgent;
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/private/metadata-resource.js
var require_metadata_resource = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/metadata-resource.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.formatAnalytics = exports.MetadataResource = void 0;
    var zlib = require("zlib");
    var region_info_1 = require_region_info2();
    var constructs_1 = require_lib4();
    var cfn_condition_1 = require_cfn_condition();
    var cfn_fn_1 = require_cfn_fn();
    var cfn_pseudo_1 = require_cfn_pseudo();
    var cfn_resource_1 = require_cfn_resource();
    var lazy_1 = require_lazy();
    var token_1 = require_token();
    var runtime_info_1 = require_runtime_info();
    var MetadataResource = class extends constructs_1.Construct {
      constructor(scope, id) {
        if (super(scope, id), token_1.Token.isUnresolved(scope.region) || region_info_1.RegionInfo.get(scope.region).cdkMetadataResourceAvailable) {
          const resource = new cfn_resource_1.CfnResource(this, "Default", { type: "AWS::CDK::Metadata", properties: { Analytics: lazy_1.Lazy.string({ produce: () => formatAnalytics(runtime_info_1.constructInfoFromStack(scope)) }) } });
          if (token_1.Token.isUnresolved(scope.region)) {
            const condition = new cfn_condition_1.CfnCondition(this, "Condition", { expression: makeCdkMetadataAvailableCondition() });
            condition.overrideLogicalId("CDKMetadataAvailable"), resource.cfnOptions.condition = condition;
          }
        }
      }
    };
    exports.MetadataResource = MetadataResource;
    function makeCdkMetadataAvailableCondition() {
      return cfn_fn_1.Fn.conditionOr(...region_info_1.RegionInfo.regions.filter((ri) => ri.cdkMetadataResourceAvailable).map((ri) => cfn_fn_1.Fn.conditionEquals(cfn_pseudo_1.Aws.REGION, ri.name)));
    }
    var Trie = class extends Map {
    };
    function formatAnalytics(infos) {
      const trie = new Trie();
      infos.forEach((info) => insertFqnInTrie(`${info.version}!${info.fqn}`, trie));
      const plaintextEncodedConstructs = prefixEncodeTrie(trie), compressedConstructsBuffer = zlib.gzipSync(Buffer.from(plaintextEncodedConstructs));
      return setGzipOperatingSystemToUnknown(compressedConstructsBuffer), `v2:deflate64:${compressedConstructsBuffer.toString("base64")}`;
    }
    exports.formatAnalytics = formatAnalytics;
    function insertFqnInTrie(fqn, trie) {
      for (const fqnPart of fqn.replace(/[^a-z0-9]/gi, "$& ").split(" ")) {
        const nextLevelTreeRef = trie.get(fqnPart) ?? new Trie();
        trie.set(fqnPart, nextLevelTreeRef), trie = nextLevelTreeRef;
      }
      return trie;
    }
    function prefixEncodeTrie(trie) {
      let prefixEncoded = "", isFirstEntryAtLevel = true;
      return [...trie.entries()].forEach(([key, value]) => {
        isFirstEntryAtLevel || (prefixEncoded += ","), isFirstEntryAtLevel = false, prefixEncoded += key, value.size > 1 ? (prefixEncoded += "{", prefixEncoded += prefixEncodeTrie(value), prefixEncoded += "}") : prefixEncoded += prefixEncodeTrie(value);
      }), prefixEncoded;
    }
    function setGzipOperatingSystemToUnknown(gzipBuffer) {
      if (gzipBuffer[0] !== 31 || gzipBuffer[1] !== 139)
        throw new Error("Expecting a gzip buffer (must start with 0x1f8b)");
      gzipBuffer[9] = 255;
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/cfn-output.js
var require_cfn_output = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cfn-output.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CfnOutput = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_element_1 = require_cfn_element();
    var CfnOutput = class extends cfn_element_1.CfnElement {
      constructor(scope, id, props) {
        super(scope, id);
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnOutputProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnOutput), error;
        }
        if (props.value === void 0)
          throw new Error(`Missing value for CloudFormation output at path "${this.node.path}"`);
        this._description = props.description, this._value = props.value, this._condition = props.condition, this._exportName = props.exportName, this.node.addValidation({ validate: () => this.validateOutput() });
      }
      get description() {
        return this._description;
      }
      set description(description) {
        this._description = description;
      }
      get value() {
        return this._value;
      }
      set value(value) {
        this._value = value;
      }
      get condition() {
        return this._condition;
      }
      set condition(condition) {
        this._condition = condition;
      }
      get exportName() {
        return this._exportName;
      }
      set exportName(exportName) {
        this._exportName = exportName;
      }
      get importValue() {
        return cfn_fn_1.Fn.importValue(lazy_1.Lazy.uncachedString({ produce: (ctx) => {
          if (stack_1.Stack.of(ctx.scope) === this.stack)
            throw new Error(`'importValue' property of '${this.node.path}' should only be used in a different Stack`);
          if (!this._exportName)
            throw new Error(`Add an exportName to the CfnOutput at '${this.node.path}' in order to use 'output.importValue'`);
          return this._exportName;
        } }));
      }
      _toCloudFormation() {
        return { Outputs: { [this.logicalId]: { Description: this._description, Value: this._value, Export: this._exportName != null ? { Name: this._exportName } : void 0, Condition: this._condition ? this._condition.logicalId : void 0 } } };
      }
      validateOutput() {
        return this._exportName && !token_1.Token.isUnresolved(this._exportName) && this._exportName.length > 255 ? [`Export name cannot exceed 255 characters (got ${this._exportName.length} characters)`] : [];
      }
    };
    exports.CfnOutput = CfnOutput, _a = JSII_RTTI_SYMBOL_1, CfnOutput[_a] = { fqn: "aws-cdk-lib.CfnOutput", version: "2.50.0" };
    var cfn_fn_1 = require_cfn_fn();
    var lazy_1 = require_lazy();
    var stack_1 = require_stack();
    var token_1 = require_token();
  }
});

// node_modules/aws-cdk-lib/core/lib/cfn-parameter.js
var require_cfn_parameter = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cfn-parameter.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CfnParameter = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_element_1 = require_cfn_element();
    var cfn_reference_1 = require_cfn_reference();
    var token_1 = require_token();
    var CfnParameter = class extends cfn_element_1.CfnElement {
      constructor(scope, id, props = {}) {
        super(scope, id);
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnParameterProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnParameter), error;
        }
        this._type = props.type || "String", this._default = props.default, this._allowedPattern = props.allowedPattern, this._allowedValues = props.allowedValues, this._constraintDescription = props.constraintDescription, this._description = props.description, this._maxLength = props.maxLength, this._maxValue = props.maxValue, this._minLength = props.minLength, this._minValue = props.minValue, this._noEcho = props.noEcho;
      }
      get type() {
        return this._type;
      }
      set type(type) {
        this._type = type;
      }
      get default() {
        return this._default;
      }
      set default(value) {
        this._default = value;
      }
      get allowedPattern() {
        return this._allowedPattern;
      }
      set allowedPattern(pattern) {
        this._allowedPattern = pattern;
      }
      get allowedValues() {
        return this._allowedValues;
      }
      set allowedValues(values) {
        this._allowedValues = values;
      }
      get constraintDescription() {
        return this._constraintDescription;
      }
      set constraintDescription(desc) {
        this._constraintDescription = desc;
      }
      get description() {
        return this._description;
      }
      set description(desc) {
        this._description = desc;
      }
      get maxLength() {
        return this._maxLength;
      }
      set maxLength(len) {
        this._maxLength = len;
      }
      get minLength() {
        return this._minLength;
      }
      set minLength(len) {
        this._minLength = len;
      }
      get maxValue() {
        return this._maxValue;
      }
      set maxValue(len) {
        this._maxValue = len;
      }
      get minValue() {
        return this._minValue;
      }
      set minValue(len) {
        this._minValue = len;
      }
      get noEcho() {
        return !!this._noEcho;
      }
      set noEcho(echo) {
        this._noEcho = echo;
      }
      get value() {
        return cfn_reference_1.CfnReference.for(this, "Ref");
      }
      get valueAsString() {
        if (!isStringType(this.type) && !isNumberType(this.type))
          throw new Error(`Parameter type (${this.type}) is not a string or number type`);
        return token_1.Token.asString(this.value);
      }
      get valueAsList() {
        if (!isListType(this.type))
          throw new Error(`Parameter type (${this.type}) is not a string list type`);
        return token_1.Token.asList(this.value);
      }
      get valueAsNumber() {
        if (!isNumberType(this.type))
          throw new Error(`Parameter type (${this.type}) is not a number type`);
        return token_1.Token.asNumber(this.value);
      }
      _toCloudFormation() {
        return { Parameters: { [this.logicalId]: { Type: this.type, Default: this.default, AllowedPattern: this.allowedPattern, AllowedValues: this.allowedValues, ConstraintDescription: this.constraintDescription, Description: this.description, MaxLength: this.maxLength, MaxValue: this.maxValue, MinLength: this.minLength, MinValue: this.minValue, NoEcho: this._noEcho } } };
      }
      resolve(_context) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IResolveContext(_context);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.resolve), error;
        }
        return this.value;
      }
    };
    exports.CfnParameter = CfnParameter, _a = JSII_RTTI_SYMBOL_1, CfnParameter[_a] = { fqn: "aws-cdk-lib.CfnParameter", version: "2.50.0" };
    function isListType(type) {
      return type.indexOf("List<") >= 0 || type.indexOf("CommaDelimitedList") >= 0;
    }
    function isNumberType(type) {
      return type === "Number";
    }
    function isStringType(type) {
      return !isListType(type) && !isNumberType(type);
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/cfn-dynamic-reference.js
var require_cfn_dynamic_reference = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cfn-dynamic-reference.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CfnDynamicReferenceService = exports.CfnDynamicReference = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var intrinsic_1 = require_intrinsic();
    var CfnDynamicReference = class extends intrinsic_1.Intrinsic {
      constructor(service, key) {
        super("{{resolve:" + service + ":" + key + "}}");
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnDynamicReferenceService(service);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnDynamicReference), error;
        }
      }
    };
    exports.CfnDynamicReference = CfnDynamicReference, _a = JSII_RTTI_SYMBOL_1, CfnDynamicReference[_a] = { fqn: "aws-cdk-lib.CfnDynamicReference", version: "2.50.0" };
    var CfnDynamicReferenceService;
    (function(CfnDynamicReferenceService2) {
      CfnDynamicReferenceService2.SSM = "ssm", CfnDynamicReferenceService2.SSM_SECURE = "ssm-secure", CfnDynamicReferenceService2.SECRETS_MANAGER = "secretsmanager";
    })(CfnDynamicReferenceService = exports.CfnDynamicReferenceService || (exports.CfnDynamicReferenceService = {}));
  }
});

// node_modules/aws-cdk-lib/core/lib/custom-resource-provider/cross-region-export-providers/types.js
var require_types = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/custom-resource-provider/cross-region-export-providers/types.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.SSM_EXPORT_PATH_PREFIX = void 0, exports.SSM_EXPORT_PATH_PREFIX = "cdk/exports/";
  }
});

// node_modules/aws-cdk-lib/core/lib/custom-resource-provider/cross-region-export-providers/export-reader-provider.js
var require_export_reader_provider = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/custom-resource-provider/cross-region-export-providers/export-reader-provider.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.ExportReader = void 0;
    var path = require("path");
    var constructs_1 = require_lib4();
    var cfn_resource_1 = require_cfn_resource();
    var custom_resource_1 = require_custom_resource();
    var lazy_1 = require_lazy();
    var stack_1 = require_stack();
    var custom_resource_provider_1 = require_custom_resource_provider();
    var types_1 = require_types();
    var ExportReader = class extends constructs_1.Construct {
      constructor(scope, id, _props = {}) {
        super(scope, id), this.importParameters = {};
        const stack = stack_1.Stack.of(this), resourceType = "Custom::CrossRegionExportReader", serviceToken = custom_resource_provider_1.CustomResourceProvider.getOrCreate(this, resourceType, { codeDirectory: path.join(__dirname, "cross-region-ssm-reader-handler"), runtime: custom_resource_provider_1.CustomResourceProviderRuntime.NODEJS_14_X, policyStatements: [{ Effect: "Allow", Resource: stack.formatArn({ service: "ssm", resource: "parameter", resourceName: `${types_1.SSM_EXPORT_PATH_PREFIX}${stack.stackName}/*` }), Action: ["ssm:AddTagsToResource", "ssm:RemoveTagsFromResource", "ssm:GetParameters"] }] }), properties = { region: stack.region, prefix: stack.stackName, imports: lazy_1.Lazy.any({ produce: () => this.importParameters }) };
        this.customResource = new custom_resource_1.CustomResource(this, "Resource", { resourceType, serviceToken, properties: { ReaderProps: properties } });
      }
      static getOrCreate(scope, uniqueId, _props = {}) {
        const stack = stack_1.Stack.of(scope), existing = stack.node.tryFindChild(uniqueId);
        return existing || new ExportReader(stack, uniqueId);
      }
      addDependency(resource) {
        const customResource = this.customResource.node.tryFindChild("Default");
        customResource && cfn_resource_1.CfnResource.isCfnResource(customResource) && customResource.addDependsOn(resource);
      }
      importValue(name, value) {
        return this.importParameters[name] = value.toString(), this.customResource.getAtt(name);
      }
    };
    exports.ExportReader = ExportReader;
  }
});

// node_modules/aws-cdk-lib/core/lib/custom-resource-provider/cross-region-export-providers/export-writer-provider.js
var require_export_writer_provider = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/custom-resource-provider/cross-region-export-providers/export-writer-provider.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.ExportWriter = void 0;
    var path = require("path");
    var constructs_1 = require_lib4();
    var cfn_dynamic_reference_1 = require_cfn_dynamic_reference();
    var custom_resource_1 = require_custom_resource();
    var lazy_1 = require_lazy();
    var uniqueid_1 = require_uniqueid2();
    var stack_1 = require_stack();
    var custom_resource_provider_1 = require_custom_resource_provider();
    var export_reader_provider_1 = require_export_reader_provider();
    var types_1 = require_types();
    var ExportWriter = class extends constructs_1.Construct {
      constructor(scope, id, props) {
        super(scope, id), this._references = {};
        const stack = stack_1.Stack.of(this), region = props.region ?? stack.region, resourceType = "Custom::CrossRegionExportWriter", serviceToken = custom_resource_provider_1.CustomResourceProvider.getOrCreate(this, resourceType, { codeDirectory: path.join(__dirname, "cross-region-ssm-writer-handler"), runtime: custom_resource_provider_1.CustomResourceProviderRuntime.NODEJS_14_X, policyStatements: [{ Effect: "Allow", Resource: stack.formatArn({ service: "ssm", resource: "parameter", region, resourceName: `${types_1.SSM_EXPORT_PATH_PREFIX}*` }), Action: ["ssm:DeleteParameters", "ssm:ListTagsForResource", "ssm:GetParameters", "ssm:PutParameter"] }] }), properties = { region, exports: lazy_1.Lazy.any({ produce: () => this._references }) };
        new custom_resource_1.CustomResource(this, "Resource", { resourceType, serviceToken, properties: { WriterProps: properties } });
      }
      static getOrCreate(scope, uniqueId, props) {
        const stack = stack_1.Stack.of(scope), existing = stack.node.tryFindChild(uniqueId);
        return existing || new ExportWriter(stack, uniqueId, { region: props.region });
      }
      exportValue(exportName, reference, importStack) {
        const stack = stack_1.Stack.of(this), parameterName = `/${types_1.SSM_EXPORT_PATH_PREFIX}${exportName}`, ref = new cfn_dynamic_reference_1.CfnDynamicReference(cfn_dynamic_reference_1.CfnDynamicReferenceService.SSM, parameterName);
        return this._references[parameterName] = stack.resolve(reference.toString()), this.addToExportReader(parameterName, ref, importStack);
      }
      addToExportReader(exportName, exportValueRef, importStack) {
        const readerConstructName = uniqueid_1.makeUniqueId(["ExportsReader"]);
        return export_reader_provider_1.ExportReader.getOrCreate(importStack.nestedStackParent ?? importStack, readerConstructName).importValue(exportName, exportValueRef);
      }
    };
    exports.ExportWriter = ExportWriter;
  }
});

// node_modules/aws-cdk-lib/core/lib/private/refs.js
var require_refs = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/refs.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.referenceNestedStackValueInParent = exports.getExportable = exports.resolveReferences = void 0;
    var cxapi = require_cx_api();
    var cfn_element_1 = require_cfn_element();
    var cfn_output_1 = require_cfn_output();
    var cfn_parameter_1 = require_cfn_parameter();
    var export_writer_provider_1 = require_export_writer_provider();
    var names_1 = require_names();
    var stack_1 = require_stack();
    var token_1 = require_token();
    var cfn_reference_1 = require_cfn_reference();
    var resolve_1 = require_resolve();
    var uniqueid_1 = require_uniqueid2();
    function resolveReferences(scope) {
      const edges = findAllReferences(scope);
      for (const { source, value } of edges) {
        const consumer = stack_1.Stack.of(source);
        if (!value.hasValueForStack(consumer)) {
          const resolved = resolveValue(consumer, value);
          value.assignValueForStack(consumer, resolved);
        }
      }
    }
    exports.resolveReferences = resolveReferences;
    function resolveValue(consumer, reference) {
      const producer = stack_1.Stack.of(reference.target), producerAccount = token_1.Token.isUnresolved(producer.account) ? cxapi.UNKNOWN_ACCOUNT : producer.account, producerRegion = token_1.Token.isUnresolved(producer.region) ? cxapi.UNKNOWN_REGION : producer.region, consumerAccount = token_1.Token.isUnresolved(consumer.account) ? cxapi.UNKNOWN_ACCOUNT : consumer.account, consumerRegion = token_1.Token.isUnresolved(consumer.region) ? cxapi.UNKNOWN_REGION : consumer.region;
      if (producer === consumer)
        return reference;
      if (producer.node.root !== consumer.node.root)
        throw new Error("Cannot reference across apps. Consuming and producing stacks must be defined within the same CDK app.");
      if (producerAccount !== consumerAccount)
        throw new Error(`Stack "${consumer.node.path}" cannot consume a cross reference from stack "${producer.node.path}". Cross stack references are only supported for stacks deployed to the same account or between nested stacks and their parent stack`);
      if (producerRegion !== consumerRegion && !consumer._crossRegionReferences)
        throw new Error(`Stack "${consumer.node.path}" cannot consume a cross reference from stack "${producer.node.path}". Cross stack references are only supported for stacks deployed to the same environment or between nested stacks and their parent stack. Set crossRegionReferences=true to enable cross region references`);
      if (consumer.nestedStackParent && isNested(consumer, producer)) {
        const parameterValue = resolveValue(consumer.nestedStackParent, reference);
        return createNestedStackParameter(consumer, reference, parameterValue);
      }
      if (producer.nested) {
        const outputValue = createNestedStackOutput(producer, reference);
        return resolveValue(consumer, outputValue);
      }
      if (producerRegion !== consumerRegion && consumer._crossRegionReferences) {
        if (producerRegion === cxapi.UNKNOWN_REGION || consumerRegion === cxapi.UNKNOWN_REGION)
          throw new Error(`Stack "${consumer.node.path}" cannot consume a cross reference from stack "${producer.node.path}". Cross stack/region references are only supported for stacks with an explicit region defined. `);
        return consumer.addDependency(producer, `${consumer.node.path} -> ${reference.target.node.path}.${reference.displayName}`), createCrossRegionImportValue(reference, consumer);
      }
      return consumer.addDependency(producer, `${consumer.node.path} -> ${reference.target.node.path}.${reference.displayName}`), createImportValue(reference);
    }
    function findAllReferences(root) {
      const result = new Array();
      for (const consumer of root.node.findAll())
        if (!!cfn_element_1.CfnElement.isCfnElement(consumer))
          try {
            const tokens = resolve_1.findTokens(consumer, () => consumer._toCloudFormation());
            for (const token of tokens)
              !cfn_reference_1.CfnReference.isCfnReference(token) || result.push({ source: consumer, value: token });
          } catch (e) {
            if (e.type === "CfnSynthesisError")
              continue;
            throw e;
          }
      return result;
    }
    function createImportValue(reference) {
      const importExpr = stack_1.Stack.of(reference.target).exportValue(reference);
      return token_1.Tokenization.reverseCompleteString(importExpr);
    }
    function createCrossRegionImportValue(reference, importStack) {
      const referenceStack = stack_1.Stack.of(reference.target), exportingStack = referenceStack.nestedStackParent ?? referenceStack, exportable = getExportable(exportingStack, reference), id = JSON.stringify(exportingStack.resolve(exportable)), exportName = generateExportName(importStack, reference, id);
      if (token_1.Token.isUnresolved(exportName))
        throw new Error(`unresolved token in generated export name: ${JSON.stringify(exportingStack.resolve(exportName))}`);
      const writerConstructName = uniqueid_1.makeUniqueId(["ExportsWriter", importStack.region]), exported = export_writer_provider_1.ExportWriter.getOrCreate(exportingStack, writerConstructName, { region: importStack.region }).exportValue(exportName, reference, importStack);
      return importStack.nestedStackParent ? createNestedStackParameter(importStack, exported, exported) : exported;
    }
    function generateExportName(importStack, reference, id) {
      var _a;
      const referenceStack = stack_1.Stack.of(reference.target), components = [referenceStack.stackName ?? "", referenceStack.region, id], prefix = `${((_a = importStack.nestedStackParent) == null ? void 0 : _a.stackName) ?? importStack.stackName}/`, localPart = uniqueid_1.makeUniqueId(components), maxLength = 900;
      return prefix + localPart.slice(Math.max(0, localPart.length - maxLength + prefix.length));
    }
    function getExportable(stack, reference) {
      return cfn_element_1.CfnElement.isCfnElement(reference.target) && reference.target._lockLogicalId(), referenceNestedStackValueInParent(reference, stack);
    }
    exports.getExportable = getExportable;
    function createNestedStackParameter(nested, reference, value) {
      const paramId = generateUniqueId(nested, reference, "reference-to-");
      let param = nested.node.tryFindChild(paramId);
      if (!param) {
        if (param = new cfn_parameter_1.CfnParameter(nested, paramId, { type: "String" }), !("setParameter" in nested))
          throw new Error('assertion failed: nested stack should have a "setParameter" method');
        nested.setParameter(param.logicalId, token_1.Token.asString(value));
      }
      return param.value;
    }
    function createNestedStackOutput(producer, reference) {
      const outputId = generateUniqueId(producer, reference);
      let output = producer.node.tryFindChild(outputId);
      if (output || (output = new cfn_output_1.CfnOutput(producer, outputId, { value: token_1.Token.asString(reference) })), !producer.nestedStackResource)
        throw new Error("assertion failed");
      return producer.nestedStackResource.getAtt(`Outputs.${output.logicalId}`);
    }
    function referenceNestedStackValueInParent(reference, targetStack) {
      let currentStack = stack_1.Stack.of(reference.target);
      if (currentStack !== targetStack && !isNested(currentStack, targetStack))
        throw new Error(`Referenced resource must be in stack '${targetStack.node.path}', got '${reference.target.node.path}'`);
      for (; currentStack !== targetStack; )
        reference = createNestedStackOutput(stack_1.Stack.of(reference.target), reference), currentStack = stack_1.Stack.of(reference.target);
      return reference;
    }
    exports.referenceNestedStackValueInParent = referenceNestedStackValueInParent;
    function isNested(nested, parent) {
      return nested.nestedStackParent === parent ? true : nested.nestedStackParent ? isNested(nested.nestedStackParent, parent) : false;
    }
    function generateUniqueId(stack, ref, prefix = "") {
      return stack.resolve(`${prefix}${names_1.Names.nodeUniqueId(ref.target.node)}${ref.displayName}`);
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/private/prepare-app.js
var require_prepare_app = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/prepare-app.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.prepareApp = void 0;
    var constructs_1 = require_lib4();
    var cfn_resource_1 = require_cfn_resource();
    var stack_1 = require_stack();
    var stage_1 = require_stage();
    var refs_1 = require_refs();
    function prepareApp(root) {
      for (const dependency of findTransitiveDeps(root)) {
        const targetCfnResources = findCfnResources(dependency.target), sourceCfnResources = findCfnResources(dependency.source);
        for (const target of targetCfnResources)
          for (const source of sourceCfnResources)
            source.addDependsOn(target);
      }
      refs_1.resolveReferences(root);
      const queue = findAllNestedStacks(root);
      if (queue.length > 0) {
        for (; queue.length > 0; ) {
          const nested = queue.shift();
          defineNestedStackAsset(nested);
        }
        refs_1.resolveReferences(root);
      }
    }
    exports.prepareApp = prepareApp;
    function defineNestedStackAsset(nestedStack) {
      nestedStack._prepareTemplateAsset();
    }
    function findAllNestedStacks(root) {
      const result = new Array(), includeStack = (stack) => !stack_1.Stack.isStack(stack) || !stack.nested ? false : stage_1.Stage.of(stack) ? stage_1.Stage.of(stack) === root : true;
      for (const stack of root.node.findAll(constructs_1.ConstructOrder.POSTORDER))
        includeStack(stack) && result.push(stack);
      return result;
    }
    function findCfnResources(root) {
      return root.node.findAll().filter(cfn_resource_1.CfnResource.isCfnResource);
    }
    function findTransitiveDeps(root) {
      const found = /* @__PURE__ */ new Map(), ret = new Array();
      for (const source of root.node.findAll())
        for (const dependable of source.node.dependencies)
          for (const target of constructs_1.Dependable.of(dependable).dependencyRoots) {
            let foundTargets = found.get(source);
            foundTargets || found.set(source, foundTargets = /* @__PURE__ */ new Set()), foundTargets.has(target) || (ret.push({ source, target }), foundTargets.add(target));
          }
      return ret;
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/tree.js
var require_tree = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/tree.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.TreeInspector = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var TreeInspector = class {
      constructor() {
        this.attributes = {};
      }
      addAttribute(key, value) {
        this.attributes[key] = value;
      }
    };
    exports.TreeInspector = TreeInspector, _a = JSII_RTTI_SYMBOL_1, TreeInspector[_a] = { fqn: "aws-cdk-lib.TreeInspector", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/private/tree-metadata.js
var require_tree_metadata = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/tree-metadata.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.TreeMetadata = void 0;
    var fs = require("fs");
    var path = require("path");
    var cloud_assembly_schema_1 = require_cloud_assembly_schema2();
    var constructs_1 = require_lib4();
    var annotations_1 = require_annotations();
    var stack_1 = require_stack();
    var tree_1 = require_tree();
    var runtime_info_1 = require_runtime_info();
    var FILE_PATH = "tree.json";
    var TreeMetadata = class extends constructs_1.Construct {
      constructor(scope) {
        super(scope, "Tree");
      }
      _synthesizeTree(session) {
        const lookup = {}, visit = (construct) => {
          const childrenMap = construct.node.children.map((c) => {
            try {
              return visit(c);
            } catch (e) {
              annotations_1.Annotations.of(this).addWarning(`Failed to render tree metadata for node [${c.node.id}]. Reason: ${e}`);
              return;
            }
          }).filter((child) => child !== void 0).reduce((map, child) => Object.assign(map, { [child.id]: child }), {}), node = { id: construct.node.id || "App", path: construct.node.path, children: Object.keys(childrenMap).length === 0 ? void 0 : childrenMap, attributes: this.synthAttributes(construct), constructInfo: runtime_info_1.constructInfoFromConstruct(construct) };
          return lookup[node.path] = node, node;
        }, tree = { version: "tree-0.1", tree: visit(this.node.root) }, builder = session.assembly;
        fs.writeFileSync(path.join(builder.outdir, FILE_PATH), JSON.stringify(tree, void 0, 2), { encoding: "utf-8" }), builder.addArtifact("Tree", { type: cloud_assembly_schema_1.ArtifactType.CDK_TREE, properties: { file: FILE_PATH } });
      }
      synthAttributes(construct) {
        function canInspect(inspectable) {
          return inspectable.inspect !== void 0;
        }
        const inspector = new tree_1.TreeInspector();
        if (canInspect(construct))
          return construct.inspect(inspector), stack_1.Stack.of(construct).resolve(inspector.attributes);
      }
    };
    exports.TreeMetadata = TreeMetadata;
  }
});

// node_modules/aws-cdk-lib/core/lib/private/synthesis.js
var require_synthesis = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/synthesis.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.addCustomSynthesis = exports.synthesize = void 0;
    var cxapi = require_cx_api();
    var annotations_1 = require_annotations();
    var aspect_1 = require_aspect();
    var stack_1 = require_stack();
    var stage_1 = require_stage();
    var metadata_resource_1 = require_metadata_resource();
    var prepare_app_1 = require_prepare_app();
    var tree_metadata_1 = require_tree_metadata();
    function synthesize(root, options = {}) {
      synthNestedAssemblies(root, options), invokeAspects(root), injectMetadataResources(root), prepare_app_1.prepareApp(root), options.skipValidation || validateTree(root);
      const builder = stage_1.Stage.isStage(root) ? root._assemblyBuilder : new cxapi.CloudAssemblyBuilder(options.outdir);
      return synthesizeTree(root, builder, options.validateOnSynthesis), builder.buildAssembly();
    }
    exports.synthesize = synthesize;
    var CUSTOM_SYNTHESIS_SYM = Symbol.for("@aws-cdk/core:customSynthesis");
    function addCustomSynthesis(construct, synthesis) {
      Object.defineProperty(construct, CUSTOM_SYNTHESIS_SYM, { value: synthesis, enumerable: false });
    }
    exports.addCustomSynthesis = addCustomSynthesis;
    function getCustomSynthesis(construct) {
      return construct[CUSTOM_SYNTHESIS_SYM];
    }
    function synthNestedAssemblies(root, options) {
      for (const child of root.node.children)
        stage_1.Stage.isStage(child) ? child.synth(options) : synthNestedAssemblies(child, options);
    }
    function invokeAspects(root) {
      const invokedByPath = {};
      let nestedAspectWarning = false;
      recurse(root, []);
      function recurse(construct, inheritedAspects) {
        const node = construct.node, aspects = aspect_1.Aspects.of(construct), allAspectsHere = [...inheritedAspects ?? [], ...aspects.all], nodeAspectsCount = aspects.all.length;
        for (const aspect of allAspectsHere) {
          let invoked = invokedByPath[node.path];
          invoked || (invoked = invokedByPath[node.path] = []), !invoked.includes(aspect) && (aspect.visit(construct), !nestedAspectWarning && nodeAspectsCount !== aspects.all.length && (annotations_1.Annotations.of(construct).addWarning("We detected an Aspect was added via another Aspect, and will not be applied"), nestedAspectWarning = true), invoked.push(aspect));
        }
        for (const child of construct.node.children)
          stage_1.Stage.isStage(child) || recurse(child, allAspectsHere);
      }
    }
    function injectMetadataResources(root) {
      visit(root, "post", (construct) => {
        if (!stack_1.Stack.isStack(construct) || !construct._versionReportingEnabled)
          return;
        const CDKMetadata = "CDKMetadata";
        construct.node.tryFindChild(CDKMetadata) || new metadata_resource_1.MetadataResource(construct, CDKMetadata);
      });
    }
    function synthesizeTree(root, builder, validateOnSynth = false) {
      visit(root, "post", (construct) => {
        var _a;
        const session = { outdir: builder.outdir, assembly: builder, validateOnSynth };
        stack_1.Stack.isStack(construct) ? construct.synthesizer.synthesize(session) : construct instanceof tree_metadata_1.TreeMetadata ? construct._synthesizeTree(session) : (_a = getCustomSynthesis(construct)) == null ? void 0 : _a.onSynthesize(session);
      });
    }
    function validateTree(root) {
      const errors = new Array();
      if (visit(root, "pre", (construct) => {
        for (const message of construct.node.validate())
          errors.push({ message, source: construct });
      }), errors.length > 0) {
        const errorList = errors.map((e) => `[${e.source.node.path}] ${e.message}`).join(`
  `);
        throw new Error(`Validation failed with the following errors:
  ${errorList}`);
      }
    }
    function visit(root, order, cb) {
      order === "pre" && cb(root);
      for (const child of root.node.children)
        stage_1.Stage.isStage(child) || visit(child, order, cb);
      order === "post" && cb(root);
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/app.js
var require_app2 = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/app.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.attachCustomSynthesis = exports.App = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxapi = require_cx_api();
    var fs = require_lib5();
    var synthesis_1 = require_synthesis();
    var tree_metadata_1 = require_tree_metadata();
    var stage_1 = require_stage();
    var APP_SYMBOL = Symbol.for("@aws-cdk/core.App");
    var App = class extends stage_1.Stage {
      constructor(props = {}) {
        super(void 0, "", { outdir: props.outdir ?? process.env[cxapi.OUTDIR_ENV] });
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_AppProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, App), error;
        }
        Object.defineProperty(this, APP_SYMBOL, { value: true }), this.loadContext(props.context, props.postCliContext), props.stackTraces === false && this.node.setContext(cxapi.DISABLE_METADATA_STACK_TRACE, true);
        const analyticsReporting = props.analyticsReporting ?? props.runtimeInfo;
        analyticsReporting !== void 0 && this.node.setContext(cxapi.ANALYTICS_REPORTING_ENABLED_CONTEXT, analyticsReporting), (props.autoSynth ?? cxapi.OUTDIR_ENV in process.env) && process.once("beforeExit", () => this.synth()), (props.treeMetadata === void 0 || props.treeMetadata) && new tree_metadata_1.TreeMetadata(this);
      }
      static isApp(obj) {
        return APP_SYMBOL in obj;
      }
      loadContext(defaults = {}, final = {}) {
        for (const [k, v] of Object.entries(defaults))
          this.node.setContext(k, v);
        const context = { ...this.readContextFromEnvironment(), ...this.readContextFromTempFile() };
        for (const [k, v] of Object.entries(context))
          this.node.setContext(k, v);
        for (const [k, v] of Object.entries(final))
          this.node.setContext(k, v);
      }
      readContextFromTempFile() {
        const location = process.env[cxapi.CONTEXT_OVERFLOW_LOCATION_ENV];
        return location ? fs.readJSONSync(location) : {};
      }
      readContextFromEnvironment() {
        const contextJson = process.env[cxapi.CONTEXT_ENV];
        return contextJson ? JSON.parse(contextJson) : {};
      }
    };
    exports.App = App, _a = JSII_RTTI_SYMBOL_1, App[_a] = { fqn: "aws-cdk-lib.App", version: "2.50.0" };
    function attachCustomSynthesis(construct, synthesis) {
      synthesis_1.addCustomSynthesis(construct, synthesis);
    }
    exports.attachCustomSynthesis = attachCustomSynthesis;
  }
});

// node_modules/aws-cdk-lib/core/lib/context-provider.js
var require_context_provider = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/context-provider.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.ContextProvider = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxapi = require_cx_api();
    var constructs_1 = require_lib4();
    var annotations_1 = require_annotations();
    var stack_1 = require_stack();
    var token_1 = require_token();
    var ContextProvider = class {
      constructor() {
      }
      static getKey(scope, options) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_GetContextKeyOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.getKey), error;
        }
        const stack = stack_1.Stack.of(scope), props = options.includeEnvironment ?? true ? { account: stack.account, region: stack.region, ...options.props } : options.props ?? {};
        if (Object.values(props).find((x) => token_1.Token.isUnresolved(x)))
          throw new Error(`Cannot determine scope for context provider ${options.provider}.
This usually happens when one or more of the provider props have unresolved tokens`);
        const propStrings = propsToArray(props);
        return { key: `${options.provider}:${propStrings.join(":")}`, props };
      }
      static getValue(scope, options) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_GetContextValueOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.getValue), error;
        }
        const stack = stack_1.Stack.of(scope);
        if (token_1.Token.isUnresolved(stack.account) || token_1.Token.isUnresolved(stack.region))
          throw new Error(`Cannot retrieve value from context provider ${options.provider} since account/region are not specified at the stack level. Configure "env" with an account and region when you define your stack.See https://docs.aws.amazon.com/cdk/latest/guide/environments.html for more details.`);
        const { key, props } = this.getKey(scope, options), value = constructs_1.Node.of(scope).tryGetContext(key), providerError = extractProviderError(value);
        return value === void 0 || providerError !== void 0 ? (stack.reportMissingContextKey({ key, provider: options.provider, props }), providerError !== void 0 && annotations_1.Annotations.of(scope).addError(providerError), { value: options.dummyValue }) : { value };
      }
    };
    exports.ContextProvider = ContextProvider, _a = JSII_RTTI_SYMBOL_1, ContextProvider[_a] = { fqn: "aws-cdk-lib.ContextProvider", version: "2.50.0" };
    function extractProviderError(value) {
      if (typeof value == "object" && value !== null)
        return value[cxapi.PROVIDER_ERROR_KEY];
    }
    function colonQuote(xs) {
      return xs.replace("$", "$$").replace(":", "$:");
    }
    function propsToArray(props, keyPrefix = "") {
      const ret = [];
      for (const key of Object.keys(props))
        if (props[key] !== void 0)
          switch (typeof props[key]) {
            case "object": {
              ret.push(...propsToArray(props[key], `${keyPrefix}${key}.`));
              break;
            }
            case "string": {
              ret.push(`${keyPrefix}${key}=${colonQuote(props[key])}`);
              break;
            }
            default: {
              ret.push(`${keyPrefix}${key}=${JSON.stringify(props[key])}`);
              break;
            }
          }
      return ret.sort(), ret;
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/feature-flags.js
var require_feature_flags = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/feature-flags.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.FeatureFlags = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxapi = require_cx_api();
    var constructs_1 = require_lib4();
    var FeatureFlags = class {
      constructor(construct) {
        this.construct = construct;
      }
      static of(scope) {
        return new FeatureFlags(scope);
      }
      isEnabled(featureFlag) {
        const context = constructs_1.Node.of(this.construct).tryGetContext(featureFlag);
        if (cxapi.FUTURE_FLAGS_EXPIRED.includes(featureFlag)) {
          if (context !== void 0)
            throw new Error(`Unsupported feature flag '${featureFlag}'. This flag existed on CDKv1 but has been removed in CDKv2. CDK will now behave as the same as when the flag is enabled.`);
          return true;
        }
        return context !== void 0 ? Boolean(context) : cxapi.futureFlagDefault(featureFlag);
      }
    };
    exports.FeatureFlags = FeatureFlags, _a = JSII_RTTI_SYMBOL_1, FeatureFlags[_a] = { fqn: "aws-cdk-lib.FeatureFlags", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/private/logical-id.js
var require_logical_id = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/logical-id.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.LogicalIDs = void 0;
    var LogicalIDs = class {
      constructor() {
        this.renames = {}, this.reverse = {};
      }
      addRename(oldId, newId) {
        if (oldId in this.renames)
          throw new Error(`A rename has already been registered for '${oldId}'`);
        this.renames[oldId] = newId;
      }
      applyRename(oldId) {
        let newId = oldId;
        if (oldId in this.renames && (newId = this.renames[oldId]), newId in this.reverse && this.reverse[newId] !== oldId)
          throw new Error(`Two objects have been assigned the same Logical ID: '${this.reverse[newId]}' and '${oldId}' are now both named '${newId}'.`);
        return this.reverse[newId] = oldId, validateLogicalId(newId), newId;
      }
      assertAllRenamesApplied() {
        const keys = /* @__PURE__ */ new Set();
        if (Object.keys(this.renames).forEach(keys.add.bind(keys)), Object.keys(this.reverse).map((newId) => {
          keys.delete(this.reverse[newId]);
        }), keys.size !== 0) {
          const unusedRenames = Array.from(keys.values());
          throw new Error(`The following Logical IDs were attempted to be renamed, but not found: ${unusedRenames.join(", ")}`);
        }
      }
    };
    exports.LogicalIDs = LogicalIDs;
    var VALID_LOGICALID_REGEX = /^[A-Za-z][A-Za-z0-9]{1,254}$/;
    function validateLogicalId(logicalId) {
      if (!VALID_LOGICALID_REGEX.test(logicalId))
        throw new Error(`Logical ID must adhere to the regular expression: ${VALID_LOGICALID_REGEX.toString()}, got '${logicalId}'`);
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/deps.js
var require_deps = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/deps.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.addDependency = void 0;
    var stack_1 = require_stack();
    var stage_1 = require_stage();
    var util_1 = require_util();
    function addDependency(source, target, reason) {
      if (source === target)
        return;
      const sourceStack = stack_1.Stack.of(source), targetStack = stack_1.Stack.of(target), sourceStage = stage_1.Stage.of(sourceStack), targetStage = stage_1.Stage.of(targetStack);
      if (sourceStage !== targetStage)
        throw new Error(`You cannot add a dependency from '${source.node.path}' (in ${describeStage(sourceStage)}) to '${target.node.path}' (in ${describeStage(targetStage)}): dependency cannot cross stage boundaries`);
      const sourcePath = util_1.pathToTopLevelStack(sourceStack), targetPath = util_1.pathToTopLevelStack(targetStack), commonStack = util_1.findLastCommonElement(sourcePath, targetPath);
      if (!commonStack) {
        const topLevelSource = sourcePath[0], topLevelTarget = targetPath[0];
        topLevelSource._addAssemblyDependency(topLevelTarget, reason);
        return;
      }
      if (commonStack === source)
        return;
      if (commonStack === target)
        throw new Error(`Nested stack '${sourceStack.node.path}' cannot depend on a parent stack '${targetStack.node.path}': ${reason}`);
      const sourceResource = resourceInCommonStackFor(source), targetResource = resourceInCommonStackFor(target);
      sourceResource._addResourceDependency(targetResource);
      function resourceInCommonStackFor(element) {
        const resource = stack_1.Stack.isStack(element) ? element.nestedStackResource : element;
        if (!resource)
          throw new Error("assertion failure");
        const resourceStack = stack_1.Stack.of(resource);
        return commonStack === resourceStack ? resource : resourceInCommonStackFor(resourceStack);
      }
    }
    exports.addDependency = addDependency;
    function describeStage(assembly) {
      return assembly ? assembly.parentStage ? `Stage '${assembly.node.path}'` : "the App" : "an unrooted construct tree";
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/stack-synthesizers/types.js
var require_types2 = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/stack-synthesizers/types.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/aws-cdk-lib/core/lib/stack-synthesizers/_shared.js
var require_shared = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/stack-synthesizers/_shared.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.resolvedOr = exports.StringSpecializer = exports.assertBound = exports.contentHash = exports.addStackArtifactToAssembly = void 0;
    var crypto = require("crypto");
    var cxschema = require_cloud_assembly_schema2();
    var cxapi = require_cx_api();
    var constructs_1 = require_lib4();
    var stack_1 = require_stack();
    var token_1 = require_token();
    function addStackArtifactToAssembly(session, stack, stackProps, additionalStackDependencies) {
      stack.tags.hasTags() && stack.node.addMetadata(cxschema.ArtifactMetadataEntryType.STACK_TAGS, stack.tags.renderTags());
      const deps = [...stack.dependencies.map((s) => s.artifactId), ...additionalStackDependencies], meta = collectStackMetadata(stack), stackNameProperty = stack.stackName === stack.artifactId ? {} : { stackName: stack.stackName }, properties = { templateFile: stack.templateFile, terminationProtection: stack.terminationProtection, tags: nonEmptyDict(stack.tags.tagValues()), validateOnSynth: session.validateOnSynth, ...stackProps, ...stackNameProperty };
      session.assembly.addArtifact(stack.artifactId, { type: cxschema.ArtifactType.AWS_CLOUDFORMATION_STACK, environment: stack.environment, properties, dependencies: deps.length > 0 ? deps : void 0, metadata: Object.keys(meta).length > 0 ? meta : void 0, displayName: stack.node.path });
    }
    exports.addStackArtifactToAssembly = addStackArtifactToAssembly;
    function collectStackMetadata(stack) {
      const output = {};
      return visit(stack), output;
      function visit(node) {
        if (findParentStack(node) === stack) {
          node.node.metadata.length > 0 && (output[constructs_1.Node.PATH_SEP + node.node.path] = node.node.metadata.map((md) => stack.resolve(md)));
          for (const child of node.node.children)
            visit(child);
        }
      }
      function findParentStack(node) {
        if (stack_1.Stack.isStack(node) && node.nestedStackParent === void 0)
          return node;
        if (!!node.node.scope)
          return findParentStack(node.node.scope);
      }
    }
    function contentHash(content) {
      return crypto.createHash("sha256").update(content).digest("hex");
    }
    exports.contentHash = contentHash;
    function assertBound(x) {
      if (x === null && x === void 0)
        throw new Error("You must call bindStack() first");
    }
    exports.assertBound = assertBound;
    function nonEmptyDict(xs) {
      return Object.keys(xs).length > 0 ? xs : void 0;
    }
    function replaceAll(s, search, replace) {
      return s.split(search).join(replace);
    }
    var StringSpecializer = class {
      constructor(stack, qualifier) {
        this.stack = stack, this.qualifier = qualifier;
      }
      specialize(s) {
        return s = replaceAll(s, "${Qualifier}", this.qualifier), cxapi.EnvironmentPlaceholders.replace(s, { region: resolvedOr(this.stack.region, cxapi.EnvironmentPlaceholders.CURRENT_REGION), accountId: resolvedOr(this.stack.account, cxapi.EnvironmentPlaceholders.CURRENT_ACCOUNT), partition: cxapi.EnvironmentPlaceholders.CURRENT_PARTITION });
      }
      qualifierOnly(s) {
        return replaceAll(s, "${Qualifier}", this.qualifier);
      }
    };
    exports.StringSpecializer = StringSpecializer;
    function resolvedOr(x, def) {
      return token_1.Token.isUnresolved(x) ? def : x;
    }
    exports.resolvedOr = resolvedOr;
  }
});

// node_modules/aws-cdk-lib/core/lib/stack-synthesizers/asset-manifest-builder.js
var require_asset_manifest_builder = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/stack-synthesizers/asset-manifest-builder.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.AssetManifestBuilder = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs = require("fs");
    var path = require("path");
    var cxschema = require_cloud_assembly_schema2();
    var assets_1 = require_assets3();
    var _shared_1 = require_shared();
    var AssetManifestBuilder = class {
      constructor() {
        this.files = {}, this.dockerImages = {};
      }
      defaultAddFileAsset(stack, asset, target) {
        var _a2, _b;
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack), jsiiDeprecationWarnings.aws_cdk_lib_FileAssetSource(asset), jsiiDeprecationWarnings.aws_cdk_lib_AssetManifestFileDestination(target);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.defaultAddFileAsset), error;
        }
        validateFileAssetSource(asset);
        const extension = asset.fileName != null ? path.extname(asset.fileName) : "", objectKey = (target.bucketPrefix ?? "") + asset.sourceHash + (asset.packaging === assets_1.FileAssetPackaging.ZIP_DIRECTORY ? ".zip" : extension);
        return this.addFileAsset(stack, asset.sourceHash, { path: asset.fileName, executable: asset.executable, packaging: asset.packaging }, { bucketName: target.bucketName, objectKey, region: _shared_1.resolvedOr(stack.region, void 0), assumeRoleArn: (_a2 = target.role) == null ? void 0 : _a2.assumeRoleArn, assumeRoleExternalId: (_b = target.role) == null ? void 0 : _b.assumeRoleExternalId });
      }
      defaultAddDockerImageAsset(stack, asset, target) {
        var _a2, _b;
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack), jsiiDeprecationWarnings.aws_cdk_lib_DockerImageAssetSource(asset), jsiiDeprecationWarnings.aws_cdk_lib_AssetManifestDockerImageDestination(target);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.defaultAddDockerImageAsset), error;
        }
        validateDockerImageAssetSource(asset);
        const imageTag = `${target.dockerTagPrefix ?? ""}${asset.sourceHash}`;
        return this.addDockerImageAsset(stack, asset.sourceHash, { executable: asset.executable, directory: asset.directoryName, dockerBuildArgs: asset.dockerBuildArgs, dockerBuildTarget: asset.dockerBuildTarget, dockerFile: asset.dockerFile, networkMode: asset.networkMode, platform: asset.platform }, { repositoryName: target.repositoryName, imageTag, region: _shared_1.resolvedOr(stack.region, void 0), assumeRoleArn: (_a2 = target.role) == null ? void 0 : _a2.assumeRoleArn, assumeRoleExternalId: (_b = target.role) == null ? void 0 : _b.assumeRoleExternalId });
      }
      addFileAsset(stack, sourceHash, source, dest) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack), jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_FileSource(source), jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_FileDestination(dest);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addFileAsset), error;
        }
        return this.files[sourceHash] || (this.files[sourceHash] = { source, destinations: {} }), this.files[sourceHash].destinations[this.manifestEnvName(stack)] = dest, dest;
      }
      addDockerImageAsset(stack, sourceHash, source, dest) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack), jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_DockerImageSource(source), jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_DockerImageDestination(dest);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addDockerImageAsset), error;
        }
        return this.dockerImages[sourceHash] || (this.dockerImages[sourceHash] = { source, destinations: {} }), this.dockerImages[sourceHash].destinations[this.manifestEnvName(stack)] = dest, dest;
      }
      get hasAssets() {
        return Object.keys(this.files).length + Object.keys(this.dockerImages).length > 0;
      }
      emitManifest(stack, session, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack), jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session), jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_AssetManifestOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.emitManifest), error;
        }
        const artifactId = `${stack.artifactId}.assets`, manifestFile = `${artifactId}.json`, outPath = path.join(session.assembly.outdir, manifestFile), manifest = { version: cxschema.Manifest.version(), files: this.files, dockerImages: this.dockerImages };
        return fs.writeFileSync(outPath, JSON.stringify(manifest, void 0, 2)), session.assembly.addArtifact(artifactId, { type: cxschema.ArtifactType.ASSET_MANIFEST, properties: { file: manifestFile, ...options } }), artifactId;
      }
      manifestEnvName(stack) {
        return [_shared_1.resolvedOr(stack.account, "current_account"), _shared_1.resolvedOr(stack.region, "current_region")].join("-");
      }
    };
    exports.AssetManifestBuilder = AssetManifestBuilder, _a = JSII_RTTI_SYMBOL_1, AssetManifestBuilder[_a] = { fqn: "aws-cdk-lib.AssetManifestBuilder", version: "2.50.0" };
    function validateFileAssetSource(asset) {
      if (!!asset.executable == !!asset.fileName)
        throw new Error(`Exactly one of 'fileName' or 'executable' is required, got: ${JSON.stringify(asset)}`);
      if (!!asset.packaging != !!asset.fileName)
        throw new Error(`'packaging' is expected in combination with 'fileName', got: ${JSON.stringify(asset)}`);
    }
    function validateDockerImageAssetSource(asset) {
      if (!!asset.executable == !!asset.directoryName)
        throw new Error(`Exactly one of 'directoryName' or 'executable' is required, got: ${JSON.stringify(asset)}`);
      check("dockerBuildArgs"), check("dockerBuildTarget"), check("dockerFile");
      function check(key) {
        if (asset[key] && !asset.directoryName)
          throw new Error(`'${key}' is only allowed in combination with 'directoryName', got: ${JSON.stringify(asset)}`);
      }
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/cfn-rule.js
var require_cfn_rule = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cfn-rule.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CfnRule = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_element_1 = require_cfn_element();
    var util_1 = require_util();
    var CfnRule = class extends cfn_element_1.CfnRefElement {
      constructor(scope, id, props) {
        super(scope, id);
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnRuleProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnRule), error;
        }
        this.ruleCondition = props && props.ruleCondition, this.assertions = props && props.assertions;
      }
      addAssertion(condition, description) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ICfnConditionExpression(condition);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addAssertion), error;
        }
        this.assertions || (this.assertions = []), this.assertions.push({ assert: condition, assertDescription: description });
      }
      _toCloudFormation() {
        return { Rules: { [this.logicalId]: { RuleCondition: this.ruleCondition, Assertions: util_1.capitalizePropertyNames(this, this.assertions) } } };
      }
    };
    exports.CfnRule = CfnRule, _a = JSII_RTTI_SYMBOL_1, CfnRule[_a] = { fqn: "aws-cdk-lib.CfnRule", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/stack-synthesizers/stack-synthesizer.js
var require_stack_synthesizer = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/stack-synthesizers/stack-synthesizer.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.StackSynthesizer = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs = require("fs");
    var path = require("path");
    var cxapi = require_cx_api();
    var assets_1 = require_assets3();
    var cfn_fn_1 = require_cfn_fn();
    var cfn_parameter_1 = require_cfn_parameter();
    var cfn_rule_1 = require_cfn_rule();
    var _shared_1 = require_shared();
    var StackSynthesizer = class {
      bind(stack) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.bind), error;
        }
        if (this._boundStack !== void 0)
          throw new Error("A StackSynthesizer can only be used for one Stack: create a new instance to use with a different Stack");
        this._boundStack = stack;
      }
      synthesizeStackTemplate(stack, session) {
        try {
          jsiiDeprecationWarnings.print("aws-cdk-lib.StackSynthesizer#synthesizeStackTemplate", "Use `synthesizeTemplate` instead"), jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack), jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.synthesizeStackTemplate), error;
        }
        stack._synthesizeTemplate(session);
      }
      synthesizeTemplate(session, lookupRoleArn) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.synthesizeTemplate), error;
        }
        return this.boundStack._synthesizeTemplate(session, lookupRoleArn), stackTemplateFileAsset(this.boundStack, session);
      }
      emitStackArtifact(stack, session, options = {}) {
        try {
          jsiiDeprecationWarnings.print("aws-cdk-lib.StackSynthesizer#emitStackArtifact", "Use `emitArtifact` instead"), jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack), jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session), jsiiDeprecationWarnings.aws_cdk_lib_SynthesizeStackArtifactOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.emitStackArtifact), error;
        }
        _shared_1.addStackArtifactToAssembly(session, stack, options ?? {}, options.additionalDependencies ?? []);
      }
      emitArtifact(session, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session), jsiiDeprecationWarnings.aws_cdk_lib_SynthesizeStackArtifactOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.emitArtifact), error;
        }
        _shared_1.addStackArtifactToAssembly(session, this.boundStack, options ?? {}, options.additionalDependencies ?? []);
      }
      addBootstrapVersionRule(requiredVersion, bootstrapStackVersionSsmParameter) {
        addBootstrapVersionRule(this.boundStack, requiredVersion, bootstrapStackVersionSsmParameter);
      }
      get boundStack() {
        if (!this._boundStack)
          throw new Error("The StackSynthesizer must be bound to a Stack first before boundStack() can be called");
        return this._boundStack;
      }
      cloudFormationLocationFromFileAsset(location) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_FileDestination(location);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.cloudFormationLocationFromFileAsset), error;
        }
        const { region, urlSuffix } = stackLocationOrInstrinsics(this.boundStack), httpUrl = cfnify(`https://s3.${region}.${urlSuffix}/${location.bucketName}/${location.objectKey}`), s3ObjectUrlWithPlaceholders = `s3://${location.bucketName}/${location.objectKey}`;
        return { bucketName: cfnify(location.bucketName), objectKey: cfnify(location.objectKey), httpUrl, s3ObjectUrl: cfnify(s3ObjectUrlWithPlaceholders), s3ObjectUrlWithPlaceholders, s3Url: httpUrl };
      }
      cloudFormationLocationFromDockerImageAsset(dest) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_DockerImageDestination(dest);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.cloudFormationLocationFromDockerImageAsset), error;
        }
        const { account, region, urlSuffix } = stackLocationOrInstrinsics(this.boundStack);
        return { repositoryName: cfnify(dest.repositoryName), imageUri: cfnify(`${account}.dkr.ecr.${region}.${urlSuffix}/${dest.repositoryName}:${dest.imageTag}`), imageTag: cfnify(dest.imageTag) };
      }
    };
    exports.StackSynthesizer = StackSynthesizer, _a = JSII_RTTI_SYMBOL_1, StackSynthesizer[_a] = { fqn: "aws-cdk-lib.StackSynthesizer", version: "2.50.0" };
    function stackTemplateFileAsset(stack, session) {
      const templatePath = path.join(session.assembly.outdir, stack.templateFile);
      if (!fs.existsSync(templatePath))
        throw new Error(`Stack template ${stack.stackName} not written yet: ${templatePath}`);
      const template = fs.readFileSync(templatePath, { encoding: "utf-8" }), sourceHash = _shared_1.contentHash(template);
      return { fileName: stack.templateFile, packaging: assets_1.FileAssetPackaging.FILE, sourceHash };
    }
    function addBootstrapVersionRule(stack, requiredVersion, bootstrapStackVersionSsmParameter) {
      if (stack.node.tryFindChild("BootstrapVersion"))
        return;
      const param = new cfn_parameter_1.CfnParameter(stack, "BootstrapVersion", { type: "AWS::SSM::Parameter::Value<String>", description: `Version of the CDK Bootstrap resources in this environment, automatically retrieved from SSM Parameter Store. ${cxapi.SSMPARAM_NO_INVALIDATE}`, default: bootstrapStackVersionSsmParameter }), oldVersions = range(1, requiredVersion).map((n) => `${n}`);
      new cfn_rule_1.CfnRule(stack, "CheckBootstrapVersion", { assertions: [{ assert: cfn_fn_1.Fn.conditionNot(cfn_fn_1.Fn.conditionContains(oldVersions, param.valueAsString)), assertDescription: `CDK bootstrap stack version ${requiredVersion} required. Please run 'cdk bootstrap' with a recent version of the CDK CLI.` }] });
    }
    function range(startIncl, endExcl) {
      const ret = new Array();
      for (let i = startIncl; i < endExcl; i++)
        ret.push(i);
      return ret;
    }
    function stackLocationOrInstrinsics(stack) {
      return { account: _shared_1.resolvedOr(stack.account, "${AWS::AccountId}"), region: _shared_1.resolvedOr(stack.region, "${AWS::Region}"), urlSuffix: _shared_1.resolvedOr(stack.urlSuffix, "${AWS::URLSuffix}") };
    }
    function cfnify(s) {
      return s.indexOf("${") > -1 ? cfn_fn_1.Fn.sub(s) : s;
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/stack-synthesizers/default-synthesizer.js
var require_default_synthesizer = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/stack-synthesizers/default-synthesizer.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.DefaultStackSynthesizer = exports.BOOTSTRAP_QUALIFIER_CONTEXT = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxapi = require_cx_api();
    var token_1 = require_token();
    var _shared_1 = require_shared();
    var asset_manifest_builder_1 = require_asset_manifest_builder();
    var stack_synthesizer_1 = require_stack_synthesizer();
    exports.BOOTSTRAP_QUALIFIER_CONTEXT = "@aws-cdk/core:bootstrapQualifier";
    var MIN_BOOTSTRAP_STACK_VERSION = 6;
    var MIN_LOOKUP_ROLE_BOOTSTRAP_STACK_VERSION = 8;
    var DefaultStackSynthesizer = class extends stack_synthesizer_1.StackSynthesizer {
      constructor(props = {}) {
        super(), this.props = props, this.assetManifest = new asset_manifest_builder_1.AssetManifestBuilder();
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_DefaultStackSynthesizerProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, DefaultStackSynthesizer), error;
        }
        this.useLookupRoleForStackOperations = props.useLookupRoleForStackOperations ?? true;
        for (const key in props)
          props.hasOwnProperty(key) && validateNoToken(key);
        function validateNoToken(key) {
          const prop = props[key];
          if (typeof prop == "string" && token_1.Token.isUnresolved(prop))
            throw new Error(`DefaultStackSynthesizer property '${key}' cannot contain tokens; only the following placeholder strings are allowed: ` + ["${Qualifier}", cxapi.EnvironmentPlaceholders.CURRENT_REGION, cxapi.EnvironmentPlaceholders.CURRENT_ACCOUNT, cxapi.EnvironmentPlaceholders.CURRENT_PARTITION].join(", "));
        }
      }
      bind(stack) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.bind), error;
        }
        super.bind(stack);
        const qualifier = this.props.qualifier ?? stack.node.tryGetContext(exports.BOOTSTRAP_QUALIFIER_CONTEXT) ?? DefaultStackSynthesizer.DEFAULT_QUALIFIER;
        this.qualifier = qualifier;
        const spec = new _shared_1.StringSpecializer(stack, qualifier);
        this.bucketName = spec.specialize(this.props.fileAssetsBucketName ?? DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME), this.repositoryName = spec.specialize(this.props.imageAssetsRepositoryName ?? DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME), this._deployRoleArn = spec.specialize(this.props.deployRoleArn ?? DefaultStackSynthesizer.DEFAULT_DEPLOY_ROLE_ARN), this._cloudFormationExecutionRoleArn = spec.specialize(this.props.cloudFormationExecutionRole ?? DefaultStackSynthesizer.DEFAULT_CLOUDFORMATION_ROLE_ARN), this.fileAssetPublishingRoleArn = spec.specialize(this.props.fileAssetPublishingRoleArn ?? DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN), this.imageAssetPublishingRoleArn = spec.specialize(this.props.imageAssetPublishingRoleArn ?? DefaultStackSynthesizer.DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN), this.lookupRoleArn = spec.specialize(this.props.lookupRoleArn ?? DefaultStackSynthesizer.DEFAULT_LOOKUP_ROLE_ARN), this.bucketPrefix = spec.specialize(this.props.bucketPrefix ?? DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX), this.dockerTagPrefix = spec.specialize(this.props.dockerTagPrefix ?? DefaultStackSynthesizer.DEFAULT_DOCKER_ASSET_PREFIX), this.bootstrapStackVersionSsmParameter = spec.qualifierOnly(this.props.bootstrapStackVersionSsmParameter ?? DefaultStackSynthesizer.DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER);
      }
      addFileAsset(asset) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_FileAssetSource(asset);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addFileAsset), error;
        }
        _shared_1.assertBound(this.bucketName);
        const location = this.assetManifest.defaultAddFileAsset(this.boundStack, asset, { bucketName: this.bucketName, bucketPrefix: this.bucketPrefix, role: this.fileAssetPublishingRoleArn ? { assumeRoleArn: this.fileAssetPublishingRoleArn, assumeRoleExternalId: this.props.fileAssetPublishingExternalId } : void 0 });
        return this.cloudFormationLocationFromFileAsset(location);
      }
      addDockerImageAsset(asset) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_DockerImageAssetSource(asset);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addDockerImageAsset), error;
        }
        _shared_1.assertBound(this.repositoryName);
        const location = this.assetManifest.defaultAddDockerImageAsset(this.boundStack, asset, { repositoryName: this.repositoryName, dockerTagPrefix: this.dockerTagPrefix, role: this.imageAssetPublishingRoleArn ? { assumeRoleArn: this.imageAssetPublishingRoleArn, assumeRoleExternalId: this.props.imageAssetPublishingExternalId } : void 0 });
        return this.cloudFormationLocationFromDockerImageAsset(location);
      }
      synthesizeStackTemplate(stack, session) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack), jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.synthesizeStackTemplate), error;
        }
        stack._synthesizeTemplate(session, this.lookupRoleArn);
      }
      get stack() {
        try {
          jsiiDeprecationWarnings.print("aws-cdk-lib.DefaultStackSynthesizer#stack", "Use `boundStack` instead.");
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, jsiiDeprecationWarnings.getPropertyDescriptor(this, "stack").get), error;
        }
        return this.boundStack;
      }
      synthesize(session) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.synthesize), error;
        }
        _shared_1.assertBound(this.qualifier), (this.props.generateBootstrapVersionRule ?? true) && this.addBootstrapVersionRule(MIN_BOOTSTRAP_STACK_VERSION, this.bootstrapStackVersionSsmParameter);
        const templateAssetSource = this.synthesizeTemplate(session, this.lookupRoleArn), templateAsset = this.addFileAsset(templateAssetSource), assetManifestId = this.assetManifest.emitManifest(this.boundStack, session, { requiresBootstrapStackVersion: MIN_BOOTSTRAP_STACK_VERSION, bootstrapStackVersionSsmParameter: this.bootstrapStackVersionSsmParameter });
        this.emitArtifact(session, { assumeRoleExternalId: this.props.deployRoleExternalId, assumeRoleArn: this._deployRoleArn, cloudFormationExecutionRoleArn: this._cloudFormationExecutionRoleArn, stackTemplateAssetObjectUrl: templateAsset.s3ObjectUrlWithPlaceholders, requiresBootstrapStackVersion: MIN_BOOTSTRAP_STACK_VERSION, bootstrapStackVersionSsmParameter: this.bootstrapStackVersionSsmParameter, additionalDependencies: [assetManifestId], lookupRole: this.useLookupRoleForStackOperations && this.lookupRoleArn ? { arn: this.lookupRoleArn, assumeRoleExternalId: this.props.lookupRoleExternalId, requiresBootstrapStackVersion: MIN_LOOKUP_ROLE_BOOTSTRAP_STACK_VERSION, bootstrapStackVersionSsmParameter: this.bootstrapStackVersionSsmParameter } : void 0 });
      }
      get deployRoleArn() {
        if (!this._deployRoleArn)
          throw new Error("deployRoleArn getter can only be called after the synthesizer has been bound to a Stack");
        return this._deployRoleArn;
      }
      get cloudFormationExecutionRoleArn() {
        if (!this._cloudFormationExecutionRoleArn)
          throw new Error("cloudFormationExecutionRoleArn getter can only be called after the synthesizer has been bound to a Stack");
        return this._cloudFormationExecutionRoleArn;
      }
    };
    exports.DefaultStackSynthesizer = DefaultStackSynthesizer, _a = JSII_RTTI_SYMBOL_1, DefaultStackSynthesizer[_a] = { fqn: "aws-cdk-lib.DefaultStackSynthesizer", version: "2.50.0" }, DefaultStackSynthesizer.DEFAULT_QUALIFIER = "hnb659fds", DefaultStackSynthesizer.DEFAULT_CLOUDFORMATION_ROLE_ARN = "arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-cfn-exec-role-${AWS::AccountId}-${AWS::Region}", DefaultStackSynthesizer.DEFAULT_DEPLOY_ROLE_ARN = "arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-deploy-role-${AWS::AccountId}-${AWS::Region}", DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PUBLISHING_ROLE_ARN = "arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-file-publishing-role-${AWS::AccountId}-${AWS::Region}", DefaultStackSynthesizer.DEFAULT_IMAGE_ASSET_PUBLISHING_ROLE_ARN = "arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-image-publishing-role-${AWS::AccountId}-${AWS::Region}", DefaultStackSynthesizer.DEFAULT_LOOKUP_ROLE_ARN = "arn:${AWS::Partition}:iam::${AWS::AccountId}:role/cdk-${Qualifier}-lookup-role-${AWS::AccountId}-${AWS::Region}", DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME = "cdk-${Qualifier}-container-assets-${AWS::AccountId}-${AWS::Region}", DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME = "cdk-${Qualifier}-assets-${AWS::AccountId}-${AWS::Region}", DefaultStackSynthesizer.DEFAULT_FILE_ASSET_KEY_ARN_EXPORT_NAME = "CdkBootstrap-${Qualifier}-FileAssetKeyArn", DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX = "", DefaultStackSynthesizer.DEFAULT_DOCKER_ASSET_PREFIX = "", DefaultStackSynthesizer.DEFAULT_BOOTSTRAP_STACK_VERSION_SSM_PARAMETER = "/cdk-bootstrap/${Qualifier}/version";
  }
});

// node_modules/aws-cdk-lib/core/lib/private/asset-parameters.js
var require_asset_parameters = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/asset-parameters.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.FileAssetParameters = void 0;
    var constructs_1 = require_lib4();
    var cfn_parameter_1 = require_cfn_parameter();
    var FileAssetParameters = class extends constructs_1.Construct {
      constructor(scope, id) {
        super(scope, id), this.bucketNameParameter = new cfn_parameter_1.CfnParameter(this, "S3Bucket", { type: "String", description: `S3 bucket for asset "${id}"` }), this.objectKeyParameter = new cfn_parameter_1.CfnParameter(this, "S3VersionKey", { type: "String", description: `S3 key for asset version "${id}"` }), this.artifactHashParameter = new cfn_parameter_1.CfnParameter(this, "ArtifactHash", { description: `Artifact hash for asset "${id}"`, type: "String" });
      }
    };
    exports.FileAssetParameters = FileAssetParameters;
  }
});

// node_modules/aws-cdk-lib/core/lib/stack-synthesizers/legacy.js
var require_legacy = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/stack-synthesizers/legacy.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.LegacyStackSynthesizer = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxschema = require_cloud_assembly_schema2();
    var cxapi = require_cx_api();
    var constructs_1 = require_lib4();
    var cfn_fn_1 = require_cfn_fn();
    var asset_parameters_1 = require_asset_parameters();
    var _shared_1 = require_shared();
    var stack_synthesizer_1 = require_stack_synthesizer();
    var ASSETS_ECR_REPOSITORY_NAME = "aws-cdk/assets";
    var ASSETS_ECR_REPOSITORY_NAME_OVERRIDE_CONTEXT_KEY = "assets-ecr-repository-name";
    var LegacyStackSynthesizer = class extends stack_synthesizer_1.StackSynthesizer {
      constructor() {
        super(...arguments), this.cycle = false, this.addedImageAssets = /* @__PURE__ */ new Set();
      }
      addFileAsset(asset) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_FileAssetSource(asset);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addFileAsset), error;
        }
        if (this.cycle)
          return this.doAddFileAsset(asset);
        this.cycle = true;
        try {
          const stack = this.boundStack;
          return withoutDeprecationWarnings(() => stack.addFileAsset(asset));
        } finally {
          this.cycle = false;
        }
      }
      addDockerImageAsset(asset) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_DockerImageAssetSource(asset);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addDockerImageAsset), error;
        }
        if (this.cycle)
          return this.doAddDockerImageAsset(asset);
        this.cycle = true;
        try {
          const stack = this.boundStack;
          return withoutDeprecationWarnings(() => stack.addDockerImageAsset(asset));
        } finally {
          this.cycle = false;
        }
      }
      synthesize(session) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.synthesize), error;
        }
        this.synthesizeTemplate(session), this.emitArtifact(session);
      }
      doAddDockerImageAsset(asset) {
        const repositoryNameOverride = this.boundStack.node.tryGetContext(ASSETS_ECR_REPOSITORY_NAME_OVERRIDE_CONTEXT_KEY), repositoryName = asset.repositoryName ?? repositoryNameOverride ?? ASSETS_ECR_REPOSITORY_NAME, imageTag = asset.sourceHash, assetId = asset.sourceHash;
        if (!this.addedImageAssets.has(assetId)) {
          if (!asset.directoryName)
            throw new Error(`LegacyStackSynthesizer does not support this type of file asset: ${JSON.stringify(asset)}`);
          const metadata = { repositoryName, imageTag, id: assetId, packaging: "container-image", path: asset.directoryName, sourceHash: asset.sourceHash, buildArgs: asset.dockerBuildArgs, target: asset.dockerBuildTarget, file: asset.dockerFile, networkMode: asset.networkMode, platform: asset.platform };
          this.boundStack.node.addMetadata(cxschema.ArtifactMetadataEntryType.ASSET, metadata), this.addedImageAssets.add(assetId);
        }
        return { imageUri: `${this.boundStack.account}.dkr.ecr.${this.boundStack.region}.${this.boundStack.urlSuffix}/${repositoryName}:${imageTag}`, repositoryName };
      }
      doAddFileAsset(asset) {
        let params = this.assetParameters.node.tryFindChild(asset.sourceHash);
        if (!params) {
          if (params = new asset_parameters_1.FileAssetParameters(this.assetParameters, asset.sourceHash), !asset.fileName || !asset.packaging)
            throw new Error(`LegacyStackSynthesizer does not support this type of file asset: ${JSON.stringify(asset)}`);
          const metadata = { path: asset.fileName, id: asset.sourceHash, packaging: asset.packaging, sourceHash: asset.sourceHash, s3BucketParameter: params.bucketNameParameter.logicalId, s3KeyParameter: params.objectKeyParameter.logicalId, artifactHashParameter: params.artifactHashParameter.logicalId };
          this.boundStack.node.addMetadata(cxschema.ArtifactMetadataEntryType.ASSET, metadata);
        }
        const bucketName = params.bucketNameParameter.valueAsString, encodedKey = params.objectKeyParameter.valueAsString, s3Prefix = cfn_fn_1.Fn.select(0, cfn_fn_1.Fn.split(cxapi.ASSET_PREFIX_SEPARATOR, encodedKey)), s3Filename = cfn_fn_1.Fn.select(1, cfn_fn_1.Fn.split(cxapi.ASSET_PREFIX_SEPARATOR, encodedKey)), objectKey = `${s3Prefix}${s3Filename}`, httpUrl = `https://s3.${this.boundStack.region}.${this.boundStack.urlSuffix}/${bucketName}/${objectKey}`, s3ObjectUrl = `s3://${bucketName}/${objectKey}`;
        return { bucketName, objectKey, httpUrl, s3ObjectUrl, s3Url: httpUrl };
      }
      get assetParameters() {
        return _shared_1.assertBound(this.boundStack), this._assetParameters || (this._assetParameters = new constructs_1.Construct(this.boundStack, "AssetParameters")), this._assetParameters;
      }
    };
    exports.LegacyStackSynthesizer = LegacyStackSynthesizer, _a = JSII_RTTI_SYMBOL_1, LegacyStackSynthesizer[_a] = { fqn: "aws-cdk-lib.LegacyStackSynthesizer", version: "2.50.0" };
    function withoutDeprecationWarnings(block) {
      const orig = process.env.JSII_DEPRECATED;
      process.env.JSII_DEPRECATED = "quiet";
      try {
        return block();
      } finally {
        process.env.JSII_DEPRECATED = orig;
      }
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/stack-synthesizers/bootstrapless-synthesizer.js
var require_bootstrapless_synthesizer = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/stack-synthesizers/bootstrapless-synthesizer.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.BootstraplessSynthesizer = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var default_synthesizer_1 = require_default_synthesizer();
    var BootstraplessSynthesizer = class extends default_synthesizer_1.DefaultStackSynthesizer {
      constructor(props) {
        super({ deployRoleArn: props.deployRoleArn, cloudFormationExecutionRole: props.cloudFormationExecutionRoleArn, generateBootstrapVersionRule: false });
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_BootstraplessSynthesizerProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, BootstraplessSynthesizer), error;
        }
      }
      addFileAsset(_asset) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_FileAssetSource(_asset);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addFileAsset), error;
        }
        throw new Error("Cannot add assets to a Stack that uses the BootstraplessSynthesizer");
      }
      addDockerImageAsset(_asset) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_DockerImageAssetSource(_asset);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addDockerImageAsset), error;
        }
        throw new Error("Cannot add assets to a Stack that uses the BootstraplessSynthesizer");
      }
      synthesize(session) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.synthesize), error;
        }
        this.synthesizeStackTemplate(this.boundStack, session), this.emitArtifact(session, { assumeRoleArn: this.deployRoleArn, cloudFormationExecutionRoleArn: this.cloudFormationExecutionRoleArn });
      }
    };
    exports.BootstraplessSynthesizer = BootstraplessSynthesizer, _a = JSII_RTTI_SYMBOL_1, BootstraplessSynthesizer[_a] = { fqn: "aws-cdk-lib.BootstraplessSynthesizer", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/stack-synthesizers/nested.js
var require_nested = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/stack-synthesizers/nested.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.NestedStackSynthesizer = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var stack_synthesizer_1 = require_stack_synthesizer();
    var NestedStackSynthesizer = class extends stack_synthesizer_1.StackSynthesizer {
      constructor(parentDeployment) {
        super(), this.parentDeployment = parentDeployment;
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IStackSynthesizer(parentDeployment);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, NestedStackSynthesizer), error;
        }
      }
      addFileAsset(asset) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_FileAssetSource(asset);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addFileAsset), error;
        }
        return this.parentDeployment.addFileAsset(asset);
      }
      addDockerImageAsset(asset) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_DockerImageAssetSource(asset);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addDockerImageAsset), error;
        }
        return this.parentDeployment.addDockerImageAsset(asset);
      }
      synthesize(session) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.synthesize), error;
        }
        this.synthesizeTemplate(session);
      }
    };
    exports.NestedStackSynthesizer = NestedStackSynthesizer, _a = JSII_RTTI_SYMBOL_1, NestedStackSynthesizer[_a] = { fqn: "aws-cdk-lib.NestedStackSynthesizer", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/stack-synthesizers/cli-credentials-synthesizer.js
var require_cli_credentials_synthesizer = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/stack-synthesizers/cli-credentials-synthesizer.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CliCredentialsStackSynthesizer = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxapi = require_cx_api();
    var token_1 = require_token();
    var _shared_1 = require_shared();
    var asset_manifest_builder_1 = require_asset_manifest_builder();
    var default_synthesizer_1 = require_default_synthesizer();
    var stack_synthesizer_1 = require_stack_synthesizer();
    var CliCredentialsStackSynthesizer = class extends stack_synthesizer_1.StackSynthesizer {
      constructor(props = {}) {
        super(), this.props = props, this.assetManifest = new asset_manifest_builder_1.AssetManifestBuilder();
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CliCredentialsStackSynthesizerProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CliCredentialsStackSynthesizer), error;
        }
        for (const key in props)
          props.hasOwnProperty(key) && validateNoToken(key);
        function validateNoToken(key) {
          const prop = props[key];
          if (typeof prop == "string" && token_1.Token.isUnresolved(prop))
            throw new Error(`CliCredentialsStackSynthesizer property '${key}' cannot contain tokens; only the following placeholder strings are allowed: ` + ["${Qualifier}", cxapi.EnvironmentPlaceholders.CURRENT_REGION, cxapi.EnvironmentPlaceholders.CURRENT_ACCOUNT, cxapi.EnvironmentPlaceholders.CURRENT_PARTITION].join(", "));
        }
      }
      bind(stack) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_Stack(stack);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.bind), error;
        }
        super.bind(stack);
        const qualifier = this.props.qualifier ?? stack.node.tryGetContext(default_synthesizer_1.BOOTSTRAP_QUALIFIER_CONTEXT) ?? default_synthesizer_1.DefaultStackSynthesizer.DEFAULT_QUALIFIER;
        this.qualifier = qualifier;
        const spec = new _shared_1.StringSpecializer(stack, qualifier);
        this.bucketName = spec.specialize(this.props.fileAssetsBucketName ?? default_synthesizer_1.DefaultStackSynthesizer.DEFAULT_FILE_ASSETS_BUCKET_NAME), this.repositoryName = spec.specialize(this.props.imageAssetsRepositoryName ?? default_synthesizer_1.DefaultStackSynthesizer.DEFAULT_IMAGE_ASSETS_REPOSITORY_NAME), this.bucketPrefix = spec.specialize(this.props.bucketPrefix ?? default_synthesizer_1.DefaultStackSynthesizer.DEFAULT_FILE_ASSET_PREFIX), this.dockerTagPrefix = spec.specialize(this.props.dockerTagPrefix ?? default_synthesizer_1.DefaultStackSynthesizer.DEFAULT_DOCKER_ASSET_PREFIX);
      }
      addFileAsset(asset) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_FileAssetSource(asset);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addFileAsset), error;
        }
        _shared_1.assertBound(this.bucketName);
        const location = this.assetManifest.defaultAddFileAsset(this.boundStack, asset, { bucketName: this.bucketName, bucketPrefix: this.bucketPrefix });
        return this.cloudFormationLocationFromFileAsset(location);
      }
      addDockerImageAsset(asset) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_DockerImageAssetSource(asset);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addDockerImageAsset), error;
        }
        _shared_1.assertBound(this.repositoryName);
        const location = this.assetManifest.defaultAddDockerImageAsset(this.boundStack, asset, { repositoryName: this.repositoryName, dockerTagPrefix: this.dockerTagPrefix });
        return this.cloudFormationLocationFromDockerImageAsset(location);
      }
      synthesize(session) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ISynthesisSession(session);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.synthesize), error;
        }
        _shared_1.assertBound(this.qualifier);
        const templateAssetSource = this.synthesizeTemplate(session), templateAsset = this.addFileAsset(templateAssetSource), assetManifestId = this.assetManifest.emitManifest(this.boundStack, session);
        this.emitArtifact(session, { stackTemplateAssetObjectUrl: templateAsset.s3ObjectUrlWithPlaceholders, additionalDependencies: [assetManifestId] });
      }
    };
    exports.CliCredentialsStackSynthesizer = CliCredentialsStackSynthesizer, _a = JSII_RTTI_SYMBOL_1, CliCredentialsStackSynthesizer[_a] = { fqn: "aws-cdk-lib.CliCredentialsStackSynthesizer", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/stack-synthesizers/index.js
var require_stack_synthesizers = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/stack-synthesizers/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        p !== "default" && !exports2.hasOwnProperty(p) && __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true }), __exportStar(require_types2(), exports), __exportStar(require_default_synthesizer(), exports), __exportStar(require_legacy(), exports), __exportStar(require_bootstrapless_synthesizer(), exports), __exportStar(require_nested(), exports), __exportStar(require_stack_synthesizer(), exports), __exportStar(require_cli_credentials_synthesizer(), exports), __exportStar(require_asset_manifest_builder(), exports);
  }
});

// node_modules/aws-cdk-lib/core/lib/cfn-mapping.js
var require_cfn_mapping = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cfn-mapping.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CfnMapping = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var annotations_1 = require_annotations();
    var cfn_element_1 = require_cfn_element();
    var cfn_fn_1 = require_cfn_fn();
    var stack_1 = require_stack();
    var token_1 = require_token();
    var CfnMapping = class extends cfn_element_1.CfnRefElement {
      constructor(scope, id, props = {}) {
        super(scope, id), this.lazyRender = false, this.lazyInformed = false;
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnMappingProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnMapping), error;
        }
        this.mapping = props.mapping ? this.validateMapping(props.mapping) : {}, this.lazy = props.lazy;
      }
      setValue(key1, key2, value) {
        this.validateAlphanumeric(key2), key1 in this.mapping || (this.mapping[key1] = {}), this.mapping[key1][key2] = value;
      }
      findInMap(key1, key2) {
        let fullyResolved = false;
        if (!token_1.Token.isUnresolved(key1)) {
          if (!(key1 in this.mapping))
            throw new Error(`Mapping doesn't contain top-level key '${key1}'`);
          if (!token_1.Token.isUnresolved(key2)) {
            if (!(key2 in this.mapping[key1]))
              throw new Error(`Mapping doesn't contain second-level key '${key2}'`);
            fullyResolved = true;
          }
        }
        if (fullyResolved) {
          if (this.lazy)
            return this.mapping[key1][key2];
        } else
          this.lazyRender = true;
        return new CfnMappingEmbedder(this, this.mapping, key1, key2).toString();
      }
      _toCloudFormation() {
        return this.lazy === void 0 && !this.lazyRender && this.informLazyUse(), !this.lazy || this.lazy && this.lazyRender ? { Mappings: { [this.logicalId]: this.mapping } } : {};
      }
      informLazyUse() {
        this.lazyInformed || annotations_1.Annotations.of(this).addInfo("Consider making this CfnMapping a lazy mapping by providing `lazy: true`: either no findInMap was called or every findInMap could be immediately resolved without using Fn::FindInMap"), this.lazyInformed = true;
      }
      validateMapping(mapping) {
        return Object.keys(mapping).forEach((m) => Object.keys(mapping[m]).forEach(this.validateAlphanumeric)), mapping;
      }
      validateAlphanumeric(value) {
        if (value.match(/[^a-zA-Z0-9]/g))
          throw new Error(`Attribute name '${value}' must contain only alphanumeric characters.`);
      }
    };
    exports.CfnMapping = CfnMapping, _a = JSII_RTTI_SYMBOL_1, CfnMapping[_a] = { fqn: "aws-cdk-lib.CfnMapping", version: "2.50.0" };
    var CfnMappingEmbedder = class {
      constructor(cfnMapping, mapping, key1, key2) {
        this.cfnMapping = cfnMapping, this.mapping = mapping, this.key1 = key1, this.key2 = key2, this.creationStack = [];
      }
      resolve(context) {
        const consumingStack = stack_1.Stack.of(context.scope);
        if (consumingStack === stack_1.Stack.of(this.cfnMapping))
          return cfn_fn_1.Fn.findInMap(this.cfnMapping.logicalId, this.key1, this.key2);
        const constructScope = consumingStack, constructId = `MappingCopy-${this.cfnMapping.node.id}-${this.cfnMapping.node.addr}`;
        let mappingCopy = constructScope.node.tryFindChild(constructId);
        return mappingCopy || (mappingCopy = new CfnMapping(constructScope, constructId, { mapping: this.mapping })), cfn_fn_1.Fn.findInMap(mappingCopy.logicalId, this.key1, this.key2);
      }
      toString() {
        return token_1.Token.asString(this);
      }
    };
  }
});

// node_modules/aws-cdk-lib/core/lib/private/region-lookup.js
var require_region_lookup = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/region-lookup.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.deployTimeLookup = void 0;
    var cxapi = require_cx_api();
    var region_info_1 = require_region_info2();
    var cfn_mapping_1 = require_cfn_mapping();
    var cfn_pseudo_1 = require_cfn_pseudo();
    function deployTimeLookup(stack, factName, lookupMap, defaultValue) {
      if (Object.values(lookupMap).length === 0) {
        if (defaultValue === void 0)
          throw new Error(`region-info: don't have any information for ${factName}. Use 'Fact.register' to provide values, or add partitions to the '${cxapi.TARGET_PARTITIONS}' context value.`);
        return defaultValue;
      }
      const pattern = findValuePattern(lookupMap);
      if (pattern !== void 0)
        return pattern;
      const [factClass, factParam] = factName.includes(":") ? factName.split(":") : [factName, "value"], mapId = `${ucfirst(factClass)}Map`, factKey = factParam.replace(/[^a-zA-Z0-9]/g, "x");
      let mapping = stack.node.tryFindChild(mapId);
      mapping || (mapping = new cfn_mapping_1.CfnMapping(stack, mapId));
      for (const [region, value] of Object.entries(lookupMap))
        mapping.setValue(region, factKey, value);
      return mapping.findInMap(cfn_pseudo_1.Aws.REGION, factKey);
    }
    exports.deployTimeLookup = deployTimeLookup;
    function ucfirst(x) {
      return `${x.slice(0, 1).toUpperCase()}${x.slice(1)}`;
    }
    function findValuePattern(regionMap) {
      const simplified = { ...regionMap }, urlSuffixes = Object.keys(simplified).map(urlSuffix);
      if (!allSame(urlSuffixes) && Object.entries(simplified).every(([region, value]) => value.includes(urlSuffix(region))))
        for (const region in simplified)
          simplified[region] = replaceAll(simplified[region], urlSuffix(region), cfn_pseudo_1.Aws.URL_SUFFIX);
      if (Object.entries(simplified).every(([region, value]) => value.includes(region)))
        for (const region in simplified)
          simplified[region] = replaceAll(simplified[region], region, cfn_pseudo_1.Aws.REGION);
      const values = Object.values(simplified);
      if (allSame(values))
        return values[0];
    }
    function allSame(xs) {
      return xs.every((x) => x === xs[0]);
    }
    function urlSuffix(region) {
      var _a;
      return ((_a = region_info_1.RegionInfo.get(region)) == null ? void 0 : _a.domainSuffix) ?? "amazonaws.com";
    }
    function replaceAll(x, pat, replacement) {
      return x.split(pat).join(replacement);
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/stack.js
var require_stack = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/stack.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.rootPathTo = exports.Stack = exports.STACK_RESOURCE_LIMIT_CONTEXT = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var fs = require("fs");
    var path = require("path");
    var cxschema = require_cloud_assembly_schema2();
    var cxapi = require_cx_api();
    var constructs_1 = require_lib4();
    var minimatch = require_minimatch();
    var annotations_1 = require_annotations();
    var app_1 = require_app2();
    var arn_1 = require_arn();
    var cfn_element_1 = require_cfn_element();
    var cfn_fn_1 = require_cfn_fn();
    var cfn_pseudo_1 = require_cfn_pseudo();
    var cfn_resource_1 = require_cfn_resource();
    var context_provider_1 = require_context_provider();
    var feature_flags_1 = require_feature_flags();
    var cloudformation_lang_1 = require_cloudformation_lang();
    var logical_id_1 = require_logical_id();
    var resolve_1 = require_resolve();
    var uniqueid_1 = require_uniqueid2();
    var STACK_SYMBOL = Symbol.for("@aws-cdk/core.Stack");
    var MY_STACK_CACHE = Symbol.for("@aws-cdk/core.Stack.myStack");
    exports.STACK_RESOURCE_LIMIT_CONTEXT = "@aws-cdk/core:stackResourceLimit";
    var VALID_STACK_NAME_REGEX = /^[A-Za-z][A-Za-z0-9-]*$/;
    var MAX_RESOURCES = 500;
    var Stack2 = class extends constructs_1.Construct {
      constructor(scope, id, props = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_StackProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, Stack2), error;
        }
        scope = scope ?? new app_1.App({ autoSynth: false, outdir: fs_1.FileSystem.mkdtemp("cdk-test-app-") }), id = id ?? "Default", super(scope, id), this._missingContext = new Array(), this._stackDependencies = {}, this.templateOptions = {}, this._crossRegionReferences = !!props.crossRegionReferences, Object.defineProperty(this, STACK_SYMBOL, { value: true }), this._logicalIds = new logical_id_1.LogicalIDs();
        const { account, region, environment } = this.parseEnvironment(props.env);
        if (this.account = account, this.region = region, this.environment = environment, this.terminationProtection = props.terminationProtection, props.description !== void 0) {
          if (props.description.length > 512)
            throw new Error(`Stack description must be <= 1024 bytes. Received description: '${props.description}'`);
          this.templateOptions.description = props.description;
        }
        if (this._stackName = props.stackName ?? this.generateStackName(), this._stackName.length > 128)
          throw new Error(`Stack name must be <= 128 characters. Stack name: '${this._stackName}'`);
        if (this.tags = new tag_manager_1.TagManager(cfn_resource_1.TagType.KEY_VALUE, "aws:cdk:stack", props.tags), !VALID_STACK_NAME_REGEX.test(this.stackName))
          throw new Error(`Stack name must match the regular expression: ${VALID_STACK_NAME_REGEX.toString()}, got '${this.stackName}'`);
        const featureFlags = feature_flags_1.FeatureFlags.of(this), stackNameDupeContext = featureFlags.isEnabled(cxapi.ENABLE_STACK_NAME_DUPLICATES_CONTEXT), newStyleSynthesisContext = featureFlags.isEnabled(cxapi.NEW_STYLE_STACK_SYNTHESIS_CONTEXT);
        this.artifactId = stackNameDupeContext || newStyleSynthesisContext ? this.generateStackArtifactId() : this.stackName, this.templateFile = `${this.artifactId}.template.json`, this._versionReportingEnabled = (props.analyticsReporting ?? this.node.tryGetContext(cxapi.ANALYTICS_REPORTING_ENABLED_CONTEXT)) && !this.nestedStackParent, this.synthesizer = props.synthesizer ?? (newStyleSynthesisContext ? new stack_synthesizers_1.DefaultStackSynthesizer() : new stack_synthesizers_1.LegacyStackSynthesizer()), this.synthesizer.bind(this);
      }
      static isStack(x) {
        return x !== null && typeof x == "object" && STACK_SYMBOL in x;
      }
      static of(construct) {
        const cache = construct[MY_STACK_CACHE];
        if (cache)
          return cache;
        {
          const value = _lookup(construct);
          return Object.defineProperty(construct, MY_STACK_CACHE, { enumerable: false, writable: false, configurable: false, value }), value;
        }
        function _lookup(c) {
          var _a2;
          if (Stack2.isStack(c))
            return c;
          const _scope = constructs_1.Node.of(c).scope;
          if (stage_1.Stage.isStage(c) || !_scope)
            throw new Error(`${((_a2 = construct.constructor) == null ? void 0 : _a2.name) ?? "Construct"} at '${constructs_1.Node.of(construct).path}' should be created in the scope of a Stack, but no Stack found`);
          return _lookup(_scope);
        }
      }
      resolve(obj) {
        return resolve_1.resolve(obj, { scope: this, prefix: [], resolver: cloudformation_lang_1.CLOUDFORMATION_TOKEN_RESOLVER, preparing: false });
      }
      toJsonString(obj, space) {
        return cloudformation_lang_1.CloudFormationLang.toJSON(obj, space).toString();
      }
      reportMissingContext(report) {
        if (!Object.values(cxschema.ContextProvider).includes(report.provider))
          throw new Error(`Unknown context provider requested in: ${JSON.stringify(report)}`);
        this.reportMissingContextKey(report);
      }
      reportMissingContextKey(report) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_cloud_assembly_schema_MissingContext(report);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.reportMissingContextKey), error;
        }
        this._missingContext.push(report);
      }
      renameLogicalId(oldId, newId) {
        this._logicalIds.addRename(oldId, newId);
      }
      getLogicalId(element) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnElement(element);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.getLogicalId), error;
        }
        const logicalId = this.allocateLogicalId(element);
        return this._logicalIds.applyRename(logicalId);
      }
      addDependency(target, reason) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_Stack(target);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addDependency), error;
        }
        deps_1.addDependency(this, target, reason);
      }
      get dependencies() {
        return Object.values(this._stackDependencies).map((x) => x.stack);
      }
      get stackName() {
        return this._stackName;
      }
      get partition() {
        return !feature_flags_1.FeatureFlags.of(this).isEnabled(cxapi.ENABLE_PARTITION_LITERALS) || token_1.Token.isUnresolved(this.region) ? cfn_pseudo_1.Aws.PARTITION : region_info_1.RegionInfo.get(this.region).partition ?? cfn_pseudo_1.Aws.PARTITION;
      }
      get urlSuffix() {
        return cfn_pseudo_1.Aws.URL_SUFFIX;
      }
      get stackId() {
        return new cfn_pseudo_1.ScopedAws(this).stackId;
      }
      get notificationArns() {
        return new cfn_pseudo_1.ScopedAws(this).notificationArns;
      }
      get nested() {
        return this.nestedStackResource !== void 0;
      }
      formatArn(components) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ArnComponents(components);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.formatArn), error;
        }
        return arn_1.Arn.format(components, this);
      }
      parseArn(arn, sepIfToken = "/", hasName = true) {
        return arn_1.Arn.parse(arn, sepIfToken, hasName);
      }
      splitArn(arn, arnFormat) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ArnFormat(arnFormat);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.splitArn), error;
        }
        return arn_1.Arn.split(arn, arnFormat);
      }
      get availabilityZones() {
        if (token_1.Token.isUnresolved(this.account) || token_1.Token.isUnresolved(this.region))
          return this.node.tryGetContext(cxapi.AVAILABILITY_ZONE_FALLBACK_CONTEXT_KEY) || [cfn_fn_1.Fn.select(0, cfn_fn_1.Fn.getAzs()), cfn_fn_1.Fn.select(1, cfn_fn_1.Fn.getAzs())];
        const value = context_provider_1.ContextProvider.getValue(this, { provider: cxschema.ContextProvider.AVAILABILITY_ZONE_PROVIDER, dummyValue: ["dummy1a", "dummy1b", "dummy1c"] }).value;
        if (!Array.isArray(value))
          throw new Error(`Provider ${cxschema.ContextProvider.AVAILABILITY_ZONE_PROVIDER} expects a list`);
        return value;
      }
      addFileAsset(asset) {
        return this.synthesizer.addFileAsset(asset);
      }
      addDockerImageAsset(asset) {
        return this.synthesizer.addDockerImageAsset(asset);
      }
      get nestedStackParent() {
        return this.nestedStackResource && Stack2.of(this.nestedStackResource);
      }
      get parentStack() {
        return this.nestedStackParent;
      }
      addTransform(transform) {
        this.templateOptions.transforms || (this.templateOptions.transforms = []), this.templateOptions.transforms.push(transform);
      }
      addMetadata(key, value) {
        this.templateOptions.metadata || (this.templateOptions.metadata = {}), this.templateOptions.metadata[key] = value;
      }
      _addAssemblyDependency(target, reason) {
        if (this.nested || target.nested)
          throw new Error("Cannot add assembly-level dependencies for nested stacks");
        reason = reason || "dependency added using stack.addDependency()";
        const cycle = target.stackDependencyReasons(this);
        if (cycle !== void 0)
          throw new Error(`'${target.node.path}' depends on '${this.node.path}' (${cycle.join(", ")}). Adding this dependency (${reason}) would create a cyclic reference.`);
        let dep = this._stackDependencies[names_1.Names.uniqueId(target)];
        dep || (dep = this._stackDependencies[names_1.Names.uniqueId(target)] = { stack: target, reasons: [] }), dep.reasons.push(reason), process.env.CDK_DEBUG_DEPS && console.error(`[CDK_DEBUG_DEPS] stack "${this.node.path}" depends on "${target.node.path}" because: ${reason}`);
      }
      _synthesizeTemplate(session, lookupRoleArn) {
        const builder = session.assembly, template = this._toCloudFormation(), outPath = path.join(builder.outdir, this.templateFile);
        if (this.maxResources > 0) {
          const resources = template.Resources || {}, numberOfResources = Object.keys(resources).length;
          if (numberOfResources > this.maxResources) {
            const counts = Object.entries(count(Object.values(resources).map((r) => `${r == null ? void 0 : r.Type}`))).map(([type, c]) => `${type} (${c})`).join(", ");
            throw new Error(`Number of resources in stack '${this.node.path}': ${numberOfResources} is greater than allowed maximum of ${this.maxResources}: ${counts}`);
          } else
            numberOfResources >= this.maxResources * 0.8 && annotations_1.Annotations.of(this).addInfo(`Number of resources: ${numberOfResources} is approaching allowed maximum of ${this.maxResources}`);
        }
        fs.writeFileSync(outPath, JSON.stringify(template, void 0, 1));
        for (const ctx of this._missingContext)
          lookupRoleArn != null ? builder.addMissing({ ...ctx, props: { ...ctx.props, lookupRoleArn } }) : builder.addMissing(ctx);
      }
      regionalFact(factName, defaultValue) {
        if (!token_1.Token.isUnresolved(this.region)) {
          const ret = region_info_1.Fact.find(this.region, factName) ?? defaultValue;
          if (ret === void 0)
            throw new Error(`region-info: don't know ${factName} for region ${this.region}. Use 'Fact.register' to provide this value.`);
          return ret;
        }
        const partitions = constructs_1.Node.of(this).tryGetContext(cxapi.TARGET_PARTITIONS);
        if (partitions !== void 0 && !Array.isArray(partitions))
          throw new Error(`Context value '${cxapi.TARGET_PARTITIONS}' should be a list of strings, got: ${JSON.stringify(cxapi.TARGET_PARTITIONS)}`);
        const lookupMap = partitions ? region_info_1.RegionInfo.limitedRegionMap(factName, partitions) : region_info_1.RegionInfo.regionMap(factName);
        return region_lookup_1.deployTimeLookup(this, factName, lookupMap, defaultValue);
      }
      exportValue(exportedValue, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ExportValueOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.exportValue), error;
        }
        if (options.name)
          return new cfn_output_1.CfnOutput(this, `Export${options.name}`, { value: exportedValue, exportName: options.name }), cfn_fn_1.Fn.importValue(options.name);
        const resolvable = token_1.Tokenization.reverse(exportedValue);
        if (!resolvable || !reference_1.Reference.isReference(resolvable))
          throw new Error("exportValue: either supply 'name' or make sure to export a resource attribute (like 'bucket.bucketName')");
        const exportable = refs_1.getExportable(this, resolvable), exportsScope = getCreateExportsScope(this), resolved = this.resolve(exportable), id = "Output" + JSON.stringify(resolved), exportName = generateExportName(exportsScope, id);
        if (token_1.Token.isUnresolved(exportName))
          throw new Error(`unresolved token in generated export name: ${JSON.stringify(this.resolve(exportName))}`);
        return exportsScope.node.tryFindChild(id) || new cfn_output_1.CfnOutput(exportsScope, id, { value: token_1.Token.asString(exportable), exportName }), cfn_fn_1.Fn.importValue(exportName);
      }
      allocateLogicalId(cfnElement) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnElement(cfnElement);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.allocateLogicalId), error;
        }
        const scopes = cfnElement.node.scopes, stackIndex = scopes.indexOf(cfnElement.stack), pathComponents = scopes.slice(stackIndex + 1).map((x) => x.node.id);
        return uniqueid_1.makeUniqueId(pathComponents);
      }
      _validateId(name) {
        if (name && !VALID_STACK_NAME_REGEX.test(name))
          throw new Error(`Stack name must match the regular expression: ${VALID_STACK_NAME_REGEX.toString()}, got '${name}'`);
      }
      _toCloudFormation() {
        let transform;
        this.templateOptions.transform && (annotations_1.Annotations.of(this).addWarning("This stack is using the deprecated `templateOptions.transform` property. Consider switching to `addTransform()`."), this.addTransform(this.templateOptions.transform)), this.templateOptions.transforms && (this.templateOptions.transforms.length === 1 ? transform = this.templateOptions.transforms[0] : transform = Array.from(new Set(this.templateOptions.transforms)));
        const template = { Description: this.templateOptions.description, Transform: transform, AWSTemplateFormatVersion: this.templateOptions.templateFormatVersion, Metadata: this.templateOptions.metadata }, fragments = cfnElements(this).map((e) => this.resolve(e._toCloudFormation()));
        for (const fragment of fragments)
          merge(template, fragment);
        const ret = this.resolve(template) || {};
        return this._logicalIds.assertAllRenamesApplied(), ret;
      }
      prepareCrossReference(_sourceStack, reference) {
        return reference;
      }
      parseEnvironment(env = {}) {
        const containingAssembly = stage_1.Stage.of(this), account = env.account ?? (containingAssembly == null ? void 0 : containingAssembly.account) ?? cfn_pseudo_1.Aws.ACCOUNT_ID, region = env.region ?? (containingAssembly == null ? void 0 : containingAssembly.region) ?? cfn_pseudo_1.Aws.REGION, envAccount = token_1.Token.isUnresolved(account) ? cxapi.UNKNOWN_ACCOUNT : account, envRegion = token_1.Token.isUnresolved(region) ? cxapi.UNKNOWN_REGION : region;
        return { account, region, environment: cxapi.EnvironmentUtils.format(envAccount, envRegion) };
      }
      get maxResources() {
        const contextLimit = this.node.tryGetContext(exports.STACK_RESOURCE_LIMIT_CONTEXT);
        return contextLimit !== void 0 ? parseInt(contextLimit, 10) : MAX_RESOURCES;
      }
      stackDependencyReasons(other) {
        if (this === other)
          return [];
        for (const dep of Object.values(this._stackDependencies)) {
          const ret = dep.stack.stackDependencyReasons(other);
          if (ret !== void 0)
            return [...dep.reasons, ...ret];
        }
      }
      generateStackName() {
        const assembly = stage_1.Stage.of(this);
        return `${assembly && assembly.stageName ? `${assembly.stageName}-` : ""}${this.generateStackId(assembly)}`;
      }
      generateStackArtifactId() {
        return this.generateStackId(this.node.root);
      }
      generateStackId(container) {
        const ids = rootPathTo(this, container).map((c) => constructs_1.Node.of(c).id);
        if (ids.length === 1 && !ids[0])
          throw new Error("unexpected: stack id must always be defined");
        return makeStackName(ids);
      }
      get bundlingRequired() {
        return (this.node.tryGetContext(cxapi.BUNDLING_STACKS) ?? ["**"]).some((pattern) => minimatch(this.node.path, pattern));
      }
    };
    exports.Stack = Stack2, _a = JSII_RTTI_SYMBOL_1, Stack2[_a] = { fqn: "aws-cdk-lib.Stack", version: "2.50.0" };
    function merge(template, fragment) {
      for (const section of Object.keys(fragment)) {
        const src = fragment[section], dest = template[section];
        dest ? template[section] = mergeSection(section, dest, src) : template[section] = src;
      }
    }
    function mergeSection(section, val1, val2) {
      switch (section) {
        case "Description":
          return `${val1}
${val2}`;
        case "AWSTemplateFormatVersion":
          if (val1 != null && val2 != null && val1 !== val2)
            throw new Error(`Conflicting CloudFormation template versions provided: '${val1}' and '${val2}`);
          return val1 ?? val2;
        case "Transform":
          return mergeSets(val1, val2);
        default:
          return mergeObjectsWithoutDuplicates(section, val1, val2);
      }
    }
    function mergeSets(val1, val2) {
      const array1 = val1 == null ? [] : Array.isArray(val1) ? val1 : [val1], array2 = val2 == null ? [] : Array.isArray(val2) ? val2 : [val2];
      for (const value of array2)
        array1.includes(value) || array1.push(value);
      return array1.length === 1 ? array1[0] : array1;
    }
    function mergeObjectsWithoutDuplicates(section, dest, src) {
      if (typeof dest != "object")
        throw new Error(`Expecting ${JSON.stringify(dest)} to be an object`);
      if (typeof src != "object")
        throw new Error(`Expecting ${JSON.stringify(src)} to be an object`);
      for (const id of Object.keys(src)) {
        if (id in dest)
          throw new Error(`section '${section}' already contains '${id}'`);
        dest[id] = src[id];
      }
      return dest;
    }
    function cfnElements(node, into = []) {
      cfn_element_1.CfnElement.isCfnElement(node) && into.push(node);
      for (const child of constructs_1.Node.of(node).children)
        Stack2.isStack(child) || cfnElements(child, into);
      return into;
    }
    function rootPathTo(construct, ancestor) {
      const scopes = constructs_1.Node.of(construct).scopes;
      for (let i = scopes.length - 2; i >= 0; i--)
        if (scopes[i] === ancestor)
          return scopes.slice(i + 1);
      return scopes;
    }
    exports.rootPathTo = rootPathTo;
    function makeStackName(components) {
      return components.length === 1 ? components[0] : unique_resource_name_1.makeUniqueResourceName(components, { maxLength: 128 });
    }
    function getCreateExportsScope(stack) {
      const exportsName = "Exports";
      let stackExports = stack.node.tryFindChild(exportsName);
      return stackExports === void 0 && (stackExports = new constructs_1.Construct(stack, exportsName)), stackExports;
    }
    function generateExportName(stackExports, id) {
      const stackRelativeExports = feature_flags_1.FeatureFlags.of(stackExports).isEnabled(cxapi.STACK_RELATIVE_EXPORTS_CONTEXT), stack = Stack2.of(stackExports), components = [...stackExports.node.scopes.slice(stackRelativeExports ? stack.node.scopes.length : 2).map((c) => c.node.id), id], prefix = stack.stackName ? stack.stackName + ":" : "", localPart = uniqueid_1.makeUniqueId(components), maxLength = 255;
      return prefix + localPart.slice(Math.max(0, localPart.length - maxLength + prefix.length));
    }
    function count(xs) {
      const ret = {};
      for (const x of xs)
        x in ret ? ret[x] += 1 : ret[x] = 1;
      return ret;
    }
    var cfn_output_1 = require_cfn_output();
    var deps_1 = require_deps();
    var fs_1 = require_fs2();
    var names_1 = require_names();
    var reference_1 = require_reference();
    var stack_synthesizers_1 = require_stack_synthesizers();
    var stage_1 = require_stage();
    var tag_manager_1 = require_tag_manager();
    var token_1 = require_token();
    var refs_1 = require_refs();
    var region_info_1 = require_region_info2();
    var region_lookup_1 = require_region_lookup();
    var unique_resource_name_1 = require_unique_resource_name();
  }
});

// node_modules/aws-cdk-lib/core/lib/private/cfn-reference.js
var require_cfn_reference = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/private/cfn-reference.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CfnReference = exports.ReferenceRendering = void 0;
    var reference_1 = require_reference();
    var CFN_REFERENCE_SYMBOL = Symbol.for("@aws-cdk/core.CfnReference");
    var ReferenceRendering;
    (function(ReferenceRendering2) {
      ReferenceRendering2[ReferenceRendering2.FN_SUB = 0] = "FN_SUB", ReferenceRendering2[ReferenceRendering2.GET_ATT_STRING = 1] = "GET_ATT_STRING";
    })(ReferenceRendering = exports.ReferenceRendering || (exports.ReferenceRendering = {}));
    var CfnReference = class extends reference_1.Reference {
      constructor(value, displayName, target) {
        super(value, target, displayName), this.target = target, this.replacementTokens = /* @__PURE__ */ new Map(), this.targetStack = stack_1.Stack.of(target), Object.defineProperty(this, CFN_REFERENCE_SYMBOL, { value: true });
      }
      static isCfnReference(x) {
        return CFN_REFERENCE_SYMBOL in x;
      }
      static for(target, attribute, refRender) {
        return CfnReference.singletonReference(target, attribute, refRender, () => {
          const cfnIntrinsic = refRender === ReferenceRendering.FN_SUB ? "${" + target.logicalId + (attribute === "Ref" ? "" : `.${attribute}`) + "}" : attribute === "Ref" ? { Ref: target.logicalId } : { "Fn::GetAtt": refRender === ReferenceRendering.GET_ATT_STRING ? `${target.logicalId}.${attribute}` : [target.logicalId, attribute] };
          return new CfnReference(cfnIntrinsic, attribute, target);
        });
      }
      static forPseudo(pseudoName, scope) {
        return CfnReference.singletonReference(scope, `Pseudo:${pseudoName}`, void 0, () => {
          const cfnIntrinsic = { Ref: pseudoName };
          return new CfnReference(cfnIntrinsic, pseudoName, scope);
        });
      }
      static singletonReference(target, attribKey, refRender, fresh) {
        let attribs = CfnReference.referenceTable.get(target);
        attribs || (attribs = /* @__PURE__ */ new Map(), CfnReference.referenceTable.set(target, attribs));
        let cacheKey = attribKey;
        switch (refRender) {
          case ReferenceRendering.FN_SUB:
            cacheKey += "Fn::Sub";
            break;
          case ReferenceRendering.GET_ATT_STRING:
            cacheKey += "Fn::GetAtt::String";
            break;
        }
        let ref = attribs.get(cacheKey);
        return ref || (ref = fresh(), attribs.set(cacheKey, ref)), ref;
      }
      resolve(context) {
        const consumingStack = stack_1.Stack.of(context.scope), token = this.replacementTokens.get(consumingStack);
        return token ? token.resolve(context) : super.resolve(context);
      }
      hasValueForStack(stack) {
        return stack === this.targetStack ? true : this.replacementTokens.has(stack);
      }
      assignValueForStack(stack, value) {
        if (stack === this.targetStack)
          throw new Error("cannot assign a value for the same stack");
        if (this.hasValueForStack(stack))
          throw new Error("Cannot assign a reference value twice to the same stack. Use hasValueForStack to check first");
        this.replacementTokens.set(stack, value);
      }
      toString() {
        return token_1.Token.asString(this, { displayHint: `${this.target.node.id}.${this.displayName}` });
      }
    };
    exports.CfnReference = CfnReference, CfnReference.referenceTable = /* @__PURE__ */ new Map();
    var stack_1 = require_stack();
    var token_1 = require_token();
  }
});

// node_modules/aws-cdk-lib/core/lib/cfn-element.js
var require_cfn_element = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cfn-element.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CfnRefElement = exports.CfnElement = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxschema = require_cloud_assembly_schema2();
    var cxapi = require_cx_api();
    var constructs_1 = require_lib4();
    var debug_1 = require_debug2();
    var lazy_1 = require_lazy();
    var CFN_ELEMENT_SYMBOL = Symbol.for("@aws-cdk/core.CfnElement");
    var CfnElement = class extends constructs_1.Construct {
      constructor(scope, id) {
        super(scope, id), Object.defineProperty(this, CFN_ELEMENT_SYMBOL, { value: true }), this.stack = stack_1.Stack.of(this), this.logicalId = lazy_1.Lazy.uncachedString({ produce: () => this.synthesizeLogicalId() }, { displayHint: `${notTooLong(constructs_1.Node.of(this).path)}.LogicalID` }), this.node.tryGetContext(cxapi.DISABLE_LOGICAL_ID_METADATA) || constructs_1.Node.of(this).addMetadata(cxschema.ArtifactMetadataEntryType.LOGICAL_ID, this.logicalId, { stackTrace: debug_1.debugModeEnabled(), traceFromFunction: this.constructor });
      }
      static isCfnElement(x) {
        return CFN_ELEMENT_SYMBOL in x;
      }
      overrideLogicalId(newLogicalId) {
        if (this._logicalIdLocked)
          throw new Error(`The logicalId for resource at path ${constructs_1.Node.of(this).path} has been locked and cannot be overridden
Make sure you are calling "overrideLogicalId" before Stack.exportValue`);
        this._logicalIdOverride = newLogicalId;
      }
      _lockLogicalId() {
        this._logicalIdLocked = true;
      }
      get creationStack() {
        const trace = constructs_1.Node.of(this).metadata.find((md) => md.type === cxschema.ArtifactMetadataEntryType.LOGICAL_ID).trace;
        if (!trace)
          return [];
        return filterStackTrace(trace);
        function filterStackTrace(stack) {
          const result = Array.of(...stack);
          for (; result.length > 0 && shouldFilter(result[result.length - 1]); )
            result.pop();
          return result.length === 0 ? stack : result;
        }
        function shouldFilter(str) {
          return str.match(/[^(]+\(internal\/.*/) !== null;
        }
      }
      synthesizeLogicalId() {
        return this._logicalIdOverride ? this._logicalIdOverride : this.stack.getLogicalId(this);
      }
    };
    exports.CfnElement = CfnElement, _a = JSII_RTTI_SYMBOL_1, CfnElement[_a] = { fqn: "aws-cdk-lib.CfnElement", version: "2.50.0" };
    var CfnRefElement = class extends CfnElement {
      get ref() {
        return token_1.Token.asString(cfn_reference_1.CfnReference.for(this, "Ref"));
      }
    };
    exports.CfnRefElement = CfnRefElement, _b = JSII_RTTI_SYMBOL_1, CfnRefElement[_b] = { fqn: "aws-cdk-lib.CfnRefElement", version: "2.50.0" };
    function notTooLong(x) {
      return x.length < 100 ? x : x.slice(0, 47) + "..." + x.slice(-47);
    }
    var cfn_reference_1 = require_cfn_reference();
    var stack_1 = require_stack();
    var token_1 = require_token();
  }
});

// node_modules/aws-cdk-lib/core/lib/cfn-resource-policy.js
var require_cfn_resource_policy = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cfn-resource-policy.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CfnDeletionPolicy = void 0;
    var CfnDeletionPolicy;
    (function(CfnDeletionPolicy2) {
      CfnDeletionPolicy2.DELETE = "Delete", CfnDeletionPolicy2.RETAIN = "Retain", CfnDeletionPolicy2.SNAPSHOT = "Snapshot";
    })(CfnDeletionPolicy = exports.CfnDeletionPolicy || (exports.CfnDeletionPolicy = {}));
  }
});

// node_modules/aws-cdk-lib/core/lib/cfn-resource.js
var require_cfn_resource = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cfn-resource.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.TagType = exports.CfnResource = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cxapi = require_cx_api();
    var annotations_1 = require_annotations();
    var cfn_element_1 = require_cfn_element();
    var cfn_resource_policy_1 = require_cfn_resource_policy();
    var constructs_1 = require_lib4();
    var deps_1 = require_deps();
    var cfn_reference_1 = require_cfn_reference();
    var cloudformation_lang_1 = require_cloudformation_lang();
    var removal_policy_1 = require_removal_policy();
    var tag_manager_1 = require_tag_manager();
    var token_1 = require_token();
    var util_1 = require_util();
    var feature_flags_1 = require_feature_flags();
    var CfnResource = class extends cfn_element_1.CfnRefElement {
      constructor(scope, id, props) {
        super(scope, id), this.cfnOptions = {}, this.rawOverrides = {}, this.dependsOn = /* @__PURE__ */ new Set();
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnResourceProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnResource), error;
        }
        if (!props.type)
          throw new Error("The `type` property is required");
        this.cfnResourceType = props.type, this._cfnProperties = props.properties || {}, constructs_1.Node.of(this).tryGetContext(cxapi.PATH_METADATA_ENABLE_CONTEXT) && this.addMetadata(cxapi.PATH_METADATA_KEY, constructs_1.Node.of(this).path);
      }
      static isCfnResource(construct) {
        return construct.cfnResourceType !== void 0;
      }
      applyRemovalPolicy(policy, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_RemovalPolicy(policy), jsiiDeprecationWarnings.aws_cdk_lib_RemovalPolicyOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.applyRemovalPolicy), error;
        }
        policy = policy || options.default || removal_policy_1.RemovalPolicy.RETAIN;
        let deletionPolicy;
        switch (policy) {
          case removal_policy_1.RemovalPolicy.DESTROY:
            deletionPolicy = cfn_resource_policy_1.CfnDeletionPolicy.DELETE;
            break;
          case removal_policy_1.RemovalPolicy.RETAIN:
            deletionPolicy = cfn_resource_policy_1.CfnDeletionPolicy.RETAIN;
            break;
          case removal_policy_1.RemovalPolicy.SNAPSHOT:
            if (!["AWS::EC2::Volume", "AWS::ElastiCache::CacheCluster", "AWS::ElastiCache::ReplicationGroup", "AWS::Neptune::DBCluster", "AWS::RDS::DBCluster", "AWS::RDS::DBInstance", "AWS::Redshift::Cluster"].includes(this.cfnResourceType)) {
              if (feature_flags_1.FeatureFlags.of(this).isEnabled(cxapi.VALIDATE_SNAPSHOT_REMOVAL_POLICY))
                throw new Error(`${this.cfnResourceType} does not support snapshot removal policy`);
              annotations_1.Annotations.of(this).addWarning(`${this.cfnResourceType} does not support snapshot removal policy. This policy will be ignored.`);
            }
            deletionPolicy = cfn_resource_policy_1.CfnDeletionPolicy.SNAPSHOT;
            break;
          default:
            throw new Error(`Invalid removal policy: ${policy}`);
        }
        this.cfnOptions.deletionPolicy = deletionPolicy, options.applyToUpdateReplacePolicy !== false && (this.cfnOptions.updateReplacePolicy = deletionPolicy);
      }
      getAtt(attributeName) {
        return cfn_reference_1.CfnReference.for(this, attributeName);
      }
      addOverride(path, value) {
        const parts = splitOnPeriods(path);
        let curr = this.rawOverrides;
        for (; parts.length > 1; ) {
          const key = parts.shift();
          curr[key] != null && typeof curr[key] == "object" && !Array.isArray(curr[key]) || (curr[key] = {}), curr = curr[key];
        }
        const lastKey = parts.shift();
        curr[lastKey] = value;
      }
      addDeletionOverride(path) {
        this.addOverride(path, void 0);
      }
      addPropertyOverride(propertyPath, value) {
        this.addOverride(`Properties.${propertyPath}`, value);
      }
      addPropertyDeletionOverride(propertyPath) {
        this.addPropertyOverride(propertyPath, void 0);
      }
      addDependsOn(target) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnResource(target);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.addDependsOn), error;
        }
        !target.shouldSynthesize() || deps_1.addDependency(this, target, `"${constructs_1.Node.of(this).path}" depends on "${constructs_1.Node.of(target).path}"`);
      }
      addMetadata(key, value) {
        this.cfnOptions.metadata || (this.cfnOptions.metadata = {}), this.cfnOptions.metadata[key] = value;
      }
      getMetadata(key) {
        var _a2;
        return (_a2 = this.cfnOptions.metadata) == null ? void 0 : _a2[key];
      }
      toString() {
        return `${super.toString()} [${this.cfnResourceType}]`;
      }
      _addResourceDependency(target) {
        this.dependsOn.add(target);
      }
      _toCloudFormation() {
        if (!this.shouldSynthesize())
          return {};
        try {
          return { Resources: { [this.logicalId]: new util_1.PostResolveToken({ Type: this.cfnResourceType, Properties: util_1.ignoreEmpty(this.cfnProperties), DependsOn: util_1.ignoreEmpty(renderDependsOn(this.dependsOn)), CreationPolicy: util_1.capitalizePropertyNames(this, renderCreationPolicy(this.cfnOptions.creationPolicy)), UpdatePolicy: util_1.capitalizePropertyNames(this, this.cfnOptions.updatePolicy), UpdateReplacePolicy: util_1.capitalizePropertyNames(this, this.cfnOptions.updateReplacePolicy), DeletionPolicy: util_1.capitalizePropertyNames(this, this.cfnOptions.deletionPolicy), Version: this.cfnOptions.version, Description: this.cfnOptions.description, Metadata: util_1.ignoreEmpty(this.cfnOptions.metadata), Condition: this.cfnOptions.condition && this.cfnOptions.condition.logicalId }, (resourceDef) => {
            const renderedProps = this.renderProperties(resourceDef.Properties || {});
            if (renderedProps) {
              const hasDefined = Object.values(renderedProps).find((v) => v !== void 0);
              resourceDef.Properties = hasDefined !== void 0 ? renderedProps : void 0;
            }
            const resolvedRawOverrides = token_1.Tokenization.resolve(this.rawOverrides, { scope: this, resolver: cloudformation_lang_1.CLOUDFORMATION_TOKEN_RESOLVER, removeEmpty: false });
            return deepMerge(resourceDef, resolvedRawOverrides);
          }) } };
        } catch (e) {
          e.message = `While synthesizing ${this.node.path}: ${e.message}`;
          const trace = this.creationStack;
          if (trace) {
            const creationStack = ["--- resource created at ---", ...trace].join(`
  at `), problemTrace = e.stack.slice(e.stack.indexOf(e.message) + e.message.length);
            e.stack = `${e.message}
  ${creationStack}
  --- problem discovered at ---${problemTrace}`;
          }
          throw e;
        }
        function renderDependsOn(dependsOn) {
          return Array.from(dependsOn).sort((x, y) => x.node.path.localeCompare(y.node.path)).map((r) => r.logicalId);
        }
        function renderCreationPolicy(policy) {
          if (!policy)
            return;
          const result = { ...policy };
          return policy.resourceSignal && policy.resourceSignal.timeout && (result.resourceSignal = policy.resourceSignal), result;
        }
      }
      get cfnProperties() {
        const props = this._cfnProperties || {};
        if (tag_manager_1.TagManager.isTaggable(this)) {
          const tagsProp = {};
          return tagsProp[this.tags.tagPropertyName] = this.tags.renderTags(), deepMerge(props, tagsProp);
        }
        return props;
      }
      renderProperties(props) {
        return props;
      }
      get updatedProperites() {
        try {
          jsiiDeprecationWarnings.print("aws-cdk-lib.CfnResource#updatedProperites", `use \`updatedProperties\`

Return properties modified after initiation

Resources that expose mutable properties should override this function to
collect and return the properties object for this resource.`);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, jsiiDeprecationWarnings.getPropertyDescriptor(this, "updatedProperites").get), error;
        }
        return this.updatedProperties;
      }
      get updatedProperties() {
        return this._cfnProperties;
      }
      validateProperties(_properties) {
      }
      shouldSynthesize() {
        return true;
      }
    };
    exports.CfnResource = CfnResource, _a = JSII_RTTI_SYMBOL_1, CfnResource[_a] = { fqn: "aws-cdk-lib.CfnResource", version: "2.50.0" };
    var TagType;
    (function(TagType2) {
      TagType2.STANDARD = "StandardTag", TagType2.AUTOSCALING_GROUP = "AutoScalingGroupTag", TagType2.MAP = "StringToStringMap", TagType2.KEY_VALUE = "KeyValue", TagType2.NOT_TAGGABLE = "NotTaggable";
    })(TagType = exports.TagType || (exports.TagType = {}));
    var MERGE_EXCLUDE_KEYS = ["Ref", "Fn::Base64", "Fn::Cidr", "Fn::FindInMap", "Fn::GetAtt", "Fn::GetAZs", "Fn::ImportValue", "Fn::Join", "Fn::Select", "Fn::Split", "Fn::Sub", "Fn::Transform", "Fn::And", "Fn::Equals", "Fn::If", "Fn::Not", "Fn::Or"];
    function deepMerge(target, ...sources) {
      for (const source of sources) {
        if (typeof source != "object" || typeof target != "object")
          throw new Error(`Invalid usage. Both source (${JSON.stringify(source)}) and target (${JSON.stringify(target)}) must be objects`);
        for (const key of Object.keys(source)) {
          const value = source[key];
          if (typeof value == "object" && value != null && !Array.isArray(value)) {
            typeof target[key] != "object" ? target[key] = {} : Object.keys(target[key]).length === 1 && MERGE_EXCLUDE_KEYS.includes(Object.keys(target[key])[0]) && (target[key] = {}), Object.keys(value).length === 1 && MERGE_EXCLUDE_KEYS.includes(Object.keys(value)[0]) && (target[key] = {}), deepMerge(target[key], value);
            const output = target[key];
            typeof output == "object" && Object.keys(output).length === 0 && delete target[key];
          } else
            value === void 0 ? delete target[key] : target[key] = value;
        }
      }
      return target;
    }
    function splitOnPeriods(x) {
      const ret = [""];
      for (let i = 0; i < x.length; i++)
        x[i] === "\\" && i + 1 < x.length ? (ret[0] += x[i + 1], i++) : x[i] === "." ? ret.unshift("") : ret[0] += x[i];
      return ret.reverse(), ret;
    }
  }
});

// node_modules/aws-cdk-lib/core/lib/tag-manager.js
var require_tag_manager = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/tag-manager.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.TagManager = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_resource_1 = require_cfn_resource();
    var lazy_1 = require_lazy();
    var StandardFormatter = class {
      parseTags(cfnPropertyTags, priority) {
        if (!Array.isArray(cfnPropertyTags))
          throw new Error(`Invalid tag input expected array of {key, value} have ${JSON.stringify(cfnPropertyTags)}`);
        const tags = [], dynamicTags = [];
        for (const tag of cfnPropertyTags)
          tag.key === void 0 || tag.value === void 0 ? dynamicTags.push(tag) : tags.push({ key: `${tag.key}`, value: `${tag.value}`, priority });
        return { tags, dynamicTags };
      }
      formatTags(tags) {
        const cfnTags = [];
        for (const tag of tags)
          cfnTags.push({ key: tag.key, value: tag.value });
        return cfnTags;
      }
    };
    var AsgFormatter = class {
      parseTags(cfnPropertyTags, priority) {
        if (!Array.isArray(cfnPropertyTags))
          throw new Error(`Invalid tag input expected array of {key, value, propagateAtLaunch} have ${JSON.stringify(cfnPropertyTags)}`);
        const tags = [], dynamicTags = [];
        for (const tag of cfnPropertyTags)
          tag.key === void 0 || tag.value === void 0 || tag.propagateAtLaunch === void 0 ? dynamicTags.push(tag) : tags.push({ key: `${tag.key}`, value: `${tag.value}`, priority, applyToLaunchedInstances: !!tag.propagateAtLaunch });
        return { tags, dynamicTags };
      }
      formatTags(tags) {
        const cfnTags = [];
        for (const tag of tags)
          cfnTags.push({ key: tag.key, value: tag.value, propagateAtLaunch: tag.applyToLaunchedInstances !== false });
        return cfnTags;
      }
    };
    var MapFormatter = class {
      parseTags(cfnPropertyTags, priority) {
        if (Array.isArray(cfnPropertyTags) || typeof cfnPropertyTags != "object")
          throw new Error(`Invalid tag input expected map of {key: value} have ${JSON.stringify(cfnPropertyTags)}`);
        const tags = [];
        for (const [key, value] of Object.entries(cfnPropertyTags))
          tags.push({ key, value: `${value}`, priority });
        return { tags, dynamicTags: void 0 };
      }
      formatTags(tags) {
        const cfnTags = {};
        for (const tag of tags)
          cfnTags[`${tag.key}`] = `${tag.value}`;
        return cfnTags;
      }
    };
    var KeyValueFormatter = class {
      parseTags(keyValueTags, priority) {
        const tags = [];
        for (const key in keyValueTags)
          if (keyValueTags.hasOwnProperty(key)) {
            const value = keyValueTags[key];
            tags.push({ key, value, priority });
          }
        return { tags, dynamicTags: void 0 };
      }
      formatTags(unformattedTags) {
        const tags = [];
        return unformattedTags.forEach((tag) => {
          tags.push({ Key: tag.key, Value: tag.value });
        }), tags;
      }
    };
    var NoFormat = class {
      parseTags(_cfnPropertyTags) {
        return { tags: [], dynamicTags: void 0 };
      }
      formatTags(_tags) {
      }
    };
    var _tagFormattersCache;
    function TAG_FORMATTERS() {
      return _tagFormattersCache ?? (_tagFormattersCache = { [cfn_resource_1.TagType.AUTOSCALING_GROUP]: new AsgFormatter(), [cfn_resource_1.TagType.STANDARD]: new StandardFormatter(), [cfn_resource_1.TagType.MAP]: new MapFormatter(), [cfn_resource_1.TagType.KEY_VALUE]: new KeyValueFormatter(), [cfn_resource_1.TagType.NOT_TAGGABLE]: new NoFormat() });
    }
    var TagManager = class {
      constructor(tagType, resourceTypeName, tagStructure, options = {}) {
        this.tags = /* @__PURE__ */ new Map(), this.priorities = /* @__PURE__ */ new Map(), this.initialTagPriority = 50;
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TagType(tagType), jsiiDeprecationWarnings.aws_cdk_lib_TagManagerOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, TagManager), error;
        }
        if (this.resourceTypeName = resourceTypeName, this.tagFormatter = TAG_FORMATTERS()[tagType], tagStructure !== void 0) {
          const parseTagsResult = this.tagFormatter.parseTags(tagStructure, this.initialTagPriority);
          this.dynamicTags = parseTagsResult.dynamicTags, this._setTag(...parseTagsResult.tags);
        }
        this.tagPropertyName = options.tagPropertyName || "tags", this.renderedTags = lazy_1.Lazy.any({ produce: () => this.renderTags() });
      }
      static isTaggable(construct) {
        return construct.tags !== void 0;
      }
      setTag(key, value, priority = 0, applyToLaunchedInstances = true) {
        this._setTag({ key, value, priority, applyToLaunchedInstances });
      }
      removeTag(key, priority) {
        priority >= (this.priorities.get(key) || 0) && (this.tags.delete(key), this.priorities.set(key, priority));
      }
      renderTags() {
        const formattedTags = this.tagFormatter.formatTags(this.sortedTags);
        if (Array.isArray(formattedTags) || Array.isArray(this.dynamicTags)) {
          const ret = [...formattedTags ?? [], ...this.dynamicTags ?? []];
          return ret.length > 0 ? ret : void 0;
        } else {
          const ret = { ...formattedTags ?? {}, ...this.dynamicTags ?? {} };
          return Object.keys(ret).length > 0 ? ret : void 0;
        }
      }
      tagValues() {
        const ret = {};
        for (const tag of this.sortedTags)
          ret[tag.key] = tag.value;
        return ret;
      }
      applyTagAspectHere(include, exclude) {
        return !(exclude && exclude.length > 0 && exclude.indexOf(this.resourceTypeName) !== -1 || include && include.length > 0 && include.indexOf(this.resourceTypeName) === -1);
      }
      hasTags() {
        return this.tags.size > 0;
      }
      _setTag(...tags) {
        for (const tag of tags)
          tag.priority >= (this.priorities.get(tag.key) || 0) && (this.tags.set(tag.key, tag), this.priorities.set(tag.key, tag.priority));
      }
      get sortedTags() {
        return Array.from(this.tags.values()).sort((a, b) => a.key.localeCompare(b.key));
      }
    };
    exports.TagManager = TagManager, _a = JSII_RTTI_SYMBOL_1, TagManager[_a] = { fqn: "aws-cdk-lib.TagManager", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/tag-aspect.js
var require_tag_aspect = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/tag-aspect.js"(exports) {
    "use strict";
    var _a;
    var _b;
    var _c;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.RemoveTag = exports.Tags = exports.Tag = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var annotations_1 = require_annotations();
    var aspect_1 = require_aspect();
    var tag_manager_1 = require_tag_manager();
    var TagBase = class {
      constructor(key, props = {}) {
        this.key = key, this.props = props;
      }
      visit(construct) {
        tag_manager_1.TagManager.isTaggable(construct) && this.applyTag(construct);
      }
    };
    var Tag = class extends TagBase {
      constructor(key, value, props = {}) {
        super(key, props), this.defaultPriority = 100;
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TagProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, Tag), error;
        }
        if (value === void 0)
          throw new Error("Tag must have a value");
        this.value = value;
      }
      static add(scope, key, value, props = {}) {
        annotations_1.Annotations.of(scope).addDeprecation("@aws-cdk/core.Tag.add(scope,k,v)", 'Use "Tags.of(scope).add(k,v)" instead'), Tags.of(scope).add(key, value, props);
      }
      static remove(scope, key, props = {}) {
        annotations_1.Annotations.of(scope).addDeprecation("@aws-cdk/core.Tag.remove(scope,k,v)", 'Use "Tags.of(scope).remove(k,v)" instead'), Tags.of(scope).remove(key, props);
      }
      applyTag(resource) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ITaggable(resource);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.applyTag), error;
        }
        resource.tags.applyTagAspectHere(this.props.includeResourceTypes, this.props.excludeResourceTypes) && resource.tags.setTag(this.key, this.value, this.props.priority ?? this.defaultPriority, this.props.applyToLaunchedInstances !== false);
      }
    };
    exports.Tag = Tag, _a = JSII_RTTI_SYMBOL_1, Tag[_a] = { fqn: "aws-cdk-lib.Tag", version: "2.50.0" };
    var Tags = class {
      constructor(scope) {
        this.scope = scope;
      }
      static of(scope) {
        return new Tags(scope);
      }
      add(key, value, props = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TagProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.add), error;
        }
        aspect_1.Aspects.of(this.scope).add(new Tag(key, value, props));
      }
      remove(key, props = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TagProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.remove), error;
        }
        aspect_1.Aspects.of(this.scope).add(new RemoveTag(key, props));
      }
    };
    exports.Tags = Tags, _b = JSII_RTTI_SYMBOL_1, Tags[_b] = { fqn: "aws-cdk-lib.Tags", version: "2.50.0" };
    var RemoveTag = class extends TagBase {
      constructor(key, props = {}) {
        super(key, props), this.defaultPriority = 200;
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TagProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, RemoveTag), error;
        }
      }
      applyTag(resource) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ITaggable(resource);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.applyTag), error;
        }
        resource.tags.applyTagAspectHere(this.props.includeResourceTypes, this.props.excludeResourceTypes) && resource.tags.removeTag(this.key, this.props.priority ?? this.defaultPriority);
      }
    };
    exports.RemoveTag = RemoveTag, _c = JSII_RTTI_SYMBOL_1, RemoveTag[_c] = { fqn: "aws-cdk-lib.RemoveTag", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/cfn-hook.js
var require_cfn_hook = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cfn-hook.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CfnHook = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_element_1 = require_cfn_element();
    var util_1 = require_util();
    var CfnHook = class extends cfn_element_1.CfnElement {
      constructor(scope, id, props) {
        super(scope, id);
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnHookProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnHook), error;
        }
        this.type = props.type, this._cfnHookProperties = props.properties;
      }
      _toCloudFormation() {
        return { Hooks: { [this.logicalId]: { Type: this.type, Properties: util_1.ignoreEmpty(this.renderProperties(this._cfnHookProperties)) } } };
      }
      renderProperties(props) {
        return props;
      }
    };
    exports.CfnHook = CfnHook, _a = JSII_RTTI_SYMBOL_1, CfnHook[_a] = { fqn: "aws-cdk-lib.CfnHook", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/cfn-codedeploy-blue-green-hook.js
var require_cfn_codedeploy_blue_green_hook = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cfn-codedeploy-blue-green-hook.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CfnCodeDeployBlueGreenHook = exports.CfnTrafficRoutingType = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_hook_1 = require_cfn_hook();
    var util_1 = require_util();
    var CfnTrafficRoutingType;
    (function(CfnTrafficRoutingType2) {
      CfnTrafficRoutingType2.ALL_AT_ONCE = "AllAtOnce", CfnTrafficRoutingType2.TIME_BASED_CANARY = "TimeBasedCanary", CfnTrafficRoutingType2.TIME_BASED_LINEAR = "TimeBasedLinear";
    })(CfnTrafficRoutingType = exports.CfnTrafficRoutingType || (exports.CfnTrafficRoutingType = {}));
    var CfnCodeDeployBlueGreenHook = class extends cfn_hook_1.CfnHook {
      constructor(scope, id, props) {
        super(scope, id, { type: "AWS::CodeDeploy::BlueGreen" });
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnCodeDeployBlueGreenHookProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnCodeDeployBlueGreenHook), error;
        }
        this._serviceRole = props.serviceRole, this._applications = props.applications, this._trafficRoutingConfig = props.trafficRoutingConfig, this._additionalOptions = props.additionalOptions, this._lifecycleEventHooks = props.lifecycleEventHooks;
      }
      static _fromCloudFormation(scope, id, hookAttributes, options) {
        var _a2, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o, _p;
        hookAttributes = hookAttributes || {};
        const hookProperties = options.parser.parseValue(hookAttributes.Properties);
        return new CfnCodeDeployBlueGreenHook(scope, id, { serviceRole: hookProperties == null ? void 0 : hookProperties.ServiceRole, applications: (_a2 = hookProperties == null ? void 0 : hookProperties.Applications) == null ? void 0 : _a2.map(applicationFromCloudFormation), trafficRoutingConfig: { type: (_b = hookProperties == null ? void 0 : hookProperties.TrafficRoutingConfig) == null ? void 0 : _b.Type, timeBasedCanary: { stepPercentage: (_d = (_c = hookProperties == null ? void 0 : hookProperties.TrafficRoutingConfig) == null ? void 0 : _c.TimeBasedCanary) == null ? void 0 : _d.StepPercentage, bakeTimeMins: (_f = (_e = hookProperties == null ? void 0 : hookProperties.TrafficRoutingConfig) == null ? void 0 : _e.TimeBasedCanary) == null ? void 0 : _f.BakeTimeMins }, timeBasedLinear: { stepPercentage: (_h = (_g = hookProperties == null ? void 0 : hookProperties.TrafficRoutingConfig) == null ? void 0 : _g.TimeBasedLinear) == null ? void 0 : _h.StepPercentage, bakeTimeMins: (_j = (_i = hookProperties == null ? void 0 : hookProperties.TrafficRoutingConfig) == null ? void 0 : _i.TimeBasedLinear) == null ? void 0 : _j.BakeTimeMins } }, additionalOptions: { terminationWaitTimeInMinutes: (_k = hookProperties == null ? void 0 : hookProperties.AdditionalOptions) == null ? void 0 : _k.TerminationWaitTimeInMinutes }, lifecycleEventHooks: { beforeInstall: (_l = hookProperties == null ? void 0 : hookProperties.LifecycleEventHooks) == null ? void 0 : _l.BeforeInstall, afterInstall: (_m = hookProperties == null ? void 0 : hookProperties.LifecycleEventHooks) == null ? void 0 : _m.AfterInstall, afterAllowTestTraffic: (_n = hookProperties == null ? void 0 : hookProperties.LifecycleEventHooks) == null ? void 0 : _n.AfterAllowTestTraffic, beforeAllowTraffic: (_o = hookProperties == null ? void 0 : hookProperties.LifecycleEventHooks) == null ? void 0 : _o.BeforeAllowTraffic, afterAllowTraffic: (_p = hookProperties == null ? void 0 : hookProperties.LifecycleEventHooks) == null ? void 0 : _p.AfterAllowTraffic } });
        function applicationFromCloudFormation(app) {
          var _a3, _b2, _c2, _d2, _e2, _f2, _g2, _h2, _i2, _j2, _k2, _l2, _m2, _n2, _o2, _p2, _q, _r, _s, _t, _u;
          const target = findResource((_a3 = app == null ? void 0 : app.Target) == null ? void 0 : _a3.LogicalID), taskDefinitions = (_c2 = (_b2 = app == null ? void 0 : app.ECSAttributes) == null ? void 0 : _b2.TaskDefinitions) == null ? void 0 : _c2.map((td) => findResource(td)), taskSets = (_e2 = (_d2 = app == null ? void 0 : app.ECSAttributes) == null ? void 0 : _d2.TaskSets) == null ? void 0 : _e2.map((ts) => findResource(ts)), prodTrafficRoute = findResource((_h2 = (_g2 = (_f2 = app == null ? void 0 : app.ECSAttributes) == null ? void 0 : _f2.TrafficRouting) == null ? void 0 : _g2.ProdTrafficRoute) == null ? void 0 : _h2.LogicalID), testTrafficRoute = findResource((_k2 = (_j2 = (_i2 = app == null ? void 0 : app.ECSAttributes) == null ? void 0 : _i2.TrafficRouting) == null ? void 0 : _j2.TestTrafficRoute) == null ? void 0 : _k2.LogicalID), targetGroups = (_n2 = (_m2 = (_l2 = app == null ? void 0 : app.ECSAttributes) == null ? void 0 : _l2.TrafficRouting) == null ? void 0 : _m2.TargetGroups) == null ? void 0 : _n2.map((tg) => findResource(tg));
          return { target: { type: (_o2 = app == null ? void 0 : app.Target) == null ? void 0 : _o2.Type, logicalId: target == null ? void 0 : target.logicalId }, ecsAttributes: { taskDefinitions: taskDefinitions == null ? void 0 : taskDefinitions.map((td) => td == null ? void 0 : td.logicalId), taskSets: taskSets == null ? void 0 : taskSets.map((ts) => ts == null ? void 0 : ts.logicalId), trafficRouting: { prodTrafficRoute: { type: (_r = (_q = (_p2 = app == null ? void 0 : app.ECSAttributes) == null ? void 0 : _p2.TrafficRouting) == null ? void 0 : _q.ProdTrafficRoute) == null ? void 0 : _r.Type, logicalId: prodTrafficRoute == null ? void 0 : prodTrafficRoute.logicalId }, testTrafficRoute: { type: (_u = (_t = (_s = app == null ? void 0 : app.ECSAttributes) == null ? void 0 : _s.TrafficRouting) == null ? void 0 : _t.TestTrafficRoute) == null ? void 0 : _u.Type, logicalId: testTrafficRoute == null ? void 0 : testTrafficRoute.logicalId }, targetGroups: targetGroups == null ? void 0 : targetGroups.map((tg) => tg == null ? void 0 : tg.logicalId) } } };
        }
        function findResource(logicalId) {
          if (logicalId == null)
            return;
          const ret = options.parser.finder.findResource(logicalId);
          if (!ret)
            throw new Error(`Hook '${id}' references resource '${logicalId}' that was not found in the template`);
          return ret;
        }
      }
      get serviceRole() {
        return this._serviceRole;
      }
      set serviceRole(serviceRole) {
        this._serviceRole = serviceRole;
      }
      get applications() {
        return this._applications;
      }
      set applications(value) {
        this._applications = value;
      }
      get trafficRoutingConfig() {
        return this._trafficRoutingConfig;
      }
      set trafficRoutingConfig(value) {
        this._trafficRoutingConfig = value;
      }
      get additionalOptions() {
        return this._additionalOptions;
      }
      set additionalOptions(value) {
        this._additionalOptions = value;
      }
      get lifecycleEventHooks() {
        return this._lifecycleEventHooks;
      }
      set lifecycleEventHooks(value) {
        this._lifecycleEventHooks = value;
      }
      renderProperties(_props) {
        var _a2, _b, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n, _o;
        return { ServiceRole: this.serviceRole, Applications: this.applications.map((app) => ({ Target: { Type: app.target.type, LogicalID: app.target.logicalId }, ECSAttributes: { TaskDefinitions: app.ecsAttributes.taskDefinitions, TaskSets: app.ecsAttributes.taskSets, TrafficRouting: { ProdTrafficRoute: { Type: app.ecsAttributes.trafficRouting.prodTrafficRoute.type, LogicalID: app.ecsAttributes.trafficRouting.prodTrafficRoute.logicalId }, TestTrafficRoute: { Type: app.ecsAttributes.trafficRouting.testTrafficRoute.type, LogicalID: app.ecsAttributes.trafficRouting.testTrafficRoute.logicalId }, TargetGroups: app.ecsAttributes.trafficRouting.targetGroups } } })), TrafficRoutingConfig: util_1.undefinedIfAllValuesAreEmpty({ Type: (_a2 = this.trafficRoutingConfig) == null ? void 0 : _a2.type, TimeBasedCanary: util_1.undefinedIfAllValuesAreEmpty({ StepPercentage: (_c = (_b = this.trafficRoutingConfig) == null ? void 0 : _b.timeBasedCanary) == null ? void 0 : _c.stepPercentage, BakeTimeMins: (_e = (_d = this.trafficRoutingConfig) == null ? void 0 : _d.timeBasedCanary) == null ? void 0 : _e.bakeTimeMins }), TimeBasedLinear: util_1.undefinedIfAllValuesAreEmpty({ StepPercentage: (_g = (_f = this.trafficRoutingConfig) == null ? void 0 : _f.timeBasedLinear) == null ? void 0 : _g.stepPercentage, BakeTimeMins: (_i = (_h = this.trafficRoutingConfig) == null ? void 0 : _h.timeBasedLinear) == null ? void 0 : _i.bakeTimeMins }) }), AdditionalOptions: util_1.undefinedIfAllValuesAreEmpty({ TerminationWaitTimeInMinutes: (_j = this.additionalOptions) == null ? void 0 : _j.terminationWaitTimeInMinutes }), LifecycleEventHooks: util_1.undefinedIfAllValuesAreEmpty({ BeforeInstall: (_k = this.lifecycleEventHooks) == null ? void 0 : _k.beforeInstall, AfterInstall: (_l = this.lifecycleEventHooks) == null ? void 0 : _l.afterInstall, AfterAllowTestTraffic: (_m = this.lifecycleEventHooks) == null ? void 0 : _m.afterAllowTestTraffic, BeforeAllowTraffic: (_n = this.lifecycleEventHooks) == null ? void 0 : _n.beforeAllowTraffic, AfterAllowTraffic: (_o = this.lifecycleEventHooks) == null ? void 0 : _o.afterAllowTraffic }) };
      }
    };
    exports.CfnCodeDeployBlueGreenHook = CfnCodeDeployBlueGreenHook, _a = JSII_RTTI_SYMBOL_1, CfnCodeDeployBlueGreenHook[_a] = { fqn: "aws-cdk-lib.CfnCodeDeployBlueGreenHook", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/cfn-include.js
var require_cfn_include = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cfn-include.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CfnInclude = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cfn_element_1 = require_cfn_element();
    var CfnInclude = class extends cfn_element_1.CfnElement {
      constructor(scope, id, props) {
        super(scope, id), this.template = props.template;
      }
      _toCloudFormation() {
        return this.template;
      }
    };
    exports.CfnInclude = CfnInclude, _a = JSII_RTTI_SYMBOL_1, CfnInclude[_a] = { fqn: "aws-cdk-lib.CfnInclude", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/cfn-tag.js
var require_cfn_tag = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cfn-tag.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/aws-cdk-lib/core/lib/cfn-json.js
var require_cfn_json = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cfn-json.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CfnJson = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var constructs_1 = require_lib4();
    var custom_resource_1 = require_custom_resource();
    var cfn_utils_provider_1 = require_cfn_utils_provider();
    var stack_1 = require_stack();
    var stack_trace_1 = require_stack_trace2();
    var CfnJson = class extends constructs_1.Construct {
      constructor(scope, id, props) {
        super(scope, id), this.creationStack = [];
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnJsonProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnJson), error;
        }
        this.creationStack = stack_trace_1.captureStackTrace(), this.jsonString = stack_1.Stack.of(this).toJsonString(props.value);
        const resource = new custom_resource_1.CustomResource(this, "Resource", { serviceToken: cfn_utils_provider_1.CfnUtilsProvider.getOrCreate(this), resourceType: "Custom::AWSCDKCfnJson", properties: { Value: this.jsonString } });
        this.value = resource.getAtt("Value");
      }
      toJSON() {
        return this.jsonString;
      }
      resolve(_) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IResolveContext(_);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.resolve), error;
        }
        return this.value;
      }
    };
    exports.CfnJson = CfnJson, _a = JSII_RTTI_SYMBOL_1, CfnJson[_a] = { fqn: "aws-cdk-lib.CfnJson", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/expiration.js
var require_expiration = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/expiration.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.Expiration = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var Expiration = class {
      constructor(date) {
        this.date = date;
      }
      static atDate(d) {
        return new Expiration(d);
      }
      static atTimestamp(t) {
        return Expiration.atDate(new Date(t));
      }
      static after(t) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_Duration(t);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.after), error;
        }
        return Expiration.atDate(new Date(Date.now() + t.toMilliseconds()));
      }
      static fromString(s) {
        return new Expiration(new Date(s));
      }
      toEpoch() {
        return Math.round(this.date.getTime() / 1e3);
      }
      isBefore(t) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_Duration(t);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.isBefore), error;
        }
        return this.date < new Date(Date.now() + t.toMilliseconds());
      }
      isAfter(t) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_Duration(t);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.isAfter), error;
        }
        return this.date > new Date(Date.now() + t.toMilliseconds());
      }
    };
    exports.Expiration = Expiration, _a = JSII_RTTI_SYMBOL_1, Expiration[_a] = { fqn: "aws-cdk-lib.Expiration", version: "2.50.0" };
  }
});

// node_modules/aws-cdk-lib/core/lib/environment.js
var require_environment2 = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/environment.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
  }
});

// node_modules/aws-cdk-lib/core/lib/runtime.js
var require_runtime = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/runtime.js"(exports) {
    "use strict";
    var _a;
    var _b;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.unionValidator = exports.requireProperty = exports.requiredValidator = exports.propertyValidator = exports.hashValidator = exports.listValidator = exports.validateCfnTag = exports.validateObject = exports.validateDate = exports.validateBoolean = exports.validateNumber = exports.validateString = exports.canInspect = exports.VALIDATION_SUCCESS = exports.ValidationResults = exports.ValidationResult = exports.unionMapper = exports.hashMapper = exports.listMapper = exports.cfnTagToCloudFormation = exports.dateToCloudFormation = exports.numberToCloudFormation = exports.objectToCloudFormation = exports.booleanToCloudFormation = exports.stringToCloudFormation = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    function identity(x) {
      return x;
    }
    exports.stringToCloudFormation = identity, exports.booleanToCloudFormation = identity, exports.objectToCloudFormation = identity, exports.numberToCloudFormation = identity;
    function dateToCloudFormation(x) {
      if (!!x)
        return `${x.getUTCFullYear()}-${pad(x.getUTCMonth() + 1)}-${pad(x.getUTCDate())}T${pad(x.getUTCHours())}:${pad(x.getUTCMinutes())}:${pad(x.getUTCSeconds())}`;
    }
    exports.dateToCloudFormation = dateToCloudFormation;
    function pad(x) {
      return x < 10 ? "0" + x.toString() : x.toString();
    }
    function cfnTagToCloudFormation(x) {
      return { Key: x.key, Value: x.value };
    }
    exports.cfnTagToCloudFormation = cfnTagToCloudFormation;
    function listMapper(elementMapper) {
      return (x) => canInspect(x) ? x.map(elementMapper) : x;
    }
    exports.listMapper = listMapper;
    function hashMapper(elementMapper) {
      return (x) => {
        if (!canInspect(x))
          return x;
        const ret = {};
        return Object.keys(x).forEach((key) => {
          ret[key] = elementMapper(x[key]);
        }), ret;
      };
    }
    exports.hashMapper = hashMapper;
    function unionMapper(validators, mappers) {
      if (validators.length !== mappers.length)
        throw Error("Not the same amount of validators and mappers passed to unionMapper()");
      return (x) => {
        if (!canInspect(x))
          return x;
        for (let i = 0; i < validators.length; i++)
          if (validators[i](x).isSuccess)
            return mappers[i](x);
        throw new TypeError("No validators matched in the union()");
      };
    }
    exports.unionMapper = unionMapper;
    var ValidationResult = class {
      constructor(errorMessage = "", results = new ValidationResults()) {
        this.errorMessage = errorMessage, this.results = results;
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ValidationResults(results);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, ValidationResult), error;
        }
      }
      get isSuccess() {
        return !this.errorMessage && this.results.isSuccess;
      }
      assertSuccess() {
        if (!this.isSuccess) {
          let message = this.errorTree();
          throw message = message.slice(0, 1).toUpperCase() + message.slice(1), new CfnSynthesisError(message);
        }
      }
      errorTree() {
        const childMessages = this.results.errorTreeList();
        return this.errorMessage + (childMessages.length ? `
  ${childMessages.replace(/\n/g, `
  `)}` : "");
      }
      prefix(message) {
        return this.isSuccess ? this : new ValidationResult(`${message}: ${this.errorMessage}`, this.results);
      }
    };
    exports.ValidationResult = ValidationResult, _a = JSII_RTTI_SYMBOL_1, ValidationResult[_a] = { fqn: "aws-cdk-lib.ValidationResult", version: "2.50.0" };
    var ValidationResults = class {
      constructor(results = []) {
        this.results = results;
      }
      collect(result) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_ValidationResult(result);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.collect), error;
        }
        result.isSuccess || this.results.push(result);
      }
      get isSuccess() {
        return this.results.every((x) => x.isSuccess);
      }
      errorTreeList() {
        return this.results.map((child) => child.errorTree()).join(`
`);
      }
      wrap(message) {
        return this.isSuccess ? exports.VALIDATION_SUCCESS : new ValidationResult(message, this);
      }
    };
    exports.ValidationResults = ValidationResults, _b = JSII_RTTI_SYMBOL_1, ValidationResults[_b] = { fqn: "aws-cdk-lib.ValidationResults", version: "2.50.0" }, exports.VALIDATION_SUCCESS = new ValidationResult();
    function canInspect(x) {
      return x != null && !isCloudFormationIntrinsic(x) && !isCloudFormationDynamicReference(x);
    }
    exports.canInspect = canInspect;
    function validateString(x) {
      return canInspect(x) && typeof x != "string" ? new ValidationResult(`${JSON.stringify(x)} should be a string`) : exports.VALIDATION_SUCCESS;
    }
    exports.validateString = validateString;
    function validateNumber(x) {
      return canInspect(x) && typeof x != "number" ? new ValidationResult(`${JSON.stringify(x)} should be a number`) : exports.VALIDATION_SUCCESS;
    }
    exports.validateNumber = validateNumber;
    function validateBoolean(x) {
      return canInspect(x) && typeof x != "boolean" ? new ValidationResult(`${JSON.stringify(x)} should be a boolean`) : exports.VALIDATION_SUCCESS;
    }
    exports.validateBoolean = validateBoolean;
    function validateDate(x) {
      return canInspect(x) && !(x instanceof Date) ? new ValidationResult(`${JSON.stringify(x)} should be a Date`) : x !== void 0 && isNaN(x.getTime()) ? new ValidationResult("got an unparseable Date") : exports.VALIDATION_SUCCESS;
    }
    exports.validateDate = validateDate;
    function validateObject(x) {
      return canInspect(x) && typeof x != "object" ? new ValidationResult(`${JSON.stringify(x)} should be an 'object'`) : exports.VALIDATION_SUCCESS;
    }
    exports.validateObject = validateObject;
    function validateCfnTag(x) {
      return canInspect(x) && (x.key == null || x.value == null) ? new ValidationResult(`${JSON.stringify(x)} should have a 'key' and a 'value' property`) : exports.VALIDATION_SUCCESS;
    }
    exports.validateCfnTag = validateCfnTag;
    function listValidator(elementValidator) {
      return (x) => {
        if (!canInspect(x))
          return exports.VALIDATION_SUCCESS;
        if (!x.forEach)
          return new ValidationResult(`${JSON.stringify(x)} should be a list`);
        for (let i = 0; i < x.length; i++) {
          const element = x[i], result = elementValidator(element);
          if (!result.isSuccess)
            return result.prefix(`element ${i}`);
        }
        return exports.VALIDATION_SUCCESS;
      };
    }
    exports.listValidator = listValidator;
    function hashValidator(elementValidator) {
      return (x) => {
        if (!canInspect(x))
          return exports.VALIDATION_SUCCESS;
        for (const key of Object.keys(x)) {
          const result = elementValidator(x[key]);
          if (!result.isSuccess)
            return result.prefix(`element '${key}'`);
        }
        return exports.VALIDATION_SUCCESS;
      };
    }
    exports.hashValidator = hashValidator;
    function propertyValidator(propName, validator) {
      return (x) => validator(x).prefix(propName);
    }
    exports.propertyValidator = propertyValidator;
    function requiredValidator(x) {
      return x == null ? new ValidationResult("required but missing") : exports.VALIDATION_SUCCESS;
    }
    exports.requiredValidator = requiredValidator;
    function requireProperty(props, name, context) {
      const value = props[name];
      if (value == null)
        throw new Error(`${context.toString()} is missing required property: ${name}`);
      return value;
    }
    exports.requireProperty = requireProperty;
    function unionValidator(...validators) {
      return (x) => {
        const results = new ValidationResults();
        let eitherOr = "either";
        for (const validator of validators) {
          const result = validator(x);
          if (result.isSuccess)
            return result;
          results.collect(result.prefix(eitherOr)), eitherOr = "or";
        }
        return results.wrap("not one of the possible types");
      };
    }
    exports.unionValidator = unionValidator;
    function isCloudFormationIntrinsic(x) {
      if (typeof x != "object")
        return false;
      const keys = Object.keys(x);
      return keys.length !== 1 ? false : keys[0] === "Ref" || keys[0].slice(0, 4) === "Fn::";
    }
    function isCloudFormationDynamicReference(x) {
      return typeof x == "string" && x.startsWith("{{resolve:") && x.endsWith("}}");
    }
    var CfnSynthesisError = class extends Error {
      constructor() {
        super(...arguments), this.type = "CfnSynthesisError";
      }
    };
  }
});

// node_modules/aws-cdk-lib/core/lib/secret-value.js
var require_secret_value = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/secret-value.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.SecretValue = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cx_api_1 = require_cx_api();
    var cfn_dynamic_reference_1 = require_cfn_dynamic_reference();
    var cfn_resource_1 = require_cfn_resource();
    var feature_flags_1 = require_feature_flags();
    var cfn_reference_1 = require_cfn_reference();
    var intrinsic_1 = require_intrinsic();
    var token_1 = require_token();
    var SecretValue = class extends intrinsic_1.Intrinsic {
      constructor(protectedValue, options) {
        super(protectedValue, options);
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IntrinsicProps(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, SecretValue), error;
        }
        this.rawValue = protectedValue;
      }
      static isSecretValue(x) {
        return typeof x == "object" && x && x[SECRET_VALUE_SYM];
      }
      static plainText(secret) {
        try {
          jsiiDeprecationWarnings.print("aws-cdk-lib.SecretValue#plainText", "Use `unsafePlainText()` instead.");
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.plainText), error;
        }
        return new SecretValue(secret);
      }
      static unsafePlainText(secret) {
        return new SecretValue(secret);
      }
      static secretsManager(secretId, options = {}) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_SecretsManagerSecretOptions(options);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.secretsManager), error;
        }
        if (!secretId)
          throw new Error("secretId cannot be empty");
        if (!token_1.Token.isUnresolved(secretId) && !secretId.startsWith("arn:") && secretId.includes(":"))
          throw new Error(`secret id "${secretId}" is not an ARN but contains ":"`);
        if (options.versionStage && options.versionId)
          throw new Error(`verionStage: '${options.versionStage}' and versionId: '${options.versionId}' were both provided but only one is allowed`);
        const parts = [secretId, "SecretString", options.jsonField || "", options.versionStage || "", options.versionId || ""], dyref = new cfn_dynamic_reference_1.CfnDynamicReference(cfn_dynamic_reference_1.CfnDynamicReferenceService.SECRETS_MANAGER, parts.join(":"));
        return this.cfnDynamicReference(dyref);
      }
      static ssmSecure(parameterName, version) {
        return this.cfnDynamicReference(new cfn_dynamic_reference_1.CfnDynamicReference(cfn_dynamic_reference_1.CfnDynamicReferenceService.SSM_SECURE, version ? `${parameterName}:${version}` : parameterName));
      }
      static cfnDynamicReference(ref) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnDynamicReference(ref);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.cfnDynamicReference), error;
        }
        return new SecretValue(ref);
      }
      static cfnParameter(param) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnParameter(param);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.cfnParameter), error;
        }
        if (!param.noEcho)
          throw new Error('CloudFormation parameter must be configured with "NoEcho"');
        return new SecretValue(param.value);
      }
      static resourceAttribute(attr) {
        const resolved = token_1.Tokenization.reverseCompleteString(attr);
        if (!resolved || !cfn_reference_1.CfnReference.isCfnReference(resolved) || !cfn_resource_1.CfnResource.isCfnResource(resolved.target))
          throw new Error("SecretValue.resourceAttribute() must be used with a resource attribute");
        return new SecretValue(attr);
      }
      unsafeUnwrap() {
        return token_1.Token.asString(this.rawValue);
      }
      resolve(context) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_IResolveContext(context);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.resolve), error;
        }
        if (feature_flags_1.FeatureFlags.of(context.scope).isEnabled(cx_api_1.CHECK_SECRET_USAGE))
          throw new Error(`Synthing a secret value to ${context.documentPath.join("/")}. Using a SecretValue here risks exposing your secret. Only pass SecretValues to constructs that accept a SecretValue property, or call AWS Secrets Manager directly in your runtime code. Call 'secretValue.unsafeUnwrap()' if you understand and accept the risks.`);
        return super.resolve(context);
      }
    };
    exports.SecretValue = SecretValue, _a = JSII_RTTI_SYMBOL_1, SecretValue[_a] = { fqn: "aws-cdk-lib.SecretValue", version: "2.50.0" };
    var SECRET_VALUE_SYM = Symbol.for("@aws-cdk/core.SecretValue");
    Object.defineProperty(SecretValue.prototype, SECRET_VALUE_SYM, { value: true, configurable: false, enumerable: false, writable: false });
  }
});

// node_modules/aws-cdk-lib/core/lib/physical-name.js
var require_physical_name = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/physical-name.js"(exports) {
    "use strict";
    var _a;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.PhysicalName = void 0;
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var physical_name_generator_1 = require_physical_name_generator();
    var token_1 = require_token();
    var PhysicalName = class {
      constructor() {
      }
    };
    exports.PhysicalName = PhysicalName, _a = JSII_RTTI_SYMBOL_1, PhysicalName[_a] = { fqn: "aws-cdk-lib.PhysicalName", version: "2.50.0" }, PhysicalName.GENERATE_IF_NEEDED = token_1.Token.asString(new physical_name_generator_1.GeneratedWhenNeededMarker());
  }
});

// node_modules/aws-cdk-lib/core/lib/helpers-internal/cfn-parse.js
var require_cfn_parse = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/helpers-internal/cfn-parse.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CfnParser = exports.CfnParsingContext = exports.FromCloudFormation = exports.FromCloudFormationPropertyObject = exports.FromCloudFormationResult = void 0;
    var cfn_fn_1 = require_cfn_fn();
    var cfn_pseudo_1 = require_cfn_pseudo();
    var cfn_resource_policy_1 = require_cfn_resource_policy();
    var lazy_1 = require_lazy();
    var cfn_reference_1 = require_cfn_reference();
    var token_1 = require_token();
    var util_1 = require_util();
    var FromCloudFormationResult = class {
      constructor(value) {
        this.value = value, this.extraProperties = {};
      }
      appendExtraProperties(prefix, properties) {
        for (const [key, val] of Object.entries(properties ?? {}))
          this.extraProperties[`${prefix}.${key}`] = val;
      }
    };
    exports.FromCloudFormationResult = FromCloudFormationResult;
    var FromCloudFormationPropertyObject = class extends FromCloudFormationResult {
      constructor() {
        super({}), this.recognizedProperties = /* @__PURE__ */ new Set();
      }
      addPropertyResult(cdkPropName, cfnPropName, result) {
        this.recognizedProperties.add(cfnPropName), result && (this.value[cdkPropName] = result.value, this.appendExtraProperties(cfnPropName, result.extraProperties));
      }
      addUnrecognizedPropertiesAsExtra(properties) {
        for (const [key, val] of Object.entries(properties))
          this.recognizedProperties.has(key) || (this.extraProperties[key] = val);
      }
    };
    exports.FromCloudFormationPropertyObject = FromCloudFormationPropertyObject;
    var FromCloudFormation = class {
      static getAny(value) {
        return new FromCloudFormationResult(value);
      }
      static getBoolean(value) {
        if (typeof value == "string")
          switch (value) {
            case "true":
              return new FromCloudFormationResult(true);
            case "false":
              return new FromCloudFormationResult(false);
            default:
              throw new Error(`Expected 'true' or 'false' for boolean value, got: '${value}'`);
          }
        return new FromCloudFormationResult(value);
      }
      static getDate(value) {
        return token_1.isResolvableObject(value) ? new FromCloudFormationResult(value) : typeof value == "string" ? new FromCloudFormationResult(new Date(value)) : new FromCloudFormationResult(value);
      }
      static getString(value) {
        return token_1.isResolvableObject(value) ? new FromCloudFormationResult(value.toString()) : typeof value == "number" ? new FromCloudFormationResult(value.toString()) : typeof value == "boolean" ? new FromCloudFormationResult(value.toString()) : new FromCloudFormationResult(value);
      }
      static getNumber(value) {
        if (token_1.isResolvableObject(value))
          return new FromCloudFormationResult(token_1.Token.asNumber(value));
        if (typeof value == "string") {
          const parsedValue = parseFloat(value);
          if (!isNaN(parsedValue))
            return new FromCloudFormationResult(parsedValue);
        }
        return new FromCloudFormationResult(value);
      }
      static getStringArray(value) {
        return token_1.isResolvableObject(value) ? new FromCloudFormationResult(token_1.Token.asList(value)) : this.getArray(this.getString)(value);
      }
      static getArray(mapper) {
        return (value) => {
          if (!Array.isArray(value))
            return new FromCloudFormationResult(value);
          const values = new Array(), ret = new FromCloudFormationResult(values);
          for (let i = 0; i < value.length; i++) {
            const result = mapper(value[i]);
            values.push(result.value), ret.appendExtraProperties(`${i}`, result.extraProperties);
          }
          return ret;
        };
      }
      static getMap(mapper) {
        return (value) => {
          if (typeof value != "object")
            return new FromCloudFormationResult(value);
          const values = {}, ret = new FromCloudFormationResult(values);
          for (const [key, val] of Object.entries(value)) {
            const result = mapper(val);
            values[key] = result.value, ret.appendExtraProperties(key, result.extraProperties);
          }
          return ret;
        };
      }
      static getCfnTag(tag) {
        return tag == null ? new FromCloudFormationResult({}) : new FromCloudFormationResult({ key: tag.Key, value: tag.Value });
      }
      static getTypeUnion(validators, mappers) {
        return (value) => {
          for (let i = 0; i < validators.length; i++) {
            const candidate = mappers[i](value);
            if (validators[i](candidate.value).isSuccess)
              return candidate;
          }
          return new FromCloudFormationResult(value);
        };
      }
    };
    exports.FromCloudFormation = FromCloudFormation;
    var CfnParsingContext;
    (function(CfnParsingContext2) {
      CfnParsingContext2[CfnParsingContext2.CONDITIONS = 0] = "CONDITIONS", CfnParsingContext2[CfnParsingContext2.RULES = 1] = "RULES";
    })(CfnParsingContext = exports.CfnParsingContext || (exports.CfnParsingContext = {}));
    var CfnParser = class {
      constructor(options) {
        this.options = options;
      }
      handleAttributes(resource, resourceAttributes, logicalId) {
        const cfnOptions = resource.cfnOptions;
        if (cfnOptions.creationPolicy = this.parseCreationPolicy(resourceAttributes.CreationPolicy), cfnOptions.updatePolicy = this.parseUpdatePolicy(resourceAttributes.UpdatePolicy), cfnOptions.deletionPolicy = this.parseDeletionPolicy(resourceAttributes.DeletionPolicy), cfnOptions.updateReplacePolicy = this.parseDeletionPolicy(resourceAttributes.UpdateReplacePolicy), cfnOptions.version = this.parseValue(resourceAttributes.Version), cfnOptions.description = this.parseValue(resourceAttributes.Description), cfnOptions.metadata = this.parseValue(resourceAttributes.Metadata), resourceAttributes.Condition) {
          const condition = this.finder.findCondition(resourceAttributes.Condition);
          if (!condition)
            throw new Error(`Resource '${logicalId}' uses Condition '${resourceAttributes.Condition}' that doesn't exist`);
          cfnOptions.condition = condition;
        }
        resourceAttributes.DependsOn = resourceAttributes.DependsOn ?? [];
        const dependencies = Array.isArray(resourceAttributes.DependsOn) ? resourceAttributes.DependsOn : [resourceAttributes.DependsOn];
        for (const dep of dependencies) {
          const depResource = this.finder.findResource(dep);
          if (!depResource)
            throw new Error(`Resource '${logicalId}' depends on '${dep}' that doesn't exist`);
          resource.node.addDependency(depResource);
        }
      }
      parseCreationPolicy(policy) {
        if (typeof policy != "object")
          return;
        return policy = this.parseValue(policy), util_1.undefinedIfAllValuesAreEmpty({ autoScalingCreationPolicy: parseAutoScalingCreationPolicy(policy.AutoScalingCreationPolicy), resourceSignal: parseResourceSignal(policy.ResourceSignal) });
        function parseAutoScalingCreationPolicy(p) {
          if (typeof p == "object")
            return util_1.undefinedIfAllValuesAreEmpty({ minSuccessfulInstancesPercent: FromCloudFormation.getNumber(p.MinSuccessfulInstancesPercent).value });
        }
        function parseResourceSignal(p) {
          if (typeof p == "object")
            return util_1.undefinedIfAllValuesAreEmpty({ count: FromCloudFormation.getNumber(p.Count).value, timeout: FromCloudFormation.getString(p.Timeout).value });
        }
      }
      parseUpdatePolicy(policy) {
        if (typeof policy != "object")
          return;
        return policy = this.parseValue(policy), util_1.undefinedIfAllValuesAreEmpty({ autoScalingReplacingUpdate: parseAutoScalingReplacingUpdate(policy.AutoScalingReplacingUpdate), autoScalingRollingUpdate: parseAutoScalingRollingUpdate(policy.AutoScalingRollingUpdate), autoScalingScheduledAction: parseAutoScalingScheduledAction(policy.AutoScalingScheduledAction), codeDeployLambdaAliasUpdate: parseCodeDeployLambdaAliasUpdate(policy.CodeDeployLambdaAliasUpdate), enableVersionUpgrade: FromCloudFormation.getBoolean(policy.EnableVersionUpgrade).value, useOnlineResharding: FromCloudFormation.getBoolean(policy.UseOnlineResharding).value });
        function parseAutoScalingReplacingUpdate(p) {
          if (typeof p == "object")
            return util_1.undefinedIfAllValuesAreEmpty({ willReplace: p.WillReplace });
        }
        function parseAutoScalingRollingUpdate(p) {
          if (typeof p == "object")
            return util_1.undefinedIfAllValuesAreEmpty({ maxBatchSize: FromCloudFormation.getNumber(p.MaxBatchSize).value, minInstancesInService: FromCloudFormation.getNumber(p.MinInstancesInService).value, minSuccessfulInstancesPercent: FromCloudFormation.getNumber(p.MinSuccessfulInstancesPercent).value, pauseTime: FromCloudFormation.getString(p.PauseTime).value, suspendProcesses: FromCloudFormation.getStringArray(p.SuspendProcesses).value, waitOnResourceSignals: FromCloudFormation.getBoolean(p.WaitOnResourceSignals).value });
        }
        function parseCodeDeployLambdaAliasUpdate(p) {
          if (typeof p == "object")
            return { beforeAllowTrafficHook: FromCloudFormation.getString(p.BeforeAllowTrafficHook).value, afterAllowTrafficHook: FromCloudFormation.getString(p.AfterAllowTrafficHook).value, applicationName: FromCloudFormation.getString(p.ApplicationName).value, deploymentGroupName: FromCloudFormation.getString(p.DeploymentGroupName).value };
        }
        function parseAutoScalingScheduledAction(p) {
          if (typeof p == "object")
            return util_1.undefinedIfAllValuesAreEmpty({ ignoreUnmodifiedGroupSizeProperties: FromCloudFormation.getBoolean(p.IgnoreUnmodifiedGroupSizeProperties).value });
        }
      }
      parseDeletionPolicy(policy) {
        switch (policy) {
          case null:
            return;
          case void 0:
            return;
          case "Delete":
            return cfn_resource_policy_1.CfnDeletionPolicy.DELETE;
          case "Retain":
            return cfn_resource_policy_1.CfnDeletionPolicy.RETAIN;
          case "Snapshot":
            return cfn_resource_policy_1.CfnDeletionPolicy.SNAPSHOT;
          default:
            throw new Error(`Unrecognized DeletionPolicy '${policy}'`);
        }
      }
      parseValue(cfnValue) {
        if (cfnValue != null) {
          if (token_1.isResolvableObject(cfnValue))
            return cfnValue;
          if (Array.isArray(cfnValue))
            return cfnValue.map((el) => this.parseValue(el));
          if (typeof cfnValue == "object") {
            const cfnIntrinsic = this.parseIfCfnIntrinsic(cfnValue);
            if (cfnIntrinsic !== void 0)
              return cfnIntrinsic;
            const ret = {};
            for (const [key, val] of Object.entries(cfnValue))
              ret[key] = this.parseValue(val);
            return ret;
          }
          return cfnValue;
        }
      }
      get finder() {
        return this.options.finder;
      }
      parseIfCfnIntrinsic(object) {
        const key = this.looksLikeCfnIntrinsic(object);
        switch (key) {
          case void 0:
            return;
          case "Ref": {
            const refTarget = object[key], specialRef = this.specialCaseRefs(refTarget);
            if (specialRef !== void 0)
              return specialRef;
            {
              const refElement = this.finder.findRefTarget(refTarget);
              if (!refElement)
                throw new Error(`Element used in Ref expression with logical ID: '${refTarget}' not found`);
              return cfn_reference_1.CfnReference.for(refElement, "Ref");
            }
          }
          case "Fn::GetAtt": {
            const value = object[key];
            let logicalId, attributeName, stringForm;
            if (typeof value == "string") {
              const dotIndex = value.indexOf(".");
              if (dotIndex === -1)
                throw new Error(`Short-form Fn::GetAtt must contain a '.' in its string argument, got: '${value}'`);
              logicalId = value.slice(0, dotIndex), attributeName = value.slice(dotIndex + 1), stringForm = true;
            } else
              logicalId = value[0], attributeName = value[1], stringForm = false;
            const target = this.finder.findResource(logicalId);
            if (!target)
              throw new Error(`Resource used in GetAtt expression with logical ID: '${logicalId}' not found`);
            return cfn_reference_1.CfnReference.for(target, attributeName, stringForm ? cfn_reference_1.ReferenceRendering.GET_ATT_STRING : void 0);
          }
          case "Fn::Join": {
            const value = this.parseValue(object[key]);
            return cfn_fn_1.Fn.join(value[0], lazy_1.Lazy.list({ produce: () => value[1] }));
          }
          case "Fn::Cidr": {
            const value = this.parseValue(object[key]);
            return cfn_fn_1.Fn.cidr(value[0], value[1], value[2]);
          }
          case "Fn::FindInMap": {
            const value = this.parseValue(object[key]);
            let mappingName;
            if (token_1.Token.isUnresolved(value[0]))
              mappingName = value[0];
            else {
              const mapping = this.finder.findMapping(value[0]);
              if (!mapping)
                throw new Error(`Mapping used in FindInMap expression with name '${value[0]}' was not found in the template`);
              mappingName = mapping.logicalId;
            }
            return cfn_fn_1.Fn._findInMap(mappingName, value[1], value[2]);
          }
          case "Fn::Select": {
            const value = this.parseValue(object[key]);
            return cfn_fn_1.Fn.select(value[0], value[1]);
          }
          case "Fn::GetAZs": {
            const value = this.parseValue(object[key]);
            return cfn_fn_1.Fn.getAzs(value);
          }
          case "Fn::ImportValue": {
            const value = this.parseValue(object[key]);
            return cfn_fn_1.Fn.importValue(value);
          }
          case "Fn::Split": {
            const value = this.parseValue(object[key]);
            return cfn_fn_1.Fn.split(value[0], value[1]);
          }
          case "Fn::Transform": {
            const value = this.parseValue(object[key]);
            return cfn_fn_1.Fn.transform(value.Name, value.Parameters);
          }
          case "Fn::Base64": {
            const value = this.parseValue(object[key]);
            return cfn_fn_1.Fn.base64(value);
          }
          case "Fn::If": {
            const value = this.parseValue(object[key]), condition = this.finder.findCondition(value[0]);
            if (!condition)
              throw new Error(`Condition '${value[0]}' used in an Fn::If expression does not exist in the template`);
            return cfn_fn_1.Fn.conditionIf(condition.logicalId, value[1], value[2]);
          }
          case "Fn::Equals": {
            const value = this.parseValue(object[key]);
            return cfn_fn_1.Fn.conditionEquals(value[0], value[1]);
          }
          case "Fn::And": {
            const value = this.parseValue(object[key]);
            return cfn_fn_1.Fn.conditionAnd(...value);
          }
          case "Fn::Not": {
            const value = this.parseValue(object[key]);
            return cfn_fn_1.Fn.conditionNot(value[0]);
          }
          case "Fn::Or": {
            const value = this.parseValue(object[key]);
            return cfn_fn_1.Fn.conditionOr(...value);
          }
          case "Fn::Sub": {
            const value = this.parseValue(object[key]);
            let fnSubString, map;
            return typeof value == "string" ? (fnSubString = value, map = void 0) : (fnSubString = value[0], map = value[1]), this.parseFnSubString(fnSubString, map);
          }
          case "Condition": {
            const condition = this.finder.findCondition(object[key]);
            if (!condition)
              throw new Error(`Referenced Condition with name '${object[key]}' was not found in the template`);
            return { Condition: condition.logicalId };
          }
          default:
            if (this.options.context === CfnParsingContext.RULES)
              return this.handleRulesIntrinsic(key, object);
            throw new Error(`Unsupported CloudFormation function '${key}'`);
        }
      }
      looksLikeCfnIntrinsic(object) {
        const objectKeys = Object.keys(object);
        if (objectKeys.length !== 1)
          return;
        const key = objectKeys[0];
        return key === "Ref" || key.startsWith("Fn::") || this.options.context === CfnParsingContext.CONDITIONS && key === "Condition" ? key : void 0;
      }
      parseFnSubString(templateString, expressionMap) {
        const map = expressionMap ?? {}, self = this;
        return cfn_fn_1.Fn.sub(go(templateString), Object.keys(map).length === 0 ? expressionMap : map);
        function go(value) {
          const leftBrace = value.indexOf("${");
          if (leftBrace === -1)
            return value;
          const rightBrace = value.indexOf("}", leftBrace);
          if (rightBrace === -1)
            return value;
          const leftHalf = value.substring(0, leftBrace), rightHalf = value.substring(rightBrace + 1), refTarget = value.substring(leftBrace + 2, rightBrace).trim();
          if (refTarget[0] === "!")
            return value.substring(0, rightBrace + 1) + go(rightHalf);
          if (refTarget in map)
            return leftHalf + "${" + refTarget + "}" + go(rightHalf);
          const specialRef = self.specialCaseSubRefs(refTarget);
          if (specialRef !== void 0)
            return token_1.Token.isUnresolved(specialRef) ? (map[refTarget] = specialRef, leftHalf + "${" + refTarget + "}" + go(rightHalf)) : leftHalf + specialRef + go(rightHalf);
          const dotIndex = refTarget.indexOf(".");
          if (dotIndex === -1) {
            const refElement = self.finder.findRefTarget(refTarget);
            if (!refElement)
              throw new Error(`Element referenced in Fn::Sub expression with logical ID: '${refTarget}' was not found in the template`);
            return leftHalf + cfn_reference_1.CfnReference.for(refElement, "Ref", cfn_reference_1.ReferenceRendering.FN_SUB).toString() + go(rightHalf);
          } else {
            const targetId = refTarget.substring(0, dotIndex), refResource = self.finder.findResource(targetId);
            if (!refResource)
              throw new Error(`Resource referenced in Fn::Sub expression with logical ID: '${targetId}' was not found in the template`);
            const attribute = refTarget.substring(dotIndex + 1);
            return leftHalf + cfn_reference_1.CfnReference.for(refResource, attribute, cfn_reference_1.ReferenceRendering.FN_SUB).toString() + go(rightHalf);
          }
        }
      }
      handleRulesIntrinsic(key, object) {
        switch (key) {
          case "Fn::ValueOf": {
            const value = this.parseValue(object[key]), parameterName = value[0];
            if (parameterName in this.parameters)
              throw new Error(`Cannot substitute parameter '${parameterName}' used in Fn::ValueOf expression with attribute '${value[1]}'`);
            const param = this.finder.findRefTarget(parameterName);
            if (!param)
              throw new Error(`Rule references parameter '${parameterName}' which was not found in the template`);
            return lazy_1.Lazy.any({ produce: () => ({ "Fn::ValueOf": [param.logicalId, value[1]] }) });
          }
          default:
            return;
        }
      }
      specialCaseRefs(value) {
        if (value in this.parameters)
          return this.parameters[value];
        switch (value) {
          case "AWS::AccountId":
            return cfn_pseudo_1.Aws.ACCOUNT_ID;
          case "AWS::Region":
            return cfn_pseudo_1.Aws.REGION;
          case "AWS::Partition":
            return cfn_pseudo_1.Aws.PARTITION;
          case "AWS::URLSuffix":
            return cfn_pseudo_1.Aws.URL_SUFFIX;
          case "AWS::NotificationARNs":
            return cfn_pseudo_1.Aws.NOTIFICATION_ARNS;
          case "AWS::StackId":
            return cfn_pseudo_1.Aws.STACK_ID;
          case "AWS::StackName":
            return cfn_pseudo_1.Aws.STACK_NAME;
          case "AWS::NoValue":
            return cfn_pseudo_1.Aws.NO_VALUE;
          default:
            return;
        }
      }
      specialCaseSubRefs(value) {
        return value in this.parameters ? this.parameters[value] : value.indexOf("::") === -1 ? void 0 : "${" + value + "}";
      }
      get parameters() {
        return this.options.parameters || {};
      }
    };
    exports.CfnParser = CfnParser;
  }
});

// node_modules/aws-cdk-lib/core/lib/helpers-internal/index.js
var require_helpers_internal = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/helpers-internal/index.js"(exports) {
    "use strict";
    var __createBinding = exports && exports.__createBinding || (Object.create ? function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), Object.defineProperty(o, k2, { enumerable: true, get: function() {
        return m[k];
      } });
    } : function(o, m, k, k2) {
      k2 === void 0 && (k2 = k), o[k2] = m[k];
    });
    var __exportStar = exports && exports.__exportStar || function(m, exports2) {
      for (var p in m)
        p !== "default" && !exports2.hasOwnProperty(p) && __createBinding(exports2, m, p);
    };
    Object.defineProperty(exports, "__esModule", { value: true }), __exportStar(require_cfn_parse(), exports);
  }
});

// node_modules/aws-cdk-lib/core/lib/cloudformation.generated.js
var require_cloudformation_generated = __commonJS({
  "node_modules/aws-cdk-lib/core/lib/cloudformation.generated.js"(exports) {
    "use strict";
    var _a;
    var _b;
    var _c;
    var _d;
    var _e;
    var _f;
    var _g;
    var _h;
    var _j;
    var _k;
    var _l;
    var _m;
    var _o;
    var _p;
    var _q;
    var _r;
    Object.defineProperty(exports, "__esModule", { value: true }), exports.CfnWaitConditionHandle = exports.CfnWaitCondition = exports.CfnTypeActivation = exports.CfnStackSet = exports.CfnStack = exports.CfnResourceVersion = exports.CfnResourceDefaultVersion = exports.CfnPublisher = exports.CfnPublicTypeVersion = exports.CfnModuleVersion = exports.CfnModuleDefaultVersion = exports.CfnMacro = exports.CfnHookVersion = exports.CfnHookTypeConfig = exports.CfnHookDefaultVersion = exports.CfnCustomResource = void 0;
    var jsiiDeprecationWarnings = require_warnings_jsii();
    var JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
    var cdk = require_lib7();
    var cfn_parse = require_helpers_internal();
    function CfnCustomResourcePropsValidator(properties) {
      if (!cdk.canInspect(properties))
        return cdk.VALIDATION_SUCCESS;
      const errors = new cdk.ValidationResults();
      return typeof properties != "object" && errors.collect(new cdk.ValidationResult("Expected an object, but received: " + JSON.stringify(properties))), errors.collect(cdk.propertyValidator("serviceToken", cdk.requiredValidator)(properties.serviceToken)), errors.collect(cdk.propertyValidator("serviceToken", cdk.validateString)(properties.serviceToken)), errors.wrap('supplied properties not correct for "CfnCustomResourceProps"');
    }
    function cfnCustomResourcePropsToCloudFormation(properties) {
      return cdk.canInspect(properties) ? (CfnCustomResourcePropsValidator(properties).assertSuccess(), { ServiceToken: cdk.stringToCloudFormation(properties.serviceToken) }) : properties;
    }
    function CfnCustomResourcePropsFromCloudFormation(properties) {
      if (properties = properties ?? {}, typeof properties != "object")
        return new cfn_parse.FromCloudFormationResult(properties);
      const ret = new cfn_parse.FromCloudFormationPropertyObject();
      return ret.addPropertyResult("serviceToken", "ServiceToken", cfn_parse.FromCloudFormation.getString(properties.ServiceToken)), ret.addUnrecognizedPropertiesAsExtra(properties), ret;
    }
    var CfnCustomResource = class extends cdk.CfnResource {
      constructor(scope, id, props) {
        super(scope, id, { type: CfnCustomResource.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnCustomResourceProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnCustomResource), error;
        }
        cdk.requireProperty(props, "serviceToken", this), this.serviceToken = props.serviceToken;
      }
      static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties), propsResult = CfnCustomResourcePropsFromCloudFormation(resourceProperties), ret = new CfnCustomResource(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties))
          ret.addPropertyOverride(propKey, propVal);
        return options.parser.handleAttributes(ret, resourceAttributes, id), ret;
      }
      inspect(inspector) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.inspect), error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnCustomResource.CFN_RESOURCE_TYPE_NAME), inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
      }
      get cfnProperties() {
        return { serviceToken: this.serviceToken };
      }
      renderProperties(props) {
        return cfnCustomResourcePropsToCloudFormation(props);
      }
    };
    exports.CfnCustomResource = CfnCustomResource, _a = JSII_RTTI_SYMBOL_1, CfnCustomResource[_a] = { fqn: "aws-cdk-lib.CfnCustomResource", version: "2.50.0" }, CfnCustomResource.CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::CustomResource";
    function CfnHookDefaultVersionPropsValidator(properties) {
      if (!cdk.canInspect(properties))
        return cdk.VALIDATION_SUCCESS;
      const errors = new cdk.ValidationResults();
      return typeof properties != "object" && errors.collect(new cdk.ValidationResult("Expected an object, but received: " + JSON.stringify(properties))), errors.collect(cdk.propertyValidator("typeName", cdk.validateString)(properties.typeName)), errors.collect(cdk.propertyValidator("typeVersionArn", cdk.validateString)(properties.typeVersionArn)), errors.collect(cdk.propertyValidator("versionId", cdk.validateString)(properties.versionId)), errors.wrap('supplied properties not correct for "CfnHookDefaultVersionProps"');
    }
    function cfnHookDefaultVersionPropsToCloudFormation(properties) {
      return cdk.canInspect(properties) ? (CfnHookDefaultVersionPropsValidator(properties).assertSuccess(), { TypeName: cdk.stringToCloudFormation(properties.typeName), TypeVersionArn: cdk.stringToCloudFormation(properties.typeVersionArn), VersionId: cdk.stringToCloudFormation(properties.versionId) }) : properties;
    }
    function CfnHookDefaultVersionPropsFromCloudFormation(properties) {
      if (properties = properties ?? {}, typeof properties != "object")
        return new cfn_parse.FromCloudFormationResult(properties);
      const ret = new cfn_parse.FromCloudFormationPropertyObject();
      return ret.addPropertyResult("typeName", "TypeName", properties.TypeName != null ? cfn_parse.FromCloudFormation.getString(properties.TypeName) : void 0), ret.addPropertyResult("typeVersionArn", "TypeVersionArn", properties.TypeVersionArn != null ? cfn_parse.FromCloudFormation.getString(properties.TypeVersionArn) : void 0), ret.addPropertyResult("versionId", "VersionId", properties.VersionId != null ? cfn_parse.FromCloudFormation.getString(properties.VersionId) : void 0), ret.addUnrecognizedPropertiesAsExtra(properties), ret;
    }
    var CfnHookDefaultVersion = class extends cdk.CfnResource {
      constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnHookDefaultVersion.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnHookDefaultVersionProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnHookDefaultVersion), error;
        }
        this.attrArn = cdk.Token.asString(this.getAtt("Arn")), this.typeName = props.typeName, this.typeVersionArn = props.typeVersionArn, this.versionId = props.versionId;
      }
      static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties), propsResult = CfnHookDefaultVersionPropsFromCloudFormation(resourceProperties), ret = new CfnHookDefaultVersion(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties))
          ret.addPropertyOverride(propKey, propVal);
        return options.parser.handleAttributes(ret, resourceAttributes, id), ret;
      }
      inspect(inspector) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.inspect), error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnHookDefaultVersion.CFN_RESOURCE_TYPE_NAME), inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
      }
      get cfnProperties() {
        return { typeName: this.typeName, typeVersionArn: this.typeVersionArn, versionId: this.versionId };
      }
      renderProperties(props) {
        return cfnHookDefaultVersionPropsToCloudFormation(props);
      }
    };
    exports.CfnHookDefaultVersion = CfnHookDefaultVersion, _b = JSII_RTTI_SYMBOL_1, CfnHookDefaultVersion[_b] = { fqn: "aws-cdk-lib.CfnHookDefaultVersion", version: "2.50.0" }, CfnHookDefaultVersion.CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::HookDefaultVersion";
    function CfnHookTypeConfigPropsValidator(properties) {
      if (!cdk.canInspect(properties))
        return cdk.VALIDATION_SUCCESS;
      const errors = new cdk.ValidationResults();
      return typeof properties != "object" && errors.collect(new cdk.ValidationResult("Expected an object, but received: " + JSON.stringify(properties))), errors.collect(cdk.propertyValidator("configuration", cdk.requiredValidator)(properties.configuration)), errors.collect(cdk.propertyValidator("configuration", cdk.validateString)(properties.configuration)), errors.collect(cdk.propertyValidator("configurationAlias", cdk.validateString)(properties.configurationAlias)), errors.collect(cdk.propertyValidator("typeArn", cdk.validateString)(properties.typeArn)), errors.collect(cdk.propertyValidator("typeName", cdk.validateString)(properties.typeName)), errors.wrap('supplied properties not correct for "CfnHookTypeConfigProps"');
    }
    function cfnHookTypeConfigPropsToCloudFormation(properties) {
      return cdk.canInspect(properties) ? (CfnHookTypeConfigPropsValidator(properties).assertSuccess(), { Configuration: cdk.stringToCloudFormation(properties.configuration), ConfigurationAlias: cdk.stringToCloudFormation(properties.configurationAlias), TypeArn: cdk.stringToCloudFormation(properties.typeArn), TypeName: cdk.stringToCloudFormation(properties.typeName) }) : properties;
    }
    function CfnHookTypeConfigPropsFromCloudFormation(properties) {
      if (properties = properties ?? {}, typeof properties != "object")
        return new cfn_parse.FromCloudFormationResult(properties);
      const ret = new cfn_parse.FromCloudFormationPropertyObject();
      return ret.addPropertyResult("configuration", "Configuration", cfn_parse.FromCloudFormation.getString(properties.Configuration)), ret.addPropertyResult("configurationAlias", "ConfigurationAlias", properties.ConfigurationAlias != null ? cfn_parse.FromCloudFormation.getString(properties.ConfigurationAlias) : void 0), ret.addPropertyResult("typeArn", "TypeArn", properties.TypeArn != null ? cfn_parse.FromCloudFormation.getString(properties.TypeArn) : void 0), ret.addPropertyResult("typeName", "TypeName", properties.TypeName != null ? cfn_parse.FromCloudFormation.getString(properties.TypeName) : void 0), ret.addUnrecognizedPropertiesAsExtra(properties), ret;
    }
    var CfnHookTypeConfig = class extends cdk.CfnResource {
      constructor(scope, id, props) {
        super(scope, id, { type: CfnHookTypeConfig.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnHookTypeConfigProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnHookTypeConfig), error;
        }
        cdk.requireProperty(props, "configuration", this), this.attrConfigurationArn = cdk.Token.asString(this.getAtt("ConfigurationArn")), this.configuration = props.configuration, this.configurationAlias = props.configurationAlias, this.typeArn = props.typeArn, this.typeName = props.typeName;
      }
      static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties), propsResult = CfnHookTypeConfigPropsFromCloudFormation(resourceProperties), ret = new CfnHookTypeConfig(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties))
          ret.addPropertyOverride(propKey, propVal);
        return options.parser.handleAttributes(ret, resourceAttributes, id), ret;
      }
      inspect(inspector) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.inspect), error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnHookTypeConfig.CFN_RESOURCE_TYPE_NAME), inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
      }
      get cfnProperties() {
        return { configuration: this.configuration, configurationAlias: this.configurationAlias, typeArn: this.typeArn, typeName: this.typeName };
      }
      renderProperties(props) {
        return cfnHookTypeConfigPropsToCloudFormation(props);
      }
    };
    exports.CfnHookTypeConfig = CfnHookTypeConfig, _c = JSII_RTTI_SYMBOL_1, CfnHookTypeConfig[_c] = { fqn: "aws-cdk-lib.CfnHookTypeConfig", version: "2.50.0" }, CfnHookTypeConfig.CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::HookTypeConfig";
    function CfnHookVersionPropsValidator(properties) {
      if (!cdk.canInspect(properties))
        return cdk.VALIDATION_SUCCESS;
      const errors = new cdk.ValidationResults();
      return typeof properties != "object" && errors.collect(new cdk.ValidationResult("Expected an object, but received: " + JSON.stringify(properties))), errors.collect(cdk.propertyValidator("executionRoleArn", cdk.validateString)(properties.executionRoleArn)), errors.collect(cdk.propertyValidator("loggingConfig", CfnHookVersion_LoggingConfigPropertyValidator)(properties.loggingConfig)), errors.collect(cdk.propertyValidator("schemaHandlerPackage", cdk.requiredValidator)(properties.schemaHandlerPackage)), errors.collect(cdk.propertyValidator("schemaHandlerPackage", cdk.validateString)(properties.schemaHandlerPackage)), errors.collect(cdk.propertyValidator("typeName", cdk.requiredValidator)(properties.typeName)), errors.collect(cdk.propertyValidator("typeName", cdk.validateString)(properties.typeName)), errors.wrap('supplied properties not correct for "CfnHookVersionProps"');
    }
    function cfnHookVersionPropsToCloudFormation(properties) {
      return cdk.canInspect(properties) ? (CfnHookVersionPropsValidator(properties).assertSuccess(), { SchemaHandlerPackage: cdk.stringToCloudFormation(properties.schemaHandlerPackage), TypeName: cdk.stringToCloudFormation(properties.typeName), ExecutionRoleArn: cdk.stringToCloudFormation(properties.executionRoleArn), LoggingConfig: cfnHookVersionLoggingConfigPropertyToCloudFormation(properties.loggingConfig) }) : properties;
    }
    function CfnHookVersionPropsFromCloudFormation(properties) {
      if (properties = properties ?? {}, typeof properties != "object")
        return new cfn_parse.FromCloudFormationResult(properties);
      const ret = new cfn_parse.FromCloudFormationPropertyObject();
      return ret.addPropertyResult("schemaHandlerPackage", "SchemaHandlerPackage", cfn_parse.FromCloudFormation.getString(properties.SchemaHandlerPackage)), ret.addPropertyResult("typeName", "TypeName", cfn_parse.FromCloudFormation.getString(properties.TypeName)), ret.addPropertyResult("executionRoleArn", "ExecutionRoleArn", properties.ExecutionRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ExecutionRoleArn) : void 0), ret.addPropertyResult("loggingConfig", "LoggingConfig", properties.LoggingConfig != null ? CfnHookVersionLoggingConfigPropertyFromCloudFormation(properties.LoggingConfig) : void 0), ret.addUnrecognizedPropertiesAsExtra(properties), ret;
    }
    var CfnHookVersion = class extends cdk.CfnResource {
      constructor(scope, id, props) {
        super(scope, id, { type: CfnHookVersion.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnHookVersionProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnHookVersion), error;
        }
        cdk.requireProperty(props, "schemaHandlerPackage", this), cdk.requireProperty(props, "typeName", this), this.attrArn = cdk.Token.asString(this.getAtt("Arn")), this.attrIsDefaultVersion = this.getAtt("IsDefaultVersion"), this.attrTypeArn = cdk.Token.asString(this.getAtt("TypeArn")), this.attrVersionId = cdk.Token.asString(this.getAtt("VersionId")), this.attrVisibility = cdk.Token.asString(this.getAtt("Visibility")), this.schemaHandlerPackage = props.schemaHandlerPackage, this.typeName = props.typeName, this.executionRoleArn = props.executionRoleArn, this.loggingConfig = props.loggingConfig;
      }
      static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties), propsResult = CfnHookVersionPropsFromCloudFormation(resourceProperties), ret = new CfnHookVersion(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties))
          ret.addPropertyOverride(propKey, propVal);
        return options.parser.handleAttributes(ret, resourceAttributes, id), ret;
      }
      inspect(inspector) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.inspect), error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnHookVersion.CFN_RESOURCE_TYPE_NAME), inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
      }
      get cfnProperties() {
        return { schemaHandlerPackage: this.schemaHandlerPackage, typeName: this.typeName, executionRoleArn: this.executionRoleArn, loggingConfig: this.loggingConfig };
      }
      renderProperties(props) {
        return cfnHookVersionPropsToCloudFormation(props);
      }
    };
    exports.CfnHookVersion = CfnHookVersion, _d = JSII_RTTI_SYMBOL_1, CfnHookVersion[_d] = { fqn: "aws-cdk-lib.CfnHookVersion", version: "2.50.0" }, CfnHookVersion.CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::HookVersion";
    function CfnHookVersion_LoggingConfigPropertyValidator(properties) {
      if (!cdk.canInspect(properties))
        return cdk.VALIDATION_SUCCESS;
      const errors = new cdk.ValidationResults();
      return typeof properties != "object" && errors.collect(new cdk.ValidationResult("Expected an object, but received: " + JSON.stringify(properties))), errors.collect(cdk.propertyValidator("logGroupName", cdk.validateString)(properties.logGroupName)), errors.collect(cdk.propertyValidator("logRoleArn", cdk.validateString)(properties.logRoleArn)), errors.wrap('supplied properties not correct for "LoggingConfigProperty"');
    }
    function cfnHookVersionLoggingConfigPropertyToCloudFormation(properties) {
      return cdk.canInspect(properties) ? (CfnHookVersion_LoggingConfigPropertyValidator(properties).assertSuccess(), { LogGroupName: cdk.stringToCloudFormation(properties.logGroupName), LogRoleArn: cdk.stringToCloudFormation(properties.logRoleArn) }) : properties;
    }
    function CfnHookVersionLoggingConfigPropertyFromCloudFormation(properties) {
      if (cdk.isResolvableObject(properties))
        return new cfn_parse.FromCloudFormationResult(properties);
      if (properties = properties ?? {}, typeof properties != "object")
        return new cfn_parse.FromCloudFormationResult(properties);
      const ret = new cfn_parse.FromCloudFormationPropertyObject();
      return ret.addPropertyResult("logGroupName", "LogGroupName", properties.LogGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.LogGroupName) : void 0), ret.addPropertyResult("logRoleArn", "LogRoleArn", properties.LogRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.LogRoleArn) : void 0), ret.addUnrecognizedPropertiesAsExtra(properties), ret;
    }
    function CfnMacroPropsValidator(properties) {
      if (!cdk.canInspect(properties))
        return cdk.VALIDATION_SUCCESS;
      const errors = new cdk.ValidationResults();
      return typeof properties != "object" && errors.collect(new cdk.ValidationResult("Expected an object, but received: " + JSON.stringify(properties))), errors.collect(cdk.propertyValidator("description", cdk.validateString)(properties.description)), errors.collect(cdk.propertyValidator("functionName", cdk.requiredValidator)(properties.functionName)), errors.collect(cdk.propertyValidator("functionName", cdk.validateString)(properties.functionName)), errors.collect(cdk.propertyValidator("logGroupName", cdk.validateString)(properties.logGroupName)), errors.collect(cdk.propertyValidator("logRoleArn", cdk.validateString)(properties.logRoleArn)), errors.collect(cdk.propertyValidator("name", cdk.requiredValidator)(properties.name)), errors.collect(cdk.propertyValidator("name", cdk.validateString)(properties.name)), errors.wrap('supplied properties not correct for "CfnMacroProps"');
    }
    function cfnMacroPropsToCloudFormation(properties) {
      return cdk.canInspect(properties) ? (CfnMacroPropsValidator(properties).assertSuccess(), { FunctionName: cdk.stringToCloudFormation(properties.functionName), Name: cdk.stringToCloudFormation(properties.name), Description: cdk.stringToCloudFormation(properties.description), LogGroupName: cdk.stringToCloudFormation(properties.logGroupName), LogRoleARN: cdk.stringToCloudFormation(properties.logRoleArn) }) : properties;
    }
    function CfnMacroPropsFromCloudFormation(properties) {
      if (properties = properties ?? {}, typeof properties != "object")
        return new cfn_parse.FromCloudFormationResult(properties);
      const ret = new cfn_parse.FromCloudFormationPropertyObject();
      return ret.addPropertyResult("functionName", "FunctionName", cfn_parse.FromCloudFormation.getString(properties.FunctionName)), ret.addPropertyResult("name", "Name", cfn_parse.FromCloudFormation.getString(properties.Name)), ret.addPropertyResult("description", "Description", properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : void 0), ret.addPropertyResult("logGroupName", "LogGroupName", properties.LogGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.LogGroupName) : void 0), ret.addPropertyResult("logRoleArn", "LogRoleARN", properties.LogRoleARN != null ? cfn_parse.FromCloudFormation.getString(properties.LogRoleARN) : void 0), ret.addUnrecognizedPropertiesAsExtra(properties), ret;
    }
    var CfnMacro = class extends cdk.CfnResource {
      constructor(scope, id, props) {
        super(scope, id, { type: CfnMacro.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnMacroProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnMacro), error;
        }
        cdk.requireProperty(props, "functionName", this), cdk.requireProperty(props, "name", this), this.functionName = props.functionName, this.name = props.name, this.description = props.description, this.logGroupName = props.logGroupName, this.logRoleArn = props.logRoleArn;
      }
      static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties), propsResult = CfnMacroPropsFromCloudFormation(resourceProperties), ret = new CfnMacro(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties))
          ret.addPropertyOverride(propKey, propVal);
        return options.parser.handleAttributes(ret, resourceAttributes, id), ret;
      }
      inspect(inspector) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.inspect), error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnMacro.CFN_RESOURCE_TYPE_NAME), inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
      }
      get cfnProperties() {
        return { functionName: this.functionName, name: this.name, description: this.description, logGroupName: this.logGroupName, logRoleArn: this.logRoleArn };
      }
      renderProperties(props) {
        return cfnMacroPropsToCloudFormation(props);
      }
    };
    exports.CfnMacro = CfnMacro, _e = JSII_RTTI_SYMBOL_1, CfnMacro[_e] = { fqn: "aws-cdk-lib.CfnMacro", version: "2.50.0" }, CfnMacro.CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::Macro";
    function CfnModuleDefaultVersionPropsValidator(properties) {
      if (!cdk.canInspect(properties))
        return cdk.VALIDATION_SUCCESS;
      const errors = new cdk.ValidationResults();
      return typeof properties != "object" && errors.collect(new cdk.ValidationResult("Expected an object, but received: " + JSON.stringify(properties))), errors.collect(cdk.propertyValidator("arn", cdk.validateString)(properties.arn)), errors.collect(cdk.propertyValidator("moduleName", cdk.validateString)(properties.moduleName)), errors.collect(cdk.propertyValidator("versionId", cdk.validateString)(properties.versionId)), errors.wrap('supplied properties not correct for "CfnModuleDefaultVersionProps"');
    }
    function cfnModuleDefaultVersionPropsToCloudFormation(properties) {
      return cdk.canInspect(properties) ? (CfnModuleDefaultVersionPropsValidator(properties).assertSuccess(), { Arn: cdk.stringToCloudFormation(properties.arn), ModuleName: cdk.stringToCloudFormation(properties.moduleName), VersionId: cdk.stringToCloudFormation(properties.versionId) }) : properties;
    }
    function CfnModuleDefaultVersionPropsFromCloudFormation(properties) {
      if (properties = properties ?? {}, typeof properties != "object")
        return new cfn_parse.FromCloudFormationResult(properties);
      const ret = new cfn_parse.FromCloudFormationPropertyObject();
      return ret.addPropertyResult("arn", "Arn", properties.Arn != null ? cfn_parse.FromCloudFormation.getString(properties.Arn) : void 0), ret.addPropertyResult("moduleName", "ModuleName", properties.ModuleName != null ? cfn_parse.FromCloudFormation.getString(properties.ModuleName) : void 0), ret.addPropertyResult("versionId", "VersionId", properties.VersionId != null ? cfn_parse.FromCloudFormation.getString(properties.VersionId) : void 0), ret.addUnrecognizedPropertiesAsExtra(properties), ret;
    }
    var CfnModuleDefaultVersion = class extends cdk.CfnResource {
      constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnModuleDefaultVersion.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnModuleDefaultVersionProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnModuleDefaultVersion), error;
        }
        this.arn = props.arn, this.moduleName = props.moduleName, this.versionId = props.versionId;
      }
      static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties), propsResult = CfnModuleDefaultVersionPropsFromCloudFormation(resourceProperties), ret = new CfnModuleDefaultVersion(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties))
          ret.addPropertyOverride(propKey, propVal);
        return options.parser.handleAttributes(ret, resourceAttributes, id), ret;
      }
      inspect(inspector) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.inspect), error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnModuleDefaultVersion.CFN_RESOURCE_TYPE_NAME), inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
      }
      get cfnProperties() {
        return { arn: this.arn, moduleName: this.moduleName, versionId: this.versionId };
      }
      renderProperties(props) {
        return cfnModuleDefaultVersionPropsToCloudFormation(props);
      }
    };
    exports.CfnModuleDefaultVersion = CfnModuleDefaultVersion, _f = JSII_RTTI_SYMBOL_1, CfnModuleDefaultVersion[_f] = { fqn: "aws-cdk-lib.CfnModuleDefaultVersion", version: "2.50.0" }, CfnModuleDefaultVersion.CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::ModuleDefaultVersion";
    function CfnModuleVersionPropsValidator(properties) {
      if (!cdk.canInspect(properties))
        return cdk.VALIDATION_SUCCESS;
      const errors = new cdk.ValidationResults();
      return typeof properties != "object" && errors.collect(new cdk.ValidationResult("Expected an object, but received: " + JSON.stringify(properties))), errors.collect(cdk.propertyValidator("moduleName", cdk.requiredValidator)(properties.moduleName)), errors.collect(cdk.propertyValidator("moduleName", cdk.validateString)(properties.moduleName)), errors.collect(cdk.propertyValidator("modulePackage", cdk.requiredValidator)(properties.modulePackage)), errors.collect(cdk.propertyValidator("modulePackage", cdk.validateString)(properties.modulePackage)), errors.wrap('supplied properties not correct for "CfnModuleVersionProps"');
    }
    function cfnModuleVersionPropsToCloudFormation(properties) {
      return cdk.canInspect(properties) ? (CfnModuleVersionPropsValidator(properties).assertSuccess(), { ModuleName: cdk.stringToCloudFormation(properties.moduleName), ModulePackage: cdk.stringToCloudFormation(properties.modulePackage) }) : properties;
    }
    function CfnModuleVersionPropsFromCloudFormation(properties) {
      if (properties = properties ?? {}, typeof properties != "object")
        return new cfn_parse.FromCloudFormationResult(properties);
      const ret = new cfn_parse.FromCloudFormationPropertyObject();
      return ret.addPropertyResult("moduleName", "ModuleName", cfn_parse.FromCloudFormation.getString(properties.ModuleName)), ret.addPropertyResult("modulePackage", "ModulePackage", cfn_parse.FromCloudFormation.getString(properties.ModulePackage)), ret.addUnrecognizedPropertiesAsExtra(properties), ret;
    }
    var CfnModuleVersion = class extends cdk.CfnResource {
      constructor(scope, id, props) {
        super(scope, id, { type: CfnModuleVersion.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnModuleVersionProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnModuleVersion), error;
        }
        cdk.requireProperty(props, "moduleName", this), cdk.requireProperty(props, "modulePackage", this), this.attrArn = cdk.Token.asString(this.getAtt("Arn")), this.attrDescription = cdk.Token.asString(this.getAtt("Description")), this.attrDocumentationUrl = cdk.Token.asString(this.getAtt("DocumentationUrl")), this.attrIsDefaultVersion = this.getAtt("IsDefaultVersion"), this.attrSchema = cdk.Token.asString(this.getAtt("Schema")), this.attrTimeCreated = cdk.Token.asString(this.getAtt("TimeCreated")), this.attrVersionId = cdk.Token.asString(this.getAtt("VersionId")), this.attrVisibility = cdk.Token.asString(this.getAtt("Visibility")), this.moduleName = props.moduleName, this.modulePackage = props.modulePackage;
      }
      static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties), propsResult = CfnModuleVersionPropsFromCloudFormation(resourceProperties), ret = new CfnModuleVersion(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties))
          ret.addPropertyOverride(propKey, propVal);
        return options.parser.handleAttributes(ret, resourceAttributes, id), ret;
      }
      inspect(inspector) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.inspect), error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnModuleVersion.CFN_RESOURCE_TYPE_NAME), inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
      }
      get cfnProperties() {
        return { moduleName: this.moduleName, modulePackage: this.modulePackage };
      }
      renderProperties(props) {
        return cfnModuleVersionPropsToCloudFormation(props);
      }
    };
    exports.CfnModuleVersion = CfnModuleVersion, _g = JSII_RTTI_SYMBOL_1, CfnModuleVersion[_g] = { fqn: "aws-cdk-lib.CfnModuleVersion", version: "2.50.0" }, CfnModuleVersion.CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::ModuleVersion";
    function CfnPublicTypeVersionPropsValidator(properties) {
      if (!cdk.canInspect(properties))
        return cdk.VALIDATION_SUCCESS;
      const errors = new cdk.ValidationResults();
      return typeof properties != "object" && errors.collect(new cdk.ValidationResult("Expected an object, but received: " + JSON.stringify(properties))), errors.collect(cdk.propertyValidator("arn", cdk.validateString)(properties.arn)), errors.collect(cdk.propertyValidator("logDeliveryBucket", cdk.validateString)(properties.logDeliveryBucket)), errors.collect(cdk.propertyValidator("publicVersionNumber", cdk.validateString)(properties.publicVersionNumber)), errors.collect(cdk.propertyValidator("type", cdk.validateString)(properties.type)), errors.collect(cdk.propertyValidator("typeName", cdk.validateString)(properties.typeName)), errors.wrap('supplied properties not correct for "CfnPublicTypeVersionProps"');
    }
    function cfnPublicTypeVersionPropsToCloudFormation(properties) {
      return cdk.canInspect(properties) ? (CfnPublicTypeVersionPropsValidator(properties).assertSuccess(), { Arn: cdk.stringToCloudFormation(properties.arn), LogDeliveryBucket: cdk.stringToCloudFormation(properties.logDeliveryBucket), PublicVersionNumber: cdk.stringToCloudFormation(properties.publicVersionNumber), Type: cdk.stringToCloudFormation(properties.type), TypeName: cdk.stringToCloudFormation(properties.typeName) }) : properties;
    }
    function CfnPublicTypeVersionPropsFromCloudFormation(properties) {
      if (properties = properties ?? {}, typeof properties != "object")
        return new cfn_parse.FromCloudFormationResult(properties);
      const ret = new cfn_parse.FromCloudFormationPropertyObject();
      return ret.addPropertyResult("arn", "Arn", properties.Arn != null ? cfn_parse.FromCloudFormation.getString(properties.Arn) : void 0), ret.addPropertyResult("logDeliveryBucket", "LogDeliveryBucket", properties.LogDeliveryBucket != null ? cfn_parse.FromCloudFormation.getString(properties.LogDeliveryBucket) : void 0), ret.addPropertyResult("publicVersionNumber", "PublicVersionNumber", properties.PublicVersionNumber != null ? cfn_parse.FromCloudFormation.getString(properties.PublicVersionNumber) : void 0), ret.addPropertyResult("type", "Type", properties.Type != null ? cfn_parse.FromCloudFormation.getString(properties.Type) : void 0), ret.addPropertyResult("typeName", "TypeName", properties.TypeName != null ? cfn_parse.FromCloudFormation.getString(properties.TypeName) : void 0), ret.addUnrecognizedPropertiesAsExtra(properties), ret;
    }
    var CfnPublicTypeVersion = class extends cdk.CfnResource {
      constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnPublicTypeVersion.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnPublicTypeVersionProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnPublicTypeVersion), error;
        }
        this.attrPublicTypeArn = cdk.Token.asString(this.getAtt("PublicTypeArn")), this.attrPublisherId = cdk.Token.asString(this.getAtt("PublisherId")), this.attrTypeVersionArn = cdk.Token.asString(this.getAtt("TypeVersionArn")), this.arn = props.arn, this.logDeliveryBucket = props.logDeliveryBucket, this.publicVersionNumber = props.publicVersionNumber, this.type = props.type, this.typeName = props.typeName;
      }
      static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties), propsResult = CfnPublicTypeVersionPropsFromCloudFormation(resourceProperties), ret = new CfnPublicTypeVersion(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties))
          ret.addPropertyOverride(propKey, propVal);
        return options.parser.handleAttributes(ret, resourceAttributes, id), ret;
      }
      inspect(inspector) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.inspect), error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPublicTypeVersion.CFN_RESOURCE_TYPE_NAME), inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
      }
      get cfnProperties() {
        return { arn: this.arn, logDeliveryBucket: this.logDeliveryBucket, publicVersionNumber: this.publicVersionNumber, type: this.type, typeName: this.typeName };
      }
      renderProperties(props) {
        return cfnPublicTypeVersionPropsToCloudFormation(props);
      }
    };
    exports.CfnPublicTypeVersion = CfnPublicTypeVersion, _h = JSII_RTTI_SYMBOL_1, CfnPublicTypeVersion[_h] = { fqn: "aws-cdk-lib.CfnPublicTypeVersion", version: "2.50.0" }, CfnPublicTypeVersion.CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::PublicTypeVersion";
    function CfnPublisherPropsValidator(properties) {
      if (!cdk.canInspect(properties))
        return cdk.VALIDATION_SUCCESS;
      const errors = new cdk.ValidationResults();
      return typeof properties != "object" && errors.collect(new cdk.ValidationResult("Expected an object, but received: " + JSON.stringify(properties))), errors.collect(cdk.propertyValidator("acceptTermsAndConditions", cdk.requiredValidator)(properties.acceptTermsAndConditions)), errors.collect(cdk.propertyValidator("acceptTermsAndConditions", cdk.validateBoolean)(properties.acceptTermsAndConditions)), errors.collect(cdk.propertyValidator("connectionArn", cdk.validateString)(properties.connectionArn)), errors.wrap('supplied properties not correct for "CfnPublisherProps"');
    }
    function cfnPublisherPropsToCloudFormation(properties) {
      return cdk.canInspect(properties) ? (CfnPublisherPropsValidator(properties).assertSuccess(), { AcceptTermsAndConditions: cdk.booleanToCloudFormation(properties.acceptTermsAndConditions), ConnectionArn: cdk.stringToCloudFormation(properties.connectionArn) }) : properties;
    }
    function CfnPublisherPropsFromCloudFormation(properties) {
      if (properties = properties ?? {}, typeof properties != "object")
        return new cfn_parse.FromCloudFormationResult(properties);
      const ret = new cfn_parse.FromCloudFormationPropertyObject();
      return ret.addPropertyResult("acceptTermsAndConditions", "AcceptTermsAndConditions", cfn_parse.FromCloudFormation.getBoolean(properties.AcceptTermsAndConditions)), ret.addPropertyResult("connectionArn", "ConnectionArn", properties.ConnectionArn != null ? cfn_parse.FromCloudFormation.getString(properties.ConnectionArn) : void 0), ret.addUnrecognizedPropertiesAsExtra(properties), ret;
    }
    var CfnPublisher = class extends cdk.CfnResource {
      constructor(scope, id, props) {
        super(scope, id, { type: CfnPublisher.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnPublisherProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnPublisher), error;
        }
        cdk.requireProperty(props, "acceptTermsAndConditions", this), this.attrIdentityProvider = cdk.Token.asString(this.getAtt("IdentityProvider")), this.attrPublisherId = cdk.Token.asString(this.getAtt("PublisherId")), this.attrPublisherProfile = cdk.Token.asString(this.getAtt("PublisherProfile")), this.attrPublisherStatus = cdk.Token.asString(this.getAtt("PublisherStatus")), this.acceptTermsAndConditions = props.acceptTermsAndConditions, this.connectionArn = props.connectionArn;
      }
      static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties), propsResult = CfnPublisherPropsFromCloudFormation(resourceProperties), ret = new CfnPublisher(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties))
          ret.addPropertyOverride(propKey, propVal);
        return options.parser.handleAttributes(ret, resourceAttributes, id), ret;
      }
      inspect(inspector) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.inspect), error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPublisher.CFN_RESOURCE_TYPE_NAME), inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
      }
      get cfnProperties() {
        return { acceptTermsAndConditions: this.acceptTermsAndConditions, connectionArn: this.connectionArn };
      }
      renderProperties(props) {
        return cfnPublisherPropsToCloudFormation(props);
      }
    };
    exports.CfnPublisher = CfnPublisher, _j = JSII_RTTI_SYMBOL_1, CfnPublisher[_j] = { fqn: "aws-cdk-lib.CfnPublisher", version: "2.50.0" }, CfnPublisher.CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::Publisher";
    function CfnResourceDefaultVersionPropsValidator(properties) {
      if (!cdk.canInspect(properties))
        return cdk.VALIDATION_SUCCESS;
      const errors = new cdk.ValidationResults();
      return typeof properties != "object" && errors.collect(new cdk.ValidationResult("Expected an object, but received: " + JSON.stringify(properties))), errors.collect(cdk.propertyValidator("typeName", cdk.validateString)(properties.typeName)), errors.collect(cdk.propertyValidator("typeVersionArn", cdk.validateString)(properties.typeVersionArn)), errors.collect(cdk.propertyValidator("versionId", cdk.validateString)(properties.versionId)), errors.wrap('supplied properties not correct for "CfnResourceDefaultVersionProps"');
    }
    function cfnResourceDefaultVersionPropsToCloudFormation(properties) {
      return cdk.canInspect(properties) ? (CfnResourceDefaultVersionPropsValidator(properties).assertSuccess(), { TypeName: cdk.stringToCloudFormation(properties.typeName), TypeVersionArn: cdk.stringToCloudFormation(properties.typeVersionArn), VersionId: cdk.stringToCloudFormation(properties.versionId) }) : properties;
    }
    function CfnResourceDefaultVersionPropsFromCloudFormation(properties) {
      if (properties = properties ?? {}, typeof properties != "object")
        return new cfn_parse.FromCloudFormationResult(properties);
      const ret = new cfn_parse.FromCloudFormationPropertyObject();
      return ret.addPropertyResult("typeName", "TypeName", properties.TypeName != null ? cfn_parse.FromCloudFormation.getString(properties.TypeName) : void 0), ret.addPropertyResult("typeVersionArn", "TypeVersionArn", properties.TypeVersionArn != null ? cfn_parse.FromCloudFormation.getString(properties.TypeVersionArn) : void 0), ret.addPropertyResult("versionId", "VersionId", properties.VersionId != null ? cfn_parse.FromCloudFormation.getString(properties.VersionId) : void 0), ret.addUnrecognizedPropertiesAsExtra(properties), ret;
    }
    var CfnResourceDefaultVersion = class extends cdk.CfnResource {
      constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnResourceDefaultVersion.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnResourceDefaultVersionProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnResourceDefaultVersion), error;
        }
        this.attrArn = cdk.Token.asString(this.getAtt("Arn")), this.typeName = props.typeName, this.typeVersionArn = props.typeVersionArn, this.versionId = props.versionId;
      }
      static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties), propsResult = CfnResourceDefaultVersionPropsFromCloudFormation(resourceProperties), ret = new CfnResourceDefaultVersion(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties))
          ret.addPropertyOverride(propKey, propVal);
        return options.parser.handleAttributes(ret, resourceAttributes, id), ret;
      }
      inspect(inspector) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.inspect), error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnResourceDefaultVersion.CFN_RESOURCE_TYPE_NAME), inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
      }
      get cfnProperties() {
        return { typeName: this.typeName, typeVersionArn: this.typeVersionArn, versionId: this.versionId };
      }
      renderProperties(props) {
        return cfnResourceDefaultVersionPropsToCloudFormation(props);
      }
    };
    exports.CfnResourceDefaultVersion = CfnResourceDefaultVersion, _k = JSII_RTTI_SYMBOL_1, CfnResourceDefaultVersion[_k] = { fqn: "aws-cdk-lib.CfnResourceDefaultVersion", version: "2.50.0" }, CfnResourceDefaultVersion.CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::ResourceDefaultVersion";
    function CfnResourceVersionPropsValidator(properties) {
      if (!cdk.canInspect(properties))
        return cdk.VALIDATION_SUCCESS;
      const errors = new cdk.ValidationResults();
      return typeof properties != "object" && errors.collect(new cdk.ValidationResult("Expected an object, but received: " + JSON.stringify(properties))), errors.collect(cdk.propertyValidator("executionRoleArn", cdk.validateString)(properties.executionRoleArn)), errors.collect(cdk.propertyValidator("loggingConfig", CfnResourceVersion_LoggingConfigPropertyValidator)(properties.loggingConfig)), errors.collect(cdk.propertyValidator("schemaHandlerPackage", cdk.requiredValidator)(properties.schemaHandlerPackage)), errors.collect(cdk.propertyValidator("schemaHandlerPackage", cdk.validateString)(properties.schemaHandlerPackage)), errors.collect(cdk.propertyValidator("typeName", cdk.requiredValidator)(properties.typeName)), errors.collect(cdk.propertyValidator("typeName", cdk.validateString)(properties.typeName)), errors.wrap('supplied properties not correct for "CfnResourceVersionProps"');
    }
    function cfnResourceVersionPropsToCloudFormation(properties) {
      return cdk.canInspect(properties) ? (CfnResourceVersionPropsValidator(properties).assertSuccess(), { SchemaHandlerPackage: cdk.stringToCloudFormation(properties.schemaHandlerPackage), TypeName: cdk.stringToCloudFormation(properties.typeName), ExecutionRoleArn: cdk.stringToCloudFormation(properties.executionRoleArn), LoggingConfig: cfnResourceVersionLoggingConfigPropertyToCloudFormation(properties.loggingConfig) }) : properties;
    }
    function CfnResourceVersionPropsFromCloudFormation(properties) {
      if (properties = properties ?? {}, typeof properties != "object")
        return new cfn_parse.FromCloudFormationResult(properties);
      const ret = new cfn_parse.FromCloudFormationPropertyObject();
      return ret.addPropertyResult("schemaHandlerPackage", "SchemaHandlerPackage", cfn_parse.FromCloudFormation.getString(properties.SchemaHandlerPackage)), ret.addPropertyResult("typeName", "TypeName", cfn_parse.FromCloudFormation.getString(properties.TypeName)), ret.addPropertyResult("executionRoleArn", "ExecutionRoleArn", properties.ExecutionRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ExecutionRoleArn) : void 0), ret.addPropertyResult("loggingConfig", "LoggingConfig", properties.LoggingConfig != null ? CfnResourceVersionLoggingConfigPropertyFromCloudFormation(properties.LoggingConfig) : void 0), ret.addUnrecognizedPropertiesAsExtra(properties), ret;
    }
    var CfnResourceVersion = class extends cdk.CfnResource {
      constructor(scope, id, props) {
        super(scope, id, { type: CfnResourceVersion.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnResourceVersionProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnResourceVersion), error;
        }
        cdk.requireProperty(props, "schemaHandlerPackage", this), cdk.requireProperty(props, "typeName", this), this.attrArn = cdk.Token.asString(this.getAtt("Arn")), this.attrIsDefaultVersion = this.getAtt("IsDefaultVersion"), this.attrProvisioningType = cdk.Token.asString(this.getAtt("ProvisioningType")), this.attrTypeArn = cdk.Token.asString(this.getAtt("TypeArn")), this.attrVersionId = cdk.Token.asString(this.getAtt("VersionId")), this.attrVisibility = cdk.Token.asString(this.getAtt("Visibility")), this.schemaHandlerPackage = props.schemaHandlerPackage, this.typeName = props.typeName, this.executionRoleArn = props.executionRoleArn, this.loggingConfig = props.loggingConfig;
      }
      static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties), propsResult = CfnResourceVersionPropsFromCloudFormation(resourceProperties), ret = new CfnResourceVersion(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties))
          ret.addPropertyOverride(propKey, propVal);
        return options.parser.handleAttributes(ret, resourceAttributes, id), ret;
      }
      inspect(inspector) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.inspect), error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnResourceVersion.CFN_RESOURCE_TYPE_NAME), inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
      }
      get cfnProperties() {
        return { schemaHandlerPackage: this.schemaHandlerPackage, typeName: this.typeName, executionRoleArn: this.executionRoleArn, loggingConfig: this.loggingConfig };
      }
      renderProperties(props) {
        return cfnResourceVersionPropsToCloudFormation(props);
      }
    };
    exports.CfnResourceVersion = CfnResourceVersion, _l = JSII_RTTI_SYMBOL_1, CfnResourceVersion[_l] = { fqn: "aws-cdk-lib.CfnResourceVersion", version: "2.50.0" }, CfnResourceVersion.CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::ResourceVersion";
    function CfnResourceVersion_LoggingConfigPropertyValidator(properties) {
      if (!cdk.canInspect(properties))
        return cdk.VALIDATION_SUCCESS;
      const errors = new cdk.ValidationResults();
      return typeof properties != "object" && errors.collect(new cdk.ValidationResult("Expected an object, but received: " + JSON.stringify(properties))), errors.collect(cdk.propertyValidator("logGroupName", cdk.validateString)(properties.logGroupName)), errors.collect(cdk.propertyValidator("logRoleArn", cdk.validateString)(properties.logRoleArn)), errors.wrap('supplied properties not correct for "LoggingConfigProperty"');
    }
    function cfnResourceVersionLoggingConfigPropertyToCloudFormation(properties) {
      return cdk.canInspect(properties) ? (CfnResourceVersion_LoggingConfigPropertyValidator(properties).assertSuccess(), { LogGroupName: cdk.stringToCloudFormation(properties.logGroupName), LogRoleArn: cdk.stringToCloudFormation(properties.logRoleArn) }) : properties;
    }
    function CfnResourceVersionLoggingConfigPropertyFromCloudFormation(properties) {
      if (cdk.isResolvableObject(properties))
        return new cfn_parse.FromCloudFormationResult(properties);
      if (properties = properties ?? {}, typeof properties != "object")
        return new cfn_parse.FromCloudFormationResult(properties);
      const ret = new cfn_parse.FromCloudFormationPropertyObject();
      return ret.addPropertyResult("logGroupName", "LogGroupName", properties.LogGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.LogGroupName) : void 0), ret.addPropertyResult("logRoleArn", "LogRoleArn", properties.LogRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.LogRoleArn) : void 0), ret.addUnrecognizedPropertiesAsExtra(properties), ret;
    }
    function CfnStackPropsValidator(properties) {
      if (!cdk.canInspect(properties))
        return cdk.VALIDATION_SUCCESS;
      const errors = new cdk.ValidationResults();
      return typeof properties != "object" && errors.collect(new cdk.ValidationResult("Expected an object, but received: " + JSON.stringify(properties))), errors.collect(cdk.propertyValidator("notificationArns", cdk.listValidator(cdk.validateString))(properties.notificationArns)), errors.collect(cdk.propertyValidator("parameters", cdk.hashValidator(cdk.validateString))(properties.parameters)), errors.collect(cdk.propertyValidator("tags", cdk.listValidator(cdk.validateCfnTag))(properties.tags)), errors.collect(cdk.propertyValidator("templateUrl", cdk.requiredValidator)(properties.templateUrl)), errors.collect(cdk.propertyValidator("templateUrl", cdk.validateString)(properties.templateUrl)), errors.collect(cdk.propertyValidator("timeoutInMinutes", cdk.validateNumber)(properties.timeoutInMinutes)), errors.wrap('supplied properties not correct for "CfnStackProps"');
    }
    function cfnStackPropsToCloudFormation(properties) {
      return cdk.canInspect(properties) ? (CfnStackPropsValidator(properties).assertSuccess(), { TemplateURL: cdk.stringToCloudFormation(properties.templateUrl), NotificationARNs: cdk.listMapper(cdk.stringToCloudFormation)(properties.notificationArns), Parameters: cdk.hashMapper(cdk.stringToCloudFormation)(properties.parameters), Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags), TimeoutInMinutes: cdk.numberToCloudFormation(properties.timeoutInMinutes) }) : properties;
    }
    function CfnStackPropsFromCloudFormation(properties) {
      if (properties = properties ?? {}, typeof properties != "object")
        return new cfn_parse.FromCloudFormationResult(properties);
      const ret = new cfn_parse.FromCloudFormationPropertyObject();
      return ret.addPropertyResult("templateUrl", "TemplateURL", cfn_parse.FromCloudFormation.getString(properties.TemplateURL)), ret.addPropertyResult("notificationArns", "NotificationARNs", properties.NotificationARNs != null ? cfn_parse.FromCloudFormation.getStringArray(properties.NotificationARNs) : void 0), ret.addPropertyResult("parameters", "Parameters", properties.Parameters != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Parameters) : void 0), ret.addPropertyResult("tags", "Tags", properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : void 0), ret.addPropertyResult("timeoutInMinutes", "TimeoutInMinutes", properties.TimeoutInMinutes != null ? cfn_parse.FromCloudFormation.getNumber(properties.TimeoutInMinutes) : void 0), ret.addUnrecognizedPropertiesAsExtra(properties), ret;
    }
    var CfnStack = class extends cdk.CfnResource {
      constructor(scope, id, props) {
        super(scope, id, { type: CfnStack.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_CfnStackProps(props);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, CfnStack), error;
        }
        cdk.requireProperty(props, "templateUrl", this), this.templateUrl = props.templateUrl, this.notificationArns = props.notificationArns, this.parameters = props.parameters, this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::CloudFormation::Stack", props.tags, { tagPropertyName: "tags" }), this.timeoutInMinutes = props.timeoutInMinutes, this.node.scope && cdk.Resource.isResource(this.node.scope) && this.node.addValidation({ validate: () => this.cfnOptions.deletionPolicy === void 0 ? ["'AWS::CloudFormation::Stack' is a stateful resource type, and you must specify a Removal Policy for it. Call 'resource.applyRemovalPolicy()'."] : [] });
      }
      static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties), propsResult = CfnStackPropsFromCloudFormation(resourceProperties), ret = new CfnStack(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties))
          ret.addPropertyOverride(propKey, propVal);
        return options.parser.handleAttributes(ret, resourceAttributes, id), ret;
      }
      inspect(inspector) {
        try {
          jsiiDeprecationWarnings.aws_cdk_lib_TreeInspector(inspector);
        } catch (error) {
          throw process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError" && Error.captureStackTrace(error, this.inspect), error;
        }
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnStack.CFN_RESOURCE_TYPE_NAME), inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
      }
      get cfnProperties() {
        return { templateUrl: this.templateUrl, notificationArns: this.notificationArns, parameters: this.parameters, tags: this.tags.renderTags(), timeoutInMinutes: this.timeoutInMinutes };
      }
      renderProperties(props) {
        return cfnStackPropsToCloudFormation(props);
      }
    };
    exports.CfnStack = CfnStack, _m = JSII_RTTI_SYMBOL_1, CfnStack[_m] = { fqn: "aws-cdk-lib.CfnStack", version: "2.50.0" }, CfnStack.CFN_RESOURCE_TYPE_NAME = "AWS::CloudFormation::Stack";
    function CfnStackSetPropsValidator(properties) {
      if (!cdk.canInspect(properties))
        return cdk.VALIDATION_SUCCESS;
      const errors = new cdk.ValidationResults();
      return typeof properties != "object" && errors.collect(new cdk.ValidationResult("Expected an object, but received: " + JSON.stringify(properties))), errors.collect(cdk.propertyValidator("administrationRoleArn", cdk.validateString)(properties.administrationRoleArn)), errors.collect(cdk.propertyValidator("autoDeployment", CfnStackSet_AutoDeploymentPropertyValidator)(properties.autoDeployment)), errors.collect(cdk.propertyValidator("callAs", cdk.validateString)(properties.callAs)), errors.collect(cdk.propertyValidator("capabilities", cdk.listValidator(cdk.validateString))(properties.capabilities)), errors.collect(cdk.propertyValidator("description", cdk.validateString)(properties.description)), errors.collect(cdk.propertyValidator("executionRoleName", cdk.validateString)(properties.executionRoleName)), errors.collect(cdk.propertyValidator("managedExecution", cdk.validateObject)(properties.managedExecution)), errors.collect(cdk.propertyValidator("operationPreferences", CfnStackSet_OperationPreferencesPropertyValidator)(properties.operationPreferences)), errors.collect(cdk.propertyValidator("parameters", cdk.listValidator(CfnStackSet_ParameterPropertyValidator))(properties.parameters)), errors.collect(cdk.propertyValidator("permissionModel", cdk.requiredValidator)(properties.permissionModel)), errors.collect(cdk.propertyValidator("permissionModel", cdk.validateString)(properties.permissionModel)), errors.collect(cdk.propertyValidator("stackInstancesGroup", cdk.listValidator(CfnStackSet_StackInstancesPropertyValidator))(properties.stackInstancesGroup)), errors.collect(cdk.propertyValidator("stackSetName", cdk.requiredValidator)(properties.stackSetName)), errors.collect(cdk.propertyValidator("stackSetName", cdk.validateString)(properties.stackSetName)), errors.collect(cdk.propertyValidator("tags", cdk.listValidator(cdk.validateCfnTag))(properties.tags)), errors.collect(cdk.propertyValidator("templateBody", cdk.validateString)(properties.templateBody)), errors.collect(cdk.propertyValidator("templateUrl", cdk.validateString)(properties.templateUrl)), errors.wrap('supplied properties not correct for "CfnStackSetProps"');
    }
    function cfnStackSetPropsToCloudFormation(properties) {
      return cdk.canInspect(properties) ? (CfnStackSetPropsValidator(properties).assertSuccess(), { PermissionModel: cdk.stringToCloudFormation(properties.permissionModel), StackSetName: cdk.stringToCloudFormation(properties.stackSetName), AdministrationRoleARN: cdk.stringToCloudFormation(properties.administrationRoleArn), AutoDeployment: cfnStackSetAutoDeploymentPropertyToCloudFormation(properties.autoDeployment), CallAs: cdk.stringToCloudFormation(properties.callAs), Capabilities: cdk.listMapper(cdk.stringToCloudFormation)(properties.capabilities), Description: cdk.stringToCloudFormation(properties.description), ExecutionRoleName: cdk.stringToCloudFormation(properties.executionRoleName), ManagedExecution: cdk.objectToCloudFormation(properties.managedExecution), OperationPreferences: cfnStackSetOperationPreferencesPropertyToCloudFormation(properties.operationPreferences), Parameters: cdk.listMapper(cfnStackSetParameterPropertyToCloudFormation)(properties.parameters), Stac