/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.mw.barcode.complexbarcode;

import com.aspose.barcode.BarCodeImageFormat;
import com.aspose.mw.barcode.MwBarcodeException;
import com.aspose.mw.barcode.MwJavaWrapper;
import com.aspose.mw.barcode.complexbarcode.MwSwissQRCodetext;
import com.aspose.mw.barcode.generation.MwBaseGenerationParameters;
import com.aspose.python.barcode.internal.co.d;
import com.aspose.python.barcode.internal.co.f;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;

public class MwComplexBarcodeGenerator
extends MwJavaWrapper<d> {
    private MwSwissQRCodetext a;
    private MwBaseGenerationParameters b;

    public MwBaseGenerationParameters getParameters() {
        return this.b;
    }

    public MwComplexBarcodeGenerator(MwSwissQRCodetext complexCodetext) throws MwBarcodeException {
        super(new d((f)complexCodetext.getNativeObject()));
    }

    public String generateBarCodeImage(String formatName) throws MwBarcodeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (formatName == null) {
                formatName = "PNG";
            }
            ((d)this.getNativeObject()).a(byteArrayOutputStream, BarCodeImageFormat.valueOf(formatName));
            return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Cannot convert image to Base64", exception.getMessage());
        }
    }

    private static String a(RenderedImage renderedImage, String string) throws MwBarcodeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write(renderedImage, string, byteArrayOutputStream);
            return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Cannot convert image to Base64", exception.getMessage());
        }
    }

    public void save(String filename, String formatString) throws Exception {
        BarCodeImageFormat barCodeImageFormat = BarCodeImageFormat.PNG;
        try {
            int n2 = Integer.parseInt(formatString);
            for (BarCodeImageFormat barCodeImageFormat2 : BarCodeImageFormat.values()) {
                if (barCodeImageFormat2.getValue() != n2) continue;
                barCodeImageFormat = barCodeImageFormat2;
                break;
            }
            ((d)this.nativeObject).a(filename, barCodeImageFormat);
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Waiting for Integer but got " + formatString, exception.getMessage());
        }
    }

    public void save(String filename) throws IOException, MwBarcodeException {
        try {
            ((d)this.nativeObject).a(filename);
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    @Override
    protected void init() throws MwBarcodeException {
        this.b = new MwBaseGenerationParameters(((d)this.getNativeObject()).a());
    }
}

