/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.mw.barcode.generation;

import com.aspose.barcode.BarCodeImageFormat;
import com.aspose.barcode.BaseEncodeType;
import com.aspose.barcode.EncodeTypes;
import com.aspose.barcode.generation.BarcodeGenerator;
import com.aspose.mw.barcode.MwBarcodeException;
import com.aspose.mw.barcode.MwJavaWrapper;
import com.aspose.mw.barcode.generation.MwBaseGenerationParameters;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import javax.imageio.ImageIO;

public class MwBarcodeGenerator
extends MwJavaWrapper<BarcodeGenerator> {
    private MwBaseGenerationParameters a;

    public MwBarcodeGenerator(String encodeType, String codeText) throws MwBarcodeException {
        super(new BarcodeGenerator(MwBarcodeGenerator.b(encodeType)));
        if (codeText != null) {
            ((BarcodeGenerator)this.getNativeObject()).setCodeText(codeText);
        }
    }

    private BarcodeGenerator a(String string) throws MwBarcodeException {
        try {
            return new BarcodeGenerator(MwBarcodeGenerator.b(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    @Override
    protected void init() throws MwBarcodeException {
        this.a = new MwBaseGenerationParameters(((BarcodeGenerator)this.nativeObject).getParameters());
    }

    public MwBaseGenerationParameters getParameters() throws MwBarcodeException {
        try {
            return this.a;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public String generateBarCodeImage(String formatName) throws MwBarcodeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (formatName == null) {
                formatName = "PNG";
            }
            ((BarcodeGenerator)this.getNativeObject()).save(byteArrayOutputStream, BarCodeImageFormat.valueOf(formatName));
            return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Cannot convert image to Base64", exception.getMessage());
        }
    }

    public String getCodeText() throws MwBarcodeException {
        try {
            String string = ((BarcodeGenerator)this.getNativeObject()).getCodeText();
            return string;
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setCodeText(String value) throws MwBarcodeException {
        try {
            ((BarcodeGenerator)this.getNativeObject()).setCodeText(value);
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public short getBarcodeType() throws MwBarcodeException {
        try {
            short s2 = ((BarcodeGenerator)this.getNativeObject()).getBarcodeType().getTypeIndex();
            return s2;
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    public void setBarcodeType(String barcodeTypeString) throws MwBarcodeException {
        try {
            BaseEncodeType baseEncodeType = MwBarcodeGenerator.b(barcodeTypeString);
            ((BarcodeGenerator)this.getNativeObject()).setBarcodeType(baseEncodeType);
        }
        catch (Exception exception) {
            throw new MwBarcodeException(exception.getMessage());
        }
    }

    private static String a(RenderedImage renderedImage, String string) throws MwBarcodeException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (string == null) {
                string = "PNG";
            }
            ImageIO.write(renderedImage, string, byteArrayOutputStream);
            return Base64.getEncoder().encodeToString(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Cannot convert image to Base64", exception.getMessage());
        }
    }

    private static BaseEncodeType b(String string) throws MwBarcodeException {
        try {
            short s2 = Short.parseShort(string.trim());
            for (BaseEncodeType baseEncodeType : EncodeTypes.getAllEncodeTypes()) {
                if (baseEncodeType.getTypeIndex() != s2) continue;
                return baseEncodeType;
            }
        }
        catch (Exception exception) {
            throw new MwBarcodeException("Waiting for short type, but got '" + string + "' of  " + string.getClass());
        }
        return EncodeTypes.NONE;
    }
}

