"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
// From https://github.com/errwischt/stacktrace-parser/blob/master/src/stack-trace-parser.js
const STACK_RE = /^\s*at (?:((?:\[object object\])?[^\\/]+(?: \[as \S+\])?) )?\(?(.*?):(\d+)(?::(\d+))?\)?\s*$/i;
/**
 * Parses the stack trace of an error
 */
function parseStackTrace(error) {
    const err = error || new Error();
    if (!err.stack) {
        return [];
    }
    const lines = err.stack.split('\n');
    const stackTrace = [];
    for (const line of lines) {
        const results = STACK_RE.exec(line);
        if (results) {
            stackTrace.push({
                file: results[2],
                methodName: results[1],
                lineNumber: parseInt(results[3], 10),
                column: parseInt(results[4], 10),
            });
        }
    }
    return stackTrace;
}
exports.parseStackTrace = parseStackTrace;
/**
 * Returns the major version of node installation
 */
function nodeMajorVersion() {
    return parseInt(process.versions.node.split('.')[0], 10);
}
exports.nodeMajorVersion = nodeMajorVersion;
/**
 * Finds closest package.json path
 */
function findPkgPath() {
    let pkgPath;
    for (const path of module.paths) {
        pkgPath = path.replace(/node_modules$/, 'package.json');
        if (fs.existsSync(pkgPath)) {
            break;
        }
    }
    return pkgPath;
}
exports.findPkgPath = findPkgPath;
/**
 * Updates the package.json and returns the original
 */
function updatePkg(pkgPath, data) {
    const original = fs.readFileSync(pkgPath);
    const pkgJson = JSON.parse(original.toString());
    const updated = {
        ...pkgJson,
        ...data,
    };
    fs.writeFileSync(pkgPath, JSON.stringify(updated, null, 2));
    return original;
}
exports.updatePkg = updatePkg;
//# sourceMappingURL=data:application/json;base64,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