# https://github.com/georgezlei/algorithm-training-py
# Author: George Lei

import random

def union_find(vertices, edges):
  unions = [i for i in range(vertices)]

  for a, b in edges:
    while a != unions[a]:
      a = unions[a]
    while b != unions[b]:
      b = unions[b]
    unions[b] = a

  return len([i for i in range(vertices) if i == unions[i]])

algorithms = [('Union Find', union_find)]

test_cases = [
  {
    'name': 'Graph 647 vertices 992 edges',
    'in': [647, [(54, 55), (86, 87), (170, 171), (92, 93), (100, 101), (125, 126), (156, 157), (164, 165), (189, 190), (49, 63), (40, 41), (72, 73), (168, 169), (18, 19), (34, 35), (94, 95), (110, 111), (146, 147), (162, 163), (43, 174), (1, 64), (127, 128), (80, 81), (96, 97), (113, 114), (144, 145), (6, 7), (122, 123), (134, 135), (160, 161), (44, 45), (52, 53), (76, 77), (84, 85), (172, 173), (180, 181), (25, 26), (49, 98), (27, 28), (35, 36), (155, 156), (163, 164), (154, 187), (4, 5), (29, 30), (37, 38), (80, 130), (105, 106), (169, 170), (14, 15), (114, 115), (142, 143), (13, 147), (55, 56), (107, 108), (115, 116), (183, 184), (0, 1), (17, 18), (33, 34), (109, 110), (117, 118), (173, 174), (181, 182), (15, 16), (67, 68), (7, 8), (131, 132), (22, 23), (106, 107), (150, 151), (69, 70), (8, 9), (73, 171), (65, 66), (58, 59), (12, 13), (20, 21), (162, 181), (7, 37), (77, 126), (103, 104), (111, 112), (145, 160), (170, 173), (93, 106), (73, 74), (50, 51), (66, 67), (190, 191), (75, 76), (23, 24), (83, 84), (139, 140), (147, 148), (38, 39), (90, 91), (166, 167), (77, 78), (85, 86), (24, 25), (57, 58), (59, 60), (187, 188), (67, 110), (191, 193), (42, 43), (74, 75), (182, 183), (14, 158), (28, 29), (36, 37), (61, 62), (108, 127), (30, 31), (46, 47), (82, 83), (98, 99), (158, 159), (174, 175), (95, 96), (16, 17), (32, 33), (49, 50), (120, 121), (153, 154), (39, 40), (47, 48), (167, 168), (175, 176), (101, 164), (124, 125), (132, 133), (157, 158), (165, 166), (82, 110), (149, 151), (168, 171), (41, 42), (2, 3), (126, 127), (130, 131), (51, 52), (43, 44), (119, 120), (171, 172), (112, 113), (128, 129), (145, 146), (161, 162), (179, 180), (45, 46), (53, 54), (118, 154), (10, 192), (3, 4), (71, 72), (79, 80), (135, 136), (143, 144), (10, 11), (118, 119), (138, 139), (5, 6), (133, 134), (104, 105), (136, 137), (147, 172), (31, 32), (63, 64), (159, 160), (191, 192), (1, 2), (129, 130), (146, 151), (70, 71), (186, 187), (135, 143), (108, 109), (116, 117), (140, 141), (148, 149), (56, 57), (89, 90), (177, 178), (184, 185), (192, 193), (89, 187), (80, 96), (147, 182), (166, 180), (91, 92), (99, 100), (41, 70), (23, 190), (133, 176), (60, 61), (68, 69), (93, 94), (101, 102), (188, 189), (9, 10), (137, 138), (62, 63), (78, 79), (178, 179), (11, 12), (19, 20), (87, 88), (151, 152), (48, 49), (64, 65), (81, 82), (97, 98), (26, 27), (102, 103), (154, 155), (176, 177), (13, 14), (21, 22), (141, 142), (149, 150), (60, 169), (88, 89), (121, 122), (152, 153), (185, 186), (126, 146), (123, 124), (356, 357), (272, 284), (222, 223), (290, 291), (336, 337), (300, 301), (332, 333), (226, 373), (281, 282), (283, 284), (270, 271), (233, 337), (243, 244), (371, 372), (358, 366), (273, 274), (258, 372), (271, 272), (323, 324), (196, 317), (325, 326), (298, 376), (245, 306), (198, 199), (244, 245), (321, 361), (227, 228), (367, 368), (201, 202), (329, 330), (366, 378), (322, 323), (339, 340), (205, 206), (341, 342), (313, 314), (315, 316), (214, 215), (228, 229), (307, 376), (226, 227), (302, 303), (354, 355), (351, 352), (292, 321), (305, 306), (236, 244), (247, 342), (279, 333), (295, 296), (208, 338), (297, 298), (357, 375), (299, 300), (251, 259), (202, 353), (195, 196), (335, 336), (231, 291), (374, 375), (289, 307), (371, 374), (345, 374), (199, 238), (364, 365), (268, 377), (247, 270), (230, 322), (304, 377), (347, 348), (269, 333), (235, 254), (349, 350), (194, 195), (334, 335), (260, 353), (211, 212), (330, 361), (320, 321), (358, 359), (377, 378), (365, 370), (251, 252), (282, 353), (348, 349), (203, 220), (363, 375), (350, 351), (369, 370), (310, 374), (248, 249), (265, 292), (239, 332), (252, 253), (260, 261), (221, 265), (361, 362), (248, 290), (273, 336), (235, 236), (311, 312), (363, 364), (240, 241), (256, 257), (373, 374), (287, 307), (263, 264), (304, 306), (202, 306), (232, 233), (209, 309), (227, 262), (236, 237), (276, 277), (285, 318), (328, 330), (219, 220), (359, 360), (279, 280), (331, 332), (333, 334), (216, 217), (201, 332), (341, 367), (220, 221), (292, 293), (368, 375), (208, 209), (288, 289), (224, 347), (347, 355), (374, 377), (245, 246), (314, 317), (259, 260), (327, 328), (331, 336), (266, 267), (261, 262), (295, 343), (257, 258), (239, 240), (318, 366), (196, 197), (376, 378), (212, 299), (203, 204), (275, 276), (343, 344), (278, 291), (225, 226), (353, 354), (282, 283), (277, 278), (269, 336), (302, 369), (238, 239), (274, 275), (223, 224), (352, 353), (250, 251), (262, 263), (233, 270), (212, 213), (239, 288), (338, 358), (323, 336), (241, 336), (315, 353), (293, 294), (267, 319), (281, 347), (242, 243), (370, 371), (335, 361), (289, 290), (227, 310), (365, 366), (269, 360), (207, 208), (314, 366), (234, 235), (278, 279), (362, 363), (208, 293), (337, 363), (369, 374), (205, 308), (321, 322), (314, 315), (234, 260), (242, 355), (268, 269), (238, 281), (206, 207), (306, 307), (219, 311), (218, 219), (294, 295), (346, 347), (259, 323), (249, 250), (306, 321), (239, 337), (346, 367), (333, 375), (298, 299), (330, 331), (253, 254), (284, 285), (227, 266), (210, 211), (286, 287), (338, 339), (197, 277), (241, 242), (301, 375), (240, 329), (316, 340), (245, 347), (233, 234), (196, 212), (247, 248), (257, 376), (237, 238), (309, 310), (363, 372), (252, 358), (248, 367), (326, 327), (312, 313), (215, 308), (351, 355), (336, 371), (231, 232), (337, 361), (229, 230), (324, 325), (315, 376), (296, 328), (318, 319), (266, 346), (267, 268), (304, 305), (344, 360), (269, 270), (361, 364), (202, 203), (310, 311), (342, 343), (251, 376), (200, 201), (296, 297), (328, 329), (366, 367), (280, 298), (249, 369), (204, 205), (308, 309), (340, 341), (288, 297), (291, 292), (285, 286), (363, 369), (213, 378), (289, 346), (247, 349), (368, 374), (199, 200), (195, 248), (197, 198), (308, 320), (264, 265), (194, 219), (244, 291), (320, 345), (215, 216), (213, 214), (304, 360), (280, 281), (372, 377), (317, 318), (315, 336), (255, 256), (224, 225), (272, 273), (271, 322), (376, 377), (357, 372), (303, 304), (254, 255), (258, 259), (299, 340), (247, 326), (307, 308), (375, 376), (368, 369), (301, 302), (308, 349), (249, 323), (246, 247), (261, 275), (360, 361), (287, 288), (319, 320), (372, 373), (281, 306), (217, 218), (345, 346), (355, 356), (228, 298), (221, 222), (316, 317), (357, 358), (265, 266), (288, 375), (209, 210), (337, 338), (230, 231), (323, 342), (344, 345), (369, 375), (348, 364), (426, 427), (381, 382), (412, 413), (420, 421), (424, 425), (402, 403), (418, 419), (383, 384), (389, 392), (400, 401), (416, 417), (390, 391), (379, 403), (426, 428), (415, 419), (411, 412), (419, 420), (425, 426), (398, 399), (405, 421), (399, 425), (387, 388), (406, 407), (409, 420), (421, 423), (424, 426), (384, 428), (385, 389), (416, 418), (381, 413), (423, 428), (390, 395), (405, 414), (415, 418), (395, 396), (403, 404), (412, 420), (422, 423), (411, 427), (387, 413), (415, 417), (418, 422), (401, 404), (414, 415), (406, 411), (409, 410), (423, 424), (380, 381), (388, 389), (413, 414), (421, 422), (419, 427), (382, 383), (386, 387), (427, 428), (384, 385), (401, 402), (417, 418), (388, 399), (391, 392), (399, 400), (383, 385), (395, 400), (394, 395), (389, 390), (392, 393), (390, 408), (415, 416), (385, 386), (402, 407), (418, 423), (396, 397), (404, 405), (416, 423), (393, 394), (402, 423), (407, 408), (410, 411), (387, 406), (397, 398), (405, 406), (409, 421), (414, 419), (404, 417), (408, 409), (380, 410), (379, 380), (438, 439), (445, 446), (430, 431), (447, 448), (433, 434), (449, 450), (442, 443), (436, 437), (440, 441), (431, 432), (429, 449), (444, 445), (446, 450), (434, 435), (446, 447), (447, 450), (439, 440), (435, 436), (432, 433), (448, 449), (444, 446), (429, 430), (437, 438), (441, 442), (443, 444), (459, 464), (458, 459), (453, 454), (451, 452), (455, 460), (453, 461), (451, 459), (456, 457), (455, 464), (451, 465), (464, 465), (454, 455), (460, 461), (463, 464), (459, 461), (452, 453), (457, 458), (462, 463), (459, 460), (465, 466), (461, 462), (455, 456), (454, 464), (470, 471), (490, 491), (476, 477), (484, 485), (488, 489), (478, 479), (482, 483), (479, 480), (480, 481), (468, 469), (473, 474), (471, 483), (483, 484), (475, 476), (487, 488), (476, 491), (477, 478), (485, 486), (489, 490), (467, 468), (471, 472), (491, 492), (481, 482), (474, 475), (486, 487), (469, 470), (472, 473), (530, 567), (566, 567), (598, 599), (604, 605), (612, 613), (637, 638), (594, 613), (544, 569), (501, 605), (498, 625), (552, 553), (584, 585), (618, 623), (494, 495), (530, 531), (546, 547), (606, 607), (622, 623), (642, 645), (639, 640), (568, 639), (590, 598), (592, 593), (608, 609), (625, 626), (506, 507), (518, 519), (634, 635), (540, 587), (556, 557), (564, 565), (588, 589), (596, 597), (602, 641), (509, 523), (504, 505), (537, 538), (573, 578), (542, 569), (539, 540), (547, 548), (590, 604), (508, 509), (516, 517), (541, 542), (549, 550), (564, 628), (538, 637), (631, 637), (627, 645), (617, 618), (555, 631), (522, 536), (513, 613), (498, 499), (526, 527), (626, 627), (576, 581), (563, 623), (503, 609), (578, 600), (600, 620), (567, 568), (499, 500), (619, 620), (627, 628), (496, 497), (512, 513), (529, 530), (545, 546), (594, 619), (502, 535), (567, 638), (519, 609), (621, 622), (629, 630), (542, 628), (536, 561), (535, 591), (603, 619), (532, 549), (519, 520), (527, 528), (579, 580), (643, 644), (558, 616), (547, 623), (534, 535), (618, 619), (581, 582), (520, 521), (621, 625), (500, 563), (612, 641), (577, 578), (504, 553), (540, 575), (570, 571), (585, 591), (500, 501), (524, 525), (532, 533), (547, 552), (641, 645), (517, 634), (504, 514), (601, 622), (537, 565), (615, 616), (623, 624), (608, 610), (569, 586), (531, 540), (585, 586), (565, 617), (622, 634), (562, 563), (578, 579), (535, 536), (587, 588), (595, 596), (618, 642), (637, 645), (550, 551), (602, 603), (589, 590), (597, 598), (610, 638), (540, 585), (637, 640), (505, 506), (536, 537), (569, 570), (610, 645), (634, 646), (571, 572), (558, 598), (514, 582), (554, 555), (586, 587), (509, 510), (540, 541), (548, 549), (573, 574), (554, 627), (606, 617), (542, 543), (558, 559), (594, 595), (610, 611), (579, 583), (504, 619), (626, 629), (511, 512), (607, 608), (497, 498), (528, 529), (544, 545), (561, 562), (594, 621), (572, 638), (520, 588), (632, 633), (629, 644), (603, 612), (610, 633), (615, 625), (640, 644), (551, 552), (559, 560), (516, 641), (604, 607), (636, 637), (644, 645), (606, 643), (545, 570), (578, 586), (553, 554), (599, 629), (510, 511), (514, 515), (638, 639), (642, 643), (515, 521), (536, 642), (571, 645), (563, 564), (555, 556), (503, 504), (631, 632), (624, 625), (640, 641), (616, 644), (500, 556), (635, 637), (513, 632), (493, 494), (501, 502), (557, 558), (565, 566), (552, 624), (515, 516), (583, 584), (591, 592), (552, 590), (566, 578), (502, 503), (522, 523), (630, 631), (631, 639), (517, 518), (645, 646), (526, 595), (532, 593), (616, 617), (541, 566), (505, 545), (607, 633), (549, 598), (501, 593), (543, 544), (575, 576), (602, 620), (554, 642), (513, 514), (641, 642), (601, 619), (582, 583), (620, 621), (628, 629), (568, 569), (601, 602), (515, 594), (532, 604), (532, 551), (643, 646), (544, 575), (590, 643), (600, 619), (511, 606), (495, 496), (603, 604), (611, 612), (553, 582), (498, 630), (572, 573), (580, 581), (605, 606), (613, 614), (521, 522), (561, 642), (574, 575), (590, 591), (508, 603), (523, 524), (531, 532), (599, 600), (591, 624), (560, 561), (576, 577), (593, 594), (609, 610), (538, 539), (614, 615), (636, 638), (612, 627), (525, 526), (533, 534), (644, 646), (550, 582), (635, 636), (601, 620), (600, 601), (633, 634), (614, 633), (493, 604), (507, 585), (507, 508)]], 
    'out': 7
  },
  {
    'name': 'Graph 615 vertices 844 edges',
    'in': [615, [(54, 55), (86, 87), (92, 93), (100, 101), (125, 126), (65, 112), (40, 41), (72, 73), (18, 19), (34, 35), (94, 95), (110, 111), (60, 108), (127, 128), (80, 81), (96, 97), (113, 114), (6, 7), (122, 123), (134, 135), (44, 45), (52, 53), (76, 77), (84, 85), (25, 26), (4, 118), (122, 132), (27, 28), (35, 36), (130, 134), (4, 5), (29, 30), (37, 38), (105, 106), (14, 15), (114, 115), (55, 56), (107, 108), (115, 116), (0, 1), (17, 18), (33, 34), (12, 97), (109, 110), (117, 118), (128, 134), (15, 16), (67, 68), (7, 8), (131, 132), (22, 23), (106, 107), (69, 70), (26, 73), (8, 9), (105, 135), (65, 66), (58, 59), (12, 13), (20, 21), (103, 104), (111, 112), (73, 74), (50, 51), (66, 67), (75, 76), (23, 24), (83, 84), (139, 140), (38, 39), (90, 91), (77, 78), (85, 86), (24, 25), (57, 58), (114, 127), (59, 60), (42, 43), (74, 75), (28, 29), (36, 37), (61, 62), (30, 31), (46, 47), (82, 83), (98, 99), (95, 96), (16, 17), (32, 33), (49, 50), (60, 105), (120, 121), (70, 141), (123, 126), (39, 40), (47, 48), (124, 125), (132, 133), (41, 42), (2, 3), (126, 127), (130, 131), (7, 106), (51, 52), (43, 44), (119, 120), (108, 118), (112, 113), (128, 129), (48, 132), (45, 46), (53, 54), (3, 4), (71, 72), (79, 80), (135, 136), (10, 11), (118, 119), (138, 139), (5, 6), (133, 134), (131, 139), (104, 105), (136, 137), (31, 32), (63, 64), (1, 2), (129, 130), (70, 71), (108, 109), (116, 117), (140, 141), (56, 57), (89, 90), (91, 92), (99, 100), (60, 61), (68, 69), (93, 94), (101, 102), (9, 10), (137, 138), (62, 63), (78, 79), (11, 12), (19, 20), (87, 88), (48, 49), (64, 65), (81, 82), (97, 98), (26, 27), (102, 103), (83, 102), (13, 14), (21, 22), (141, 142), (88, 89), (121, 122), (123, 124), (170, 171), (202, 203), (219, 244), (156, 157), (164, 165), (189, 190), (168, 169), (200, 201), (146, 147), (162, 163), (222, 223), (238, 239), (223, 224), (144, 145), (160, 161), (177, 178), (156, 228), (250, 251), (172, 173), (180, 181), (204, 205), (212, 213), (246, 251), (248, 249), (169, 243), (155, 156), (163, 164), (179, 201), (180, 191), (227, 245), (169, 170), (242, 243), (237, 243), (221, 238), (183, 184), (235, 236), (243, 244), (240, 241), (170, 203), (173, 174), (181, 182), (199, 200), (207, 208), (152, 169), (150, 151), (234, 235), (197, 198), (230, 235), (159, 165), (232, 233), (249, 252), (183, 217), (193, 194), (167, 169), (198, 199), (236, 237), (244, 245), (193, 233), (219, 220), (227, 228), (200, 238), (186, 219), (146, 185), (224, 244), (206, 216), (201, 202), (144, 187), (190, 191), (206, 207), (215, 216), (147, 148), (153, 156), (166, 208), (218, 219), (166, 167), (205, 206), (213, 214), (216, 217), (249, 250), (156, 219), (184, 214), (236, 247), (187, 188), (240, 242), (238, 247), (180, 209), (228, 234), (182, 183), (214, 215), (220, 221), (228, 229), (198, 234), (226, 244), (218, 220), (145, 223), (232, 243), (158, 159), (174, 175), (210, 211), (226, 227), (180, 229), (208, 209), (224, 225), (241, 242), (232, 234), (207, 234), (192, 236), (153, 154), (154, 190), (152, 204), (167, 168), (175, 176), (191, 224), (169, 225), (157, 158), (165, 166), (233, 234), (171, 172), (179, 180), (247, 248), (167, 233), (145, 146), (161, 162), (205, 215), (237, 238), (245, 246), (237, 251), (195, 196), (143, 144), (233, 250), (246, 247), (191, 233), (146, 238), (179, 226), (147, 249), (159, 160), (191, 192), (186, 187), (148, 149), (174, 185), (184, 185), (217, 218), (162, 195), (188, 206), (231, 232), (239, 240), (215, 231), (233, 238), (188, 189), (196, 197), (221, 222), (229, 230), (173, 228), (178, 179), (194, 195), (203, 204), (211, 212), (151, 152), (195, 228), (176, 177), (192, 193), (209, 210), (225, 226), (154, 155), (230, 231), (244, 247), (149, 150), (152, 153), (185, 186), (162, 173), (186, 234), (251, 252), (195, 238), (310, 311), (342, 343), (332, 347), (348, 349), (356, 357), (381, 382), (282, 284), (296, 297), (328, 329), (274, 275), (290, 291), (350, 351), (366, 367), (402, 403), (383, 384), (271, 303), (321, 340), (267, 365), (336, 337), (352, 353), (369, 370), (400, 401), (262, 263), (378, 379), (390, 391), (289, 405), (300, 301), (308, 309), (332, 333), (340, 341), (281, 282), (294, 408), (333, 360), (337, 365), (283, 284), (291, 292), (411, 412), (260, 261), (285, 286), (293, 294), (361, 362), (270, 271), (370, 371), (398, 399), (306, 373), (311, 333), (311, 312), (363, 364), (371, 372), (386, 401), (256, 257), (273, 274), (289, 290), (406, 409), (345, 368), (365, 366), (373, 374), (253, 384), (396, 403), (292, 311), (271, 272), (323, 324), (263, 264), (387, 388), (344, 361), (349, 391), (278, 279), (362, 363), (406, 407), (325, 326), (264, 265), (355, 390), (364, 368), (321, 322), (314, 315), (268, 269), (276, 277), (309, 374), (359, 360), (367, 368), (328, 366), (279, 394), (328, 372), (329, 330), (306, 307), (322, 323), (275, 320), (323, 391), (279, 280), (331, 332), (339, 340), (395, 396), (403, 404), (319, 351), (294, 295), (346, 347), (333, 334), (341, 342), (333, 347), (280, 281), (313, 314), (259, 402), (294, 372), (315, 316), (298, 299), (330, 331), (253, 254), (284, 285), (292, 293), (317, 318), (267, 296), (256, 312), (326, 341), (300, 370), (266, 405), (269, 359), (286, 287), (302, 303), (338, 339), (354, 355), (255, 256), (351, 352), (272, 273), (288, 289), (305, 306), (312, 339), (376, 377), (409, 410), (352, 358), (343, 364), (383, 405), (295, 296), (303, 304), (328, 357), (335, 369), (380, 381), (388, 389), (375, 412), (297, 298), (320, 400), (254, 255), (258, 259), (382, 383), (386, 387), (286, 371), (307, 308), (299, 300), (375, 376), (368, 369), (384, 385), (401, 402), (255, 331), (301, 302), (309, 310), (335, 372), (269, 411), (337, 368), (259, 260), (327, 328), (335, 336), (391, 392), (399, 400), (265, 410), (266, 267), (374, 375), (394, 395), (261, 262), (389, 390), (370, 389), (323, 331), (360, 361), (392, 393), (332, 351), (285, 310), (287, 288), (319, 320), (257, 258), (385, 386), (372, 378), (316, 402), (326, 327), (364, 365), (372, 373), (396, 397), (404, 405), (312, 313), (345, 346), (336, 385), (347, 348), (355, 356), (343, 402), (272, 274), (366, 369), (408, 412), (316, 317), (324, 325), (349, 350), (357, 358), (337, 404), (265, 266), (393, 394), (365, 380), (318, 319), (334, 335), (267, 268), (275, 276), (343, 344), (407, 408), (304, 305), (320, 321), (337, 338), (353, 354), (282, 283), (358, 359), (410, 411), (269, 270), (277, 278), (397, 398), (405, 406), (344, 345), (377, 378), (408, 409), (379, 380), (426, 427), (458, 459), (420, 421), (445, 446), (486, 522), (436, 478), (529, 532), (519, 537), (424, 425), (456, 457), (512, 519), (418, 419), (478, 479), (494, 495), (530, 531), (479, 480), (416, 417), (433, 434), (506, 507), (518, 519), (428, 429), (436, 437), (460, 461), (468, 469), (486, 512), (504, 505), (537, 538), (486, 535), (505, 533), (419, 420), (431, 535), (508, 509), (516, 517), (425, 426), (498, 499), (526, 527), (469, 528), (439, 440), (491, 492), (499, 500), (496, 497), (512, 513), (529, 530), (429, 430), (437, 438), (508, 534), (455, 456), (463, 464), (519, 520), (527, 528), (490, 491), (534, 535), (453, 454), (444, 488), (488, 489), (520, 521), (452, 537), (449, 450), (454, 455), (470, 534), (492, 493), (500, 501), (524, 525), (532, 533), (498, 518), (419, 445), (475, 476), (483, 484), (432, 491), (482, 488), (457, 458), (446, 447), (462, 463), (512, 520), (471, 472), (535, 536), (422, 423), (474, 475), (461, 462), (469, 470), (472, 473), (505, 506), (536, 537), (426, 507), (522, 532), (443, 444), (492, 532), (438, 439), (470, 471), (476, 477), (484, 485), (509, 510), (414, 415), (430, 431), (466, 467), (482, 483), (427, 440), (511, 512), (486, 527), (464, 465), (480, 481), (497, 498), (528, 529), (461, 506), (482, 505), (423, 424), (431, 432), (413, 414), (421, 422), (445, 510), (489, 490), (510, 511), (514, 515), (427, 428), (435, 436), (503, 504), (417, 418), (493, 494), (501, 502), (471, 509), (487, 528), (451, 452), (515, 516), (502, 503), (522, 523), (517, 518), (426, 493), (537, 539), (415, 416), (447, 448), (513, 514), (507, 535), (500, 525), (442, 443), (440, 441), (473, 474), (487, 488), (495, 496), (499, 521), (444, 445), (452, 453), (477, 478), (485, 486), (503, 535), (521, 522), (517, 527), (434, 435), (450, 451), (459, 460), (467, 468), (523, 524), (531, 532), (432, 433), (448, 449), (465, 466), (481, 482), (486, 487), (538, 539), (525, 526), (533, 534), (441, 442), (507, 508), (577, 579), (566, 567), (598, 599), (604, 605), (612, 613), (552, 553), (584, 585), (546, 547), (606, 607), (592, 593), (608, 609), (567, 592), (556, 557), (564, 565), (588, 589), (596, 597), (594, 614), (556, 587), (547, 548), (595, 597), (541, 542), (549, 550), (606, 610), (583, 612), (574, 587), (566, 573), (553, 581), (567, 568), (545, 546), (579, 580), (607, 609), (547, 557), (581, 582), (608, 613), (580, 598), (577, 578), (599, 606), (570, 571), (612, 614), (584, 586), (545, 552), (562, 582), (587, 594), (608, 610), (576, 598), (564, 611), (589, 600), (585, 586), (542, 555), (557, 572), (562, 563), (578, 579), (587, 588), (595, 596), (587, 593), (550, 551), (602, 603), (589, 590), (597, 598), (569, 570), (611, 614), (591, 613), (571, 572), (556, 596), (554, 555), (586, 587), (540, 541), (548, 549), (573, 574), (542, 543), (558, 559), (594, 595), (610, 611), (607, 608), (544, 545), (561, 562), (580, 585), (597, 610), (563, 569), (551, 552), (559, 560), (553, 554), (576, 614), (602, 613), (608, 611), (555, 556), (563, 564), (554, 572), (550, 558), (557, 558), (565, 566), (591, 592), (583, 584), (596, 601), (565, 577), (548, 589), (554, 603), (542, 549), (543, 544), (575, 576), (582, 583), (589, 592), (568, 569), (601, 602), (551, 561), (603, 604), (611, 612), (544, 608), (602, 609), (572, 573), (580, 581), (605, 606), (613, 614), (560, 608), (574, 575), (590, 591), (552, 603), (599, 600), (560, 561), (576, 577), (593, 594), (609, 610), (562, 580), (600, 601), (608, 612), (583, 610)]],
    'out': 5
  },
  {
    'name': 'Graph 618 vertices 902 edges',
    'in': [618, [(54, 55), (86, 87), (92, 93), (100, 101), (125, 126), (114, 120), (46, 100), (77, 101), (40, 41), (72, 73), (62, 139), (18, 19), (34, 35), (94, 95), (110, 111), (127, 128), (28, 88), (80, 81), (96, 97), (113, 114), (59, 87), (6, 7), (122, 123), (134, 135), (3, 24), (44, 45), (52, 53), (76, 77), (84, 85), (100, 133), (72, 109), (25, 26), (112, 128), (105, 113), (44, 75), (27, 28), (35, 36), (127, 135), (16, 63), (66, 124), (4, 5), (29, 30), (37, 38), (17, 62), (105, 106), (14, 15), (114, 115), (28, 123), (55, 56), (107, 108), (115, 116), (0, 1), (17, 18), (33, 34), (19, 137), (109, 110), (117, 118), (15, 16), (67, 68), (7, 8), (131, 132), (115, 126), (48, 140), (22, 23), (106, 107), (69, 70), (8, 9), (72, 83), (40, 70), (3, 135), (65, 66), (58, 59), (132, 137), (12, 13), (20, 21), (49, 62), (129, 133), (50, 70), (91, 127), (103, 104), (111, 112), (37, 125), (134, 139), (39, 44), (73, 74), (122, 133), (108, 132), (50, 51), (66, 67), (75, 76), (23, 24), (83, 84), (139, 140), (101, 126), (11, 45), (38, 39), (90, 91), (77, 78), (85, 86), (95, 133), (19, 27), (24, 25), (57, 58), (74, 97), (17, 87), (90, 112), (59, 60), (77, 106), (120, 137), (42, 43), (74, 75), (28, 29), (36, 37), (61, 62), (99, 138), (3, 94), (30, 31), (46, 47), (82, 83), (98, 99), (40, 93), (65, 137), (95, 96), (73, 134), (16, 17), (32, 33), (49, 50), (82, 109), (85, 117), (9, 33), (0, 116), (120, 121), (10, 53), (137, 139), (16, 117), (17, 121), (39, 40), (47, 48), (124, 125), (132, 133), (41, 42), (62, 106), (2, 3), (126, 127), (130, 131), (77, 136), (51, 52), (43, 44), (119, 120), (104, 132), (112, 113), (128, 129), (76, 79), (79, 123), (41, 121), (136, 140), (45, 46), (53, 54), (51, 130), (39, 80), (5, 41), (1, 7), (126, 132), (50, 72), (120, 128), (3, 4), (71, 72), (79, 80), (135, 136), (67, 120), (133, 137), (86, 121), (10, 11), (118, 119), (138, 139), (55, 81), (5, 6), (133, 134), (20, 95), (89, 95), (0, 82), (104, 105), (136, 137), (33, 136), (122, 135), (71, 124), (31, 32), (63, 64), (46, 87), (1, 2), (129, 130), (127, 139), (70, 71), (108, 109), (116, 117), (24, 38), (56, 57), (89, 90), (31, 91), (19, 25), (73, 114), (91, 92), (99, 100), (109, 129), (60, 61), (68, 69), (93, 94), (101, 102), (121, 134), (84, 96), (9, 10), (137, 138), (58, 69), (62, 63), (78, 79), (110, 131), (8, 17), (78, 137), (11, 12), (19, 20), (87, 88), (68, 128), (48, 49), (64, 65), (81, 82), (97, 98), (26, 27), (102, 103), (7, 79), (46, 94), (13, 14), (21, 22), (67, 138), (88, 89), (121, 122), (123, 124), (323, 335), (170, 171), (202, 203), (310, 311), (161, 268), (156, 157), (164, 165), (189, 190), (168, 169), (200, 201), (296, 297), (328, 329), (146, 147), (162, 163), (222, 223), (238, 239), (274, 275), (290, 291), (299, 321), (223, 224), (144, 145), (160, 161), (177, 178), (319, 332), (250, 251), (262, 263), (173, 247), (202, 328), (172, 173), (180, 181), (204, 205), (212, 213), (300, 301), (308, 309), (332, 333), (217, 280), (248, 249), (281, 282), (261, 303), (152, 162), (194, 281), (164, 248), (155, 156), (163, 164), (283, 284), (291, 292), (281, 316), (327, 334), (252, 253), (260, 261), (285, 286), (293, 294), (266, 326), (291, 335), (169, 170), (171, 247), (205, 306), (142, 143), (242, 243), (270, 271), (183, 184), (235, 236), (243, 244), (311, 312), (240, 241), (256, 257), (273, 274), (289, 290), (174, 183), (172, 200), (274, 281), (173, 174), (181, 182), (215, 314), (300, 311), (177, 283), (199, 200), (207, 208), (263, 264), (271, 272), (323, 324), (283, 290), (150, 151), (234, 235), (278, 279), (328, 333), (197, 198), (325, 326), (169, 258), (151, 297), (232, 233), (264, 265), (310, 327), (166, 283), (193, 194), (321, 322), (198, 199), (314, 315), (236, 237), (244, 245), (268, 269), (276, 277), (300, 327), (320, 321), (254, 293), (187, 229), (219, 220), (227, 228), (332, 334), (182, 332), (201, 202), (329, 330), (325, 335), (190, 191), (206, 207), (306, 307), (322, 323), (231, 330), (215, 216), (147, 148), (279, 280), (331, 332), (302, 328), (157, 293), (250, 275), (207, 237), (166, 167), (218, 219), (294, 295), (334, 336), (205, 206), (213, 214), (333, 334), (241, 288), (161, 174), (216, 217), (249, 250), (280, 281), (313, 314), (187, 188), (315, 316), (272, 295), (182, 183), (214, 215), (298, 299), (330, 331), (220, 221), (228, 229), (253, 254), (284, 285), (292, 293), (317, 318), (161, 250), (149, 258), (242, 283), (287, 335), (305, 331), (158, 159), (174, 175), (210, 211), (226, 227), (286, 287), (302, 303), (277, 298), (180, 229), (255, 256), (229, 322), (191, 254), (257, 276), (208, 209), (224, 225), (241, 242), (272, 273), (288, 289), (305, 306), (306, 313), (275, 276), (265, 310), (153, 154), (175, 264), (167, 168), (175, 176), (295, 296), (303, 304), (205, 331), (177, 295), (157, 158), (165, 166), (217, 248), (177, 308), (233, 234), (297, 298), (263, 292), (254, 255), (258, 259), (296, 305), (211, 289), (171, 172), (179, 180), (247, 248), (299, 300), (145, 146), (161, 162), (307, 308), (307, 321), (237, 238), (245, 246), (301, 302), (309, 310), (288, 312), (297, 328), (173, 209), (165, 182), (195, 196), (143, 144), (259, 260), (327, 328), (335, 336), (314, 335), (161, 254), (246, 247), (266, 267), (151, 336), (261, 262), (153, 237), (300, 319), (179, 226), (159, 160), (191, 192), (287, 288), (319, 320), (257, 258), (292, 299), (159, 299), (267, 294), (186, 187), (326, 327), (222, 333), (148, 149), (277, 316), (184, 185), (217, 218), (312, 313), (211, 217), (155, 235), (323, 326), (276, 335), (231, 232), (239, 240), (317, 326), (244, 279), (235, 273), (188, 189), (196, 197), (221, 222), (229, 230), (316, 317), (324, 325), (279, 285), (324, 336), (265, 266), (174, 332), (178, 179), (194, 195), (318, 319), (334, 335), (196, 227), (184, 320), (270, 329), (145, 150), (203, 204), (211, 212), (151, 152), (267, 268), (176, 177), (192, 193), (209, 210), (225, 226), (154, 155), (230, 231), (282, 283), (304, 305), (141, 142), (149, 150), (269, 270), (277, 278), (205, 226), (152, 153), (185, 186), (143, 331), (233, 254), (247, 251), (206, 233), (233, 243), (251, 252), (421, 489), (342, 343), (426, 427), (458, 459), (348, 349), (356, 357), (381, 382), (412, 413), (420, 421), (445, 446), (424, 425), (456, 457), (350, 351), (366, 367), (402, 403), (418, 419), (478, 479), (494, 495), (383, 384), (479, 480), (352, 353), (369, 370), (400, 401), (416, 417), (378, 379), (390, 391), (433, 434), (506, 507), (340, 341), (428, 429), (436, 437), (460, 461), (468, 469), (461, 473), (504, 505), (411, 412), (419, 420), (349, 496), (388, 480), (508, 509), (358, 415), (361, 362), (425, 426), (370, 371), (398, 399), (498, 499), (363, 364), (371, 372), (439, 440), (491, 492), (496, 497), (499, 500), (512, 513), (365, 366), (373, 374), (429, 430), (437, 438), (387, 510), (503, 515), (377, 513), (387, 388), (455, 456), (463, 464), (362, 363), (406, 407), (490, 491), (448, 501), (453, 454), (488, 489), (448, 491), (449, 450), (454, 455), (492, 493), (500, 501), (451, 503), (350, 420), (341, 460), (359, 360), (367, 368), (475, 476), (483, 484), (407, 423), (348, 435), (457, 458), (496, 513), (354, 461), (446, 447), (462, 463), (425, 498), (395, 396), (339, 340), (403, 404), (471, 472), (346, 347), (422, 423), (474, 475), (341, 342), (461, 462), (469, 470), (472, 473), (505, 506), (369, 442), (443, 444), (513, 515), (438, 439), (470, 471), (505, 516), (425, 463), (476, 477), (484, 485), (509, 510), (459, 488), (392, 447), (445, 460), (338, 339), (354, 355), (414, 415), (430, 431), (466, 467), (482, 483), (442, 465), (351, 352), (511, 512), (464, 465), (480, 481), (497, 498), (376, 377), (409, 410), (423, 424), (431, 432), (423, 503), (354, 474), (380, 381), (388, 389), (413, 414), (421, 422), (376, 475), (489, 490), (387, 424), (398, 428), (382, 383), (386, 387), (510, 511), (514, 515), (383, 473), (375, 376), (427, 428), (435, 436), (503, 504), (368, 369), (384, 385), (401, 402), (417, 418), (382, 472), (447, 487), (493, 494), (501, 502), (474, 491), (404, 421), (391, 392), (399, 400), (451, 452), (515, 516), (374, 375), (394, 395), (502, 503), (468, 473), (389, 390), (360, 361), (392, 393), (337, 482), (388, 468), (415, 416), (447, 448), (385, 386), (513, 514), (461, 502), (442, 443), (407, 496), (364, 365), (372, 373), (396, 397), (404, 405), (400, 456), (392, 416), (345, 346), (440, 441), (473, 474), (355, 356), (347, 348), (487, 488), (495, 496), (404, 494), (489, 494), (349, 350), (357, 358), (444, 445), (452, 453), (477, 478), (485, 486), (507, 508), (413, 511), (393, 394), (448, 493), (434, 435), (450, 451), (407, 408), (343, 344), (459, 460), (467, 468), (337, 338), (353, 354), (432, 433), (448, 449), (410, 411), (358, 359), (465, 466), (481, 482), (397, 398), (405, 406), (486, 487), (366, 423), (449, 495), (344, 345), (377, 378), (408, 409), (441, 442), (379, 380), (566, 567), (598, 599), (557, 610), (604, 605), (612, 613), (552, 553), (584, 585), (530, 531), (546, 547), (606, 607), (592, 593), (608, 609), (518, 519), (556, 557), (564, 565), (588, 589), (596, 597), (594, 603), (537, 538), (539, 606), (539, 540), (547, 548), (541, 542), (549, 550), (576, 594), (526, 527), (567, 568), (529, 530), (545, 546), (519, 520), (579, 580), (527, 528), (534, 535), (550, 583), (581, 582), (520, 521), (577, 578), (570, 571), (524, 525), (532, 533), (518, 544), (528, 603), (553, 568), (615, 616), (596, 603), (567, 595), (565, 570), (579, 589), (610, 616), (578, 596), (585, 586), (562, 563), (578, 579), (587, 588), (535, 536), (595, 596), (604, 612), (550, 551), (602, 603), (589, 590), (597, 598), (536, 537), (569, 570), (571, 572), (546, 550), (554, 555), (586, 587), (540, 541), (548, 549), (573, 574), (587, 604), (542, 543), (558, 559), (594, 595), (610, 611), (607, 608), (528, 529), (544, 545), (561, 562), (563, 604), (554, 556), (603, 612), (520, 528), (551, 552), (559, 560), (573, 592), (582, 616), (542, 546), (553, 554), (538, 582), (555, 556), (563, 564), (584, 610), (610, 617), (557, 558), (565, 566), (579, 615), (591, 592), (583, 584), (604, 613), (577, 597), (522, 523), (517, 518), (616, 617), (543, 544), (575, 576), (544, 598), (527, 566), (543, 573), (582, 583), (572, 592), (563, 573), (560, 611), (568, 569), (601, 602), (588, 593), (593, 599), (603, 604), (611, 612), (548, 605), (614, 617), (572, 573), (580, 581), (605, 606), (613, 614), (521, 522), (574, 575), (590, 591), (603, 616), (523, 524), (531, 532), (599, 600), (560, 561), (576, 577), (593, 594), (609, 610), (538, 539), (614, 615), (582, 617), (525, 526), (533, 534), (564, 596), (600, 601)]],
    'out': 4
  },
  {
    'name': 'Graph 537 vertices 869 edges',
    'in': [537, [(54, 55), (86, 87), (92, 93), (100, 101), (125, 126), (156, 157), (114, 120), (134, 156), (40, 41), (72, 73), (136, 147), (18, 19), (34, 35), (94, 95), (110, 111), (146, 147), (24, 128), (127, 128), (5, 8), (80, 81), (96, 97), (113, 114), (144, 145), (6, 7), (122, 123), (134, 135), (14, 80), (44, 45), (52, 53), (76, 77), (84, 85), (134, 138), (61, 104), (25, 26), (27, 28), (35, 36), (155, 156), (116, 123), (4, 5), (29, 30), (37, 38), (97, 113), (39, 114), (122, 124), (105, 106), (14, 15), (114, 115), (142, 143), (74, 96), (55, 56), (107, 108), (115, 116), (77, 107), (0, 1), (17, 18), (33, 34), (109, 110), (117, 118), (5, 135), (15, 16), (67, 68), (7, 8), (131, 132), (54, 99), (119, 158), (22, 23), (106, 107), (150, 151), (69, 70), (7, 91), (150, 154), (117, 136), (8, 9), (77, 134), (7, 113), (84, 133), (88, 148), (65, 66), (73, 122), (151, 158), (58, 59), (12, 13), (20, 21), (36, 69), (34, 98), (103, 104), (111, 112), (95, 134), (98, 149), (54, 122), (73, 74), (11, 128), (50, 51), (66, 67), (75, 76), (23, 24), (83, 84), (139, 140), (147, 148), (153, 156), (148, 151), (116, 119), (38, 39), (90, 91), (90, 148), (79, 81), (77, 78), (85, 86), (24, 25), (57, 58), (26, 138), (45, 116), (59, 60), (84, 119), (146, 150), (42, 43), (74, 75), (40, 55), (28, 29), (36, 37), (61, 62), (135, 153), (49, 149), (30, 31), (46, 47), (82, 83), (98, 99), (36, 118), (11, 48), (114, 117), (1, 42), (95, 96), (16, 17), (32, 33), (49, 50), (15, 66), (152, 155), (120, 121), (153, 154), (41, 76), (98, 121), (6, 150), (75, 143), (39, 40), (47, 48), (134, 143), (123, 150), (75, 144), (41, 77), (4, 156), (6, 100), (124, 125), (132, 133), (157, 158), (41, 42), (84, 157), (141, 156), (2, 3), (126, 127), (130, 131), (51, 76), (127, 130), (34, 68), (51, 52), (43, 44), (119, 120), (112, 113), (128, 129), (145, 146), (32, 53), (45, 46), (53, 54), (29, 107), (9, 42), (62, 153), (3, 4), (71, 72), (79, 80), (135, 136), (143, 144), (102, 142), (36, 103), (10, 11), (118, 119), (138, 139), (5, 6), (133, 134), (9, 22), (104, 105), (136, 137), (34, 77), (134, 152), (115, 118), (58, 102), (31, 32), (63, 64), (51, 129), (1, 2), (129, 130), (70, 71), (108, 109), (116, 117), (140, 141), (148, 149), (138, 140), (77, 80), (2, 97), (56, 57), (89, 90), (91, 92), (99, 100), (49, 115), (60, 61), (68, 69), (93, 94), (101, 102), (49, 64), (9, 10), (137, 138), (62, 63), (78, 79), (94, 126), (134, 140), (11, 12), (19, 20), (87, 88), (151, 152), (48, 49), (64, 65), (81, 82), (97, 98), (26, 27), (102, 103), (154, 155), (26, 129), (13, 14), (21, 22), (141, 142), (149, 150), (129, 155), (96, 135), (141, 155), (88, 89), (121, 122), (152, 153), (146, 157), (15, 110), (123, 124), (170, 171), (202, 203), (164, 165), (189, 190), (168, 169), (200, 201), (162, 163), (222, 223), (238, 239), (223, 224), (160, 161), (177, 178), (172, 173), (180, 181), (204, 205), (212, 213), (163, 164), (169, 170), (242, 243), (235, 236), (183, 184), (243, 244), (240, 241), (173, 174), (181, 182), (207, 208), (199, 200), (234, 235), (197, 198), (232, 233), (193, 194), (198, 199), (236, 237), (244, 245), (219, 220), (227, 228), (201, 202), (190, 191), (206, 207), (202, 215), (215, 216), (166, 167), (218, 219), (205, 206), (213, 214), (216, 217), (187, 188), (182, 183), (214, 215), (220, 221), (228, 229), (174, 175), (210, 211), (226, 227), (208, 209), (224, 225), (241, 242), (175, 176), (167, 168), (165, 166), (233, 234), (171, 172), (179, 180), (161, 162), (237, 238), (245, 246), (195, 196), (159, 160), (191, 192), (186, 187), (184, 185), (217, 218), (231, 232), (239, 240), (193, 236), (188, 189), (196, 197), (221, 222), (229, 230), (178, 179), (194, 195), (211, 212), (203, 204), (176, 177), (192, 193), (209, 210), (225, 226), (230, 231), (185, 186), (426, 427), (378, 404), (356, 357), (263, 391), (424, 425), (290, 291), (336, 337), (368, 426), (300, 301), (332, 333), (281, 282), (283, 284), (419, 420), (395, 397), (350, 367), (391, 411), (312, 367), (270, 271), (290, 421), (371, 372), (273, 274), (406, 409), (286, 399), (366, 414), (271, 272), (323, 324), (351, 370), (325, 326), (421, 433), (330, 423), (429, 433), (379, 433), (403, 409), (292, 406), (367, 368), (277, 429), (248, 307), (261, 273), (329, 330), (322, 323), (339, 340), (258, 306), (341, 342), (313, 314), (315, 316), (312, 431), (302, 303), (354, 355), (351, 352), (305, 306), (394, 427), (359, 411), (365, 399), (313, 345), (295, 296), (431, 432), (380, 381), (388, 389), (253, 309), (297, 298), (382, 383), (386, 387), (299, 300), (274, 310), (368, 408), (335, 336), (328, 421), (383, 385), (374, 375), (392, 393), (340, 425), (372, 402), (415, 416), (258, 370), (364, 365), (404, 405), (277, 396), (347, 348), (349, 350), (429, 431), (393, 394), (334, 335), (354, 419), (320, 321), (358, 359), (385, 406), (377, 378), (408, 409), (410, 432), (412, 428), (379, 380), (251, 252), (348, 349), (420, 421), (350, 351), (418, 419), (395, 403), (369, 370), (400, 401), (428, 429), (316, 330), (248, 249), (403, 416), (411, 412), (322, 388), (252, 253), (260, 261), (361, 362), (398, 399), (311, 312), (363, 364), (326, 368), (256, 257), (269, 418), (313, 351), (373, 374), (363, 408), (263, 264), (387, 388), (323, 414), (336, 341), (421, 426), (332, 430), (276, 277), (315, 368), (378, 433), (359, 360), (306, 354), (306, 411), (403, 430), (414, 427), (279, 280), (331, 332), (403, 404), (333, 334), (292, 293), (395, 412), (430, 431), (288, 289), (409, 410), (249, 431), (423, 424), (421, 422), (368, 392), (337, 373), (427, 428), (367, 433), (401, 402), (361, 427), (334, 352), (300, 413), (259, 260), (327, 328), (399, 400), (266, 267), (261, 262), (346, 384), (269, 416), (257, 258), (396, 397), (333, 398), (377, 431), (311, 386), (275, 276), (343, 344), (323, 325), (273, 335), (353, 354), (268, 340), (282, 283), (297, 321), (277, 278), (421, 434), (290, 352), (395, 409), (401, 422), (381, 382), (412, 413), (390, 412), (274, 275), (256, 354), (352, 353), (433, 434), (250, 251), (262, 263), (378, 379), (369, 422), (332, 344), (254, 338), (293, 294), (425, 426), (353, 402), (370, 371), (355, 359), (255, 287), (289, 290), (290, 297), (365, 366), (377, 389), (432, 434), (278, 279), (362, 363), (306, 312), (369, 395), (416, 424), (321, 322), (314, 315), (293, 432), (360, 428), (268, 269), (426, 434), (259, 262), (272, 307), (318, 335), (347, 430), (306, 307), (395, 396), (256, 315), (294, 295), (346, 347), (249, 250), (298, 299), (330, 331), (253, 254), (284, 285), (286, 287), (338, 339), (264, 358), (322, 402), (413, 414), (367, 371), (247, 248), (422, 430), (384, 385), (250, 398), (309, 310), (287, 301), (368, 405), (391, 392), (394, 395), (355, 387), (389, 390), (405, 419), (254, 284), (271, 349), (345, 412), (385, 386), (290, 295), (326, 327), (312, 432), (312, 313), (278, 412), (324, 325), (344, 421), (318, 319), (267, 268), (407, 408), (304, 305), (401, 424), (353, 387), (410, 411), (269, 270), (405, 406), (369, 424), (310, 311), (342, 343), (420, 432), (296, 297), (328, 329), (366, 367), (402, 403), (383, 384), (416, 417), (390, 391), (368, 383), (308, 309), (340, 341), (305, 413), (377, 405), (291, 292), (285, 286), (399, 425), (314, 344), (281, 401), (297, 367), (429, 430), (382, 406), (406, 407), (279, 425), (264, 265), (276, 316), (336, 344), (358, 426), (350, 358), (325, 368), (352, 415), (372, 399), (422, 423), (280, 281), (357, 430), (408, 429), (313, 372), (363, 367), (268, 348), (317, 318), (267, 296), (414, 415), (407, 410), (255, 256), (272, 273), (352, 406), (363, 433), (352, 396), (376, 377), (258, 374), (303, 304), (247, 306), (248, 391), (289, 365), (254, 255), (258, 259), (381, 418), (418, 428), (307, 308), (375, 376), (368, 369), (417, 418), (427, 433), (301, 302), (360, 361), (302, 387), (393, 421), (382, 434), (287, 288), (319, 320), (271, 396), (316, 336), (372, 373), (267, 316), (394, 396), (345, 346), (310, 370), (363, 431), (355, 356), (345, 380), (316, 317), (357, 358), (385, 397), (265, 266), (423, 427), (298, 322), (337, 338), (359, 387), (432, 433), (397, 398), (254, 340), (340, 383), (341, 375), (364, 396), (344, 345), (458, 459), (445, 446), (481, 493), (456, 457), (465, 482), (478, 479), (471, 474), (479, 480), (468, 474), (473, 478), (436, 437), (460, 461), (468, 469), (436, 482), (458, 460), (454, 485), (473, 490), (445, 477), (468, 479), (469, 471), (442, 479), (477, 494), (462, 468), (471, 486), (491, 492), (439, 440), (443, 445), (488, 492), (437, 438), (455, 456), (463, 464), (471, 485), (490, 491), (453, 454), (470, 492), (488, 489), (473, 480), (449, 450), (454, 455), (465, 476), (492, 493), (487, 493), (448, 485), (443, 485), (475, 476), (483, 484), (453, 483), (457, 458), (446, 447), (462, 463), (480, 490), (458, 471), (471, 472), (473, 489), (483, 494), (474, 475), (461, 462), (469, 470), (472, 473), (458, 462), (437, 464), (455, 465), (439, 460), (443, 444), (435, 466), (438, 439), (470, 471), (476, 477), (484, 485), (467, 485), (443, 464), (468, 477), (466, 467), (482, 483), (464, 465), (480, 481), (483, 488), (441, 476), (442, 466), (489, 490), (443, 484), (479, 482), (435, 436), (448, 471), (493, 494), (477, 489), (451, 452), (437, 479), (447, 448), (442, 443), (437, 483), (440, 441), (473, 474), (449, 453), (435, 481), (487, 488), (491, 493), (458, 479), (484, 488), (444, 445), (452, 453), (477, 478), (485, 486), (450, 451), (467, 483), (459, 460), (467, 468), (448, 449), (465, 466), (481, 482), (486, 487), (441, 442), (479, 493), (483, 486), (449, 478), (502, 503), (522, 523), (534, 535), (520, 535), (509, 510), (517, 518), (519, 524), (506, 515), (520, 521), (530, 531), (511, 512), (497, 498), (513, 514), (519, 520), (528, 529), (506, 507), (518, 519), (500, 501), (524, 525), (532, 533), (521, 533), (498, 529), (504, 505), (503, 532), (495, 496), (534, 536), (502, 534), (508, 509), (516, 517), (533, 535), (516, 528), (521, 522), (498, 499), (510, 511), (514, 515), (526, 527), (503, 504), (499, 500), (523, 524), (531, 532), (496, 497), (512, 513), (529, 530), (535, 536), (507, 509), (501, 502), (525, 526), (533, 534), (505, 517), (505, 506), (527, 528), (513, 520), (500, 519), (522, 532), (515, 516), (507, 508), (512, 514)]], 
    'out': 5
  },
  {
    'name': 'Graph 673 vertices 1085 edges',
    'in': [673, [(47, 54), (54, 55), (0, 20), (40, 41), (18, 19), (34, 35), (46, 61), (12, 40), (6, 7), (53, 64), (44, 45), (52, 53), (14, 18), (25, 26), (58, 63), (27, 28), (35, 36), (4, 5), (29, 30), (37, 38), (14, 15), (38, 56), (23, 38), (64, 72), (55, 56), (0, 1), (17, 18), (33, 34), (66, 71), (15, 16), (67, 68), (7, 8), (64, 66), (22, 23), (2, 18), (69, 70), (8, 9), (65, 66), (21, 46), (58, 59), (12, 13), (20, 21), (3, 55), (50, 61), (52, 69), (28, 68), (43, 62), (32, 52), (58, 60), (50, 51), (66, 67), (15, 72), (23, 24), (26, 56), (38, 39), (24, 25), (57, 58), (30, 36), (59, 60), (66, 68), (36, 42), (42, 43), (46, 69), (28, 29), (36, 37), (61, 62), (30, 31), (46, 47), (4, 22), (11, 14), (39, 54), (16, 17), (32, 33), (49, 50), (16, 58), (31, 66), (40, 71), (17, 59), (39, 40), (47, 48), (54, 56), (8, 33), (41, 42), (2, 3), (54, 65), (51, 52), (43, 44), (45, 46), (53, 54), (19, 67), (56, 64), (3, 4), (71, 72), (10, 11), (5, 6), (31, 32), (63, 64), (1, 2), (70, 71), (4, 70), (25, 39), (56, 57), (48, 52), (60, 61), (68, 69), (9, 10), (62, 63), (11, 12), (19, 20), (15, 17), (48, 49), (64, 65), (26, 27), (33, 57), (13, 14), (21, 22), (2, 21), (86, 87), (170, 171), (92, 93), (100, 101), (125, 126), (156, 157), (164, 165), (189, 190), (152, 165), (168, 169), (123, 138), (101, 111), (94, 95), (110, 111), (146, 147), (162, 163), (170, 192), (127, 128), (80, 81), (96, 97), (113, 114), (144, 145), (122, 123), (134, 135), (160, 161), (177, 178), (76, 77), (84, 85), (172, 173), (180, 181), (155, 156), (163, 164), (128, 150), (131, 182), (160, 174), (112, 124), (105, 106), (169, 170), (114, 115), (142, 143), (107, 108), (115, 116), (183, 184), (118, 195), (88, 93), (109, 110), (117, 118), (173, 174), (181, 182), (142, 164), (157, 173), (131, 132), (106, 107), (150, 151), (90, 161), (100, 168), (128, 144), (86, 188), (175, 177), (193, 194), (166, 179), (148, 185), (127, 165), (103, 104), (111, 112), (177, 192), (73, 74), (190, 191), (139, 140), (147, 148), (83, 84), (75, 76), (90, 91), (166, 167), (77, 78), (85, 86), (98, 171), (162, 193), (187, 188), (134, 174), (74, 75), (182, 183), (82, 83), (98, 99), (158, 159), (174, 175), (192, 195), (95, 96), (123, 195), (127, 143), (120, 121), (153, 154), (167, 168), (175, 176), (186, 193), (162, 178), (124, 125), (132, 133), (157, 158), (165, 166), (130, 148), (163, 171), (126, 127), (130, 131), (119, 120), (171, 172), (179, 180), (112, 113), (128, 129), (145, 146), (161, 162), (166, 189), (137, 170), (135, 136), (143, 144), (79, 80), (195, 196), (118, 119), (138, 139), (133, 134), (178, 184), (88, 196), (104, 105), (136, 137), (183, 186), (159, 160), (191, 192), (129, 130), (186, 187), (108, 109), (116, 117), (140, 141), (148, 149), (148, 194), (89, 90), (184, 185), (120, 161), (91, 92), (99, 100), (93, 94), (101, 102), (188, 189), (162, 168), (142, 167), (137, 138), (78, 79), (178, 179), (194, 195), (154, 170), (87, 88), (151, 152), (81, 82), (97, 98), (176, 177), (192, 193), (102, 103), (154, 155), (141, 142), (149, 150), (129, 155), (142, 173), (88, 89), (121, 122), (152, 153), (185, 186), (76, 196), (123, 124), (333, 342), (202, 203), (310, 311), (342, 343), (288, 300), (200, 201), (296, 297), (328, 329), (222, 223), (238, 239), (274, 275), (290, 291), (208, 239), (283, 324), (228, 319), (223, 224), (336, 337), (250, 251), (262, 263), (309, 320), (259, 301), (204, 205), (212, 213), (300, 301), (308, 309), (332, 333), (340, 341), (203, 264), (220, 227), (248, 249), (281, 282), (210, 274), (283, 284), (291, 292), (287, 329), (252, 253), (260, 261), (285, 286), (293, 294), (341, 343), (266, 280), (242, 243), (270, 271), (216, 269), (256, 286), (271, 339), (243, 244), (235, 236), (311, 312), (240, 241), (256, 257), (273, 274), (289, 290), (298, 308), (263, 264), (271, 272), (199, 200), (207, 208), (323, 324), (209, 328), (234, 235), (278, 279), (197, 198), (325, 326), (232, 233), (264, 265), (246, 263), (253, 344), (271, 292), (321, 322), (198, 199), (314, 315), (236, 237), (244, 245), (268, 269), (276, 277), (216, 314), (302, 335), (219, 220), (227, 228), (336, 338), (217, 221), (321, 344), (209, 276), (201, 202), (329, 330), (215, 340), (206, 207), (306, 307), (322, 323), (215, 216), (279, 280), (331, 332), (339, 340), (218, 219), (294, 295), (205, 206), (213, 214), (333, 334), (341, 342), (224, 307), (219, 312), (216, 217), (249, 250), (280, 281), (313, 314), (315, 316), (236, 265), (236, 276), (214, 215), (298, 299), (330, 331), (314, 340), (220, 221), (228, 229), (253, 254), (284, 285), (292, 293), (317, 318), (253, 340), (210, 211), (226, 227), (286, 287), (302, 303), (338, 339), (321, 326), (255, 256), (254, 280), (208, 209), (224, 225), (241, 242), (272, 273), (288, 289), (305, 306), (247, 293), (224, 278), (202, 307), (234, 308), (295, 296), (303, 304), (222, 288), (214, 251), (255, 272), (325, 344), (233, 234), (297, 298), (271, 316), (254, 255), (258, 259), (297, 319), (241, 282), (334, 340), (247, 248), (299, 300), (307, 308), (274, 310), (237, 238), (245, 246), (301, 302), (309, 310), (197, 206), (259, 260), (327, 328), (335, 336), (289, 322), (246, 247), (266, 267), (241, 295), (261, 262), (300, 319), (256, 272), (286, 336), (287, 288), (319, 320), (335, 346), (257, 258), (200, 216), (326, 327), (282, 297), (217, 218), (312, 313), (345, 346), (231, 232), (239, 240), (290, 324), (221, 222), (229, 230), (316, 317), (324, 325), (268, 294), (265, 266), (280, 291), (318, 319), (334, 335), (203, 204), (211, 212), (267, 268), (275, 276), (209, 210), (225, 226), (304, 305), (320, 321), (230, 231), (282, 283), (337, 338), (245, 346), (269, 270), (277, 278), (343, 344), (344, 345), (297, 318), (331, 340), (213, 304), (237, 286), (251, 252), (426, 427), (458, 459), (356, 357), (424, 425), (456, 457), (494, 495), (479, 480), (436, 437), (468, 469), (419, 420), (516, 522), (400, 417), (371, 372), (529, 530), (408, 519), (359, 475), (436, 444), (507, 523), (510, 516), (463, 464), (527, 528), (511, 530), (419, 429), (450, 522), (376, 386), (367, 368), (398, 412), (462, 463), (377, 517), (430, 434), (505, 506), (446, 510), (366, 424), (441, 511), (395, 474), (354, 355), (485, 512), (351, 352), (511, 512), (497, 498), (497, 522), (360, 391), (431, 432), (380, 381), (388, 389), (489, 490), (447, 524), (382, 383), (386, 387), (435, 436), (503, 504), (433, 526), (515, 516), (374, 375), (517, 518), (409, 504), (480, 498), (392, 393), (384, 486), (365, 444), (426, 442), (415, 416), (447, 448), (364, 365), (404, 405), (473, 474), (476, 500), (347, 348), (487, 488), (514, 528), (349, 350), (444, 445), (485, 486), (393, 394), (465, 466), (358, 359), (445, 509), (377, 378), (408, 409), (507, 514), (379, 380), (388, 519), (379, 475), (348, 349), (420, 421), (350, 351), (418, 419), (416, 446), (411, 457), (369, 370), (400, 401), (428, 429), (460, 461), (423, 504), (480, 486), (411, 412), (361, 362), (398, 399), (432, 437), (363, 364), (499, 500), (486, 494), (373, 374), (458, 493), (359, 490), (387, 388), (455, 456), (406, 416), (388, 391), (453, 454), (464, 502), (435, 513), (414, 525), (422, 435), (500, 501), (524, 525), (359, 360), (483, 484), (489, 514), (457, 458), (459, 474), (397, 456), (403, 404), (471, 472), (353, 500), (521, 525), (368, 421), (469, 470), (357, 465), (443, 444), (407, 435), (484, 485), (404, 449), (430, 431), (482, 483), (401, 409), (480, 481), (528, 529), (409, 410), (423, 424), (421, 422), (510, 511), (514, 515), (478, 516), (427, 428), (401, 402), (367, 415), (401, 436), (433, 468), (399, 400), (451, 452), (502, 503), (522, 523), (497, 502), (487, 522), (401, 506), (513, 514), (516, 521), (485, 496), (396, 397), (371, 452), (493, 513), (477, 478), (521, 522), (450, 451), (435, 515), (467, 468), (527, 529), (353, 354), (448, 449), (500, 503), (486, 487), (438, 461), (475, 495), (441, 442), (507, 508), (355, 408), (392, 397), (381, 382), (412, 413), (491, 503), (478, 479), (352, 353), (433, 434), (378, 379), (510, 528), (508, 509), (516, 517), (372, 511), (425, 426), (370, 371), (466, 476), (439, 440), (491, 492), (432, 516), (365, 366), (437, 438), (381, 450), (362, 363), (366, 513), (454, 455), (492, 493), (475, 476), (446, 447), (437, 458), (475, 488), (395, 396), (461, 462), (407, 521), (366, 437), (438, 439), (470, 471), (476, 477), (442, 482), (486, 527), (450, 507), (448, 513), (418, 427), (435, 503), (350, 377), (413, 414), (375, 393), (358, 451), (352, 390), (467, 505), (384, 385), (501, 502), (371, 430), (487, 528), (497, 528), (391, 392), (403, 469), (516, 519), (508, 511), (394, 395), (397, 483), (389, 390), (398, 467), (423, 505), (351, 401), (385, 386), (388, 421), (451, 489), (366, 501), (499, 501), (431, 450), (513, 525), (407, 408), (459, 460), (481, 482), (410, 411), (405, 406), (393, 488), (390, 440), (445, 446), (442, 451), (366, 367), (402, 403), (383, 384), (398, 477), (416, 417), (390, 391), (506, 507), (518, 519), (460, 472), (504, 505), (420, 493), (470, 530), (456, 516), (498, 499), (526, 527), (486, 525), (496, 497), (512, 513), (429, 430), (519, 520), (445, 508), (406, 407), (490, 491), (488, 489), (520, 521), (449, 450), (415, 520), (513, 522), (478, 519), (477, 517), (457, 501), (400, 455), (422, 423), (474, 475), (472, 473), (363, 522), (509, 510), (472, 485), (414, 415), (466, 467), (464, 465), (376, 377), (479, 501), (511, 522), (476, 504), (497, 512), (426, 524), (375, 376), (368, 369), (417, 418), (433, 455), (493, 494), (354, 520), (390, 415), (440, 484), (360, 361), (512, 515), (442, 443), (372, 373), (440, 441), (467, 524), (355, 356), (495, 496), (428, 463), (357, 358), (452, 453), (434, 435), (370, 530), (523, 524), (432, 433), (397, 398), (525, 526), (407, 459), (566, 567), (598, 599), (604, 605), (535, 572), (552, 553), (584, 585), (546, 547), (606, 607), (592, 593), (564, 570), (601, 606), (556, 557), (564, 565), (588, 589), (596, 597), (537, 538), (595, 608), (543, 547), (539, 540), (547, 548), (581, 605), (595, 597), (541, 542), (549, 550), (598, 605), (563, 608), (588, 605), (567, 568), (545, 546), (551, 597), (563, 595), (550, 604), (563, 571), (532, 549), (579, 580), (598, 606), (578, 605), (534, 535), (581, 582), (547, 608), (585, 598), (601, 608), (599, 608), (537, 559), (577, 578), (570, 571), (532, 533), (562, 573), (538, 586), (583, 599), (549, 586), (585, 586), (573, 577), (562, 563), (578, 579), (587, 588), (595, 596), (535, 536), (550, 551), (602, 603), (531, 550), (589, 590), (597, 598), (589, 603), (536, 537), (569, 570), (571, 572), (554, 555), (586, 587), (569, 606), (540, 541), (548, 549), (573, 574), (555, 567), (542, 543), (558, 559), (594, 595), (552, 592), (607, 608), (544, 545), (561, 562), (552, 558), (605, 607), (543, 561), (540, 597), (546, 600), (537, 547), (551, 552), (559, 560), (548, 587), (553, 554), (580, 601), (587, 597), (545, 583), (584, 593), (566, 577), (555, 556), (563, 564), (601, 604), (557, 558), (565, 566), (542, 575), (531, 579), (591, 592), (583, 584), (561, 591), (537, 567), (569, 599), (606, 608), (535, 567), (574, 595), (543, 544), (575, 576), (582, 583), (562, 600), (602, 605), (568, 569), (601, 602), (593, 599), (533, 550), (603, 604), (546, 573), (600, 604), (572, 573), (580, 581), (605, 606), (538, 575), (578, 608), (574, 575), (590, 591), (599, 600), (531, 532), (560, 561), (576, 577), (593, 594), (551, 579), (538, 539), (533, 534), (600, 601), (581, 596), (590, 597), (654, 657), (612, 613), (637, 638), (668, 669), (648, 659), (622, 623), (658, 659), (624, 665), (639, 640), (640, 668), (625, 626), (656, 657), (634, 635), (646, 647), (617, 654), (643, 671), (667, 668), (639, 650), (624, 636), (617, 618), (643, 649), (626, 627), (654, 655), (645, 661), (619, 620), (627, 628), (642, 657), (621, 622), (629, 630), (633, 645), (637, 663), (626, 648), (663, 667), (643, 644), (618, 619), (662, 663), (633, 659), (615, 664), (640, 643), (634, 640), (666, 669), (653, 656), (623, 624), (615, 616), (630, 662), (666, 670), (633, 660), (662, 669), (659, 660), (651, 652), (656, 671), (634, 668), (641, 670), (644, 670), (658, 662), (656, 668), (649, 669), (654, 666), (610, 611), (670, 671), (662, 667), (613, 615), (632, 633), (665, 666), (635, 638), (636, 637), (644, 645), (669, 670), (633, 664), (644, 656), (655, 669), (638, 639), (642, 643), (629, 650), (668, 672), (631, 632), (624, 625), (640, 641), (657, 658), (667, 670), (647, 648), (655, 656), (640, 667), (625, 627), (630, 631), (650, 651), (617, 655), (645, 646), (616, 617), (648, 649), (650, 661), (671, 672), (632, 650), (667, 669), (641, 642), (620, 621), (628, 629), (652, 653), (660, 661), (650, 652), (654, 667), (611, 612), (613, 614), (621, 623), (649, 650), (657, 662), (663, 664), (609, 610), (614, 615), (666, 667), (653, 654), (661, 662), (633, 634), (664, 665), (642, 655), (635, 636)]],
    'out': 6
  },
  {
    'name': 'Graph 556 vertices 794 edges',
    'in': [556, [(0, 1), (1, 2), (6, 7), (4, 5), (5, 6), (1, 4), (2, 3), (3, 7), (3, 4), (54, 55), (86, 87), (92, 93), (100, 101), (125, 126), (40, 41), (72, 73), (141, 145), (18, 19), (34, 35), (94, 95), (110, 111), (146, 147), (127, 128), (80, 81), (96, 97), (113, 114), (144, 145), (122, 123), (134, 135), (62, 123), (44, 45), (52, 53), (76, 77), (84, 85), (25, 26), (27, 28), (35, 36), (29, 30), (37, 38), (138, 141), (105, 106), (25, 91), (14, 15), (114, 115), (142, 143), (93, 110), (55, 56), (107, 108), (115, 116), (17, 18), (33, 34), (23, 81), (109, 110), (117, 118), (43, 92), (67, 68), (15, 16), (131, 132), (22, 23), (106, 107), (69, 70), (20, 148), (8, 9), (65, 66), (72, 131), (58, 59), (12, 13), (20, 21), (103, 104), (111, 112), (45, 100), (73, 74), (50, 51), (66, 67), (75, 76), (23, 24), (83, 84), (139, 140), (147, 148), (38, 39), (90, 91), (77, 78), (85, 86), (24, 25), (57, 58), (59, 60), (42, 43), (74, 75), (28, 29), (36, 37), (61, 62), (30, 31), (46, 47), (82, 83), (98, 99), (95, 96), (16, 17), (32, 33), (49, 50), (29, 84), (109, 143), (120, 121), (39, 40), (47, 48), (124, 125), (132, 133), (41, 42), (126, 127), (130, 131), (43, 44), (51, 52), (119, 120), (112, 113), (128, 129), (145, 146), (45, 46), (53, 54), (12, 30), (79, 80), (71, 72), (135, 136), (143, 144), (12, 116), (10, 11), (118, 119), (138, 139), (133, 134), (104, 105), (136, 137), (31, 32), (63, 64), (129, 130), (70, 71), (108, 109), (116, 117), (140, 141), (148, 149), (124, 131), (23, 73), (56, 57), (89, 90), (9, 83), (91, 92), (99, 100), (60, 61), (68, 69), (93, 94), (101, 102), (9, 10), (137, 138), (62, 63), (78, 79), (91, 104), (19, 20), (11, 12), (87, 88), (48, 49), (64, 65), (81, 82), (97, 98), (26, 27), (102, 103), (13, 14), (21, 22), (141, 142), (88, 89), (121, 122), (123, 124), (313, 317), (156, 157), (301, 314), (222, 223), (290, 291), (264, 306), (161, 191), (301, 331), (251, 257), (300, 301), (201, 246), (281, 282), (283, 284), (159, 188), (293, 297), (254, 267), (270, 271), (170, 250), (243, 244), (273, 274), (181, 182), (297, 311), (226, 268), (271, 272), (323, 324), (206, 209), (224, 277), (247, 298), (325, 326), (257, 282), (242, 287), (198, 199), (166, 296), (244, 245), (241, 257), (227, 228), (226, 263), (201, 202), (329, 330), (190, 191), (322, 323), (172, 317), (242, 278), (205, 206), (313, 314), (315, 316), (181, 184), (182, 183), (214, 215), (263, 303), (228, 229), (274, 293), (260, 283), (174, 175), (226, 227), (302, 303), (259, 294), (305, 306), (287, 299), (164, 274), (153, 154), (288, 325), (167, 168), (295, 296), (254, 262), (210, 256), (157, 158), (297, 298), (228, 313), (299, 300), (187, 218), (215, 296), (317, 320), (191, 222), (195, 196), (158, 206), (194, 200), (205, 262), (227, 295), (326, 330), (196, 319), (194, 195), (211, 212), (320, 321), (192, 193), (154, 155), (185, 186), (221, 278), (251, 252), (189, 190), (184, 255), (177, 178), (254, 285), (248, 249), (256, 326), (312, 331), (236, 278), (246, 281), (252, 253), (260, 261), (169, 170), (211, 322), (183, 184), (235, 236), (311, 312), (240, 241), (256, 257), (210, 246), (173, 174), (171, 180), (263, 264), (232, 233), (228, 257), (292, 330), (236, 237), (276, 277), (222, 291), (328, 330), (219, 220), (234, 266), (191, 297), (181, 257), (289, 305), (279, 280), (303, 318), (216, 217), (295, 331), (220, 221), (292, 293), (174, 250), (244, 293), (208, 209), (288, 289), (310, 312), (311, 317), (195, 267), (184, 266), (294, 302), (245, 246), (200, 307), (259, 260), (327, 328), (266, 267), (261, 262), (211, 324), (203, 282), (257, 258), (239, 240), (289, 318), (196, 197), (275, 276), (203, 204), (151, 152), (225, 226), (282, 283), (277, 278), (247, 321), (179, 192), (313, 328), (191, 299), (238, 239), (274, 275), (223, 224), (160, 161), (250, 251), (262, 263), (180, 181), (212, 213), (163, 164), (293, 294), (242, 243), (289, 290), (316, 318), (207, 208), (325, 329), (150, 151), (234, 235), (278, 279), (193, 194), (321, 322), (314, 315), (268, 269), (192, 331), (221, 240), (302, 305), (317, 321), (206, 207), (306, 307), (166, 167), (218, 219), (294, 295), (249, 250), (153, 168), (298, 299), (330, 331), (253, 254), (284, 285), (158, 159), (210, 211), (286, 287), (172, 253), (241, 242), (244, 278), (204, 236), (293, 315), (227, 327), (245, 305), (267, 286), (233, 234), (179, 180), (247, 248), (161, 162), (237, 238), (309, 310), (246, 315), (254, 314), (155, 271), (314, 318), (186, 187), (326, 327), (184, 185), (312, 313), (231, 232), (311, 313), (188, 189), (229, 230), (324, 325), (178, 179), (318, 319), (267, 268), (176, 177), (304, 305), (269, 270), (264, 309), (170, 171), (202, 203), (310, 311), (164, 165), (168, 169), (200, 201), (296, 297), (328, 329), (162, 163), (210, 240), (172, 173), (204, 205), (308, 309), (154, 292), (210, 274), (155, 156), (291, 292), (285, 286), (188, 220), (165, 314), (214, 287), (322, 327), (169, 318), (315, 322), (199, 200), (150, 213), (172, 194), (197, 198), (264, 265), (155, 324), (306, 317), (195, 302), (198, 215), (190, 240), (164, 244), (215, 216), (213, 214), (196, 302), (280, 281), (200, 254), (187, 188), (159, 178), (317, 318), (255, 256), (170, 252), (224, 225), (272, 273), (175, 176), (303, 304), (273, 328), (165, 166), (239, 262), (254, 255), (258, 259), (310, 321), (171, 172), (307, 308), (301, 302), (263, 308), (246, 247), (189, 200), (159, 160), (191, 192), (287, 288), (319, 320), (217, 218), (193, 202), (321, 330), (221, 222), (316, 317), (273, 288), (265, 266), (275, 291), (209, 210), (277, 281), (230, 231), (240, 324), (152, 153), (422, 434), (342, 343), (426, 427), (458, 459), (348, 349), (356, 357), (381, 382), (412, 413), (420, 421), (445, 446), (424, 491), (351, 430), (424, 425), (456, 457), (350, 351), (366, 367), (402, 403), (418, 419), (478, 479), (383, 384), (479, 480), (336, 337), (352, 353), (369, 370), (400, 401), (378, 379), (390, 391), (416, 417), (433, 434), (332, 333), (340, 341), (428, 429), (436, 437), (460, 461), (468, 469), (427, 488), (448, 459), (411, 412), (419, 420), (484, 487), (469, 474), (396, 398), (468, 479), (420, 465), (397, 485), (361, 362), (425, 426), (370, 371), (398, 399), (372, 485), (363, 364), (371, 372), (439, 440), (389, 418), (479, 489), (365, 366), (373, 374), (429, 430), (437, 438), (369, 482), (467, 482), (462, 480), (361, 479), (333, 351), (387, 388), (455, 456), (463, 464), (362, 363), (406, 407), (490, 491), (458, 465), (453, 454), (468, 491), (488, 489), (386, 396), (463, 484), (395, 408), (384, 387), (449, 450), (442, 469), (454, 455), (383, 424), (431, 458), (489, 491), (435, 461), (468, 488), (359, 360), (367, 368), (475, 476), (483, 484), (363, 401), (398, 403), (370, 398), (457, 458), (446, 447), (462, 463), (349, 397), (403, 404), (395, 396), (339, 340), (471, 472), (346, 347), (422, 423), (474, 475), (391, 463), (333, 334), (341, 342), (461, 462), (469, 470), (393, 463), (472, 473), (358, 483), (417, 459), (443, 444), (407, 435), (438, 439), (470, 471), (479, 488), (476, 477), (484, 485), (474, 476), (388, 439), (338, 339), (354, 355), (414, 415), (430, 431), (466, 467), (482, 483), (440, 480), (351, 352), (449, 459), (454, 462), (464, 465), (480, 481), (383, 417), (486, 488), (376, 377), (409, 410), (437, 490), (457, 484), (386, 485), (423, 424), (431, 432), (375, 403), (465, 467), (414, 431), (408, 423), (380, 381), (388, 389), (413, 414), (421, 422), (374, 396), (489, 490), (382, 383), (386, 387), (402, 412), (387, 445), (375, 376), (427, 428), (435, 436), (401, 402), (368, 369), (384, 385), (417, 418), (371, 383), (444, 480), (337, 368), (391, 392), (399, 400), (335, 336), (451, 452), (334, 412), (374, 375), (394, 395), (389, 390), (422, 427), (360, 361), (392, 393), (392, 478), (466, 489), (415, 416), (447, 448), (385, 386), (442, 443), (426, 452), (391, 448), (364, 365), (372, 373), (396, 397), (404, 405), (467, 484), (436, 491), (345, 346), (440, 441), (473, 474), (353, 403), (393, 401), (351, 404), (400, 435), (347, 348), (355, 356), (487, 488), (350, 391), (475, 480), (349, 350), (357, 358), (444, 445), (452, 453), (477, 478), (485, 486), (469, 481), (410, 450), (393, 394), (334, 335), (434, 435), (450, 451), (360, 454), (407, 408), (343, 344), (459, 460), (467, 468), (337, 338), (353, 354), (432, 433), (448, 449), (358, 359), (410, 411), (465, 466), (481, 482), (397, 398), (405, 406), (486, 487), (401, 424), (387, 451), (343, 401), (389, 422), (390, 422), (344, 345), (377, 378), (408, 409), (441, 442), (379, 380), (513, 515), (502, 503), (522, 523), (509, 510), (517, 518), (520, 521), (494, 495), (511, 512), (497, 498), (513, 514), (519, 520), (528, 529), (506, 507), (518, 519), (492, 493), (500, 501), (524, 525), (504, 505), (495, 496), (508, 509), (516, 517), (521, 522), (498, 499), (510, 511), (514, 515), (526, 527), (503, 504), (499, 500), (523, 524), (496, 497), (512, 513), (529, 530), (493, 494), (501, 502), (525, 526), (505, 506), (527, 528), (515, 516), (507, 508), (534, 535), (554, 555), (540, 541), (548, 549), (550, 555), (552, 553), (542, 543), (546, 547), (542, 549), (543, 544), (544, 545), (532, 533), (541, 543), (552, 554), (537, 538), (544, 553), (539, 540), (547, 548), (551, 552), (538, 545), (541, 542), (549, 550), (553, 554), (544, 547), (535, 536), (531, 532), (545, 546), (538, 539), (550, 551), (548, 553), (533, 534), (536, 537), (551, 554)]],
    'out': 6
  },
  {
    'name': 'Graph 892 vertices 1190 edges',
    'in': [892, [(18, 128), (54, 55), (86, 87), (92, 93), (100, 101), (125, 126), (97, 109), (40, 41), (72, 73), (4, 55), (18, 19), (34, 35), (94, 95), (110, 111), (99, 115), (59, 98), (127, 128), (80, 81), (96, 97), (113, 114), (108, 116), (6, 7), (122, 123), (71, 97), (44, 45), (52, 53), (76, 77), (84, 85), (61, 85), (25, 26), (110, 117), (27, 28), (35, 36), (59, 124), (120, 126), (5, 11), (4, 5), (29, 30), (37, 38), (105, 106), (14, 15), (114, 115), (46, 111), (55, 56), (107, 108), (115, 116), (0, 1), (17, 18), (33, 34), (49, 71), (109, 110), (117, 118), (116, 120), (15, 16), (67, 68), (7, 8), (131, 132), (47, 90), (83, 105), (22, 23), (106, 107), (28, 107), (109, 131), (69, 70), (34, 97), (8, 9), (92, 98), (65, 66), (58, 59), (33, 54), (15, 23), (12, 13), (20, 21), (51, 88), (71, 74), (58, 77), (103, 104), (111, 112), (94, 102), (73, 74), (50, 51), (66, 67), (119, 128), (75, 76), (23, 24), (83, 84), (64, 98), (31, 63), (67, 121), (38, 39), (90, 91), (77, 78), (85, 86), (108, 122), (110, 132), (119, 124), (62, 72), (24, 25), (57, 58), (22, 36), (82, 104), (59, 60), (82, 119), (42, 43), (74, 75), (28, 29), (36, 37), (61, 62), (30, 31), (46, 47), (82, 83), (98, 99), (86, 104), (47, 101), (95, 96), (16, 17), (32, 33), (49, 50), (58, 111), (120, 121), (128, 132), (39, 40), (47, 48), (124, 125), (132, 133), (63, 78), (30, 34), (48, 72), (109, 133), (77, 112), (41, 42), (58, 95), (4, 76), (2, 3), (126, 127), (130, 131), (51, 52), (43, 44), (119, 120), (112, 113), (128, 129), (65, 130), (45, 46), (53, 54), (74, 109), (85, 107), (33, 42), (101, 129), (42, 96), (3, 4), (71, 72), (79, 80), (19, 52), (10, 11), (118, 119), (5, 6), (9, 22), (104, 105), (31, 32), (63, 64), (39, 87), (1, 2), (129, 130), (116, 122), (70, 71), (36, 105), (108, 109), (116, 117), (65, 80), (56, 57), (89, 90), (122, 127), (31, 84), (91, 92), (99, 100), (34, 61), (111, 130), (60, 61), (68, 69), (93, 94), (101, 102), (15, 131), (9, 10), (62, 63), (78, 79), (62, 112), (11, 12), (19, 20), (87, 88), (48, 49), (64, 65), (81, 82), (97, 98), (26, 27), (102, 103), (13, 14), (21, 22), (88, 89), (121, 122), (0, 35), (123, 124), (128, 130), (53, 56), (170, 171), (202, 203), (310, 311), (156, 157), (164, 165), (189, 190), (272, 284), (168, 169), (200, 201), (296, 297), (204, 228), (146, 147), (162, 163), (222, 223), (238, 239), (274, 275), (290, 291), (223, 224), (144, 145), (160, 161), (177, 178), (156, 228), (134, 135), (250, 251), (262, 263), (248, 306), (172, 173), (180, 181), (204, 205), (212, 213), (300, 301), (308, 309), (215, 246), (282, 288), (248, 249), (281, 282), (304, 315), (191, 246), (155, 156), (163, 164), (283, 284), (291, 292), (213, 237), (190, 283), (281, 305), (252, 253), (260, 261), (285, 286), (293, 294), (281, 294), (164, 209), (169, 170), (192, 241), (313, 315), (142, 143), (242, 243), (270, 271), (246, 294), (304, 312), (183, 184), (235, 236), (243, 244), (311, 312), (240, 241), (256, 257), (273, 274), (289, 290), (173, 174), (181, 182), (142, 219), (243, 255), (185, 226), (194, 302), (199, 200), (207, 208), (263, 264), (271, 272), (147, 286), (150, 151), (234, 235), (278, 279), (197, 198), (185, 295), (232, 233), (264, 265), (148, 157), (255, 301), (234, 245), (193, 194), (198, 199), (314, 315), (139, 171), (295, 314), (236, 237), (244, 245), (268, 269), (276, 277), (230, 267), (168, 170), (179, 216), (219, 220), (227, 228), (260, 284), (222, 245), (186, 214), (201, 202), (286, 299), (190, 191), (206, 207), (306, 307), (147, 148), (139, 140), (215, 216), (279, 280), (153, 215), (166, 167), (218, 219), (294, 295), (205, 206), (213, 214), (275, 283), (216, 217), (249, 250), (280, 281), (313, 314), (221, 290), (145, 246), (151, 198), (187, 188), (234, 297), (258, 292), (151, 179), (206, 299), (182, 183), (214, 215), (298, 299), (220, 221), (228, 229), (253, 254), (284, 285), (292, 293), (275, 304), (260, 283), (179, 261), (158, 159), (174, 175), (210, 211), (226, 227), (286, 287), (302, 303), (202, 244), (255, 256), (243, 277), (208, 209), (224, 225), (241, 242), (272, 273), (288, 289), (305, 306), (256, 271), (234, 298), (306, 313), (286, 308), (233, 290), (275, 276), (137, 182), (153, 154), (291, 306), (302, 309), (275, 288), (167, 168), (175, 176), (295, 296), (303, 304), (157, 158), (165, 166), (192, 243), (233, 234), (297, 298), (254, 255), (258, 259), (155, 203), (171, 172), (179, 180), (247, 248), (299, 300), (145, 146), (161, 162), (307, 308), (302, 311), (169, 173), (308, 311), (238, 286), (237, 238), (245, 246), (301, 302), (309, 310), (201, 296), (268, 275), (195, 196), (135, 136), (143, 144), (259, 260), (197, 232), (174, 188), (138, 139), (246, 247), (266, 267), (186, 283), (261, 262), (202, 240), (258, 307), (304, 311), (136, 137), (304, 314), (159, 160), (191, 192), (287, 288), (257, 258), (189, 209), (186, 187), (171, 222), (140, 141), (148, 149), (232, 244), (184, 185), (217, 218), (312, 313), (135, 165), (283, 292), (161, 192), (231, 232), (239, 240), (279, 295), (189, 283), (225, 289), (250, 300), (140, 270), (188, 189), (196, 197), (221, 222), (229, 230), (137, 138), (265, 266), (189, 193), (178, 179), (194, 195), (167, 284), (145, 155), (203, 204), (151, 152), (211, 212), (267, 268), (176, 177), (192, 193), (209, 210), (225, 226), (154, 155), (230, 231), (282, 283), (304, 305), (141, 142), (149, 150), (269, 270), (277, 278), (208, 311), (152, 153), (185, 186), (204, 242), (197, 212), (275, 312), (136, 252), (247, 251), (251, 252), (342, 343), (426, 427), (458, 459), (348, 349), (356, 357), (381, 382), (412, 413), (420, 421), (445, 446), (328, 329), (424, 425), (456, 457), (481, 482), (350, 351), (366, 367), (402, 403), (418, 419), (478, 479), (494, 495), (383, 384), (479, 480), (336, 337), (352, 353), (369, 370), (400, 401), (378, 379), (390, 391), (416, 417), (433, 434), (332, 333), (340, 341), (428, 429), (436, 437), (460, 461), (468, 469), (501, 507), (370, 452), (504, 505), (475, 489), (411, 412), (419, 420), (419, 441), (361, 362), (425, 426), (370, 371), (398, 399), (498, 499), (457, 497), (371, 372), (363, 364), (439, 440), (491, 492), (496, 497), (499, 500), (382, 462), (365, 366), (373, 374), (429, 430), (437, 438), (374, 443), (387, 388), (323, 324), (455, 456), (463, 464), (362, 363), (406, 407), (490, 491), (325, 326), (453, 454), (488, 489), (321, 322), (449, 450), (454, 455), (492, 493), (500, 501), (377, 460), (359, 360), (367, 368), (475, 476), (483, 484), (370, 453), (329, 330), (457, 458), (322, 323), (446, 447), (462, 463), (331, 332), (339, 340), (395, 396), (403, 404), (471, 472), (346, 347), (422, 423), (474, 475), (333, 334), (341, 342), (461, 462), (469, 470), (472, 473), (505, 506), (432, 507), (443, 444), (330, 331), (438, 439), (470, 471), (317, 318), (476, 477), (484, 485), (427, 479), (425, 476), (338, 339), (354, 355), (414, 415), (430, 431), (466, 467), (482, 483), (439, 454), (351, 352), (495, 497), (464, 465), (480, 481), (497, 498), (415, 486), (506, 507), (431, 440), (476, 505), (376, 377), (409, 410), (435, 503), (423, 424), (431, 432), (470, 500), (380, 381), (388, 389), (413, 414), (421, 422), (489, 490), (382, 383), (386, 387), (375, 376), (427, 428), (435, 436), (503, 504), (368, 369), (384, 385), (401, 402), (417, 418), (474, 504), (493, 494), (501, 502), (367, 415), (442, 450), (434, 474), (391, 392), (335, 336), (327, 328), (399, 400), (451, 452), (449, 469), (381, 464), (374, 375), (394, 395), (502, 503), (468, 473), (389, 390), (462, 485), (360, 361), (392, 393), (494, 500), (319, 320), (415, 416), (447, 448), (385, 386), (326, 327), (442, 443), (364, 365), (372, 373), (396, 397), (404, 405), (450, 478), (360, 395), (345, 346), (440, 441), (473, 474), (347, 348), (355, 356), (487, 488), (495, 496), (491, 493), (316, 317), (324, 325), (349, 350), (357, 358), (444, 445), (452, 453), (477, 478), (485, 486), (393, 394), (318, 319), (334, 335), (434, 435), (450, 451), (343, 344), (407, 408), (459, 460), (467, 468), (320, 321), (337, 338), (353, 354), (432, 433), (358, 359), (410, 411), (448, 449), (465, 466), (397, 398), (405, 406), (486, 487), (336, 439), (344, 345), (377, 378), (408, 409), (441, 442), (388, 505), (379, 380), (566, 567), (598, 599), (527, 532), (552, 553), (584, 585), (530, 531), (546, 547), (514, 517), (592, 593), (571, 599), (518, 519), (556, 557), (564, 565), (588, 589), (596, 597), (579, 586), (537, 538), (539, 540), (547, 548), (508, 509), (516, 517), (541, 542), (549, 550), (589, 591), (526, 527), (567, 568), (512, 513), (529, 530), (545, 546), (579, 580), (527, 528), (519, 520), (534, 535), (581, 582), (520, 521), (577, 578), (570, 571), (524, 525), (532, 533), (565, 570), (585, 586), (562, 563), (578, 579), (512, 517), (578, 590), (535, 536), (587, 588), (595, 596), (550, 551), (564, 568), (589, 590), (597, 598), (536, 537), (569, 570), (571, 572), (526, 566), (554, 555), (586, 587), (509, 510), (540, 541), (548, 549), (573, 574), (567, 597), (542, 543), (558, 559), (594, 595), (511, 512), (528, 529), (544, 545), (561, 562), (551, 552), (559, 560), (511, 577), (553, 554), (558, 588), (510, 511), (514, 515), (563, 564), (555, 556), (536, 541), (557, 558), (565, 566), (583, 584), (515, 516), (591, 592), (522, 523), (517, 518), (543, 544), (575, 576), (513, 514), (582, 583), (568, 569), (572, 573), (580, 581), (521, 522), (574, 575), (590, 591), (582, 599), (523, 524), (531, 532), (599, 600), (560, 561), (576, 577), (593, 594), (538, 539), (525, 526), (533, 534), (600, 601), (682, 683), (714, 715), (604, 605), (612, 613), (637, 638), (668, 669), (676, 677), (701, 702), (696, 731), (680, 681), (712, 713), (617, 682), (751, 779), (606, 607), (622, 623), (658, 659), (674, 675), (734, 735), (750, 751), (639, 640), (735, 736), (773, 776), (608, 609), (625, 626), (656, 657), (672, 673), (634, 635), (646, 647), (689, 690), (762, 763), (684, 685), (692, 693), (716, 717), (724, 725), (774, 775), (760, 761), (701, 739), (645, 737), (667, 668), (675, 676), (770, 774), (764, 765), (772, 773), (617, 618), (681, 682), (626, 627), (654, 655), (754, 755), (619, 620), (627, 628), (695, 696), (747, 748), (752, 753), (755, 756), (763, 764), (768, 769), (628, 632), (621, 622), (629, 630), (685, 686), (693, 694), (657, 728), (620, 638), (643, 644), (711, 712), (719, 720), (775, 776), (608, 727), (618, 619), (662, 663), (746, 747), (709, 710), (744, 745), (776, 777), (700, 731), (705, 706), (710, 711), (748, 749), (756, 757), (728, 760), (615, 616), (623, 624), (731, 732), (739, 740), (607, 715), (713, 714), (702, 703), (718, 719), (659, 660), (651, 652), (727, 728), (734, 748), (602, 603), (678, 679), (730, 731), (664, 722), (717, 718), (725, 726), (691, 750), (658, 698), (728, 729), (761, 762), (650, 665), (699, 700), (681, 774), (694, 695), (726, 727), (732, 733), (740, 741), (765, 766), (610, 611), (670, 671), (686, 687), (722, 723), (738, 739), (607, 608), (767, 768), (717, 736), (720, 721), (736, 737), (753, 754), (607, 637), (747, 767), (712, 724), (632, 633), (665, 666), (679, 680), (687, 688), (636, 637), (644, 645), (669, 670), (677, 678), (679, 717), (745, 746), (638, 639), (642, 643), (766, 767), (770, 771), (664, 770), (631, 632), (683, 684), (691, 692), (759, 760), (673, 674), (624, 625), (640, 641), (657, 658), (696, 703), (749, 750), (757, 758), (691, 726), (647, 648), (655, 656), (707, 708), (771, 772), (777, 780), (630, 631), (650, 651), (758, 759), (778, 779), (645, 646), (773, 774), (665, 760), (616, 617), (648, 649), (628, 743), (752, 755), (729, 771), (671, 672), (703, 704), (641, 642), (769, 770), (698, 699), (620, 621), (628, 629), (652, 653), (660, 661), (687, 766), (778, 780), (696, 697), (729, 730), (602, 766), (611, 612), (603, 604), (743, 744), (751, 752), (605, 606), (613, 614), (700, 701), (708, 709), (733, 734), (741, 742), (638, 713), (649, 650), (777, 778), (690, 691), (706, 707), (708, 739), (663, 664), (715, 716), (723, 724), (779, 780), (609, 610), (688, 689), (704, 705), (721, 722), (614, 615), (666, 667), (737, 738), (742, 743), (653, 654), (661, 662), (633, 634), (664, 665), (697, 698), (620, 628), (623, 776), (635, 636), (866, 870), (822, 823), (854, 855), (860, 861), (868, 869), (808, 809), (840, 841), (849, 866), (786, 787), (802, 803), (862, 863), (878, 879), (867, 883), (817, 846), (877, 885), (848, 849), (864, 865), (881, 882), (800, 832), (890, 891), (840, 877), (812, 813), (820, 821), (844, 845), (852, 853), (793, 794), (875, 882), (795, 796), (803, 804), (827, 865), (790, 886), (797, 798), (805, 806), (873, 874), (782, 783), (882, 883), (821, 880), (823, 824), (875, 876), (883, 884), (785, 786), (801, 802), (877, 878), (885, 886), (862, 872), (833, 850), (844, 855), (835, 836), (783, 784), (790, 791), (874, 875), (837, 838), (808, 819), (861, 890), (833, 834), (856, 883), (826, 827), (788, 789), (782, 824), (807, 863), (871, 872), (879, 880), (842, 863), (806, 809), (841, 842), (818, 819), (834, 835), (817, 886), (843, 844), (791, 792), (851, 852), (794, 847), (806, 807), (858, 859), (845, 846), (853, 854), (782, 793), (792, 793), (825, 826), (827, 828), (810, 811), (842, 843), (796, 797), (804, 805), (829, 830), (819, 839), (844, 890), (877, 890), (798, 799), (814, 815), (850, 851), (866, 867), (880, 890), (863, 864), (828, 883), (784, 785), (800, 801), (817, 818), (802, 811), (877, 880), (840, 852), (888, 889), (842, 854), (807, 808), (815, 816), (882, 886), (842, 871), (809, 810), (811, 812), (819, 820), (887, 888), (880, 881), (886, 889), (813, 814), (821, 822), (839, 840), (847, 848), (881, 883), (886, 887), (787, 809), (856, 891), (872, 873), (818, 883), (868, 889), (799, 800), (831, 832), (838, 839), (876, 877), (884, 885), (864, 877), (824, 825), (857, 858), (859, 860), (867, 868), (792, 853), (850, 874), (858, 865), (828, 829), (836, 837), (861, 862), (869, 870), (888, 890), (830, 831), (846, 847), (881, 889), (855, 856), (787, 788), (816, 817), (832, 833), (849, 850), (865, 866), (794, 795), (870, 871), (789, 859), (781, 782), (789, 790), (867, 884), (856, 857), (889, 890), (800, 848), (849, 889), (879, 882), (799, 832)]],
    'out': 6
  },
  {
    'name': 'Graph 748 vertices 1241 edges',
    'in': [748, [(10, 11), (22, 23), (42, 43), (54, 55), (5, 6), (28, 29), (36, 37), (8, 9), (15, 16), (40, 41), (18, 19), (30, 31), (34, 35), (46, 47), (31, 32), (1, 2), (16, 17), (32, 33), (49, 50), (6, 7), (51, 52), (12, 13), (20, 21), (44, 45), (52, 53), (25, 26), (56, 57), (3, 4), (27, 28), (35, 36), (39, 40), (47, 48), (4, 5), (29, 30), (37, 38), (35, 43), (55, 56), (9, 10), (41, 42), (2, 3), (14, 15), (50, 51), (11, 12), (19, 20), (23, 24), (43, 44), (0, 1), (17, 18), (33, 34), (48, 49), (26, 27), (38, 39), (13, 14), (21, 22), (45, 46), (53, 54), (24, 25), (15, 40), (7, 8), (9, 12), (131, 143), (86, 87), (92, 93), (100, 101), (125, 126), (108, 134), (72, 73), (94, 95), (110, 111), (120, 129), (127, 128), (80, 81), (96, 97), (113, 114), (144, 145), (134, 135), (122, 123), (76, 77), (84, 85), (61, 85), (66, 87), (98, 131), (122, 132), (109, 120), (105, 106), (114, 115), (142, 143), (115, 116), (107, 108), (130, 145), (116, 144), (102, 125), (109, 110), (117, 118), (138, 142), (85, 133), (128, 137), (131, 132), (67, 68), (106, 107), (69, 70), (73, 101), (134, 142), (65, 66), (58, 59), (74, 117), (127, 131), (63, 85), (103, 104), (111, 112), (90, 142), (124, 139), (131, 141), (83, 125), (73, 74), (66, 67), (75, 76), (83, 84), (139, 140), (90, 91), (77, 78), (85, 86), (64, 83), (76, 94), (63, 116), (59, 60), (108, 137), (74, 75), (96, 143), (61, 62), (82, 83), (98, 99), (95, 96), (92, 99), (120, 121), (113, 117), (59, 139), (94, 121), (72, 132), (124, 125), (132, 133), (111, 134), (126, 127), (130, 131), (129, 137), (64, 131), (119, 120), (112, 113), (128, 129), (100, 135), (105, 129), (106, 125), (120, 128), (79, 80), (71, 72), (135, 136), (143, 144), (137, 140), (73, 109), (118, 119), (138, 139), (64, 84), (133, 134), (104, 105), (136, 137), (118, 135), (63, 64), (62, 109), (129, 130), (70, 71), (107, 132), (108, 109), (116, 117), (140, 141), (89, 90), (91, 92), (99, 100), (94, 135), (115, 117), (102, 105), (60, 61), (68, 69), (93, 94), (101, 102), (137, 138), (92, 111), (62, 63), (78, 79), (97, 125), (134, 140), (87, 88), (64, 65), (81, 82), (97, 98), (62, 90), (102, 103), (141, 142), (78, 100), (76, 134), (88, 89), (121, 122), (78, 85), (123, 124), (150, 151), (156, 157), (164, 165), (150, 154), (148, 157), (146, 147), (158, 159), (162, 163), (159, 160), (160, 161), (148, 149), (154, 157), (157, 159), (153, 154), (163, 164), (155, 156), (148, 155), (148, 150), (157, 158), (152, 163), (151, 152), (147, 148), (157, 165), (161, 162), (154, 155), (149, 150), (158, 163), (152, 153), (161, 165), (151, 155), (356, 357), (222, 223), (290, 291), (227, 316), (179, 341), (336, 337), (275, 296), (176, 234), (300, 301), (332, 333), (281, 282), (241, 323), (283, 284), (270, 271), (243, 244), (273, 274), (181, 182), (275, 305), (328, 359), (247, 268), (271, 272), (323, 324), (183, 261), (325, 326), (244, 277), (198, 199), (244, 245), (192, 229), (240, 282), (223, 227), (305, 333), (227, 228), (200, 238), (342, 354), (300, 313), (201, 202), (329, 330), (190, 191), (322, 323), (323, 339), (339, 340), (257, 309), (205, 206), (341, 342), (188, 342), (313, 314), (212, 348), (271, 338), (315, 316), (312, 329), (182, 183), (214, 215), (263, 303), (228, 229), (176, 264), (175, 320), (271, 358), (174, 175), (226, 227), (302, 303), (354, 355), (351, 352), (305, 306), (337, 362), (170, 262), (244, 303), (167, 168), (295, 296), (268, 270), (193, 251), (297, 298), (299, 300), (300, 303), (271, 277), (322, 335), (195, 196), (335, 336), (290, 356), (325, 357), (347, 348), (349, 350), (201, 336), (194, 195), (334, 335), (211, 212), (286, 347), (192, 193), (320, 321), (358, 359), (185, 186), (234, 315), (251, 252), (263, 321), (189, 190), (348, 349), (207, 212), (286, 297), (350, 351), (264, 346), (177, 178), (254, 315), (207, 280), (180, 226), (248, 249), (355, 360), (179, 291), (252, 253), (260, 261), (169, 170), (361, 362), (235, 236), (183, 184), (311, 312), (240, 241), (256, 257), (173, 174), (346, 351), (172, 362), (263, 264), (277, 346), (232, 233), (236, 237), (276, 277), (219, 220), (359, 360), (188, 358), (244, 304), (321, 344), (279, 280), (331, 332), (333, 334), (336, 354), (216, 217), (229, 348), (236, 335), (220, 221), (292, 293), (208, 322), (208, 209), (288, 289), (207, 335), (167, 192), (322, 351), (241, 331), (217, 314), (325, 341), (208, 351), (245, 246), (262, 352), (259, 260), (327, 328), (266, 267), (261, 262), (257, 258), (239, 240), (196, 197), (275, 302), (251, 263), (191, 278), (203, 204), (275, 276), (343, 344), (353, 354), (225, 226), (282, 283), (277, 278), (238, 336), (238, 239), (274, 275), (223, 224), (352, 353), (250, 251), (262, 263), (260, 275), (180, 181), (212, 213), (258, 283), (237, 341), (227, 356), (293, 294), (242, 243), (289, 290), (249, 331), (211, 347), (201, 234), (177, 250), (207, 208), (293, 350), (234, 235), (278, 279), (313, 316), (193, 194), (321, 322), (314, 315), (268, 269), (271, 326), (188, 313), (182, 197), (246, 297), (206, 207), (306, 307), (316, 359), (166, 167), (218, 219), (294, 295), (346, 347), (205, 219), (249, 250), (280, 343), (264, 314), (173, 213), (298, 299), (330, 331), (253, 254), (284, 285), (220, 354), (210, 211), (286, 287), (338, 339), (241, 242), (244, 278), (166, 222), (247, 323), (185, 239), (265, 346), (193, 333), (233, 234), (306, 338), (179, 180), (247, 248), (237, 238), (309, 310), (203, 326), (183, 207), (186, 187), (326, 327), (184, 185), (312, 313), (231, 232), (188, 189), (229, 230), (324, 325), (178, 179), (318, 319), (267, 268), (176, 177), (304, 305), (310, 354), (269, 270), (200, 285), (317, 357), (170, 171), (202, 203), (310, 311), (342, 343), (339, 357), (168, 169), (200, 201), (296, 297), (328, 329), (322, 332), (323, 358), (191, 320), (359, 361), (260, 349), (286, 335), (172, 173), (204, 205), (308, 309), (340, 341), (245, 310), (291, 292), (285, 286), (235, 241), (341, 352), (251, 333), (285, 332), (199, 200), (197, 198), (248, 336), (264, 265), (345, 352), (234, 236), (271, 351), (187, 327), (229, 276), (202, 302), (215, 216), (211, 351), (213, 214), (280, 281), (311, 315), (187, 188), (191, 210), (284, 336), (317, 318), (335, 340), (350, 361), (267, 296), (183, 296), (255, 256), (224, 225), (272, 273), (168, 345), (306, 322), (235, 291), (189, 207), (175, 176), (303, 304), (254, 255), (258, 259), (348, 352), (171, 172), (307, 308), (301, 302), (246, 247), (360, 361), (217, 270), (190, 304), (191, 192), (287, 288), (319, 320), (217, 218), (345, 346), (321, 330), (355, 356), (173, 202), (221, 222), (316, 317), (357, 358), (266, 295), (265, 266), (337, 338), (209, 210), (230, 231), (325, 330), (176, 322), (328, 351), (344, 345), (268, 310), (374, 375), (382, 384), (381, 382), (366, 371), (367, 384), (366, 367), (375, 378), (381, 387), (384, 387), (383, 384), (369, 370), (385, 386), (374, 387), (378, 379), (370, 386), (364, 365), (372, 373), (365, 377), (378, 384), (372, 382), (376, 377), (368, 379), (367, 368), (372, 379), (380, 381), (382, 386), (376, 378), (370, 371), (382, 383), (386, 387), (377, 386), (375, 376), (371, 372), (363, 364), (368, 369), (384, 385), (365, 366), (373, 374), (363, 386), (377, 378), (372, 380), (363, 377), (379, 380), (384, 386), (426, 427), (412, 413), (420, 421), (445, 446), (424, 425), (402, 403), (418, 419), (399, 403), (400, 401), (416, 417), (433, 434), (390, 391), (428, 429), (436, 437), (403, 416), (411, 412), (419, 420), (430, 446), (425, 426), (398, 399), (406, 423), (439, 440), (398, 433), (441, 446), (429, 430), (437, 438), (402, 420), (418, 432), (406, 407), (442, 446), (416, 424), (408, 435), (426, 434), (390, 442), (425, 430), (395, 443), (403, 404), (395, 396), (390, 432), (409, 412), (422, 423), (389, 391), (428, 446), (443, 444), (399, 411), (438, 439), (392, 428), (402, 432), (427, 439), (414, 415), (430, 431), (434, 444), (403, 439), (398, 435), (409, 410), (423, 424), (431, 432), (398, 407), (411, 416), (388, 389), (413, 414), (421, 422), (415, 443), (400, 403), (410, 435), (427, 428), (435, 436), (401, 402), (417, 418), (406, 431), (412, 442), (391, 392), (399, 400), (394, 395), (389, 390), (392, 393), (439, 442), (403, 417), (415, 416), (418, 423), (442, 443), (396, 397), (404, 405), (440, 441), (405, 422), (414, 437), (399, 409), (444, 445), (393, 394), (434, 435), (433, 441), (407, 408), (432, 433), (410, 411), (397, 398), (405, 406), (426, 432), (421, 434), (408, 409), (441, 442), (392, 423), (505, 509), (471, 499), (458, 459), (456, 457), (478, 479), (494, 495), (470, 488), (451, 455), (479, 480), (506, 507), (460, 461), (468, 469), (504, 505), (469, 493), (473, 490), (508, 509), (477, 500), (506, 508), (480, 496), (498, 499), (462, 468), (491, 492), (499, 500), (496, 497), (487, 500), (469, 477), (477, 503), (463, 464), (455, 456), (480, 509), (490, 491), (453, 454), (488, 489), (465, 504), (483, 489), (449, 450), (454, 455), (492, 493), (500, 501), (490, 492), (447, 463), (485, 494), (475, 476), (483, 484), (467, 491), (482, 509), (457, 458), (493, 508), (461, 487), (462, 463), (487, 496), (471, 472), (474, 475), (467, 486), (461, 462), (469, 470), (472, 473), (505, 506), (466, 477), (475, 497), (495, 498), (469, 495), (470, 471), (476, 477), (484, 485), (462, 498), (466, 467), (482, 483), (464, 465), (480, 481), (497, 498), (471, 484), (484, 501), (456, 485), (497, 509), (489, 490), (503, 504), (507, 509), (451, 495), (493, 494), (501, 502), (504, 507), (470, 497), (451, 452), (459, 492), (467, 500), (502, 503), (499, 502), (447, 448), (465, 499), (473, 474), (453, 501), (482, 495), (487, 488), (495, 496), (491, 493), (452, 453), (477, 478), (485, 486), (454, 500), (450, 451), (459, 460), (467, 468), (448, 449), (465, 466), (481, 482), (450, 509), (486, 487), (495, 503), (492, 495), (497, 508), (491, 509), (454, 497), (507, 508), (566, 567), (598, 599), (637, 638), (668, 669), (615, 646), (643, 661), (552, 553), (584, 585), (640, 683), (530, 531), (527, 583), (686, 701), (672, 673), (556, 557), (588, 589), (692, 693), (583, 653), (547, 614), (682, 694), (541, 542), (548, 624), (617, 618), (587, 609), (567, 568), (619, 620), (529, 530), (606, 667), (621, 622), (693, 694), (673, 688), (579, 580), (527, 528), (573, 669), (682, 689), (581, 582), (592, 680), (675, 702), (597, 611), (674, 682), (516, 543), (631, 656), (698, 704), (696, 706), (553, 658), (615, 616), (583, 665), (562, 563), (702, 703), (657, 698), (595, 596), (597, 598), (606, 611), (573, 574), (670, 671), (629, 683), (511, 512), (561, 562), (632, 633), (685, 701), (559, 560), (621, 694), (679, 693), (664, 679), (636, 637), (644, 645), (525, 593), (638, 639), (642, 643), (657, 658), (692, 695), (557, 558), (510, 648), (583, 584), (515, 516), (655, 656), (650, 651), (517, 518), (616, 617), (543, 544), (575, 576), (641, 642), (563, 582), (620, 621), (660, 661), (632, 699), (692, 702), (695, 697), (511, 540), (580, 581), (649, 650), (690, 691), (531, 532), (599, 600), (593, 594), (688, 689), (666, 667), (533, 534), (547, 554), (600, 601), (618, 628), (666, 687), (568, 616), (604, 605), (676, 677), (592, 673), (606, 607), (674, 675), (639, 640), (608, 609), (612, 650), (689, 690), (547, 578), (564, 565), (596, 597), (644, 664), (667, 668), (549, 550), (615, 633), (626, 627), (600, 620), (627, 628), (598, 671), (621, 640), (629, 630), (605, 631), (586, 613), (659, 666), (524, 525), (552, 639), (596, 637), (675, 701), (528, 622), (623, 624), (652, 661), (537, 619), (699, 700), (540, 541), (564, 679), (542, 543), (594, 595), (607, 608), (528, 529), (600, 702), (529, 545), (698, 703), (610, 674), (613, 676), (590, 624), (510, 511), (514, 515), (683, 684), (565, 566), (641, 658), (598, 705), (591, 592), (522, 523), (527, 659), (513, 514), (628, 629), (598, 617), (702, 706), (521, 522), (547, 671), (597, 649), (574, 575), (639, 682), (560, 561), (549, 702), (538, 539), (616, 673), (612, 613), (660, 683), (520, 575), (546, 547), (663, 676), (625, 626), (656, 657), (646, 647), (537, 538), (539, 540), (675, 676), (531, 562), (516, 517), (681, 706), (573, 619), (654, 655), (679, 701), (547, 558), (545, 546), (634, 694), (519, 688), (628, 676), (595, 628), (662, 663), (705, 706), (570, 571), (532, 533), (644, 674), (694, 700), (616, 662), (598, 659), (578, 579), (651, 652), (678, 679), (569, 570), (571, 572), (575, 577), (541, 593), (554, 555), (586, 587), (694, 695), (548, 549), (686, 687), (664, 706), (611, 686), (576, 630), (590, 618), (620, 665), (680, 692), (665, 666), (523, 608), (679, 680), (678, 688), (559, 666), (669, 670), (553, 554), (603, 651), (555, 556), (691, 692), (624, 625), (673, 674), (646, 671), (645, 685), (630, 631), (630, 650), (698, 699), (601, 602), (696, 697), (524, 575), (603, 604), (599, 625), (605, 606), (700, 701), (598, 618), (704, 705), (609, 610), (614, 615), (653, 654), (697, 698), (682, 683), (701, 702), (680, 681), (617, 682), (622, 623), (658, 659), (592, 593), (518, 519), (634, 635), (684, 685), (547, 548), (631, 680), (681, 682), (526, 527), (632, 674), (551, 573), (695, 696), (554, 706), (512, 513), (553, 602), (612, 678), (685, 686), (533, 577), (555, 604), (605, 612), (519, 520), (643, 644), (534, 535), (618, 619), (550, 586), (560, 605), (548, 558), (520, 521), (577, 578), (525, 566), (639, 677), (565, 567), (585, 586), (535, 536), (587, 588), (659, 660), (550, 551), (602, 603), (552, 589), (589, 590), (674, 705), (536, 537), (681, 702), (520, 636), (515, 634), (593, 699), (667, 705), (592, 703), (558, 559), (610, 611), (544, 545), (613, 628), (545, 680), (629, 689), (551, 552), (687, 688), (677, 678), (540, 617), (596, 638), (543, 630), (563, 564), (631, 632), (640, 641), (647, 648), (525, 545), (645, 646), (648, 649), (584, 670), (622, 628), (671, 672), (703, 704), (582, 583), (652, 653), (639, 644), (653, 676), (568, 569), (635, 706), (611, 612), (641, 664), (572, 573), (613, 614), (541, 576), (590, 591), (523, 524), (663, 664), (576, 577), (525, 526), (661, 662), (633, 634), (664, 665), (635, 636), (714, 715), (726, 727), (746, 747), (734, 736), (709, 710), (732, 733), (740, 741), (719, 736), (723, 741), (712, 713), (744, 745), (722, 723), (734, 735), (738, 739), (733, 739), (735, 736), (720, 721), (736, 737), (710, 711), (742, 744), (740, 742), (716, 717), (724, 725), (730, 733), (713, 744), (719, 739), (717, 720), (729, 730), (727, 739), (724, 743), (745, 747), (716, 721), (731, 732), (739, 740), (743, 744), (727, 729), (714, 739), (725, 730), (708, 709), (733, 734), (741, 742), (713, 714), (745, 746), (718, 719), (723, 739), (732, 736), (743, 747), (715, 716), (723, 724), (727, 728), (721, 722), (737, 738), (730, 731), (742, 743), (717, 718), (725, 726), (711, 743), (719, 720), (728, 729), (717, 722), (714, 724), (707, 708), (715, 719), (711, 712)]],
    'out': 9
  },
  {
    'name': 'Graph 724 vertices 1056 edges',
    'in': [724, [(54, 55), (86, 87), (170, 171), (92, 93), (100, 101), (125, 126), (156, 157), (164, 165), (40, 41), (72, 73), (168, 169), (18, 19), (34, 35), (94, 95), (110, 111), (146, 147), (162, 163), (127, 128), (80, 81), (96, 97), (113, 114), (144, 145), (6, 7), (122, 123), (134, 135), (160, 161), (44, 45), (52, 53), (76, 77), (84, 85), (172, 173), (180, 181), (25, 26), (27, 28), (35, 36), (155, 156), (163, 164), (4, 5), (29, 30), (37, 38), (105, 106), (169, 170), (14, 15), (114, 115), (142, 143), (55, 56), (107, 108), (115, 116), (183, 184), (0, 1), (17, 18), (33, 34), (181, 185), (109, 110), (117, 118), (173, 174), (181, 182), (15, 16), (67, 68), (7, 8), (131, 132), (22, 23), (106, 107), (150, 151), (69, 70), (8, 9), (65, 66), (58, 59), (12, 13), (20, 21), (103, 104), (111, 112), (73, 74), (50, 51), (66, 67), (75, 76), (23, 24), (83, 84), (139, 140), (147, 148), (38, 39), (90, 91), (166, 167), (77, 78), (85, 86), (24, 25), (57, 58), (59, 60), (42, 43), (74, 75), (182, 183), (28, 29), (36, 37), (61, 62), (30, 31), (46, 47), (82, 83), (98, 99), (158, 159), (174, 175), (95, 96), (16, 17), (32, 33), (49, 50), (120, 121), (153, 154), (39, 40), (47, 48), (167, 168), (175, 176), (124, 125), (132, 133), (157, 158), (165, 166), (41, 42), (2, 3), (126, 127), (130, 131), (51, 52), (43, 44), (119, 120), (171, 172), (112, 113), (128, 129), (145, 146), (161, 162), (179, 180), (45, 46), (53, 54), (3, 4), (71, 72), (79, 80), (135, 136), (143, 144), (10, 11), (118, 119), (138, 139), (5, 6), (133, 134), (104, 105), (136, 137), (31, 32), (63, 64), (159, 160), (1, 2), (129, 130), (70, 71), (108, 109), (116, 117), (140, 141), (148, 149), (16, 62), (56, 57), (89, 90), (177, 178), (184, 185), (91, 92), (99, 100), (60, 61), (68, 69), (93, 94), (101, 102), (9, 10), (137, 138), (62, 63), (78, 79), (178, 179), (11, 12), (19, 20), (87, 88), (151, 152), (48, 49), (64, 65), (81, 82), (97, 98), (26, 27), (102, 103), (154, 155), (176, 177), (13, 14), (21, 22), (141, 142), (149, 150), (88, 89), (121, 122), (152, 153), (185, 186), (123, 124), (202, 203), (189, 200), (189, 190), (197, 198), (200, 201), (191, 192), (197, 200), (193, 194), (198, 199), (200, 202), (199, 202), (195, 196), (188, 189), (196, 197), (198, 203), (201, 202), (190, 191), (194, 195), (193, 201), (192, 197), (199, 201), (192, 193), (187, 188), (189, 201), (197, 199), (199, 200), (249, 253), (234, 263), (222, 223), (238, 239), (223, 224), (253, 273), (250, 251), (262, 263), (204, 205), (212, 213), (248, 249), (240, 244), (214, 230), (252, 253), (260, 261), (265, 272), (242, 243), (270, 271), (235, 236), (243, 244), (240, 241), (256, 257), (248, 264), (244, 259), (253, 260), (252, 268), (263, 264), (271, 272), (207, 208), (234, 235), (242, 261), (232, 233), (264, 265), (204, 254), (236, 237), (244, 245), (268, 269), (269, 272), (234, 251), (219, 220), (227, 228), (233, 269), (236, 242), (206, 207), (215, 216), (218, 219), (205, 206), (213, 214), (247, 252), (216, 217), (249, 250), (238, 247), (235, 240), (214, 215), (220, 221), (228, 229), (253, 254), (261, 269), (210, 211), (226, 227), (267, 270), (216, 267), (255, 256), (208, 209), (224, 225), (241, 242), (272, 273), (204, 236), (257, 270), (221, 223), (260, 269), (226, 259), (209, 264), (210, 227), (238, 263), (244, 267), (233, 234), (254, 255), (258, 259), (213, 229), (244, 262), (247, 248), (237, 238), (245, 246), (214, 263), (259, 260), (246, 247), (266, 267), (228, 265), (261, 262), (228, 260), (255, 268), (213, 267), (257, 258), (215, 261), (217, 218), (231, 232), (239, 240), (239, 273), (258, 272), (210, 249), (239, 258), (221, 222), (229, 230), (229, 243), (265, 266), (211, 212), (267, 268), (271, 273), (209, 210), (225, 226), (230, 231), (269, 270), (236, 250), (233, 254), (216, 224), (251, 252), (310, 311), (342, 343), (344, 370), (348, 349), (356, 357), (320, 334), (296, 297), (328, 329), (274, 275), (290, 291), (350, 351), (366, 367), (367, 369), (336, 337), (352, 353), (369, 370), (300, 301), (308, 309), (332, 333), (340, 341), (351, 367), (281, 282), (283, 284), (291, 292), (297, 364), (324, 348), (285, 286), (293, 294), (341, 343), (350, 354), (312, 314), (342, 366), (361, 362), (350, 369), (370, 371), (310, 358), (311, 312), (363, 364), (371, 372), (289, 290), (286, 353), (286, 314), (365, 366), (303, 361), (332, 343), (323, 324), (278, 279), (362, 363), (325, 326), (335, 351), (321, 322), (314, 315), (276, 277), (317, 350), (359, 360), (367, 368), (355, 363), (329, 330), (306, 307), (322, 323), (339, 340), (279, 280), (331, 332), (346, 347), (294, 295), (292, 358), (324, 360), (333, 334), (341, 342), (325, 371), (280, 281), (313, 314), (353, 357), (315, 316), (275, 319), (332, 367), (298, 299), (330, 331), (284, 285), (292, 293), (317, 318), (286, 330), (286, 287), (302, 303), (338, 339), (354, 355), (351, 352), (333, 352), (288, 289), (305, 306), (330, 369), (357, 359), (347, 371), (320, 364), (295, 296), (303, 304), (297, 298), (285, 324), (299, 300), (307, 308), (368, 369), (301, 302), (309, 310), (344, 369), (339, 369), (341, 363), (327, 328), (335, 336), (316, 350), (277, 310), (284, 330), (277, 291), (360, 361), (312, 343), (305, 368), (287, 288), (319, 320), (326, 327), (364, 365), (312, 313), (345, 346), (337, 343), (349, 367), (347, 348), (355, 356), (337, 356), (363, 365), (316, 317), (324, 325), (349, 350), (357, 358), (369, 372), (348, 367), (318, 319), (334, 335), (342, 362), (275, 276), (343, 344), (304, 305), (320, 321), (337, 338), (353, 354), (282, 283), (358, 359), (338, 352), (277, 278), (344, 345), (343, 372), (314, 326), (368, 370), (318, 333), (384, 385), (385, 386), (387, 388), (374, 375), (378, 379), (379, 380), (373, 374), (380, 381), (381, 382), (388, 389), (376, 377), (377, 378), (382, 383), (386, 387), (375, 376), (383, 384), (400, 401), (394, 395), (390, 391), (393, 399), (396, 397), (397, 398), (399, 400), (392, 393), (393, 394), (395, 396), (398, 399), (391, 392), (471, 574), (518, 521), (426, 427), (458, 459), (566, 567), (559, 566), (424, 425), (456, 457), (552, 553), (494, 495), (530, 531), (479, 480), (553, 569), (452, 490), (436, 437), (468, 469), (556, 557), (419, 420), (482, 498), (541, 542), (567, 568), (529, 530), (461, 574), (463, 464), (527, 528), (475, 494), (461, 536), (427, 515), (527, 548), (516, 549), (489, 504), (444, 459), (497, 575), (462, 463), (562, 563), (501, 529), (434, 576), (502, 560), (505, 506), (573, 574), (477, 483), (413, 516), (511, 512), (497, 498), (561, 562), (526, 572), (530, 579), (431, 432), (559, 560), (447, 509), (489, 490), (543, 571), (547, 572), (435, 436), (503, 504), (422, 445), (557, 558), (497, 515), (515, 516), (517, 518), (469, 545), (533, 547), (545, 563), (528, 536), (415, 416), (447, 448), (543, 544), (575, 576), (422, 521), (548, 550), (404, 405), (473, 474), (483, 531), (436, 562), (487, 488), (440, 455), (444, 445), (485, 486), (502, 517), (416, 529), (531, 532), (465, 466), (520, 546), (533, 534), (408, 409), (555, 559), (420, 421), (418, 419), (458, 482), (482, 508), (495, 567), (428, 429), (460, 461), (564, 565), (478, 552), (411, 412), (549, 550), (499, 500), (469, 550), (455, 456), (453, 454), (546, 554), (479, 492), (551, 553), (500, 501), (524, 525), (483, 484), (457, 458), (529, 534), (575, 578), (470, 490), (471, 472), (403, 404), (511, 554), (522, 575), (487, 544), (436, 440), (469, 470), (550, 554), (521, 535), (490, 577), (443, 444), (430, 453), (484, 485), (540, 541), (430, 431), (482, 483), (542, 543), (491, 525), (480, 481), (528, 529), (409, 410), (549, 571), (423, 424), (472, 533), (421, 422), (441, 454), (510, 511), (514, 515), (458, 480), (427, 428), (565, 566), (573, 576), (483, 573), (473, 578), (451, 452), (508, 531), (502, 503), (522, 523), (513, 514), (501, 512), (538, 570), (484, 554), (477, 478), (564, 578), (521, 522), (491, 567), (450, 451), (574, 575), (467, 468), (448, 449), (560, 561), (486, 487), (538, 539), (562, 571), (441, 442), (498, 531), (479, 512), (507, 508), (412, 413), (543, 556), (478, 479), (546, 547), (433, 434), (537, 538), (539, 540), (420, 552), (508, 509), (516, 517), (425, 426), (439, 440), (491, 492), (545, 546), (553, 557), (437, 438), (518, 579), (433, 534), (559, 576), (500, 563), (574, 577), (454, 455), (570, 571), (492, 493), (532, 533), (544, 557), (546, 559), (475, 476), (437, 532), (436, 524), (536, 540), (446, 447), (578, 579), (461, 462), (474, 544), (539, 550), (569, 570), (540, 545), (571, 572), (495, 524), (438, 439), (470, 471), (554, 555), (476, 477), (548, 549), (515, 522), (436, 495), (413, 414), (553, 554), (466, 509), (555, 556), (501, 502), (459, 543), (424, 548), (439, 442), (521, 570), (402, 510), (424, 555), (407, 408), (459, 460), (481, 482), (410, 411), (405, 406), (451, 456), (546, 557), (506, 523), (551, 558), (484, 531), (445, 446), (425, 496), (555, 577), (402, 403), (413, 504), (418, 430), (416, 417), (506, 507), (518, 519), (559, 568), (504, 562), (514, 554), (504, 505), (479, 557), (537, 578), (547, 548), (511, 561), (498, 499), (526, 527), (425, 505), (416, 450), (496, 497), (512, 513), (429, 430), (455, 522), (519, 520), (479, 554), (406, 407), (490, 491), (534, 535), (541, 552), (452, 475), (444, 488), (488, 489), (520, 521), (461, 564), (449, 450), (577, 578), (561, 574), (539, 566), (537, 554), (431, 436), (535, 536), (422, 423), (474, 475), (550, 551), (472, 473), (536, 537), (509, 510), (564, 573), (572, 578), (412, 495), (414, 415), (466, 467), (558, 559), (408, 450), (480, 510), (464, 465), (544, 545), (446, 515), (551, 552), (441, 465), (419, 427), (433, 493), (563, 564), (431, 527), (417, 418), (493, 494), (535, 558), (445, 475), (409, 574), (554, 561), (500, 509), (415, 525), (562, 565), (442, 443), (440, 441), (568, 569), (488, 542), (495, 496), (522, 551), (452, 453), (572, 573), (451, 478), (434, 435), (460, 574), (523, 524), (576, 577), (432, 433), (425, 526), (525, 526), (483, 507), (598, 599), (682, 683), (714, 715), (604, 605), (612, 613), (637, 638), (668, 669), (676, 677), (701, 702), (693, 712), (584, 585), (680, 681), (712, 713), (606, 607), (622, 623), (658, 659), (674, 675), (639, 640), (592, 711), (592, 593), (608, 609), (625, 626), (656, 657), (634, 635), (646, 647), (672, 673), (689, 690), (588, 589), (596, 597), (684, 685), (692, 693), (716, 717), (655, 697), (583, 626), (660, 701), (630, 644), (607, 685), (647, 703), (623, 654), (667, 668), (675, 676), (675, 716), (617, 618), (681, 682), (626, 627), (654, 655), (627, 694), (619, 620), (627, 628), (695, 696), (644, 669), (631, 689), (621, 622), (629, 630), (685, 686), (693, 694), (675, 692), (702, 707), (614, 661), (622, 723), (700, 705), (643, 644), (711, 712), (719, 720), (674, 688), (618, 619), (662, 663), (581, 582), (709, 710), (639, 718), (633, 659), (693, 705), (675, 691), (612, 694), (705, 706), (710, 711), (704, 719), (615, 616), (623, 624), (620, 687), (637, 656), (653, 684), (585, 586), (713, 714), (648, 723), (702, 703), (718, 719), (588, 618), (692, 719), (587, 588), (595, 596), (651, 652), (659, 660), (587, 711), (605, 679), (602, 603), (678, 679), (589, 590), (597, 598), (717, 718), (656, 674), (699, 710), (688, 694), (714, 718), (633, 674), (699, 700), (586, 587), (694, 695), (691, 711), (586, 653), (644, 676), (607, 655), (699, 720), (594, 595), (610, 611), (670, 671), (686, 687), (722, 723), (711, 715), (607, 608), (647, 695), (689, 718), (635, 668), (720, 721), (615, 707), (689, 723), (632, 633), (665, 666), (624, 628), (679, 680), (687, 688), (636, 637), (644, 645), (669, 670), (677, 678), (615, 710), (595, 615), (600, 686), (618, 654), (638, 639), (642, 643), (634, 685), (631, 632), (683, 684), (691, 692), (624, 625), (640, 641), (657, 658), (673, 674), (677, 684), (582, 629), (668, 706), (630, 649), (652, 701), (647, 648), (583, 584), (655, 656), (591, 592), (707, 708), (650, 713), (650, 700), (630, 631), (650, 651), (645, 646), (683, 700), (644, 718), (695, 706), (616, 617), (648, 649), (590, 693), (671, 672), (703, 704), (641, 642), (582, 583), (698, 699), (620, 621), (628, 629), (652, 653), (660, 661), (601, 602), (696, 697), (716, 721), (688, 692), (582, 620), (603, 604), (611, 612), (600, 604), (580, 581), (605, 606), (613, 614), (700, 701), (708, 709), (649, 650), (587, 602), (590, 591), (690, 691), (706, 707), (616, 710), (599, 600), (663, 664), (715, 716), (719, 721), (593, 594), (609, 610), (688, 689), (704, 705), (614, 615), (666, 667), (721, 722), (653, 654), (661, 662), (600, 601), (633, 634), (664, 665), (697, 698), (613, 633), (635, 636)]],
    'out': 8
  },
  {
    'name': 'Graph 744 vertices 999 edges',
    'in': [744, [(10, 11), (22, 23), (42, 43), (54, 55), (5, 6), (28, 29), (36, 37), (10, 42), (46, 55), (8, 9), (15, 16), (40, 41), (18, 19), (30, 31), (34, 35), (46, 47), (19, 55), (31, 32), (1, 2), (16, 17), (32, 33), (49, 50), (6, 7), (44, 52), (51, 52), (12, 13), (20, 21), (44, 45), (52, 53), (25, 26), (37, 46), (3, 4), (27, 28), (35, 36), (39, 40), (47, 48), (18, 35), (4, 5), (29, 30), (37, 38), (3, 23), (35, 43), (32, 39), (55, 56), (9, 10), (41, 42), (51, 56), (2, 3), (14, 15), (50, 51), (11, 12), (19, 20), (23, 24), (43, 44), (0, 1), (17, 18), (33, 34), (48, 49), (26, 27), (38, 39), (13, 14), (21, 22), (45, 46), (53, 54), (24, 25), (7, 8), (86, 87), (170, 171), (92, 93), (100, 101), (125, 126), (156, 157), (164, 165), (72, 73), (168, 169), (94, 95), (110, 111), (146, 147), (162, 163), (127, 128), (80, 81), (96, 97), (113, 114), (144, 145), (122, 123), (134, 135), (160, 161), (177, 178), (76, 77), (84, 85), (172, 173), (155, 156), (163, 164), (105, 106), (169, 170), (114, 115), (142, 143), (115, 116), (107, 108), (109, 110), (117, 118), (173, 174), (131, 132), (67, 68), (106, 107), (150, 151), (69, 70), (65, 66), (58, 59), (103, 104), (111, 112), (73, 74), (66, 67), (75, 76), (83, 84), (139, 140), (147, 148), (90, 91), (166, 167), (77, 78), (85, 86), (57, 58), (59, 60), (74, 75), (61, 62), (82, 83), (98, 99), (158, 159), (174, 175), (95, 96), (120, 121), (153, 154), (167, 168), (175, 176), (165, 169), (124, 125), (132, 133), (157, 158), (165, 166), (126, 127), (130, 131), (119, 120), (171, 172), (112, 113), (128, 129), (145, 146), (161, 162), (79, 80), (71, 72), (135, 136), (143, 144), (118, 119), (138, 139), (133, 134), (104, 105), (136, 137), (63, 64), (159, 160), (129, 130), (70, 71), (108, 109), (116, 117), (140, 141), (148, 149), (89, 90), (91, 92), (99, 100), (60, 61), (68, 69), (93, 94), (101, 102), (137, 138), (62, 63), (78, 79), (178, 179), (87, 88), (151, 152), (64, 65), (81, 82), (97, 98), (176, 177), (102, 103), (154, 155), (141, 142), (149, 150), (88, 89), (121, 122), (152, 153), (168, 178), (123, 124), (241, 296), (202, 203), (310, 311), (189, 190), (200, 201), (296, 297), (222, 223), (238, 239), (274, 275), (290, 291), (223, 224), (250, 251), (262, 263), (312, 317), (212, 280), (180, 181), (204, 205), (212, 213), (300, 301), (308, 309), (224, 243), (248, 249), (281, 282), (289, 306), (283, 284), (291, 292), (207, 300), (252, 253), (260, 261), (285, 286), (293, 294), (246, 268), (309, 318), (242, 243), (270, 271), (213, 272), (243, 244), (183, 184), (235, 236), (311, 312), (240, 241), (256, 257), (273, 274), (289, 290), (206, 254), (181, 182), (254, 305), (256, 298), (215, 314), (293, 321), (207, 208), (199, 200), (263, 264), (271, 272), (250, 307), (234, 235), (278, 279), (266, 298), (197, 198), (240, 285), (220, 259), (205, 251), (232, 233), (264, 265), (226, 258), (193, 194), (198, 199), (314, 315), (236, 237), (244, 245), (268, 269), (276, 277), (222, 291), (214, 220), (219, 220), (227, 228), (212, 281), (212, 214), (232, 278), (284, 316), (201, 202), (260, 314), (290, 310), (190, 191), (206, 207), (306, 307), (189, 239), (215, 216), (279, 280), (218, 219), (294, 295), (259, 278), (205, 206), (213, 214), (216, 217), (249, 250), (280, 281), (313, 314), (187, 188), (315, 316), (319, 321), (182, 183), (214, 215), (298, 299), (220, 221), (228, 229), (253, 254), (284, 285), (292, 293), (317, 318), (200, 277), (267, 296), (215, 309), (210, 211), (226, 227), (286, 287), (302, 303), (210, 222), (255, 256), (226, 251), (208, 209), (224, 225), (241, 242), (272, 273), (288, 289), (305, 306), (279, 292), (196, 201), (311, 318), (249, 274), (192, 257), (285, 321), (279, 320), (243, 289), (295, 296), (303, 304), (300, 309), (183, 286), (184, 208), (233, 234), (297, 298), (254, 255), (258, 259), (254, 313), (247, 248), (299, 300), (307, 308), (237, 238), (245, 246), (301, 302), (309, 310), (285, 301), (195, 196), (259, 260), (246, 247), (266, 267), (261, 262), (248, 305), (191, 192), (287, 288), (319, 320), (204, 232), (257, 258), (296, 312), (186, 187), (184, 185), (217, 218), (312, 313), (231, 232), (239, 240), (278, 280), (188, 189), (196, 197), (221, 222), (229, 230), (316, 317), (216, 240), (263, 301), (265, 266), (274, 295), (194, 195), (318, 319), (294, 305), (203, 204), (211, 212), (267, 268), (275, 276), (192, 193), (209, 210), (225, 226), (304, 305), (230, 231), (282, 283), (320, 321), (297, 321), (269, 270), (277, 278), (197, 305), (182, 205), (214, 239), (185, 186), (247, 321), (297, 307), (251, 252), (342, 343), (426, 427), (458, 459), (374, 470), (348, 349), (356, 357), (381, 382), (412, 413), (420, 421), (445, 446), (388, 411), (335, 387), (328, 329), (424, 425), (456, 457), (364, 452), (350, 351), (366, 367), (402, 403), (418, 419), (368, 409), (383, 384), (326, 334), (336, 337), (352, 353), (369, 370), (400, 401), (378, 379), (390, 391), (416, 417), (433, 434), (332, 333), (340, 341), (428, 429), (436, 437), (460, 461), (468, 469), (411, 440), (368, 445), (465, 472), (346, 382), (411, 412), (419, 420), (419, 441), (418, 469), (355, 458), (361, 362), (425, 426), (402, 445), (467, 472), (370, 371), (398, 399), (363, 364), (371, 372), (439, 440), (368, 387), (414, 442), (352, 373), (445, 467), (365, 366), (373, 374), (429, 430), (437, 438), (376, 454), (354, 375), (385, 422), (434, 456), (331, 402), (387, 388), (323, 324), (455, 456), (463, 464), (406, 469), (362, 363), (406, 407), (365, 387), (325, 326), (453, 454), (394, 436), (365, 417), (334, 404), (333, 341), (449, 450), (422, 435), (401, 421), (454, 455), (417, 461), (330, 440), (429, 436), (447, 469), (359, 360), (367, 368), (394, 450), (424, 451), (424, 470), (329, 330), (457, 458), (400, 443), (369, 450), (322, 323), (446, 447), (462, 463), (442, 453), (380, 423), (395, 396), (331, 332), (339, 340), (403, 404), (471, 472), (346, 347), (422, 423), (449, 470), (375, 402), (333, 334), (341, 342), (461, 462), (469, 470), (448, 467), (360, 459), (401, 414), (322, 426), (472, 473), (439, 451), (395, 416), (439, 460), (443, 444), (366, 424), (412, 435), (330, 331), (438, 439), (470, 471), (447, 466), (446, 471), (396, 473), (420, 471), (338, 339), (354, 355), (414, 415), (430, 431), (466, 467), (356, 394), (351, 352), (464, 465), (365, 368), (376, 377), (409, 410), (371, 408), (358, 407), (381, 409), (381, 452), (423, 424), (431, 432), (346, 441), (380, 381), (388, 389), (413, 414), (421, 422), (353, 462), (382, 383), (386, 387), (436, 454), (375, 376), (427, 428), (435, 436), (368, 369), (384, 385), (401, 402), (417, 418), (373, 417), (388, 410), (376, 472), (391, 392), (335, 336), (327, 328), (399, 400), (451, 452), (394, 395), (374, 375), (389, 390), (384, 398), (351, 401), (360, 361), (392, 393), (416, 465), (443, 458), (396, 420), (377, 468), (409, 431), (415, 416), (447, 448), (385, 386), (326, 327), (442, 443), (364, 365), (372, 373), (396, 397), (404, 405), (345, 346), (440, 441), (323, 433), (347, 348), (355, 356), (350, 472), (456, 463), (398, 445), (370, 471), (424, 431), (324, 325), (349, 350), (357, 358), (444, 445), (452, 453), (450, 468), (352, 359), (393, 394), (383, 411), (334, 335), (434, 435), (450, 451), (342, 362), (343, 344), (407, 408), (459, 460), (467, 468), (337, 338), (353, 354), (432, 433), (448, 449), (358, 359), (410, 411), (465, 466), (463, 465), (397, 398), (405, 406), (329, 405), (383, 463), (344, 345), (377, 378), (408, 409), (441, 442), (384, 452), (410, 455), (379, 380), (490, 491), (502, 503), (495, 505), (476, 477), (484, 485), (509, 510), (480, 492), (488, 489), (478, 479), (482, 483), (494, 495), (479, 480), (511, 512), (480, 481), (497, 498), (506, 507), (504, 509), (492, 493), (500, 501), (504, 505), (477, 513), (483, 484), (487, 488), (475, 476), (495, 496), (477, 478), (485, 486), (508, 509), (489, 490), (498, 499), (510, 511), (502, 513), (491, 492), (499, 500), (503, 504), (492, 502), (481, 482), (496, 497), (512, 513), (474, 475), (486, 487), (493, 494), (501, 502), (505, 506), (475, 482), (507, 508), (535, 563), (566, 567), (598, 599), (604, 605), (612, 613), (552, 619), (552, 553), (584, 585), (530, 531), (546, 547), (606, 607), (622, 623), (592, 593), (608, 609), (625, 626), (518, 519), (556, 557), (564, 565), (588, 589), (596, 597), (550, 618), (575, 613), (537, 538), (539, 540), (547, 548), (614, 624), (516, 517), (541, 542), (549, 550), (599, 619), (617, 618), (526, 527), (626, 627), (521, 594), (567, 568), (619, 620), (627, 628), (529, 530), (545, 546), (621, 622), (552, 566), (548, 623), (532, 594), (522, 598), (579, 580), (527, 528), (519, 520), (528, 587), (534, 535), (618, 619), (533, 602), (581, 582), (520, 521), (522, 577), (577, 578), (570, 571), (524, 525), (532, 533), (589, 625), (615, 616), (623, 624), (585, 608), (585, 586), (562, 563), (578, 579), (616, 625), (587, 588), (535, 536), (595, 596), (550, 551), (602, 603), (589, 590), (597, 598), (536, 537), (569, 570), (571, 572), (554, 555), (586, 587), (603, 628), (540, 541), (548, 549), (573, 574), (533, 573), (542, 543), (558, 559), (594, 595), (610, 611), (607, 608), (528, 529), (544, 545), (561, 562), (620, 625), (527, 551), (551, 552), (559, 560), (527, 603), (597, 616), (553, 554), (514, 515), (567, 620), (555, 556), (563, 564), (624, 625), (557, 558), (565, 566), (583, 584), (515, 516), (591, 592), (522, 523), (517, 518), (616, 617), (543, 544), (575, 576), (585, 601), (602, 620), (535, 595), (582, 583), (620, 621), (551, 614), (568, 569), (601, 602), (603, 604), (611, 612), (572, 573), (580, 581), (605, 606), (613, 614), (521, 522), (574, 575), (590, 591), (523, 524), (531, 532), (599, 600), (538, 620), (560, 561), (576, 577), (593, 594), (609, 610), (538, 539), (614, 615), (582, 617), (584, 588), (525, 526), (533, 534), (600, 601), (703, 742), (682, 683), (714, 715), (637, 638), (668, 669), (676, 677), (701, 702), (680, 681), (712, 713), (645, 697), (658, 659), (674, 675), (734, 735), (677, 704), (639, 640), (735, 736), (656, 657), (672, 673), (689, 690), (634, 635), (646, 647), (695, 720), (684, 685), (692, 693), (716, 717), (724, 725), (690, 732), (667, 668), (675, 676), (728, 743), (709, 743), (681, 682), (637, 641), (654, 655), (695, 696), (634, 699), (709, 720), (629, 630), (685, 686), (693, 694), (675, 715), (652, 670), (655, 691), (643, 644), (711, 712), (719, 720), (715, 720), (662, 663), (716, 736), (709, 710), (643, 703), (659, 717), (705, 706), (710, 711), (709, 716), (632, 730), (676, 706), (639, 734), (731, 732), (739, 740), (681, 710), (657, 742), (669, 704), (713, 714), (702, 703), (718, 719), (685, 722), (651, 652), (659, 660), (727, 728), (669, 700), (678, 679), (730, 731), (717, 718), (725, 726), (728, 729), (664, 685), (656, 696), (699, 700), (694, 695), (726, 727), (732, 733), (740, 741), (708, 722), (705, 721), (670, 671), (686, 687), (722, 723), (738, 739), (689, 718), (648, 730), (720, 721), (736, 737), (632, 633), (665, 666), (654, 725), (665, 706), (679, 680), (687, 688), (632, 669), (636, 637), (644, 645), (669, 670), (677, 678), (649, 700), (638, 639), (642, 643), (673, 736), (691, 692), (631, 632), (683, 684), (640, 641), (657, 658), (673, 674), (696, 704), (647, 648), (655, 656), (707, 708), (679, 739), (630, 631), (650, 651), (729, 735), (645, 646), (673, 685), (648, 649), (736, 741), (671, 672), (703, 704), (641, 642), (698, 699), (691, 701), (652, 653), (660, 661), (676, 709), (696, 697), (729, 730), (687, 700), (678, 692), (737, 743), (666, 742), (700, 701), (708, 709), (733, 734), (741, 742), (659, 730), (649, 650), (676, 730), (690, 691), (706, 707), (634, 742), (663, 664), (715, 716), (723, 724), (688, 689), (704, 705), (721, 722), (737, 738), (666, 667), (742, 743), (653, 654), (661, 662), (709, 711), (713, 727), (633, 634), (664, 665), (697, 698), (730, 738), (729, 737), (675, 711), (728, 736), (635, 636)]],
    'out': 7
  }
]

def generate_test_cases(case_num=10):
  test_cases = []
  for _ in range(case_num):
    vertices = random.randrange(500, 1000)
    edges = []
    components = 0
    vertices_covered = 0
    while vertices_covered < vertices:
      component_size = min(random.randrange(1, 200), vertices - vertices_covered)
      start, end = vertices_covered, vertices_covered + component_size
      # chain all vertices in component
      edges_component = set()
      for i in range(start, end - 1):
        edges_component.add((i, i + 1))
      # add some random edges in component
      for i in range(random.randrange(0, component_size)):
        a = random.randrange(start, end - 1)
        b = random.randrange(a + 1, end)
        edges_component.add((a, b))

      edges.extend(edges_component)
      vertices_covered += component_size
      components += 1

    test_cases.append({
      'name': 'Random Graph {} vertices {} edges'.format(vertices, len(edges)),
      'in': [vertices, edges],
      'out': components
    })
  return test_cases