"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateToDynamoDB = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
const defaults = require("@aws-solutions-constructs/core");
class FargateToDynamoDB extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckFargateProps(props);
        // Other permissions for constructs are accepted as arrays, turning tablePermissions into
        // an array to use the same validation function.
        if (props.tablePermissions) {
            const allowedPermissions = ['ALL', 'READ', 'READWRITE', 'WRITE'];
            defaults.CheckListValues(allowedPermissions, [props.tablePermissions.toUpperCase()], 'tablePermission');
        }
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: { enableDnsHostnames: true, enableDnsSupport: true }
        });
        defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.DYNAMODB);
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            [this.service, this.container] = defaults.CreateFargateService(scope, id, this.vpc, props.clusterProps, props.ecrRepositoryArn, props.ecrImageVersion, props.fargateTaskDefinitionProps, props.containerDefinitionProps, props.fargateServiceProps);
        }
        [this.dynamoTableInterface, this.dynamoTable] = defaults.buildDynamoDBTable(this, {
            dynamoTableProps: props.dynamoTableProps,
            existingTableInterface: props.existingTableInterface
        });
        // Add the requested or default table permissions
        if (props.tablePermissions) {
            const permission = props.tablePermissions.toUpperCase();
            if (permission === 'ALL') {
                this.dynamoTableInterface.grantFullAccess(this.service.taskDefinition.taskRole);
            }
            else if (permission === 'READ') {
                this.dynamoTableInterface.grantReadData(this.service.taskDefinition.taskRole);
            }
            else if (permission === 'READWRITE') {
                this.dynamoTableInterface.grantReadWriteData(this.service.taskDefinition.taskRole);
            }
            else if (permission === 'WRITE') {
                this.dynamoTableInterface.grantWriteData(this.service.taskDefinition.taskRole);
            }
        }
        else {
            this.dynamoTableInterface.grantReadWriteData(this.service.taskDefinition.taskRole);
        }
        // Add environment variables
        const tableArnEnvironmentVariableName = props.tableArnEnvironmentVariableName || 'DYNAMODB_TABLE_ARN';
        this.container.addEnvironment(tableArnEnvironmentVariableName, this.dynamoTableInterface.tableArn);
        const tableEnvironmentVariableName = props.tableEnvironmentVariableName || 'DYNAMODB_TABLE_NAME';
        this.container.addEnvironment(tableEnvironmentVariableName, this.dynamoTableInterface.tableName);
    }
}
exports.FargateToDynamoDB = FargateToDynamoDB;
_a = JSII_RTTI_SYMBOL_1;
FargateToDynamoDB[_a] = { fqn: "@aws-solutions-constructs/aws-fargate-dynamodb.FargateToDynamoDB", version: "1.155.0" };
//# sourceMappingURL=data:application/json;base64,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