/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.coordinate;

import java.io.Serializable;
import org.geotools.geometry.iso.primitive.CurveBoundaryImpl;
import org.geotools.geometry.iso.primitive.CurveImpl;
import org.geotools.geometry.iso.primitive.PointImpl;
import org.geotools.geometry.iso.util.DoubleOperation;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.CurveInterpolation;
import org.opengis.geometry.primitive.CurveSegment;

public abstract class CurveSegmentImpl
implements CurveSegment,
Serializable {
    protected double startParam;
    protected double endParam;
    protected CurveInterpolation interpolation = null;
    private CurveImpl curve;

    public CurveSegmentImpl(double startPar) {
        this.curve = null;
        this.startParam = startPar;
        this.endParam = -1.0;
    }

    public CurveSegmentImpl(CurveSegmentImpl other) {
        this.curve = other.curve;
        this.startParam = other.startParam;
        this.endParam = other.endParam;
    }

    @Override
    public CurveBoundaryImpl getBoundary() {
        return new CurveBoundaryImpl(this.getCurve().getCoordinateReferenceSystem(), new PointImpl(this.getStartPoint()), new PointImpl(this.getEndPoint()));
    }

    @Override
    public CurveInterpolation getInterpolation() {
        return this.interpolation;
    }

    protected void setInterpolation(CurveInterpolation interpolation) {
        this.interpolation = interpolation;
    }

    public void setCurve(CurveImpl curve) {
        if (curve == null) {
            throw new IllegalArgumentException("Curve not passed");
        }
        this.curve = curve;
    }

    @Override
    public CurveImpl getCurve() {
        if (this.curve == null) {
            throw new IllegalArgumentException("Parent Curve not set.");
        }
        return this.curve;
    }

    @Override
    public abstract DirectPosition getStartPoint();

    @Override
    public abstract DirectPosition getEndPoint();

    public abstract Position getStartPosition();

    public abstract Position getEndPosition();

    public double length() {
        return DoubleOperation.subtract(this.getEndParam(), this.getStartParam());
    }

    @Override
    public double getStartParam() {
        return this.startParam;
    }

    public void setStartParam(double Value) {
        this.startParam = Value;
    }

    @Override
    public double getEndParam() {
        return this.endParam;
    }

    public void setEndParam(double Value) {
        this.endParam = Value;
    }

    @Override
    public double getStartConstructiveParam() {
        return DoubleOperation.div(this.getStartParam(), this.curve.length());
    }

    @Override
    public double getEndConstructiveParam() {
        return DoubleOperation.div(this.getEndParam(), this.curve.length());
    }

    @Override
    public double length(Position point0, Position point1) {
        throw new UnsupportedOperationException("not implemented yet.");
    }

    @Override
    public double length(double par1, double par2) {
        double parDif = Math.abs(DoubleOperation.subtract(par1, par2));
        return DoubleOperation.mult(parDif, this.getCurve().length());
    }

    public abstract Envelope getEnvelope();

    public abstract void split(double var1);
}

