/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.topograph2D;

import java.io.PrintStream;
import org.geotools.geometry.iso.topograph2D.Coordinate;

public class EdgeIntersection
implements Comparable<EdgeIntersection> {
    public Coordinate coord;
    public int segmentIndex;
    public double dist;

    public EdgeIntersection(Coordinate coord, int segmentIndex, double dist) {
        this.coord = new Coordinate(coord);
        this.segmentIndex = segmentIndex;
        this.dist = dist;
    }

    @Override
    public int compareTo(EdgeIntersection other) {
        return this.compare(other.segmentIndex, other.dist);
    }

    public int compare(int segmentIndex, double dist) {
        if (this.segmentIndex < segmentIndex) {
            return -1;
        }
        if (this.segmentIndex > segmentIndex) {
            return 1;
        }
        if (this.dist < dist) {
            return -1;
        }
        if (this.dist > dist) {
            return 1;
        }
        return 0;
    }

    public boolean isEndPoint(int maxSegmentIndex) {
        if (this.segmentIndex == 0 && this.dist == 0.0) {
            return true;
        }
        return this.segmentIndex == maxSegmentIndex;
    }

    public void print(PrintStream out) {
        out.print(this.coord);
        out.print(" seg # = " + this.segmentIndex);
        out.println(" dist = " + this.dist);
    }
}

