/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.iso.util.algorithm2D;

import java.util.List;
import org.geotools.geometry.iso.primitive.RingImplUnsafe;
import org.geotools.geometry.iso.primitive.SurfaceImpl;
import org.geotools.geometry.iso.root.GeometryImpl;
import org.geotools.geometry.iso.topograph2D.Coordinate;
import org.geotools.geometry.iso.topograph2D.util.CoordinateArrays;
import org.geotools.geometry.iso.util.algorithm2D.CGAlgorithms;
import org.opengis.geometry.aggregate.MultiPrimitive;
import org.opengis.geometry.primitive.Ring;

public class SimplePointInAreaLocator {
    public static int locate(Coordinate p, GeometryImpl geom) {
        if (SimplePointInAreaLocator.containsPoint(p, geom)) {
            return 0;
        }
        return 2;
    }

    private static boolean containsPoint(Coordinate p, GeometryImpl geom) {
        if (geom instanceof SurfaceImpl) {
            return SimplePointInAreaLocator.containsPointInPolygon(p, (SurfaceImpl)geom);
        }
        if (geom instanceof MultiPrimitive) {
            for (GeometryImpl geometryImpl : ((MultiPrimitive)((Object)geom)).getElements()) {
                if (geometryImpl == geom || !SimplePointInAreaLocator.containsPoint(p, geometryImpl)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsPointInPolygon(Coordinate p, SurfaceImpl aSurface) {
        List<Ring> rings = aSurface.getBoundaryRings();
        Ring shell = rings.get(0);
        if (!CGAlgorithms.isPointInRing(p, CoordinateArrays.toCoordinateArray(((RingImplUnsafe)shell).asDirectPositions()))) {
            return false;
        }
        for (int i = 1; i < rings.size(); ++i) {
            RingImplUnsafe hole = (RingImplUnsafe)rings.get(i);
            if (!CGAlgorithms.isPointInRing(p, CoordinateArrays.toCoordinateArray(hole.asDirectPositions()))) continue;
            return false;
        }
        return true;
    }
}

