/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.format.UnitFormat;
import tech.units.indriya.format.SimpleUnitFormat;

public abstract class GeoToolsUnitFormat
extends SimpleUnitFormat {
    private static BaseGT2Format INSTANCE = new BaseGT2Format();

    public static SimpleUnitFormat getInstance() {
        return INSTANCE;
    }

    static {
        INSTANCE.initUnits(SimpleUnitFormat.getInstance());
    }

    protected static class BaseGT2Format
    extends SimpleUnitFormat.DefaultFormat {
        protected void initUnits(UnitFormat base) {
            try {
                HashMap<String, Unit<?>> nameToUnitMap = this.getNameToUnitMap(base);
                HashMap<Unit<?>, String> unitToNameMap = this.getUnitToNameMap(base);
                for (Map.Entry<String, Unit<?>> entry : nameToUnitMap.entrySet()) {
                    String name = entry.getKey();
                    Unit<?> unit = entry.getValue();
                    if (unitToNameMap.containsKey(unit) && name.equals(unitToNameMap.get(unit))) {
                        this.label(unit, name);
                        this.addUnit(unit);
                        continue;
                    }
                    this.alias(unit, name);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to initialize the " + this.getClass().getCanonicalName() + " format unit parser with the same values as " + base.getClass().getCanonicalName() + "  one", t);
            }
        }

        private HashMap<Unit<?>, String> getUnitToNameMap(UnitFormat base) throws NoSuchFieldException, IllegalAccessException {
            Field unitToNameField = SimpleUnitFormat.DefaultFormat.class.getDeclaredField("unitToName");
            unitToNameField.setAccessible(true);
            return (HashMap)unitToNameField.get(base);
        }

        private HashMap<String, Unit<?>> getNameToUnitMap(UnitFormat base) throws NoSuchFieldException, IllegalAccessException {
            Field nameToUnitField = SimpleUnitFormat.DefaultFormat.class.getDeclaredField("nameToUnit");
            nameToUnitField.setAccessible(true);
            return (HashMap)nameToUnitField.get(base);
        }

        protected void addUnit(Unit<?> unit) {
        }
    }
}

