/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.algorithms.shortestpath;

import java.util.LinkedList;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortestpath.ShortestPathResult;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.path.DirectedPath;
import org.goplanit.utils.path.DirectedPathFactory;

public class ShortestPathResultImpl
implements ShortestPathResult {
    private static final Logger LOGGER = Logger.getLogger(ShortestPathResult.class.getCanonicalName());
    protected final double[] vertexMeasuredCost;
    protected final EdgeSegment[] incomingEdgeSegment;

    protected ShortestPathResultImpl(double[] vertexMeasuredCost, EdgeSegment[] incomingEdgeSegment) {
        this.vertexMeasuredCost = vertexMeasuredCost;
        this.incomingEdgeSegment = incomingEdgeSegment;
    }

    @Override
    public DirectedPath createPath(DirectedPathFactory pathFactory, Vertex origin, Vertex destination) {
        LinkedList<EdgeSegment> pathEdgeSegments = new LinkedList<EdgeSegment>();
        int vertexId = (int)destination.getId();
        EdgeSegment previousEdgeSegmentOnPath = this.incomingEdgeSegment[vertexId];
        int originVertexId = (int)origin.getId();
        while (originVertexId != vertexId) {
            if (previousEdgeSegmentOnPath == null) {
                return null;
            }
            pathEdgeSegments.addFirst(previousEdgeSegmentOnPath);
            vertexId = (int)previousEdgeSegmentOnPath.getUpstreamVertex().getId();
            previousEdgeSegmentOnPath = this.incomingEdgeSegment[vertexId];
        }
        return pathFactory.createNew(pathEdgeSegments);
    }

    @Override
    public EdgeSegment getIncomingEdgeSegmentForVertex(Vertex vertex) {
        return this.incomingEdgeSegment[(int)vertex.getId()];
    }

    @Override
    public double getCostToReach(Vertex vertex) {
        return this.vertexMeasuredCost[(int)vertex.getId()];
    }
}

