/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment;

import java.util.Calendar;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Logger;
import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.time.TimePeriod;

public abstract class StaticTrafficAssignment
extends TrafficAssignment {
    private static final long serialVersionUID = -2600601431539929608L;
    private static final Logger LOGGER = Logger.getLogger(StaticTrafficAssignment.class.getCanonicalName());

    protected abstract void executeTimePeriod(TimePeriod var1, Set<Mode> var2) throws PlanItException;

    protected void executeTimePeriod(TimePeriod timePeriod) throws PlanItException {
        Calendar startTime;
        Calendar initialStartTime = startTime = Calendar.getInstance();
        this.executeTimePeriod(timePeriod, this.getDemands().getRegisteredModesForTimePeriod(timePeriod));
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + String.format("run time: %d milliseconds", startTime.getTimeInMillis() - initialStartTime.getTimeInMillis()));
    }

    protected StaticTrafficAssignment(IdGroupingToken groupId) {
        super(groupId);
    }

    protected StaticTrafficAssignment(StaticTrafficAssignment staticTrafficAssignment) {
        super(staticTrafficAssignment);
    }

    @Override
    public void executeEquilibration() throws PlanItException {
        SortedSet<TimePeriod> timePeriods = this.getDemands().timePeriods.asSortedSetByStartTime();
        LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + "total time periods: " + timePeriods.size());
        for (TimePeriod timePeriod : timePeriods) {
            LOGGER.info(LoggingUtils.createRunIdPrefix(this.getId()) + LoggingUtils.createTimePeriodPrefix(timePeriod) + timePeriod.toString());
            this.executeTimePeriod(timePeriod);
        }
    }
}

