/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment;

import java.util.List;
import java.util.logging.Logger;
import org.goplanit.assignment.TrafficAssignment;
import org.goplanit.cost.physical.AbstractPhysicalCost;
import org.goplanit.cost.physical.PhysicalCostConfigurator;
import org.goplanit.cost.physical.PhysicalCostConfiguratorFactory;
import org.goplanit.cost.physical.initial.InitialLinkSegmentCost;
import org.goplanit.cost.physical.initial.InitialModesLinkSegmentCost;
import org.goplanit.cost.virtual.AbstractVirtualCost;
import org.goplanit.cost.virtual.VirtualCostConfigurator;
import org.goplanit.cost.virtual.VirtualCostConfiguratorFactory;
import org.goplanit.demands.Demands;
import org.goplanit.gap.GapFunction;
import org.goplanit.gap.GapFunctionConfigurator;
import org.goplanit.gap.GapFunctionConfiguratorFactory;
import org.goplanit.network.TransportLayerNetwork;
import org.goplanit.output.OutputManager;
import org.goplanit.output.configuration.OutputConfiguration;
import org.goplanit.output.configuration.OutputTypeConfiguration;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.formatter.OutputFormatter;
import org.goplanit.sdinteraction.smoothing.Smoothing;
import org.goplanit.sdinteraction.smoothing.SmoothingConfigurator;
import org.goplanit.sdinteraction.smoothing.SmoothingConfiguratorFactory;
import org.goplanit.utils.builder.Configurator;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.zoning.Zoning;

public class TrafficAssignmentConfigurator<T extends TrafficAssignment>
extends Configurator<T> {
    private static final Logger LOGGER = Logger.getLogger(TrafficAssignmentConfigurator.class.getCanonicalName());
    protected static final String SET_OUTPUT_MANAGER = "setOutputManager";
    protected static final String SET_GAP_FUNCTION = "setGapFunction";
    protected static final String SET_VIRTUAL_COST = "setVirtualCost";
    protected static final String SET_PHYSICAL_COST = "setPhysicalCost";
    protected static final String SET_INITIAL_LINK_SEGMENT_COST = "setInitialLinkSegmentCost";
    protected static final String SET_INFRASTRUCTURE_NETWORK = "setInfrastructureNetwork";
    protected static final String SET_ZONING = "setZoning";
    protected static final String SET_DEMANDS = "setDemands";
    private SmoothingConfigurator<? extends Smoothing> smoothingConfigurator = null;
    private PhysicalCostConfigurator<? extends AbstractPhysicalCost> physicalCostConfigurator = null;
    private VirtualCostConfigurator<? extends AbstractVirtualCost> virtualCostConfigurator = null;
    private GapFunctionConfigurator<? extends GapFunction> gapFunctionConfigurator = null;

    protected void setInfrastructureNetwork(TransportLayerNetwork<?, ?> network) {
        this.registerDelayedMethodCall(SET_INFRASTRUCTURE_NETWORK, network);
    }

    protected void setZoning(Zoning zoning) {
        this.registerDelayedMethodCall(SET_ZONING, zoning);
    }

    protected void setDemands(Demands demands) {
        this.registerDelayedMethodCall(SET_DEMANDS, demands);
    }

    protected void setOutputManager(OutputManager outputManager) {
        this.registerDelayedMethodCall(SET_OUTPUT_MANAGER, outputManager);
    }

    protected OutputManager getOutputManager() {
        return (OutputManager)this.getFirstParameterOfDelayedMethodCall(SET_OUTPUT_MANAGER);
    }

    public TrafficAssignmentConfigurator(Class<T> instanceType) {
        super(instanceType);
    }

    public TransportLayerNetwork<?, ?> getInfrastructureNetwork() {
        return (TransportLayerNetwork)this.getFirstParameterOfDelayedMethodCall(SET_INFRASTRUCTURE_NETWORK);
    }

    public Zoning getZoning() {
        return (Zoning)this.getFirstParameterOfDelayedMethodCall(SET_ZONING);
    }

    public Demands getDemands() {
        return (Demands)this.getFirstParameterOfDelayedMethodCall(SET_DEMANDS);
    }

    public GapFunctionConfigurator<? extends GapFunction> createAndRegisterGapFunction(String gapFunctionType) throws PlanItException {
        this.gapFunctionConfigurator = GapFunctionConfiguratorFactory.createConfigurator(gapFunctionType);
        return this.gapFunctionConfigurator;
    }

    public SmoothingConfigurator<? extends Smoothing> createAndRegisterSmoothing(String smoothingType) throws PlanItException {
        this.smoothingConfigurator = SmoothingConfiguratorFactory.createConfigurator(smoothingType);
        return this.smoothingConfigurator;
    }

    public PhysicalCostConfigurator<? extends AbstractPhysicalCost> createAndRegisterPhysicalCost(String physicalTraveltimeCostFunctionType) throws PlanItException {
        this.physicalCostConfigurator = PhysicalCostConfiguratorFactory.createConfigurator(physicalTraveltimeCostFunctionType);
        return this.physicalCostConfigurator;
    }

    public VirtualCostConfigurator<? extends AbstractVirtualCost> createAndRegisterVirtualCost(String virtualTraveltimeCostFunctionType) throws PlanItException {
        this.virtualCostConfigurator = VirtualCostConfiguratorFactory.createConfigurator(virtualTraveltimeCostFunctionType);
        return this.virtualCostConfigurator;
    }

    public void registerOutputFormatter(OutputFormatter outputFormatter) throws PlanItException {
        this.getOutputManager().registerOutputFormatter(outputFormatter);
    }

    public void unregisterOutputFormatter(OutputFormatter outputFormatter) throws PlanItException {
        this.getOutputManager().unregisterOutputFormatter(outputFormatter);
    }

    public List<OutputFormatter> getOutputFormatters() {
        return this.getOutputManager().getOutputFormatters();
    }

    public void registerInitialLinkSegmentCost(InitialLinkSegmentCost initialLinkSegmentCost) {
        this.registerInitialLinkSegmentCost(initialLinkSegmentCost.getTimePeriodAgnosticCosts());
        if (initialLinkSegmentCost.getTimePeriods() != null) {
            for (TimePeriod timePeriod : initialLinkSegmentCost.getTimePeriods()) {
                this.registerInitialLinkSegmentCost(initialLinkSegmentCost.getTimePeriodCosts(timePeriod));
            }
        }
    }

    public void registerInitialLinkSegmentCost(InitialModesLinkSegmentCost initialLinkSegmentCost) {
        this.registerDelayedMethodCall(SET_INITIAL_LINK_SEGMENT_COST, initialLinkSegmentCost);
    }

    public void registerInitialLinkSegmentCost(TimePeriod timePeriod, InitialModesLinkSegmentCost initialLinkSegmentCost) throws PlanItException {
        PlanItException.throwIf(timePeriod == null, "time period null when registering initial link segment costs", new Object[0]);
        this.registerDelayedMethodCall(SET_INITIAL_LINK_SEGMENT_COST, timePeriod, initialLinkSegmentCost);
    }

    public OutputTypeConfiguration activateOutput(OutputType outputType) throws PlanItException {
        if (!this.isOutputTypeActive(outputType)) {
            return this.getOutputManager().createAndRegisterOutputTypeConfiguration(outputType);
        }
        return this.getOutputManager().getOutputTypeConfiguration(outputType);
    }

    public void deactivateOutput(OutputType outputType) {
        if (this.isOutputTypeActive(outputType)) {
            this.getOutputManager().deregisterOutputTypeConfiguration(outputType);
            this.getOutputManager().deregisterOutputTypeAdapter(outputType);
        }
    }

    public boolean isOutputTypeActive(OutputType outputType) {
        return this.getOutputManager().isOutputTypeActive(outputType);
    }

    public OutputConfiguration getOutputConfiguration() {
        return this.getOutputManager().getOutputConfiguration();
    }

    public GapFunctionConfigurator<? extends GapFunction> getGapFunction() {
        return this.gapFunctionConfigurator;
    }

    public PhysicalCostConfigurator<? extends AbstractPhysicalCost> getPhysicalCost() {
        return this.physicalCostConfigurator;
    }

    public VirtualCostConfigurator<? extends AbstractVirtualCost> getVirtualCost() {
        return this.virtualCostConfigurator;
    }

    public SmoothingConfigurator<? extends Smoothing> getSmoothing() {
        return this.smoothingConfigurator;
    }
}

