/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm;

import org.goplanit.algorithms.nodemodel.NodeModel;
import org.goplanit.assignment.TrafficAssignmentConfigurator;
import org.goplanit.assignment.ltm.LtmAssignment;
import org.goplanit.path.choice.PathChoice;
import org.goplanit.path.choice.PathChoiceConfigurator;
import org.goplanit.path.choice.PathChoiceConfiguratorFactory;
import org.goplanit.supply.fundamentaldiagram.FundamentalDiagram;
import org.goplanit.supply.fundamentaldiagram.FundamentalDiagramComponent;
import org.goplanit.supply.fundamentaldiagram.FundamentalDiagramConfigurator;
import org.goplanit.supply.fundamentaldiagram.FundamentalDiagramConfiguratorFactory;
import org.goplanit.supply.network.nodemodel.NodeModelComponent;
import org.goplanit.supply.network.nodemodel.NodeModelConfigurator;
import org.goplanit.supply.network.nodemodel.NodeModelConfiguratorFactory;
import org.goplanit.utils.exceptions.PlanItException;

public class LtmConfigurator<T extends LtmAssignment>
extends TrafficAssignmentConfigurator<T> {
    private FundamentalDiagramConfigurator<? extends FundamentalDiagramComponent> fundamentalDiagramConfigurator = null;
    private NodeModelConfigurator<? extends NodeModelComponent> nodeModelConfigurator = null;
    private PathChoiceConfigurator<? extends PathChoice> pathChoiceConfigurator = null;

    public LtmConfigurator(Class<T> ltmClass) throws PlanItException {
        super(ltmClass);
        this.createAndRegisterFundamentalDiagram(FundamentalDiagram.NEWELL);
        this.createAndRegisterNodeModel(NodeModel.TAMPERE);
    }

    public FundamentalDiagramConfigurator<? extends FundamentalDiagramComponent> createAndRegisterFundamentalDiagram(String fundamentalDiagramType) throws PlanItException {
        this.fundamentalDiagramConfigurator = FundamentalDiagramConfiguratorFactory.createConfigurator(fundamentalDiagramType);
        return this.fundamentalDiagramConfigurator;
    }

    public FundamentalDiagramConfigurator<? extends FundamentalDiagramComponent> getFundamentalDiagram() {
        return this.fundamentalDiagramConfigurator;
    }

    public NodeModelConfigurator<? extends NodeModelComponent> createAndRegisterNodeModel(String nodeModelType) throws PlanItException {
        this.nodeModelConfigurator = NodeModelConfiguratorFactory.createConfigurator(nodeModelType);
        return this.nodeModelConfigurator;
    }

    public NodeModelConfigurator<? extends NodeModelComponent> getNodeModel() {
        return this.nodeModelConfigurator;
    }

    public PathChoiceConfigurator<? extends PathChoice> createAndRegisterPathChoice(String pathChoiceType) throws PlanItException {
        this.pathChoiceConfigurator = PathChoiceConfiguratorFactory.createConfigurator(pathChoiceType);
        return this.pathChoiceConfigurator;
    }

    public PathChoiceConfigurator<? extends PathChoice> getPathChoice() {
        return this.pathChoiceConfigurator;
    }
}

