/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.util.logging.Logger;
import org.goplanit.algorithms.shortestpath.DijkstraShortestPathAlgorithm;
import org.goplanit.algorithms.shortestpath.ShortestPathResult;
import org.goplanit.assignment.ltm.sltm.StaticLtmAssignmentStrategy;
import org.goplanit.assignment.ltm.sltm.StaticLtmSettings;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmLoadingPath;
import org.goplanit.assignment.ltm.sltm.loading.StaticLtmLoadingScheme;
import org.goplanit.interactor.TrafficAssignmentComponentAccessee;
import org.goplanit.network.transport.TransportModelNetwork;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.od.path.OdPaths;
import org.goplanit.od.path.OdPathsHashed;
import org.goplanit.path.DirectedPathFactoryImpl;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.path.DirectedPath;
import org.goplanit.utils.zoning.OdZone;
import org.goplanit.zoning.Zoning;

public class StaticLtmPathStrategy
extends StaticLtmAssignmentStrategy {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmPathStrategy.class.getCanonicalName());
    private OdPaths odPaths;

    private OdPaths createOdPaths(double[] currentSegmentCosts) throws PlanItException {
        DijkstraShortestPathAlgorithm shortestPathAlgorithm = new DijkstraShortestPathAlgorithm(currentSegmentCosts, this.getTransportNetwork().getNumberOfEdgeSegmentsAllLayers(), this.getTransportNetwork().getNumberOfVerticesAllLayers());
        DirectedPathFactoryImpl pathFactory = new DirectedPathFactoryImpl(this.getIdGroupingToken());
        OdPathsHashed odPaths = new OdPathsHashed(this.getIdGroupingToken(), this.getTransportNetwork().getZoning().getOdZones());
        Zoning zoning = this.getTransportNetwork().getZoning();
        OdDemands odDemands = this.getOdDemands();
        for (OdZone origin : zoning.getOdZones()) {
            ShortestPathResult oneToAllResult = shortestPathAlgorithm.executeOneToAll(origin.getCentroid());
            for (OdZone destination : zoning.getOdZones()) {
                Double currOdDemand;
                if (destination.idEquals(origin) || (currOdDemand = (Double)odDemands.getValue(origin, destination)) == null || !(currOdDemand > 0.0)) continue;
                DirectedPath path = oneToAllResult.createPath(pathFactory, origin.getCentroid(), destination.getCentroid());
                if (path == null) {
                    LOGGER.warning(String.format("%sUnable to create path for OD (%s,%s) with non-zero demand (%.2f)", LoggingUtils.createRunIdPrefix(this.getAssignmentId()), origin.getXmlId(), destination.getXmlId(), currOdDemand));
                    continue;
                }
                odPaths.setValue(origin, destination, path);
            }
        }
        return odPaths;
    }

    @Override
    protected StaticLtmLoadingPath createNetworkLoading() {
        return new StaticLtmLoadingPath(this.getIdGroupingToken(), this.getAssignmentId(), this.getSettings());
    }

    @Override
    protected StaticLtmLoadingPath getLoading() {
        return (StaticLtmLoadingPath)super.getLoading();
    }

    public StaticLtmPathStrategy(IdGroupingToken idGroupingToken, long assignmentId, TransportModelNetwork transportModelNetwork, StaticLtmSettings settings, TrafficAssignmentComponentAccessee taComponents) {
        super(idGroupingToken, assignmentId, transportModelNetwork, settings, taComponents);
    }

    @Override
    public void createInitialSolution(double[] initialLinkSegmentCosts) {
        try {
            this.odPaths = this.createOdPaths(initialLinkSegmentCosts);
            this.getLoading().updateOdPaths(this.odPaths);
        }
        catch (Exception e) {
            LOGGER.severe(String.format("Unable to create paths for initial solution of path-based sLTM %s", this.getAssignmentId()));
        }
    }

    @Override
    public boolean performIteration(Mode theMode, double[] costsToUpdate, int iterationIndex) {
        try {
            this.executeNetworkLoading();
            boolean updateOnlyPotentiallyBlockingNodeCosts = this.getLoading().getActivatedSolutionScheme().equals((Object)StaticLtmLoadingScheme.POINT_QUEUE_BASIC);
            this.executeNetworkCostsUpdate(theMode, updateOnlyPotentiallyBlockingNodeCosts, costsToUpdate);
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            LOGGER.severe("Unable to complete sLTM iteration");
            if (this.getSettings().isDetailedLogging().booleanValue()) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    @Override
    public String getDescription() {
        return "{Path-based";
    }
}

