/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm;

import java.lang.reflect.Field;
import java.util.logging.Logger;

public class StaticLtmSettings
implements Cloneable {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmSettings.class.getCanonicalName());
    private Boolean disableStorageConstraints = null;
    private Boolean detailedLogging = null;
    private Boolean bushBased = BUSH_BASED_DEFAULT;
    public static boolean BUSH_BASED_DEFAULT = true;

    public StaticLtmSettings() {
    }

    public StaticLtmSettings(StaticLtmSettings staticLtmSettings) {
        this.bushBased = (boolean)staticLtmSettings.bushBased;
        this.detailedLogging = (boolean)staticLtmSettings.detailedLogging;
        this.disableStorageConstraints = (boolean)staticLtmSettings.disableStorageConstraints;
    }

    public Boolean isDisableStorageConstraints() {
        return this.disableStorageConstraints;
    }

    public void setDisableStorageConstraints(Boolean disableStorageConstraints) {
        this.disableStorageConstraints = disableStorageConstraints;
    }

    public Boolean isDetailedLogging() {
        return this.detailedLogging;
    }

    public void setDetailedLogging(Boolean detailedLogging) {
        this.detailedLogging = detailedLogging;
    }

    public Boolean isBushBased() {
        return this.bushBased;
    }

    public void setBushBased(Boolean flag) {
        this.bushBased = flag;
    }

    public boolean validate() {
        boolean valid = true;
        Field[] fields = this.getClass().getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            Field field = fields[index];
            field.setAccessible(true);
            try {
                if (field.get(this) != null) continue;
                LOGGER.severe(String.format("%s has not been set as part of sLTM network loading settings, this should not happen", field.getName()));
                valid = false;
                continue;
            }
            catch (Exception e) {
                LOGGER.severe(String.format("Unable to collect field %s from class instance %s, this should not happen", field.getName(), this.getClass().getName()));
                e.printStackTrace();
                valid = false;
            }
        }
        return valid;
    }

    public StaticLtmSettings clone() {
        return new StaticLtmSettings(this);
    }
}

