/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.consumer;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.goplanit.assignment.ltm.sltm.Bush;
import org.goplanit.assignment.ltm.sltm.consumer.NetworkFlowUpdateData;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.math.Precision;

public class BushFlowUpdateConsumer<T extends NetworkFlowUpdateData>
implements Consumer<Bush> {
    private static final Logger LOGGER = Logger.getLogger(BushFlowUpdateConsumer.class.getCanonicalName());
    protected T dataConfig;

    private void initialiseRootExitSegmentSendingFlows(Bush originBush, double[] bushSendingFlows) {
        int index = 0;
        double[] rootVertexSplittingRates = originBush.getRootVertexSplittingRates();
        for (EdgeSegment rootExit : originBush.getOrigin().getCentroid().getExitEdgeSegments()) {
            if (originBush.containsEdgeSegment(rootExit)) {
                bushSendingFlows[(int)rootExit.getId()] = originBush.getTravelDemandPcuH() * rootVertexSplittingRates[index];
            }
            ++index;
        }
    }

    protected void applyAcceptedTurnFlowUpdate(int prevSegmentId, EdgeSegment currentSegment, double turnAcceptedFlow) {
    }

    public BushFlowUpdateConsumer(T dataConfig) {
        this.dataConfig = dataConfig;
    }

    @Override
    public void accept(Bush originBush) {
        double[] bushSendingFlows = new double[((NetworkFlowUpdateData)this.dataConfig).flowAcceptanceFactors.length];
        Collection<DirectedVertex> topSortedVertices = originBush.getTopologicallySortedVertices();
        Iterator<DirectedVertex> vertexIter = topSortedVertices.iterator();
        DirectedVertex currVertex = vertexIter.next();
        if (!currVertex.idEquals(originBush.getOrigin().getCentroid())) {
            LOGGER.severe(String.format("Topologically sorted bush rooted at origin %s, does not commence with its root vertex %s", originBush.getOrigin().getXmlId(), originBush.getOrigin().getCentroid().getXmlId()));
            return;
        }
        this.initialiseRootExitSegmentSendingFlows(originBush, bushSendingFlows);
        while (vertexIter.hasNext()) {
            currVertex = vertexIter.next();
            for (EdgeSegment entrySegment : currVertex.getEntryEdgeSegments()) {
                if (!originBush.containsEdgeSegment(entrySegment)) continue;
                int entrySegmentId = (int)entrySegment.getId();
                double bushLinkSendingFlow = bushSendingFlows[entrySegmentId];
                if (((NetworkFlowUpdateData)this.dataConfig).updateLinkSendingFlows) {
                    int n = (int)entrySegment.getId();
                    ((NetworkFlowUpdateData)this.dataConfig).sendingFlows[n] = ((NetworkFlowUpdateData)this.dataConfig).sendingFlows[n] + bushLinkSendingFlow;
                }
                double bushEntryAcceptedFlow = bushLinkSendingFlow * ((NetworkFlowUpdateData)this.dataConfig).flowAcceptanceFactors[entrySegmentId];
                double[] splittingRates = originBush.getSplittingRates(entrySegment);
                int index = 0;
                for (EdgeSegment exitSegment : currVertex.getExitEdgeSegments()) {
                    if (Precision.isPositive(splittingRates[index])) {
                        int exitSegmentId = (int)exitSegment.getId();
                        double turnAcceptedFlow = bushEntryAcceptedFlow * splittingRates[index];
                        int n = exitSegmentId;
                        bushSendingFlows[n] = bushSendingFlows[n] + turnAcceptedFlow;
                        this.applyAcceptedTurnFlowUpdate(entrySegmentId, exitSegment, turnAcceptedFlow);
                    }
                    ++index;
                }
            }
        }
    }
}

