/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.consumer;

import java.util.Iterator;
import java.util.logging.Logger;
import org.goplanit.assignment.ltm.sltm.consumer.NetworkFlowUpdateData;
import org.goplanit.od.path.OdPaths;
import org.goplanit.utils.functionalinterface.TriConsumer;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.path.DirectedPath;
import org.goplanit.utils.zoning.OdZone;

public abstract class PathFlowUpdateConsumer<T extends NetworkFlowUpdateData>
implements TriConsumer<OdZone, OdZone, Double> {
    private static final Logger LOGGER = Logger.getLogger(PathFlowUpdateConsumer.class.getCanonicalName());
    protected T dataConfig;
    private final OdPaths odPaths;

    protected abstract double applySingleFlowUpdate(int var1, EdgeSegment var2, double var3);

    protected abstract void applyPathFinalSegmentFlowUpdate(EdgeSegment var1, double var2);

    public PathFlowUpdateConsumer(T dataConfig, OdPaths odPaths) {
        this.dataConfig = dataConfig;
        this.odPaths = odPaths;
    }

    @Override
    public void accept(OdZone origin, OdZone destination, Double odDemand) {
        DirectedPath odPath = (DirectedPath)this.odPaths.getValue(origin, destination);
        double acceptedPathFlowRate = odDemand;
        if (odPath.isEmpty()) {
            LOGGER.warning(String.format("IGNORE: encountered empty path %s", odPath.getXmlId()));
            return;
        }
        Iterator edgeSegmentIter = odPath.iterator();
        int previousEdgeSegmentId = (int)((EdgeSegment)edgeSegmentIter.next()).getId();
        EdgeSegment currEdgeSegment = null;
        while (edgeSegmentIter.hasNext()) {
            currEdgeSegment = (EdgeSegment)edgeSegmentIter.next();
            acceptedPathFlowRate = this.applySingleFlowUpdate(previousEdgeSegmentId, currEdgeSegment, acceptedPathFlowRate);
            previousEdgeSegmentId = (int)currEdgeSegment.getId();
        }
        this.applyPathFinalSegmentFlowUpdate(currEdgeSegment, acceptedPathFlowRate);
    }
}

