/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.loading;

import org.goplanit.assignment.ltm.sltm.LinkSegmentData;

public class NetworkLoadingFactorData
extends LinkSegmentData {
    private double[][] flowAcceptanceFactors = null;
    private double[][] storageCapacityFactors = null;
    private double[][] flowCapacityFactors = null;

    public NetworkLoadingFactorData(int numberOfLinkSegments) {
        super(numberOfLinkSegments, 1.0);
        this.flowAcceptanceFactors = new double[2][numberOfLinkSegments];
        this.flowCapacityFactors = new double[2][numberOfLinkSegments];
        this.storageCapacityFactors = new double[2][numberOfLinkSegments];
        this.reset();
    }

    public void resetNextFlowAcceptanceFactors() {
        this.flowAcceptanceFactors[1] = this.createinitialStateLinkSegmentDoubleArray();
    }

    public void resetCurrentFlowAcceptanceFactors() {
        this.flowAcceptanceFactors[0] = this.createinitialStateLinkSegmentDoubleArray();
    }

    public void resetNextFlowCapacityFactors() {
        this.flowCapacityFactors[1] = this.createinitialStateLinkSegmentDoubleArray();
    }

    public void resetCurrentFlowCapacityFactors() {
        this.flowCapacityFactors[0] = this.createinitialStateLinkSegmentDoubleArray();
    }

    public void resetNextStorageCapacityFactors() {
        this.storageCapacityFactors[1] = this.createinitialStateLinkSegmentDoubleArray();
    }

    public void resetCurrentStorageCapacityFactors() {
        this.storageCapacityFactors[0] = this.createinitialStateLinkSegmentDoubleArray();
    }

    public double[] getCurrentFlowAcceptanceFactors() {
        return this.flowAcceptanceFactors[0];
    }

    public double[] getCurrentFlowCapacityFactors() {
        return this.flowCapacityFactors[0];
    }

    public double[] getCurrentStorageCapacityFactors() {
        return this.storageCapacityFactors[0];
    }

    public double[] getNextStorageCapacityFactors() {
        return this.storageCapacityFactors[1];
    }

    public double[] getNextFlowAcceptanceFactors() {
        return this.flowAcceptanceFactors[1];
    }

    public double[] getNextFlowCapacityFactors() {
        return this.flowCapacityFactors[1];
    }

    public void swapCurrentAndNextStorageCapacityFactors() {
        NetworkLoadingFactorData.swap(0, 1, this.storageCapacityFactors);
    }

    public void swapCurrentAndNextFlowCapacityFactors() {
        NetworkLoadingFactorData.swap(0, 1, this.flowCapacityFactors);
    }

    public void swapCurrentAndNextFlowAcceptanceFactors() {
        NetworkLoadingFactorData.swap(0, 1, this.flowAcceptanceFactors);
    }

    public void reset() {
        this.resetCurrentFlowAcceptanceFactors();
        this.resetNextFlowAcceptanceFactors();
        this.resetCurrentFlowCapacityFactors();
        this.resetNextFlowCapacityFactors();
        this.resetCurrentStorageCapacityFactors();
        this.resetNextStorageCapacityFactors();
    }
}

