/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.loading;

import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.goplanit.assignment.ltm.sltm.loading.SplittingRateData;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.misc.HashUtils;
import org.ojalgo.array.Array1D;

public class SplittingRateDataPartial
implements SplittingRateData {
    private final Set<DirectedVertex> trackedNodes;
    private final BitSet potentiallyBlockingNodes;
    private final HashMap<Integer, Array1D<Double>> splittingRates = new HashMap();

    private void registerSplittingRates(DirectedVertex potentiallyBlockingNode, EdgeSegment entrySegment) {
        this.splittingRates.putIfAbsent(HashUtils.createCombinedHashCode(potentiallyBlockingNode.getId(), entrySegment.getId()), (Array1D<Double>)Array1D.PRIMITIVE64.makeZero(potentiallyBlockingNode.sizeOfExitEdgeSegments()));
    }

    public SplittingRateDataPartial(int numberOfVertices) {
        this.trackedNodes = new HashSet<DirectedVertex>();
        this.potentiallyBlockingNodes = new BitSet(numberOfVertices);
    }

    public void registerPotentiallyBlockingNode(DirectedVertex potentiallyBlockingNode) {
        int id = (int)potentiallyBlockingNode.getId();
        if (!this.potentiallyBlockingNodes.get(id)) {
            this.potentiallyBlockingNodes.set(id);
            this.registerTrackedNode(potentiallyBlockingNode);
        }
    }

    public void registerTrackedNode(DirectedVertex trackNode) {
        if (!this.trackedNodes.contains(trackNode)) {
            this.trackedNodes.add(trackNode);
            for (EdgeSegment entrySegment : trackNode.getEntryEdgeSegments()) {
                this.registerSplittingRates(trackNode, entrySegment);
            }
        }
    }

    @Override
    public boolean isTracked(DirectedVertex nodeToVerify) {
        return this.trackedNodes.contains(nodeToVerify);
    }

    @Override
    public boolean isPotentiallyBlocking(DirectedVertex nodeToVerify) {
        return this.potentiallyBlockingNodes.get((int)nodeToVerify.getId());
    }

    @Override
    public Set<DirectedVertex> getTrackedNodes() {
        return this.trackedNodes;
    }

    @Override
    public Array1D<Double> getSplittingRates(EdgeSegment entrySegment) {
        return this.splittingRates.get(HashUtils.createCombinedHashCode(entrySegment.getDownstreamVertex().getId(), entrySegment.getId()));
    }

    @Override
    public void resetTrackedNodes() {
        this.trackedNodes.clear();
    }

    @Override
    public void resetPotentiallyBlockingNodes() {
        this.potentiallyBlockingNodes.clear();
    }

    @Override
    public void resetSplittingRates() {
        this.splittingRates.clear();
    }
}

