/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.ltm.sltm.loading;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.goplanit.utils.math.Precision;
import org.goplanit.utils.misc.LoggingUtils;

public class StaticLtmNetworkLoadingConvergenceAnalyser {
    private static final Logger LOGGER = Logger.getLogger(StaticLtmNetworkLoadingConvergenceAnalyser.class.getCanonicalName());
    private final ArrayList<Double> gapsByIteration;
    private int iterationOffset = DEFAULT_ITERATION_OFFSET;
    private int minIterationThreshold = DEFAULT_MIN_ITERATION_THRESHOLD;
    private int maxIterationThreshold = DEFAULT_MAX_ITERATION_THRESHOLD;
    private final double maxSingleIterationWorseningGapThreshold = DEFAULT_MAX_SINGLE_WORSENING_THRESHOLD;
    private final double minAverageImprovingGapThreshold = DEFAULT_MIN_AVERAGE_IMPROVEMENT_THRESHOLD;
    public static int DEFAULT_ITERATION_OFFSET = 0;
    public static int DEFAULT_MIN_ITERATION_THRESHOLD = 2;
    public static int DEFAULT_MAX_ITERATION_THRESHOLD = 5;
    public static double DEFAULT_MIN_AVERAGE_IMPROVEMENT_THRESHOLD = 0.0;
    public static double DEFAULT_MAX_SINGLE_WORSENING_THRESHOLD = 0.1;

    public StaticLtmNetworkLoadingConvergenceAnalyser() {
        this.gapsByIteration = new ArrayList();
    }

    public boolean isImproving() {
        double nextLatestGap;
        double latestGap;
        if (this.minIterationThreshold > this.getRegisteredIterations() - this.iterationOffset) {
            return true;
        }
        if (this.maxIterationThreshold < this.getRegisteredIterations() - this.iterationOffset) {
            return false;
        }
        if (this.gapsByIteration.size() > 2 && Precision.isGreaterEqual((latestGap = this.gapsByIteration.get(this.getRegisteredIterations()).doubleValue()) - (nextLatestGap = this.gapsByIteration.get(this.getRegisteredIterations() - 1).doubleValue()), this.maxSingleIterationWorseningGapThreshold)) {
            return false;
        }
        double gapDelta = this.gapsByIteration.get(this.iterationOffset) - this.gapsByIteration.get(this.getRegisteredIterations());
        double averagePerIterationGapImprovement = gapDelta / (double)(this.getRegisteredIterations() - this.iterationOffset);
        return !Precision.isSmallerEqual(averagePerIterationGapImprovement, this.minAverageImprovingGapThreshold);
    }

    public void registerIterationGap(double gap) {
        this.gapsByIteration.add(gap);
    }

    public int getRegisteredIterations() {
        return Math.max(0, this.gapsByIteration.size() - 1);
    }

    public int getIterationOffset() {
        return this.iterationOffset;
    }

    public void setIterationOffset(int iterationOffset) {
        this.iterationOffset = iterationOffset;
    }

    public int getMinIterationThreshold() {
        return this.minIterationThreshold;
    }

    public void setMinIterationThreshold(int minIterationThreshold) {
        this.minIterationThreshold = minIterationThreshold;
    }

    public void logGapsSince(long runId, int referenceIteration) {
        LOGGER.info(String.format("%sGaps for iteration %d-%d: %s", LoggingUtils.createRunIdPrefix(runId), referenceIteration, this.getRegisteredIterations(), this.gapsByIteration.toString()));
    }

    public void reset() {
        this.gapsByIteration.clear();
        this.iterationOffset = DEFAULT_ITERATION_OFFSET;
    }
}

