/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.assignment.traditionalstatic;

import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.goplanit.algorithms.shortestpath.DijkstraShortestPathAlgorithm;
import org.goplanit.algorithms.shortestpath.ShortestPathResult;
import org.goplanit.assignment.StaticTrafficAssignment;
import org.goplanit.assignment.traditionalstatic.ModeData;
import org.goplanit.assignment.traditionalstatic.TraditionalStaticAssignmentLinkOutputTypeAdapter;
import org.goplanit.assignment.traditionalstatic.TraditionalStaticAssignmentOdOutputTypeAdapter;
import org.goplanit.assignment.traditionalstatic.TraditionalStaticAssignmentSimulationData;
import org.goplanit.assignment.traditionalstatic.TraditionalStaticPathOutputTypeAdapter;
import org.goplanit.cost.Cost;
import org.goplanit.cost.physical.initial.InitialModesLinkSegmentCost;
import org.goplanit.gap.LinkBasedRelativeDualityGapFunction;
import org.goplanit.interactor.LinkVolumeAccessee;
import org.goplanit.network.MacroscopicNetwork;
import org.goplanit.network.layer.MacroscopicNetworkLayerImpl;
import org.goplanit.od.demand.OdDemands;
import org.goplanit.od.path.OdPathMatrix;
import org.goplanit.od.skim.OdSkimMatrix;
import org.goplanit.output.adapter.OutputTypeAdapter;
import org.goplanit.output.adapter.OutputTypeAdapterImpl;
import org.goplanit.output.configuration.OdOutputTypeConfiguration;
import org.goplanit.output.enums.OdSkimSubOutputType;
import org.goplanit.output.enums.OutputType;
import org.goplanit.output.enums.SubOutputTypeEnum;
import org.goplanit.path.DirectedPathFactoryImpl;
import org.goplanit.utils.arrays.ArrayUtils;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdGroupingToken;
import org.goplanit.utils.misc.LoggingUtils;
import org.goplanit.utils.mode.Mode;
import org.goplanit.utils.network.layer.MacroscopicNetworkLayer;
import org.goplanit.utils.network.layer.macroscopic.MacroscopicLinkSegment;
import org.goplanit.utils.network.layer.physical.LinkSegment;
import org.goplanit.utils.network.layer.physical.UntypedPhysicalLayer;
import org.goplanit.utils.network.layers.MacroscopicNetworkLayers;
import org.goplanit.utils.network.virtual.ConnectoidSegment;
import org.goplanit.utils.path.DirectedPath;
import org.goplanit.utils.path.DirectedPathFactory;
import org.goplanit.utils.time.TimePeriod;
import org.goplanit.utils.zoning.Centroid;
import org.goplanit.utils.zoning.Zone;

public class TraditionalStaticAssignment
extends StaticTrafficAssignment
implements LinkVolumeAccessee {
    private static final long serialVersionUID = -4610905345414397908L;
    private static final Logger LOGGER = Logger.getLogger(TraditionalStaticAssignment.class.getCanonicalName());
    private static final double DEFAULT_FLOW_EPSILON = 1.0E-6;
    private TraditionalStaticAssignmentSimulationData simulationData;
    private MacroscopicNetworkLayerImpl networkLayer;
    private DirectedPathFactory localPathFactory;

    protected String createLoggingPrefix() {
        return super.createLoggingPrefix(this.simulationData.getIterationIndex());
    }

    @Override
    protected void verifyNetworkDemandZoningCompatibility() throws PlanItException {
        PlanItException.throwIf(!(this.getInfrastructureNetwork() instanceof MacroscopicNetwork), "Traditional static assignment is only compatible with macroscopic networks", new Object[0]);
        MacroscopicNetwork macroscopicNetwork = this.getInfrastructureNetwork();
        PlanItException.throwIf(((MacroscopicNetworkLayers)macroscopicNetwork.getTransportLayers()).size() != 1, "Traditional static assignment  is currently only compatible with networks using a single infrastructure layer", new Object[0]);
        MacroscopicNetworkLayer infrastructureLayer = (MacroscopicNetworkLayer)((MacroscopicNetworkLayers)macroscopicNetwork.getTransportLayers()).getFirst();
        if (this.getInfrastructureNetwork().getModes().size() != infrastructureLayer.getSupportedModes().size()) {
            LOGGER.warning("network wide modes do not match modes supported by the single available layer, consider removing unused modes");
        }
        this.networkLayer = (MacroscopicNetworkLayerImpl)infrastructureLayer;
    }

    @Override
    protected void verifyComponentCompatibility() throws PlanItException {
        PlanItException.throwIf(!(this.getGapFunction() instanceof LinkBasedRelativeDualityGapFunction), "Traditional static assignment only supports link based relative duality gap function at the moment, but found %s", this.getGapFunction().getClass().getCanonicalName());
    }

    private void initialiseTimePeriod(TimePeriod timePeriod, Set<Mode> modes) throws PlanItException {
        this.simulationData = new TraditionalStaticAssignmentSimulationData(this.getIdGroupingToken());
        this.simulationData.setIterationIndex(0);
        this.simulationData.getModeSpecificData().clear();
        for (Mode mode : modes) {
            this.simulationData.getModeSpecificData().put(mode, new ModeData(new double[this.getTotalNumberOfNetworkSegments()]));
            double[] modalLinkSegmentCosts = this.initialiseLinkSegmentCosts(mode, timePeriod);
            this.simulationData.setModalLinkSegmentCosts(mode, modalLinkSegmentCosts);
        }
        if (this.localPathFactory == null) {
            this.localPathFactory = new DirectedPathFactoryImpl(this.networkLayer.getLayerIdGroupingToken());
        }
        this.getPhysicalCost().updateTimePeriod(timePeriod);
        this.getVirtualCost().updateTimePeriod(timePeriod);
    }

    private void applySmoothing(Mode mode, ModeData modeData) {
        double[] smoothedSegmentFlows = this.getSmoothing().execute(modeData.getCurrentSegmentFlows(), modeData.getNextSegmentFlows(), this.getTotalNumberOfNetworkSegments());
        modeData.setCurrentSegmentFlows(smoothedSegmentFlows);
        this.simulationData.getModeSpecificData().put(mode, modeData);
    }

    private void executeTimePeriodAndMode(Mode mode, TimePeriod timePeriod, ModeData currentModeData, double[] modalNetworkSegmentCosts) throws PlanItException {
        DijkstraShortestPathAlgorithm shortestPathAlgorithm = new DijkstraShortestPathAlgorithm(modalNetworkSegmentCosts, this.getTotalNumberOfNetworkSegments(), this.getTotalNumberOfNetworkVertices());
        OdDemands odDemands = this.getDemands().get(mode, timePeriod);
        LinkBasedRelativeDualityGapFunction dualityGapFunction = (LinkBasedRelativeDualityGapFunction)this.getGapFunction();
        OdPathMatrix odpathMatrix = this.simulationData.getOdPathMatrix(mode);
        Map<OdSkimSubOutputType, OdSkimMatrix> skimMatrixMap = this.simulationData.getSkimMatrixMap(mode);
        long previousOriginZoneId = -1L;
        ShortestPathResult shortestPathResult = null;
        Iterator odDemandMatrixIter = odDemands.iterator();
        while (odDemandMatrixIter.hasNext()) {
            double odDemand = (Double)odDemandMatrixIter.next();
            Zone currentOriginZone = odDemandMatrixIter.getCurrentOrigin();
            Zone currentDestinationZone = odDemandMatrixIter.getCurrentDestination();
            if (currentOriginZone.getId() == currentDestinationZone.getId() || !this.getOutputManager().getOutputConfiguration().isPersistZeroFlow() && !(odDemand - 1.0E-6 > 0.0)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(LoggingUtils.createRunIdPrefix(this.getId()) + String.format("(O,D)=(%d,%d) --> demand (pcu/h): %f (mode: %d)", currentOriginZone.getExternalId(), currentDestinationZone.getExternalId(), odDemand, mode.getExternalId()));
            }
            if (previousOriginZoneId != currentOriginZone.getId()) {
                Centroid originCentroid = currentOriginZone.getCentroid();
                if (originCentroid.getExitEdgeSegments().isEmpty()) {
                    throw new PlanItException(String.format("edge segments have not been assigned to Centroid for Zone %d", currentOriginZone.getExternalId()));
                }
                shortestPathResult = shortestPathAlgorithm.executeOneToAll(originCentroid);
            }
            if (odDemand - 1.0E-6 > 0.0) {
                double odShortestPathCost = shortestPathResult.getCostToReach(currentDestinationZone.getCentroid());
                if (odShortestPathCost == Double.POSITIVE_INFINITY || odShortestPathCost == Double.MAX_VALUE) {
                    LOGGER.warning(String.format("%s impossible path from origin zone %s (id:%d) to destination zone %s (id:%d) for mode %s (id:%d)", this.createLoggingPrefix(), currentOriginZone.getXmlId(), currentOriginZone.getId(), currentDestinationZone.getXmlId(), currentDestinationZone.getId(), mode.getXmlId(), mode.getId()));
                } else {
                    this.updateNetworkFlowsForPath(shortestPathResult, currentOriginZone, currentDestinationZone, odDemand, currentModeData);
                    dualityGapFunction.increaseConvexityBound(odDemand * odShortestPathCost);
                }
            }
            previousOriginZoneId = currentOriginZone.getId();
            this.updateODOutputData(skimMatrixMap, currentOriginZone, currentDestinationZone, odDemand, shortestPathResult);
            this.updatePathOutputData(mode, odpathMatrix, currentOriginZone, currentDestinationZone, shortestPathResult);
        }
    }

    private void smoothTimePeriodAndMode(Mode mode, TimePeriod timePeriod, ModeData currentModeData, double[] modalNetworkSegmentCosts) {
        double totalModeSystemTravelTime = ArrayUtils.dotProduct(currentModeData.getCurrentSegmentFlows(), modalNetworkSegmentCosts, this.getTotalNumberOfNetworkSegments());
        LinkBasedRelativeDualityGapFunction dualityGapFunction = (LinkBasedRelativeDualityGapFunction)this.getGapFunction();
        dualityGapFunction.increaseMeasuredCost(totalModeSystemTravelTime);
        this.applySmoothing(mode, currentModeData);
    }

    private void executeAndSmoothTimePeriodAndMode(TimePeriod timePeriod, Mode mode) throws PlanItException {
        LOGGER.fine(LoggingUtils.createRunIdPrefix(this.getId()) + String.format("[mode %s (id:%d)]", mode.getExternalId(), mode.getId()));
        double[] modalLinkSegmentCosts = this.simulationData.getModalLinkSegmentCosts(mode);
        ModeData currentModeData = this.simulationData.getModeSpecificData().get(mode);
        currentModeData.resetNextNetworkSegmentFlows();
        this.executeTimePeriodAndMode(mode, timePeriod, currentModeData, modalLinkSegmentCosts);
        this.smoothTimePeriodAndMode(mode, timePeriod, currentModeData, modalLinkSegmentCosts);
    }

    private void updateNetworkFlowsForPath(ShortestPathResult shortestPathResult, Zone origin, Zone destination, double odDemand, ModeData currentModeData) throws PlanItException {
        EdgeSegment currentEdgeSegment = null;
        DirectedVertex currentVertex = destination.getCentroid();
        while (currentVertex.getId() != origin.getCentroid().getId()) {
            currentEdgeSegment = shortestPathResult.getIncomingEdgeSegmentForVertex(currentVertex);
            if (currentEdgeSegment == null) {
                PlanItException.throwIf(currentVertex instanceof Centroid, "The solution could not find an Edge Segment for the connectoid for zone " + currentVertex.getParentZone().getExternalId(), new Object[0]);
            }
            currentModeData.addToNextSegmentFlows(currentEdgeSegment.getId(), odDemand);
            currentVertex = currentEdgeSegment.getUpstreamVertex();
        }
    }

    private void updateODOutputData(Map<OdSkimSubOutputType, OdSkimMatrix> skimMatrixMap, Zone currentOriginZone, Zone currentDestinationZone, double odDemand, ShortestPathResult shortestPathResult) {
        if (this.getOutputManager().isOutputTypeActive(OutputType.OD)) {
            Set<SubOutputTypeEnum> activeSubOutputTypes = ((OdOutputTypeConfiguration)this.getOutputManager().getOutputTypeConfiguration(OutputType.OD)).getActiveSubOutputTypes();
            for (SubOutputTypeEnum odSkimOutputType : activeSubOutputTypes) {
                if (!odSkimOutputType.equals(OdSkimSubOutputType.COST)) continue;
                double odGeneralisedCost = shortestPathResult.getCostToReach(currentDestinationZone.getCentroid());
                OdSkimMatrix odSkimMatrix = skimMatrixMap.get(odSkimOutputType);
                odSkimMatrix.setValue(currentOriginZone, currentDestinationZone, odGeneralisedCost);
            }
        }
    }

    private void updatePathOutputData(Mode mode, OdPathMatrix odpathMatrix, Zone origin, Zone destination, ShortestPathResult shortestPathResult) {
        if (this.getOutputManager().isOutputTypeActive(OutputType.PATH)) {
            DirectedPath path = shortestPathResult.createPath(this.localPathFactory, origin.getCentroid(), destination.getCentroid());
            if (path == null) {
                LOGGER.fine(String.format("Unable to create path from origin %s (id:%d) to destination %s (id:%d) for mode %s (id:%d)", origin.getXmlId(), origin.getId(), destination.getXmlId(), destination.getId(), mode.getXmlId(), mode.getId()));
            }
            odpathMatrix.setValue(origin, destination, path);
        }
    }

    private Calendar logBasicIterationInformation(Calendar startTime, double measuredNetworkCost, double dualityGap) {
        Calendar currentTime = Calendar.getInstance();
        LOGGER.info(this.createLoggingPrefix() + String.format("Network cost: %f", measuredNetworkCost));
        LOGGER.info(this.createLoggingPrefix() + String.format("Gap: %.10f (%d ms)", dualityGap, currentTime.getTimeInMillis() - startTime.getTimeInMillis()));
        return currentTime;
    }

    private void populateModalConnectoidCosts(Mode mode, double[] currentSegmentCosts) throws PlanItException {
        for (ConnectoidSegment currentSegment : this.getTransportNetwork().getVirtualNetwork().getConnectoidSegments()) {
            currentSegmentCosts[(int)currentSegment.getId()] = this.getVirtualCost().getGeneralisedCost(mode, currentSegment);
        }
    }

    private void populateModalLinkSegmentCosts(Mode mode, double[] currentSegmentCosts) throws PlanItException {
        this.getPhysicalCost().populateWithCost((UntypedPhysicalLayer)this.getInfrastructureNetwork().getLayerByMode(mode), mode, currentSegmentCosts);
    }

    private boolean populateToInitialCost(Mode mode, double[] segmentCostToPopulate) throws PlanItException {
        if (this.initialLinkSegmentCostTimePeriodAgnostic == null || !this.initialLinkSegmentCostTimePeriodAgnostic.isSegmentCostsSetForMode(mode)) {
            return false;
        }
        this.populateCost(this.initialLinkSegmentCostTimePeriodAgnostic, mode, segmentCostToPopulate);
        return true;
    }

    private boolean populateToInitialCost(Mode mode, TimePeriod timePeriod, double[] segmentCostToPopulate) throws PlanItException {
        InitialModesLinkSegmentCost initialLinkSegmentCostForTimePeriod = (InitialModesLinkSegmentCost)this.initialLinkSegmentCostByTimePeriod.get(timePeriod);
        if (initialLinkSegmentCostForTimePeriod == null || !initialLinkSegmentCostForTimePeriod.isSegmentCostsSetForMode(mode)) {
            return this.populateToInitialCost(mode, segmentCostToPopulate);
        }
        this.populateCost(initialLinkSegmentCostForTimePeriod, mode, segmentCostToPopulate);
        return true;
    }

    private void populateCost(Cost<MacroscopicLinkSegment> cost, Mode mode, double[] costsToPopulate) throws PlanItException {
        for (MacroscopicLinkSegment linkSegment : this.networkLayer.getLinkSegments()) {
            double currentSegmentCost = cost.getGeneralisedCost(mode, linkSegment);
            if (currentSegmentCost < 0.0) {
                throw new PlanItException(String.format("link segment cost is negative for link segment %d (id: %d)", linkSegment.getExternalId(), linkSegment.getId()));
            }
            costsToPopulate[(int)linkSegment.getId()] = currentSegmentCost;
        }
    }

    private double[] initialiseLinkSegmentCosts(Mode mode, TimePeriod timePeriod) throws PlanItException {
        double[] currentSegmentCosts = new double[this.getTransportNetwork().getNumberOfEdgeSegmentsAllLayers()];
        this.populateModalConnectoidCosts(mode, currentSegmentCosts);
        if (this.populateToInitialCost(mode, timePeriod, currentSegmentCosts)) {
            return currentSegmentCosts;
        }
        this.populateModalLinkSegmentCosts(mode, currentSegmentCosts);
        return currentSegmentCosts;
    }

    private double[] collectModalLinkSegmentCosts(Mode mode, TimePeriod timePeriod) throws PlanItException {
        double[] currentSegmentCosts = new double[this.getTransportNetwork().getNumberOfEdgeSegmentsAllLayers()];
        this.populateModalConnectoidCosts(mode, currentSegmentCosts);
        this.populateModalLinkSegmentCosts(mode, currentSegmentCosts);
        return currentSegmentCosts;
    }

    @Override
    protected void executeTimePeriod(TimePeriod timePeriod, Set<Mode> modes) throws PlanItException {
        this.initialiseTimePeriod(timePeriod, modes);
        LinkBasedRelativeDualityGapFunction dualityGapFunction = (LinkBasedRelativeDualityGapFunction)this.getGapFunction();
        boolean converged = false;
        Calendar iterationStartTime = Calendar.getInstance();
        while (!converged) {
            dualityGapFunction.reset();
            this.getSmoothing().updateStep(this.simulationData.getIterationIndex());
            for (Mode mode : modes) {
                if (this.getOutputManager().isOutputTypeActive(OutputType.OD)) {
                    this.simulationData.resetSkimMatrix(mode, this.getTransportNetwork().getZoning().odZones, (OdOutputTypeConfiguration)this.getOutputManager().getOutputTypeConfiguration(OutputType.OD));
                }
                if (this.getOutputManager().isOutputTypeActive(OutputType.PATH)) {
                    this.simulationData.resetPathMatrix(mode, this.getTransportNetwork().getZoning().odZones);
                }
                this.executeAndSmoothTimePeriodAndMode(timePeriod, mode);
            }
            dualityGapFunction.computeGap();
            this.simulationData.incrementIterationIndex();
            iterationStartTime = this.logBasicIterationInformation(iterationStartTime, dualityGapFunction.getMeasuredNetworkCost(), dualityGapFunction.getGap());
            for (Mode mode : modes) {
                double[] modalLinkSegmentCosts = this.collectModalLinkSegmentCosts(mode, timePeriod);
                this.simulationData.setModalLinkSegmentCosts(mode, modalLinkSegmentCosts);
            }
            converged = dualityGapFunction.hasConverged(this.simulationData.getIterationIndex());
            this.getOutputManager().persistOutputData(timePeriod, modes, converged);
        }
    }

    protected TraditionalStaticAssignmentSimulationData getIterationData() {
        return this.simulationData;
    }

    public TraditionalStaticAssignment(IdGroupingToken groupId) {
        super(groupId);
        this.simulationData = null;
        this.localPathFactory = null;
    }

    public TraditionalStaticAssignment(TraditionalStaticAssignment traditionalStaticAssignment) {
        super(traditionalStaticAssignment);
        this.simulationData = traditionalStaticAssignment.simulationData;
        this.localPathFactory = traditionalStaticAssignment.localPathFactory;
        this.networkLayer = traditionalStaticAssignment.networkLayer;
    }

    public MacroscopicNetwork getInfrastructureNetwork() {
        return (MacroscopicNetwork)super.getInfrastructureNetwork();
    }

    @Override
    public OutputTypeAdapter createOutputTypeAdapter(OutputType outputType) {
        OutputTypeAdapterImpl outputTypeAdapter = null;
        switch (outputType) {
            case LINK: {
                outputTypeAdapter = new TraditionalStaticAssignmentLinkOutputTypeAdapter(outputType, this);
                break;
            }
            case OD: {
                outputTypeAdapter = new TraditionalStaticAssignmentOdOutputTypeAdapter(outputType, this);
                break;
            }
            case PATH: {
                outputTypeAdapter = new TraditionalStaticPathOutputTypeAdapter(outputType, this);
                break;
            }
            default: {
                LOGGER.warning(LoggingUtils.createRunIdPrefix(this.getId()) + outputType.value() + " has not been defined yet.");
            }
        }
        return outputTypeAdapter;
    }

    @Override
    public int getIterationIndex() {
        return this.getIterationData() == null ? 0 : this.getIterationData().getIterationIndex();
    }

    @Override
    public double getLinkSegmentVolume(LinkSegment linkSegment) {
        return this.simulationData.collectTotalNetworkSegmentFlow(linkSegment);
    }

    @Override
    public double[] getLinkSegmentVolumes() {
        return this.simulationData.collectTotalNetworkSegmentFlows();
    }

    @Override
    public TraditionalStaticAssignment clone() {
        return new TraditionalStaticAssignment(this);
    }
}

