/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import org.goplanit.converter.ConverterReader;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.wrapper.MapWrapper;
import org.goplanit.utils.wrapper.MapWrapperImpl;

public abstract class BaseReaderImpl<T>
implements ConverterReader<T> {
    private static final Logger LOGGER = Logger.getLogger(BaseReaderImpl.class.getCanonicalName());
    protected final Map<Class<?>, MapWrapper<?, ?>> sourceIdTrackerMap = new HashMap();

    protected <V> void registerBySourceId(V obj) throws PlanItException {
        this.registerBySourceId(obj.getClass(), obj);
    }

    protected <U, V> void registerBySourceId(Class<U> theClazz, V obj) throws PlanItException {
        MapWrapper<?, ?> mapWrapper = this.sourceIdTrackerMap.get(theClazz);
        if (mapWrapper == null) {
            throw new PlanItException("No source id container registered for PLANit entity of type %s, unable to register, perhaps consider registering via its superclass explicitly", obj.getClass().getName());
        }
        if (mapWrapper.contains(obj)) {
            throw new PlanItException("PLANit entity of type %s already registered by its source id %s, unable to register", obj.getClass().getName(), mapWrapper.getKeyByValue(obj).toString());
        }
        mapWrapper.register(obj);
    }

    protected <K, V> void initialiseSourceIdMap(Class<V> clazz, Function<V, K> valueToKey) {
        if (this.sourceIdTrackerMap.containsKey(clazz)) {
            LOGGER.warning(String.format("Unable to register PLANit entity sourceId tracker for %s, already present", clazz.getName()));
        }
        this.sourceIdTrackerMap.put(clazz, new MapWrapperImpl(new HashMap(), valueToKey));
    }

    protected <K, V> void initialiseSourceIdMap(Class<V> clazz, Function<V, K> valueToKey, Iterable<V> addToSourceIdMap) {
        this.initialiseSourceIdMap(clazz, valueToKey);
        this.getSourceIdContainer(clazz).addAll(addToSourceIdMap);
    }

    protected <V> MapWrapper<?, V> getSourceIdContainer(Class<V> clazz) {
        return this.sourceIdTrackerMap.get(clazz);
    }

    protected <V, K> V getBySourceId(Class<V> clazz, K key) {
        return (V)this.sourceIdTrackerMap.get(clazz).get(key);
    }

    protected BaseReaderImpl() {
    }
}

