/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.converter;

import java.util.logging.Logger;
import org.goplanit.converter.ConverterBase;
import org.goplanit.converter.ConverterReader;
import org.goplanit.converter.ConverterWriter;
import org.goplanit.utils.exceptions.PlanItException;

public abstract class Converter<T>
extends ConverterBase {
    private static final Logger LOGGER = Logger.getLogger(Converter.class.getCanonicalName());

    protected Converter(ConverterReader<T> reader, ConverterWriter<T> writer) {
        super(reader, writer);
    }

    @Override
    public void convert() throws PlanItException {
        ConverterReader reader = (ConverterReader)this.getReader();
        LOGGER.info(String.format("****************** [START] CONVERTER: READ %s [START] ********************", reader.getTypeDescription()));
        Object network = reader.read();
        reader.reset();
        LOGGER.info(String.format("****************** [END]   CONVERTER: READ %s [END]   ********************", reader.getTypeDescription()));
        ConverterWriter writer = (ConverterWriter)this.getWriter();
        LOGGER.info(String.format("****************** [START] NETWORK CONVERTER: WRITE %s [START] ********************", writer.getTypeDescription()));
        writer.write(network);
        writer.reset();
        LOGGER.info(String.format("****************** [END]   NETWORK CONVERTER: WRITE %s [END]   ********************", writer.getTypeDescription()));
    }
}

