/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph.directed.acyclic;

import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Logger;
import org.goplanit.graph.directed.acyclic.ACyclicSubGraph;
import org.goplanit.graph.directed.acyclic.AcyclicVertexData;
import org.goplanit.utils.graph.EdgeSegment;
import org.goplanit.utils.graph.directed.DirectedVertex;
import org.goplanit.utils.id.IdGenerator;
import org.goplanit.utils.id.IdGroupingToken;

public class ACyclicSubGraphImpl
implements ACyclicSubGraph {
    private static final Logger LOGGER = Logger.getLogger(ACyclicSubGraphImpl.class.getCanonicalName());
    private final long id;
    DirectedVertex root;
    private Map<DirectedVertex, AcyclicVertexData> vertexData;
    private ArrayDeque<DirectedVertex> topologicalOrder;
    private BitSet registeredLinkSegments;

    private void resetVertexData() {
        for (AcyclicVertexData vertexData : this.vertexData.values()) {
            vertexData.postVisitIndex = 0L;
            vertexData.preVisitIndex = 0L;
        }
    }

    private void removeVertexData(DirectedVertex vertex) {
        this.vertexData.remove(vertex);
    }

    private boolean isConnectedToAnySubgraphEdgeSegment(DirectedVertex vertex) {
        for (EdgeSegment edgeSegment : vertex.getExitEdgeSegments()) {
            if (!this.containsEdgeSegment(edgeSegment)) continue;
            return true;
        }
        for (EdgeSegment edgeSegment : vertex.getEntryEdgeSegments()) {
            if (!this.containsEdgeSegment(edgeSegment)) continue;
            return true;
        }
        return false;
    }

    private boolean traverseRecursively(DirectedVertex vertex, BitSet visited, LongAdder counter, Deque<DirectedVertex> topologicalOrder) {
        visited.set((int)vertex.getId());
        AcyclicVertexData vertexData = this.getVertexData(vertex);
        this.preVisit(vertexData, counter);
        boolean isAcyclic = true;
        for (EdgeSegment exitEdgeSegment : vertex.getExitEdgeSegments()) {
            if (!this.containsEdgeSegment(exitEdgeSegment)) continue;
            DirectedVertex downstreamVertex = exitEdgeSegment.getDownstreamVertex();
            AcyclicVertexData downstreamVertexData = this.getVertexData(downstreamVertex);
            if (downstreamVertexData.preVisitIndex == 0L) {
                isAcyclic = this.traverseRecursively(downstreamVertex, visited, counter, topologicalOrder);
            } else if (downstreamVertexData.postVisitIndex == 0L) {
                isAcyclic = false;
                LOGGER.warning(String.format("Cycle detected in supposed acyclic graph at vertex %s, terminating", downstreamVertex.getXmlId()));
            }
            if (isAcyclic) continue;
            return isAcyclic;
        }
        this.postVisit(vertexData, counter);
        topologicalOrder.push(vertex);
        return isAcyclic;
    }

    protected void postVisit(AcyclicVertexData vertexData, LongAdder counter) {
        vertexData.postVisitIndex = counter.intValue();
        counter.increment();
    }

    protected void preVisit(AcyclicVertexData vertexData, LongAdder counter) {
        vertexData.preVisitIndex = counter.intValue();
        counter.increment();
    }

    protected AcyclicVertexData getVertexData(DirectedVertex vertex) {
        return this.vertexData.get(vertex);
    }

    public ACyclicSubGraphImpl(IdGroupingToken groupId, int numberOfParentEdgeSegments, DirectedVertex root) {
        this.id = IdGenerator.generateId(groupId, ACyclicSubGraph.class);
        this.root = root;
        this.vertexData = new HashMap<DirectedVertex, AcyclicVertexData>();
        this.registeredLinkSegments = new BitSet(numberOfParentEdgeSegments);
        this.topologicalOrder = null;
    }

    public ACyclicSubGraphImpl(ACyclicSubGraphImpl aCyclicSubGraphImpl) {
        this.id = aCyclicSubGraphImpl.getId();
        this.root = aCyclicSubGraphImpl.getRootVertex();
        this.registeredLinkSegments = BitSet.valueOf(aCyclicSubGraphImpl.registeredLinkSegments.toByteArray());
        this.vertexData = new HashMap<DirectedVertex, AcyclicVertexData>();
        aCyclicSubGraphImpl.vertexData.forEach((? super K v, ? super V d) -> this.vertexData.put((DirectedVertex)v, d.clone()));
        this.topologicalOrder = aCyclicSubGraphImpl.topologicalOrder != null ? new ArrayDeque<DirectedVertex>(aCyclicSubGraphImpl.topologicalOrder) : null;
    }

    @Override
    public Collection<DirectedVertex> topologicalSort(boolean update) {
        if (!update && this.topologicalOrder != null && !this.topologicalOrder.isEmpty()) {
            return this.topologicalOrder;
        }
        this.topologicalOrder = new ArrayDeque(this.vertexData.size());
        this.resetVertexData();
        BitSet visited = new BitSet(this.vertexData.size());
        LongAdder counter = new LongAdder();
        counter.increment();
        boolean isAcyclic = this.traverseRecursively(this.root, visited, counter, this.topologicalOrder);
        if (!isAcyclic) {
            return null;
        }
        for (Map.Entry<DirectedVertex, AcyclicVertexData> vertexEntry : this.vertexData.entrySet()) {
            if (visited.get((int)vertexEntry.getKey().getId())) continue;
            LOGGER.warning(String.format("Topological sort applied, but some vertices not connected to the root (%s) of the acyclic graph (%d), unable to determine sorting order", this.root.getXmlId(), this.getId()));
            return null;
        }
        return this.topologicalOrder;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public DirectedVertex getRootVertex() {
        return this.root;
    }

    @Override
    public void addEdgeSegment(EdgeSegment edgeSegment) {
        this.registeredLinkSegments.set((int)edgeSegment.getId());
        if (!this.vertexData.containsKey(edgeSegment.getUpstreamVertex())) {
            this.vertexData.put(edgeSegment.getUpstreamVertex(), new AcyclicVertexData());
        }
        if (!this.vertexData.containsKey(edgeSegment.getDownstreamVertex())) {
            this.vertexData.put(edgeSegment.getDownstreamVertex(), new AcyclicVertexData());
        }
    }

    @Override
    public boolean containsEdgeSegment(EdgeSegment edgeSegment) {
        return this.registeredLinkSegments.get((int)edgeSegment.getId());
    }

    @Override
    public long getNumberOfVertices() {
        return this.vertexData.size();
    }

    @Override
    public Iterator<DirectedVertex> iterator() {
        return Collections.unmodifiableSet(this.vertexData.keySet()).iterator();
    }

    @Override
    public void removeEdgeSegment(EdgeSegment edgeSegment) {
        this.registeredLinkSegments.set((int)edgeSegment.getId(), false);
        if (!this.isConnectedToAnySubgraphEdgeSegment(edgeSegment.getDownstreamVertex())) {
            this.removeVertexData(edgeSegment.getDownstreamVertex());
        }
        if (!this.isConnectedToAnySubgraphEdgeSegment(edgeSegment.getUpstreamVertex())) {
            this.removeVertexData(edgeSegment.getUpstreamVertex());
        }
    }

    @Override
    public ACyclicSubGraphImpl clone() {
        return new ACyclicSubGraphImpl(this);
    }
}

