/*
 * Decompiled with CFR 0.152.
 */
package org.goplanit.graph.modifier;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Logger;
import org.goplanit.graph.modifier.event.BreakEdgeEvent;
import org.goplanit.graph.modifier.event.RemoveSubGraphEdgeEvent;
import org.goplanit.graph.modifier.event.RemoveSubGraphEvent;
import org.goplanit.graph.modifier.event.RemoveSubGraphVertexEvent;
import org.goplanit.utils.event.Event;
import org.goplanit.utils.event.EventListener;
import org.goplanit.utils.event.EventProducerImpl;
import org.goplanit.utils.exceptions.PlanItException;
import org.goplanit.utils.geo.PlanitJtsCrsUtils;
import org.goplanit.utils.geo.PlanitJtsUtils;
import org.goplanit.utils.graph.Edge;
import org.goplanit.utils.graph.UntypedGraph;
import org.goplanit.utils.graph.Vertex;
import org.goplanit.utils.graph.modifier.GraphModifier;
import org.goplanit.utils.graph.modifier.event.GraphModificationEvent;
import org.goplanit.utils.graph.modifier.event.GraphModifierEventType;
import org.goplanit.utils.graph.modifier.event.GraphModifierListener;
import org.goplanit.utils.id.ManagedIdEntities;
import org.locationtech.jts.geom.LineString;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GraphModifierImpl
extends EventProducerImpl
implements GraphModifier<Vertex, Edge> {
    private static final Logger LOGGER = Logger.getLogger(GraphModifierImpl.class.getCanonicalName());
    protected final UntypedGraph<?, ?> theGraph;

    protected static void updateBrokenEdgeGeometry(Edge brokenEdge, Vertex vertexBrokenAt) throws PlanItException {
        LineString updatedGeometry = null;
        if (brokenEdge.getVertexA().equals(vertexBrokenAt)) {
            updatedGeometry = PlanitJtsUtils.createCopyWithoutCoordinatesBefore(vertexBrokenAt.getPosition(), brokenEdge.getGeometry());
        } else if (brokenEdge.getVertexB().equals(vertexBrokenAt)) {
            updatedGeometry = PlanitJtsUtils.createCopyWithoutCoordinatesAfter(vertexBrokenAt.getPosition(), brokenEdge.getGeometry());
        } else {
            LOGGER.warning(String.format("unable to locate vertex to break at (%s) for broken edge %s (id:%d)", vertexBrokenAt.getPosition().toString(), brokenEdge.getExternalId(), brokenEdge.getId()));
        }
        brokenEdge.setGeometry(updatedGeometry);
    }

    protected Set<Vertex> processSubNetworkVertex(Vertex referenceVertex) throws PlanItException {
        PlanItException.throwIfNull(referenceVertex, "provided reference vertex is null when identifying its subnetwork, thisis not allowed");
        HashSet<Vertex> subNetworkVertices = new HashSet<Vertex>();
        subNetworkVertices.add(referenceVertex);
        HashSet<Vertex> verticesToExplore = new HashSet<Vertex>();
        verticesToExplore.add(referenceVertex);
        Iterator vertexIter = verticesToExplore.iterator();
        while (vertexIter.hasNext()) {
            Vertex currVertex = (Vertex)vertexIter.next();
            vertexIter.remove();
            Collection<Edge> edgesOfCurrVertex = currVertex.getEdges();
            for (Edge currEdge : edgesOfCurrVertex) {
                if (currEdge.getVertexA() != null && currEdge.getVertexA().getId() != currVertex.getId() && !subNetworkVertices.contains(currEdge.getVertexA())) {
                    subNetworkVertices.add(currEdge.getVertexA());
                    verticesToExplore.add(currEdge.getVertexA());
                    continue;
                }
                if (currEdge.getVertexB() == null || currEdge.getVertexB().getId() == currVertex.getId() || subNetworkVertices.contains(currEdge.getVertexB())) continue;
                subNetworkVertices.add(currEdge.getVertexB());
                verticesToExplore.add(currEdge.getVertexB());
            }
            vertexIter = verticesToExplore.iterator();
        }
        return subNetworkVertices;
    }

    @Override
    protected void fireEvent(EventListener eventListener, Event event) {
        ((GraphModifierListener)GraphModifierListener.class.cast(eventListener)).onGraphModificationEvent((GraphModificationEvent)GraphModificationEvent.class.cast(event));
    }

    public GraphModifierImpl(UntypedGraph<?, ?> theGraph) {
        this.theGraph = theGraph;
    }

    @Override
    public void removeDanglingSubGraphs(Integer belowSize, Integer aboveSize, boolean alwaysKeepLargest) throws PlanItException {
        HashMap<Integer, LongAdder> removedDanglingNetworksBySize = new HashMap<Integer, LongAdder>();
        HashSet remainingVertices = new HashSet(this.theGraph.getVertices().size());
        this.theGraph.getVertices().forEach(vertex -> remainingVertices.add(vertex));
        HashMap<Vertex, Integer> identifiedSubNetworkSizes = new HashMap<Vertex, Integer>();
        while (remainingVertices.iterator().hasNext()) {
            Vertex referenceVertex = (Vertex)remainingVertices.iterator().next();
            Set<Vertex> subNetworkVerticesToPopulate = this.processSubNetworkVertex(referenceVertex);
            identifiedSubNetworkSizes.put(referenceVertex, subNetworkVerticesToPopulate.size());
            remainingVertices.removeAll(subNetworkVerticesToPopulate);
        }
        if (!identifiedSubNetworkSizes.isEmpty()) {
            int maxSubNetworkSize = (Integer)Collections.max(identifiedSubNetworkSizes.values());
            LOGGER.fine(String.format("remaining vertices %d, edges %d", this.theGraph.getVertices().size(), this.theGraph.getEdges().size()));
            for (Map.Entry entry : identifiedSubNetworkSizes.entrySet()) {
                int subNetworkSize = (Integer)entry.getValue();
                if (subNetworkSize >= maxSubNetworkSize && alwaysKeepLargest || subNetworkSize >= belowSize && subNetworkSize <= aboveSize) continue;
                removedDanglingNetworksBySize.putIfAbsent(subNetworkSize, new LongAdder());
                ((LongAdder)removedDanglingNetworksBySize.get(subNetworkSize)).increment();
                LOGGER.fine(String.format("removing %d vertices from graph", subNetworkSize));
                LOGGER.fine(String.format("remaining vertices %d, edges %d", this.theGraph.getVertices().size(), this.theGraph.getEdges().size()));
            }
            LongAdder totalCount = new LongAdder();
            removedDanglingNetworksBySize.forEach((size, count) -> {
                LOGGER.fine(String.format("sub graph size %d - %d removed", size, count.longValue()));
                totalCount.add(count.longValue());
            });
            LOGGER.fine(String.format("removed %d dangling sub graphs", totalCount.longValue()));
        } else {
            LOGGER.warning("no networks identified, unable to remove dangling subnetworks");
        }
    }

    @Override
    public void removeSubGraph(Set<? extends Vertex> subGraphToRemove) {
        for (Vertex vertex : subGraphToRemove) {
            HashSet<Edge> vertexEdges = new HashSet<Edge>(vertex.getEdges());
            for (Edge edge : vertexEdges) {
                vertex.removeEdge(edge);
            }
            for (Edge edge : vertexEdges) {
                edge.removeVertex(vertex);
            }
            this.theGraph.getVertices().remove(vertex.getId());
            if (this.hasListener(RemoveSubGraphVertexEvent.EVENT_TYPE)) {
                this.fireEvent(new RemoveSubGraphVertexEvent(this, vertex));
            }
            for (Edge edge : vertexEdges) {
                this.theGraph.getEdges().remove(edge.getId());
                if (!this.hasListener(RemoveSubGraphEdgeEvent.EVENT_TYPE)) continue;
                this.fireEvent(new RemoveSubGraphEdgeEvent(this, edge));
            }
            if (!this.hasListener(RemoveSubGraphEvent.EVENT_TYPE)) continue;
            this.fireEvent(new RemoveSubGraphEvent(this));
        }
    }

    @Override
    public void removeSubGraphOf(Vertex referenceVertex) throws PlanItException {
        Set<Vertex> subNetworkNodesToRemove = this.processSubNetworkVertex(referenceVertex);
        this.removeSubGraph((Set<? extends Vertex>)subNetworkNodesToRemove);
    }

    @Override
    public <Ex extends Edge> Map<Long, Set<Ex>> breakEdgesAt(List<Ex> edgesToBreak, Vertex vertexToBreakAt, CoordinateReferenceSystem crs) throws PlanItException {
        PlanitJtsCrsUtils geoUtils = new PlanitJtsCrsUtils(crs);
        HashMap<Long, Set<Ex>> affectedEdges = new HashMap<Long, Set<Ex>>();
        for (Edge edgeToBreak : edgesToBreak) {
            affectedEdges.putIfAbsent(edgeToBreak.getId(), new HashSet());
            Set affectedEdgesOfEdgeToBreak = (Set)affectedEdges.get(edgeToBreak.getId());
            Edge breakToB = this.breakEdgeAt(vertexToBreakAt, edgeToBreak, geoUtils);
            if (breakToB == null) continue;
            Edge aToBreak = edgeToBreak;
            affectedEdgesOfEdgeToBreak.add(aToBreak);
            affectedEdgesOfEdgeToBreak.add(breakToB);
        }
        return affectedEdges;
    }

    @Override
    public <Ex extends Edge> Ex breakEdgeAt(Vertex vertexToBreakAt, Ex edgeToBreak, PlanitJtsCrsUtils geoUtils) throws PlanItException {
        Ex aToBreak = edgeToBreak;
        Edge breakToB = (Edge)this.theGraph.getEdges().getFactory().createUniqueCopyOf(edgeToBreak);
        this.theGraph.getEdges().register(breakToB);
        if (edgeToBreak.getVertexA() == null || edgeToBreak.getVertexB() == null) {
            LOGGER.severe(String.format("unable to break edge since edge to break %s (id:%d) is missing one or more vertices", edgeToBreak.getExternalId(), edgeToBreak.getId()));
            return null;
        }
        Vertex oldVertexB = edgeToBreak.getVertexB();
        Vertex oldVertexA = edgeToBreak.getVertexA();
        aToBreak.replace(oldVertexB, vertexToBreakAt);
        breakToB.replace(oldVertexA, vertexToBreakAt);
        oldVertexB.replace(edgeToBreak, breakToB, true);
        oldVertexA.replace(edgeToBreak, aToBreak, true);
        vertexToBreakAt.addEdge(aToBreak);
        vertexToBreakAt.addEdge(breakToB);
        for (Edge brokenEdge : Set.of(aToBreak, breakToB)) {
            GraphModifierImpl.updateBrokenEdgeGeometry(brokenEdge, vertexToBreakAt);
            brokenEdge.setLengthKm(geoUtils.getDistanceInKilometres(brokenEdge.getGeometry()));
        }
        if (this.hasListener(BreakEdgeEvent.EVENT_TYPE)) {
            this.fireEvent(new BreakEdgeEvent(this, vertexToBreakAt, aToBreak, breakToB));
        }
        return (Ex)breakToB;
    }

    @Override
    public void recreateManagedEntitiesIds() {
        if (this.theGraph.getEdges() instanceof ManagedIdEntities) {
            ((ManagedIdEntities)((Object)this.theGraph.getEdges())).recreateIds();
        }
        if (this.theGraph.getVertices() instanceof ManagedIdEntities) {
            ((ManagedIdEntities)((Object)this.theGraph.getVertices())).recreateIds();
        }
    }

    @Override
    public void reset() {
        super.removeAllListeners();
    }

    @Override
    public void addListener(GraphModifierListener listener) {
        super.addListener(listener);
    }

    @Override
    public void addListener(GraphModifierListener listener, GraphModifierEventType eventType) {
        super.addListener((EventListener)listener, eventType);
    }

    @Override
    public void removeListener(GraphModifierListener listener, GraphModifierEventType eventType) {
        super.removeListener(listener, eventType);
    }

    @Override
    public void removeListener(GraphModifierListener listener) {
        super.removeListener(listener);
    }
}

